/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlSubqueryUtils;
import com.intellij.util.CommonProcessors;
import com.intellij.util.MergeQuery;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SqlCteInplaceIntroducer
extends AbstractInplaceIntroducer<SqlAsExpression, PsiElement> {
    private final SqlExpression myInnerExpr;
    private SqlAsExpression myId;
    private boolean myDeleteSelf;
    private final PsiElement myContext;

    SqlCteInplaceIntroducer(Project project, Editor editor2, @NotNull SqlExpression subquery, @NotNull PsiElement context, FileType fileType) {
        if (subquery == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(1);
        }
        super(project, editor2, (PsiElement)SqlSubqueryUtils.expandedToAlias(subquery), null, new PsiElement[]{SqlSubqueryUtils.expandedToAlias(subquery)}, SqlBundle.message((String)"command.name.introduce.cte", (Object[])new Object[0]), fileType);
        this.myInnerExpr = subquery;
        this.myContext = context;
    }

    public PsiElement restoreExpression(@NotNull PsiFile containingFile, @NotNull SqlAsExpression variable, @NotNull RangeMarker marker, String exprText) {
        if (containingFile == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(2);
        }
        if (variable == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(3);
        }
        if (marker == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(4);
        }
        PsiElement start2 = containingFile.findElementAt(marker.getStartOffset());
        PsiElement end = containingFile.findElementAt(marker.getEndOffset() - 1);
        if (start2 == null || end == null) {
            return null;
        }
        return PsiTreeUtil.findCommonParent((PsiElement)start2, (PsiElement)end);
    }

    protected String getActionName() {
        return "Introduce CTE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected SqlAsExpression createFieldToStartTemplateOn(boolean replaceAll, String @NotNull [] names) {
        if (names == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(5);
        }
        this.myId = SqlCteInplaceIntroducer.doCreateFieldToStartTemplateOn(this.myContext, this.myInnerExpr);
        if (this.myId == null) {
            return null;
        }
        SmartPsiElementPointer smartId = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)this.myId);
        try {
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
            if (smartId.getElement() != null) {
                this.restoreState((SqlAsExpression)smartId.getElement());
            }
            this.myId = (SqlAsExpression)smartId.getElement();
        }
        finally {
            this.myDeleteSelf = true;
            SmartPointerManager.getInstance((Project)this.myProject).removePointer(smartId);
        }
        this.myEditor.getCaretModel().moveToOffset(this.myId.getTextRange().getStartOffset());
        return this.myId;
    }

    @Nullable
    public static SqlAsExpression doCreateFieldToStartTemplateOn(@NotNull PsiElement context, @NotNull SqlExpression innerExpr) {
        if (context == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(6);
        }
        if (innerExpr == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(7);
        }
        Project project = context.getProject();
        Language language = context.getContainingFile().getLanguage();
        assert (language instanceof SqlLanguageDialect) : "Expected an instance of SqlLanguageDialect but got: " + String.valueOf(language.getClass());
        SqlLanguageDialect dialect = (SqlLanguageDialect)language;
        StringBuilder out = new StringBuilder();
        DdlBuilder builder = new DdlBuilder(out);
        builder.applyCodeStyle(context.getProject(), dialect);
        SqlWithClause with = SqlSubqueryUtils.extractWithClause(context);
        List allExpressions = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)with, SqlExpression.class);
        int parent = -1;
        for (int i2 = 0; i2 < allExpressions.size(); ++i2) {
            SqlExpression expression = (SqlExpression)allExpressions.get(i2);
            if (!PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)innerExpr, (boolean)true)) continue;
            parent = i2;
            break;
        }
        String prepend = with == null || parent == 0 ? "" : (parent == -1 ? with.getText() : allExpressions.stream().limit(parent).map(e -> e.getText()).collect(Collectors.joining(", ")));
        String append2 = with == null || parent == -1 ? "" : allExpressions.stream().skip(parent).map(e -> e.getText()).collect(Collectors.joining(", "));
        boolean noPrepend = StringUtil.isEmptyOrSpaces((String)prepend);
        if (noPrepend || !StringUtil.startsWithIgnoreCase((String)prepend.trim(), (String)"with")) {
            builder.keyword("with").space();
        }
        if (!noPrepend) {
            builder.plain(prepend).symbol(",").space();
        }
        String aliasName = null;
        SqlColumnAliasListImpl columnAliasList = null;
        PsiElement enclosingElement = SqlImplUtil.sqlParent((PsiElement)SqlSubqueryUtils.expanded(innerExpr));
        if (enclosingElement instanceof SqlAsExpression) {
            aliasName = ((SqlAsExpression)enclosingElement).getNameElement().getName();
            columnAliasList = (SqlColumnAliasListImpl)PsiTreeUtil.getChildOfType((PsiElement)enclosingElement, SqlColumnAliasListImpl.class);
        }
        if (aliasName == null) {
            aliasName = SqlNamesGenerator.suggestAliasName(innerExpr);
        }
        int idPos = builder.length();
        builder.identifier(aliasName);
        if (columnAliasList != null) {
            builder.plain(columnAliasList.getText());
        }
        builder.space().keyword("as").space().symbol("(").plain(innerExpr.getText()).symbol(")");
        if (!StringUtil.isEmptyOrSpaces((String)append2)) {
            builder.symbol(",").space().plain(append2);
        }
        builder.newLine().plain("SELECT * from aaa");
        SqlSelectStatement select = (SqlSelectStatement)PsiTreeUtil.findChildOfType((PsiElement)SqlPsiElementFactory.createStatementFromText(out.toString(), SqlImplUtil.getSqlDialectSafe(context), project, context), SqlSelectStatement.class, (boolean)false);
        assert (select != null);
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)select.getQueryExpression(), SqlWithQueryExpression.class);
        assert (withEx != null);
        SqlWithClause newWith = withEx.getWithClause();
        if (with != null) {
            with = (SqlWithClause)with.replace((PsiElement)newWith);
        } else {
            SqlExpression q = withEx.getExpression();
            with = (SqlWithClause)context.addRangeBefore((PsiElement)withEx.getWithClause(), (PsiElement)(q != null ? q.getPrevSibling() : withEx.getWithClause()), context.getFirstChild());
        }
        return (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)with.findElementAt(idPos), SqlAsExpression.class);
    }

    protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
        if (!(this.myExpr instanceof SqlAsExpression)) {
            return super.collectRefs(referencesSearchScope);
        }
        Query searchExtracted = ReferencesSearch.search((PsiElement)this.myElementToRename, (SearchScope)referencesSearchScope, (boolean)false);
        Query searchOriginal = ReferencesSearch.search((PsiElement)this.myExpr, (SearchScope)referencesSearchScope, (boolean)false);
        MergeQuery query = new MergeQuery(searchExtracted, searchOriginal);
        CommonProcessors.CollectProcessor<PsiReference> processor2 = new CommonProcessors.CollectProcessor<PsiReference>(){

            protected boolean accept(PsiReference reference) {
                return SqlCteInplaceIntroducer.this.acceptReference(reference);
            }
        };
        query.forEach((Processor)processor2);
        return processor2.getResults();
    }

    protected boolean acceptReference(PsiReference reference) {
        PsiElement element = reference.getElement();
        return element != this.myExpr && element != this.myElementToRename;
    }

    protected void addReferenceAtCaret(Collection<? super PsiReference> refs) {
    }

    protected void deleteTemplateField(SqlAsExpression variable) {
        if (!this.myDeleteSelf) {
            return;
        }
        super.deleteTemplateField((PsiNameIdentifierOwner)variable);
    }

    protected int getCaretOffset() {
        PsiElement identifier;
        if (this.myId != null && (identifier = this.myId.getNameIdentifier()) != null) {
            return identifier.getTextOffset();
        }
        return super.getCaretOffset();
    }

    protected String @NotNull [] suggestNames(boolean replaceAll, @Nullable SqlAsExpression variable) {
        return new String[0];
    }

    protected void performIntroduce() {
    }

    public boolean isReplaceAllOccurrences() {
        return false;
    }

    public void setReplaceAllOccurrences(boolean allOccurrences) {
    }

    protected JComponent getComponent() {
        return null;
    }

    protected void saveSettings(@NotNull SqlAsExpression variable) {
        if (variable == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(8);
        }
    }

    protected SqlAsExpression getVariable() {
        return this.myId;
    }

    protected void restoreState(@NotNull SqlAsExpression psiField) {
        if (psiField == null) {
            SqlCteInplaceIntroducer.$$$reportNull$$$0(9);
        }
        if (this.myDeleteSelf) {
            return;
        }
        super.restoreState((PsiNameIdentifierOwner)psiField);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subquery";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerExpr";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/refactoring/SqlCteInplaceIntroducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createFieldToStartTemplateOn";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doCreateFieldToStartTemplateOn";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "saveSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

