/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.ignore;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.ignore.FileGroupInfo;
import org.jetbrains.idea.svn.ignore.SvnPropertyService;

public class IgnoreGroupHelperAction {
    private static final Key<Optional<IgnoreGroupHelperAction>> KEY = Key.create((String)"IgnoreGroupHelperAction");
    private final FileGroupInfo myFileGroupInfo = new FileGroupInfo();
    private boolean myAllCanBeIgnored = true;
    private boolean myAllAreIgnored = true;
    private final Ref<Boolean> myIgnoreFilesOk = new Ref((Object)Boolean.FALSE);
    private final Ref<Boolean> myIgnoreExtensionOk = new Ref((Object)Boolean.FALSE);

    private IgnoreGroupHelperAction() {
    }

    @Nullable
    public static IgnoreGroupHelperAction createFor(@NotNull AnActionEvent e) {
        if (e == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(0);
        }
        UpdateSession session = e.getUpdateSession();
        Optional helper = (Optional)session.sharedData(KEY, () -> IgnoreGroupHelperAction.tryCreateFor(e));
        return helper.orElse(null);
    }

    @NotNull
    private static Optional<IgnoreGroupHelperAction> tryCreateFor(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(1);
        }
        SvnVcs vcs = (project = e.getProject()) != null ? SvnVcs.getInstance(project) : null;
        Object[] files = IgnoreGroupHelperAction.getSelectedFiles(e);
        if (project == null || vcs == null || ArrayUtil.isEmpty((Object[])files)) {
            Optional<IgnoreGroupHelperAction> optional = Optional.empty();
            if (optional == null) {
                IgnoreGroupHelperAction.$$$reportNull$$$0(2);
            }
            return optional;
        }
        IgnoreGroupHelperAction helper = new IgnoreGroupHelperAction();
        if (!helper.checkEnabled(vcs, (VirtualFile[])files)) {
            Optional<IgnoreGroupHelperAction> optional = Optional.empty();
            if (optional == null) {
                IgnoreGroupHelperAction.$$$reportNull$$$0(3);
            }
            return optional;
        }
        helper.checkIgnoreProperty(vcs);
        Optional<IgnoreGroupHelperAction> optional = Optional.of(helper);
        if (optional == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(4);
        }
        return optional;
    }

    public static VirtualFile @Nullable [] getSelectedFiles(@NotNull AnActionEvent e) {
        Iterable exactlySelectedFiles;
        if (e == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(5);
        }
        if (e.getPlace().equals("ChangesViewPopup") && (exactlySelectedFiles = (Iterable)e.getData(ChangesListView.EXACTLY_SELECTED_FILES_DATA_KEY)) != null) {
            return (VirtualFile[])JBIterable.from((Iterable)exactlySelectedFiles).toList().toArray(VirtualFile[]::new);
        }
        return (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
    }

    private boolean checkEnabled(@NotNull SvnVcs vcs, VirtualFile @NotNull [] files) {
        if (vcs == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(6);
        }
        if (files == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(7);
        }
        return ProjectLevelVcsManager.getInstance((Project)vcs.getProject()).checkAllFilesAreUnder((AbstractVcs)vcs, files) && ContainerUtil.and((Object[])files, file -> this.isEnabled(vcs, (VirtualFile)file));
    }

    private void checkIgnoreProperty(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(8);
        }
        if (this.myAllAreIgnored) {
            SvnPropertyService.doCheckIgnoreProperty(vcs, null, this.myFileGroupInfo, this.myFileGroupInfo.getExtensionMask(), this.myIgnoreFilesOk, this.myIgnoreExtensionOk);
        }
    }

    private boolean isEnabledImpl(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        VirtualFile parent;
        if (vcs == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(9);
        }
        if (file == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(10);
        }
        if (IgnoreGroupHelperAction.isIgnored(vcs, file)) {
            this.myAllCanBeIgnored = false;
            return this.myAllAreIgnored;
        }
        if (IgnoreGroupHelperAction.isUnversioned(vcs, file) && (parent = file.getParent()) != null && SvnStatusUtil.isUnderControl(vcs, parent)) {
            this.myAllAreIgnored = false;
            return this.myAllCanBeIgnored;
        }
        this.myAllCanBeIgnored = false;
        this.myAllAreIgnored = false;
        return false;
    }

    private boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        boolean result;
        if (vcs == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(11);
        }
        if (file == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(12);
        }
        if (result = this.isEnabledImpl(vcs, file)) {
            this.myFileGroupInfo.onFileEnabled(file);
        }
        return result;
    }

    public boolean allCanBeIgnored() {
        return this.myAllCanBeIgnored;
    }

    public boolean allAreIgnored() {
        return this.myAllAreIgnored;
    }

    @NotNull
    public FileGroupInfo getFileGroupInfo() {
        FileGroupInfo fileGroupInfo = this.myFileGroupInfo;
        if (fileGroupInfo == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(13);
        }
        return fileGroupInfo;
    }

    public boolean areIgnoreFilesOk() {
        return this.myAllAreIgnored && Boolean.TRUE.equals(this.myIgnoreFilesOk.get());
    }

    public boolean areIgnoreExtensionOk() {
        return this.myAllAreIgnored && Boolean.TRUE.equals(this.myIgnoreExtensionOk.get());
    }

    public static boolean isIgnored(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(14);
        }
        if (file == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(15);
        }
        return SvnStatusUtil.isIgnoredInAnySense(vcs.getProject(), file);
    }

    public static boolean isUnversioned(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        VirtualFile parent;
        if (vcs == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(16);
        }
        if (file == null) {
            IgnoreGroupHelperAction.$$$reportNull$$$0(17);
        }
        return ChangeListManager.getInstance((Project)vcs.getProject()).isUnversioned(file) && (parent = file.getParent()) != null && SvnStatusUtil.isUnderControl(vcs, parent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/ignore/IgnoreGroupHelperAction";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/ignore/IgnoreGroupHelperAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "tryCreateFor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileGroupInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFiles";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkEnabled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkIgnoreProperty";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isUnversioned";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 13 -> new IllegalStateException(string);
        };
    }
}

