/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.ds.jupyter.customCells.sql.resolver;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.pycharm.ds.jupyter.customCells.JupyterSqlPluginSettings;
import com.intellij.pycharm.ds.jupyter.customCells.sql.metadata.SqlCellMetadataKt;
import com.intellij.pycharm.ds.jupyter.customCells.sql.resolver.DataFrameTable;
import com.intellij.pycharm.ds.jupyter.customCells.sql.resolver.JupyterDataFrameSqlResolveExtensionKt;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlResolveExtension;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\u000f\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/pycharm/ds/jupyter/customCells/sql/resolver/JupyterDataFrameSqlResolveExtension;", "Lcom/intellij/sql/psi/impl/SqlResolveExtension;", "<init>", "()V", "process", "", "reference", "Lcom/intellij/sql/psi/SqlReference;", "processor", "Lcom/intellij/sql/psi/SqlScopeProcessor;", "isDataFrameSQLCell", "file", "Lcom/intellij/sql/psi/SqlFile;", "originPsiFile", "Lcom/intellij/psi/PsiFile;", "DataFrameDasSymbol", "DataFrameTableType", "DataFrameColumnElement", "intellij.pycharm.ds.jupyter.customCells"})
@SourceDebugExtension(value={"SMAP\nJupyterDataFrameSqlResolveExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDataFrameSqlResolveExtension.kt\ncom/intellij/pycharm/ds/jupyter/customCells/sql/resolver/JupyterDataFrameSqlResolveExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1863#2,2:166\n*S KotlinDebug\n*F\n+ 1 JupyterDataFrameSqlResolveExtension.kt\ncom/intellij/pycharm/ds/jupyter/customCells/sql/resolver/JupyterDataFrameSqlResolveExtension\n*L\n53#1:166,2\n*E\n"})
public final class JupyterDataFrameSqlResolveExtension
implements SqlResolveExtension {
    public boolean process(@NotNull SqlReference reference, @NotNull SqlScopeProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        if (!processor.mayAccept(ObjectKind.TABLE)) {
            return true;
        }
        PsiFile psiFile = reference.getElement().getContainingFile();
        SqlFile sqlFile = psiFile instanceof SqlFile ? (SqlFile)psiFile : null;
        if (sqlFile == null) {
            return true;
        }
        SqlFile file = sqlFile;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        VirtualFile virtualFile2 = JupyterDataFrameSqlResolveExtensionKt.access$getOriginalFile(virtualFile);
        if (virtualFile2 == null) {
            return true;
        }
        VirtualFile originVirtualFile = virtualFile2;
        PsiFile psiFile2 = file.getManager().findFile(originVirtualFile);
        if (psiFile2 == null) {
            return true;
        }
        PsiFile originPsiFile = psiFile2;
        if (!this.isDataFrameSQLCell(file, originPsiFile)) {
            return true;
        }
        List list = JupyterDataFrameSqlResolveExtensionKt.access$getOrCreateTables(originPsiFile);
        if (list == null) {
            return true;
        }
        List tables = list;
        Iterable $this$forEach$iv = tables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataFrameTable tableSource = (DataFrameTable)element$iv;
            boolean bl = false;
            processor.executeTarget((DasSymbol)tableSource.getTable(), (DasType)tableSource.getDasSymbol(), null, ResolveState.initial());
        }
        return true;
    }

    private final boolean isDataFrameSQLCell(SqlFile file, PsiFile originPsiFile) {
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        int startOffsetOrigin = InjectedLanguageManager.getInstance((Project)project2).injectedToHost((PsiElement)file, file.getTextRange()).getStartOffset();
        VirtualFile virtualFile = originPsiFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(virtualFile);
        if (backedNotebookVirtualFile == null) {
            return false;
        }
        BackedNotebookVirtualFile notebook = backedNotebookVirtualFile;
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(originPsiFile);
        if (document == null) {
            return false;
        }
        Document document2 = document;
        if (startOffsetOrigin > document2.getTextLength()) {
            return false;
        }
        int lineNumber = document2.getLineNumber(startOffsetOrigin);
        if (!NotebookCellLines.Companion.hasSupport(document2)) {
            return false;
        }
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)NotebookCellLines.Companion.get(document2).intervalsIterator(lineNumber).next();
        JupyterNotebook jupyterNotebook = notebook.getNotebookOrNull();
        if (jupyterNotebook == null) {
            return false;
        }
        JupyterNotebook jupyterNotebook2 = jupyterNotebook;
        return SqlCellMetadataKt.checkIfDataFrameSQLCell(jupyterNotebook2.getCell(interval.getOrdinal()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u001d\u0010\u0015\u001a\u0017\u0012\u000e\u0012\f0\u0000\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0002\b\u00180\u0016\u00a2\u0006\u0002\b\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0000H\u0016J\b\u0010\u001a\u001a\u00020\u0000H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/pycharm/ds/jupyter/customCells/sql/resolver/JupyterDataFrameSqlResolveExtension$DataFrameColumnElement;", "Lcom/intellij/psi/impl/FakePsiElement;", "Lcom/intellij/database/symbols/DasSymbol;", "name", "", "originPsiFile", "Lcom/intellij/psi/PsiFile;", "dataFrameName", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiFile;Ljava/lang/String;)V", "getParent", "getName", "getKind", "Lcom/intellij/database/model/ObjectKind;", "isQuoted", "", "getDbms", "Lcom/intellij/database/Dbms;", "isValid", "getDasObject", "Lcom/intellij/database/model/DasObject;", "getPsiDeclarations", "Lcom/intellij/util/containers/JBIterable;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "getNavigationElement", "getContextElement", "getTextOffset", "", "getText", "intellij.pycharm.ds.jupyter.customCells"})
    public static final class DataFrameColumnElement
    extends FakePsiElement
    implements DasSymbol {
        @NotNull
        private final String name;
        @NotNull
        private final PsiFile originPsiFile;
        @NotNull
        private final String dataFrameName;

        public DataFrameColumnElement(@NotNull String name, @NotNull PsiFile originPsiFile, @NotNull String dataFrameName) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)originPsiFile, (String)"originPsiFile");
            Intrinsics.checkNotNullParameter((Object)dataFrameName, (String)"dataFrameName");
            this.name = name;
            this.originPsiFile = originPsiFile;
            this.dataFrameName = dataFrameName;
        }

        @NotNull
        public PsiFile getParent() {
            return this.originPsiFile;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            return objectKind;
        }

        public boolean isQuoted() {
            return false;
        }

        @NotNull
        public Dbms getDbms() {
            return JupyterSqlPluginSettings.INSTANCE.getDataFrameSqlCellLanguage();
        }

        public boolean isValid() {
            return true;
        }

        @Nullable
        public DasObject getDasObject() {
            return null;
        }

        @NotNull
        public JBIterable<DataFrameColumnElement> getPsiDeclarations() {
            JBIterable jBIterable = JBIterable.of((Object)((Object)this));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
            return jBIterable;
        }

        @NotNull
        public DataFrameColumnElement getNavigationElement() {
            return this;
        }

        @NotNull
        public DataFrameColumnElement getContextElement() {
            return this;
        }

        public int getTextOffset() {
            Object object = JupyterDataFrameSqlResolveExtensionKt.access$extractTopLevelAttributes(this.originPsiFile);
            return object != null && (object = (Integer)object.get(this.dataFrameName)) != null ? (Integer)object : -1;
        }

        @NotNull
        public String getText() {
            return this.name;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0016J\u001d\u0010\u0014\u001a\u0017\u0012\u000e\u0012\f0\u0000\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u00170\u0015\u00a2\u0006\u0002\b\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0000H\u0016J\b\u0010\u001b\u001a\u00020\u0000H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/pycharm/ds/jupyter/customCells/sql/resolver/JupyterDataFrameSqlResolveExtension$DataFrameDasSymbol;", "Lcom/intellij/psi/impl/FakePsiElement;", "Lcom/intellij/database/symbols/DasSymbol;", "originPsiFile", "Lcom/intellij/psi/PsiFile;", "name", "", "dasObject", "Lcom/intellij/database/model/DasObject;", "<init>", "(Lcom/intellij/psi/PsiFile;Ljava/lang/String;Lcom/intellij/database/model/DasObject;)V", "getName", "getKind", "Lcom/intellij/database/model/ObjectKind;", "isQuoted", "", "getDbms", "Lcom/intellij/database/Dbms;", "isValid", "getDasObject", "getPsiDeclarations", "Lcom/intellij/util/containers/JBIterable;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "getParent", "Lcom/intellij/psi/PsiElement;", "getNavigationElement", "getContextElement", "getTextOffset", "", "intellij.pycharm.ds.jupyter.customCells"})
    public static final class DataFrameDasSymbol
    extends FakePsiElement
    implements DasSymbol {
        @NotNull
        private final PsiFile originPsiFile;
        @NotNull
        private final String name;
        @Nullable
        private final DasObject dasObject;

        public DataFrameDasSymbol(@NotNull PsiFile originPsiFile, @NotNull String name, @Nullable DasObject dasObject) {
            Intrinsics.checkNotNullParameter((Object)originPsiFile, (String)"originPsiFile");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.originPsiFile = originPsiFile;
            this.name = name;
            this.dasObject = dasObject;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            return objectKind;
        }

        public boolean isQuoted() {
            return false;
        }

        @NotNull
        public Dbms getDbms() {
            return JupyterSqlPluginSettings.INSTANCE.getDataFrameSqlCellLanguage();
        }

        public boolean isValid() {
            return true;
        }

        @Nullable
        public DasObject getDasObject() {
            return this.dasObject;
        }

        @NotNull
        public JBIterable<DataFrameDasSymbol> getPsiDeclarations() {
            JBIterable jBIterable = JBIterable.of((Object)((Object)this));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
            return jBIterable;
        }

        @NotNull
        public PsiElement getParent() {
            return (PsiElement)this.originPsiFile;
        }

        @NotNull
        public DataFrameDasSymbol getNavigationElement() {
            return this;
        }

        @NotNull
        public DataFrameDasSymbol getContextElement() {
            return this;
        }

        public int getTextOffset() {
            Object object = JupyterDataFrameSqlResolveExtensionKt.access$extractTopLevelAttributes(this.originPsiFile);
            return object != null && (object = (Integer)object.get(this.name)) != null ? (Integer)object : -1;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0014\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/pycharm/ds/jupyter/customCells/sql/resolver/JupyterDataFrameSqlResolveExtension$DataFrameTableType;", "Lcom/intellij/sql/psi/impl/SqlTableTypeBase;", "columns", "", "Lcom/intellij/pycharm/ds/jupyter/customCells/sql/resolver/JupyterDataFrameSqlResolveExtension$DataFrameColumnElement;", "<init>", "(Ljava/util/List;)V", "toDataType", "Lcom/intellij/database/model/DataType;", "Lorg/jetbrains/annotations/NotNull;", "getColumnCount", "", "getColumnName", "", "i", "getColumnDasType", "Lcom/intellij/database/types/DasBuiltinType;", "getMethods", "", "Lcom/intellij/database/model/DasObject;", "isColumnQuoted", "", "getColumnElement", "getSourceColumnElement", "", "getColumnQualifier", "intellij.pycharm.ds.jupyter.customCells"})
    public static final class DataFrameTableType
    extends SqlTableTypeBase {
        @NotNull
        private final List<DataFrameColumnElement> columns;

        public DataFrameTableType(@NotNull List<DataFrameColumnElement> columns) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            this.columns = columns;
        }

        @NotNull
        public DataType toDataType() {
            DataType dataType = SqlTypeFactory.createTableDataType((String)"");
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"createTableDataType(...)");
            return dataType;
        }

        public int getColumnCount() {
            return ((Collection)this.columns).size();
        }

        @NotNull
        public String getColumnName(int i) {
            return this.columns.get(i).getName();
        }

        @NotNull
        public DasBuiltinType<?> getColumnDasType(int i) {
            return DasTypeSystemBase.UNKNOWN;
        }

        @NotNull
        public List<DasObject> getMethods() {
            return new ArrayList();
        }

        public boolean isColumnQuoted(int i) {
            return false;
        }

        @NotNull
        public DataFrameColumnElement getColumnElement(int i) {
            return this.columns.get(i);
        }

        @Nullable
        public Void getSourceColumnElement(int i) {
            return null;
        }

        @Nullable
        public Void getColumnQualifier(int i) {
            return null;
        }
    }
}

