/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.jupyterPython.cell;

import com.intellij.dataWrangler.jupyterPython.cell.JupyterDataWranglerCellMetadata;
import com.intellij.dataWrangler.jupyterPython.cell.JupyterDataWranglerCellMetadataKt;
import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesDocumentUtils;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellsContents;
import com.intellij.jupyter.core.core.impl.actions.RemoveOutputsUndoableAction;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/dataWrangler/jupyterPython/cell/JupyterDataWranglerConvertToCodeAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.dataWrangler.jupyterPython"})
final class JupyterDataWranglerConvertToCodeAction
extends AnAction {
    private JupyterDataWranglerConvertToCodeAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        NotebookCellLines.Interval selectedInterval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext);
        if (selectedInterval == null || JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(selectedInterval) != JupyterCellType.DATA_WRANGLER) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterDataContextExtensionsKt.getJupyterNotebookFile((DataContext)dataContext2);
        JupyterDataWranglerCellMetadata metadata = backedNotebookVirtualFile != null && (backedNotebookVirtualFile = backedNotebookVirtualFile.getNotebook()) != null && (backedNotebookVirtualFile = backedNotebookVirtualFile.getCellOrNull(selectedInterval.getOrdinal())) != null ? JupyterDataWranglerCellMetadataKt.getDataWranglerMetadata((JupyterCell)backedNotebookVirtualFile) : null;
        e.getPresentation().setEnabled(metadata != null && !((charSequence = (CharSequence)metadata.getSource()) == null || StringsKt.isBlank((CharSequence)charSequence)));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext);
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterDataContextExtensionsKt.getJupyterNotebookFile((DataContext)dataContext2);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        JupyterDataWranglerCellMetadata jupyterDataWranglerCellMetadata = JupyterDataWranglerCellMetadataKt.getDataWranglerMetadata(notebookFile.getNotebook().getCell(interval2.getOrdinal()));
        if (jupyterDataWranglerCellMetadata == null) {
            return;
        }
        JupyterDataWranglerCellMetadata metadata = jupyterDataWranglerCellMetadata;
        DataContext dataContext3 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor((DataContext)dataContext3);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        String string = metadata.getSource();
        if (string == null) {
            return;
        }
        String source = string;
        Object object = NotebookCellLinesEditHelper.Companion.getOrNull((Editor)editor);
        if (object == null || (object = NotebookCellLinesEditHelper.makeCell$default((NotebookCellLinesEditHelper)object, (String)source, (NotebookCellLines.CellType)NotebookCellLines.CellType.CODE, null, (int)4, null)) == null) {
            return;
        }
        Object cellText = object;
        WriteCommandAction.writeCommandAction((Project)project2).withName(e.getPresentation().getText()).run(() -> JupyterDataWranglerConvertToCodeAction.actionPerformed$lambda$0(editor, (String)cellText, interval2, project2));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final void actionPerformed$lambda$0(EditorImpl $editor, String $cellText, NotebookCellLines.Interval $interval, Project $project) {
        DocumentEx documentEx = $editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        NotebookCellLines.Interval insertedInterval = (NotebookCellLines.Interval)CollectionsKt.first((List)NotebookCellLinesDocumentUtils.insertCells$default((NotebookCellLinesDocumentUtils)NotebookCellLinesDocumentUtils.INSTANCE, (Document)((Document)document), (NotebookCellLines)NotebookCellLines.Companion.get((Editor)$editor), (String)$cellText, (int)($interval.getOrdinal() + 1), (boolean)false, (int)8, null));
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)$editor));
        if (notebookCellSelectionModel != null) {
            notebookCellSelectionModel.selectSingleCell(insertedInterval);
        }
        NotebookCellsContents cellContent = NotebookCellsContents.Companion.invoke((Editor)$editor, CollectionsKt.listOf((Object)$interval));
        RemoveOutputsUndoableAction undoableAction = new RemoveOutputsUndoableAction((Editor)$editor, cellContent);
        UndoManager.getInstance((Project)$project).undoableActionPerformed((UndoableAction)undoableAction);
        NotebookCellLinesDocumentUtils.INSTANCE.removeCell((Document)document, $interval, NotebookIntervalPointerFactory.Companion.get($project, (Document)document));
    }
}

