/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.console.ConsoleMessage;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.JavaScriptConsoleViewContentTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateContextBase;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.ConsoleAPICalledEventData;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/debugger/wip/WipConsoleAPICalled;", "Lcom/intellij/javascript/debugger/console/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/runtime/ConsoleAPICalledEventData;", "vm", "Lorg/jetbrains/wip/WipVm;", "<init>", "(Lorg/jetbrains/wip/protocol/runtime/ConsoleAPICalledEventData;Lorg/jetbrains/wip/WipVm;)V", "print", "", "printer", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "printParameters", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "startFrom", "", "xmlView", "", "getKeyByValueType", "Lcom/intellij/openapi/util/Key;", "", "type", "Lorg/jetbrains/wip/protocol/runtime/RemoteObjectValue$Type;", "printFormatted", "isSpecifier", "c", "", "hasFormat", "remoteObjectValue", "Lorg/jetbrains/wip/protocol/runtime/RemoteObjectValue;", "intellij.javascript.chrome.connector"})
@SourceDebugExtension(value={"SMAP\nWipConsoleAPICalled.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WipConsoleAPICalled.kt\ncom/jetbrains/debugger/wip/WipConsoleAPICalled\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1#2:203\n*E\n"})
public final class WipConsoleAPICalled
implements ConsoleMessage {
    @NotNull
    private final ConsoleAPICalledEventData message;
    @NotNull
    private final WipVm vm;

    public WipConsoleAPICalled(@NotNull ConsoleAPICalledEventData message, @NotNull WipVm vm) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.message = message;
        this.vm = vm;
    }

    public void print(@NotNull ConsoleMessageBuilder printer) {
        CallFrameValue callFrame;
        ConsoleViewContentType contentType;
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        StackTraceValue stackTrace = this.message.getStackTrace();
        switch (WhenMappings.$EnumSwitchMapping$0[this.message.type().ordinal()]) {
            case 1: {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_ERROR_OUTPUT;
                break;
            }
            case 2: {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_WARNING_OUTPUT;
                break;
            }
            case 3: {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_INFO_OUTPUT;
                break;
            }
            case 4: {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
                break;
            }
            default: {
                ConsoleViewContentType consoleViewContentType = contentType = ConsoleViewContentType.NORMAL_OUTPUT;
            }
        }
        if (this.message.type() == ConsoleAPICalledEventData.EventType.END_GROUP) {
            printer.groupEnd();
            return;
        }
        Intrinsics.checkNotNull((Object)contentType);
        ConsoleMessageBuilder.startMessage$default((ConsoleMessageBuilder)printer, (ConsoleViewContentType)contentType, null, (int)2, null);
        Object object = stackTrace;
        CallFrameValue callFrameValue = object != null && (object = object.callFrames()) != null ? (CallFrameValue)CollectionsKt.firstOrNull((List)object) : (callFrame = null);
        if (callFrame != null && !(((CharSequence)callFrame.url()).length() == 0) && !Intrinsics.areEqual((Object)callFrame.url(), (Object)"undefined")) {
            ConsoleMessageBuilder.addMessageLink$default((ConsoleMessageBuilder)printer, (String)callFrame.url(), (int)callFrame.getLineNumber(), (int)callFrame.getColumnNumber(), (String)callFrame.functionName(), (boolean)true, null, (int)32, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.message.type().ordinal()]) {
            case 5: 
            case 6: {
                String string;
                RemoteObjectValue remoteObjectValue = this.message.args().get(0);
                if (remoteObjectValue.type() == RemoteObjectValue.Type.STRING) {
                    Object object2 = remoteObjectValue.value();
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
                    string = (String)object2;
                } else {
                    string = remoteObjectValue.getDescription();
                    if (string == null) {
                        string = "console.group()";
                    }
                }
                String groupName = string;
                printer.groupStart(groupName, this.message.type() == ConsoleAPICalledEventData.EventType.START_GROUP_COLLAPSED);
                break;
            }
            case 7: 
            case 8: {
                WipConsoleAPICalled.printParameters$default(this, printer, contentType, 0, this.message.type() != ConsoleAPICalledEventData.EventType.DIR, 4, null);
                break;
            }
            case 9: {
                printer.clear();
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType((Key)ConsoleMessageBuilder.Companion.getCONSOLE_INFO_KEY());
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"getConsoleViewType(...)");
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)"Console was cleared", (ConsoleViewContentType)consoleViewContentType, null, (int)4, null);
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                WipConsoleAPICalled.printParameters$default(this, printer, contentType, 0, false, 12, null);
                printer.printStackTrace(contentType, stackTrace);
                break;
            }
            case 11: {
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)"Assertion failed: ", (ConsoleViewContentType)contentType, null, (int)4, null);
                WipConsoleAPICalled.printParameters$default(this, printer, contentType, 0, false, 12, null);
                break;
            }
            default: {
                WipConsoleAPICalled.printParameters$default(this, printer, contentType, 0, false, 12, null);
            }
        }
        printer.endMessage();
    }

    /*
     * Unable to fully structure code
     */
    private final void printParameters(ConsoleMessageBuilder printer, ConsoleViewContentType contentType, int startFrom, boolean xmlView) {
        if (startFrom == 0 && this.message.args().size() > 1 && this.hasFormat(this.message.args().get(0))) {
            this.printFormatted(printer, contentType);
            return;
        }
        var6_6 = this.message.args().size();
        for (i = startFrom; i < var6_6; ++i) {
            objectValue = this.message.args().get(i);
            if (i != 0) {
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)" ", (ConsoleViewContentType)contentType, null, (int)4, null);
            }
            if ((var9_9 = this.getKeyByValueType(objectValue.type())) == null) ** GOTO lbl-1000
            it = var9_9;
            $i$a$-let-WipConsoleAPICalled$printParameters$valueContentType$1 = false;
            var10_10 = ConsoleViewContentType.getConsoleViewType(it);
            if (var10_10 != null) {
                v0 = var10_10;
            } else lbl-1000:
            // 2 sources

            {
                v0 = contentType;
            }
            valueContentType = v0;
            var9_9 = objectValue.getObjectId();
            if (!(var9_9 == null || var9_9.length() == 0)) {
                v1 = this.vm.getEvaluateContext();
                Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type org.jetbrains.debugger.EvaluateContextBase<*>");
                v2 = ((EvaluateContextBase)v1).getValueManager();
                Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type org.jetbrains.wip.WipValueManager");
                valueManager = (WipValueManager)v2;
                v3 = valueManager.createValue(objectValue);
                Intrinsics.checkNotNull((Object)v3);
                printer.printAndStoreValueToInspect(v3, null, valueContentType, xmlView);
                continue;
            }
            if (objectValue.value() != null) {
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)String.valueOf(objectValue.value()), (ConsoleViewContentType)valueContentType, null, (int)4, null);
                continue;
            }
            if (!StringUtil.isEmpty((String)objectValue.getDescription())) {
                v4 = objectValue.getDescription();
                Intrinsics.checkNotNull((Object)v4);
                ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)v4, (ConsoleViewContentType)valueContentType, null, (int)4, null);
                continue;
            }
            if (!Intrinsics.areEqual((Object)objectValue.type().name(), (Object)"UNDEFINED")) continue;
            v5 = ConsoleViewContentType.getConsoleViewType((Key)JavaScriptConsoleViewContentTypes.INSTANCE.getKEYWORD_KEY());
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getConsoleViewType(...)");
            ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)"undefined", (ConsoleViewContentType)v5, null, (int)4, null);
        }
    }

    static /* synthetic */ void printParameters$default(WipConsoleAPICalled wipConsoleAPICalled, ConsoleMessageBuilder consoleMessageBuilder, ConsoleViewContentType consoleViewContentType, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        wipConsoleAPICalled.printParameters(consoleMessageBuilder, consoleViewContentType, n, bl);
    }

    private final Key<Object> getKeyByValueType(RemoteObjectValue.Type type) {
        return switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1 -> JavaScriptConsoleViewContentTypes.INSTANCE.getNUMBER_KEY();
            case 2, 3, 4 -> JavaScriptConsoleViewContentTypes.INSTANCE.getKEYWORD_KEY();
            default -> null;
        };
    }

    private final void printFormatted(ConsoleMessageBuilder printer, ConsoleViewContentType contentType) {
        String formatString = String.valueOf(this.message.args().get(0).value());
        int currentArgument = 1;
        int currentIndex = 0;
        int lastIndex = 0;
        String style = null;
        while (currentIndex + 1 < formatString.length() && currentArgument < this.message.args().size()) {
            while (!(currentIndex + 1 >= formatString.length() || formatString.charAt(currentIndex) == '%' && this.isSpecifier(formatString.charAt(currentIndex + 1)))) {
                ++currentIndex;
            }
            if (currentIndex + 1 == formatString.length()) break;
            String string = formatString.substring(lastIndex, currentIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            printer.append(string, contentType, style);
            RemoteObjectValue argument = this.message.args().get(currentArgument);
            switch (formatString.charAt(currentIndex + 1)) {
                case 's': {
                    String string2 = argument.getDescription();
                    if (string2 == null) {
                        string2 = String.valueOf(argument.value());
                    }
                    String text = string2;
                    ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)text, null, (String)style, (int)2, null);
                    ++currentArgument;
                    break;
                }
                case 'd': 
                case 'i': {
                    ConsoleViewContentType numberContentType;
                    String string3;
                    String string4 = argument.getDescription();
                    if (string4 == null) {
                        string4 = String.valueOf(argument.value());
                    }
                    String text = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)ConsoleViewContentType.getConsoleViewType((Key)JavaScriptConsoleViewContentTypes.INSTANCE.getNUMBER_KEY()), (String)"getConsoleViewType(...)");
                    try {
                        string3 = String.valueOf(Long.parseLong(text, CharsKt.checkRadix((int)10)));
                    }
                    catch (Exception exception) {
                        String string5;
                        try {
                            string5 = new BigDecimal(text).round(MathContext.DECIMAL128).toString();
                        }
                        catch (Exception exception2) {
                            string5 = "NaN";
                        }
                        String string6 = string5;
                        Intrinsics.checkNotNull((Object)string6);
                        string3 = string6;
                    }
                    String num = string3;
                    printer.append(num, numberContentType, style);
                    ++currentArgument;
                    break;
                }
                case 'f': {
                    ConsoleViewContentType numberContentType;
                    String string3;
                    String string7 = argument.getDescription();
                    if (string7 == null) {
                        string7 = String.valueOf(argument.value());
                    }
                    String text = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)ConsoleViewContentType.getConsoleViewType((Key)JavaScriptConsoleViewContentTypes.INSTANCE.getNUMBER_KEY()), (String)"getConsoleViewType(...)");
                    try {
                        string3 = String.valueOf(Float.parseFloat(text));
                    }
                    catch (Exception exception) {
                        string3 = "NaN";
                    }
                    String num = string3;
                    printer.append(num, numberContentType, style);
                    ++currentArgument;
                    break;
                }
                case 'O': 
                case 'o': {
                    EvaluateContext evaluateContext = this.vm.getEvaluateContext();
                    Intrinsics.checkNotNull((Object)evaluateContext, (String)"null cannot be cast to non-null type org.jetbrains.debugger.EvaluateContextBase<*>");
                    ValueManager valueManager = ((EvaluateContextBase)evaluateContext).getValueManager();
                    Intrinsics.checkNotNull((Object)valueManager, (String)"null cannot be cast to non-null type org.jetbrains.wip.WipValueManager");
                    WipValueManager valueManager2 = (WipValueManager)valueManager;
                    Value value = valueManager2.createValue(argument);
                    if (value != null) {
                        printer.printAndStoreValueToInspect(value, null, contentType, false);
                    } else {
                        String string8 = argument.getDescription();
                        if (string8 == null) {
                            string8 = String.valueOf(argument.value());
                        }
                        String text = string8;
                        ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)text, null, (String)style, (int)2, null);
                    }
                    ++currentArgument;
                    break;
                }
                case 'c': {
                    style = String.valueOf(argument.value());
                    ++currentArgument;
                    break;
                }
                default: {
                    String string9 = formatString.substring(currentIndex, currentIndex + 2);
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                    printer.append(string9, contentType, style);
                }
            }
            lastIndex = currentIndex + 2;
            currentIndex += 2;
        }
        String string = formatString.substring(lastIndex, formatString.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)printer, (String)string, null, style, (int)2, null);
        WipConsoleAPICalled.printParameters$default(this, printer, contentType, currentArgument, false, 8, null);
    }

    private final boolean isSpecifier(char c) {
        return c == 's' || c == 'f' || c == 'i' || c == 'd' || c == 'o' || c == 'O' || c == 'c';
    }

    private final boolean hasFormat(RemoteObjectValue remoteObjectValue) {
        if (remoteObjectValue.type() != RemoteObjectValue.Type.STRING) {
            return false;
        }
        String s = String.valueOf(remoteObjectValue.value());
        return StringsKt.contains$default((CharSequence)s, (CharSequence)"%s", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)s, (CharSequence)"%f", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)s, (CharSequence)"%i", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)s, (CharSequence)"%d", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)s, (CharSequence)"%o", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)s, (CharSequence)"%O", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)s, (CharSequence)"%c", (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ConsoleAPICalledEventData.EventType.values().length];
            try {
                nArray[ConsoleAPICalledEventData.EventType.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleAPICalledEventData.EventType.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleAPICalledEventData.EventType.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleAPICalledEventData.EventType.DEBUG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleAPICalledEventData.EventType.START_GROUP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleAPICalledEventData.EventType.START_GROUP_COLLAPSED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleAPICalledEventData.EventType.DIR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleAPICalledEventData.EventType.DIRXML.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleAPICalledEventData.EventType.CLEAR.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleAPICalledEventData.EventType.TRACE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleAPICalledEventData.EventType.ASSERT.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RemoteObjectValue.Type.values().length];
            try {
                nArray[RemoteObjectValue.Type.NUMBER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemoteObjectValue.Type.UNDEFINED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemoteObjectValue.Type.SYMBOL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemoteObjectValue.Type.BOOLEAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

