/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedStub;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public interface JSCachingNamespaceOwner
extends JSNamedElement {
    public static final Key<ParameterizedCachedValue<JSNamespace, JSCachingNamespaceOwner>> NAMESPACE_PROVIDER_KEY = Key.create((String)"js.symbol.namespace");
    public static final Key<JSStubElementImpl.StubBuildCachedValue<JSNamespace>> STUB_BUILDING_NAMESPACE_PROVIDER_KEY = Key.create((String)"js.stub.building.symbol.namespace");
    public static final ParameterizedCachedValueProvider<JSNamespace, JSCachingNamespaceOwner> NAMESPACE_PROVIDER = element -> {
        JSQualifiedStub stub = (JSQualifiedStub)((StubBasedPsiElementBase)element).getGreenStub();
        JSNamespace data2 = stub != null ? stub.getNamespaceWithSource((PsiElement)element) : element.calculateSymbolNamespace();
        return CachedValueProvider.Result.create((Object)data2, (Object[])new Object[]{element.getContainingFile()});
    };

    @NotNull
    default public JSNamespace calculateSymbolNamespace() {
        boolean isLocal;
        boolean useJSDocTypes = this.useTypesFromJSDoc();
        boolean lookedUpComment = false;
        PsiComment comment = null;
        if (useJSDocTypes && JSUtils.getMemberContainingClass((PsiElement)this) == null && DialectDetector.isJavaScript((PsiElement)this)) {
            comment = JSDocumentationUtils.findDocComment((PsiElement)this);
            lookedUpComment = true;
            JSNamespace fromJSDoc = JSDocumentationUtils.getNamespaceFromJSDoc(comment);
            if (fromJSDoc != null) {
                JSNamespace jSNamespace = fromJSDoc;
                if (jSNamespace == null) {
                    JSCachingNamespaceOwner.$$$reportNull$$$0(0);
                }
                return jSNamespace;
            }
        }
        JSQualifiedName name = JSPsiImplUtils.getPrefixFromName(this);
        JSNamespace parentNamespace = JSPsiImplUtils.getNamespaceFromParent(this);
        if (parentNamespace != null) {
            name = JSQualifiedNameImpl.concat(parentNamespace.getQualifiedName(), name);
        }
        boolean isStrict = parentNamespace != null && parentNamespace.isSourceStrict();
        PsiElement declarationScope = PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{JSExecutionScope.class, JSClass.class});
        boolean bl = isLocal = parentNamespace != null && parentNamespace.isLocal() || JSUseScopeProvider.getUseScopeElement(this) != null;
        if (isLocal) {
            if (!lookedUpComment) {
                comment = JSDocumentationUtils.findDocComment((PsiElement)this);
            }
            if (comment instanceof JSDocComment) {
                JSDocComment docComment = (JSDocComment)comment;
                boolean bl2 = isLocal = !docComment.isClassExplicitly() && docComment.getExplicitName() == null;
            }
        }
        if (declarationScope instanceof JSFile || declarationScope instanceof JSEmbeddedContent || declarationScope instanceof JSFunction) {
            isStrict = true;
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(name, JSSymbolUtil.getContext(this, useJSDocTypes), (PsiElement)this, isStrict, true, isLocal);
        if (jSNamespace == null) {
            JSCachingNamespaceOwner.$$$reportNull$$$0(1);
        }
        return jSNamespace;
    }

    public boolean useTypesFromJSDoc();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSCachingNamespaceOwner", "calculateSymbolNamespace"));
    }
}

