/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.gist.JSStubElementGist;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSParameterListImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.stubs.JSParameterStub;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterImpl
extends JSVariableBaseImpl<JSParameterStub, JSParameter>
implements JSParameter {
    private static final Key<ParameterizedCachedValue<JSParameterTypeDecorator, JSParameterImpl>> TYPE_KEY = Key.create((String)"js.parameter.type");
    private static final ParameterizedCachedValueProvider<JSParameterTypeDecorator, JSParameterImpl> TYPE_PROVIDER = psi -> {
        boolean isTypeRest = JSStubElementGist.getInstance(psi.getProject()).getData((JSParameterImpl)psi).isTypeRest();
        JSParameterTypeDecoratorImpl decorator = new JSParameterTypeDecoratorImpl(psi.getName(), psi.getSimpleType(), psi.isOptional(), isTypeRest, psi.isTypeStrict(), (JSParameterImpl)psi){
            final /* synthetic */ JSParameterImpl val$psi;
            {
                this.val$psi = jSParameterImpl;
                super(name, type2, optional, rest, explicitlyDeclared);
            }

            @Override
            @Nullable
            public JSType getInferredType() {
                return this.val$psi.getInferredType();
            }
        };
        return CachedValueProvider.Result.create((Object)decorator, (Object[])new Object[]{psi});
    };

    public JSParameterImpl(ASTNode node) {
        super(node);
    }

    public JSParameterImpl(JSParameterStub stub) {
        super(stub, JSStubElementTypes.FORMAL_PARAMETER);
    }

    public JSParameterImpl(JSParameterStub stub, JSStubElementType<JSParameterStub, JSParameter> elementType) {
        super(stub, elementType);
    }

    @Override
    public JSFunction getDeclaringFunction() {
        JSElement owner = JSParameterImpl.getOwner(this);
        return owner instanceof JSFunction ? (JSFunction)owner : null;
    }

    @Override
    public boolean isRest() {
        JSParameterStub parameterStub = (JSParameterStub)this.getGreenStub();
        if (parameterStub != null) {
            return parameterStub.isRest();
        }
        return this.getNode().findChildByType(JSTokenTypes.DOT_DOT_DOT) != null;
    }

    @Override
    public boolean isOptional() {
        return JSStubElementGist.getInstance(this.getProject()).getData(this).isOptional();
    }

    public boolean calculateIsOptional() {
        PsiElement isQuest;
        if (this.getInitializer() != null) {
            return true;
        }
        if (DialectDetector.isActionScript(this)) {
            return false;
        }
        PsiElement firstChild = this.getFirstChild();
        if (firstChild != null && (isQuest = firstChild.getNextSibling()) != null && isQuest instanceof LeafPsiElement && ((LeafPsiElement)isQuest).getElementType() == JSTokenTypes.QUEST) {
            return true;
        }
        if (PsiTreeUtil.getChildOfType((PsiElement)this, JSTypeDeclaration.class) != null) {
            return false;
        }
        JSFunction function = this.getDeclaringFunction();
        if (!(function instanceof JSFunctionBaseImpl)) {
            return false;
        }
        return ((JSFunctionBaseImpl)function).isOptional(this);
    }

    protected boolean isTypeStrict() {
        return JSStubElementGist.getInstance(this.getProject()).getData(this).isTypeStrict();
    }

    public boolean calculateIsTypeStrict() {
        JSFunction grandParent = this.getDeclaringFunction();
        if (!(grandParent instanceof JSFunctionBaseImpl)) {
            return false;
        }
        return ((JSFunctionBaseImpl)grandParent).isTypeExplicitlyDeclared(this);
    }

    public boolean calcIsTypeRest() {
        JSFunction grandParent;
        boolean isTypeRest = this.isRest();
        if (!isTypeRest && this.getNode().findChildByType(JSTokenTypes.COLON) == null && (grandParent = this.getDeclaringFunction()) instanceof JSFunctionBaseImpl) {
            isTypeRest = ((JSFunctionBaseImpl)grandParent).isRest(this);
        }
        return isTypeRest;
    }

    @Override
    @NotNull
    public JSParameterTypeDecorator getTypeDecorator() {
        JSParameterTypeDecorator jSParameterTypeDecorator = (JSParameterTypeDecorator)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, TYPE_KEY, TYPE_PROVIDER, false, (Object)this);
        if (jSParameterTypeDecorator == null) {
            JSParameterImpl.$$$reportNull$$$0(0);
        }
        return jSParameterTypeDecorator;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSParameterImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSParameter(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public Icon getIcon(int flags) {
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.Parameter);
    }

    @Override
    public JSAttributeList getAttributeList() {
        return JSUtils.getAttributeList(this);
    }

    @Override
    public ASTNode findNameIdentifier() {
        return JSParameterImpl.findParameterNameIdentifier(this.getNode());
    }

    @Override
    @Nullable
    public PsiElement getDeclarationElement() {
        return this.getNameIdentifier();
    }

    @Nullable
    public static ASTNode findParameterNameIdentifier(ASTNode node) {
        return JSVariableBaseImpl.findVariableNameIdentifier(node);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        if (!JSParameterListImpl.handleChildDeletion(this)) {
            super.delete();
        }
    }

    @Override
    public PsiElement getTypeElement() {
        return DialectDetector.isActionScript(this) ? ActionScriptPsiImplUtil.getTypeElementFromDeclaration(this) : JSPsiImplUtils.getTypeElementFromDeclaration(this);
    }

    @Override
    @Nullable
    public JSType doGetExplicitlyDeclaredType() {
        ASTNode type2;
        ASTNode astNode;
        ASTNode anchor;
        PsiElement grandParent;
        PsiElement parentWithoutDestructuring = JSDestructuringUtil.getParentSkippingDestructuring(this);
        if (parentWithoutDestructuring != null && (grandParent = parentWithoutDestructuring.getParent()) instanceof JSFunctionBaseImpl) {
            return this.doGetTypeFromFunction((JSFunctionBaseImpl)grandParent);
        }
        JSType t = super.doGetExplicitlyDeclaredType();
        if (t == null && (anchor = (astNode = this.getNode()).findChildByType(JSTokenTypes.INSTANCEOF_KEYWORD)) != null && (type2 = astNode.findChildByType(JSKeywordSets.IDENTIFIER_TOKENS_SET, anchor)) != null) {
            t = JSTypeParser.createType(this.getProject(), JSPsiImplUtils.getNameFromIdentifier(type2), JSTypeSourceFactory.createTypeSource(this, true));
        }
        return t;
    }

    @Nullable
    private JSType doGetTypeFromFunction(JSFunctionBaseImpl grandParent) {
        JSType typeFromDeclaration = JSPsiImplUtils.getTypeFromDeclaration(this);
        if (typeFromDeclaration != null) {
            return typeFromDeclaration;
        }
        JSType typeFromComments = grandParent.getTypeFromComments(this);
        if (typeFromComments == null) {
            return null;
        }
        typeFromComments = JSTypeBaseImpl.replaceEmptySourceRecursive(typeFromComments, JSTypeSourceFactory.createTypeSource(this, true));
        return typeFromComments;
    }

    @Override
    @Nullable
    public JSType getInferredType() {
        JSParameterItem superParameter;
        JSFunction function;
        JSType type2 = this.getJSType();
        if (type2 == null && (function = this.getDeclaringFunction()) != null && JSPsiImplUtils.isPotentialOverride(function) && (superParameter = JSInheritanceUtil.findMatchedSuperParameter(this, function)) != null) {
            return superParameter.getSimpleType();
        }
        return type2;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        PsiComment elt;
        JSElement fun = JSParameterImpl.getOwner(this);
        assert (fun != null);
        if (fun instanceof JSFunction && (elt = JSDocumentationUtils.findFunctionComment((JSFunction)fun)) != null) {
            return new LocalSearchScope(new PsiElement[]{elt, fun});
        }
        return new LocalSearchScope((PsiElement)fun);
    }

    @Nullable
    public static JSElement getOwner(@NotNull JSParameterListElement parameter) {
        if (parameter == null) {
            JSParameterImpl.$$$reportNull$$$0(2);
        }
        return (JSElement)PsiTreeUtil.getParentOfType((PsiElement)parameter, (Class[])new Class[]{JSFunction.class, JSCatchBlock.class, TypeScriptIndexSignature.class});
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = this.isValid() ? ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this) : PsiReference.EMPTY_ARRAY;
        if (psiReferenceArray == null) {
            JSParameterImpl.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    @Override
    @Nullable
    public String calculateLiteralOrReferenceInitializerText() {
        String result2 = super.calculateLiteralOrReferenceInitializerText();
        if (result2 != null) {
            return result2;
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment(this);
        String name = this.getName();
        if (docComment instanceof JSDocComment && name != null) {
            return ((JSDocComment)docComment).getDefaultValue(JSQualifiedNameImpl.create(name, null));
        }
        return null;
    }

    @Override
    public boolean isDecoratorRest() {
        return this.getTypeDecorator().isRest();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean hasBlockScope() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSParameterImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDecorator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSParameterImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOwner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

