/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.json.psi.JsonElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.frameworks.JSFrameworkSpecificHandler;
import com.intellij.lang.javascript.frameworks.amd.JSAmdModulesIndex;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.frameworks.gcl.JSGclModuleReference;
import com.intellij.lang.javascript.frameworks.gcl.JSGclReferenceContributor;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSLocalTypeEvaluatorBase;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSEmptyExpression;
import com.intellij.lang.javascript.psi.JSEvaluableElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReferenceItem;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.FlowJSFunction;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralTextReference;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSThisExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCompleteTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationCache;
import com.intellij.lang.javascript.psi.resolve.JSObjectLiteralTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationResultProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeGuardEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JavaScriptTypeHelper;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptMergedTypeImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSAsyncReturnType;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSElvisType;
import com.intellij.lang.javascript.psi.types.JSForInStringType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeWithWidening;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.JsonElementType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyIndexedAccessType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyNewType;
import com.intellij.lang.javascript.psi.types.evaluable.JSCustomElementType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSStubBasedExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSUnwrapPromiseType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.util.JSDestructuringContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeEvaluator {
    public static final int MAX_RESOLVE_RESULT_COUNT_TO_EVALUATE = 20;
    public static final String JQUERY_NS = "jQuery";
    @NotNull
    protected JSEvaluateContext myContext;
    @NotNull
    protected final JSTypeEvaluationResultProcessor myTypeProcessor;
    private static final Predicate<JSInitializerOwner> WITH_TYPE_DECLARATION_PREDICATE = owner -> {
        JSFunction function;
        if (owner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)((Object)owner)).getTypeElement() != null) {
            return true;
        }
        if (owner instanceof JSDestructuringParameter && (function = ((JSDestructuringParameter)owner).getDeclaringFunction()) instanceof JSFunctionBaseImpl) {
            return ((JSFunctionBaseImpl)function).getTypeFromComments((JSDestructuringParameter)owner) != null;
        }
        return false;
    };

    protected JSTypeEvaluator(@NotNull JSEvaluateContext context2) {
        if (context2 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(0);
        }
        this.myTypeProcessor = new JSTypeEvaluationResultProcessor();
        this.myContext = context2;
    }

    public static void evaluateTypes(@NotNull JSExpression expr, @NotNull JSTypeProcessor typeProcessor) {
        if (expr == null) {
            JSTypeEvaluator.$$$reportNull$$$0(1);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(2);
        }
        JSCompleteTypeEvaluationProcessor.evaluateTypes((PsiElement)expr, expr.getContainingFile(), typeProcessor, false);
    }

    public static void evaluateTypes(@NotNull JSExpression expr, @NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor) {
        if (expr == null) {
            JSTypeEvaluator.$$$reportNull$$$0(3);
        }
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(4);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(5);
        }
        JSCompleteTypeEvaluationProcessor.evaluateTypes((PsiElement)expr, targetFile, typeProcessor, false);
    }

    public static void evaluateExpressionOrElementTypes(@NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor, @NotNull PsiElement element) {
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(6);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(7);
        }
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(8);
        }
        JSCompleteTypeEvaluationProcessor.evaluateTypes(element, targetFile, typeProcessor, false);
    }

    public void doEvaluateExpressionOrElementTypes(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(9);
        }
        if (element instanceof JSExpression && JSTypeEvaluator.isEvaluatedAsExpression((JSExpression)element)) {
            this.doEvaluateTypes((JSExpression)element);
        } else if (element instanceof JSDestructuringContainer) {
            this.evaluateDestructuringContainer((JSDestructuringContainer)element);
        } else {
            this.doAddTypeFromResolveResult(element);
        }
    }

    public static boolean isEvaluatedAsExpression(@NotNull JSExpression element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(10);
        }
        return !(element instanceof JSDefinitionExpression);
    }

    @NotNull
    public static JSTypeEvaluator createEvaluator(@Nullable PsiElement element, @NotNull JSEvaluateContext context2) {
        if (context2 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(11);
        }
        JSTypeEvaluator jSTypeEvaluator = JSDialectSpecificHandlersFactory.forElement(element).newTypeEvaluator(context2);
        if (jSTypeEvaluator == null) {
            JSTypeEvaluator.$$$reportNull$$$0(12);
        }
        return jSTypeEvaluator;
    }

    @Nullable
    public static JSTypeEvaluationResult getElementType(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(13);
        }
        return JSEvaluationCache.getElementType(element, new JSEvaluateContext(element.getContainingFile(), false));
    }

    static void addTypeEvaluationResultElement(@NotNull JSEvaluationResultElement element, @NotNull JSEvaluateContext context2, @NotNull JSTypeProcessor typeProcessor) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(14);
        }
        if (context2 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(15);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(16);
        }
        JSReferenceExpression originalExpression = context2.getProcessedExpression();
        PsiElement originalSource = context2.getSource();
        JSEvaluateContext combinedContext = context2.combineWith(element.getEvaluateContext());
        JSType type2 = element.getTypeOrAdditionalType();
        if (element.isAdditionalType()) {
            typeProcessor.processAdditionalType(type2, combinedContext);
            return;
        }
        if (originalExpression != null) {
            type2 = JSTypeGuardEvaluator.applyToExpressionType(type2, originalExpression, originalSource, combinedContext);
        } else if (originalSource != null) {
            type2 = JSTypeGuardEvaluator.applyToResolveResultType(type2, originalSource, combinedContext);
        }
        typeProcessor.process(type2, combinedContext);
    }

    public void addType(@Nullable JSType type2) {
        if (type2 == null) {
            return;
        }
        this.doAddType(type2);
    }

    protected void doAddType(@NotNull JSType type2) {
        if (type2 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(17);
        }
        this.addAdditionalTypesForType(type2);
        this.myTypeProcessor.process(type2, this.myContext);
    }

    @Deprecated(forRemoval=true)
    public void addType(@Nullable JSType type2, @Nullable PsiElement source) {
        this.addType(type2);
    }

    private void addAdditionalTypesForType(@Nullable JSType type2) {
        PsiElement element;
        JSType referenceType;
        JSType jSType = type2 instanceof JSReferenceType || type2 instanceof JSQualifiedReferenceType ? type2 : (referenceType = type2 instanceof JSApplyCallType ? ((JSApplyCallType)type2).getBaseType() : null);
        if (referenceType instanceof JSReferenceItem && (element = referenceType.getSourceElement()) != null) {
            JSReferenceItem refType = (JSReferenceItem)((Object)referenceType);
            JSTypeEvaluator.addAdditionalTypes(element, refType, this.myTypeProcessor, this.myContext);
        }
    }

    public void addAdditionalType(@NotNull JSType type2) {
        if (type2 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(18);
        }
        this.myTypeProcessor.processAdditionalType(type2, this.myContext);
    }

    private void doEvaluateTypes(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(19);
        }
        if (this.myContext.isAstAccessAllowed((PsiElement)rawqualifier) && JSElvisType.isElvisContext(rawqualifier)) {
            JSType qualifierType = JSEvaluableOnlyTypeBase.substituteWithEvaluator(JSAnyType.get((PsiElement)rawqualifier), evaluator -> {
                evaluator.doEvaluateTypesImpl(rawqualifier);
                return JSEvaluationTasks.fromList(Collections.unmodifiableList(evaluator.getResult().getResults()));
            }, null);
            qualifierType = JSElvisType.applyElvisContext(rawqualifier, qualifierType);
            this.addType(qualifierType);
            return;
        }
        this.doEvaluateTypesImpl(rawqualifier);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doEvaluateTypesImpl(@NotNull JSExpression rawqualifier) {
        JSType typecast;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(20);
        }
        if (this.myContext.isAstAccessAllowed((PsiElement)rawqualifier) && (typecast = this.evaluateTypeFromInlineComment(rawqualifier)) != null) {
            this.addType(typecast);
            return;
        }
        if (rawqualifier instanceof JSEvaluableElement && ((JSEvaluableElement)((Object)rawqualifier)).evaluate(this.myContext, this.myTypeProcessor)) {
            return;
        }
        if (rawqualifier instanceof JSDefinitionExpression) {
            JSExpression innerExpression = ((JSDefinitionExpression)rawqualifier).getExpression();
            if (innerExpression == null) {
                return;
            }
            rawqualifier = innerExpression;
        }
        if (rawqualifier instanceof JSReferenceExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)rawqualifier;
            if (referenceExpression.getQualifier() == null && rawqualifier.getNode().findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                this.addType(JSNamedTypeFactory.createUndefinedType(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true)));
                return;
            }
            this.processRefExpr(referenceExpression);
            return;
        }
        if (rawqualifier instanceof JSNewExpression) {
            this.evaluateNewExpressionTypes((JSNewExpression)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSCallExpression) {
            this.evaluateCallExpressionTypes((JSCallExpression)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSPrefixExpression) {
            JSPrefixExpression prefixExpression = (JSPrefixExpression)rawqualifier;
            IElementType sign = prefixExpression.getOperationSign();
            String evaluatedType = null;
            JSType evaluatedJsType = null;
            if (JSTokenTypes.EXCL == sign || JSTokenTypes.DELETE_KEYWORD == sign) {
                evaluatedType = "boolean";
            } else if (JSTokenTypes.PLUS == sign || JSTokenTypes.PLUSPLUS == sign || JSTokenTypes.TILDE == sign || JSTokenTypes.MINUSMINUS == sign || JSTokenTypes.MINUS == sign) {
                if (JSSymbolUtil.isLiteralOrLiteralWithSign(prefixExpression)) {
                    this.addTypeFromLiteralExpression(prefixExpression);
                    return;
                }
                if (!DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    this.addNumericOperatorType(prefixExpression.getExpression(), null, prefixExpression);
                    return;
                }
                JSType type2 = this.getExpressionTypeInContext(prefixExpression.getExpression());
                if (type2 != null) {
                    evaluatedType = type2.getTypeText();
                }
            } else if (JSTokenTypes.TYPEOF_KEYWORD == sign) {
                if (!DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                    evaluatedJsType = JSCompositeTypeFactory.createUnionType(typeSource, ContainerUtil.map((Object[])JSCommonTypeNames.TYPEOF_VALUES, v -> new JSStringLiteralTypeImpl((String)v, false, typeSource)));
                } else {
                    evaluatedType = "string";
                }
            } else if (JSTokenTypes.AWAIT_KEYWORD == sign) {
                this.addCodeBasedType(rawqualifier);
                return;
            }
            if (evaluatedJsType != null) {
                this.addType(evaluatedJsType);
                return;
            }
            if (evaluatedType != null) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                JSType type3 = JSNamedTypeFactory.createType(evaluatedType, source, JSContext.INSTANCE);
                this.addType(type3);
                return;
            }
            this.setUnknownElement((PsiElement)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSPostfixExpression) {
            JSPostfixExpression postfixExpression = (JSPostfixExpression)rawqualifier;
            IElementType sign = postfixExpression.getOperationSign();
            if (JSTokenTypes.PLUSPLUS != sign) {
                if (JSTokenTypes.MINUSMINUS != sign) return;
            }
            if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                this.simpleEvalType(rawqualifier, postfixExpression.getExpression());
                return;
            }
            this.addNumericOperatorType(postfixExpression.getExpression(), null, rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)rawqualifier;
            IElementType sign = binaryExpression.getOperationSign();
            JSExpression rOperand = binaryExpression.getROperand();
            JSExpression lOperand = binaryExpression.getLOperand();
            if (lOperand == null) return;
            if (rOperand == null) return;
            this.processBinaryOperation(binaryExpression, sign, lOperand, rOperand);
            return;
        }
        if (rawqualifier instanceof JSLiteralExpression) {
            this.addTypeFromLiteralExpression(rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSArrayLiteralExpression) {
            JSType type4;
            JSArrayLiteralExpression literal = (JSArrayLiteralExpression)rawqualifier;
            if (!literal.isEmpty()) {
                type4 = this.getArrayTypeFromExpressions(literal, literal.getExpressionStream());
            } else {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                type4 = new JSArrayTypeImpl(JSAnyType.get((PsiElement)rawqualifier), typeSource);
            }
            this.addType(type4);
            return;
        }
        if (rawqualifier instanceof JSIndexedPropertyAccessExpression) {
            this.addType(this.getIndexedPropertyAccessType((JSIndexedPropertyAccessExpression)rawqualifier));
            return;
        }
        if (rawqualifier instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)rawqualifier, this.myContext.isAstAccessAllowed((PsiElement)rawqualifier));
            return;
        }
        if (rawqualifier instanceof JSParenthesizedExpression) {
            this.evaluateTypes(((JSParenthesizedExpression)rawqualifier).getInnerExpression());
            return;
        }
        if (rawqualifier instanceof JSThisExpression) {
            this.processThisQualifierExpression((JSThisExpression)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSSuperExpression) {
            JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)rawqualifier);
            this.processSuperQualifierExpression((JSSuperExpression)rawqualifier, jsClass);
            return;
        }
        if (rawqualifier instanceof JSFunctionExpression) {
            this.processFunction((JSFunctionExpression)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSConditionalExpression) {
            JSConditionalExpression conditionalExpression = (JSConditionalExpression)rawqualifier;
            JSExpression thenPart = (JSExpression)conditionalExpression.getThenBranch();
            JSExpression elsePart = (JSExpression)conditionalExpression.getElseBranch();
            JSType thenType = this.getConditionalPartTypeOrAny(conditionalExpression, thenPart);
            JSType elseType = this.getConditionalPartTypeOrAny(conditionalExpression, elsePart);
            if (thenType == null) {
                if (elseType == null) return;
            }
            JSType common = TypeScriptTypeRelations.getBestChoiceType(thenType, elseType, (PsiElement)conditionalExpression);
            this.addType(common);
            return;
        }
        if (rawqualifier instanceof JSEmptyExpression) {
            this.addType(JSNamedTypeFactory.createUndefinedType(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, false)));
            return;
        }
        if (this.evaluateDialectSpecificTypes(rawqualifier)) return;
        this.setUnknownElement((PsiElement)rawqualifier);
    }

    private void processBinaryOperation(@NotNull JSBinaryExpression binaryExpression, @Nullable IElementType sign, @Nullable JSExpression lOperand, @Nullable JSExpression rOperand) {
        if (binaryExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(21);
        }
        if (sign == JSTokenTypes.AS_KEYWORD) {
            this.resolveAsBinaryOperationExpression(binaryExpression, rOperand);
        } else if (JSTokenTypes.BOOLEAN_RESULT_OPERATIONS.contains(sign)) {
            this.addType(JSNamedTypeFactory.createBooleanPrimitiveType(JSTypeSourceFactory.createTypeSource((PsiElement)binaryExpression, true)));
        } else if (JSTokenTypes.ADDITIVE_OPERATIONS.contains(sign) || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign) || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.OROR || sign == JSTokenTypes.QUEST_QUEST || sign == JSTokenTypes.MULTMULT) {
            if (sign == JSTokenTypes.DIV || (sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.MINUS || sign == JSTokenTypes.MULTMULT || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign)) && !DialectDetector.isActionScript((PsiElement)binaryExpression)) {
                this.addNumericOperatorType(lOperand, rOperand, binaryExpression);
            } else {
                JSType lProcType = JSTypeUtils.getValuableType(this.getExpressionTypeInContext(lOperand), (PsiElement)lOperand);
                JSType rProcType = JSTypeUtils.getValuableType(this.getExpressionTypeInContext(rOperand), (PsiElement)rOperand);
                if (sign == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.QUEST_QUEST) {
                    this.evaluateAndOrOrType(binaryExpression, sign, lProcType, rProcType);
                } else {
                    this.evaluatePlusType(binaryExpression, lProcType, rProcType);
                }
            }
        } else if (JSElementTypes.ASSIGNMENT_OPERATIONS.contains(sign)) {
            JSTypeEvaluationResult result2 = null;
            if (lOperand instanceof JSDefinitionExpression) {
                lOperand = ((JSDefinitionExpression)lOperand).getExpression();
            }
            if (lOperand != null && DialectDetector.isActionScript((PsiElement)binaryExpression)) {
                result2 = this.getTypeEvaluationResultInContext((PsiElement)lOperand);
            }
            if (result2 == null) {
                result2 = this.getTypeEvaluationResultInContext((PsiElement)rOperand);
            }
            if (result2 != null) {
                for (JSEvaluationResultElement element : result2.getResults()) {
                    JSTypeEvaluator.addTypeEvaluationResultElement(element, this.myContext, this.myTypeProcessor);
                }
            } else {
                this.setUnknownElement((PsiElement)binaryExpression);
            }
        } else if (JSTokenTypes.SHIFT_OPERATIONS.contains(sign)) {
            this.simpleEvalType(binaryExpression, lOperand);
        }
    }

    protected JSType evaluateTypeFromInlineComment(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(22);
        }
        return JSDocumentationUtils.findTypeFromInlineComment((PsiElement)rawqualifier);
    }

    private void addNumericOperatorType(@Nullable JSExpression firstOperand, @Nullable JSExpression secondOperand, @NotNull JSExpression evaluatedExpression) {
        if (evaluatedExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(23);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)evaluatedExpression, true);
        JSType expressionType = this.getExpressionTypeInContext(firstOperand);
        if (expressionType instanceof JSBigIntType) {
            this.addType(JSNamedTypeFactory.createBigIntPrimitiveType(typeSource));
        } else {
            JSType otherExpressionType = this.getExpressionTypeInContext(secondOperand);
            if (otherExpressionType instanceof JSBigIntType) {
                this.addType(JSNamedTypeFactory.createBigIntPrimitiveType(typeSource));
            } else {
                this.addType(JSNamedTypeFactory.createNumberPrimitiveType(typeSource));
            }
        }
    }

    protected void evaluatePlusType(@NotNull JSBinaryExpression binaryExpression, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        JSType evaluatedType;
        if (binaryExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(24);
        }
        if ((evaluatedType = JSLocalTypeEvaluatorBase.evaluatePlusForExpandedTypes((PsiElement)binaryExpression, lProcType, rProcType)) != null) {
            this.addType(evaluatedType);
        } else {
            this.setUnknownElement((PsiElement)binaryExpression);
        }
    }

    protected void evaluateAndOrOrType(@NotNull JSExpression rawqualifier, @NotNull IElementType sign, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(25);
        }
        if (sign == null) {
            JSTypeEvaluator.$$$reportNull$$$0(26);
        }
        if (lProcType != null) {
            this.addType(lProcType);
        }
        if (rProcType != null) {
            this.addType(rProcType);
        }
        if (lProcType == null && rProcType == null) {
            this.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    @Nullable
    protected JSType getIndexedPropertyAccessType(@NotNull JSIndexedPropertyAccessExpression rawqualifier) {
        PsiElement resolve2;
        PsiReference reference;
        JSExpression qualifier;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(27);
        }
        if ((qualifier = rawqualifier.getQualifier()) == null) {
            return null;
        }
        JSExpression indexExpression = rawqualifier.getIndexExpression();
        if (DialectDetector.isJavaScript((PsiElement)rawqualifier) && indexExpression instanceof JSLiteralExpression && (reference = indexExpression.getReference()) instanceof JSLiteralTextReference && !JSResolveUtil.isDummyResolve((JSLiteralTextReference)reference) && (resolve2 = reference.resolve()) != null) {
            return JSCodeBasedTypeFactory.getPsiBasedType(resolve2, this.myContext);
        }
        JSPsiBasedTypeOfType qualifierType = JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)qualifier, this.myContext);
        JSType indexExpressionType = indexExpression == null ? null : (JSPsiImplUtils.isSymbolRef(indexExpression) || indexExpression instanceof JSReferenceExpression && ((JSReferenceExpression)indexExpression).getQualifier() == null ? JSResolveUtil.getExpressionJSType(indexExpression) : JSTypeEvaluator.getTypeFromConstant(indexExpression));
        return new JSApplyIndexedAccessType((JSType)qualifierType, indexExpressionType, rawqualifier);
    }

    private void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier) {
        JSClass jsClass;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(28);
        }
        JSClass jSClass = jsClass = JSResolveUtil.ownerHasExplicitThisParameter(rawqualifier) ? null : (JSClass)ObjectUtils.tryCast((Object)JSThisExpressionImpl.resolveThisContext((PsiElement)rawqualifier), JSClass.class);
        if (jsClass != null) {
            JSContext staticOrInstance = JSResolveUtil.calculateStaticFromContext((PsiElement)rawqualifier) ? JSContext.STATIC : JSContext.INSTANCE;
            this.processThisQualifierExpression(rawqualifier, jsClass, staticOrInstance);
        } else {
            PsiElement thisScope = JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)rawqualifier);
            this.processThisQualifierInExecutionScope(rawqualifier, thisScope);
        }
        JSTypeEvaluator.addAdditionalTypes((PsiElement)rawqualifier, rawqualifier, this.myTypeProcessor, this.myContext);
    }

    protected void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier, @NotNull JSClass jsClass, @NotNull JSContext staticOrInstance) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(29);
        }
        if (jsClass == null) {
            JSTypeEvaluator.$$$reportNull$$$0(30);
        }
        if (staticOrInstance == null) {
            JSTypeEvaluator.$$$reportNull$$$0(31);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
        this.addType(this.createTypeForThisExpression(staticOrInstance, jsClass, typeSource));
    }

    @NotNull
    protected JSType createTypeForThisExpression(@NotNull JSContext staticOrInstance, @NotNull JSClass jsClass, @NotNull JSTypeSource typeSource) {
        JSNamespace ns;
        if (staticOrInstance == null) {
            JSTypeEvaluator.$$$reportNull$$$0(32);
        }
        if (jsClass == null) {
            JSTypeEvaluator.$$$reportNull$$$0(33);
        }
        if (typeSource == null) {
            JSTypeEvaluator.$$$reportNull$$$0(34);
        }
        if ((ns = JSNamedTypeFactory.buildProvidedNamespace(jsClass, typeSource.isStrict())) == null) {
            ns = JSAnyType.get(typeSource);
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.copyWithJSContext(ns, staticOrInstance);
        if (jSNamespace == null) {
            JSTypeEvaluator.$$$reportNull$$$0(35);
        }
        return jSNamespace;
    }

    protected void processThisQualifierInExecutionScope(@NotNull JSThisExpression thisQualifier, PsiElement thisScope) {
        JSType typeFromParameter;
        if (thisQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(36);
        }
        if (thisScope instanceof FlowJSFunction && (typeFromParameter = TypeScriptPsiUtil.getThisParameterType((JSFunction)thisScope)) != null) {
            this.addType(typeFromParameter);
            return;
        }
        JSType type2 = JSDocumentationUtils.findContextType(thisScope);
        if (type2 != null) {
            this.addType(type2);
        } else {
            boolean added = JSContextResolver.resolveContext((PsiElement)thisQualifier, this.myContext, this.myTypeProcessor);
            if (!added && thisScope instanceof JSFunctionExpression && thisScope.getParent() instanceof JSArgumentList) {
                JSType thisType;
                JSType funcType = JSDialectSpecificHandlersFactory.findExpectedType((JSFunctionExpression)thisScope, this.getContextualExpectedTypeKind());
                if ((funcType = JSTypeUtils.getValuableType(funcType, thisScope)) instanceof JSFunctionTypeImpl && (thisType = ((JSFunctionTypeImpl)funcType).getThisType()) != null) {
                    this.addType(thisType);
                }
            }
            if (!added) {
                this.setUnknownElement((PsiElement)thisQualifier);
            }
        }
    }

    private void resolveAsBinaryOperationExpression(JSExpression rawqualifier, JSExpression rOperand) {
        JSType type2;
        PsiElement resolve2;
        boolean isClassCast = false;
        if (rOperand instanceof JSReferenceExpression && (resolve2 = ((JSReferenceExpression)rOperand).resolve()) instanceof JSVariable && (type2 = ((JSVariable)resolve2).getJSType()) instanceof JSNamedType && "Class".equals(type2.getTypeText(JSType.TypeTextFormat.SIMPLE))) {
            isClassCast = true;
        }
        if (isClassCast) {
            this.addType(JSAnyType.get((PsiElement)rawqualifier));
        } else {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rOperand, false);
            this.addType(JSTypeParser.createType(rOperand.getProject(), rOperand.getText(), source));
        }
    }

    protected void processSuperQualifierExpression(JSSuperExpression rawqualifier, @Nullable JSClass jsClass) {
        JSClass aClass;
        String name;
        JSClass[] classes;
        if (jsClass != null && (classes = jsClass.getSuperClasses()).length > 0 && (name = (aClass = classes[0]).getQualifiedName()) != null) {
            this.addType(JSNamedTypeFactory.createType(name, JSTypeSourceFactory.createTypeSource(aClass, false), JSContext.UNKNOWN));
        }
    }

    @Nullable
    private JSType getConditionalPartTypeOrAny(JSExpression conditionalExpression, JSExpression part) {
        JSType partType = null;
        if (part != null && (partType = this.getExpressionTypeInContext(part)) == null) {
            partType = JSAnyType.get((PsiElement)conditionalExpression);
        }
        return partType;
    }

    protected boolean isContextualOverloadEvaluation() {
        return this.myContext.isContextualOverloadEvaluation();
    }

    @Nullable
    protected JSType getExpressionTypeInContext(@Nullable JSExpression toEvaluate) {
        return JSResolveUtil.getElementJSType((PsiElement)toEvaluate, this.isContextualOverloadEvaluation());
    }

    @Nullable
    protected JSType getLazyExpressionTypeInContext(@Nullable JSExpression toEvaluate) {
        if (toEvaluate == null) {
            return null;
        }
        return JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)toEvaluate, this.myContext);
    }

    @Nullable
    protected JSTypeEvaluationResult getTypeEvaluationResultInContext(@Nullable PsiElement toEvaluate) {
        return toEvaluate == null ? null : JSEvaluationCache.getElementType(toEvaluate, this.myContext);
    }

    @NotNull
    protected JSType getArrayTypeFromExpressions(@NotNull JSArrayLiteralExpression rawQualifier, @NotNull Stream<JSExpression> expressions) {
        if (rawQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(37);
        }
        if (expressions == null) {
            JSTypeEvaluator.$$$reportNull$$$0(38);
        }
        List providers = expressions.map(el -> () -> JSTypeEvaluator.getTypeOrSpread(el, this.getExpressionTypeForArrayLiteral(rawQualifier, (JSExpression)el, null))).collect(Collectors.toList());
        JSType commonType = JSTypeUtils.getCommonType(providers, (PsiElement)rawQualifier, true);
        return new JSArrayTypeImpl(commonType, JSTypeSourceFactory.createTypeSource((PsiElement)rawQualifier, true));
    }

    @Nullable
    protected static JSType getTypeOrSpread(@NotNull JSExpression el, @Nullable JSType type2) {
        if (el == null) {
            JSTypeEvaluator.$$$reportNull$$$0(39);
        }
        if (el instanceof JSSpreadExpression) {
            return new JSSpreadTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)el, true), type2 == null ? JSAnyType.get((PsiElement)el) : type2);
        }
        return type2;
    }

    @Nullable
    protected JSType getExpressionTypeForArrayLiteral(@Nullable JSExpression arrayLiteralExpression, @Nullable JSExpression expression, @Nullable AtomicInteger typesToEvaluateLimit) {
        JSType exprType;
        JSType jSType = expression instanceof JSSpreadExpression ? this.getArrayElementTypeFromSpread((JSSpreadExpression)expression) : (exprType = expression != null ? JSTypeEvaluator.getTypeFromConstant(expression) : this.createNullType(arrayLiteralExpression));
        if (exprType == null && (typesToEvaluateLimit == null || typesToEvaluateLimit.decrementAndGet() >= 0)) {
            exprType = this.getLazyExpressionTypeInContext(expression);
        }
        return exprType;
    }

    @Nullable
    private JSType getArrayElementTypeFromSpread(@NotNull JSSpreadExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(40);
        }
        return this.getExpressionTypeInContext(expression.getExpression());
    }

    @NotNull
    protected JSType createNullType(@Nullable JSExpression rawqualifier) {
        JSType jSType = JSNamedTypeFactory.createType("null", JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true), JSContext.INSTANCE);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(41);
        }
        return jSType;
    }

    protected void addTypeFromLocalName(PsiNamedElement resolveResult) {
        String name = resolveResult.getName();
        if (name != null && DialectDetector.isJavaScript((PsiElement)resolveResult)) {
            JSNamespace ns = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(name, null), JSContext.STATIC, (PsiElement)resolveResult, false, true, true);
            this.addAdditionalType(ns);
        }
    }

    protected boolean evaluateDialectSpecificTypes(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(42);
        }
        return false;
    }

    protected void evaluateNewExpressionTypes(@NotNull JSNewExpression newExpression) {
        if (newExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(43);
        }
        this.addCodeBasedType(newExpression);
    }

    protected void evaluateCallExpressionTypes(@NotNull JSCallExpression callExpression) {
        JSClass jsClass;
        JSFunction parentFunction;
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(44);
        }
        if (callExpression instanceof JSNewExpression) {
            this.evaluateNewExpressionTypes((JSNewExpression)callExpression);
            return;
        }
        if (!this.myContext.isAstAccessAllowed((PsiElement)callExpression)) {
            JSExpression methodExpression = callExpression.getStubSafeMethodExpression();
            if (methodExpression != null) {
                JSPsiBasedTypeOfType methodExpressionType = JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)methodExpression, this.myContext);
                JSApplyCallType type2 = new JSApplyCallType((JSType)methodExpressionType, callExpression);
                this.addType(type2);
            }
            return;
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            boolean isTypeScript;
            JSReferenceExpression invoked = (JSReferenceExpression)methodExpression;
            String referencedName = invoked.getReferenceName();
            DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)callExpression);
            boolean bl = isTypeScript = dialect != null && dialect.isTypeScript;
            if ("create".equals(referencedName) && dialect != null && dialect.isJavaScript()) {
                boolean processed = this.processCreateMethodCall(callExpression, invoked);
                if (processed) {
                    return;
                }
            } else if (!isTypeScript && ("apply".equals(referencedName) || "call".equals(referencedName))) {
                methodExpression = JSTypeEvaluator.processApplyOrCallMethodCall(methodExpression, invoked);
            } else if (!isTypeScript && ("reduce".equals(referencedName) || "reduceRight".equals(referencedName))) {
                methodExpression = JSTypeEvaluator.processReduceMethodCall(methodExpression, invoked);
            } else {
                if (!this.processRequireMethodCall(callExpression)) {
                    return;
                }
                if (JSGclReferenceContributor.isGoogRequireCall(methodExpression)) {
                    this.addTypeFromGclRequireCall(callExpression);
                    return;
                }
            }
        }
        if (methodExpression instanceof JSSuperExpression && !DialectDetector.isTypeScript((PsiElement)callExpression) && (parentFunction = JSPsiImplUtils.getParentFunctionThroughLambdas((PsiElement)methodExpression)) != null && parentFunction.isConstructor() && (jsClass = JSResolveUtil.getClassOfContext(parentFunction)) != null) {
            this.addType(jsClass.getJSType());
        }
        if (methodExpression != null) {
            JSApplyCallType type3 = new JSApplyCallType((JSType)JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)methodExpression, this.myContext), JSTypeSourceFactory.createTypeSource((PsiElement)callExpression, true));
            this.addType(type3);
        }
    }

    private void addTypeFromGclRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(45);
        }
        JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withCombinedStrictness(DialectDetector.isTypeScript((PsiElement)callExpression)));
        boolean resolvedToModule = false;
        JSGclModuleReference reference = JSGclReferenceContributor.getGclModuleReference(callExpression);
        if (reference != null) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = reference.multiResolve(false)) {
                PsiFile file;
                PsiElement element = result2.getElement();
                if (!(element instanceof JSImplicitElement) || !"gcl".equals(((JSImplicitElement)element).getUserString()) || !((file = element.getContainingFile()) instanceof JSFile)) continue;
                resolvedToModule = true;
                this.addTypeFromExternalModuleReferenceResolveResult((PsiElement)file);
                List<JSPsiElementBase> exportsList = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit("exports", file);
                if (exportsList.size() != 1) continue;
                JSPsiElementBase exportElement = (JSPsiElementBase)exportsList.iterator().next();
                this.addTypeFromResolveResult((PsiElement)exportElement);
            }
            if (!resolvedToModule) {
                JSQualifiedName qName = reference.getQualifiedName();
                JSNamespace namespace = JSNamedTypeFactory.createNamespace(qName, JSContext.STATIC, reference.getElement(), true);
                reference.getElement();
                this.addAdditionalType(namespace);
            }
        }
        this.finishEvaluationWithContext(previousContext);
    }

    protected boolean processRequireMethodCall(@NotNull JSCallExpression callExpression) {
        JSExpression jSExpression;
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(46);
        }
        if (!callExpression.isRequireCall() || !this.getEvaluateContext().isAstAccessAllowed((PsiElement)callExpression)) {
            return true;
        }
        JSExpression[] arguments = callExpression.getArguments();
        if (JSAmdPsiUtil.isWithinAmdModule((PsiElement)callExpression) && (jSExpression = arguments[0]) instanceof JSLiteralExpression) {
            JSLiteralExpression amdModuleReference = (JSLiteralExpression)jSExpression;
            Collection<PsiElement> modules = CommonJSUtil.findReferencedModulesIfRequireCall(callExpression);
            if (!modules.isEmpty() && modules.size() <= JSRequireCallExpressionType.getMaxModulesToEvaluateCount()) {
                for (PsiElement module : modules) {
                    this.addTypeFromAmdModule(amdModuleReference, module);
                }
            }
            return true;
        }
        JSRequireCallExpressionType type2 = CommonJSUtil.getTypeIfRequireCall(callExpression);
        if (type2 != null) {
            this.addType(type2);
            return false;
        }
        return true;
    }

    private static JSExpression processReduceMethodCall(JSExpression methodExpression, JSReferenceExpression invoked) {
        Optional<JSExpression> first;
        JSExpression qualifier = invoked.getQualifier();
        if (qualifier instanceof JSArrayLiteralExpression && (first = ((JSArrayLiteralExpression)qualifier).getExpressionStream().findFirst()).isPresent()) {
            return first.get();
        }
        return methodExpression;
    }

    @NotNull
    private static JSExpression processApplyOrCallMethodCall(@NotNull JSExpression methodExpression, @NotNull JSReferenceExpression invoked) {
        JSExpression qualifier;
        if (methodExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(47);
        }
        if (invoked == null) {
            JSTypeEvaluator.$$$reportNull$$$0(48);
        }
        if ((qualifier = invoked.getQualifier()) != null) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = invoked.multiResolve(false)) {
                String fileName;
                PsiElement element = result2.getElement();
                if (element == null || !"ECMAScript.js2".equals(fileName = element.getContainingFile().getName()) && !JSCorePredefinedLibrariesProvider.isECMAScriptLibraryFileName(fileName)) continue;
                JSExpression jSExpression = qualifier;
                if (jSExpression == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(49);
                }
                return jSExpression;
            }
        }
        JSExpression jSExpression = methodExpression;
        if (jSExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(50);
        }
        return jSExpression;
    }

    private boolean processCreateMethodCall(@NotNull JSCallExpression callExpression, @NotNull JSReferenceExpression invoked) {
        JSType type2;
        JSFunctionItem functionItem;
        JSExpression[] arguments;
        JSExpression firstArgument;
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(51);
        }
        if (invoked == null) {
            JSTypeEvaluator.$$$reportNull$$$0(52);
        }
        JSExpression jSExpression = firstArgument = (arguments = callExpression.getArguments()).length > 0 ? arguments[0] : null;
        if (JSSymbolUtil.isAccurateReferenceExpressionName(invoked, "Object", "create")) {
            if (firstArgument != null) {
                JSLiteralExpression literalExpression;
                if (firstArgument instanceof JSLiteralExpression && (literalExpression = (JSLiteralExpression)firstArgument).isNullLiteral()) {
                    return false;
                }
                this.addType(JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)firstArgument, this.myContext.withCombinedStrictness(false)));
            }
            return true;
        }
        boolean hasExplicitReturnType = false;
        PsiElement resolve2 = invoked.resolve();
        if (resolve2 != null && (functionItem = JSPsiImplUtils.calculatePossibleFunction(resolve2, (PsiElement)invoked, true)) != null && JSTypeUtils.isStrictType(type2 = functionItem.getReturnType())) {
            hasExplicitReturnType = true;
        }
        if (!hasExplicitReturnType && (firstArgument instanceof JSLiteralExpression && ((JSLiteralExpression)firstArgument).isQuotedLiteral() || firstArgument instanceof JSReferenceExpression)) {
            String typeString;
            String string = typeString = firstArgument instanceof JSReferenceExpression ? JSQualifiedNameImpl.toString(JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)firstArgument))) : ((JSLiteralExpression)firstArgument).getStringValue();
            if (typeString != null) {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)firstArgument, false);
                JSType type3 = JSNamedTypeFactory.createType(typeString, typeSource, JSTypeContext.UNKNOWN);
                this.addType(type3);
            }
            return true;
        }
        return false;
    }

    public final void addTypeFromExternalModuleReferenceResolveResult(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        this.addTypeFromExternalModuleReferenceResolveResult(element, false);
    }

    public void addTypeFromExternalModuleReferenceResolveResult(@NotNull PsiElement resolve2, boolean fromRequire) {
        if (resolve2 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(53);
        }
        if (resolve2 instanceof PsiFile) {
            this.addType(new JSModuleTypeImpl((PsiFile)resolve2, fromRequire));
        } else if (ES6PsiUtil.isEmbeddedBlock(resolve2)) {
            this.addType(new JSModuleTypeImpl((JSEmbeddedContent)resolve2, fromRequire));
        } else {
            this.addTypeFromResolveResult(resolve2);
        }
    }

    @NotNull
    public JSEvaluateContext getEvaluateContext() {
        JSEvaluateContext jSEvaluateContext = this.myContext;
        if (jSEvaluateContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(54);
        }
        return jSEvaluateContext;
    }

    protected void runWithContext(@NotNull JSEvaluateContext context2, @NotNull Runnable runnable) {
        if (context2 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(55);
        }
        if (runnable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(56);
        }
        JSEvaluateContext previousContext = this.myContext;
        this.myContext = context2;
        runnable.run();
        this.myContext = previousContext;
    }

    @NotNull
    public JSEvaluateContext startEvaluationWithContext(@NotNull JSEvaluateContext context2) {
        if (context2 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(57);
        }
        JSEvaluateContext previousContext = this.myContext;
        this.myContext = context2;
        JSEvaluateContext jSEvaluateContext = previousContext;
        if (jSEvaluateContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(58);
        }
        return jSEvaluateContext;
    }

    public void finishEvaluationWithContext(@NotNull JSEvaluateContext previousContext) {
        if (previousContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(59);
        }
        this.myContext = previousContext;
    }

    protected boolean processFunction(@NotNull JSFunction function) {
        if (function == null) {
            JSTypeEvaluator.$$$reportNull$$$0(60);
        }
        if (!this.myContext.isAstAccessAllowed(function, true)) {
            this.addType(TypeScriptTypeParser.buildFunctionType(function));
            this.addTypeFromLocalName(function);
            return true;
        }
        if (function.isGetProperty()) {
            JSType typeFromExpression;
            JSType returnType2 = JSFunctionImpl.getReturnTypeInContext(function, (PsiElement)this.myContext.getProcessedExpression(), this.getContextualExpectedTypeKind());
            if ((returnType2 == null || returnType2 instanceof JSEvaluableOnlyType) && (typeFromExpression = this.getTypeFromReturnedExpression(function)) != null) {
                returnType2 = typeFromExpression;
            }
            if (returnType2 != null) {
                this.addType(returnType2);
            }
        } else if (function.isSetProperty()) {
            JSType parameterType = JSResolveUtil.getTypeFromSetAccessor(function);
            if (parameterType != null) {
                this.addType(parameterType);
            }
        } else if (DialectDetector.isTypeScript(function)) {
            JSType type2 = TypeScriptTypeParser.buildFunctionType(function);
            if (function instanceof JSOptionalOwner && ((JSOptionalOwner)((Object)function)).isOptional()) {
                type2 = JSTypeGuardUtil.wrapWithUndefined(type2, type2.getSource());
            }
            this.addType(type2);
        } else if (DialectDetector.isJavaScript(function)) {
            JSType constructorType;
            boolean canBeConstructorAndFunction;
            JSType returnType3;
            boolean isConstructorType;
            JSType functionType = JSApplyNewType.getTypeFromConstructorName(function, this.myContext, false, false);
            boolean bl = isConstructorType = functionType != null;
            if (functionType == null && (returnType3 = this.getTypeFromReturnedExpression(function)) != null) {
                functionType = TypeScriptTypeParser.buildFunctionTypeWithCustomReturnType(function, returnType3);
            }
            boolean bl2 = canBeConstructorAndFunction = functionType == null;
            if (functionType == null) {
                functionType = TypeScriptTypeParser.buildFunctionType(function);
            }
            this.addType(functionType);
            if (canBeConstructorAndFunction) {
                this.setUnknownElement(function);
            }
            if (!isConstructorType && (constructorType = JSApplyNewType.getTypeFromConstructorName(function, this.myContext, true, false)) != null) {
                this.addAdditionalType(constructorType);
            }
        } else {
            this.addType(JSNamedTypeFactory.createFunctionType(JSTypeSourceFactory.createTypeSource(function, false)));
        }
        return true;
    }

    @Nullable
    private JSType getTypeFromReturnedExpression(@NotNull JSFunction function) {
        JSTypeSource source;
        if (function == null) {
            JSTypeEvaluator.$$$reportNull$$$0(61);
        }
        if (!this.myContext.isAstAccessAllowed(function)) {
            return null;
        }
        JSExpression returnedExpression = JSPsiImplUtils.getReturnedExpressionIfSingle(function);
        if (returnedExpression == null) {
            return null;
        }
        JSType type2 = JSCodeBasedTypeFactory.getCodeBasedType(returnedExpression, true, this.myContext.isContextualOverloadEvaluation());
        JSTypeSource jSTypeSource = source = type2 != null ? type2.getSource() : JSTypeSourceFactory.createTypeSource(function, false);
        if (type2 == null) {
            type2 = JSAnyType.get(source);
        }
        if (function.isAsync()) {
            type2 = new JSAsyncReturnType(source, type2);
        }
        return type2;
    }

    private void processRefExpr(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(62);
        }
        new JSReferenceExpressionType(expression).evaluate(this.myContext).applyWithContext(this.myTypeProcessor, this.myContext);
    }

    public boolean addTypeFromResolveResult(String referenceName, ResolveResult resolveResult) {
        PsiElement element = resolveResult.getElement();
        if (element == null) {
            return true;
        }
        this.addTypeFromResolveResult(element);
        this.addLocalNamespaceFromImport(referenceName, resolveResult);
        return true;
    }

    protected void addLocalNamespaceFromImport(String referenceName, ResolveResult r) {
        ES6ImportExportDeclarationPart anImport;
        if (r instanceof JSResolveResult && (anImport = ((JSResolveResult)r).getES6Import()) instanceof ES6ImportExportSpecifier && Objects.equals(referenceName, anImport.getDeclaredName())) {
            JSNamespace nsFromImport = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(referenceName, null), JSContext.STATIC, (PsiElement)anImport, true, true, true);
            this.addAdditionalType(nsFromImport);
        }
    }

    protected final void addTypeFromResolveResult(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(63);
        }
        if (resolveResult instanceof JSArrayLiteralExpression) {
            return;
        }
        this.addType(JSCodeBasedTypeFactory.getPsiBasedType(resolveResult, this.myContext));
    }

    private void doAddTypeFromResolveResult(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(64);
        }
        this.startEvaluationWithContext(this.myContext.withSource(resolveResult));
        if (resolveResult instanceof TypeScriptProxyImplicitElementWithBackingItem) {
            resolveResult = ((TypeScriptProxyImplicitElementWithBackingItem)resolveResult).getBackingElement();
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            if (!(handler.addTypeFromResolveResult(this, this.myContext, resolveResult) | handler.addTypeFromResolveResult(this, resolveResult, false))) continue;
            return;
        }
        JSType alias = JSTypeEvaluator.findAliasTypeFromDocComment(resolveResult);
        if (alias != null) {
            this.addType(alias);
        }
        if (resolveResult instanceof JSEvaluableElement && ((JSEvaluableElement)resolveResult).evaluate(this.myContext, this.myTypeProcessor)) {
            return;
        }
        if (resolveResult instanceof JSFieldVariable) {
            this.addTypeFromVariableResolveResult((JSFieldVariable)resolveResult);
        } else {
            this.addTypeFromElementResolveResult(resolveResult);
        }
    }

    @Nullable
    public static JSType findAliasTypeFromDocComment(@NotNull PsiElement resolveResult) {
        String alias;
        JSDocComment docComment;
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(65);
        }
        if ((docComment = JSStubBasedPsiTreeUtil.findOwnDocComment(resolveResult)) != null && (alias = docComment.getAlias()) != null) {
            return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromQualifiedName(alias), JSContext.STATIC, (PsiElement)docComment);
        }
        return null;
    }

    protected void addTypeFromVariableResolveResult(@NotNull JSFieldVariable jsVariable) {
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(66);
        }
        this.addTypeFromVariableResolveResult(jsVariable, jsVariable.getJSType());
    }

    public void addTypeFromVariableResolveResult(@NotNull JSFieldVariable jsVariable, @Nullable JSType variableType) {
        JSNamespace namespace;
        boolean useAccurateTypeFromInitializer;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(67);
        }
        if (jsVariable instanceof JSParameter) {
            if (variableType == null && this.addTypeFromAmdModuleReference((JSParameter)jsVariable)) {
                return;
            }
            variableType = this.processParameterType((JSParameter)jsVariable, variableType);
        }
        JSReferenceExpression context2 = this.myContext.getProcessedExpression();
        boolean useMoreAccurateEvaluationForFrameworks = variableType instanceof JSEvaluableOnlyType && context2 != null && ContainerUtil.exists((Iterable)JSFrameworkSpecificHandler.EP_NAME.allForLanguage(context2.getLanguage()), it -> it.useMoreAccurateEvaluation((PsiElement)context2));
        boolean useMoreAccurateEvaluation = useMoreAccurateEvaluationForFrameworks || variableType != null && variableType.isJavaScript() && !jsVariable.requiresTypeChecking() && this.myContext.isAstAccessAllowed((PsiElement)jsVariable);
        boolean useVariableType = variableType != null && !useMoreAccurateEvaluation;
        boolean bl = useAccurateTypeFromInitializer = !useVariableType && (this.myContext.isAstAccessAllowed((PsiElement)jsVariable) || useMoreAccurateEvaluation);
        if (useVariableType) {
            this.addType(variableType);
        } else if (useAccurateTypeFromInitializer && (variableType = this.addTypeFromVariableInitializer(jsVariable, variableType, useMoreAccurateEvaluationForFrameworks)) == null) {
            this.addTypeForAutoTypeVariable(jsVariable);
        }
        if ((!useVariableType || (variableType instanceof JSCodeBasedType || variableType instanceof JSRecordType) && variableType.isJavaScript() || JSTypeUtils.isNewPropertiesDefinitionAllowed(variableType, false)) && (namespace = JSNamedTypeFactory.buildProvidedNamespace(jsVariable, false)) != null) {
            this.addAdditionalType(namespace);
        }
    }

    private void addTypeForAutoTypeVariable(@NotNull JSFieldVariable variable) {
        if (variable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(68);
        }
        if (JSTypeGuardUtil.isAutoTypeField((PsiElement)variable)) {
            JSType typeFromGuard = JSTypeGuardEvaluator.applyToResolveResultType(null, (PsiElement)variable, this.myContext);
            this.addType(Objects.requireNonNullElseGet(typeFromGuard, () -> JSAnyType.get((PsiElement)variable)));
        }
    }

    @Nullable
    private JSType addTypeFromVariableInitializer(@NotNull JSFieldVariable jsVariable, @Nullable JSType variableType, boolean useAccurateType) {
        JSDestructuringContext destructuringContext;
        JSInitializerOwner initializerOwner;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(69);
        }
        JSExpression initializer = (initializerOwner = (destructuringContext = JSTypeEvaluator.findDestructuringParents(jsVariable)).getOuterElement()) != null ? (JSExpression)JSStubBasedPsiTreeUtil.forceAllowTreeLoading(initializerOwner.getContainingFile(), () -> initializerOwner.getInitializer()) : null;
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)jsVariable);
        if (isTypeScript && initializerOwner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)((Object)initializerOwner)).getTypeElement() != null) {
            JSType type2 = ((JSTypeDeclarationOwner)((Object)initializerOwner)).getJSType();
            this.addType(destructuringContext.applyToOuterType(type2));
        } else if (initializer != null) {
            JSType typeFromInitializer;
            JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withCombinedStrictness(!(jsVariable instanceof JSVariable) || JavaScriptTypeHelper.isStrictInitializer((PsiElement)jsVariable)));
            JSType jSType = typeFromInitializer = useAccurateType ? JSResolveUtil.getExpressionJSType(initializer) : this.getTypeFromInitializer(initializer);
            if (typeFromInitializer != null) {
                this.addType(destructuringContext.applyToOuterType(typeFromInitializer));
            }
            this.finishEvaluationWithContext(previousContext);
        } else if (variableType == null && jsVariable instanceof JSVariable && JSTypeEvaluator.isForStatementDeclaration((JSVariable)jsVariable)) {
            PsiElement forOf = JSResolveUtil.findParent((PsiElement)jsVariable);
            List<JSType> types = this.getLoopVariableTypes(expression, (PsiElement)jsVariable, (JSForInStatement)forOf);
            for (JSType type3 : types) {
                this.addType(destructuringContext.applyToOuterType(type3));
            }
            variableType = (JSType)ContainerUtil.getFirstItem(types);
        } else if (variableType != null) {
            this.addType(variableType);
        }
        return variableType;
    }

    @Nullable
    private JSType processParameterType(@NotNull JSParameter jsVariable, JSType variableType) {
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(70);
        }
        if (variableType == null && this.myContext.isAstAccessAllowed((PsiElement)jsVariable)) {
            variableType = JSContextTypeEvaluator.getParameterType(jsVariable, this.myContext, this.getContextualExpectedTypeKind());
        }
        if (jsVariable.isRest()) {
            if (!(variableType instanceof JSRestTypeImpl)) {
                JSTypeSource typeSource = variableType != null && variableType.getSourceElement() != null ? variableType.getSource() : JSTypeSourceFactory.createTypeSource((PsiElement)jsVariable, jsVariable.getTypeDecorator().isExplicitlyDeclared());
                variableType = new JSArrayTypeImpl(variableType, typeSource);
            } else {
                variableType = ((JSRestTypeImpl)variableType).getIterableType();
            }
        }
        return this.substituteThisType(variableType, jsVariable);
    }

    @NotNull
    public static JSDestructuringContext findDestructuringParents(@NotNull JSFieldVariable jsVariable) {
        JSDestructuringContext context2;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(71);
        }
        if (DialectDetector.isTypeScript((PsiElement)jsVariable) && (context2 = JSDestructuringContext.findDestructuringParents((PsiElement)jsVariable, WITH_TYPE_DECLARATION_PREDICATE)).getOuterElement() != null) {
            JSDestructuringContext jSDestructuringContext = context2;
            if (jSDestructuringContext == null) {
                JSTypeEvaluator.$$$reportNull$$$0(72);
            }
            return jSDestructuringContext;
        }
        JSDestructuringContext jSDestructuringContext = JSDestructuringContext.findDestructuringParents((PsiElement)jsVariable, JSInitializerOwner::hasOwnInitializer);
        if (jSDestructuringContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(73);
        }
        return jSDestructuringContext;
    }

    private static boolean isForStatementDeclaration(@NotNull JSVariable jsVariable) {
        PsiElement forOfCandidate;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(74);
        }
        return (forOfCandidate = JSResolveUtil.findParent((PsiElement)jsVariable)) instanceof JSForInStatement && PsiTreeUtil.isAncestor((PsiElement)((JSForInStatement)forOfCandidate).getVarDeclaration(), (PsiElement)jsVariable, (boolean)true);
    }

    @Nullable
    private JSType getTypeFromInitializer(@Nullable JSExpression initializer) {
        if (initializer == null) {
            return null;
        }
        if (DialectDetector.isTypeScript((PsiElement)initializer)) {
            return this.getExpressionTypeInContext(initializer);
        }
        JSType type2 = JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)initializer, this.myContext);
        if (JSTypeEvaluator.isEmptyJSObjectLiteral(initializer)) {
            type2 = type2.copyWithStrict(false);
        }
        return type2;
    }

    public static boolean isEmptyJSObjectLiteral(@NotNull JSExpression initializer) {
        if (initializer == null) {
            JSTypeEvaluator.$$$reportNull$$$0(75);
        }
        return DialectDetector.isJavaScript((PsiElement)initializer) && initializer instanceof JSObjectLiteralExpression && ((JSObjectLiteralExpression)initializer).isEmpty();
    }

    private void evaluateDestructuringContainer(@NotNull JSDestructuringContainer destructuringContainer) {
        JSType type2;
        JSDestructuringContext destructuringContext;
        JSInitializerOwner owner;
        if (destructuringContainer == null) {
            JSTypeEvaluator.$$$reportNull$$$0(76);
        }
        if ((owner = (destructuringContext = JSDestructuringContext.findDestructuringParents((PsiElement)destructuringContainer, e -> e.hasOwnInitializer() || JSTypeEvaluator.isApplicableTypeDeclaration(e) || e instanceof JSParameterListElement)).getOuterElement()) == null) {
            return;
        }
        JSType typeFromDestructuringInLoop = this.getTypeFromDestructuringInLoop(owner);
        if (typeFromDestructuringInLoop != null) {
            this.addType(destructuringContext.applyToOuterType(typeFromDestructuringInLoop));
            return;
        }
        if (WITH_TYPE_DECLARATION_PREDICATE.test(owner) && (type2 = ((JSTypeDeclarationOwner)((Object)owner)).getJSType()) != null) {
            this.addType(destructuringContext.applyToOuterType(type2));
        }
        if (owner.hasOwnInitializer()) {
            JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withCombinedStrictness(DialectDetector.isTypeScript((PsiElement)owner)));
            JSType typeFromInitializer = this.getTypeFromInitializer((JSExpression)JSStubBasedPsiTreeUtil.forceAllowTreeLoading(owner.getContainingFile(), () -> owner.getInitializer()));
            if (typeFromInitializer != null) {
                this.addType(destructuringContext.applyToOuterType(typeFromInitializer));
            }
            this.finishEvaluationWithContext(previousContext);
        }
        if (owner instanceof JSParameterListElement) {
            JSType parameterType;
            if (destructuringContext.isEmpty()) {
                for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
                    if (!handler.addTypeFromResolveResult(this, this.myContext, (PsiElement)owner)) continue;
                    return;
                }
            }
            if ((parameterType = JSContextTypeEvaluator.getParameterType((JSParameterListElement)owner, this.myContext, JSExpectedTypeKind.EXPECTED)) != null) {
                this.addType(destructuringContext.applyToOuterType(parameterType));
            }
        }
    }

    @Nullable
    private JSType getTypeFromDestructuringInLoop(JSInitializerOwner owner) {
        PsiElement parent = owner.getParent();
        if (!(parent instanceof JSVarStatement)) {
            return null;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof JSForInStatement) || !((JSForInStatement)grandParent).isForEach()) {
            return null;
        }
        JSExpression expression = ((JSForInStatement)grandParent).getCollectionExpression();
        if (expression == null) {
            return null;
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)owner, true);
        JSPsiBasedTypeOfType expressionType = JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)expression, this.myContext);
        return new JSIterableComponentTypeImpl(expressionType, source);
    }

    private static boolean isApplicableTypeDeclaration(JSInitializerOwner e) {
        if (!(e instanceof JSTypeDeclarationOwner)) {
            return false;
        }
        if (WITH_TYPE_DECLARATION_PREDICATE.test(e)) {
            return true;
        }
        PsiElement parent = e.getParent();
        if (!(parent instanceof JSVarStatement)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        return grandParent instanceof JSForInStatement && ((JSForInStatement)grandParent).isForEach();
    }

    protected JSType substituteThisType(@Nullable JSType type2, @NotNull JSFieldVariable jsVariable) {
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(77);
        }
        return type2;
    }

    protected boolean addTypeFromAmdModuleReference(@NotNull JSParameter parameter) {
        if (parameter == null) {
            JSTypeEvaluator.$$$reportNull$$$0(78);
        }
        boolean result2 = false;
        if (!this.myContext.isAstAccessAllowed((PsiElement)parameter)) {
            return false;
        }
        JSLiteralExpression amdModuleReference = JSSymbolUtil.getParameterInitializationIfRequireArgument(parameter);
        if (amdModuleReference != null) {
            PsiReference[] references = amdModuleReference.getReferences();
            Collection<PsiElement> modules = JSFileReferencesUtil.getMostPriorityModules((PsiElement)parameter, references);
            for (PsiElement resolve2 : modules) {
                result2 |= this.addTypeFromAmdModule(amdModuleReference, resolve2);
            }
        }
        return result2;
    }

    private boolean addTypeFromAmdModule(@NotNull JSLiteralExpression amdModuleReference, @NotNull PsiElement resolve2) {
        if (amdModuleReference == null) {
            JSTypeEvaluator.$$$reportNull$$$0(79);
        }
        if (resolve2 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(80);
        }
        boolean result2 = false;
        JSFunctionExpression moduleInitializer = null;
        if (resolve2 instanceof JSFile) {
            JSFunctionExpression amdModule = JSAmdModulesIndex.findDefaultAmdModule((JSFile)resolve2);
            if (amdModule != null) {
                moduleInitializer = amdModule;
            } else {
                this.addTypeFromExternalModuleReferenceResolveResult(resolve2, true);
            }
            result2 = true;
        } else if (resolve2 instanceof JSFunctionExpression) {
            moduleInitializer = (JSFunctionExpression)resolve2;
            JSType type2 = JSNamedTypeFactory.createType(JSAmdPsiUtil.unifyModuleName(amdModuleReference), JSTypeSourceFactory.createTypeSource(resolve2, true), JSContext.STATIC);
            this.addType(type2);
            result2 = true;
        }
        if (moduleInitializer != null) {
            this.addType(new JSApplyCallType((JSType)JSCodeBasedTypeFactory.getPsiBasedType(moduleInitializer, this.myContext), JSTypeSourceFactory.createTypeSource((PsiElement)amdModuleReference, true)));
            this.addExportsNamespace(moduleInitializer);
        }
        return result2;
    }

    private void addExportsNamespace(@NotNull PsiElement source) {
        if (source == null) {
            JSTypeEvaluator.$$$reportNull$$$0(81);
        }
        JSNamespace exportsNamespace = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create("exports", null), JSContext.STATIC, source, true, false, true);
        this.addAdditionalType(exportsNamespace);
    }

    protected void evaluateTypes(@Nullable JSExpression expression) {
        if (expression == null) {
            return;
        }
        this.addType(JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)expression, this.myContext));
    }

    public void doEvaluateTypesStubSafely(JSExpression expression) {
        if (expression instanceof JSFunction) {
            this.processFunction((JSFunction)((Object)expression));
        } else if (expression instanceof JSCallExpression) {
            this.evaluateCallExpressionTypes((JSCallExpression)expression);
        } else if (expression instanceof JSClassExpression) {
            this.addTypeFromClassExpression((JSClassExpression)expression);
        } else if (expression instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)expression, false);
        }
    }

    public void addTypeFromClassExpression(JSClassExpression classExpression) {
    }

    protected void addTypeFromElementResolveResult(@Nullable PsiElement resolveResult) {
        if (resolveResult instanceof TypeScriptMergedTypeImplicitElement) {
            this.addTypeFromMergedElementResolveResult((TypeScriptMergedTypeImplicitElement)resolveResult);
        } else if (resolveResult instanceof JSImplicitElement) {
            JSImplicitElement implicitElement = (JSImplicitElement)resolveResult;
            this.addTypeFromImplicitElementResolveResult(implicitElement);
        } else if (resolveResult instanceof JSProperty) {
            this.addTypeFromProperty((JSProperty)resolveResult);
        } else if (resolveResult instanceof JSClass) {
            this.addTypeFromClassCandidate((JSClass)resolveResult);
        } else if (resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor() && resolveResult.getContext() instanceof JSClass) {
            this.addTypeFromClassCandidate((JSClass)resolveResult.getContext());
        } else if (resolveResult instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)resolveResult, false);
        } else if (resolveResult instanceof JSDefinitionExpression) {
            JSType parameterType = null;
            PsiElement resolveResultParent = resolveResult.getContext();
            if (resolveResultParent instanceof JSForInStatement && resolveResult == ((JSForInStatement)resolveResultParent).getVariableExpression()) {
                List<JSType> types = this.getLoopVariableTypes(this.myContext.getProcessedExpression(), resolveResult, (JSForInStatement)resolveResultParent);
                for (JSType type2 : types) {
                    this.addType(type2);
                }
                parameterType = (JSType)ContainerUtil.getFirstItem(types);
            }
            if (parameterType == null) {
                this.addTypeFromDefExpr((JSDefinitionExpression)resolveResult);
            }
        } else if (resolveResult instanceof JSFunction) {
            this.processFunction((JSFunction)resolveResult);
        } else if (resolveResult instanceof JSNamedElement) {
            String name = JSTypeEvaluator.getElementQName((JSNamedElement)resolveResult);
            if (name != null) {
                JSType jsType = JSNamedTypeFactory.createType(name, JSTypeSourceFactory.createTypeSource(resolveResult, false), JSContext.STATIC);
                this.addType(jsType);
            }
        } else if (resolveResult instanceof JSLiteralExpression) {
            this.addTypeFromLiteralExpression((JSExpression)resolveResult);
        } else if (resolveResult instanceof JsonElement) {
            this.addType(JsonElementType.createJsonElementType((JsonElement)resolveResult, null));
        } else if (resolveResult instanceof StylesheetFile) {
            this.addType(new JSCustomElementType(resolveResult));
        } else if (resolveResult instanceof PsiFile || ES6PsiUtil.isEmbeddedBlock(resolveResult)) {
            this.addTypeFromExternalModuleReferenceResolveResult(resolveResult);
        }
    }

    private void addTypeFromImplicitElementResolveResult(@NotNull JSImplicitElement resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(82);
        }
        boolean typeAdded = false;
        if (resolveResult instanceof JSLocalImplicitElementImpl) {
            this.addType(resolveResult.getJSType());
            return;
        }
        JSType type2 = resolveResult.getJSType();
        if (type2 != null) {
            this.addType(type2);
            typeAdded = true;
        }
        JSNamespace namespace = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedNamedElement(resolveResult), JSContext.STATIC, (PsiElement)resolveResult, resolveResult.isNamespaceExplicitlyDeclared());
        if (!typeAdded && resolveResult.getType().providesNamespace()) {
            this.addType(namespace);
        } else {
            this.addAdditionalType(namespace);
        }
    }

    private void addTypeFromMergedElementResolveResult(TypeScriptMergedTypeImplicitElement resolveResult) {
        JSType jsType = resolveResult.getJSType();
        if (resolveResult.isOptional() && jsType != null) {
            jsType = JSTypeGuardUtil.wrapWithUndefined(jsType, jsType.getSource());
        }
        this.addType(jsType);
    }

    private void addTypeFromProperty(@NotNull JSProperty property) {
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(83);
        }
        boolean skipEvaluatingProps = false;
        boolean hasType = false;
        JSType jsType = property.getJSType();
        if (jsType != null) {
            this.addType(jsType);
            hasType = true;
            boolean bl = skipEvaluatingProps = !JSTypeUtils.isNewPropertiesDefinitionAllowed(jsType, false);
        }
        if (!skipEvaluatingProps) {
            JSDocComment docComment;
            JSNamespace type2;
            JSFunction functionInitializer = property.tryGetFunctionInitializer();
            JSObjectLiteralExpression objectLiteralExpression = property.getObjectLiteralExpressionInitializer();
            boolean providesNamespace = functionInitializer != null && !functionInitializer.isGetProperty() && !functionInitializer.isSetProperty() || objectLiteralExpression != null;
            boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)property);
            if (!isTypeScript && providesNamespace && (type2 = JSNamedTypeFactory.buildProvidedNamespace(property, (docComment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)property)) != null && docComment.isClassExplicitly())) != null) {
                this.addAdditionalType(type2);
            }
            if (!hasType) {
                JSExpression value;
                if (functionInitializer != null || objectLiteralExpression != null) {
                    if (functionInitializer != null) {
                        if (functionInitializer == property) {
                            this.processFunction(functionInitializer);
                        } else {
                            this.addType(JSCodeBasedTypeFactory.getPsiBasedType(functionInitializer, this.myContext));
                        }
                    } else {
                        this.addTypeFromObjectLiteralExpression(objectLiteralExpression, false);
                    }
                } else if (this.myContext.isFromCurrentFile((PsiElement)property) && (value = property.getValue()) != null) {
                    this.evaluateTypes(value);
                }
            }
        }
    }

    protected void addTypeFromClassCandidate(@NotNull JSClass resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(84);
        }
    }

    @NotNull
    private List<JSType> getLoopVariableTypes(@Nullable JSReferenceExpression expression, @NotNull PsiElement element, @Nullable JSForInStatement forInStatement) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(85);
        }
        if (forInStatement == null) {
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                JSTypeEvaluator.$$$reportNull$$$0(86);
            }
            return list;
        }
        if (forInStatement.isForEach()) {
            List types = this.getComponentTypeFromArrayExpression(expression, forInStatement.getCollectionExpression());
            if (forInStatement.isForAwait()) {
                types = ContainerUtil.map(types, t -> new JSUnwrapPromiseType((JSType)t, t.getSource()));
            }
            List list = types;
            if (list == null) {
                JSTypeEvaluator.$$$reportNull$$$0(87);
            }
            return list;
        }
        List<JSType> list = Collections.singletonList(new JSForInStringType(JSTypeSourceFactory.createTypeSource(element, true), JSTypeContext.INSTANCE));
        if (list == null) {
            JSTypeEvaluator.$$$reportNull$$$0(88);
        }
        return list;
    }

    @Nullable
    public final JSType addComponentTypeFromArrayExpression(@Nullable JSExpression rawqualifier, @Nullable JSExpression collectionExpression) {
        List<JSType> types = this.getComponentTypeFromArrayExpression(rawqualifier, collectionExpression);
        for (JSType type2 : types) {
            this.addType(type2);
        }
        return types.size() == 1 ? (JSType)ContainerUtil.getFirstItem(types) : null;
    }

    @NotNull
    public List<JSType> getComponentTypeFromArrayExpression(@Nullable JSExpression rawqualifier, @Nullable JSExpression collectionExpression) {
        JSLiteralExpression literalExpression;
        JSIndexedPropertyAccessExpression indexedPropertyAccessExpression;
        JSExpression indexExpression;
        if (collectionExpression == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSTypeEvaluator.$$$reportNull$$$0(89);
            }
            return list;
        }
        JSType collectionType = JSResolveUtil.getExpressionJSType(collectionExpression);
        JSType type2 = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(collectionType, (PsiElement)collectionExpression);
        int index = -1;
        if (rawqualifier instanceof JSIndexedPropertyAccessExpression && (indexExpression = (indexedPropertyAccessExpression = (JSIndexedPropertyAccessExpression)rawqualifier).getIndexExpression()) instanceof JSLiteralExpression && (literalExpression = (JSLiteralExpression)indexExpression).isNumericLiteral()) {
            BigInteger bigInteger;
            Long longValue;
            Object value = literalExpression.getValue();
            assert (value instanceof Double || value instanceof Long || value instanceof BigInteger) : indexExpression.getText();
            if (value instanceof Long && (longValue = (Long)value) >= 0L && longValue <= Integer.MAX_VALUE) {
                index = Math.toIntExact(longValue);
            } else if (value instanceof BigInteger && (bigInteger = (BigInteger)value).compareTo(BigInteger.ZERO) >= 0 && bigInteger.compareTo(JSLiteralExpressionImpl.INT_MAX_VALUE_AS_BIGINT) <= 0) {
                index = bigInteger.intValueExact();
            }
        }
        if (type2 instanceof JSTupleType) {
            JSTupleType tupleType = (JSTupleType)type2;
            if (index >= 0) {
                JSType t = tupleType.getTypeByIndex(index);
                List<JSType> list = Collections.singletonList(t != null ? t : JSNamedTypeFactory.createUndefinedType(type2.getSource()));
                if (list == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(90);
                }
                return list;
            }
        }
        List<JSType> list = this.getComponentTypeFromProcessor(rawqualifier, type2);
        if (list == null) {
            JSTypeEvaluator.$$$reportNull$$$0(91);
        }
        return list;
    }

    @Nullable
    public final JSType addComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type2) {
        List<JSType> types = this.getComponentTypeFromProcessor(rawqualifier, type2);
        for (JSType jsType : types) {
            if (type2 == null) continue;
            this.addType(jsType);
        }
        return types.size() == 1 ? (JSType)ContainerUtil.getFirstItem(types) : null;
    }

    @NotNull
    protected List<JSType> getComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type2) {
        SmartList result2 = this.getComponentTypeWithExpandingComposite(rawqualifier, type2);
        SmartList smartList = result2.isEmpty() ? new SmartList((Object)JSAnyType.get((PsiElement)rawqualifier)) : result2;
        if (smartList == null) {
            JSTypeEvaluator.$$$reportNull$$$0(92);
        }
        return smartList;
    }

    @NotNull
    protected final List<JSType> getComponentTypeWithExpandingComposite(@Nullable JSExpression rawqualifier, @Nullable JSType type2) {
        if ((type2 = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type2, (PsiElement)rawqualifier)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSTypeEvaluator.$$$reportNull$$$0(93);
            }
            return list;
        }
        if (type2 instanceof JSUnionType) {
            ArrayList<JSType> result2 = new ArrayList<JSType>();
            for (JSType typeOption : ((JSUnionType)type2).getTypes()) {
                result2.addAll(this.getComponentTypeFromProcessor(rawqualifier, typeOption));
            }
            ArrayList<JSType> arrayList = result2;
            if (arrayList == null) {
                JSTypeEvaluator.$$$reportNull$$$0(94);
            }
            return arrayList;
        }
        JSTypeSource prevSource = type2.getSource();
        if ((type2 = JSTypeUtils.getIndexableComponentType(type2, true, false)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSTypeEvaluator.$$$reportNull$$$0(95);
            }
            return list;
        }
        type2 = JSTypeUtils.copyWithStrict(type2, prevSource.isStrict() && type2.isSourceStrict());
        List<JSType> list = Collections.singletonList(type2);
        if (list == null) {
            JSTypeEvaluator.$$$reportNull$$$0(96);
        }
        return list;
    }

    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawQualifier) {
        JSType type2;
        if (rawQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(97);
        }
        if ((type2 = JSTypeEvaluator.getTypeFromConstant(rawQualifier)) != null) {
            this.addType(type2);
        } else {
            this.setUnknownElement((PsiElement)rawQualifier);
        }
    }

    @Nullable
    public static JSType getTypeFromConstant(@NotNull JSExpression rawqualifier) {
        IElementType constantType;
        IElementType sign;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(98);
        }
        if (rawqualifier instanceof JSEmptyExpression) {
            return JSTypeEvaluator.createConstantNamedType("undefined", rawqualifier);
        }
        if (rawqualifier instanceof JSPrefixExpression && ((sign = ((JSPrefixExpression)rawqualifier).getOperationSign()) == JSTokenTypes.PLUS || sign == JSTokenTypes.MINUS)) {
            JSExpression expression = ((JSPrefixExpression)rawqualifier).getExpression();
            if (expression != null) {
                JSType innerType = JSTypeEvaluator.getTypeFromConstant(expression);
                if (innerType instanceof JSNumberLiteralTypeImpl || innerType instanceof JSBigIntLiteralTypeImpl) {
                    JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, innerType.isSourceStrict());
                    if (sign == JSTokenTypes.MINUS) {
                        boolean allowWidening = ((JSTypeWithWidening)innerType).allowWidening();
                        innerType = innerType instanceof JSNumberLiteralTypeImpl ? new JSNumberLiteralTypeImpl(-((JSNumberLiteralTypeImpl)innerType).getLiteral().doubleValue(), allowWidening, typeSource, "-" + ((JSNumberLiteralTypeImpl)innerType).getValueAsString()) : new JSBigIntLiteralTypeImpl(((JSBigIntLiteralTypeImpl)innerType).getLiteral().negate(), allowWidening, typeSource, "-" + ((JSBigIntLiteralTypeImpl)innerType).getValueAsString());
                    }
                    return innerType.withNewSource(typeSource);
                }
                if (innerType instanceof JSNumberType || innerType instanceof JSBigIntType) {
                    return innerType;
                }
            }
            return JSTypeEvaluator.createConstantNamedType("number", rawqualifier);
        }
        ASTNode childNode = rawqualifier.getNode().getFirstChildNode();
        IElementType iElementType = constantType = childNode != null ? childNode.getElementType() : null;
        if (constantType == JSTokenTypes.XML_START_TAG_START || constantType == JSTokenTypes.XML_START_TAG_LIST) {
            if (DialectDetector.isTypeScript((PsiElement)rawqualifier) || DialectDetector.isJSX((PsiElement)rawqualifier)) {
                return null;
            }
            String type2 = constantType == JSTokenTypes.XML_START_TAG_START ? "XML" : "XMLList";
            return JSTypeEvaluator.createConstantNamedType(type2, rawqualifier);
        }
        if (JSSymbolUtil.isUndefinedExpression(rawqualifier)) {
            if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                return null;
            }
            return JSTypeEvaluator.createConstantNamedType("undefined", rawqualifier);
        }
        if (!(rawqualifier instanceof JSLiteralExpression)) {
            return null;
        }
        JSLiteralExpression literalExpression = (JSLiteralExpression)rawqualifier;
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
        JSLiteralExpressionKind kind = literalExpression.getExpressionKind(false);
        switch (kind) {
            case TEMPLATE_WITH_ARGS: {
                if (rawqualifier instanceof JSStringTemplateExpression && DialectDetector.isTypeScript((PsiElement)rawqualifier) && (JSWidenType.isConstContextSimple((PsiElement)rawqualifier) || JSWidenType.canBeInGenericConstContext(rawqualifier))) {
                    return null;
                }
            }
            case QUOTED: 
            case TEMPLATE_NO_ARGS: {
                return JSTypeEvaluator.createStringType(literalExpression, typeSource);
            }
            case REGEXP: {
                return JSTypeEvaluator.createConstantNamedType("RegExp", rawqualifier);
            }
            case TRUE: 
            case FALSE: {
                if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    return JSTypeEvaluator.createConstantNamedType("boolean", rawqualifier);
                }
                return new JSBooleanLiteralTypeImpl(kind == JSLiteralExpressionKind.TRUE, true, typeSource);
            }
            case NULL: {
                if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    return JSAnyType.get((PsiElement)rawqualifier);
                }
                return JSTypeEvaluator.createConstantNamedType("null", rawqualifier);
            }
        }
        if (kind.isNumeric()) {
            Object value = literalExpression.getValue();
            if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                return value instanceof Long ? JSTypeEvaluator.createConstantNamedType("int", rawqualifier) : JSTypeEvaluator.createConstantNamedType("number", rawqualifier);
            }
            if (value instanceof BigInteger) {
                return new JSBigIntLiteralTypeImpl((BigInteger)value, true, typeSource, literalExpression.getText());
            }
            if (value instanceof Long) {
                value = ((Long)value).doubleValue();
            }
            if (value != null) {
                return new JSNumberLiteralTypeImpl((Double)value, true, typeSource, literalExpression.getText());
            }
            return JSTypeEvaluator.createConstantNamedType("number", rawqualifier);
        }
        return null;
    }

    @NotNull
    protected static JSType createStringType(@NotNull JSLiteralExpression literalExpression, @NotNull JSTypeSource typeSource) {
        if (literalExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(99);
        }
        if (typeSource == null) {
            JSTypeEvaluator.$$$reportNull$$$0(100);
        }
        if (literalExpression.getTextLength() > 4096) {
            JSStringType jSStringType = JSNamedTypeFactory.createStringPrimitiveType(typeSource);
            if (jSStringType == null) {
                JSTypeEvaluator.$$$reportNull$$$0(101);
            }
            return jSStringType;
        }
        String value = literalExpression.getStringValue();
        if (value != null) {
            return new JSStringLiteralTypeImpl(value, true, typeSource);
        }
        return JSTypeEvaluator.createConstantNamedType("string", literalExpression);
    }

    @NotNull
    private static JSType createConstantNamedType(@NotNull String name, @NotNull JSExpression rawqualifier) {
        if (name == null) {
            JSTypeEvaluator.$$$reportNull$$$0(102);
        }
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(103);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
        JSType jSType = JSNamedTypeFactory.createType(name, typeSource, JSContext.INSTANCE);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(104);
        }
        return jSType;
    }

    public static void addAdditionalTypes(@NotNull PsiElement context2, @NotNull JSReferenceItem qualifier, @NotNull JSTypeProcessor processor, @NotNull JSEvaluateContext evaluateContext) {
        if (context2 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(105);
        }
        if (qualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(106);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(107);
        }
        if (evaluateContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(108);
        }
        JSEvaluationTask types = JSTypeEvaluator.getAdditionalTypes(context2, qualifier, evaluateContext);
        types.applyWithContext(processor, evaluateContext);
    }

    @NotNull
    public static JSEvaluationTask getAdditionalTypes(@NotNull PsiElement context2, @NotNull JSReferenceItem qualifier, @NotNull JSEvaluateContext evaluateContext) {
        if (context2 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(109);
        }
        if (qualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(110);
        }
        if (evaluateContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(111);
        }
        SmartList types = new SmartList();
        for (JSFrameworkSpecificHandler handler : JSFrameworkSpecificHandler.EP_NAME.allForLanguage(DialectDetector.languageOfElement(context2))) {
            for (JSType type2 : handler.getAdditionalTypes(context2, qualifier, evaluateContext)) {
                types.add(new JSEvaluationResultElement(type2, false, evaluateContext));
            }
        }
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromList((List<? extends JSEvaluationTask>)types);
        if (jSEvaluationTask == null) {
            JSTypeEvaluator.$$$reportNull$$$0(112);
        }
        return jSEvaluationTask;
    }

    @NotNull
    public static JSType getJQueryType(@NotNull PsiElement source) {
        if (source == null) {
            JSTypeEvaluator.$$$reportNull$$$0(113);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(source, false);
        JSType jSType = JSNamedTypeFactory.createType(JQUERY_NS, typeSource, JSContext.UNKNOWN);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(114);
        }
        return jSType;
    }

    @Nullable
    private static String getElementQName(JSNamedElement psiElement) {
        String name = null;
        if (psiElement instanceof JSQualifiedNamedElement) {
            name = ((JSQualifiedNamedElement)psiElement).getQualifiedName();
        }
        if (name == null) {
            name = psiElement.getName();
        }
        return name;
    }

    protected void addTypeFromObjectLiteralExpression(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        JSType recordType = this.getObjectLiteralType(expression, evaluatePropertyTypes);
        this.addType(recordType);
    }

    @NotNull
    protected JSType getObjectLiteralType(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            return new JSObjectType(JSTypeSourceFactory.createTypeSource((PsiElement)expression, false), JSTypeContext.UNKNOWN);
        }
        if (DialectDetector.isTypeScript((PsiElement)expression)) {
            evaluatePropertyTypes = true;
        }
        JSType jSType = new JSObjectLiteralTypeEvaluator(evaluatePropertyTypes, this.myContext.isContextualOverloadEvaluation(), this.myContext.isAstAccessAllowed((PsiElement)expression)).evaluate(expression);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(115);
        }
        return jSType;
    }

    protected void addTypeFromDefExpr(@NotNull JSDefinitionExpression psiElement) {
        JSDocComment comment;
        JSNamespace providedNs;
        JSType jsType;
        boolean isExportDefinition;
        if (psiElement == null) {
            JSTypeEvaluator.$$$reportNull$$$0(116);
        }
        if (isExportDefinition = CommonJSUtil.isExportNamespace(JSNamedTypeFactory.buildProvidedNamespace(psiElement, true))) {
            this.addExportsNamespace((PsiElement)psiElement);
        }
        if ((jsType = psiElement.getJSType()) instanceof JSStubBasedExpressionType) {
            jsType = null;
        }
        boolean hasType = false;
        if (jsType != null) {
            this.addType(jsType);
            hasType = true;
            if (jsType instanceof JSReferenceType && CommonJSUtil.isExportNamespace(JSQualifiedNameImpl.buildProvidedNamespace(psiElement))) {
                String referencedName = ((JSReferenceType)jsType).getReferenceName();
                JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.create(referencedName, null);
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)psiElement, true);
                for (FrameworkIndexingHandler indexingHandler : FrameworkIndexingHandler.getExtensions((PsiElement)psiElement)) {
                    JSType type2 = indexingHandler.getExportsInnerAliasType(qualifiedName, typeSource);
                    if (type2 == null) continue;
                    this.addType(type2);
                }
            }
            if (jsType.isSourceStrict()) {
                return;
            }
        }
        JSFunctionExpression functionInitializer = null;
        if (!hasType) {
            boolean evaluateInitializer;
            JSExpression initializer = psiElement.getInitializerOrStub();
            functionInitializer = initializer instanceof JSFunctionExpression ? (JSFunctionExpression)initializer : null;
            boolean bl = evaluateInitializer = this.myContext.isStrict() || isExportDefinition;
            if (evaluateInitializer) {
                if (this.myContext.isAstAccessAllowed((PsiElement)psiElement)) {
                    JSExpression expr = JSPsiImplUtils.getRightmostOperand(psiElement);
                    if (expr != null) {
                        this.evaluateTypes(expr);
                    }
                } else if (initializer != null) {
                    JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withAstAccessForbidden());
                    this.evaluateTypes(initializer);
                    this.finishEvaluationWithContext(previousContext);
                }
            }
        }
        boolean explicitType = false;
        if (psiElement.isNamespaceExplicitlyDeclared() && (providedNs = JSNamedTypeFactory.buildProvidedNamespace(psiElement, explicitType = (comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)psiElement)) != null && comment.hasNamespaceTag())) != null) {
            if (explicitType) {
                this.addType(providedNs);
            } else {
                this.addAdditionalType(providedNs);
            }
        }
        if (jsType == null && !explicitType && !CommonJSUtil.isModuleExportsAssigmentTarget(psiElement) && functionInitializer == null) {
            this.setUnknownElement((PsiElement)psiElement);
        }
    }

    @NotNull
    protected JSExpectedTypeKind getContextualExpectedTypeKind() {
        JSExpectedTypeKind jSExpectedTypeKind = this.myContext.getContextualExpectedTypeKind();
        if (jSExpectedTypeKind == null) {
            JSTypeEvaluator.$$$reportNull$$$0(117);
        }
        return jSExpectedTypeKind;
    }

    private void simpleEvalType(JSExpression rawqualifier, JSExpression lOperand) {
        JSType evaluatedType = this.getExpressionTypeInContext(lOperand);
        if (evaluatedType != null) {
            this.addType(evaluatedType);
        } else {
            this.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    public void setUnknownElement(@NotNull PsiElement unknownElement) {
        if (unknownElement == null) {
            JSTypeEvaluator.$$$reportNull$$$0(118);
        }
        this.addType(JSAnyType.get(unknownElement));
    }

    protected void addCodeBasedType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(119);
        }
        JSType type2 = JSCodeBasedTypeFactory.getCodeBasedType(expression, this.myContext.isAstAccessAllowed((PsiElement)expression), this.isContextualOverloadEvaluation());
        this.addType(type2);
    }

    @NotNull
    public JSTypeEvaluationResult getResult() {
        JSTypeEvaluationResult jSTypeEvaluationResult = this.myTypeProcessor.getResult();
        if (jSTypeEvaluationResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(120);
        }
        return jSTypeEvaluationResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 35, 41, 49, 50, 54, 58, 72, 73, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 101, 104, 112, 114, 115, 117, 120 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProcessor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 35: 
            case 41: 
            case 49: 
            case 50: 
            case 54: 
            case 58: 
            case 72: 
            case 73: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 101: 
            case 104: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 42: 
            case 98: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawqualifier";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluatedExpression";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 34: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisQualifier";
                break;
            }
            case 37: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawQualifier";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 40: 
            case 62: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoked";
                break;
            }
            case 53: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousContext";
                break;
            }
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 82: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsVariable";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringContainer";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "amdModuleReference";
                break;
            }
            case 81: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 106: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 108: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unknownElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvaluator";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeForThisExpression";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createNullType";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "processApplyOrCallMethodCall";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluateContext";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "startEvaluationWithContext";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "findDestructuringParents";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoopVariableTypes";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromArrayExpression";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromProcessor";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeWithExpandingComposite";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringType";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstantNamedType";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalTypes";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "getJQueryType";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectLiteralType";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextualExpectedTypeKind";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypes";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpressionOrElementTypes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateExpressionOrElementTypes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEvaluatedAsExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluator";
                break;
            }
            case 12: 
            case 35: 
            case 41: 
            case 49: 
            case 50: 
            case 54: 
            case 58: 
            case 72: 
            case 73: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 101: 
            case 104: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 120: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getElementType";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addTypeEvaluationResultElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doAddType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateTypes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateTypesImpl";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processBinaryOperation";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypeFromInlineComment";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addNumericOperatorType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePlusType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "evaluateAndOrOrType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyAccessType";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierExpression";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createTypeForThisExpression";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierInExecutionScope";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getArrayTypeFromExpressions";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOrSpread";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElementTypeFromSpread";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "evaluateDialectSpecificTypes";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "evaluateNewExpressionTypes";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCallExpressionTypes";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromGclRequireCall";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processRequireMethodCall";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "processApplyOrCallMethodCall";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "processCreateMethodCall";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromExternalModuleReferenceResolveResult";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "runWithContext";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "startEvaluationWithContext";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "finishEvaluationWithContext";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "processFunction";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromReturnedExpression";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "processRefExpr";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromResolveResult";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "doAddTypeFromResolveResult";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "findAliasTypeFromDocComment";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromVariableResolveResult";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "addTypeForAutoTypeVariable";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromVariableInitializer";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "processParameterType";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "findDestructuringParents";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isForStatementDeclaration";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyJSObjectLiteral";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "evaluateDestructuringContainer";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "substituteThisType";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromAmdModuleReference";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromAmdModule";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addExportsNamespace";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromImplicitElementResolveResult";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromProperty";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassCandidate";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getLoopVariableTypes";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromLiteralExpression";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromConstant";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "createStringType";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "createConstantNamedType";
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalTypes";
                break;
            }
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalTypes";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getJQueryType";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromDefExpr";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "setUnknownElement";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "addCodeBasedType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 35, 41, 49, 50, 54, 58, 72, 73, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 101, 104, 112, 114, 115, 117, 120 -> new IllegalStateException(string);
        };
    }
}

