/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.evaluable;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReferenceItem;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSCompleteTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.JSEvaluableTypeResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeGuardEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyResolveResultsWithOverloadsType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeStructuralPartEvaluator;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeWithDeclarations;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSQualifiedReferenceType
extends JSEvaluableOnlyTypeBase
implements JSEvaluableOnlyType,
JSTypeWithDeclarations,
JSReferenceItem {
    @NotNull
    private final String myReferenceName;
    private final boolean privateName;
    private final int privateNameDepth;
    @NotNull
    private final JSType myQualifierType;

    public JSQualifiedReferenceType(@NotNull String referenceName, @NotNull JSType qualifierType, @NotNull JSReferenceExpression expression) {
        if (referenceName == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(0);
        }
        if (qualifierType == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(2);
        }
        super((PsiElement)expression);
        this.myReferenceName = referenceName;
        this.privateName = JSUtils.isPrivateNameReference((PsiElement)expression);
        this.privateNameDepth = JSPsiImplUtils.getPrivateNameDepthOfContext(this.privateName, (PsiElement)expression);
        this.myQualifierType = qualifierType;
    }

    public JSQualifiedReferenceType(@NotNull String referenceName, @NotNull JSType qualifierType, @NotNull JSTypeSource source) {
        if (referenceName == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(3);
        }
        if (qualifierType == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(4);
        }
        if (source == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(5);
        }
        super(source);
        this.myReferenceName = referenceName;
        this.privateName = false;
        this.privateNameDepth = -1;
        this.myQualifierType = qualifierType;
    }

    public JSQualifiedReferenceType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(6);
        }
        if (inputStream == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(7);
        }
        super(source);
        this.myReferenceName = JSTypeSerializer.readString(inputStream);
        this.privateName = JSTypeSerializer.readBoolean(inputStream);
        this.privateNameDepth = JSTypeSerializer.readInt(inputStream);
        this.myQualifierType = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(8);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeString(this.myReferenceName, outputStream);
        JSTypeSerializer.writeBoolean(this.privateName, outputStream);
        JSTypeSerializer.writeInt(this.privateNameDepth, outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myQualifierType, outputStream);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(9);
        }
        this.myQualifierType.accept(visitor);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(10);
        }
        return new JSQualifiedReferenceType(this.myReferenceName, this.myQualifierType, source);
    }

    @Override
    @NotNull
    public String getReferenceName() {
        String string = this.myReferenceName;
        if (string == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(11);
        }
        return string;
    }

    public int getPrivateNameDepth() {
        return this.privateNameDepth;
    }

    public boolean isPrivateName() {
        return this.privateName;
    }

    @Override
    public boolean hasQualifier() {
        return true;
    }

    @NotNull
    public JSType getQualifierType() {
        JSType jSType = this.myQualifierType;
        if (jSType == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myReferenceName, this.getSourceElement(), this.myQualifierType);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type2, @Nullable ProcessingContext context2, boolean allowResolve) {
        if (type2 == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(13);
        }
        JSQualifiedReferenceType other = (JSQualifiedReferenceType)type2;
        return this.myReferenceName.equals(other.myReferenceName) && Objects.equals(this.getSourceElement(), other.getSourceElement()) && this.myQualifierType.isEquivalentTo(other.myQualifierType, context2, allowResolve);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        JSType newType;
        if (childTransform == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(14);
        }
        if (newSource == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(15);
        }
        if (this.myQualifierType == (newType = JSTypeUtils.transformTypeHierarchySafe(this.myQualifierType, childTransform))) {
            JSQualifiedReferenceType jSQualifiedReferenceType = this;
            if (jSQualifiedReferenceType == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(16);
            }
            return jSQualifiedReferenceType;
        }
        return new JSQualifiedReferenceType(this.myReferenceName, newType, newSource);
    }

    @Override
    @NotNull
    public Collection<PsiElement> getDeclarations() {
        PsiElement element = this.getSourceElement();
        if (element == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(17);
            }
            return list;
        }
        if (this.matchesSourceElement()) {
            List<PsiElement> list = JSResolveResult.toElements(((JSReferenceExpression)element).multiResolve(false));
            if (list == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(18);
            }
            return list;
        }
        ArrayList<PsiElement> results = new ArrayList<PsiElement>();
        JSType substitute = this.substitute();
        if (substitute instanceof JSTypeWithDeclarations && substitute != this) {
            results.addAll(((JSTypeWithDeclarations)substitute).getDeclarations());
        }
        String name = this.getReferenceName();
        JSType rawQualifierType = this.getQualifierType();
        results.addAll(JSQualifiedReferenceType.resolveNamespaceElements(element, name, rawQualifierType));
        ArrayList<PsiElement> arrayList = results;
        if (arrayList == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<PsiElement> resolveNamespaceElements(@NotNull PsiElement context2, @NotNull String name, @NotNull JSType rawQualifierType) {
        if (context2 == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(20);
        }
        if (name == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(21);
        }
        if (rawQualifierType == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(22);
        }
        if (DialectDetector.isTypeScript(context2)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(23);
            }
            return list;
        }
        PsiFile targetFile = context2.getContainingFile();
        if (targetFile == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(24);
            }
            return list;
        }
        Ref result2 = Ref.create(Collections.emptyList());
        JSEvaluatorComplexityTracker.getDefaultInstance().runTask(1, () -> {
            result2.set(JSQualifiedReferenceType.doResolveNamespaceElements(name, rawQualifierType, targetFile));
            return true;
        });
        Collection collection = (Collection)result2.get();
        if (collection == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(25);
        }
        return collection;
    }

    @NotNull
    private static Collection<PsiElement> doResolveNamespaceElements(@NotNull String name, @NotNull JSType rawQualifierType, @NotNull PsiFile targetFile) {
        if (name == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(26);
        }
        if (rawQualifierType == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(27);
        }
        if (targetFile == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(28);
        }
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(name, targetFile, (PsiElement)targetFile);
        processor.setAddOnlyCompleteMatches();
        new JSCompleteTypeEvaluationProcessor(processor.createTypeProcessor(), JSEvaluableTypeResolver.complete(false)).process(rawQualifierType, new JSEvaluateContext(targetFile));
        if (!processor.getTypeInfo().isEmpty()) {
            JSIndexBasedResolveUtil.processAllSymbols(processor);
            List list = ((StreamEx)StreamEx.of(JSResolveResult.toElements(processor.getResults(), true)).limit((long)JSReferenceExpressionResolver.MAX_RESULTS_COUNT_TO_KEEP)).toList();
            if (list == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(29);
            }
            return list;
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(30);
        }
        return list;
    }

    @Override
    @Nullable
    public JSReferenceItem getReferenceItemQualifier() {
        return (JSReferenceItem)ObjectUtils.tryCast((Object)this.myQualifierType, JSReferenceItem.class);
    }

    @Override
    @NotNull
    public JSEvaluationTask evaluate(@NotNull JSEvaluateContext context2) {
        if (context2 == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(31);
        }
        JSType qualifierType = this.getQualifierType();
        ArrayList<JSEvaluationTask> tasks = new ArrayList<JSEvaluationTask>();
        tasks.add(new JSQualifierEvaluator().evaluate(qualifierType, context2));
        if (JSSymbolUtil.isGlobalNamedType(qualifierType)) {
            tasks.add(JSEvaluationResultElement.fromType(new JSReferenceType(this.getReferenceName(), this.getSource()), context2));
        }
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromList(tasks);
        if (jSEvaluationTask == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(32);
        }
        return jSEvaluationTask;
    }

    @Nullable
    public static JSType getTypeFromPropertySignature(@NotNull JSRecordType.PropertySignature signature) {
        TypeScriptField field;
        JSType type2;
        if (signature == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(33);
        }
        JSType jSType = type2 = signature.isOptional() ? JSTypeGuardUtil.wrapWithUndefined(signature.getJSType(), null) : signature.getJSType();
        if (type2 == null && signature instanceof TypeScriptField && JSTypeGuardUtil.isAutoTypeField((PsiElement)(field = (TypeScriptField)((Object)signature)))) {
            type2 = JSTypeGuardEvaluator.applyToResolveResultType(null, (PsiElement)field, new JSEvaluateContext(field.getContainingFile()));
        }
        return type2;
    }

    @NotNull
    private static StreamEx<JSType> resolveTypesFromElements(@NotNull JSNamedType type2, String propertyName) {
        Collection<PsiElement> declarations;
        PsiElement sourceElement;
        if (type2 == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(34);
        }
        if ((sourceElement = type2.getSourceElement()) != null && !(declarations = JSQualifiedReferenceType.resolveNamespaceElements(sourceElement, propertyName, type2)).isEmpty()) {
            StreamEx streamEx = ((StreamEx)StreamEx.of(declarations).select(JSTypeOwner.class).map(JSTypeOwner::getJSType).filter(t -> !(t instanceof JSEvaluableOnlyType))).nonNull();
            if (streamEx == null) {
                JSQualifiedReferenceType.$$$reportNull$$$0(35);
            }
            return streamEx;
        }
        StreamEx streamEx = StreamEx.empty();
        if (streamEx == null) {
            JSQualifiedReferenceType.$$$reportNull$$$0(36);
        }
        return streamEx;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 16, 17, 18, 19, 23, 24, 25, 29, 30, 32, 35, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 32: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSQualifiedReferenceType";
                break;
            }
            case 13: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawQualifierType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSQualifiedReferenceType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNamespaceElements";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveNamespaceElements";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTypesFromElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 32: 
            case 35: 
            case 36: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveNamespaceElements";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doResolveNamespaceElements";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromPropertySignature";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypesFromElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 16, 17, 18, 19, 23, 24, 25, 29, 30, 32, 35, 36 -> new IllegalStateException(string);
        };
    }

    private final class JSQualifierEvaluator
    extends JSTypeStructuralPartEvaluator {
        private JSQualifierEvaluator() {
        }

        @Override
        protected boolean processSpecialTypes(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext, @NotNull List<JSEvaluationTask> outTasks) {
            if (type2 == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(0);
            }
            if (evaluateContext == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(1);
            }
            if (outTasks == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(2);
            }
            if (type2 instanceof JSEvaluableOnlyType) {
                return true;
            }
            PsiElement ref2 = JSQualifiedReferenceType.this.getSourceElement();
            if (!(type2 instanceof JSRecordType) && !type2.isEcma() && ref2 != null) {
                QualifiedItemProcessor<ResolveResultSink> processor = JSDialectSpecificHandlersFactory.forElement(ref2).createResolveProcessor(JSQualifiedReferenceType.this.myReferenceName, ref2, false);
                JSCompleteTypeEvaluationProcessor.evaluateTypes(type2, evaluateContext, processor, true);
                ResolveResult[] results = processor.getResultsIfResolveCompleted();
                if (results != null) {
                    List<ResolveResultSink.JSResolveResultForSymbolProcessor> filteredResults = ((ResolveResultSink)processor.getResultSink()).getFilteredResults();
                    outTasks.add(JSEvaluationResultElement.fromType(new JSApplyResolveResultsWithOverloadsType(filteredResults, JSQualifiedReferenceType.this.getSource()), evaluateContext));
                    return false;
                }
            }
            List<JSType> types = this.applyToType(type2);
            outTasks.addAll(ContainerUtil.map(types, t -> JSEvaluationResultElement.fromType(t, evaluateContext)));
            return false;
        }

        @Override
        @NotNull
        protected List<JSType> applyToType(@NotNull JSType type2) {
            String propertyName;
            if (type2 == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(3);
            }
            if (StringUtil.isEmpty((String)(propertyName = JSQualifiedReferenceType.this.getReferenceName()))) {
                List<JSType> list = Collections.emptyList();
                if (list == null) {
                    JSQualifierEvaluator.$$$reportNull$$$0(4);
                }
                return list;
            }
            ArrayList<JSType> types = new ArrayList<JSType>();
            if (type2 instanceof JSRecordType) {
                this.evaluateRecordTypeProperty((JSRecordType)type2, propertyName, JSQualifiedReferenceType.this.isPrivateName(), JSQualifiedReferenceType.this.getPrivateNameDepth(), types);
            } else if (type2 instanceof JSNamedType && !(type2 instanceof JSObjectType) && ((JSNamedType)type2).getJSContext() != JSContext.INSTANCE) {
                String resolvedTypeText = type2.getTypeText(JSType.TypeTextFormat.RESOLVED);
                JSQualifiedNameImpl newTypeName = JSQualifiedNameImpl.create(propertyName, JSQualifiedNameImpl.fromQualifiedName(resolvedTypeText));
                JSTypeSource newTypeSource = type2.getSource();
                boolean isLocal = ((JSNamedType)type2).isLocal();
                JSDestructuringProperty property = (JSDestructuringProperty)ObjectUtils.tryCast((Object)JSQualifiedReferenceType.this.getSourceElement(), JSDestructuringProperty.class);
                if (property != null && !isLocal) {
                    newTypeSource = JSTypeSourceFactory.copyTypeSource(newTypeSource, (PsiElement)property);
                }
                JSNamespace newType = JSNamedTypeFactory.createNamespace((JSQualifiedName)newTypeName, newTypeSource, JSTypeContext.STATIC, isLocal);
                types.add(newType);
                List typesFromElements = JSQualifiedReferenceType.resolveTypesFromElements((JSNamedType)type2, propertyName).toList();
                if (!typesFromElements.isEmpty()) {
                    types.add(JSCompositeTypeFactory.createUnionType(type2.getSource(), typesFromElements));
                }
            } else if (type2 instanceof JSAnyType) {
                types.add(type2);
            }
            ArrayList<JSType> arrayList = types;
            if (arrayList == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private void evaluateRecordTypeProperty(@NotNull JSRecordType _type, @NotNull String propertyName, boolean privateName, int privateNameDepth, @NotNull List<JSType> outTypes) {
            JSRecordType.PropertySignature signature;
            if (_type == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(6);
            }
            if (propertyName == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(7);
            }
            if (outTypes == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(8);
            }
            if ((signature = privateName ? _type.findPrivatePropertySignature(propertyName, privateNameDepth) : _type.findPropertySignature(propertyName)) != null) {
                JSType propertyType = JSQualifiedReferenceType.getTypeFromPropertySignature(signature);
                JSQualifierEvaluator.acceptMemberType(propertyType, outTypes);
                return;
            }
            JSRecordType.IndexSignature numericIndexer = _type.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC);
            if (numericIndexer != null && JSNumberParser.tryParseNumericValue(propertyName, false) != null) {
                JSQualifierEvaluator.acceptMemberType(numericIndexer.getMemberType(), outTypes);
                return;
            }
            JSRecordType.IndexSignature stringIndexer = _type.findIndexer(JSRecordType.IndexSignatureKind.STRING);
            if (stringIndexer != null) {
                JSQualifierEvaluator.acceptMemberType(stringIndexer.getMemberType(), outTypes);
            }
        }

        private static void acceptMemberType(@Nullable JSType propertyType, @NotNull List<JSType> outTypes) {
            if (outTypes == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(9);
            }
            if (propertyType != null) {
                outTypes.add(propertyType);
            }
        }

        @Override
        @NotNull
        protected JSType copyOwnerType(@NotNull JSType baseType, @NotNull JSEvaluateContext evaluateContext) {
            if (baseType == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(10);
            }
            if (evaluateContext == null) {
                JSQualifierEvaluator.$$$reportNull$$$0(11);
            }
            return new JSQualifiedReferenceType(JSQualifiedReferenceType.this.myReferenceName, baseType, JSQualifiedReferenceType.this.getSource());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluateContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outTasks";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSQualifiedReferenceType$JSQualifierEvaluator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_type";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outTypes";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSQualifiedReferenceType$JSQualifierEvaluator";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "applyToType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "processSpecialTypes";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyToType";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluateRecordTypeProperty";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptMemberType";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "copyOwnerType";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

