/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceParameter;

import com.intellij.DynamicBundle;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterSettings;
import com.intellij.lang.javascript.validation.fixes.JSParameterInserter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.LanguageTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.XDebuggerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroduceParameterDialog
extends JSBaseIntroduceDialog<BasicIntroducedEntityInfoProvider>
implements JSIntroduceParameterSettings {
    private JPanel myPanel;
    private EditorComboBox myVarType;
    private JLabel myNameLabel;
    private NameSuggestionsField myNameField;
    private JCheckBox myReplaceAllCheckBox;
    private JCheckBox myOptionalParameter;
    private JLabel myValueLabel;
    private JPanel myIntroducedParameterValuePanel;
    private JLabel myVarTypeText;
    private final LanguageTextField myIntroducedParameterValue;
    private SmartPsiElementPointer<JSFunction> myFunctionPointer;
    private final boolean myEcmaScriptLevel4;

    protected JSIntroduceParameterDialog(@NotNull Project project, JSExpression[] occurrences, JSExpression mainOccurrence, String initialValue, final JSFunction function) {
        boolean mustBeOptional;
        if (project == null) {
            JSIntroduceParameterDialog.$$$reportNull$$$0(0);
        }
        super(project, new BasicIntroducedEntityInfoProvider(mainOccurrence, occurrences, function), "javascript.introduce.parameter.title");
        this.$$$setupUI$$$();
        final PsiFile containingFile = mainOccurrence.getContainingFile();
        this.myEcmaScriptLevel4 = containingFile.getLanguage().isKindOf((Language)FlexSupportLoader.ECMA_SCRIPT_L4);
        this.myVarType.setVisible(this.myEcmaScriptLevel4);
        this.myVarTypeText.setVisible(this.myEcmaScriptLevel4);
        this.myIntroducedParameterValue = new LanguageTextField((Language)JavascriptLanguage.INSTANCE, project, initialValue, new LanguageTextField.DocumentCreator(){

            public Document createDocument(String value, @Nullable Language language, Project project) {
                VirtualFile contextVirtualFile = containingFile.getVirtualFile();
                PsiElement context2 = null;
                if (contextVirtualFile != null) {
                    context2 = XDebuggerUtil.getInstance().findContextElement(contextVirtualFile, function.getTextOffset(), project, true);
                }
                return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)JSElementFactory.createExpressionCodeFragment(project, value, context2));
            }
        });
        JSParameterInserter parameterInserter = JSParameterInserter.build(function);
        boolean bl = mustBeOptional = parameterInserter != null && parameterInserter.mustBeOptional();
        if (mustBeOptional) {
            this.myOptionalParameter.setEnabled(false);
        }
        this.myIntroducedParameterValuePanel.add((Component)this.myIntroducedParameterValue, "Center");
        this.myValueLabel.setLabelFor((Component)this.myIntroducedParameterValue);
        this.myFunctionPointer = SmartPointerManager.createPointer((PsiElement)function);
        this.doInit();
    }

    @Override
    protected NameSuggestionsField getNameField() {
        return this.myNameField;
    }

    @Override
    protected JLabel getNameLabel() {
        return this.myNameLabel;
    }

    @Override
    protected JPanel getPanel() {
        return this.myPanel;
    }

    @Override
    protected JCheckBox getReplaceAllCheckBox() {
        return this.myReplaceAllCheckBox;
    }

    @Override
    public JComboBox getVarTypeField() {
        return this.myVarType;
    }

    private void createUIComponents() {
        this.myNameField = this.configureNameField();
        this.myVarType = this.configureTypeField();
    }

    @Override
    public boolean addOptionalParameter() {
        return this.myOptionalParameter.isSelected();
    }

    @Override
    public String getInitialValue() {
        return this.myIntroducedParameterValue.getText();
    }

    @Override
    public JSFunction functionForIntroduceParameter() {
        return (JSFunction)this.myFunctionPointer.getElement();
    }

    @Override
    public void setFunctionToIntroduceParameter(JSFunction function) {
        this.myFunctionPointer = SmartPointerManager.createPointer((PsiElement)function);
    }

    protected String getHelpId() {
        return this.myEcmaScriptLevel4 ? "refactoring.introduceParameter.ActionScript" : "refactoring.introduceParameter.JavaScript";
    }

    @Override
    public boolean addJsDoc() {
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myVarTypeText = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/JavaScriptBundle", JSIntroduceParameterDialog.class).getString("introduce.parameter.type"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        EditorComboBox editorComboBox = this.myVarType;
        jPanel2.add((Component)editorComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myNameLabel = jLabel2 = new JLabel();
        jLabel2.setRequestFocusEnabled(false);
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/JavaScriptBundle", JSIntroduceParameterDialog.class).getString("javascript.introduce.variable.name.prompt"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        NameSuggestionsField nameSuggestionsField = this.myNameField;
        jPanel2.add((Component)nameSuggestionsField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myReplaceAllCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setActionCommand("");
        jCheckBox2.setContentAreaFilled(false);
        jCheckBox2.setFocusable(false);
        jCheckBox2.setMargin(new Insets(2, 0, 2, 0));
        jCheckBox2.setText("");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myOptionalParameter = jCheckBox = new JCheckBox();
        jCheckBox.setActionCommand("");
        jCheckBox.setContentAreaFilled(false);
        jCheckBox.setFocusable(false);
        jCheckBox.setMargin(new Insets(2, 0, 2, 0));
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/JavaScriptBundle", JSIntroduceParameterDialog.class).getString("introduce.parameter.optional"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myValueLabel = jLabel = new JLabel();
        jLabel.setRequestFocusEnabled(false);
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JavaScriptBundle", JSIntroduceParameterDialog.class).getString("javascript.introduce.parameter.introduced.variable.value"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIntroducedParameterValuePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel3.setLabelFor((Component)editorComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/introduceParameter/JSIntroduceParameterDialog", "<init>"));
    }
}

