/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.psi.references;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/httpClient/http/request/psi/references/JsonConverter;", "", "jsonObject", "Lcom/intellij/json/psi/JsonObject;", "<init>", "(Lcom/intellij/json/psi/JsonObject;)V", "getJsonObject", "()Lcom/intellij/json/psi/JsonObject;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "convert", "Lcom/fasterxml/jackson/databind/JsonNode;", "generateNode", "value", "Lcom/intellij/json/psi/JsonValue;", "createNodeFromLiteral", "literal", "Lcom/intellij/json/psi/JsonLiteral;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientJsonPsiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientJsonPsiUtil.kt\ncom/intellij/httpClient/http/request/psi/references/JsonConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1863#2,2:107\n1863#2,2:109\n1863#2,2:111\n*S KotlinDebug\n*F\n+ 1 HttpClientJsonPsiUtil.kt\ncom/intellij/httpClient/http/request/psi/references/JsonConverter\n*L\n38#1:107,2\n53#1:109,2\n62#1:111,2\n*E\n"})
final class JsonConverter {
    @NotNull
    private final JsonObject jsonObject;
    @NotNull
    private final ObjectMapper mapper;

    public JsonConverter(@NotNull JsonObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        this.jsonObject = jsonObject;
        this.mapper = new ObjectMapper();
    }

    @NotNull
    public final JsonObject getJsonObject() {
        return this.jsonObject;
    }

    @NotNull
    public final JsonNode convert() {
        ObjectNode rootNode = this.mapper.createObjectNode();
        List list2 = this.jsonObject.getPropertyList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPropertyList(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonValue value2;
            JsonProperty property = (JsonProperty)element$iv;
            boolean bl = false;
            if (property.getValue() == null) continue;
            rootNode.set(property.getName(), this.generateNode(value2));
        }
        Intrinsics.checkNotNull((Object)rootNode);
        return (JsonNode)rootNode;
    }

    private final JsonNode generateNode(JsonValue value2) {
        if (value2 instanceof JsonLiteral) {
            return this.createNodeFromLiteral((JsonLiteral)value2);
        }
        if (value2 instanceof JsonObject) {
            ObjectNode newNode = this.mapper.createObjectNode();
            List list2 = ((JsonObject)value2).getPropertyList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPropertyList(...)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonValue currentValue;
                JsonProperty property = (JsonProperty)element$iv;
                boolean bl = false;
                if (property.getValue() == null) continue;
                newNode.set(property.getName(), this.generateNode(currentValue));
            }
            return (JsonNode)newNode;
        }
        if (value2 instanceof JsonArray) {
            ArrayNode node = new ObjectMapper().createArrayNode();
            List list3 = ((JsonArray)value2).getValueList();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueList(...)");
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonValue it = (JsonValue)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                node.add(this.generateNode(it));
            }
            return (JsonNode)node;
        }
        return null;
    }

    private final JsonNode createNodeFromLiteral(JsonLiteral literal) {
        JsonLiteral jsonLiteral = literal;
        return jsonLiteral instanceof JsonStringLiteral ? (JsonNode)new TextNode(((JsonStringLiteral)literal).getValue()) : (jsonLiteral instanceof JsonBooleanLiteral ? (JsonNode)BooleanNode.valueOf((boolean)((JsonBooleanLiteral)literal).getValue()) : (jsonLiteral instanceof JsonNumberLiteral ? (JsonNode)new DoubleNode(((JsonNumberLiteral)literal).getValue()) : null));
    }
}

