/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.array.ArrayCreateNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

@ImportStatic(value={JSRuntime.class, Integer.class})
public abstract class ArrayCreateNode
extends JavaScriptBaseNode {
    private final JSContext context;

    protected ArrayCreateNode(JSContext context2) {
        this.context = context2;
    }

    @NeverDefault
    public static ArrayCreateNode create(JSContext context2) {
        return ArrayCreateNodeGen.create(context2);
    }

    @Specialization(guards={"isValidArrayLength(length)", "length <= MAX_VALUE"})
    protected final JSArrayObject doDefault(long length2, JSRealm realm, JSDynamicObject proto) {
        return JSArray.createEmptyChecked(this.context, realm, proto, length2);
    }

    @Specialization(guards={"isValidArrayLength(length)", "length > MAX_VALUE"})
    protected final JSArrayObject doLargeLength(long length2, JSRealm realm, JSDynamicObject proto) {
        return JSArray.createSparseArray(this.context, realm, proto, length2);
    }

    @Specialization(guards={"!isValidArrayLength(length)"})
    protected final JSArrayObject doInvalidLength(long length2, JSRealm realm, JSDynamicObject proto) {
        throw Errors.createRangeErrorInvalidArrayLength(this);
    }

    public final JSArrayObject execute(long length2) {
        JSRealm realm = this.getRealm();
        return this.execute(length2, realm, realm.getArrayPrototype());
    }

    public abstract JSArrayObject execute(long var1, JSRealm var3, JSDynamicObject var4);
}

