/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.render.svg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.values.Font;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Token;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTSpanElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b \u0018\u0000 \u00132\u00020\u0001:\u0005\u0013\u0014\u0015\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u0011H&R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node;", "", "()V", "svg", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTSpanElement;", "getSvg", "()Ljava/util/List;", "visualCharCount", "", "getVisualCharCount", "()I", "estimateWidth", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "", "Companion", "GroupNode", "SubscriptNode", "SuperscriptNode", "TextNode", "plot-base"})
public abstract class Node {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ZERO_WIDTH_SPACE_SYMBOL = "\u200b";
    @NotNull
    private static final String INDENT_SYMBOL = " ";
    private static final double INDENT_SIZE_FACTOR = 0.1;
    private static final double INDEX_SIZE_FACTOR = 0.7;
    private static final double INDEX_RELATIVE_SHIFT = 0.4;
    @NotNull
    private static final Map<String, String> GREEK_LETTERS;
    @NotNull
    private static final Map<String, String> OPERATIONS;
    @NotNull
    private static final Map<String, String> RELATIONS;
    @NotNull
    private static final Map<String, String> MISCELLANEOUS;
    @NotNull
    private static final Map<String, String> SYMBOLS;

    public abstract int getVisualCharCount();

    @NotNull
    public abstract List<SvgTSpanElement> getSvg();

    public abstract double estimateWidth(@NotNull Font var1, @NotNull Function2<? super String, ? super Font, Double> var2);

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Alpha", (Object)"\u0391"), TuplesKt.to((Object)"Beta", (Object)"\u0392"), TuplesKt.to((Object)"Gamma", (Object)"\u0393"), TuplesKt.to((Object)"Delta", (Object)"\u0394"), TuplesKt.to((Object)"Epsilon", (Object)"\u0395"), TuplesKt.to((Object)"Zeta", (Object)"\u0396"), TuplesKt.to((Object)"Eta", (Object)"\u0397"), TuplesKt.to((Object)"Theta", (Object)"\u0398"), TuplesKt.to((Object)"Iota", (Object)"\u0399"), TuplesKt.to((Object)"Kappa", (Object)"\u039a"), TuplesKt.to((Object)"Lambda", (Object)"\u039b"), TuplesKt.to((Object)"Mu", (Object)"\u039c"), TuplesKt.to((Object)"Nu", (Object)"\u039d"), TuplesKt.to((Object)"Xi", (Object)"\u039e"), TuplesKt.to((Object)"Omicron", (Object)"\u039f"), TuplesKt.to((Object)"Pi", (Object)"\u03a0"), TuplesKt.to((Object)"Rho", (Object)"\u03a1"), TuplesKt.to((Object)"Sigma", (Object)"\u03a3"), TuplesKt.to((Object)"Tau", (Object)"\u03a4"), TuplesKt.to((Object)"Upsilon", (Object)"\u03a5"), TuplesKt.to((Object)"Phi", (Object)"\u03a6"), TuplesKt.to((Object)"Chi", (Object)"\u03a7"), TuplesKt.to((Object)"Psi", (Object)"\u03a8"), TuplesKt.to((Object)"Omega", (Object)"\u03a9"), TuplesKt.to((Object)"alpha", (Object)"\u03b1"), TuplesKt.to((Object)"beta", (Object)"\u03b2"), TuplesKt.to((Object)"gamma", (Object)"\u03b3"), TuplesKt.to((Object)"delta", (Object)"\u03b4"), TuplesKt.to((Object)"epsilon", (Object)"\u03b5"), TuplesKt.to((Object)"zeta", (Object)"\u03b6"), TuplesKt.to((Object)"eta", (Object)"\u03b7"), TuplesKt.to((Object)"theta", (Object)"\u03b8"), TuplesKt.to((Object)"iota", (Object)"\u03b9"), TuplesKt.to((Object)"kappa", (Object)"\u03ba"), TuplesKt.to((Object)"lambda", (Object)"\u03bb"), TuplesKt.to((Object)"mu", (Object)"\u03bc"), TuplesKt.to((Object)"nu", (Object)"\u03bd"), TuplesKt.to((Object)"xi", (Object)"\u03be"), TuplesKt.to((Object)"omicron", (Object)"\u03bf"), TuplesKt.to((Object)"pi", (Object)"\u03c0"), TuplesKt.to((Object)"rho", (Object)"\u03c1"), TuplesKt.to((Object)"sigma", (Object)"\u03c3"), TuplesKt.to((Object)"tau", (Object)"\u03c4"), TuplesKt.to((Object)"upsilon", (Object)"\u03c5"), TuplesKt.to((Object)"phi", (Object)"\u03c6"), TuplesKt.to((Object)"chi", (Object)"\u03c7"), TuplesKt.to((Object)"psi", (Object)"\u03c8"), TuplesKt.to((Object)"omega", (Object)"\u03c9")};
        GREEK_LETTERS = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"pm", (Object)"\u00b1"), TuplesKt.to((Object)"mp", (Object)"\u2213"), TuplesKt.to((Object)"times", (Object)"\u00d7"), TuplesKt.to((Object)"div", (Object)"\u00f7"), TuplesKt.to((Object)"cdot", (Object)"\u00b7")};
        OPERATIONS = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"leq", (Object)"\u2264"), TuplesKt.to((Object)"geq", (Object)"\u2265"), TuplesKt.to((Object)"neq", (Object)"\u2260")};
        RELATIONS = MapsKt.mapOf((Pair[])pairArray);
        MISCELLANEOUS = MapsKt.mapOf((Pair)TuplesKt.to((Object)"infty", (Object)"\u221e"));
        SYMBOLS = MapsKt.plus((Map)MapsKt.plus((Map)MapsKt.plus(GREEK_LETTERS, OPERATIONS), RELATIONS), MISCELLANEOUS);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00070\u0018H\u0002J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010\u001e\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0002J\u001e\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020!0(2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010)\u001a\u00020\u00122\f\u0010'\u001a\b\u0012\u0004\u0012\u00020!0(2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node$Companion;", "", "()V", "GREEK_LETTERS", "", "", "INDENT_SIZE_FACTOR", "", "INDENT_SYMBOL", "INDEX_RELATIVE_SHIFT", "INDEX_SIZE_FACTOR", "MISCELLANEOUS", "OPERATIONS", "RELATIONS", "SYMBOLS", "ZERO_WIDTH_SPACE_SYMBOL", "estimateWidthForIndexNode", "content", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node;", "level", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "getSvgForIndexNode", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTSpanElement;", "isSuperior", "", "parse", "tokens", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Token;", "parseCommand", "token", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Token$Command;", "parseGroup", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node$GroupNode;", "iterator", "", "parseSupOrSub", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nLatexTerm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LatexTerm.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/Node$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n1#2:330\n1559#3:331\n1590#3,4:332\n*S KotlinDebug\n*F\n+ 1 LatexTerm.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/Node$Companion\n*L\n300#1:331\n300#1:332,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Node parse(@NotNull Sequence<? extends Token> tokens) {
            Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
            return this.parseGroup(tokens.iterator(), 0);
        }

        private final GroupNode parseGroup(Iterator<? extends Token> iterator2, int level) {
            List nodes = new ArrayList();
            while (iterator2.hasNext()) {
                Token token = iterator2.next();
                Token token2 = token;
                if (token2 instanceof Token.Command) {
                    nodes.add(this.parseCommand((Token.Command)token));
                    continue;
                }
                if (token2 instanceof Token.OpenBrace) {
                    nodes.add(this.parseGroup(iterator2, level));
                    continue;
                }
                if (token2 instanceof Token.CloseBrace) break;
                if (token2 instanceof Token.Superscript) {
                    nodes.add(new SuperscriptNode(this.parseSupOrSub(iterator2, level + 1), level));
                    continue;
                }
                if (token2 instanceof Token.Subscript) {
                    nodes.add(new SubscriptNode(this.parseSupOrSub(iterator2, level + 1), level));
                    continue;
                }
                if (token2 instanceof Token.Text) {
                    nodes.add(new TextNode(((Token.Text)token).getContent()));
                    continue;
                }
                if (token2 instanceof Token.Space || !(token2 instanceof Token.ExplicitSpace)) continue;
                nodes.add(new TextNode(((Token.ExplicitSpace)token).getSpace()));
            }
            return new GroupNode(nodes);
        }

        private final Node parseSupOrSub(Iterator<? extends Token> iterator2, int level) {
            Node node;
            Token nextToken2 = iterator2.next();
            if (nextToken2 instanceof Token.OpenBrace) {
                node = this.parseGroup(iterator2, level);
            } else if (nextToken2 instanceof Token.Text) {
                node = new TextNode(((Token.Text)nextToken2).getContent());
            } else if (nextToken2 instanceof Token.Command) {
                node = this.parseCommand((Token.Command)nextToken2);
            } else {
                throw new IllegalArgumentException("Unexpected token after superscript or subscript");
            }
            return node;
        }

        private final Node parseCommand(Token.Command token) {
            Map map2 = SYMBOLS;
            Object object = map2.get(token.getName());
            if (object == null) {
                boolean bl = false;
                object = '\\' + token.getName();
            }
            String string = (String)object;
            return new TextNode(string);
        }

        /*
         * WARNING - void declaration
         */
        private final List<SvgTSpanElement> getSvgForIndexNode(Node content, int level, boolean isSuperior) {
            SvgTSpanElement svgTSpanElement;
            void $this$mapIndexedTo$iv$iv;
            SvgTSpanElement svgTSpanElement2;
            Pair pair2 = isSuperior ? TuplesKt.to((Object)"-", (Object)"") : TuplesKt.to((Object)"", (Object)"-");
            String shift = (String)pair2.component1();
            String backShift = (String)pair2.component2();
            SvgTSpanElement $this$getSvgForIndexNode_u24lambda_u241 = svgTSpanElement2 = new SvgTSpanElement(Node.INDENT_SYMBOL);
            boolean bl = false;
            $this$getSvgForIndexNode_u24lambda_u241.setAttribute(SvgTSpanElement.Companion.getFONT_SIZE(), "0.1em");
            SvgTSpanElement indentTSpan = svgTSpanElement2;
            double indexSize = Math.pow(0.7, level + 1);
            Iterable $this$mapIndexed$iv = content.getSvg();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                void element;
                void var23_27;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                SvgTSpanElement svgTSpanElement3 = (SvgTSpanElement)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void $this$getSvgForIndexNode_u24lambda_u243_u24lambda_u242 = var23_27 = element;
                boolean bl3 = false;
                if ($this$getSvgForIndexNode_u24lambda_u243_u24lambda_u242.getAttribute(SvgTSpanElement.Companion.getFONT_SIZE()).get() == null) {
                    $this$getSvgForIndexNode_u24lambda_u243_u24lambda_u242.setAttribute(SvgTSpanElement.Companion.getFONT_SIZE(), indexSize + "em");
                }
                if (i == false) {
                    $this$getSvgForIndexNode_u24lambda_u243_u24lambda_u242.setAttribute(SvgTSpanElement.Companion.getDY(), shift + "0.4em");
                }
                collection.add(var23_27);
            }
            List indexTSpanElements = (List)destination$iv$iv;
            SvgTSpanElement $this$getSvgForIndexNode_u24lambda_u244 = svgTSpanElement = new SvgTSpanElement(Node.ZERO_WIDTH_SPACE_SYMBOL);
            boolean bl4 = false;
            $this$getSvgForIndexNode_u24lambda_u244.setAttribute(SvgTSpanElement.Companion.getFONT_SIZE(), indexSize + "em");
            $this$getSvgForIndexNode_u24lambda_u244.setAttribute(SvgTSpanElement.Companion.getDY(), backShift + "0.4em");
            SvgTSpanElement restoreBaselineTSpan = svgTSpanElement;
            return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)indentTSpan), (Iterable)indexTSpanElements), (Object)restoreBaselineTSpan);
        }

        private final double estimateWidthForIndexNode(Node content, int level, Font font, Function2<? super String, ? super Font, Double> widthCalculator) {
            int indexFontSize = MathKt.roundToInt((double)((double)font.getSize() * Math.pow(0.7, level + 1)));
            Font indexFont = new Font(font.getFamily(), indexFontSize, font.isBold(), font.isItalic());
            return content.estimateWidth(indexFont, widthCalculator);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u0019\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00150\u0019H\u0016J\t\u0010\u001b\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node$GroupNode;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node;", "children", "", "(Ljava/util/List;)V", "getChildren", "()Ljava/util/List;", "svg", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTSpanElement;", "getSvg", "visualCharCount", "", "getVisualCharCount", "()I", "component1", "copy", "equals", "", "other", "", "estimateWidth", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "", "hashCode", "toString", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nLatexTerm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LatexTerm.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/Node$GroupNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n1#2:330\n1360#3:331\n1446#3,5:332\n*S KotlinDebug\n*F\n+ 1 LatexTerm.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/Node$GroupNode\n*L\n165#1:331\n165#1:332,5\n*E\n"})
    public static final class GroupNode
    extends Node {
        @NotNull
        private final List<Node> children;
        private final int visualCharCount;
        @NotNull
        private final List<SvgTSpanElement> svg;

        /*
         * WARNING - void declaration
         */
        public GroupNode(@NotNull List<? extends Node> children2) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            int n;
            Intrinsics.checkNotNullParameter(children2, (String)"children");
            this.children = children2;
            Iterable iterable = this.children;
            GroupNode groupNode = this;
            int n2 = 0;
            for (Object t : iterable) {
                void it;
                Node node = (Node)t;
                n = n2;
                boolean bl = false;
                int n3 = it.getVisualCharCount();
                n2 = n + n3;
            }
            groupNode.visualCharCount = n = n2;
            iterable = this.children;
            groupNode = this;
            boolean $i$f$flatMap = false;
            Iterator iterator2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Node it = (Node)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getSvg();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            groupNode.svg = (List)destination$iv$iv;
        }

        @NotNull
        public final List<Node> getChildren() {
            return this.children;
        }

        @Override
        public int getVisualCharCount() {
            return this.visualCharCount;
        }

        @Override
        @NotNull
        public List<SvgTSpanElement> getSvg() {
            return this.svg;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public double estimateWidth(@NotNull Font font, @NotNull Function2<? super String, ? super Font, Double> widthCalculator) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter(widthCalculator, (String)"widthCalculator");
            Iterable iterable = this.children;
            double d = 0.0;
            for (Object t : iterable) {
                void it;
                Node node = (Node)t;
                double d2 = d;
                boolean bl = false;
                double d3 = it.estimateWidth(font, widthCalculator);
                d = d2 + d3;
            }
            return d;
        }

        @NotNull
        public final List<Node> component1() {
            return this.children;
        }

        @NotNull
        public final GroupNode copy(@NotNull List<? extends Node> children2) {
            Intrinsics.checkNotNullParameter(children2, (String)"children");
            return new GroupNode(children2);
        }

        public static /* synthetic */ GroupNode copy$default(GroupNode groupNode, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = groupNode.children;
            }
            return groupNode.copy(list2);
        }

        @NotNull
        public String toString() {
            return "GroupNode(children=" + this.children + ')';
        }

        public int hashCode() {
            return ((Object)this.children).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GroupNode)) {
                return false;
            }
            GroupNode groupNode = (GroupNode)other;
            return Intrinsics.areEqual(this.children, groupNode.children);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0011\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J*\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00190\u001dH\u0016J\t\u0010\u001f\u001a\u00020\u0004H\u00d6\u0001J\t\u0010 \u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node$SubscriptNode;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node;", "content", "level", "", "(Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node;I)V", "getContent", "()Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node;", "getLevel", "()I", "svg", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTSpanElement;", "getSvg", "()Ljava/util/List;", "visualCharCount", "getVisualCharCount", "component1", "component2", "copy", "equals", "", "other", "", "estimateWidth", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "", "hashCode", "toString", "plot-base"})
    public static final class SubscriptNode
    extends Node {
        @NotNull
        private final Node content;
        private final int level;
        private final int visualCharCount;
        @NotNull
        private final List<SvgTSpanElement> svg;

        public SubscriptNode(@NotNull Node content, int level) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
            this.level = level;
            this.visualCharCount = this.content.getVisualCharCount();
            this.svg = Companion.getSvgForIndexNode(this.content, this.level, false);
        }

        @NotNull
        public final Node getContent() {
            return this.content;
        }

        public final int getLevel() {
            return this.level;
        }

        @Override
        public int getVisualCharCount() {
            return this.visualCharCount;
        }

        @Override
        @NotNull
        public List<SvgTSpanElement> getSvg() {
            return this.svg;
        }

        @Override
        public double estimateWidth(@NotNull Font font, @NotNull Function2<? super String, ? super Font, Double> widthCalculator) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter(widthCalculator, (String)"widthCalculator");
            return Companion.estimateWidthForIndexNode(this.content, this.level, font, (Function2<? super String, ? super Font, Double>)widthCalculator);
        }

        @NotNull
        public final Node component1() {
            return this.content;
        }

        public final int component2() {
            return this.level;
        }

        @NotNull
        public final SubscriptNode copy(@NotNull Node content, int level) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new SubscriptNode(content, level);
        }

        public static /* synthetic */ SubscriptNode copy$default(SubscriptNode subscriptNode, Node node, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                node = subscriptNode.content;
            }
            if ((n2 & 2) != 0) {
                n = subscriptNode.level;
            }
            return subscriptNode.copy(node, n);
        }

        @NotNull
        public String toString() {
            return "SubscriptNode(content=" + this.content + ", level=" + this.level + ')';
        }

        public int hashCode() {
            int result2 = this.content.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.level);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SubscriptNode)) {
                return false;
            }
            SubscriptNode subscriptNode = (SubscriptNode)other;
            if (!Intrinsics.areEqual((Object)this.content, (Object)subscriptNode.content)) {
                return false;
            }
            return this.level == subscriptNode.level;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0011\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J*\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00190\u001dH\u0016J\t\u0010\u001f\u001a\u00020\u0004H\u00d6\u0001J\t\u0010 \u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node$SuperscriptNode;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node;", "content", "level", "", "(Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node;I)V", "getContent", "()Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node;", "getLevel", "()I", "svg", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTSpanElement;", "getSvg", "()Ljava/util/List;", "visualCharCount", "getVisualCharCount", "component1", "component2", "copy", "equals", "", "other", "", "estimateWidth", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "", "hashCode", "toString", "plot-base"})
    public static final class SuperscriptNode
    extends Node {
        @NotNull
        private final Node content;
        private final int level;
        private final int visualCharCount;
        @NotNull
        private final List<SvgTSpanElement> svg;

        public SuperscriptNode(@NotNull Node content, int level) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
            this.level = level;
            this.visualCharCount = this.content.getVisualCharCount();
            this.svg = Companion.getSvgForIndexNode(this.content, this.level, true);
        }

        @NotNull
        public final Node getContent() {
            return this.content;
        }

        public final int getLevel() {
            return this.level;
        }

        @Override
        public int getVisualCharCount() {
            return this.visualCharCount;
        }

        @Override
        @NotNull
        public List<SvgTSpanElement> getSvg() {
            return this.svg;
        }

        @Override
        public double estimateWidth(@NotNull Font font, @NotNull Function2<? super String, ? super Font, Double> widthCalculator) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter(widthCalculator, (String)"widthCalculator");
            return Companion.estimateWidthForIndexNode(this.content, this.level, font, (Function2<? super String, ? super Font, Double>)widthCalculator);
        }

        @NotNull
        public final Node component1() {
            return this.content;
        }

        public final int component2() {
            return this.level;
        }

        @NotNull
        public final SuperscriptNode copy(@NotNull Node content, int level) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new SuperscriptNode(content, level);
        }

        public static /* synthetic */ SuperscriptNode copy$default(SuperscriptNode superscriptNode, Node node, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                node = superscriptNode.content;
            }
            if ((n2 & 2) != 0) {
                n = superscriptNode.level;
            }
            return superscriptNode.copy(node, n);
        }

        @NotNull
        public String toString() {
            return "SuperscriptNode(content=" + this.content + ", level=" + this.level + ')';
        }

        public int hashCode() {
            int result2 = this.content.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.level);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SuperscriptNode)) {
                return false;
            }
            SuperscriptNode superscriptNode = (SuperscriptNode)other;
            if (!Intrinsics.areEqual((Object)this.content, (Object)superscriptNode.content)) {
                return false;
            }
            return this.level == superscriptNode.level;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00170\u001bH\u0016J\t\u0010\u001c\u001a\u00020\rH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node$TextNode;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node;", "content", "", "(Ljava/lang/String;)V", "getContent", "()Ljava/lang/String;", "svg", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTSpanElement;", "getSvg", "()Ljava/util/List;", "visualCharCount", "", "getVisualCharCount", "()I", "component1", "copy", "equals", "", "other", "", "estimateWidth", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "hashCode", "toString", "plot-base"})
    public static final class TextNode
    extends Node {
        @NotNull
        private final String content;
        private final int visualCharCount;
        @NotNull
        private final List<SvgTSpanElement> svg;

        public TextNode(@NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
            this.visualCharCount = this.content.length();
            this.svg = CollectionsKt.listOf((Object)new SvgTSpanElement(this.content));
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        @Override
        public int getVisualCharCount() {
            return this.visualCharCount;
        }

        @Override
        @NotNull
        public List<SvgTSpanElement> getSvg() {
            return this.svg;
        }

        @Override
        public double estimateWidth(@NotNull Font font, @NotNull Function2<? super String, ? super Font, Double> widthCalculator) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter(widthCalculator, (String)"widthCalculator");
            return ((Number)widthCalculator.invoke((Object)this.content, (Object)font)).doubleValue();
        }

        @NotNull
        public final String component1() {
            return this.content;
        }

        @NotNull
        public final TextNode copy(@NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new TextNode(content);
        }

        public static /* synthetic */ TextNode copy$default(TextNode textNode, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = textNode.content;
            }
            return textNode.copy(string);
        }

        @NotNull
        public String toString() {
            return "TextNode(content=" + this.content + ')';
        }

        public int hashCode() {
            return this.content.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextNode)) {
                return false;
            }
            TextNode textNode = (TextNode)other;
            return Intrinsics.areEqual((Object)this.content, (Object)textNode.content);
        }
    }
}

