/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.ast.PyAstCallExpression;
import com.jetbrains.python.ast.PyAstDocStringOwner;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstExpressionStatement;
import com.jetbrains.python.ast.PyAstFile;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstNamedParameter;
import com.jetbrains.python.ast.PyAstParameter;
import com.jetbrains.python.ast.PyAstRaiseStatement;
import com.jetbrains.python.ast.PyAstRecursiveElementVisitor;
import com.jetbrains.python.ast.PyAstReturnStatement;
import com.jetbrains.python.ast.PyAstStatementList;
import com.jetbrains.python.ast.PyAstStatementListContainer;
import com.jetbrains.python.ast.PyAstStringLiteralExpression;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.documentation.docstrings.DocStringBuilder;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringParser;
import com.jetbrains.python.documentation.docstrings.DocStringUpdater;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocString;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocStringUpdater;
import com.jetbrains.python.documentation.docstrings.NumpyDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.NumpyDocStringUpdater;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.TagBasedDocString;
import com.jetbrains.python.documentation.docstrings.TagBasedDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.TagBasedDocStringUpdater;
import com.jetbrains.python.psi.PyAstElementGenerator;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.StructuredDocString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyDocstringGenerator {
    public static final String TRIPLE_DOUBLE_QUOTES = "\"\"\"";
    public static final String TRIPLE_SINGLE_QUOTES = "'''";
    private final List<DocstringParam> myAddedParams;
    private final List<DocstringParam> myRemovedParams;
    private final String myDocStringText;
    @Nullable
    private final PyAstDocStringOwner myDocStringOwner;
    private final String myDocStringIndent;
    private final DocStringFormat myDocStringFormat;
    private final PsiElement mySettingsAnchor;
    private boolean myUseTypesFromDebuggerSignature;
    private boolean myNewMode;
    private boolean myAddFirstEmptyLine;
    private boolean myParametersPrepared;
    private String myQuotes;

    private PyDocstringGenerator(@Nullable PyAstDocStringOwner docStringOwner, @Nullable String docStringText, @NotNull DocStringFormat format, @NotNull String indentation, @NotNull PsiElement settingsAnchor) {
        if (format == null) {
            PyDocstringGenerator.$$$reportNull$$$0(0);
        }
        if (indentation == null) {
            PyDocstringGenerator.$$$reportNull$$$0(1);
        }
        if (settingsAnchor == null) {
            PyDocstringGenerator.$$$reportNull$$$0(2);
        }
        this.myAddedParams = new ArrayList<DocstringParam>();
        this.myRemovedParams = new ArrayList<DocstringParam>();
        this.myUseTypesFromDebuggerSignature = true;
        this.myAddFirstEmptyLine = false;
        this.myParametersPrepared = false;
        this.myQuotes = TRIPLE_DOUBLE_QUOTES;
        this.myDocStringOwner = docStringOwner;
        this.myDocStringIndent = indentation;
        this.myDocStringFormat = format;
        this.myDocStringText = docStringText;
        this.myNewMode = this.myDocStringText == null;
        this.mySettingsAnchor = settingsAnchor;
    }

    @NotNull
    public static PyDocstringGenerator forDocStringOwner(@NotNull PyAstDocStringOwner owner) {
        if (owner == null) {
            PyDocstringGenerator.$$$reportNull$$$0(3);
        }
        String indentation = "";
        if (owner instanceof PyAstStatementListContainer) {
            indentation = PyIndentUtil.getElementIndent((PsiElement)((PyAstStatementListContainer)((Object)owner)).getStatementList());
        }
        String docStringText = owner.getDocStringExpression() == null ? null : owner.getDocStringExpression().getText();
        return new PyDocstringGenerator(owner, docStringText, DocStringParser.getConfiguredDocStringFormatOrPlain((PsiElement)owner), indentation, (PsiElement)owner);
    }

    @NotNull
    public static PyDocstringGenerator create(@NotNull DocStringFormat format, @NotNull String indentation, @NotNull PsiElement settingsAnchor) {
        if (format == null) {
            PyDocstringGenerator.$$$reportNull$$$0(4);
        }
        if (indentation == null) {
            PyDocstringGenerator.$$$reportNull$$$0(5);
        }
        if (settingsAnchor == null) {
            PyDocstringGenerator.$$$reportNull$$$0(6);
        }
        return new PyDocstringGenerator(null, null, format, indentation, settingsAnchor);
    }

    @NotNull
    public static PyDocstringGenerator update(@NotNull PyAstStringLiteralExpression docString) {
        if (docString == null) {
            PyDocstringGenerator.$$$reportNull$$$0(7);
        }
        return new PyDocstringGenerator((PyAstDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)docString, PyAstDocStringOwner.class), docString.getText(), DocStringParser.getConfiguredDocStringFormatOrPlain(docString), PyIndentUtil.getElementIndent(docString), docString);
    }

    @NotNull
    public static PyDocstringGenerator update(@NotNull DocStringFormat format, @NotNull String indentation, @NotNull String text, PsiElement settingsAnchor) {
        if (format == null) {
            PyDocstringGenerator.$$$reportNull$$$0(8);
        }
        if (indentation == null) {
            PyDocstringGenerator.$$$reportNull$$$0(9);
        }
        if (text == null) {
            PyDocstringGenerator.$$$reportNull$$$0(10);
        }
        return new PyDocstringGenerator(null, text, format, indentation, settingsAnchor);
    }

    @NotNull
    public PyDocstringGenerator withParam(@NotNull String name) {
        if (name == null) {
            PyDocstringGenerator.$$$reportNull$$$0(11);
        }
        PyDocstringGenerator pyDocstringGenerator = this.withParamTypedByName(name, null);
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(12);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withParam(@NotNull PyAstNamedParameter param) {
        if (param == null) {
            PyDocstringGenerator.$$$reportNull$$$0(13);
        }
        PyDocstringGenerator pyDocstringGenerator = this.withParam(this.getPreferredParameterName(param));
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(14);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withParamTypedByName(@NotNull String name, @Nullable String type) {
        if (name == null) {
            PyDocstringGenerator.$$$reportNull$$$0(15);
        }
        this.myAddedParams.add(new DocstringParam(name, type, false));
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(16);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withParamTypedByName(@NotNull PyAstNamedParameter name, @Nullable String type) {
        if (name == null) {
            PyDocstringGenerator.$$$reportNull$$$0(17);
        }
        PyDocstringGenerator pyDocstringGenerator = this.withParamTypedByName(this.getPreferredParameterName(name), type);
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(18);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withReturnValue(@Nullable String type) {
        this.myAddedParams.add(new DocstringParam("", type, true));
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(19);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withoutParam(@NotNull String name) {
        if (name == null) {
            PyDocstringGenerator.$$$reportNull$$$0(20);
        }
        this.myRemovedParams.add(new DocstringParam(name, null, false));
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(21);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withQuotes(@NotNull String quotes) {
        if (quotes == null) {
            PyDocstringGenerator.$$$reportNull$$$0(22);
        }
        this.myQuotes = quotes;
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(23);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator useTypesFromDebuggerSignature(boolean use) {
        this.myUseTypesFromDebuggerSignature = use;
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(24);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator addFirstEmptyLine() {
        this.myAddFirstEmptyLine = true;
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(25);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator forceNewMode() {
        this.myNewMode = true;
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(26);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withInferredParameters(boolean addReturn) {
        if (this.myDocStringOwner instanceof PyAstFunction) {
            for (PyAstParameter param : ((PyAstFunction)this.myDocStringOwner).getParameterList().getParameters()) {
                if (param.getAsNamed() == null) continue;
                String paramName = param.getName();
                StructuredDocString docString = this.getStructuredDocString();
                if (StringUtil.isEmpty((String)paramName) || param.isSelf() || docString != null && docString.getParameters().contains(paramName)) continue;
                this.withParam((PyAstNamedParameter)param);
            }
            RaiseVisitor visitor = new RaiseVisitor();
            PyAstStatementList statementList = ((PyAstFunction)this.myDocStringOwner).getStatementList();
            statementList.accept(visitor);
            if (!PyUtilCore.isConstructorLikeMethod((PsiElement)this.myDocStringOwner) && (visitor.myHasReturn || addReturn)) {
                this.withReturnValue(null);
            }
        }
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(27);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public String getDocStringIndent() {
        String string = this.myDocStringIndent;
        if (string == null) {
            PyDocstringGenerator.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public DocStringFormat getDocStringFormat() {
        DocStringFormat docStringFormat = this.myDocStringFormat;
        if (docStringFormat == null) {
            PyDocstringGenerator.$$$reportNull$$$0(29);
        }
        return docStringFormat;
    }

    public boolean isNewMode() {
        return this.myNewMode;
    }

    private void prepareParameters() {
        if (this.myParametersPrepared) {
            return;
        }
        HashSet<Pair> withoutType = new HashSet<Pair>();
        HashMap paramTypes = Maps.newHashMap();
        for (DocstringParam param : this.myAddedParams) {
            if (param.getType() == null) {
                withoutType.add(Pair.create((Object)param.getName(), (Object)param.isReturnValue()));
                continue;
            }
            paramTypes.put(Pair.create((Object)param.getName(), (Object)param.isReturnValue()), param.getType());
        }
        PySignature signature = null;
        if (this.myDocStringOwner instanceof PyAstFunction && this.myUseTypesFromDebuggerSignature) {
            signature = PySignatureCacheManager.getInstance(this.myDocStringOwner.getProject()).findSignature((PyAstFunction)this.myDocStringOwner);
        }
        DocStringFormat format = this.myDocStringFormat;
        ArrayList<DocstringParam> filtered = new ArrayList<DocstringParam>();
        HashSet<Pair> processed = new HashSet<Pair>();
        for (DocstringParam param : this.myAddedParams) {
            Pair paramCoordinates = Pair.create((Object)param.getName(), (Object)param.isReturnValue());
            if (processed.contains(paramCoordinates)) continue;
            if (param.getType() == null) {
                String type = (String)paramTypes.get(paramCoordinates);
                if (type == null && PyCodeInsightSettings.getInstance().INSERT_TYPE_DOCSTUB) {
                    type = signature != null ? StringUtil.notNullize((String)(param.isReturnValue() ? signature.getReturnTypeQualifiedName() : signature.getArgTypeQualifiedName(param.getName()))) : "";
                }
                if (type != null) {
                    if (format != DocStringFormat.GOOGLE && format != DocStringFormat.NUMPY) {
                        filtered.add(param);
                    }
                    filtered.add(new DocstringParam(param.getName(), type, param.isReturnValue()));
                } else {
                    filtered.add(param);
                }
            } else if (!withoutType.contains(paramCoordinates)) {
                filtered.add(param);
            }
            processed.add(paramCoordinates);
        }
        this.myAddedParams.clear();
        this.myAddedParams.addAll(filtered);
        this.myParametersPrepared = true;
    }

    public boolean hasParametersToAdd() {
        this.prepareParameters();
        return !this.myAddedParams.isEmpty();
    }

    @Nullable
    public PyAstStringLiteralExpression getDocStringExpression() {
        Preconditions.checkNotNull((Object)this.myDocStringOwner, (Object)"For this action docstring owner must be supplied");
        return this.myDocStringOwner.getDocStringExpression();
    }

    @Nullable
    private StructuredDocString getStructuredDocString() {
        return this.myDocStringText == null ? null : DocStringParser.parseDocString(this.myDocStringFormat, this.myDocStringText);
    }

    @NotNull
    public String getPreferredParameterName(@NotNull PyAstNamedParameter parameter) {
        if (parameter == null) {
            PyDocstringGenerator.$$$reportNull$$$0(30);
        }
        if (this.getDocStringFormat() == DocStringFormat.GOOGLE) {
            String string = parameter.getAsNamed().getRepr(false);
            if (string == null) {
                PyDocstringGenerator.$$$reportNull$$$0(31);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)parameter.getName());
        if (string == null) {
            PyDocstringGenerator.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public static String getDefaultType(@NotNull DocstringParam param) {
        if (param == null) {
            PyDocstringGenerator.$$$reportNull$$$0(33);
        }
        if (StringUtil.isEmpty((String)param.getType())) {
            return "object";
        }
        String string = param.getType();
        if (string == null) {
            PyDocstringGenerator.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public String buildDocString() {
        this.prepareParameters();
        if (this.myNewMode) {
            return this.createDocString();
        }
        return this.updateDocString();
    }

    @NotNull
    private String createDocString() {
        DocStringBuilder builder = null;
        if (this.myDocStringFormat == DocStringFormat.REST) {
            builder = new TagBasedDocStringBuilder(":");
            TagBasedDocStringBuilder tagBuilder = builder;
            if (this.myAddFirstEmptyLine) {
                tagBuilder.addEmptyLine();
            }
            for (DocstringParam param2 : this.myAddedParams) {
                if (param2.isReturnValue()) {
                    if (param2.getType() != null) {
                        tagBuilder.addReturnValueType(param2.getType());
                        continue;
                    }
                    tagBuilder.addReturnValueDescription("");
                    continue;
                }
                if (param2.getType() != null) {
                    tagBuilder.addParameterType(param2.getName(), param2.getType());
                    continue;
                }
                tagBuilder.addParameterDescription(param2.getName(), "");
            }
        } else if (this.myDocStringFormat == DocStringFormat.GOOGLE || this.myDocStringFormat == DocStringFormat.NUMPY) {
            List returnValues;
            List parameters;
            builder = this.myDocStringFormat == DocStringFormat.GOOGLE ? GoogleCodeStyleDocStringBuilder.forSettings(this.mySettingsAnchor.getContainingFile()) : new NumpyDocStringBuilder();
            SectionBasedDocStringBuilder sectionBuilder = (SectionBasedDocStringBuilder)builder;
            if (this.myAddFirstEmptyLine) {
                sectionBuilder.addEmptyLine();
            }
            if (!(parameters = ContainerUtil.findAll(this.myAddedParams, param -> !param.isReturnValue())).isEmpty()) {
                sectionBuilder.startParametersSection();
                for (DocstringParam param3 : parameters) {
                    sectionBuilder.addParameter(param3.getName(), param3.getType(), "");
                }
            }
            if (!(returnValues = ContainerUtil.findAll(this.myAddedParams, param -> param.isReturnValue())).isEmpty()) {
                sectionBuilder.startReturnsSection();
                boolean hasTypedReturns = false;
                for (DocstringParam returnValue : returnValues) {
                    if (!StringUtil.isNotEmpty((String)returnValue.getType())) continue;
                    sectionBuilder.addReturnValue(null, returnValue.getType(), "");
                    hasTypedReturns = true;
                }
                if (!hasTypedReturns) {
                    sectionBuilder.addEmptyLine();
                }
            }
        }
        if (builder != null && !builder.getLines().isEmpty()) {
            String string = this.myQuotes + "\n" + builder.buildContent(this.myDocStringIndent, true) + "\n" + this.myDocStringIndent + this.myQuotes;
            if (string == null) {
                PyDocstringGenerator.$$$reportNull$$$0(35);
            }
            return string;
        }
        return this.createEmptyFallbackDocString();
    }

    @NotNull
    private String updateDocString() {
        DocStringUpdater updater = null;
        if (this.myDocStringFormat == DocStringFormat.REST) {
            updater = new TagBasedDocStringUpdater((TagBasedDocString)this.getStructuredDocString(), ":", this.myDocStringIndent);
        } else if (this.myDocStringFormat == DocStringFormat.GOOGLE) {
            updater = GoogleCodeStyleDocStringUpdater.forSettings((GoogleCodeStyleDocString)this.getStructuredDocString(), this.myDocStringIndent, this.mySettingsAnchor.getContainingFile());
        } else if (this.myDocStringFormat == DocStringFormat.NUMPY) {
            updater = new NumpyDocStringUpdater((SectionBasedDocString)this.getStructuredDocString(), this.myDocStringIndent);
        } else if (this.myDocStringText != null) {
            String string = this.myDocStringText;
            if (string == null) {
                PyDocstringGenerator.$$$reportNull$$$0(36);
            }
            return string;
        }
        if (updater != null) {
            for (DocstringParam param : this.myAddedParams) {
                if (param.isReturnValue()) {
                    updater.addReturnValue(param.getType());
                    continue;
                }
                updater.addParameter(param.getName(), param.getType());
            }
            for (DocstringParam param : this.myRemovedParams) {
                if (param.isReturnValue()) continue;
                updater.removeParameter(param.getName());
            }
            String string = updater.getDocStringText();
            if (string == null) {
                PyDocstringGenerator.$$$reportNull$$$0(37);
            }
            return string;
        }
        return this.createEmptyFallbackDocString();
    }

    @NotNull
    private String createEmptyFallbackDocString() {
        String string = this.myQuotes + "\n" + this.myDocStringIndent + this.myQuotes;
        if (string == null) {
            PyDocstringGenerator.$$$reportNull$$$0(38);
        }
        return string;
    }

    public DocstringParam getParamToEdit() {
        if (this.myAddedParams.isEmpty()) {
            throw new IllegalStateException("We should have at least one param to edit");
        }
        return this.myAddedParams.get(0);
    }

    @NotNull
    public PyAstDocStringOwner buildAndInsert(@NotNull String replacementText) {
        if (replacementText == null) {
            PyDocstringGenerator.$$$reportNull$$$0(39);
        }
        Preconditions.checkNotNull((Object)this.myDocStringOwner, (Object)"For this action docstring owner must be supplied");
        Project project = this.myDocStringOwner.getProject();
        PyAstElementGenerator elementGenerator = PyAstElementGenerator.getInstance(project);
        PyAstExpressionStatement replacement = elementGenerator.createDocstring(replacementText);
        PyAstStringLiteralExpression docStringExpression = this.getDocStringExpression();
        if (docStringExpression != null) {
            docStringExpression.replace((PsiElement)replacement.getExpression());
        } else {
            PyAstDocStringOwner pyAstDocStringOwner = this.myDocStringOwner;
            if (pyAstDocStringOwner instanceof PyAstFile) {
                PyAstFile pyAstFile = (PyAstFile)pyAstDocStringOwner;
                PsiElement lastCommentOrNull = null;
                for (PsiElement child : pyAstFile.getChildren()) {
                    if (child instanceof PsiWhiteSpace) continue;
                    if (!(child instanceof PsiComment)) break;
                    lastCommentOrNull = child;
                }
                this.myDocStringOwner.addAfter((PsiElement)replacement, lastCommentOrNull);
                PyAstDocStringOwner pyAstDocStringOwner2 = this.myDocStringOwner;
                if (pyAstDocStringOwner2 == null) {
                    PyDocstringGenerator.$$$reportNull$$$0(40);
                }
                return pyAstDocStringOwner2;
            }
            PyAstStatementListContainer container = (PyAstStatementListContainer)ObjectUtils.tryCast((Object)this.myDocStringOwner, PyAstStatementListContainer.class);
            if (container == null) {
                throw new IllegalStateException("Should be a function or class");
            }
            PyAstStatementList statements = container.getStatementList();
            String indentation = PyIndentUtil.getElementIndent((PsiElement)statements);
            PyUtilCore.updateDocumentUnblockedAndCommitted((PsiElement)this.myDocStringOwner, (Consumer<? super Document>)((Consumer)document -> {
                PsiElement beforeStatements = statements.getPrevSibling();
                String replacementWithLineBreaks = "\n" + indentation + replacementText;
                if (statements.getStatements().length > 0) {
                    replacementWithLineBreaks = replacementWithLineBreaks + "\n" + indentation;
                }
                TextRange range = beforeStatements.getTextRange();
                if (!(beforeStatements instanceof PsiWhiteSpace)) {
                    document.insertString(range.getEndOffset(), (CharSequence)replacementWithLineBreaks);
                } else if (statements.getStatements().length == 0 && beforeStatements.textContains('\n')) {
                    document.insertString(range.getStartOffset(), (CharSequence)replacementWithLineBreaks);
                } else {
                    document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replacementWithLineBreaks);
                }
            }));
        }
        PyAstDocStringOwner pyAstDocStringOwner = this.myDocStringOwner;
        if (pyAstDocStringOwner == null) {
            PyDocstringGenerator.$$$reportNull$$$0(41);
        }
        return pyAstDocStringOwner;
    }

    @NotNull
    public PyAstDocStringOwner buildAndInsert() {
        Preconditions.checkNotNull((Object)this.myDocStringOwner, (Object)"For this action docstring owner must be supplied");
        PyAstDocStringOwner pyAstDocStringOwner = this.buildAndInsert(this.buildDocString());
        if (pyAstDocStringOwner == null) {
            PyDocstringGenerator.$$$reportNull$$$0(42);
        }
        return pyAstDocStringOwner;
    }

    @Nullable
    public PyAstDocStringOwner getDocStringOwner() {
        return this.myDocStringOwner;
    }

    public List<DocstringParam> getAddedParams() {
        return this.myAddedParams;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 14, 16, 18, 19, 21, 23, 24, 25, 26, 27, 28, 29, 31, 32, 34, 35, 36, 37, 38, 40, 41, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentation";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsAnchor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docString";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator";
                break;
            }
            case 13: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotes";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "withParam";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "withParamTypedByName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "withReturnValue";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutParam";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "withQuotes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "useTypesFromDebuggerSignature";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "addFirstEmptyLine";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "forceNewMode";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "withInferredParameters";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocStringIndent";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocStringFormat";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredParameterName";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultType";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocString";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "updateDocString";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyFallbackDocString";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAndInsert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forDocStringOwner";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "withParam";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "withParamTypedByName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "withoutParam";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "withQuotes";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredParameterName";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultType";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "buildAndInsert";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 14, 16, 18, 19, 21, 23, 24, 25, 26, 27, 28, 29, 31, 32, 34, 35, 36, 37, 38, 40, 41, 42 -> new IllegalStateException(string);
        };
    }

    public static final class DocstringParam {
        private final String myName;
        private final String myType;
        private final boolean myReturnValue;

        private DocstringParam(@NotNull String name, @Nullable String type, boolean isReturn) {
            if (name == null) {
                DocstringParam.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myType = type;
            this.myReturnValue = isReturn;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                DocstringParam.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public String getType() {
            return this.myType;
        }

        public boolean isReturnValue() {
            return this.myReturnValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DocstringParam param = (DocstringParam)o;
            if (this.myReturnValue != param.myReturnValue) {
                return false;
            }
            if (!this.myName.equals(param.myName)) {
                return false;
            }
            return Objects.equals(this.myType, param.myType);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
            result = 31 * result + (this.myReturnValue ? 1 : 0);
            return result;
        }

        public String toString() {
            return "DocstringParam{myName='" + this.myName + "', myType='" + this.myType + "', myReturnValue=" + this.myReturnValue + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator$DocstringParam";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator$DocstringParam";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class RaiseVisitor
    extends PyAstRecursiveElementVisitor {
        private boolean myHasRaise = false;
        private boolean myHasReturn = false;
        @Nullable
        private PyAstExpression myRaiseTarget = null;

        private RaiseVisitor() {
        }

        @Override
        public void visitPyRaiseStatement(@NotNull PyAstRaiseStatement node) {
            if (node == null) {
                RaiseVisitor.$$$reportNull$$$0(0);
            }
            this.myHasRaise = true;
            PyAstExpression[] expressions = node.getExpressions();
            if (expressions.length > 0) {
                this.myRaiseTarget = expressions[0];
            }
        }

        @Override
        public void visitPyReturnStatement(@NotNull PyAstReturnStatement node) {
            if (node == null) {
                RaiseVisitor.$$$reportNull$$$0(1);
            }
            this.myHasReturn = true;
        }

        @NotNull
        public String getRaiseTargetText() {
            if (this.myRaiseTarget != null) {
                PyAstExpression callee;
                String raiseTarget = this.myRaiseTarget.getText();
                if (this.myRaiseTarget instanceof PyAstCallExpression && (callee = ((PyAstCallExpression)this.myRaiseTarget).getCallee()) != null) {
                    raiseTarget = callee.getText();
                }
                String string = raiseTarget;
                if (string == null) {
                    RaiseVisitor.$$$reportNull$$$0(2);
                }
                return string;
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator$RaiseVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator$RaiseVisitor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRaiseTargetText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyRaiseStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyReturnStatement";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

