/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.hub.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.ui.ClickListener;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0011\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u0004H'J\b\u0010\u000f\u001a\u00020\rH&J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0015\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\rH\u0002J\b\u0010\u0016\u001a\u00020\rH\u0002J\b\u0010\u0017\u001a\u00020\rH\u0002J\b\u0010\u0018\u001a\u00020\rH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/swagger/core/hub/ui/SwaggerHubFilterPanelBase;", "T", "Ljavax/swing/JPanel;", "filterName", "", "<init>", "(Ljava/lang/String;)V", "myNameLabel", "Lcom/intellij/ui/components/JBLabel;", "myValueLabel", "getMyValueLabel", "()Lcom/intellij/ui/components/JBLabel;", "init", "", "retrieveFilterValue", "showVariantsPopup", "isEnabled", "", "applyChanges", "value", "(Ljava/lang/Object;)V", "indicateHovering", "setOnHoverForeground", "setDefaultForeground", "showPopupOnClick", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwaggerHubFilterPanelBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerHubFilterPanelBase.kt\ncom/intellij/swagger/core/hub/ui/SwaggerHubFilterPanelBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public abstract class SwaggerHubFilterPanelBase<T>
extends JPanel {
    @NotNull
    private final JBLabel myNameLabel;
    @NotNull
    private final JBLabel myValueLabel;

    public SwaggerHubFilterPanelBase(@Nls @NotNull String filterName) {
        Intrinsics.checkNotNullParameter((Object)filterName, (String)"filterName");
        this.myNameLabel = new JBLabel(filterName + ": ");
        this.myValueLabel = new JBLabel(this){
            final /* synthetic */ SwaggerHubFilterPanelBase<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public String getText() {
                String string;
                String it = string = this.this$0.retrieveFilterValue();
                boolean bl = false;
                String string2 = !StringsKt.isBlank((CharSequence)it) ? string : null;
                if (string2 == null) {
                    string2 = SwaggerBundle.message("settings.hub.filters.any.value.accepted", new Object[0]);
                }
                return string2;
            }
        };
        this.init();
    }

    @NotNull
    protected final JBLabel getMyValueLabel() {
        return this.myValueLabel;
    }

    private final void init() {
        this.setLayout(new BoxLayout(this, 0));
        this.setDefaultForeground();
        this.add((Component)this.myNameLabel);
        this.add((Component)this.myValueLabel);
        this.add(Box.createHorizontalStrut(3));
        this.add((Component)new JBLabel(AllIcons.Ide.Statusbar_arrows));
        this.showPopupOnClick();
        this.indicateHovering();
    }

    @NlsSafe
    @NotNull
    public abstract String retrieveFilterValue();

    public abstract void showVariantsPopup();

    @Override
    public boolean isEnabled() {
        return true;
    }

    public void applyChanges(T value) {
        this.myValueLabel.revalidate();
        this.myValueLabel.repaint();
    }

    private final void indicateHovering() {
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ SwaggerHubFilterPanelBase<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.this$0.isEnabled()) {
                    SwaggerHubFilterPanelBase.access$setOnHoverForeground(this.this$0);
                }
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.this$0.isEnabled()) {
                    SwaggerHubFilterPanelBase.access$setDefaultForeground(this.this$0);
                }
            }
        });
    }

    private final void setOnHoverForeground() {
        this.myNameLabel.setForeground(StartupUiUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextAreaForeground());
    }

    private final void setDefaultForeground() {
        Color color;
        Color $this$setDefaultForeground_u24lambda_u241 = color = NamedColorUtil.getInactiveTextColor();
        boolean bl = false;
        if (StartupUiUtil.isUnderDarcula()) {
            int n = 3;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl2 = false;
                $this$setDefaultForeground_u24lambda_u241.brighter();
            }
        }
        Color color2 = color;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"apply(...)");
        Color foregroundColor = color2;
        this.myNameLabel.setForeground(foregroundColor);
        if (!this.isEnabled()) {
            this.myValueLabel.setForeground(foregroundColor);
        }
    }

    private final void showPopupOnClick() {
        new ClickListener(this){
            final /* synthetic */ SwaggerHubFilterPanelBase<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onClick(MouseEvent event, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.this$0.isEnabled()) {
                    this.this$0.showVariantsPopup();
                }
                return true;
            }
        }.installOn((Component)this);
    }

    public static final /* synthetic */ void access$setOnHoverForeground(SwaggerHubFilterPanelBase $this) {
        $this.setOnHoverForeground();
    }

    public static final /* synthetic */ void access$setDefaultForeground(SwaggerHubFilterPanelBase $this) {
        $this.setDefaultForeground();
    }
}

