/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CloudSpannerJdbcHelper
extends JdbcHelperImpl {
    public CloudSpannerJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("CLOUD_SPANNER", version, connection);
    }

    public CloudSpannerJdbcHelper() {
        this(null, null);
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "Cloud Spanner")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return CloudSpannerJdbcHelper.create(delegate, productVer);
    }

    @NotNull
    private static CloudSpannerJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new CloudSpannerJdbcHelper(CloudSpannerJdbcHelper.extractVersion(productVer), delegate);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return CloudSpannerJdbcHelper.extractVersion(version);
    }

    @Nullable
    private static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection) {
        return new CloudSpannerJdbcHelper(version, connection);
    }

    @Override
    public JdbcHelper.LikeSupport getLikeSupport() {
        return JdbcHelper.LikeSupport.NONE;
    }
}

