/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote;

import java.util.Map;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestRunnerFactory;
import org.testng.TestNG;
import org.testng.TestNGCommandLineArgs;
import org.testng.TestRunner;
import org.testng.remote.strprotocol.GenericMessage;
import org.testng.remote.strprotocol.RemoteMessageSenderTestListener;
import org.testng.remote.strprotocol.StringMessageSenderHelper;
import org.testng.remote.strprotocol.SuiteMessage;
import org.testng.reporters.JUnitXMLReporter;
import org.testng.reporters.TestHTMLReporter;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class RemoteTestNG
extends TestNG {
    private static final String LOCALHOST = "127.0.0.1";
    private ITestRunnerFactory m_customTestRunnerFactory;
    protected String m_host;
    protected int m_port;

    public void setConnectionParameters(String host, int port) {
        this.m_host = null == host || "".equals(host) ? LOCALHOST : host;
        this.m_port = port;
    }

    public void configure(Map cmdLineArgs) {
        super.configure(cmdLineArgs);
        this.setConnectionParameters((String)cmdLineArgs.get("-host"), Integer.parseInt((String)cmdLineArgs.get("-port")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StringMessageSenderHelper msh = new StringMessageSenderHelper(this.m_host, this.m_port);
        try {
            if (msh.connect()) {
                if (this.m_suites.size() > 0) {
                    int testCount = 0;
                    for (int i = 0; i < this.m_suites.size(); ++i) {
                        testCount += ((XmlSuite)this.m_suites.get(i)).getTests().size();
                    }
                    GenericMessage gm = new GenericMessage(1);
                    gm.addProperty("suiteCount", this.m_suites.size()).addProperty("testCount", testCount);
                    msh.sendMessage(gm);
                    this.addListener(new RemoteSuiteListener(msh));
                    this.setTestRunnerFactory(new DelegatingTestRunnerFactory(this.buildTestRunnerFactory(), msh));
                    super.run();
                } else {
                    System.err.println("WARNING: No test suite found.  Nothing to run");
                }
            } else {
                System.err.println("Cannot connect to " + this.m_host + " on " + this.m_port);
            }
        }
        catch (Throwable cause) {
            cause.printStackTrace(System.err);
        }
        finally {
            msh.shutDown();
            System.exit(0);
        }
    }

    protected ITestRunnerFactory buildTestRunnerFactory() {
        if (null == this.m_customTestRunnerFactory) {
            this.m_customTestRunnerFactory = new ITestRunnerFactory(){

                public TestRunner newTestRunner(ISuite suite, XmlTest xmlTest) {
                    TestRunner runner = new TestRunner(suite, xmlTest, false);
                    if (RemoteTestNG.this.m_useDefaultListeners) {
                        runner.addListener(new TestHTMLReporter());
                        runner.addListener(new JUnitXMLReporter());
                    }
                    return runner;
                }
            };
        }
        return this.m_customTestRunnerFactory;
    }

    public static void main(String[] args) {
        Map commandLineArgs = TestNGCommandLineArgs.parseCommandLine(args);
        RemoteTestNG testNG = new RemoteTestNG();
        testNG.configure(commandLineArgs);
        testNG.run();
    }

    private static class DelegatingTestRunnerFactory
    implements ITestRunnerFactory {
        private final ITestRunnerFactory m_delagateFactory;
        private final StringMessageSenderHelper m_messageSender;

        DelegatingTestRunnerFactory(ITestRunnerFactory trf, StringMessageSenderHelper smsh) {
            this.m_delagateFactory = trf;
            this.m_messageSender = smsh;
        }

        public TestRunner newTestRunner(ISuite suite, XmlTest test) {
            TestRunner tr = this.m_delagateFactory.newTestRunner(suite, test);
            tr.addListener(new RemoteMessageSenderTestListener(suite, test, this.m_messageSender));
            return tr;
        }
    }

    private static class RemoteSuiteListener
    implements ISuiteListener {
        private final StringMessageSenderHelper m_messageSender;

        RemoteSuiteListener(StringMessageSenderHelper smsh) {
            this.m_messageSender = smsh;
        }

        public void onFinish(ISuite suite) {
            this.m_messageSender.sendMessage(new SuiteMessage(suite, false));
        }

        public void onStart(ISuite suite) {
            this.m_messageSender.sendMessage(new SuiteMessage(suite, true));
        }
    }
}

