package performancetimeline

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/dom"
)

// LargestContentfulPaint see https://github.com/WICG/LargestContentfulPaint
// and largest_contentful_paint.idl.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/PerformanceTimeline#type-LargestContentfulPaint
type LargestContentfulPaint struct {
	RenderTime *cdp.TimeSinceEpoch `json:"renderTime"`
	LoadTime   *cdp.TimeSinceEpoch `json:"loadTime"`
	Size       float64             `json:"size"`                // The number of pixels being painted.
	ElementID  string              `json:"elementId,omitempty"` // The id attribute of the element, if available.
	URL        string              `json:"url,omitempty"`       // The URL of the image (may be trimmed).
	NodeID     cdp.BackendNodeID   `json:"nodeId,omitempty"`
}

// LayoutShiftAttribution [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/PerformanceTimeline#type-LayoutShiftAttribution
type LayoutShiftAttribution struct {
	PreviousRect *dom.Rect         `json:"previousRect"`
	CurrentRect  *dom.Rect         `json:"currentRect"`
	NodeID       cdp.BackendNodeID `json:"nodeId,omitempty"`
}

// LayoutShift see
// https://wicg.github.io/layout-instability/#sec-layout-shift and
// layout_shift.idl.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/PerformanceTimeline#type-LayoutShift
type LayoutShift struct {
	Value          float64                   `json:"value"` // Score increment produced by this event.
	HadRecentInput bool                      `json:"hadRecentInput"`
	LastInputTime  *cdp.TimeSinceEpoch       `json:"lastInputTime"`
	Sources        []*LayoutShiftAttribution `json:"sources"`
}

// TimelineEvent [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/PerformanceTimeline#type-TimelineEvent
type TimelineEvent struct {
	FrameID            cdp.FrameID             `json:"frameId"`            // Identifies the frame that this event is related to. Empty for non-frame targets.
	Type               string                  `json:"type"`               // The event type, as specified in https://w3c.github.io/performance-timeline/#dom-performanceentry-entrytype This determines which of the optional "details" fields is present.
	Name               string                  `json:"name"`               // Name may be empty depending on the type.
	Time               *cdp.TimeSinceEpoch     `json:"time"`               // Time in seconds since Epoch, monotonically increasing within document lifetime.
	Duration           float64                 `json:"duration,omitempty"` // Event duration, if applicable.
	LcpDetails         *LargestContentfulPaint `json:"lcpDetails,omitempty"`
	LayoutShiftDetails *LayoutShift            `json:"layoutShiftDetails,omitempty"`
}
