/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram.syntrax;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.commons.cli.ParseException;
import org.asciidoctor.diagram.DiagramGeneratorFunction;
import org.asciidoctor.diagram.HTTPHeader;
import org.asciidoctor.diagram.MimeType;
import org.asciidoctor.diagram.Request;
import org.asciidoctor.diagram.ResponseData;
import org.atpfivt.jsyntrax.InputArguments;
import org.atpfivt.jsyntrax.Main;
import org.atpfivt.jsyntrax.styles.StyleConfig;
import org.atpfivt.jsyntrax.util.SVGTranscoder;

public class Syntrax
implements DiagramGeneratorFunction {
    public static final MimeType DEFAULT_OUTPUT_FORMAT = MimeType.SVG;

    public ResponseData generate(Request request) throws IOException {
        InputArguments iArgs;
        MimeType format = (MimeType)request.headers.getValue(HTTPHeader.ACCEPT);
        if (format == null) {
            format = DEFAULT_OUTPUT_FORMAT;
        }
        if (!format.equals((Object)MimeType.SVG) && !format.equals((Object)MimeType.PNG)) {
            throw new IOException("Unsupported output format: " + format);
        }
        String[] options = new String[]{};
        String optionString = (String)request.headers.getValue(HTTPHeader.OPTIONS);
        if (optionString != null) {
            options = optionString.split(" ");
        }
        try {
            iArgs = new InputArguments(options);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        StyleConfig style = Main.getStyleConfig((InputArguments)iArgs);
        String title = iArgs.getTitle();
        String result = Main.generateSVG((String)title, (StyleConfig)style, (String)new String(request.data, StandardCharsets.UTF_8));
        byte[] responseData = result.getBytes(StandardCharsets.UTF_8);
        try {
            if (format.equals((Object)MimeType.PNG)) {
                responseData = SVGTranscoder.svg2Png((String)result);
            }
        }
        catch (TranscoderException e) {
            throw new IOException(e);
        }
        return new ResponseData(format, responseData);
    }
}

