// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.2
// source: google/cloud/gkemulticloud/v1/aws_resources.proto

package gkemulticloudpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The lifecycle state of the cluster.
type AwsCluster_State int32

const (
	// Not set.
	AwsCluster_STATE_UNSPECIFIED AwsCluster_State = 0
	// The PROVISIONING state indicates the cluster is being created.
	AwsCluster_PROVISIONING AwsCluster_State = 1
	// The RUNNING state indicates the cluster has been created and is fully
	// usable.
	AwsCluster_RUNNING AwsCluster_State = 2
	// The RECONCILING state indicates that some work is actively being done on
	// the cluster, such as upgrading the control plane replicas.
	AwsCluster_RECONCILING AwsCluster_State = 3
	// The STOPPING state indicates the cluster is being deleted.
	AwsCluster_STOPPING AwsCluster_State = 4
	// The ERROR state indicates the cluster is in a broken unrecoverable
	// state.
	AwsCluster_ERROR AwsCluster_State = 5
	// The DEGRADED state indicates the cluster requires user action to
	// restore full functionality.
	AwsCluster_DEGRADED AwsCluster_State = 6
)

// Enum value maps for AwsCluster_State.
var (
	AwsCluster_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PROVISIONING",
		2: "RUNNING",
		3: "RECONCILING",
		4: "STOPPING",
		5: "ERROR",
		6: "DEGRADED",
	}
	AwsCluster_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PROVISIONING":      1,
		"RUNNING":           2,
		"RECONCILING":       3,
		"STOPPING":          4,
		"ERROR":             5,
		"DEGRADED":          6,
	}
)

func (x AwsCluster_State) Enum() *AwsCluster_State {
	p := new(AwsCluster_State)
	*p = x
	return p
}

func (x AwsCluster_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsCluster_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_enumTypes[0].Descriptor()
}

func (AwsCluster_State) Type() protoreflect.EnumType {
	return &file_google_cloud_gkemulticloud_v1_aws_resources_proto_enumTypes[0]
}

func (x AwsCluster_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsCluster_State.Descriptor instead.
func (AwsCluster_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{0, 0}
}

// Types of supported EBS volumes. We currently only support GP2 or GP3
// volumes.
// See https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html
// for more information.
type AwsVolumeTemplate_VolumeType int32

const (
	// Not set.
	AwsVolumeTemplate_VOLUME_TYPE_UNSPECIFIED AwsVolumeTemplate_VolumeType = 0
	// GP2 (General Purpose SSD volume type).
	AwsVolumeTemplate_GP2 AwsVolumeTemplate_VolumeType = 1
	// GP3 (General Purpose SSD volume type).
	AwsVolumeTemplate_GP3 AwsVolumeTemplate_VolumeType = 2
)

// Enum value maps for AwsVolumeTemplate_VolumeType.
var (
	AwsVolumeTemplate_VolumeType_name = map[int32]string{
		0: "VOLUME_TYPE_UNSPECIFIED",
		1: "GP2",
		2: "GP3",
	}
	AwsVolumeTemplate_VolumeType_value = map[string]int32{
		"VOLUME_TYPE_UNSPECIFIED": 0,
		"GP2":                     1,
		"GP3":                     2,
	}
)

func (x AwsVolumeTemplate_VolumeType) Enum() *AwsVolumeTemplate_VolumeType {
	p := new(AwsVolumeTemplate_VolumeType)
	*p = x
	return p
}

func (x AwsVolumeTemplate_VolumeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsVolumeTemplate_VolumeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_enumTypes[1].Descriptor()
}

func (AwsVolumeTemplate_VolumeType) Type() protoreflect.EnumType {
	return &file_google_cloud_gkemulticloud_v1_aws_resources_proto_enumTypes[1]
}

func (x AwsVolumeTemplate_VolumeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsVolumeTemplate_VolumeType.Descriptor instead.
func (AwsVolumeTemplate_VolumeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{7, 0}
}

// The lifecycle state of the node pool.
type AwsNodePool_State int32

const (
	// Not set.
	AwsNodePool_STATE_UNSPECIFIED AwsNodePool_State = 0
	// The PROVISIONING state indicates the node pool is being created.
	AwsNodePool_PROVISIONING AwsNodePool_State = 1
	// The RUNNING state indicates the node pool has been created
	// and is fully usable.
	AwsNodePool_RUNNING AwsNodePool_State = 2
	// The RECONCILING state indicates that the node pool is being reconciled.
	AwsNodePool_RECONCILING AwsNodePool_State = 3
	// The STOPPING state indicates the node pool is being deleted.
	AwsNodePool_STOPPING AwsNodePool_State = 4
	// The ERROR state indicates the node pool is in a broken unrecoverable
	// state.
	AwsNodePool_ERROR AwsNodePool_State = 5
	// The DEGRADED state indicates the node pool requires user action to
	// restore full functionality.
	AwsNodePool_DEGRADED AwsNodePool_State = 6
)

// Enum value maps for AwsNodePool_State.
var (
	AwsNodePool_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PROVISIONING",
		2: "RUNNING",
		3: "RECONCILING",
		4: "STOPPING",
		5: "ERROR",
		6: "DEGRADED",
	}
	AwsNodePool_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PROVISIONING":      1,
		"RUNNING":           2,
		"RECONCILING":       3,
		"STOPPING":          4,
		"ERROR":             5,
		"DEGRADED":          6,
	}
)

func (x AwsNodePool_State) Enum() *AwsNodePool_State {
	p := new(AwsNodePool_State)
	*p = x
	return p
}

func (x AwsNodePool_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsNodePool_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_enumTypes[2].Descriptor()
}

func (AwsNodePool_State) Type() protoreflect.EnumType {
	return &file_google_cloud_gkemulticloud_v1_aws_resources_proto_enumTypes[2]
}

func (x AwsNodePool_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsNodePool_State.Descriptor instead.
func (AwsNodePool_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{9, 0}
}

// Tenancy defines how EC2 instances are distributed across physical hardware.
type AwsInstancePlacement_Tenancy int32

const (
	// Not set.
	AwsInstancePlacement_TENANCY_UNSPECIFIED AwsInstancePlacement_Tenancy = 0
	// Use default VPC tenancy.
	AwsInstancePlacement_DEFAULT AwsInstancePlacement_Tenancy = 1
	// Run a dedicated instance.
	AwsInstancePlacement_DEDICATED AwsInstancePlacement_Tenancy = 2
	// Launch this instance to a dedicated host.
	AwsInstancePlacement_HOST AwsInstancePlacement_Tenancy = 3
)

// Enum value maps for AwsInstancePlacement_Tenancy.
var (
	AwsInstancePlacement_Tenancy_name = map[int32]string{
		0: "TENANCY_UNSPECIFIED",
		1: "DEFAULT",
		2: "DEDICATED",
		3: "HOST",
	}
	AwsInstancePlacement_Tenancy_value = map[string]int32{
		"TENANCY_UNSPECIFIED": 0,
		"DEFAULT":             1,
		"DEDICATED":           2,
		"HOST":                3,
	}
)

func (x AwsInstancePlacement_Tenancy) Enum() *AwsInstancePlacement_Tenancy {
	p := new(AwsInstancePlacement_Tenancy)
	*p = x
	return p
}

func (x AwsInstancePlacement_Tenancy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsInstancePlacement_Tenancy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_enumTypes[3].Descriptor()
}

func (AwsInstancePlacement_Tenancy) Type() protoreflect.EnumType {
	return &file_google_cloud_gkemulticloud_v1_aws_resources_proto_enumTypes[3]
}

func (x AwsInstancePlacement_Tenancy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsInstancePlacement_Tenancy.Descriptor instead.
func (AwsInstancePlacement_Tenancy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{22, 0}
}

// An Anthos cluster running on AWS.
type AwsCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of this resource.
	//
	// Cluster names are formatted as
	// `projects/<project-number>/locations/<region>/awsClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud Platform resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A human readable description of this cluster.
	// Cannot be longer than 255 UTF-8 encoded bytes.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Cluster-wide networking configuration.
	Networking *AwsClusterNetworking `protobuf:"bytes,3,opt,name=networking,proto3" json:"networking,omitempty"`
	// Required. The AWS region where the cluster runs.
	//
	// Each Google Cloud region supports a subset of nearby AWS regions.
	// You can call
	// [GetAwsServerConfig][google.cloud.gkemulticloud.v1.AwsClusters.GetAwsServerConfig]
	// to list all supported AWS regions within a given Google Cloud region.
	AwsRegion string `protobuf:"bytes,4,opt,name=aws_region,json=awsRegion,proto3" json:"aws_region,omitempty"`
	// Required. Configuration related to the cluster control plane.
	ControlPlane *AwsControlPlane `protobuf:"bytes,5,opt,name=control_plane,json=controlPlane,proto3" json:"control_plane,omitempty"`
	// Required. Configuration related to the cluster RBAC settings.
	Authorization *AwsAuthorization `protobuf:"bytes,15,opt,name=authorization,proto3" json:"authorization,omitempty"`
	// Output only. The current state of the cluster.
	State AwsCluster_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.gkemulticloud.v1.AwsCluster_State" json:"state,omitempty"`
	// Output only. The endpoint of the cluster's API server.
	Endpoint string `protobuf:"bytes,8,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Output only. A globally unique identifier for the cluster.
	Uid string `protobuf:"bytes,9,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. If set, there are currently changes in flight to the cluster.
	Reconciling bool `protobuf:"varint,10,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Output only. The time at which this cluster was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this cluster was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Allows clients to perform consistent read-modify-writes
	// through optimistic concurrency control.
	//
	// Can be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,13,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. Annotations on the cluster.
	//
	// This field has the same restrictions as Kubernetes annotations.
	// The total size of all keys and values combined is limited to 256k.
	// Key can have 2 segments: prefix (optional) and name (required),
	// separated by a slash (/).
	// Prefix must be a DNS subdomain.
	// Name must be 63 characters or less, begin and end with alphanumerics,
	// with dashes (-), underscores (_), dots (.), and alphanumerics between.
	Annotations map[string]string `protobuf:"bytes,14,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Workload Identity settings.
	WorkloadIdentityConfig *WorkloadIdentityConfig `protobuf:"bytes,16,opt,name=workload_identity_config,json=workloadIdentityConfig,proto3" json:"workload_identity_config,omitempty"`
	// Output only. PEM encoded x509 certificate of the cluster root of trust.
	ClusterCaCertificate string `protobuf:"bytes,17,opt,name=cluster_ca_certificate,json=clusterCaCertificate,proto3" json:"cluster_ca_certificate,omitempty"`
	// Required. Fleet configuration.
	Fleet *Fleet `protobuf:"bytes,18,opt,name=fleet,proto3" json:"fleet,omitempty"`
	// Optional. Logging configuration for this cluster.
	LoggingConfig *LoggingConfig `protobuf:"bytes,19,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	// Output only. A set of errors found in the cluster.
	Errors []*AwsClusterError `protobuf:"bytes,20,rep,name=errors,proto3" json:"errors,omitempty"`
	// Optional. Monitoring configuration for this cluster.
	MonitoringConfig *MonitoringConfig `protobuf:"bytes,21,opt,name=monitoring_config,json=monitoringConfig,proto3" json:"monitoring_config,omitempty"`
	// Optional. Binary Authorization configuration for this cluster.
	BinaryAuthorization *BinaryAuthorization `protobuf:"bytes,22,opt,name=binary_authorization,json=binaryAuthorization,proto3" json:"binary_authorization,omitempty"`
}

func (x *AwsCluster) Reset() {
	*x = AwsCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsCluster) ProtoMessage() {}

func (x *AwsCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsCluster.ProtoReflect.Descriptor instead.
func (*AwsCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{0}
}

func (x *AwsCluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AwsCluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *AwsCluster) GetNetworking() *AwsClusterNetworking {
	if x != nil {
		return x.Networking
	}
	return nil
}

func (x *AwsCluster) GetAwsRegion() string {
	if x != nil {
		return x.AwsRegion
	}
	return ""
}

func (x *AwsCluster) GetControlPlane() *AwsControlPlane {
	if x != nil {
		return x.ControlPlane
	}
	return nil
}

func (x *AwsCluster) GetAuthorization() *AwsAuthorization {
	if x != nil {
		return x.Authorization
	}
	return nil
}

func (x *AwsCluster) GetState() AwsCluster_State {
	if x != nil {
		return x.State
	}
	return AwsCluster_STATE_UNSPECIFIED
}

func (x *AwsCluster) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *AwsCluster) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *AwsCluster) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *AwsCluster) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AwsCluster) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AwsCluster) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *AwsCluster) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *AwsCluster) GetWorkloadIdentityConfig() *WorkloadIdentityConfig {
	if x != nil {
		return x.WorkloadIdentityConfig
	}
	return nil
}

func (x *AwsCluster) GetClusterCaCertificate() string {
	if x != nil {
		return x.ClusterCaCertificate
	}
	return ""
}

func (x *AwsCluster) GetFleet() *Fleet {
	if x != nil {
		return x.Fleet
	}
	return nil
}

func (x *AwsCluster) GetLoggingConfig() *LoggingConfig {
	if x != nil {
		return x.LoggingConfig
	}
	return nil
}

func (x *AwsCluster) GetErrors() []*AwsClusterError {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *AwsCluster) GetMonitoringConfig() *MonitoringConfig {
	if x != nil {
		return x.MonitoringConfig
	}
	return nil
}

func (x *AwsCluster) GetBinaryAuthorization() *BinaryAuthorization {
	if x != nil {
		return x.BinaryAuthorization
	}
	return nil
}

// ControlPlane defines common parameters between control plane nodes.
type AwsControlPlane struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Kubernetes version to run on control plane replicas
	// (e.g. `1.19.10-gke.1000`).
	//
	// You can list all supported versions on a given Google Cloud region by
	// calling
	// [GetAwsServerConfig][google.cloud.gkemulticloud.v1.AwsClusters.GetAwsServerConfig].
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Optional. The AWS instance type.
	//
	// When unspecified, it uses a default based on the cluster's version.
	InstanceType string `protobuf:"bytes,2,opt,name=instance_type,json=instanceType,proto3" json:"instance_type,omitempty"`
	// Optional. SSH configuration for how to access the underlying control plane
	// machines.
	SshConfig *AwsSshConfig `protobuf:"bytes,14,opt,name=ssh_config,json=sshConfig,proto3" json:"ssh_config,omitempty"`
	// Required. The list of subnets where control plane replicas will run.
	// A replica will be provisioned on each subnet and up to three values
	// can be provided.
	// Each subnet must be in a different AWS Availability Zone (AZ).
	SubnetIds []string `protobuf:"bytes,4,rep,name=subnet_ids,json=subnetIds,proto3" json:"subnet_ids,omitempty"`
	// Optional. The IDs of additional security groups to add to control plane
	// replicas. The Anthos Multi-Cloud API will automatically create and manage
	// security groups with the minimum rules needed for a functioning cluster.
	SecurityGroupIds []string `protobuf:"bytes,5,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	// Required. The name or ARN of the AWS IAM instance profile to assign to each
	// control plane replica.
	IamInstanceProfile string `protobuf:"bytes,7,opt,name=iam_instance_profile,json=iamInstanceProfile,proto3" json:"iam_instance_profile,omitempty"`
	// Optional. Configuration related to the root volume provisioned for each
	// control plane replica.
	//
	// Volumes will be provisioned in the availability zone associated
	// with the corresponding subnet.
	//
	// When unspecified, it defaults to 32 GiB with the GP2 volume type.
	RootVolume *AwsVolumeTemplate `protobuf:"bytes,8,opt,name=root_volume,json=rootVolume,proto3" json:"root_volume,omitempty"`
	// Optional. Configuration related to the main volume provisioned for each
	// control plane replica.
	// The main volume is in charge of storing all of the cluster's etcd state.
	//
	// Volumes will be provisioned in the availability zone associated
	// with the corresponding subnet.
	//
	// When unspecified, it defaults to 8 GiB with the GP2 volume type.
	MainVolume *AwsVolumeTemplate `protobuf:"bytes,9,opt,name=main_volume,json=mainVolume,proto3" json:"main_volume,omitempty"`
	// Required. The ARN of the AWS KMS key used to encrypt cluster secrets.
	DatabaseEncryption *AwsDatabaseEncryption `protobuf:"bytes,10,opt,name=database_encryption,json=databaseEncryption,proto3" json:"database_encryption,omitempty"`
	// Optional. A set of AWS resource tags to propagate to all underlying managed
	// AWS resources.
	//
	// Specify at most 50 pairs containing alphanumerics, spaces, and symbols
	// (.+-=_:@/). Keys can be up to 127 Unicode characters. Values can be up to
	// 255 Unicode characters.
	Tags map[string]string `protobuf:"bytes,11,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Authentication configuration for management of AWS resources.
	AwsServicesAuthentication *AwsServicesAuthentication `protobuf:"bytes,12,opt,name=aws_services_authentication,json=awsServicesAuthentication,proto3" json:"aws_services_authentication,omitempty"`
	// Optional. Proxy configuration for outbound HTTP(S) traffic.
	ProxyConfig *AwsProxyConfig `protobuf:"bytes,16,opt,name=proxy_config,json=proxyConfig,proto3" json:"proxy_config,omitempty"`
	// Required. Config encryption for user data.
	ConfigEncryption *AwsConfigEncryption `protobuf:"bytes,17,opt,name=config_encryption,json=configEncryption,proto3" json:"config_encryption,omitempty"`
	// Optional. The placement to use on control plane instances.
	// When unspecified, the VPC's default tenancy will be used.
	InstancePlacement *AwsInstancePlacement `protobuf:"bytes,18,opt,name=instance_placement,json=instancePlacement,proto3" json:"instance_placement,omitempty"`
}

func (x *AwsControlPlane) Reset() {
	*x = AwsControlPlane{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsControlPlane) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsControlPlane) ProtoMessage() {}

func (x *AwsControlPlane) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsControlPlane.ProtoReflect.Descriptor instead.
func (*AwsControlPlane) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{1}
}

func (x *AwsControlPlane) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AwsControlPlane) GetInstanceType() string {
	if x != nil {
		return x.InstanceType
	}
	return ""
}

func (x *AwsControlPlane) GetSshConfig() *AwsSshConfig {
	if x != nil {
		return x.SshConfig
	}
	return nil
}

func (x *AwsControlPlane) GetSubnetIds() []string {
	if x != nil {
		return x.SubnetIds
	}
	return nil
}

func (x *AwsControlPlane) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

func (x *AwsControlPlane) GetIamInstanceProfile() string {
	if x != nil {
		return x.IamInstanceProfile
	}
	return ""
}

func (x *AwsControlPlane) GetRootVolume() *AwsVolumeTemplate {
	if x != nil {
		return x.RootVolume
	}
	return nil
}

func (x *AwsControlPlane) GetMainVolume() *AwsVolumeTemplate {
	if x != nil {
		return x.MainVolume
	}
	return nil
}

func (x *AwsControlPlane) GetDatabaseEncryption() *AwsDatabaseEncryption {
	if x != nil {
		return x.DatabaseEncryption
	}
	return nil
}

func (x *AwsControlPlane) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *AwsControlPlane) GetAwsServicesAuthentication() *AwsServicesAuthentication {
	if x != nil {
		return x.AwsServicesAuthentication
	}
	return nil
}

func (x *AwsControlPlane) GetProxyConfig() *AwsProxyConfig {
	if x != nil {
		return x.ProxyConfig
	}
	return nil
}

func (x *AwsControlPlane) GetConfigEncryption() *AwsConfigEncryption {
	if x != nil {
		return x.ConfigEncryption
	}
	return nil
}

func (x *AwsControlPlane) GetInstancePlacement() *AwsInstancePlacement {
	if x != nil {
		return x.InstancePlacement
	}
	return nil
}

// Authentication configuration for the management of AWS resources.
type AwsServicesAuthentication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Amazon Resource Name (ARN) of the role that the Anthos
	// Multi-Cloud API will assume when managing AWS resources on your account.
	RoleArn string `protobuf:"bytes,1,opt,name=role_arn,json=roleArn,proto3" json:"role_arn,omitempty"`
	// Optional. An identifier for the assumed role session.
	//
	// When unspecified, it defaults to `multicloud-service-agent`.
	RoleSessionName string `protobuf:"bytes,2,opt,name=role_session_name,json=roleSessionName,proto3" json:"role_session_name,omitempty"`
}

func (x *AwsServicesAuthentication) Reset() {
	*x = AwsServicesAuthentication{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsServicesAuthentication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsServicesAuthentication) ProtoMessage() {}

func (x *AwsServicesAuthentication) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsServicesAuthentication.ProtoReflect.Descriptor instead.
func (*AwsServicesAuthentication) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{2}
}

func (x *AwsServicesAuthentication) GetRoleArn() string {
	if x != nil {
		return x.RoleArn
	}
	return ""
}

func (x *AwsServicesAuthentication) GetRoleSessionName() string {
	if x != nil {
		return x.RoleSessionName
	}
	return ""
}

// Configuration related to the cluster RBAC settings.
type AwsAuthorization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Users that can perform operations as a cluster admin. A managed
	// ClusterRoleBinding will be created to grant the `cluster-admin` ClusterRole
	// to the users. Up to ten admin users can be provided.
	//
	// For more info on RBAC, see
	// https://kubernetes.io/docs/reference/access-authn-authz/rbac/#user-facing-roles
	AdminUsers []*AwsClusterUser `protobuf:"bytes,1,rep,name=admin_users,json=adminUsers,proto3" json:"admin_users,omitempty"`
	// Optional. Groups of users that can perform operations as a cluster admin. A
	// managed ClusterRoleBinding will be created to grant the `cluster-admin`
	// ClusterRole to the groups. Up to ten admin groups can be provided.
	//
	// For more info on RBAC, see
	// https://kubernetes.io/docs/reference/access-authn-authz/rbac/#user-facing-roles
	AdminGroups []*AwsClusterGroup `protobuf:"bytes,2,rep,name=admin_groups,json=adminGroups,proto3" json:"admin_groups,omitempty"`
}

func (x *AwsAuthorization) Reset() {
	*x = AwsAuthorization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsAuthorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsAuthorization) ProtoMessage() {}

func (x *AwsAuthorization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsAuthorization.ProtoReflect.Descriptor instead.
func (*AwsAuthorization) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{3}
}

func (x *AwsAuthorization) GetAdminUsers() []*AwsClusterUser {
	if x != nil {
		return x.AdminUsers
	}
	return nil
}

func (x *AwsAuthorization) GetAdminGroups() []*AwsClusterGroup {
	if x != nil {
		return x.AdminGroups
	}
	return nil
}

// Identities of a user-type subject for AWS clusters.
type AwsClusterUser struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the user, e.g. `my-gcp-id@gmail.com`.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
}

func (x *AwsClusterUser) Reset() {
	*x = AwsClusterUser{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsClusterUser) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsClusterUser) ProtoMessage() {}

func (x *AwsClusterUser) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsClusterUser.ProtoReflect.Descriptor instead.
func (*AwsClusterUser) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{4}
}

func (x *AwsClusterUser) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

// Identities of a group-type subject for AWS clusters.
type AwsClusterGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the group, e.g. `my-group@domain.com`.
	Group string `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
}

func (x *AwsClusterGroup) Reset() {
	*x = AwsClusterGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsClusterGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsClusterGroup) ProtoMessage() {}

func (x *AwsClusterGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsClusterGroup.ProtoReflect.Descriptor instead.
func (*AwsClusterGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{5}
}

func (x *AwsClusterGroup) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

// Configuration related to application-layer secrets encryption.
type AwsDatabaseEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ARN of the AWS KMS key used to encrypt cluster secrets.
	KmsKeyArn string `protobuf:"bytes,1,opt,name=kms_key_arn,json=kmsKeyArn,proto3" json:"kms_key_arn,omitempty"`
}

func (x *AwsDatabaseEncryption) Reset() {
	*x = AwsDatabaseEncryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsDatabaseEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsDatabaseEncryption) ProtoMessage() {}

func (x *AwsDatabaseEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsDatabaseEncryption.ProtoReflect.Descriptor instead.
func (*AwsDatabaseEncryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{6}
}

func (x *AwsDatabaseEncryption) GetKmsKeyArn() string {
	if x != nil {
		return x.KmsKeyArn
	}
	return ""
}

// Configuration template for AWS EBS volumes.
type AwsVolumeTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The size of the volume, in GiBs.
	//
	// When unspecified, a default value is provided. See the specific reference
	// in the parent resource.
	SizeGib int32 `protobuf:"varint,1,opt,name=size_gib,json=sizeGib,proto3" json:"size_gib,omitempty"`
	// Optional. Type of the EBS volume.
	//
	// When unspecified, it defaults to GP2 volume.
	VolumeType AwsVolumeTemplate_VolumeType `protobuf:"varint,2,opt,name=volume_type,json=volumeType,proto3,enum=google.cloud.gkemulticloud.v1.AwsVolumeTemplate_VolumeType" json:"volume_type,omitempty"`
	// Optional. The number of I/O operations per second (IOPS) to provision for
	// GP3 volume.
	Iops int32 `protobuf:"varint,3,opt,name=iops,proto3" json:"iops,omitempty"`
	// Optional. The throughput that the volume supports, in MiB/s. Only valid if
	// volume_type is GP3.
	//
	// If the volume_type is GP3 and this is not speficied, it defaults to 125.
	Throughput int32 `protobuf:"varint,5,opt,name=throughput,proto3" json:"throughput,omitempty"`
	// Optional. The Amazon Resource Name (ARN) of the Customer Managed Key (CMK)
	// used to encrypt AWS EBS volumes.
	//
	// If not specified, the default Amazon managed key associated to
	// the AWS region where this cluster runs will be used.
	KmsKeyArn string `protobuf:"bytes,4,opt,name=kms_key_arn,json=kmsKeyArn,proto3" json:"kms_key_arn,omitempty"`
}

func (x *AwsVolumeTemplate) Reset() {
	*x = AwsVolumeTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsVolumeTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsVolumeTemplate) ProtoMessage() {}

func (x *AwsVolumeTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsVolumeTemplate.ProtoReflect.Descriptor instead.
func (*AwsVolumeTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{7}
}

func (x *AwsVolumeTemplate) GetSizeGib() int32 {
	if x != nil {
		return x.SizeGib
	}
	return 0
}

func (x *AwsVolumeTemplate) GetVolumeType() AwsVolumeTemplate_VolumeType {
	if x != nil {
		return x.VolumeType
	}
	return AwsVolumeTemplate_VOLUME_TYPE_UNSPECIFIED
}

func (x *AwsVolumeTemplate) GetIops() int32 {
	if x != nil {
		return x.Iops
	}
	return 0
}

func (x *AwsVolumeTemplate) GetThroughput() int32 {
	if x != nil {
		return x.Throughput
	}
	return 0
}

func (x *AwsVolumeTemplate) GetKmsKeyArn() string {
	if x != nil {
		return x.KmsKeyArn
	}
	return ""
}

// ClusterNetworking defines cluster-wide networking configuration.
//
// Anthos clusters on AWS run on a single VPC. This includes control
// plane replicas and node pool nodes.
type AwsClusterNetworking struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The VPC associated with the cluster. All component clusters
	// (i.e. control plane and node pools) run on a single VPC.
	//
	// This field cannot be changed after creation.
	VpcId string `protobuf:"bytes,1,opt,name=vpc_id,json=vpcId,proto3" json:"vpc_id,omitempty"`
	// Required. All pods in the cluster are assigned an IPv4 address from these
	// ranges. Only a single range is supported. This field cannot be changed
	// after creation.
	PodAddressCidrBlocks []string `protobuf:"bytes,2,rep,name=pod_address_cidr_blocks,json=podAddressCidrBlocks,proto3" json:"pod_address_cidr_blocks,omitempty"`
	// Required. All services in the cluster are assigned an IPv4 address from
	// these ranges. Only a single range is supported. This field cannot be
	// changed after creation.
	ServiceAddressCidrBlocks []string `protobuf:"bytes,3,rep,name=service_address_cidr_blocks,json=serviceAddressCidrBlocks,proto3" json:"service_address_cidr_blocks,omitempty"`
	// Optional. Disable the per node pool subnet security group rules on the
	// control plane security group. When set to true, you must also provide one
	// or more security groups that ensure node pools are able to send requests to
	// the control plane on TCP/443 and TCP/8132. Failure to do so may result in
	// unavailable node pools.
	PerNodePoolSgRulesDisabled bool `protobuf:"varint,5,opt,name=per_node_pool_sg_rules_disabled,json=perNodePoolSgRulesDisabled,proto3" json:"per_node_pool_sg_rules_disabled,omitempty"`
}

func (x *AwsClusterNetworking) Reset() {
	*x = AwsClusterNetworking{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsClusterNetworking) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsClusterNetworking) ProtoMessage() {}

func (x *AwsClusterNetworking) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsClusterNetworking.ProtoReflect.Descriptor instead.
func (*AwsClusterNetworking) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{8}
}

func (x *AwsClusterNetworking) GetVpcId() string {
	if x != nil {
		return x.VpcId
	}
	return ""
}

func (x *AwsClusterNetworking) GetPodAddressCidrBlocks() []string {
	if x != nil {
		return x.PodAddressCidrBlocks
	}
	return nil
}

func (x *AwsClusterNetworking) GetServiceAddressCidrBlocks() []string {
	if x != nil {
		return x.ServiceAddressCidrBlocks
	}
	return nil
}

func (x *AwsClusterNetworking) GetPerNodePoolSgRulesDisabled() bool {
	if x != nil {
		return x.PerNodePoolSgRulesDisabled
	}
	return false
}

// An Anthos node pool running on AWS.
type AwsNodePool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of this resource.
	//
	// Node pool names are formatted as
	// `projects/<project-number>/locations/<region>/awsClusters/<cluster-id>/awsNodePools/<node-pool-id>`.
	//
	// For more details on Google Cloud resource names,
	// see [Resource Names](https://cloud.google.com/apis/design/resource_names)
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The Kubernetes version to run on this node pool (e.g.
	// `1.19.10-gke.1000`).
	//
	// You can list all supported versions on a given Google Cloud region by
	// calling
	// [GetAwsServerConfig][google.cloud.gkemulticloud.v1.AwsClusters.GetAwsServerConfig].
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// Required. The configuration of the node pool.
	Config *AwsNodeConfig `protobuf:"bytes,28,opt,name=config,proto3" json:"config,omitempty"`
	// Required. Autoscaler configuration for this node pool.
	Autoscaling *AwsNodePoolAutoscaling `protobuf:"bytes,25,opt,name=autoscaling,proto3" json:"autoscaling,omitempty"`
	// Required. The subnet where the node pool node run.
	SubnetId string `protobuf:"bytes,6,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Output only. The lifecycle state of the node pool.
	State AwsNodePool_State `protobuf:"varint,16,opt,name=state,proto3,enum=google.cloud.gkemulticloud.v1.AwsNodePool_State" json:"state,omitempty"`
	// Output only. A globally unique identifier for the node pool.
	Uid string `protobuf:"bytes,17,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. If set, there are currently changes in flight to the node
	// pool.
	Reconciling bool `protobuf:"varint,18,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Output only. The time at which this node pool was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,19,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this node pool was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,20,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Allows clients to perform consistent read-modify-writes
	// through optimistic concurrency control.
	//
	// Can be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,21,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. Annotations on the node pool.
	//
	// This field has the same restrictions as Kubernetes annotations.
	// The total size of all keys and values combined is limited to 256k.
	// Key can have 2 segments: prefix (optional) and name (required),
	// separated by a slash (/).
	// Prefix must be a DNS subdomain.
	// Name must be 63 characters or less, begin and end with alphanumerics,
	// with dashes (-), underscores (_), dots (.), and alphanumerics between.
	Annotations map[string]string `protobuf:"bytes,22,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The constraint on the maximum number of pods that can be run
	// simultaneously on a node in the node pool.
	MaxPodsConstraint *MaxPodsConstraint `protobuf:"bytes,27,opt,name=max_pods_constraint,json=maxPodsConstraint,proto3" json:"max_pods_constraint,omitempty"`
	// Output only. A set of errors found in the node pool.
	Errors []*AwsNodePoolError `protobuf:"bytes,29,rep,name=errors,proto3" json:"errors,omitempty"`
	// Optional. The Management configuration for this node pool.
	Management *AwsNodeManagement `protobuf:"bytes,30,opt,name=management,proto3" json:"management,omitempty"`
	// Optional. Update settings control the speed and disruption of the update.
	UpdateSettings *UpdateSettings `protobuf:"bytes,32,opt,name=update_settings,json=updateSettings,proto3" json:"update_settings,omitempty"`
}

func (x *AwsNodePool) Reset() {
	*x = AwsNodePool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsNodePool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsNodePool) ProtoMessage() {}

func (x *AwsNodePool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsNodePool.ProtoReflect.Descriptor instead.
func (*AwsNodePool) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{9}
}

func (x *AwsNodePool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AwsNodePool) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AwsNodePool) GetConfig() *AwsNodeConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *AwsNodePool) GetAutoscaling() *AwsNodePoolAutoscaling {
	if x != nil {
		return x.Autoscaling
	}
	return nil
}

func (x *AwsNodePool) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *AwsNodePool) GetState() AwsNodePool_State {
	if x != nil {
		return x.State
	}
	return AwsNodePool_STATE_UNSPECIFIED
}

func (x *AwsNodePool) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *AwsNodePool) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *AwsNodePool) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AwsNodePool) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AwsNodePool) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *AwsNodePool) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *AwsNodePool) GetMaxPodsConstraint() *MaxPodsConstraint {
	if x != nil {
		return x.MaxPodsConstraint
	}
	return nil
}

func (x *AwsNodePool) GetErrors() []*AwsNodePoolError {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *AwsNodePool) GetManagement() *AwsNodeManagement {
	if x != nil {
		return x.Management
	}
	return nil
}

func (x *AwsNodePool) GetUpdateSettings() *UpdateSettings {
	if x != nil {
		return x.UpdateSettings
	}
	return nil
}

// UpdateSettings control the level of parallelism and the level of
// disruption caused during the update of a node pool.
//
// These settings are applicable when the node pool update requires replacing
// the existing node pool nodes with the updated ones.
//
// UpdateSettings are optional. When UpdateSettings are not specified during the
// node pool creation, a default is chosen based on the parent cluster's
// version. For clusters with minor version 1.27 and later, a default
// surge_settings configuration with max_surge = 1 and max_unavailable = 0 is
// used. For clusters with older versions, node pool updates use the traditional
// rolling update mechanism of updating one node at a time in a
// "terminate before create" fashion and update_settings is not applicable.
//
// Set the surge_settings parameter to use the Surge Update mechanism for
// the rolling update of node pool nodes.
// 1. max_surge controls the number of additional nodes that can be created
// beyond the current size of the node pool temporarily for the time of the
// update to increase the number of available nodes.
// 2. max_unavailable controls the number of nodes that can be simultaneously
// unavailable during the update.
// 3. (max_surge + max_unavailable) determines the level of parallelism (i.e.,
// the number of nodes being updated at the same time).
type UpdateSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Settings for surge update.
	SurgeSettings *SurgeSettings `protobuf:"bytes,1,opt,name=surge_settings,json=surgeSettings,proto3" json:"surge_settings,omitempty"`
}

func (x *UpdateSettings) Reset() {
	*x = UpdateSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSettings) ProtoMessage() {}

func (x *UpdateSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSettings.ProtoReflect.Descriptor instead.
func (*UpdateSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateSettings) GetSurgeSettings() *SurgeSettings {
	if x != nil {
		return x.SurgeSettings
	}
	return nil
}

// SurgeSettings contains the parameters for Surge update.
type SurgeSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The maximum number of nodes that can be created beyond the
	// current size of the node pool during the update process.
	MaxSurge int32 `protobuf:"varint,1,opt,name=max_surge,json=maxSurge,proto3" json:"max_surge,omitempty"`
	// Optional. The maximum number of nodes that can be simultaneously
	// unavailable during the update process. A node is considered unavailable if
	// its status is not Ready.
	MaxUnavailable int32 `protobuf:"varint,2,opt,name=max_unavailable,json=maxUnavailable,proto3" json:"max_unavailable,omitempty"`
}

func (x *SurgeSettings) Reset() {
	*x = SurgeSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SurgeSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SurgeSettings) ProtoMessage() {}

func (x *SurgeSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SurgeSettings.ProtoReflect.Descriptor instead.
func (*SurgeSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{11}
}

func (x *SurgeSettings) GetMaxSurge() int32 {
	if x != nil {
		return x.MaxSurge
	}
	return 0
}

func (x *SurgeSettings) GetMaxUnavailable() int32 {
	if x != nil {
		return x.MaxUnavailable
	}
	return 0
}

// AwsNodeManagement defines the set of node management features turned on for
// an AWS node pool.
type AwsNodeManagement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether or not the nodes will be automatically repaired. When set
	// to true, the nodes in this node pool will be monitored and if they fail
	// health checks consistently over a period of time, an automatic repair
	// action will be triggered to replace them with new nodes.
	AutoRepair bool `protobuf:"varint,1,opt,name=auto_repair,json=autoRepair,proto3" json:"auto_repair,omitempty"`
}

func (x *AwsNodeManagement) Reset() {
	*x = AwsNodeManagement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsNodeManagement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsNodeManagement) ProtoMessage() {}

func (x *AwsNodeManagement) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsNodeManagement.ProtoReflect.Descriptor instead.
func (*AwsNodeManagement) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{12}
}

func (x *AwsNodeManagement) GetAutoRepair() bool {
	if x != nil {
		return x.AutoRepair
	}
	return false
}

// Parameters that describe the nodes in a cluster.
type AwsNodeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The EC2 instance type when creating on-Demand instances.
	//
	// If unspecified during node pool creation, a default will be chosen based on
	// the node pool version, and assigned to this field.
	InstanceType string `protobuf:"bytes,1,opt,name=instance_type,json=instanceType,proto3" json:"instance_type,omitempty"`
	// Optional. Template for the root volume provisioned for node pool nodes.
	// Volumes will be provisioned in the availability zone assigned
	// to the node pool subnet.
	//
	// When unspecified, it defaults to 32 GiB with the GP2 volume type.
	RootVolume *AwsVolumeTemplate `protobuf:"bytes,2,opt,name=root_volume,json=rootVolume,proto3" json:"root_volume,omitempty"`
	// Optional. The initial taints assigned to nodes of this node pool.
	Taints []*NodeTaint `protobuf:"bytes,3,rep,name=taints,proto3" json:"taints,omitempty"`
	// Optional. The initial labels assigned to nodes of this node pool. An object
	// containing a list of "key": value pairs. Example: { "name": "wrench",
	// "mass": "1.3kg", "count": "3" }.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Key/value metadata to assign to each underlying AWS resource.
	// Specify at most 50 pairs containing alphanumerics, spaces, and symbols
	// (.+-=_:@/). Keys can be up to 127 Unicode characters. Values can be up to
	// 255 Unicode characters.
	Tags map[string]string `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The name or ARN of the AWS IAM role assigned to nodes in the
	// pool.
	IamInstanceProfile string `protobuf:"bytes,6,opt,name=iam_instance_profile,json=iamInstanceProfile,proto3" json:"iam_instance_profile,omitempty"`
	// Optional. The OS image type to use on node pool instances.
	// Can be unspecified, or have a value of `ubuntu`.
	//
	// When unspecified, it defaults to `ubuntu`.
	ImageType string `protobuf:"bytes,11,opt,name=image_type,json=imageType,proto3" json:"image_type,omitempty"`
	// Optional. The SSH configuration.
	SshConfig *AwsSshConfig `protobuf:"bytes,9,opt,name=ssh_config,json=sshConfig,proto3" json:"ssh_config,omitempty"`
	// Optional. The IDs of additional security groups to add to nodes in this
	// pool. The manager will automatically create security groups with minimum
	// rules needed for a functioning cluster.
	SecurityGroupIds []string `protobuf:"bytes,10,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	// Optional. Proxy configuration for outbound HTTP(S) traffic.
	ProxyConfig *AwsProxyConfig `protobuf:"bytes,12,opt,name=proxy_config,json=proxyConfig,proto3" json:"proxy_config,omitempty"`
	// Required. Config encryption for user data.
	ConfigEncryption *AwsConfigEncryption `protobuf:"bytes,13,opt,name=config_encryption,json=configEncryption,proto3" json:"config_encryption,omitempty"`
	// Optional. Placement related info for this node.
	// When unspecified, the VPC's default tenancy will be used.
	InstancePlacement *AwsInstancePlacement `protobuf:"bytes,14,opt,name=instance_placement,json=instancePlacement,proto3" json:"instance_placement,omitempty"`
	// Optional. Configuration related to CloudWatch metrics collection on the
	// Auto Scaling group of the node pool.
	//
	// When unspecified, metrics collection is disabled.
	AutoscalingMetricsCollection *AwsAutoscalingGroupMetricsCollection `protobuf:"bytes,15,opt,name=autoscaling_metrics_collection,json=autoscalingMetricsCollection,proto3" json:"autoscaling_metrics_collection,omitempty"`
	// Optional. Configuration for provisioning EC2 Spot instances
	//
	// When specified, the node pool will provision Spot instances from the set
	// of spot_config.instance_types.
	// This field is mutually exclusive with `instance_type`.
	SpotConfig *SpotConfig `protobuf:"bytes,16,opt,name=spot_config,json=spotConfig,proto3" json:"spot_config,omitempty"`
}

func (x *AwsNodeConfig) Reset() {
	*x = AwsNodeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsNodeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsNodeConfig) ProtoMessage() {}

func (x *AwsNodeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsNodeConfig.ProtoReflect.Descriptor instead.
func (*AwsNodeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{13}
}

func (x *AwsNodeConfig) GetInstanceType() string {
	if x != nil {
		return x.InstanceType
	}
	return ""
}

func (x *AwsNodeConfig) GetRootVolume() *AwsVolumeTemplate {
	if x != nil {
		return x.RootVolume
	}
	return nil
}

func (x *AwsNodeConfig) GetTaints() []*NodeTaint {
	if x != nil {
		return x.Taints
	}
	return nil
}

func (x *AwsNodeConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *AwsNodeConfig) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *AwsNodeConfig) GetIamInstanceProfile() string {
	if x != nil {
		return x.IamInstanceProfile
	}
	return ""
}

func (x *AwsNodeConfig) GetImageType() string {
	if x != nil {
		return x.ImageType
	}
	return ""
}

func (x *AwsNodeConfig) GetSshConfig() *AwsSshConfig {
	if x != nil {
		return x.SshConfig
	}
	return nil
}

func (x *AwsNodeConfig) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

func (x *AwsNodeConfig) GetProxyConfig() *AwsProxyConfig {
	if x != nil {
		return x.ProxyConfig
	}
	return nil
}

func (x *AwsNodeConfig) GetConfigEncryption() *AwsConfigEncryption {
	if x != nil {
		return x.ConfigEncryption
	}
	return nil
}

func (x *AwsNodeConfig) GetInstancePlacement() *AwsInstancePlacement {
	if x != nil {
		return x.InstancePlacement
	}
	return nil
}

func (x *AwsNodeConfig) GetAutoscalingMetricsCollection() *AwsAutoscalingGroupMetricsCollection {
	if x != nil {
		return x.AutoscalingMetricsCollection
	}
	return nil
}

func (x *AwsNodeConfig) GetSpotConfig() *SpotConfig {
	if x != nil {
		return x.SpotConfig
	}
	return nil
}

// AwsNodePoolAutoscaling contains information required by cluster autoscaler
// to adjust the size of the node pool to the current cluster usage.
type AwsNodePoolAutoscaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Minimum number of nodes in the node pool. Must be greater than or
	// equal to 1 and less than or equal to max_node_count.
	MinNodeCount int32 `protobuf:"varint,1,opt,name=min_node_count,json=minNodeCount,proto3" json:"min_node_count,omitempty"`
	// Required. Maximum number of nodes in the node pool. Must be greater than or
	// equal to min_node_count and less than or equal to 50.
	MaxNodeCount int32 `protobuf:"varint,2,opt,name=max_node_count,json=maxNodeCount,proto3" json:"max_node_count,omitempty"`
}

func (x *AwsNodePoolAutoscaling) Reset() {
	*x = AwsNodePoolAutoscaling{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsNodePoolAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsNodePoolAutoscaling) ProtoMessage() {}

func (x *AwsNodePoolAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsNodePoolAutoscaling.ProtoReflect.Descriptor instead.
func (*AwsNodePoolAutoscaling) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{14}
}

func (x *AwsNodePoolAutoscaling) GetMinNodeCount() int32 {
	if x != nil {
		return x.MinNodeCount
	}
	return 0
}

func (x *AwsNodePoolAutoscaling) GetMaxNodeCount() int32 {
	if x != nil {
		return x.MaxNodeCount
	}
	return 0
}

// AwsOpenIdConfig is an OIDC discovery document for the cluster.
// See the OpenID Connect Discovery 1.0 specification for details.
type AwsOpenIdConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// OIDC Issuer.
	Issuer string `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// JSON Web Key uri.
	JwksUri string `protobuf:"bytes,2,opt,name=jwks_uri,json=jwksUri,proto3" json:"jwks_uri,omitempty"`
	// Supported response types.
	ResponseTypesSupported []string `protobuf:"bytes,3,rep,name=response_types_supported,json=responseTypesSupported,proto3" json:"response_types_supported,omitempty"`
	// Supported subject types.
	SubjectTypesSupported []string `protobuf:"bytes,4,rep,name=subject_types_supported,json=subjectTypesSupported,proto3" json:"subject_types_supported,omitempty"`
	// supported ID Token signing Algorithms.
	IdTokenSigningAlgValuesSupported []string `protobuf:"bytes,5,rep,name=id_token_signing_alg_values_supported,json=idTokenSigningAlgValuesSupported,proto3" json:"id_token_signing_alg_values_supported,omitempty"`
	// Supported claims.
	ClaimsSupported []string `protobuf:"bytes,6,rep,name=claims_supported,json=claimsSupported,proto3" json:"claims_supported,omitempty"`
	// Supported grant types.
	GrantTypes []string `protobuf:"bytes,7,rep,name=grant_types,json=grantTypes,proto3" json:"grant_types,omitempty"`
}

func (x *AwsOpenIdConfig) Reset() {
	*x = AwsOpenIdConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsOpenIdConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsOpenIdConfig) ProtoMessage() {}

func (x *AwsOpenIdConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsOpenIdConfig.ProtoReflect.Descriptor instead.
func (*AwsOpenIdConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{15}
}

func (x *AwsOpenIdConfig) GetIssuer() string {
	if x != nil {
		return x.Issuer
	}
	return ""
}

func (x *AwsOpenIdConfig) GetJwksUri() string {
	if x != nil {
		return x.JwksUri
	}
	return ""
}

func (x *AwsOpenIdConfig) GetResponseTypesSupported() []string {
	if x != nil {
		return x.ResponseTypesSupported
	}
	return nil
}

func (x *AwsOpenIdConfig) GetSubjectTypesSupported() []string {
	if x != nil {
		return x.SubjectTypesSupported
	}
	return nil
}

func (x *AwsOpenIdConfig) GetIdTokenSigningAlgValuesSupported() []string {
	if x != nil {
		return x.IdTokenSigningAlgValuesSupported
	}
	return nil
}

func (x *AwsOpenIdConfig) GetClaimsSupported() []string {
	if x != nil {
		return x.ClaimsSupported
	}
	return nil
}

func (x *AwsOpenIdConfig) GetGrantTypes() []string {
	if x != nil {
		return x.GrantTypes
	}
	return nil
}

// AwsJsonWebKeys is a valid JSON Web Key Set as specififed in RFC 7517.
type AwsJsonWebKeys struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The public component of the keys used by the cluster to sign token
	// requests.
	Keys []*Jwk `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
}

func (x *AwsJsonWebKeys) Reset() {
	*x = AwsJsonWebKeys{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsJsonWebKeys) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsJsonWebKeys) ProtoMessage() {}

func (x *AwsJsonWebKeys) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsJsonWebKeys.ProtoReflect.Descriptor instead.
func (*AwsJsonWebKeys) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{16}
}

func (x *AwsJsonWebKeys) GetKeys() []*Jwk {
	if x != nil {
		return x.Keys
	}
	return nil
}

// AwsServerConfig is the configuration of GKE cluster on AWS.
type AwsServerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the config.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// List of all released Kubernetes versions, including ones which are end of
	// life and can no longer be used.  Filter by the `enabled`
	// property to limit to currently available versions.
	// Valid versions supported for both create and update operations
	ValidVersions []*AwsK8SVersionInfo `protobuf:"bytes,2,rep,name=valid_versions,json=validVersions,proto3" json:"valid_versions,omitempty"`
	// The list of supported AWS regions.
	SupportedAwsRegions []string `protobuf:"bytes,3,rep,name=supported_aws_regions,json=supportedAwsRegions,proto3" json:"supported_aws_regions,omitempty"`
}

func (x *AwsServerConfig) Reset() {
	*x = AwsServerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsServerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsServerConfig) ProtoMessage() {}

func (x *AwsServerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsServerConfig.ProtoReflect.Descriptor instead.
func (*AwsServerConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{17}
}

func (x *AwsServerConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AwsServerConfig) GetValidVersions() []*AwsK8SVersionInfo {
	if x != nil {
		return x.ValidVersions
	}
	return nil
}

func (x *AwsServerConfig) GetSupportedAwsRegions() []string {
	if x != nil {
		return x.SupportedAwsRegions
	}
	return nil
}

// Kubernetes version information of GKE cluster on AWS.
type AwsK8SVersionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Kubernetes version name.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Optional. True if the version is available for cluster creation. If a
	// version is enabled for creation, it can be used to create new clusters.
	// Otherwise, cluster creation will fail. However, cluster upgrade operations
	// may succeed, even if the version is not enabled.
	Enabled bool `protobuf:"varint,3,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Optional. True if this cluster version belongs to a minor version that has
	// reached its end of life and is no longer in scope to receive security and
	// bug fixes.
	EndOfLife bool `protobuf:"varint,4,opt,name=end_of_life,json=endOfLife,proto3" json:"end_of_life,omitempty"`
	// Optional. The estimated date (in Pacific Time) when this cluster version
	// will reach its end of life. Or if this version is no longer supported (the
	// `end_of_life` field is true), this is the actual date (in Pacific time)
	// when the version reached its end of life.
	EndOfLifeDate *date.Date `protobuf:"bytes,5,opt,name=end_of_life_date,json=endOfLifeDate,proto3" json:"end_of_life_date,omitempty"`
	// Optional. The date (in Pacific Time) when the cluster version was released.
	ReleaseDate *date.Date `protobuf:"bytes,6,opt,name=release_date,json=releaseDate,proto3" json:"release_date,omitempty"`
}

func (x *AwsK8SVersionInfo) Reset() {
	*x = AwsK8SVersionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsK8SVersionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsK8SVersionInfo) ProtoMessage() {}

func (x *AwsK8SVersionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsK8SVersionInfo.ProtoReflect.Descriptor instead.
func (*AwsK8SVersionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{18}
}

func (x *AwsK8SVersionInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AwsK8SVersionInfo) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *AwsK8SVersionInfo) GetEndOfLife() bool {
	if x != nil {
		return x.EndOfLife
	}
	return false
}

func (x *AwsK8SVersionInfo) GetEndOfLifeDate() *date.Date {
	if x != nil {
		return x.EndOfLifeDate
	}
	return nil
}

func (x *AwsK8SVersionInfo) GetReleaseDate() *date.Date {
	if x != nil {
		return x.ReleaseDate
	}
	return nil
}

// SSH configuration for AWS resources.
type AwsSshConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the EC2 key pair used to login into cluster machines.
	Ec2KeyPair string `protobuf:"bytes,1,opt,name=ec2_key_pair,json=ec2KeyPair,proto3" json:"ec2_key_pair,omitempty"`
}

func (x *AwsSshConfig) Reset() {
	*x = AwsSshConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsSshConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsSshConfig) ProtoMessage() {}

func (x *AwsSshConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsSshConfig.ProtoReflect.Descriptor instead.
func (*AwsSshConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{19}
}

func (x *AwsSshConfig) GetEc2KeyPair() string {
	if x != nil {
		return x.Ec2KeyPair
	}
	return ""
}

// Details of a proxy config stored in AWS Secret Manager.
type AwsProxyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ARN of the AWS Secret Manager secret that contains the HTTP(S) proxy
	// configuration.
	//
	// The secret must be a JSON encoded proxy configuration
	// as described in
	// https://cloud.google.com/anthos/clusters/docs/multi-cloud/aws/how-to/use-a-proxy#create_a_proxy_configuration_file
	SecretArn string `protobuf:"bytes,1,opt,name=secret_arn,json=secretArn,proto3" json:"secret_arn,omitempty"`
	// The version string of the AWS Secret Manager secret that contains the
	// HTTP(S) proxy configuration.
	SecretVersion string `protobuf:"bytes,2,opt,name=secret_version,json=secretVersion,proto3" json:"secret_version,omitempty"`
}

func (x *AwsProxyConfig) Reset() {
	*x = AwsProxyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsProxyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsProxyConfig) ProtoMessage() {}

func (x *AwsProxyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsProxyConfig.ProtoReflect.Descriptor instead.
func (*AwsProxyConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{20}
}

func (x *AwsProxyConfig) GetSecretArn() string {
	if x != nil {
		return x.SecretArn
	}
	return ""
}

func (x *AwsProxyConfig) GetSecretVersion() string {
	if x != nil {
		return x.SecretVersion
	}
	return ""
}

// Config encryption for user data.
type AwsConfigEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ARN of the AWS KMS key used to encrypt user data.
	KmsKeyArn string `protobuf:"bytes,1,opt,name=kms_key_arn,json=kmsKeyArn,proto3" json:"kms_key_arn,omitempty"`
}

func (x *AwsConfigEncryption) Reset() {
	*x = AwsConfigEncryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsConfigEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsConfigEncryption) ProtoMessage() {}

func (x *AwsConfigEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsConfigEncryption.ProtoReflect.Descriptor instead.
func (*AwsConfigEncryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{21}
}

func (x *AwsConfigEncryption) GetKmsKeyArn() string {
	if x != nil {
		return x.KmsKeyArn
	}
	return ""
}

// Details of placement information for an instance.
// Limitations for using the `host` tenancy:
//
//   - T3 instances that use the unlimited CPU credit option don't support host
//     tenancy.
type AwsInstancePlacement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The tenancy for instance.
	Tenancy AwsInstancePlacement_Tenancy `protobuf:"varint,1,opt,name=tenancy,proto3,enum=google.cloud.gkemulticloud.v1.AwsInstancePlacement_Tenancy" json:"tenancy,omitempty"`
}

func (x *AwsInstancePlacement) Reset() {
	*x = AwsInstancePlacement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsInstancePlacement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsInstancePlacement) ProtoMessage() {}

func (x *AwsInstancePlacement) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsInstancePlacement.ProtoReflect.Descriptor instead.
func (*AwsInstancePlacement) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{22}
}

func (x *AwsInstancePlacement) GetTenancy() AwsInstancePlacement_Tenancy {
	if x != nil {
		return x.Tenancy
	}
	return AwsInstancePlacement_TENANCY_UNSPECIFIED
}

// Configuration related to CloudWatch metrics collection in an AWS
// Auto Scaling group.
type AwsAutoscalingGroupMetricsCollection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The frequency at which EC2 Auto Scaling sends aggregated data to
	// AWS CloudWatch. The only valid value is "1Minute".
	Granularity string `protobuf:"bytes,1,opt,name=granularity,proto3" json:"granularity,omitempty"`
	// Optional. The metrics to enable. For a list of valid metrics, see
	// https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html.
	// If you specify Granularity and don't specify any metrics, all metrics are
	// enabled.
	Metrics []string `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *AwsAutoscalingGroupMetricsCollection) Reset() {
	*x = AwsAutoscalingGroupMetricsCollection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsAutoscalingGroupMetricsCollection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsAutoscalingGroupMetricsCollection) ProtoMessage() {}

func (x *AwsAutoscalingGroupMetricsCollection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsAutoscalingGroupMetricsCollection.ProtoReflect.Descriptor instead.
func (*AwsAutoscalingGroupMetricsCollection) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{23}
}

func (x *AwsAutoscalingGroupMetricsCollection) GetGranularity() string {
	if x != nil {
		return x.Granularity
	}
	return ""
}

func (x *AwsAutoscalingGroupMetricsCollection) GetMetrics() []string {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// SpotConfig has configuration info for Spot node.
type SpotConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of instance types for creating spot node pool.
	InstanceTypes []string `protobuf:"bytes,1,rep,name=instance_types,json=instanceTypes,proto3" json:"instance_types,omitempty"`
}

func (x *SpotConfig) Reset() {
	*x = SpotConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpotConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpotConfig) ProtoMessage() {}

func (x *SpotConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpotConfig.ProtoReflect.Descriptor instead.
func (*SpotConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{24}
}

func (x *SpotConfig) GetInstanceTypes() []string {
	if x != nil {
		return x.InstanceTypes
	}
	return nil
}

// AwsClusterError describes errors found on AWS clusters.
type AwsClusterError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Human-friendly description of the error.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *AwsClusterError) Reset() {
	*x = AwsClusterError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsClusterError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsClusterError) ProtoMessage() {}

func (x *AwsClusterError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsClusterError.ProtoReflect.Descriptor instead.
func (*AwsClusterError) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{25}
}

func (x *AwsClusterError) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// AwsNodePoolError describes errors found on AWS node pools.
type AwsNodePoolError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Human-friendly description of the error.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *AwsNodePoolError) Reset() {
	*x = AwsNodePoolError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsNodePoolError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsNodePoolError) ProtoMessage() {}

func (x *AwsNodePoolError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsNodePoolError.ProtoReflect.Descriptor instead.
func (*AwsNodePoolError) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP(), []int{26}
}

func (x *AwsNodePoolError) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

var File_google_cloud_gkemulticloud_v1_aws_resources_proto protoreflect.FileDescriptor

var file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x2f,
	0x61, 0x77, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb1, 0x0d,
	0x0a, 0x0a, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e,
	0x67, 0x12, 0x22, 0x0a, 0x0a, 0x61, 0x77, 0x73, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x61, 0x77, 0x73, 0x52,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65, 0x12,
	0x5a, 0x0a, 0x0d, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12,
	0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e,
	0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x61,
	0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x74, 0x0a, 0x18, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x16, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x39, 0x0a, 0x16, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x66, 0x6c,
	0x65, 0x65, 0x74, 0x12, 0x58, 0x0a, 0x0e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a,
	0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77,
	0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x61, 0x0a, 0x11, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6a, 0x0a,
	0x14, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x6e, 0x61,
	0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x75, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f,
	0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52,
	0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x43, 0x4f,
	0x4e, 0x43, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f,
	0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x47, 0x52, 0x41, 0x44, 0x45, 0x44, 0x10, 0x06,
	0x3a, 0x6f, 0xea, 0x41, 0x6c, 0x0a, 0x27, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x41,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x2f, 0x7b, 0x61, 0x77, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x7d, 0x22, 0x86, 0x09, 0x0a, 0x0f, 0x41, 0x77, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x50, 0x6c, 0x61, 0x6e, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4f,
	0x0a, 0x0a, 0x73, 0x73, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x22, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x49, 0x64, 0x73, 0x12, 0x31, 0x0a, 0x12, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x49, 0x64, 0x73, 0x12, 0x35, 0x0a, 0x14, 0x69, 0x61, 0x6d, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x69, 0x61, 0x6d, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x56, 0x0a,
	0x0b, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x72, 0x6f, 0x6f, 0x74, 0x56,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x56, 0x0a, 0x0b, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x76, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x6d, 0x61, 0x69, 0x6e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x6a, 0x0a,
	0x13, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x7d, 0x0a, 0x1b,
	0x61, 0x77, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x61, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x41, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x19, 0x61, 0x77, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x41, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x0c, 0x70,
	0x72, 0x6f, 0x78, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x77, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x64, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x1a, 0x37, 0x0a, 0x09, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x6c, 0x0a, 0x19, 0x41, 0x77,
	0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x08, 0x72, 0x6f, 0x6c, 0x65, 0x5f,
	0x61, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07,
	0x72, 0x6f, 0x6c, 0x65, 0x41, 0x72, 0x6e, 0x12, 0x2f, 0x0a, 0x11, 0x72, 0x6f, 0x6c, 0x65, 0x5f,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x72, 0x6f, 0x6c, 0x65, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xbf, 0x01, 0x0a, 0x10, 0x41, 0x77, 0x73,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a,
	0x0b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x55, 0x73, 0x65,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x55, 0x73, 0x65,
	0x72, 0x73, 0x12, 0x56, 0x0a, 0x0c, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x22, 0x31, 0x0a, 0x0e, 0x41, 0x77,
	0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x55, 0x73, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x08,
	0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x2c, 0x0a,
	0x0f, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x19, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x3c, 0x0a, 0x15, 0x41,
	0x77, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0b, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x61, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x41, 0x72, 0x6e, 0x22, 0xb6, 0x02, 0x0a, 0x11, 0x41, 0x77,
	0x73, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12,
	0x1e, 0x0a, 0x08, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x69, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x73, 0x69, 0x7a, 0x65, 0x47, 0x69, 0x62, 0x12,
	0x61, 0x0a, 0x0b, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x69, 0x6f, 0x70, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x69, 0x6f, 0x70, 0x73, 0x12, 0x23, 0x0a, 0x0a, 0x74,
	0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x70, 0x75, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x70, 0x75, 0x74,
	0x12, 0x23, 0x0a, 0x0b, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x61, 0x72, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6b, 0x6d, 0x73, 0x4b,
	0x65, 0x79, 0x41, 0x72, 0x6e, 0x22, 0x3b, 0x0a, 0x0a, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x07, 0x0a, 0x03, 0x47, 0x50, 0x32, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x47, 0x50, 0x33,
	0x10, 0x02, 0x22, 0xfc, 0x01, 0x0a, 0x14, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x12, 0x1a, 0x0a, 0x06, 0x76,
	0x70, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x76, 0x70, 0x63, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x17, 0x70, 0x6f, 0x64, 0x5f, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x70,
	0x6f, 0x64, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x73, 0x12, 0x42, 0x0a, 0x1b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x18, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x69, 0x64,
	0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x12, 0x48, 0x0a, 0x1f, 0x70, 0x65, 0x72, 0x5f, 0x6e,
	0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x73, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x70, 0x65, 0x72, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x53, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x22, 0xc3, 0x0a, 0x0a, 0x0b, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x5c, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x19,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x20, 0x0a,
	0x09, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x49, 0x64, 0x12,
	0x4b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x03,
	0x75, 0x69, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03,
	0x75, 0x69, 0x64, 0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69,
	0x6e, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72,
	0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x12, 0x62, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x65, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x6f,
	0x64, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x1b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x78, 0x50, 0x6f, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x50,
	0x6f, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x4c, 0x0a,
	0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x1d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77,
	0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x55, 0x0a, 0x0a, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x0f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0e, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x1a,
	0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x75, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0f,
	0x0a, 0x0b, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x43, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12,
	0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x09, 0x0a,
	0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x47, 0x52,
	0x41, 0x44, 0x45, 0x44, 0x10, 0x06, 0x3a, 0x8e, 0x01, 0xea, 0x41, 0x8a, 0x01, 0x0a, 0x28, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x77, 0x73, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x5e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x61, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x61, 0x77,
	0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x2f, 0x61, 0x77, 0x73, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x61, 0x77, 0x73, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x7d, 0x22, 0x6a, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x58, 0x0a, 0x0e, 0x73, 0x75, 0x72,
	0x67, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x75, 0x72, 0x67, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x75, 0x72, 0x67, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x22, 0x5f, 0x0a, 0x0d, 0x53, 0x75, 0x72, 0x67, 0x65, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x75, 0x72, 0x67,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x61,
	0x78, 0x53, 0x75, 0x72, 0x67, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x75, 0x6e,
	0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x55, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c,
	0x61, 0x62, 0x6c, 0x65, 0x22, 0x39, 0x0a, 0x11, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x75, 0x74,
	0x6f, 0x5f, 0x72, 0x65, 0x70, 0x61, 0x69, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x52, 0x65, 0x70, 0x61, 0x69, 0x72, 0x22,
	0xdb, 0x09, 0x0a, 0x0d, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x28, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x56, 0x0a, 0x0b, 0x72,
	0x6f, 0x6f, 0x74, 0x5f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x77, 0x73, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x72, 0x6f, 0x6f, 0x74, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x06, 0x74, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x61, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x74, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x55, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x4e, 0x6f,
	0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x4f, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x61,
	0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x61,
	0x67, 0x73, 0x12, 0x35, 0x0a, 0x14, 0x69, 0x61, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x69, 0x61, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4f, 0x0a,
	0x0a, 0x73, 0x73, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x31,
	0x0a, 0x12, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x69, 0x64, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64,
	0x73, 0x12, 0x55, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x64, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67,
	0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6c,
	0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x8e, 0x01, 0x0a, 0x1e, 0x61, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x5f,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x77, 0x73, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x43, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1c, 0x61, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x0b, 0x73, 0x70, 0x6f, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70,
	0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x73,
	0x70, 0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x37, 0x0a, 0x09, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x6e, 0x0a,
	0x16, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x29, 0x0a, 0x0e, 0x6d, 0x69, 0x6e, 0x5f, 0x6e,
	0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x29, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x6d, 0x61, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xd3, 0x02,
	0x0a, 0x0f, 0x41, 0x77, 0x73, 0x4f, 0x70, 0x65, 0x6e, 0x49, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x77, 0x6b,
	0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x77, 0x6b,
	0x73, 0x55, 0x72, 0x69, 0x12, 0x38, 0x0a, 0x18, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x16, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x12, 0x36,
	0x0a, 0x17, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x5f,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x15, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x12, 0x4f, 0x0a, 0x25, 0x69, 0x64, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x6c, 0x67, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x20, 0x69, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x69,
	0x67, 0x6e, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x53, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x6c, 0x61, 0x69, 0x6d,
	0x73, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x22, 0x48, 0x0a, 0x0e, 0x41, 0x77, 0x73, 0x4a, 0x73, 0x6f, 0x6e, 0x57, 0x65,
	0x62, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x36, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x77, 0x6b, 0x52, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x22, 0x9e, 0x02,
	0x0a, 0x0f, 0x41, 0x77, 0x73, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77,
	0x73, 0x4b, 0x38, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x32,
	0x0a, 0x15, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x77, 0x73, 0x5f,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x41, 0x77, 0x73, 0x52, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x6a, 0xea, 0x41, 0x67, 0x0a, 0x2c, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x77, 0x73, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61,
	0x77, 0x73, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xed,
	0x01, 0x0a, 0x11, 0x41, 0x77, 0x73, 0x4b, 0x38, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1d,
	0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x23, 0x0a,
	0x0b, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x66, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x4f, 0x66, 0x4c, 0x69,
	0x66, 0x65, 0x12, 0x3f, 0x0a, 0x10, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x66, 0x5f, 0x6c, 0x69, 0x66,
	0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x65, 0x6e, 0x64, 0x4f, 0x66, 0x4c, 0x69, 0x66, 0x65, 0x44,
	0x61, 0x74, 0x65, 0x12, 0x39, 0x0a, 0x0c, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x64,
	0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x44, 0x61, 0x74, 0x65, 0x22, 0x35,
	0x0a, 0x0c, 0x41, 0x77, 0x73, 0x53, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x25,
	0x0a, 0x0c, 0x65, 0x63, 0x32, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x65, 0x63, 0x32, 0x4b, 0x65,
	0x79, 0x50, 0x61, 0x69, 0x72, 0x22, 0x56, 0x0a, 0x0e, 0x41, 0x77, 0x73, 0x50, 0x72, 0x6f, 0x78,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x5f, 0x61, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x41, 0x72, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x3a, 0x0a,
	0x13, 0x41, 0x77, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0b, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x61, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x41, 0x72, 0x6e, 0x22, 0xbc, 0x01, 0x0a, 0x14, 0x41, 0x77,
	0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x07, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x79, 0x22, 0x48,
	0x0a, 0x07, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x79, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x45, 0x4e,
	0x41, 0x4e, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x01, 0x12,
	0x0d, 0x0a, 0x09, 0x44, 0x45, 0x44, 0x49, 0x43, 0x41, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x08,
	0x0a, 0x04, 0x48, 0x4f, 0x53, 0x54, 0x10, 0x03, 0x22, 0x6c, 0x0a, 0x24, 0x41, 0x77, 0x73, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x25, 0x0a, 0x0b, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x67, 0x72, 0x61, 0x6e,
	0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1d, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x38, 0x0a, 0x0a, 0x53, 0x70, 0x6f, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x22, 0x2b, 0x0a, 0x0f, 0x41, 0x77, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x2c, 0x0a,
	0x10, 0x41, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0xe4, 0x01, 0x0a, 0x21,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x31, 0x42, 0x11, 0x41, 0x77, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x70, 0x62, 0x3b,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x70, 0x62, 0xaa,
	0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47,
	0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47,
	0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x47, 0x6b, 0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescOnce sync.Once
	file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescData = file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDesc
)

func file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescData)
	})
	return file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDescData
}

var file_google_cloud_gkemulticloud_v1_aws_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 32)
var file_google_cloud_gkemulticloud_v1_aws_resources_proto_goTypes = []interface{}{
	(AwsCluster_State)(0),                        // 0: google.cloud.gkemulticloud.v1.AwsCluster.State
	(AwsVolumeTemplate_VolumeType)(0),            // 1: google.cloud.gkemulticloud.v1.AwsVolumeTemplate.VolumeType
	(AwsNodePool_State)(0),                       // 2: google.cloud.gkemulticloud.v1.AwsNodePool.State
	(AwsInstancePlacement_Tenancy)(0),            // 3: google.cloud.gkemulticloud.v1.AwsInstancePlacement.Tenancy
	(*AwsCluster)(nil),                           // 4: google.cloud.gkemulticloud.v1.AwsCluster
	(*AwsControlPlane)(nil),                      // 5: google.cloud.gkemulticloud.v1.AwsControlPlane
	(*AwsServicesAuthentication)(nil),            // 6: google.cloud.gkemulticloud.v1.AwsServicesAuthentication
	(*AwsAuthorization)(nil),                     // 7: google.cloud.gkemulticloud.v1.AwsAuthorization
	(*AwsClusterUser)(nil),                       // 8: google.cloud.gkemulticloud.v1.AwsClusterUser
	(*AwsClusterGroup)(nil),                      // 9: google.cloud.gkemulticloud.v1.AwsClusterGroup
	(*AwsDatabaseEncryption)(nil),                // 10: google.cloud.gkemulticloud.v1.AwsDatabaseEncryption
	(*AwsVolumeTemplate)(nil),                    // 11: google.cloud.gkemulticloud.v1.AwsVolumeTemplate
	(*AwsClusterNetworking)(nil),                 // 12: google.cloud.gkemulticloud.v1.AwsClusterNetworking
	(*AwsNodePool)(nil),                          // 13: google.cloud.gkemulticloud.v1.AwsNodePool
	(*UpdateSettings)(nil),                       // 14: google.cloud.gkemulticloud.v1.UpdateSettings
	(*SurgeSettings)(nil),                        // 15: google.cloud.gkemulticloud.v1.SurgeSettings
	(*AwsNodeManagement)(nil),                    // 16: google.cloud.gkemulticloud.v1.AwsNodeManagement
	(*AwsNodeConfig)(nil),                        // 17: google.cloud.gkemulticloud.v1.AwsNodeConfig
	(*AwsNodePoolAutoscaling)(nil),               // 18: google.cloud.gkemulticloud.v1.AwsNodePoolAutoscaling
	(*AwsOpenIdConfig)(nil),                      // 19: google.cloud.gkemulticloud.v1.AwsOpenIdConfig
	(*AwsJsonWebKeys)(nil),                       // 20: google.cloud.gkemulticloud.v1.AwsJsonWebKeys
	(*AwsServerConfig)(nil),                      // 21: google.cloud.gkemulticloud.v1.AwsServerConfig
	(*AwsK8SVersionInfo)(nil),                    // 22: google.cloud.gkemulticloud.v1.AwsK8sVersionInfo
	(*AwsSshConfig)(nil),                         // 23: google.cloud.gkemulticloud.v1.AwsSshConfig
	(*AwsProxyConfig)(nil),                       // 24: google.cloud.gkemulticloud.v1.AwsProxyConfig
	(*AwsConfigEncryption)(nil),                  // 25: google.cloud.gkemulticloud.v1.AwsConfigEncryption
	(*AwsInstancePlacement)(nil),                 // 26: google.cloud.gkemulticloud.v1.AwsInstancePlacement
	(*AwsAutoscalingGroupMetricsCollection)(nil), // 27: google.cloud.gkemulticloud.v1.AwsAutoscalingGroupMetricsCollection
	(*SpotConfig)(nil),                           // 28: google.cloud.gkemulticloud.v1.SpotConfig
	(*AwsClusterError)(nil),                      // 29: google.cloud.gkemulticloud.v1.AwsClusterError
	(*AwsNodePoolError)(nil),                     // 30: google.cloud.gkemulticloud.v1.AwsNodePoolError
	nil,                                          // 31: google.cloud.gkemulticloud.v1.AwsCluster.AnnotationsEntry
	nil,                                          // 32: google.cloud.gkemulticloud.v1.AwsControlPlane.TagsEntry
	nil,                                          // 33: google.cloud.gkemulticloud.v1.AwsNodePool.AnnotationsEntry
	nil,                                          // 34: google.cloud.gkemulticloud.v1.AwsNodeConfig.LabelsEntry
	nil,                                          // 35: google.cloud.gkemulticloud.v1.AwsNodeConfig.TagsEntry
	(*timestamppb.Timestamp)(nil),                // 36: google.protobuf.Timestamp
	(*WorkloadIdentityConfig)(nil),               // 37: google.cloud.gkemulticloud.v1.WorkloadIdentityConfig
	(*Fleet)(nil),                                // 38: google.cloud.gkemulticloud.v1.Fleet
	(*LoggingConfig)(nil),                        // 39: google.cloud.gkemulticloud.v1.LoggingConfig
	(*MonitoringConfig)(nil),                     // 40: google.cloud.gkemulticloud.v1.MonitoringConfig
	(*BinaryAuthorization)(nil),                  // 41: google.cloud.gkemulticloud.v1.BinaryAuthorization
	(*MaxPodsConstraint)(nil),                    // 42: google.cloud.gkemulticloud.v1.MaxPodsConstraint
	(*NodeTaint)(nil),                            // 43: google.cloud.gkemulticloud.v1.NodeTaint
	(*Jwk)(nil),                                  // 44: google.cloud.gkemulticloud.v1.Jwk
	(*date.Date)(nil),                            // 45: google.type.Date
}
var file_google_cloud_gkemulticloud_v1_aws_resources_proto_depIdxs = []int32{
	12, // 0: google.cloud.gkemulticloud.v1.AwsCluster.networking:type_name -> google.cloud.gkemulticloud.v1.AwsClusterNetworking
	5,  // 1: google.cloud.gkemulticloud.v1.AwsCluster.control_plane:type_name -> google.cloud.gkemulticloud.v1.AwsControlPlane
	7,  // 2: google.cloud.gkemulticloud.v1.AwsCluster.authorization:type_name -> google.cloud.gkemulticloud.v1.AwsAuthorization
	0,  // 3: google.cloud.gkemulticloud.v1.AwsCluster.state:type_name -> google.cloud.gkemulticloud.v1.AwsCluster.State
	36, // 4: google.cloud.gkemulticloud.v1.AwsCluster.create_time:type_name -> google.protobuf.Timestamp
	36, // 5: google.cloud.gkemulticloud.v1.AwsCluster.update_time:type_name -> google.protobuf.Timestamp
	31, // 6: google.cloud.gkemulticloud.v1.AwsCluster.annotations:type_name -> google.cloud.gkemulticloud.v1.AwsCluster.AnnotationsEntry
	37, // 7: google.cloud.gkemulticloud.v1.AwsCluster.workload_identity_config:type_name -> google.cloud.gkemulticloud.v1.WorkloadIdentityConfig
	38, // 8: google.cloud.gkemulticloud.v1.AwsCluster.fleet:type_name -> google.cloud.gkemulticloud.v1.Fleet
	39, // 9: google.cloud.gkemulticloud.v1.AwsCluster.logging_config:type_name -> google.cloud.gkemulticloud.v1.LoggingConfig
	29, // 10: google.cloud.gkemulticloud.v1.AwsCluster.errors:type_name -> google.cloud.gkemulticloud.v1.AwsClusterError
	40, // 11: google.cloud.gkemulticloud.v1.AwsCluster.monitoring_config:type_name -> google.cloud.gkemulticloud.v1.MonitoringConfig
	41, // 12: google.cloud.gkemulticloud.v1.AwsCluster.binary_authorization:type_name -> google.cloud.gkemulticloud.v1.BinaryAuthorization
	23, // 13: google.cloud.gkemulticloud.v1.AwsControlPlane.ssh_config:type_name -> google.cloud.gkemulticloud.v1.AwsSshConfig
	11, // 14: google.cloud.gkemulticloud.v1.AwsControlPlane.root_volume:type_name -> google.cloud.gkemulticloud.v1.AwsVolumeTemplate
	11, // 15: google.cloud.gkemulticloud.v1.AwsControlPlane.main_volume:type_name -> google.cloud.gkemulticloud.v1.AwsVolumeTemplate
	10, // 16: google.cloud.gkemulticloud.v1.AwsControlPlane.database_encryption:type_name -> google.cloud.gkemulticloud.v1.AwsDatabaseEncryption
	32, // 17: google.cloud.gkemulticloud.v1.AwsControlPlane.tags:type_name -> google.cloud.gkemulticloud.v1.AwsControlPlane.TagsEntry
	6,  // 18: google.cloud.gkemulticloud.v1.AwsControlPlane.aws_services_authentication:type_name -> google.cloud.gkemulticloud.v1.AwsServicesAuthentication
	24, // 19: google.cloud.gkemulticloud.v1.AwsControlPlane.proxy_config:type_name -> google.cloud.gkemulticloud.v1.AwsProxyConfig
	25, // 20: google.cloud.gkemulticloud.v1.AwsControlPlane.config_encryption:type_name -> google.cloud.gkemulticloud.v1.AwsConfigEncryption
	26, // 21: google.cloud.gkemulticloud.v1.AwsControlPlane.instance_placement:type_name -> google.cloud.gkemulticloud.v1.AwsInstancePlacement
	8,  // 22: google.cloud.gkemulticloud.v1.AwsAuthorization.admin_users:type_name -> google.cloud.gkemulticloud.v1.AwsClusterUser
	9,  // 23: google.cloud.gkemulticloud.v1.AwsAuthorization.admin_groups:type_name -> google.cloud.gkemulticloud.v1.AwsClusterGroup
	1,  // 24: google.cloud.gkemulticloud.v1.AwsVolumeTemplate.volume_type:type_name -> google.cloud.gkemulticloud.v1.AwsVolumeTemplate.VolumeType
	17, // 25: google.cloud.gkemulticloud.v1.AwsNodePool.config:type_name -> google.cloud.gkemulticloud.v1.AwsNodeConfig
	18, // 26: google.cloud.gkemulticloud.v1.AwsNodePool.autoscaling:type_name -> google.cloud.gkemulticloud.v1.AwsNodePoolAutoscaling
	2,  // 27: google.cloud.gkemulticloud.v1.AwsNodePool.state:type_name -> google.cloud.gkemulticloud.v1.AwsNodePool.State
	36, // 28: google.cloud.gkemulticloud.v1.AwsNodePool.create_time:type_name -> google.protobuf.Timestamp
	36, // 29: google.cloud.gkemulticloud.v1.AwsNodePool.update_time:type_name -> google.protobuf.Timestamp
	33, // 30: google.cloud.gkemulticloud.v1.AwsNodePool.annotations:type_name -> google.cloud.gkemulticloud.v1.AwsNodePool.AnnotationsEntry
	42, // 31: google.cloud.gkemulticloud.v1.AwsNodePool.max_pods_constraint:type_name -> google.cloud.gkemulticloud.v1.MaxPodsConstraint
	30, // 32: google.cloud.gkemulticloud.v1.AwsNodePool.errors:type_name -> google.cloud.gkemulticloud.v1.AwsNodePoolError
	16, // 33: google.cloud.gkemulticloud.v1.AwsNodePool.management:type_name -> google.cloud.gkemulticloud.v1.AwsNodeManagement
	14, // 34: google.cloud.gkemulticloud.v1.AwsNodePool.update_settings:type_name -> google.cloud.gkemulticloud.v1.UpdateSettings
	15, // 35: google.cloud.gkemulticloud.v1.UpdateSettings.surge_settings:type_name -> google.cloud.gkemulticloud.v1.SurgeSettings
	11, // 36: google.cloud.gkemulticloud.v1.AwsNodeConfig.root_volume:type_name -> google.cloud.gkemulticloud.v1.AwsVolumeTemplate
	43, // 37: google.cloud.gkemulticloud.v1.AwsNodeConfig.taints:type_name -> google.cloud.gkemulticloud.v1.NodeTaint
	34, // 38: google.cloud.gkemulticloud.v1.AwsNodeConfig.labels:type_name -> google.cloud.gkemulticloud.v1.AwsNodeConfig.LabelsEntry
	35, // 39: google.cloud.gkemulticloud.v1.AwsNodeConfig.tags:type_name -> google.cloud.gkemulticloud.v1.AwsNodeConfig.TagsEntry
	23, // 40: google.cloud.gkemulticloud.v1.AwsNodeConfig.ssh_config:type_name -> google.cloud.gkemulticloud.v1.AwsSshConfig
	24, // 41: google.cloud.gkemulticloud.v1.AwsNodeConfig.proxy_config:type_name -> google.cloud.gkemulticloud.v1.AwsProxyConfig
	25, // 42: google.cloud.gkemulticloud.v1.AwsNodeConfig.config_encryption:type_name -> google.cloud.gkemulticloud.v1.AwsConfigEncryption
	26, // 43: google.cloud.gkemulticloud.v1.AwsNodeConfig.instance_placement:type_name -> google.cloud.gkemulticloud.v1.AwsInstancePlacement
	27, // 44: google.cloud.gkemulticloud.v1.AwsNodeConfig.autoscaling_metrics_collection:type_name -> google.cloud.gkemulticloud.v1.AwsAutoscalingGroupMetricsCollection
	28, // 45: google.cloud.gkemulticloud.v1.AwsNodeConfig.spot_config:type_name -> google.cloud.gkemulticloud.v1.SpotConfig
	44, // 46: google.cloud.gkemulticloud.v1.AwsJsonWebKeys.keys:type_name -> google.cloud.gkemulticloud.v1.Jwk
	22, // 47: google.cloud.gkemulticloud.v1.AwsServerConfig.valid_versions:type_name -> google.cloud.gkemulticloud.v1.AwsK8sVersionInfo
	45, // 48: google.cloud.gkemulticloud.v1.AwsK8sVersionInfo.end_of_life_date:type_name -> google.type.Date
	45, // 49: google.cloud.gkemulticloud.v1.AwsK8sVersionInfo.release_date:type_name -> google.type.Date
	3,  // 50: google.cloud.gkemulticloud.v1.AwsInstancePlacement.tenancy:type_name -> google.cloud.gkemulticloud.v1.AwsInstancePlacement.Tenancy
	51, // [51:51] is the sub-list for method output_type
	51, // [51:51] is the sub-list for method input_type
	51, // [51:51] is the sub-list for extension type_name
	51, // [51:51] is the sub-list for extension extendee
	0,  // [0:51] is the sub-list for field type_name
}

func init() { file_google_cloud_gkemulticloud_v1_aws_resources_proto_init() }
func file_google_cloud_gkemulticloud_v1_aws_resources_proto_init() {
	if File_google_cloud_gkemulticloud_v1_aws_resources_proto != nil {
		return
	}
	file_google_cloud_gkemulticloud_v1_common_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsControlPlane); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsServicesAuthentication); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsAuthorization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsClusterUser); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsClusterGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsDatabaseEncryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsVolumeTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsClusterNetworking); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsNodePool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SurgeSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsNodeManagement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsNodeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsNodePoolAutoscaling); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsOpenIdConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsJsonWebKeys); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsServerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsK8SVersionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsSshConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsProxyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsConfigEncryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsInstancePlacement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsAutoscalingGroupMetricsCollection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpotConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsClusterError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsNodePoolError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   32,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkemulticloud_v1_aws_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkemulticloud_v1_aws_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkemulticloud_v1_aws_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkemulticloud_v1_aws_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_gkemulticloud_v1_aws_resources_proto = out.File
	file_google_cloud_gkemulticloud_v1_aws_resources_proto_rawDesc = nil
	file_google_cloud_gkemulticloud_v1_aws_resources_proto_goTypes = nil
	file_google_cloud_gkemulticloud_v1_aws_resources_proto_depIdxs = nil
}
