// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package talent aliases all exported identifiers in package
// "cloud.google.com/go/talent/apiv4/talentpb".
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package talent

import (
	src "cloud.google.com/go/talent/apiv4/talentpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/talent/apiv4/talentpb
const (
	BatchOperationMetadata_CANCELLED                                 = src.BatchOperationMetadata_CANCELLED
	BatchOperationMetadata_CANCELLING                                = src.BatchOperationMetadata_CANCELLING
	BatchOperationMetadata_FAILED                                    = src.BatchOperationMetadata_FAILED
	BatchOperationMetadata_INITIALIZING                              = src.BatchOperationMetadata_INITIALIZING
	BatchOperationMetadata_PROCESSING                                = src.BatchOperationMetadata_PROCESSING
	BatchOperationMetadata_STATE_UNSPECIFIED                         = src.BatchOperationMetadata_STATE_UNSPECIFIED
	BatchOperationMetadata_SUCCEEDED                                 = src.BatchOperationMetadata_SUCCEEDED
	CommuteFilter_BUSY_HOUR                                          = src.CommuteFilter_BUSY_HOUR
	CommuteFilter_ROAD_TRAFFIC_UNSPECIFIED                           = src.CommuteFilter_ROAD_TRAFFIC_UNSPECIFIED
	CommuteFilter_TRAFFIC_FREE                                       = src.CommuteFilter_TRAFFIC_FREE
	CommuteMethod_COMMUTE_METHOD_UNSPECIFIED                         = src.CommuteMethod_COMMUTE_METHOD_UNSPECIFIED
	CommuteMethod_CYCLING                                            = src.CommuteMethod_CYCLING
	CommuteMethod_DRIVING                                            = src.CommuteMethod_DRIVING
	CommuteMethod_TRANSIT                                            = src.CommuteMethod_TRANSIT
	CommuteMethod_TRANSIT_ACCESSIBLE                                 = src.CommuteMethod_TRANSIT_ACCESSIBLE
	CommuteMethod_WALKING                                            = src.CommuteMethod_WALKING
	CompanySize_BIG                                                  = src.CompanySize_BIG
	CompanySize_BIGGER                                               = src.CompanySize_BIGGER
	CompanySize_COMPANY_SIZE_UNSPECIFIED                             = src.CompanySize_COMPANY_SIZE_UNSPECIFIED
	CompanySize_GIANT                                                = src.CompanySize_GIANT
	CompanySize_MEDIUM                                               = src.CompanySize_MEDIUM
	CompanySize_MINI                                                 = src.CompanySize_MINI
	CompanySize_SMALL                                                = src.CompanySize_SMALL
	CompanySize_SMEDIUM                                              = src.CompanySize_SMEDIUM
	CompensationFilter_ANNUALIZED_BASE_AMOUNT                        = src.CompensationFilter_ANNUALIZED_BASE_AMOUNT
	CompensationFilter_ANNUALIZED_TOTAL_AMOUNT                       = src.CompensationFilter_ANNUALIZED_TOTAL_AMOUNT
	CompensationFilter_FILTER_TYPE_UNSPECIFIED                       = src.CompensationFilter_FILTER_TYPE_UNSPECIFIED
	CompensationFilter_UNIT_AND_AMOUNT                               = src.CompensationFilter_UNIT_AND_AMOUNT
	CompensationFilter_UNIT_ONLY                                     = src.CompensationFilter_UNIT_ONLY
	CompensationInfo_BASE                                            = src.CompensationInfo_BASE
	CompensationInfo_BONUS                                           = src.CompensationInfo_BONUS
	CompensationInfo_COMMISSIONS                                     = src.CompensationInfo_COMMISSIONS
	CompensationInfo_COMPENSATION_TYPE_UNSPECIFIED                   = src.CompensationInfo_COMPENSATION_TYPE_UNSPECIFIED
	CompensationInfo_COMPENSATION_UNIT_UNSPECIFIED                   = src.CompensationInfo_COMPENSATION_UNIT_UNSPECIFIED
	CompensationInfo_DAILY                                           = src.CompensationInfo_DAILY
	CompensationInfo_EQUITY                                          = src.CompensationInfo_EQUITY
	CompensationInfo_HOURLY                                          = src.CompensationInfo_HOURLY
	CompensationInfo_MONTHLY                                         = src.CompensationInfo_MONTHLY
	CompensationInfo_ONE_TIME                                        = src.CompensationInfo_ONE_TIME
	CompensationInfo_OTHER_COMPENSATION_TYPE                         = src.CompensationInfo_OTHER_COMPENSATION_TYPE
	CompensationInfo_OTHER_COMPENSATION_UNIT                         = src.CompensationInfo_OTHER_COMPENSATION_UNIT
	CompensationInfo_PROFIT_SHARING                                  = src.CompensationInfo_PROFIT_SHARING
	CompensationInfo_SIGNING_BONUS                                   = src.CompensationInfo_SIGNING_BONUS
	CompensationInfo_TIPS                                            = src.CompensationInfo_TIPS
	CompensationInfo_WEEKLY                                          = src.CompensationInfo_WEEKLY
	CompensationInfo_YEARLY                                          = src.CompensationInfo_YEARLY
	CompleteQueryRequest_COMBINED                                    = src.CompleteQueryRequest_COMBINED
	CompleteQueryRequest_COMPANY_NAME                                = src.CompleteQueryRequest_COMPANY_NAME
	CompleteQueryRequest_COMPLETION_SCOPE_UNSPECIFIED                = src.CompleteQueryRequest_COMPLETION_SCOPE_UNSPECIFIED
	CompleteQueryRequest_COMPLETION_TYPE_UNSPECIFIED                 = src.CompleteQueryRequest_COMPLETION_TYPE_UNSPECIFIED
	CompleteQueryRequest_JOB_TITLE                                   = src.CompleteQueryRequest_JOB_TITLE
	CompleteQueryRequest_PUBLIC                                      = src.CompleteQueryRequest_PUBLIC
	CompleteQueryRequest_TENANT                                      = src.CompleteQueryRequest_TENANT
	DegreeType_ADULT_REMEDIAL_EDUCATION                              = src.DegreeType_ADULT_REMEDIAL_EDUCATION
	DegreeType_ASSOCIATES_OR_EQUIVALENT                              = src.DegreeType_ASSOCIATES_OR_EQUIVALENT
	DegreeType_BACHELORS_OR_EQUIVALENT                               = src.DegreeType_BACHELORS_OR_EQUIVALENT
	DegreeType_DEGREE_TYPE_UNSPECIFIED                               = src.DegreeType_DEGREE_TYPE_UNSPECIFIED
	DegreeType_DOCTORAL_OR_EQUIVALENT                                = src.DegreeType_DOCTORAL_OR_EQUIVALENT
	DegreeType_LOWER_SECONDARY_EDUCATION                             = src.DegreeType_LOWER_SECONDARY_EDUCATION
	DegreeType_MASTERS_OR_EQUIVALENT                                 = src.DegreeType_MASTERS_OR_EQUIVALENT
	DegreeType_PRIMARY_EDUCATION                                     = src.DegreeType_PRIMARY_EDUCATION
	DegreeType_UPPER_SECONDARY_EDUCATION                             = src.DegreeType_UPPER_SECONDARY_EDUCATION
	DeviceInfo_ANDROID                                               = src.DeviceInfo_ANDROID
	DeviceInfo_BOT                                                   = src.DeviceInfo_BOT
	DeviceInfo_DEVICE_TYPE_UNSPECIFIED                               = src.DeviceInfo_DEVICE_TYPE_UNSPECIFIED
	DeviceInfo_IOS                                                   = src.DeviceInfo_IOS
	DeviceInfo_MOBILE_WEB                                            = src.DeviceInfo_MOBILE_WEB
	DeviceInfo_OTHER                                                 = src.DeviceInfo_OTHER
	DeviceInfo_WEB                                                   = src.DeviceInfo_WEB
	EmploymentType_CONTRACTOR                                        = src.EmploymentType_CONTRACTOR
	EmploymentType_CONTRACT_TO_HIRE                                  = src.EmploymentType_CONTRACT_TO_HIRE
	EmploymentType_EMPLOYMENT_TYPE_UNSPECIFIED                       = src.EmploymentType_EMPLOYMENT_TYPE_UNSPECIFIED
	EmploymentType_FLY_IN_FLY_OUT                                    = src.EmploymentType_FLY_IN_FLY_OUT
	EmploymentType_FULL_TIME                                         = src.EmploymentType_FULL_TIME
	EmploymentType_INTERN                                            = src.EmploymentType_INTERN
	EmploymentType_OTHER_EMPLOYMENT_TYPE                             = src.EmploymentType_OTHER_EMPLOYMENT_TYPE
	EmploymentType_PART_TIME                                         = src.EmploymentType_PART_TIME
	EmploymentType_PER_DIEM                                          = src.EmploymentType_PER_DIEM
	EmploymentType_TEMPORARY                                         = src.EmploymentType_TEMPORARY
	EmploymentType_VOLUNTEER                                         = src.EmploymentType_VOLUNTEER
	HtmlSanitization_HTML_SANITIZATION_DISABLED                      = src.HtmlSanitization_HTML_SANITIZATION_DISABLED
	HtmlSanitization_HTML_SANITIZATION_UNSPECIFIED                   = src.HtmlSanitization_HTML_SANITIZATION_UNSPECIFIED
	HtmlSanitization_SIMPLE_FORMATTING_ONLY                          = src.HtmlSanitization_SIMPLE_FORMATTING_ONLY
	JobBenefit_CHILD_CARE                                            = src.JobBenefit_CHILD_CARE
	JobBenefit_DENTAL                                                = src.JobBenefit_DENTAL
	JobBenefit_DOMESTIC_PARTNER                                      = src.JobBenefit_DOMESTIC_PARTNER
	JobBenefit_FLEXIBLE_HOURS                                        = src.JobBenefit_FLEXIBLE_HOURS
	JobBenefit_JOB_BENEFIT_UNSPECIFIED                               = src.JobBenefit_JOB_BENEFIT_UNSPECIFIED
	JobBenefit_LIFE_INSURANCE                                        = src.JobBenefit_LIFE_INSURANCE
	JobBenefit_MEDICAL                                               = src.JobBenefit_MEDICAL
	JobBenefit_PARENTAL_LEAVE                                        = src.JobBenefit_PARENTAL_LEAVE
	JobBenefit_RETIREMENT_PLAN                                       = src.JobBenefit_RETIREMENT_PLAN
	JobBenefit_SICK_DAYS                                             = src.JobBenefit_SICK_DAYS
	JobBenefit_VACATION                                              = src.JobBenefit_VACATION
	JobBenefit_VISION                                                = src.JobBenefit_VISION
	JobCategory_ACCOUNTING_AND_FINANCE                               = src.JobCategory_ACCOUNTING_AND_FINANCE
	JobCategory_ADMINISTRATIVE_AND_OFFICE                            = src.JobCategory_ADMINISTRATIVE_AND_OFFICE
	JobCategory_ADVERTISING_AND_MARKETING                            = src.JobCategory_ADVERTISING_AND_MARKETING
	JobCategory_ANIMAL_CARE                                          = src.JobCategory_ANIMAL_CARE
	JobCategory_ART_FASHION_AND_DESIGN                               = src.JobCategory_ART_FASHION_AND_DESIGN
	JobCategory_BUSINESS_OPERATIONS                                  = src.JobCategory_BUSINESS_OPERATIONS
	JobCategory_CLEANING_AND_FACILITIES                              = src.JobCategory_CLEANING_AND_FACILITIES
	JobCategory_COMPUTER_AND_IT                                      = src.JobCategory_COMPUTER_AND_IT
	JobCategory_CONSTRUCTION                                         = src.JobCategory_CONSTRUCTION
	JobCategory_CUSTOMER_SERVICE                                     = src.JobCategory_CUSTOMER_SERVICE
	JobCategory_EDUCATION                                            = src.JobCategory_EDUCATION
	JobCategory_ENTERTAINMENT_AND_TRAVEL                             = src.JobCategory_ENTERTAINMENT_AND_TRAVEL
	JobCategory_FARMING_AND_OUTDOORS                                 = src.JobCategory_FARMING_AND_OUTDOORS
	JobCategory_HEALTHCARE                                           = src.JobCategory_HEALTHCARE
	JobCategory_HUMAN_RESOURCES                                      = src.JobCategory_HUMAN_RESOURCES
	JobCategory_INSTALLATION_MAINTENANCE_AND_REPAIR                  = src.JobCategory_INSTALLATION_MAINTENANCE_AND_REPAIR
	JobCategory_JOB_CATEGORY_UNSPECIFIED                             = src.JobCategory_JOB_CATEGORY_UNSPECIFIED
	JobCategory_LEGAL                                                = src.JobCategory_LEGAL
	JobCategory_MANAGEMENT                                           = src.JobCategory_MANAGEMENT
	JobCategory_MANUFACTURING_AND_WAREHOUSE                          = src.JobCategory_MANUFACTURING_AND_WAREHOUSE
	JobCategory_MEDIA_COMMUNICATIONS_AND_WRITING                     = src.JobCategory_MEDIA_COMMUNICATIONS_AND_WRITING
	JobCategory_OIL_GAS_AND_MINING                                   = src.JobCategory_OIL_GAS_AND_MINING
	JobCategory_PERSONAL_CARE_AND_SERVICES                           = src.JobCategory_PERSONAL_CARE_AND_SERVICES
	JobCategory_PROTECTIVE_SERVICES                                  = src.JobCategory_PROTECTIVE_SERVICES
	JobCategory_REAL_ESTATE                                          = src.JobCategory_REAL_ESTATE
	JobCategory_RESTAURANT_AND_HOSPITALITY                           = src.JobCategory_RESTAURANT_AND_HOSPITALITY
	JobCategory_SALES_AND_RETAIL                                     = src.JobCategory_SALES_AND_RETAIL
	JobCategory_SCIENCE_AND_ENGINEERING                              = src.JobCategory_SCIENCE_AND_ENGINEERING
	JobCategory_SOCIAL_SERVICES_AND_NON_PROFIT                       = src.JobCategory_SOCIAL_SERVICES_AND_NON_PROFIT
	JobCategory_SPORTS_FITNESS_AND_RECREATION                        = src.JobCategory_SPORTS_FITNESS_AND_RECREATION
	JobCategory_TRANSPORTATION_AND_LOGISTICS                         = src.JobCategory_TRANSPORTATION_AND_LOGISTICS
	JobEvent_APPLICATION_COMPANY_SUBMIT                              = src.JobEvent_APPLICATION_COMPANY_SUBMIT
	JobEvent_APPLICATION_FINISH                                      = src.JobEvent_APPLICATION_FINISH
	JobEvent_APPLICATION_QUICK_SUBMISSION                            = src.JobEvent_APPLICATION_QUICK_SUBMISSION
	JobEvent_APPLICATION_REDIRECT                                    = src.JobEvent_APPLICATION_REDIRECT
	JobEvent_APPLICATION_REDIRECT_FROM_SEARCH                        = src.JobEvent_APPLICATION_REDIRECT_FROM_SEARCH
	JobEvent_APPLICATION_START                                       = src.JobEvent_APPLICATION_START
	JobEvent_APPLICATION_START_FROM_SEARCH                           = src.JobEvent_APPLICATION_START_FROM_SEARCH
	JobEvent_BOOKMARK                                                = src.JobEvent_BOOKMARK
	JobEvent_HIRED                                                   = src.JobEvent_HIRED
	JobEvent_IMPRESSION                                              = src.JobEvent_IMPRESSION
	JobEvent_INTERVIEW_GRANTED                                       = src.JobEvent_INTERVIEW_GRANTED
	JobEvent_JOB_EVENT_TYPE_UNSPECIFIED                              = src.JobEvent_JOB_EVENT_TYPE_UNSPECIFIED
	JobEvent_NOTIFICATION                                            = src.JobEvent_NOTIFICATION
	JobEvent_SENT_CV                                                 = src.JobEvent_SENT_CV
	JobEvent_VIEW                                                    = src.JobEvent_VIEW
	JobEvent_VIEW_REDIRECT                                           = src.JobEvent_VIEW_REDIRECT
	JobLevel_DIRECTOR                                                = src.JobLevel_DIRECTOR
	JobLevel_ENTRY_LEVEL                                             = src.JobLevel_ENTRY_LEVEL
	JobLevel_EXECUTIVE                                               = src.JobLevel_EXECUTIVE
	JobLevel_EXPERIENCED                                             = src.JobLevel_EXPERIENCED
	JobLevel_JOB_LEVEL_UNSPECIFIED                                   = src.JobLevel_JOB_LEVEL_UNSPECIFIED
	JobLevel_MANAGER                                                 = src.JobLevel_MANAGER
	JobView_JOB_VIEW_FULL                                            = src.JobView_JOB_VIEW_FULL
	JobView_JOB_VIEW_ID_ONLY                                         = src.JobView_JOB_VIEW_ID_ONLY
	JobView_JOB_VIEW_MINIMAL                                         = src.JobView_JOB_VIEW_MINIMAL
	JobView_JOB_VIEW_SMALL                                           = src.JobView_JOB_VIEW_SMALL
	JobView_JOB_VIEW_UNSPECIFIED                                     = src.JobView_JOB_VIEW_UNSPECIFIED
	LocationFilter_TELECOMMUTE_ALLOWED                               = src.LocationFilter_TELECOMMUTE_ALLOWED
	LocationFilter_TELECOMMUTE_EXCLUDED                              = src.LocationFilter_TELECOMMUTE_EXCLUDED
	LocationFilter_TELECOMMUTE_JOBS_EXCLUDED                         = src.LocationFilter_TELECOMMUTE_JOBS_EXCLUDED
	LocationFilter_TELECOMMUTE_PREFERENCE_UNSPECIFIED                = src.LocationFilter_TELECOMMUTE_PREFERENCE_UNSPECIFIED
	Location_ADMINISTRATIVE_AREA                                     = src.Location_ADMINISTRATIVE_AREA
	Location_COUNTRY                                                 = src.Location_COUNTRY
	Location_LOCALITY                                                = src.Location_LOCALITY
	Location_LOCATION_TYPE_UNSPECIFIED                               = src.Location_LOCATION_TYPE_UNSPECIFIED
	Location_NEIGHBORHOOD                                            = src.Location_NEIGHBORHOOD
	Location_POSTAL_CODE                                             = src.Location_POSTAL_CODE
	Location_STREET_ADDRESS                                          = src.Location_STREET_ADDRESS
	Location_SUB_ADMINISTRATIVE_AREA                                 = src.Location_SUB_ADMINISTRATIVE_AREA
	Location_SUB_LOCALITY                                            = src.Location_SUB_LOCALITY
	Location_SUB_LOCALITY_1                                          = src.Location_SUB_LOCALITY_1
	Location_SUB_LOCALITY_2                                          = src.Location_SUB_LOCALITY_2
	PostingRegion_ADMINISTRATIVE_AREA                                = src.PostingRegion_ADMINISTRATIVE_AREA
	PostingRegion_NATION                                             = src.PostingRegion_NATION
	PostingRegion_POSTING_REGION_UNSPECIFIED                         = src.PostingRegion_POSTING_REGION_UNSPECIFIED
	PostingRegion_TELECOMMUTE                                        = src.PostingRegion_TELECOMMUTE
	SearchJobsRequest_CustomRankingInfo_EXTREME                      = src.SearchJobsRequest_CustomRankingInfo_EXTREME
	SearchJobsRequest_CustomRankingInfo_HIGH                         = src.SearchJobsRequest_CustomRankingInfo_HIGH
	SearchJobsRequest_CustomRankingInfo_IMPORTANCE_LEVEL_UNSPECIFIED = src.SearchJobsRequest_CustomRankingInfo_IMPORTANCE_LEVEL_UNSPECIFIED
	SearchJobsRequest_CustomRankingInfo_LOW                          = src.SearchJobsRequest_CustomRankingInfo_LOW
	SearchJobsRequest_CustomRankingInfo_MEDIUM                       = src.SearchJobsRequest_CustomRankingInfo_MEDIUM
	SearchJobsRequest_CustomRankingInfo_MILD                         = src.SearchJobsRequest_CustomRankingInfo_MILD
	SearchJobsRequest_CustomRankingInfo_NONE                         = src.SearchJobsRequest_CustomRankingInfo_NONE
	SearchJobsRequest_DISABLED                                       = src.SearchJobsRequest_DISABLED
	SearchJobsRequest_DIVERSIFICATION_LEVEL_UNSPECIFIED              = src.SearchJobsRequest_DIVERSIFICATION_LEVEL_UNSPECIFIED
	SearchJobsRequest_DIVERSIFY_BY_LOOSER_SIMILARITY                 = src.SearchJobsRequest_DIVERSIFY_BY_LOOSER_SIMILARITY
	SearchJobsRequest_FEATURED_JOB_SEARCH                            = src.SearchJobsRequest_FEATURED_JOB_SEARCH
	SearchJobsRequest_JOB_SEARCH                                     = src.SearchJobsRequest_JOB_SEARCH
	SearchJobsRequest_KEYWORD_MATCH_ALL                              = src.SearchJobsRequest_KEYWORD_MATCH_ALL
	SearchJobsRequest_KEYWORD_MATCH_DISABLED                         = src.SearchJobsRequest_KEYWORD_MATCH_DISABLED
	SearchJobsRequest_KEYWORD_MATCH_MODE_UNSPECIFIED                 = src.SearchJobsRequest_KEYWORD_MATCH_MODE_UNSPECIFIED
	SearchJobsRequest_KEYWORD_MATCH_TITLE_ONLY                       = src.SearchJobsRequest_KEYWORD_MATCH_TITLE_ONLY
	SearchJobsRequest_ONE_PER_COMPANY                                = src.SearchJobsRequest_ONE_PER_COMPANY
	SearchJobsRequest_SEARCH_MODE_UNSPECIFIED                        = src.SearchJobsRequest_SEARCH_MODE_UNSPECIFIED
	SearchJobsRequest_SIMPLE                                         = src.SearchJobsRequest_SIMPLE
	SearchJobsRequest_TWO_PER_COMPANY                                = src.SearchJobsRequest_TWO_PER_COMPANY
	Visibility_ACCOUNT_ONLY                                          = src.Visibility_ACCOUNT_ONLY
	Visibility_SHARED_WITH_GOOGLE                                    = src.Visibility_SHARED_WITH_GOOGLE
	Visibility_SHARED_WITH_PUBLIC                                    = src.Visibility_SHARED_WITH_PUBLIC
	Visibility_VISIBILITY_UNSPECIFIED                                = src.Visibility_VISIBILITY_UNSPECIFIED
)

// Deprecated: Please use vars in: cloud.google.com/go/talent/apiv4/talentpb
var (
	BatchOperationMetadata_State_name                         = src.BatchOperationMetadata_State_name
	BatchOperationMetadata_State_value                        = src.BatchOperationMetadata_State_value
	CommuteFilter_RoadTraffic_name                            = src.CommuteFilter_RoadTraffic_name
	CommuteFilter_RoadTraffic_value                           = src.CommuteFilter_RoadTraffic_value
	CommuteMethod_name                                        = src.CommuteMethod_name
	CommuteMethod_value                                       = src.CommuteMethod_value
	CompanySize_name                                          = src.CompanySize_name
	CompanySize_value                                         = src.CompanySize_value
	CompensationFilter_FilterType_name                        = src.CompensationFilter_FilterType_name
	CompensationFilter_FilterType_value                       = src.CompensationFilter_FilterType_value
	CompensationInfo_CompensationType_name                    = src.CompensationInfo_CompensationType_name
	CompensationInfo_CompensationType_value                   = src.CompensationInfo_CompensationType_value
	CompensationInfo_CompensationUnit_name                    = src.CompensationInfo_CompensationUnit_name
	CompensationInfo_CompensationUnit_value                   = src.CompensationInfo_CompensationUnit_value
	CompleteQueryRequest_CompletionScope_name                 = src.CompleteQueryRequest_CompletionScope_name
	CompleteQueryRequest_CompletionScope_value                = src.CompleteQueryRequest_CompletionScope_value
	CompleteQueryRequest_CompletionType_name                  = src.CompleteQueryRequest_CompletionType_name
	CompleteQueryRequest_CompletionType_value                 = src.CompleteQueryRequest_CompletionType_value
	DegreeType_name                                           = src.DegreeType_name
	DegreeType_value                                          = src.DegreeType_value
	DeviceInfo_DeviceType_name                                = src.DeviceInfo_DeviceType_name
	DeviceInfo_DeviceType_value                               = src.DeviceInfo_DeviceType_value
	EmploymentType_name                                       = src.EmploymentType_name
	EmploymentType_value                                      = src.EmploymentType_value
	File_google_cloud_talent_v4_common_proto                  = src.File_google_cloud_talent_v4_common_proto
	File_google_cloud_talent_v4_company_proto                 = src.File_google_cloud_talent_v4_company_proto
	File_google_cloud_talent_v4_company_service_proto         = src.File_google_cloud_talent_v4_company_service_proto
	File_google_cloud_talent_v4_completion_service_proto      = src.File_google_cloud_talent_v4_completion_service_proto
	File_google_cloud_talent_v4_event_proto                   = src.File_google_cloud_talent_v4_event_proto
	File_google_cloud_talent_v4_event_service_proto           = src.File_google_cloud_talent_v4_event_service_proto
	File_google_cloud_talent_v4_filters_proto                 = src.File_google_cloud_talent_v4_filters_proto
	File_google_cloud_talent_v4_histogram_proto               = src.File_google_cloud_talent_v4_histogram_proto
	File_google_cloud_talent_v4_job_proto                     = src.File_google_cloud_talent_v4_job_proto
	File_google_cloud_talent_v4_job_service_proto             = src.File_google_cloud_talent_v4_job_service_proto
	File_google_cloud_talent_v4_tenant_proto                  = src.File_google_cloud_talent_v4_tenant_proto
	File_google_cloud_talent_v4_tenant_service_proto          = src.File_google_cloud_talent_v4_tenant_service_proto
	HtmlSanitization_name                                     = src.HtmlSanitization_name
	HtmlSanitization_value                                    = src.HtmlSanitization_value
	JobBenefit_name                                           = src.JobBenefit_name
	JobBenefit_value                                          = src.JobBenefit_value
	JobCategory_name                                          = src.JobCategory_name
	JobCategory_value                                         = src.JobCategory_value
	JobEvent_JobEventType_name                                = src.JobEvent_JobEventType_name
	JobEvent_JobEventType_value                               = src.JobEvent_JobEventType_value
	JobLevel_name                                             = src.JobLevel_name
	JobLevel_value                                            = src.JobLevel_value
	JobView_name                                              = src.JobView_name
	JobView_value                                             = src.JobView_value
	LocationFilter_TelecommutePreference_name                 = src.LocationFilter_TelecommutePreference_name
	LocationFilter_TelecommutePreference_value                = src.LocationFilter_TelecommutePreference_value
	Location_LocationType_name                                = src.Location_LocationType_name
	Location_LocationType_value                               = src.Location_LocationType_value
	PostingRegion_name                                        = src.PostingRegion_name
	PostingRegion_value                                       = src.PostingRegion_value
	SearchJobsRequest_CustomRankingInfo_ImportanceLevel_name  = src.SearchJobsRequest_CustomRankingInfo_ImportanceLevel_name
	SearchJobsRequest_CustomRankingInfo_ImportanceLevel_value = src.SearchJobsRequest_CustomRankingInfo_ImportanceLevel_value
	SearchJobsRequest_DiversificationLevel_name               = src.SearchJobsRequest_DiversificationLevel_name
	SearchJobsRequest_DiversificationLevel_value              = src.SearchJobsRequest_DiversificationLevel_value
	SearchJobsRequest_KeywordMatchMode_name                   = src.SearchJobsRequest_KeywordMatchMode_name
	SearchJobsRequest_KeywordMatchMode_value                  = src.SearchJobsRequest_KeywordMatchMode_value
	SearchJobsRequest_SearchMode_name                         = src.SearchJobsRequest_SearchMode_name
	SearchJobsRequest_SearchMode_value                        = src.SearchJobsRequest_SearchMode_value
	Visibility_name                                           = src.Visibility_name
	Visibility_value                                          = src.Visibility_value
)

// Request to create a batch of jobs.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type BatchCreateJobsRequest = src.BatchCreateJobsRequest

// The result of
// [JobService.BatchCreateJobs][google.cloud.talent.v4.JobService.BatchCreateJobs].
// It's used to replace
// [google.longrunning.Operation.response][google.longrunning.Operation.response]
// in case of success.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type BatchCreateJobsResponse = src.BatchCreateJobsResponse

// Request to delete a batch of jobs.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type BatchDeleteJobsRequest = src.BatchDeleteJobsRequest

// The result of
// [JobService.BatchDeleteJobs][google.cloud.talent.v4.JobService.BatchDeleteJobs].
// It's used to replace
// [google.longrunning.Operation.response][google.longrunning.Operation.response]
// in case of success.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type BatchDeleteJobsResponse = src.BatchDeleteJobsResponse

// Metadata used for long running operations returned by CTS batch APIs. It's
// used to replace
// [google.longrunning.Operation.metadata][google.longrunning.Operation.metadata].
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type BatchOperationMetadata = src.BatchOperationMetadata
type BatchOperationMetadata_State = src.BatchOperationMetadata_State

// Request to update a batch of jobs.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type BatchUpdateJobsRequest = src.BatchUpdateJobsRequest

// The result of
// [JobService.BatchUpdateJobs][google.cloud.talent.v4.JobService.BatchUpdateJobs].
// It's used to replace
// [google.longrunning.Operation.response][google.longrunning.Operation.response]
// in case of success.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type BatchUpdateJobsResponse = src.BatchUpdateJobsResponse

// An event issued when an end user interacts with the application that
// implements Cloud Talent Solution. Providing this information improves the
// quality of results for the API clients, enabling the service to perform
// optimally. The number of events sent must be consistent with other calls,
// such as job searches, issued to the service by the client.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type ClientEvent = src.ClientEvent
type ClientEvent_JobEvent = src.ClientEvent_JobEvent

// Parameters needed for commute search.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CommuteFilter = src.CommuteFilter
type CommuteFilter_DepartureTime = src.CommuteFilter_DepartureTime

// The traffic density to use when calculating commute time.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CommuteFilter_RoadTraffic = src.CommuteFilter_RoadTraffic
type CommuteFilter_RoadTraffic_ = src.CommuteFilter_RoadTraffic_

// Method for commute. Walking, biking and wheelchair accessible transit is
// still in the Preview stage.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CommuteMethod = src.CommuteMethod

// A Company resource represents a company in the service. A company is the
// entity that owns job postings, that is, the hiring entity responsible for
// employing applicants for the job position.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type Company = src.Company

// CompanyServiceClient is the client API for CompanyService service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompanyServiceClient = src.CompanyServiceClient

// CompanyServiceServer is the server API for CompanyService service.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompanyServiceServer = src.CompanyServiceServer

// An enum that represents the size of the company.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompanySize = src.CompanySize

// Derived details about the company.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type Company_DerivedInfo = src.Company_DerivedInfo

// Filter on job compensation type and amount.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompensationFilter = src.CompensationFilter

// Specify the type of filtering.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompensationFilter_FilterType = src.CompensationFilter_FilterType

// Job compensation details.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompensationInfo = src.CompensationInfo

// A compensation entry that represents one component of compensation, such as
// base pay, bonus, or other compensation type. Annualization: One compensation
// entry can be annualized if - it contains valid
// [amount][google.cloud.talent.v4.CompensationInfo.CompensationEntry.amount]
// or [range][google.cloud.talent.v4.CompensationInfo.CompensationEntry.range].
// - and its
// [expected_units_per_year][google.cloud.talent.v4.CompensationInfo.CompensationEntry.expected_units_per_year]
// is set or can be derived. Its annualized range is determined as
// ([amount][google.cloud.talent.v4.CompensationInfo.CompensationEntry.amount]
// or [range][google.cloud.talent.v4.CompensationInfo.CompensationEntry.range])
// times
// [expected_units_per_year][google.cloud.talent.v4.CompensationInfo.CompensationEntry.expected_units_per_year].
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompensationInfo_CompensationEntry = src.CompensationInfo_CompensationEntry
type CompensationInfo_CompensationEntry_Amount = src.CompensationInfo_CompensationEntry_Amount
type CompensationInfo_CompensationEntry_Range = src.CompensationInfo_CompensationEntry_Range

// Compensation range.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompensationInfo_CompensationRange = src.CompensationInfo_CompensationRange

// The type of compensation. For compensation amounts specified in
// non-monetary amounts, describe the compensation scheme in the
// [CompensationEntry.description][google.cloud.talent.v4.CompensationInfo.CompensationEntry.description].
// For example, tipping format is described in
// [CompensationEntry.description][google.cloud.talent.v4.CompensationInfo.CompensationEntry.description]
// (for example, "expect 15-20% tips based on customer bill.") and an estimate
// of the tips provided in
// [CompensationEntry.amount][google.cloud.talent.v4.CompensationInfo.CompensationEntry.amount]
// or
// [CompensationEntry.range][google.cloud.talent.v4.CompensationInfo.CompensationEntry.range]
// ($10 per hour). For example, equity is described in
// [CompensationEntry.description][google.cloud.talent.v4.CompensationInfo.CompensationEntry.description]
// (for example, "1% - 2% equity vesting over 4 years, 1 year cliff") and value
// estimated in
// [CompensationEntry.amount][google.cloud.talent.v4.CompensationInfo.CompensationEntry.amount]
// or
// [CompensationEntry.range][google.cloud.talent.v4.CompensationInfo.CompensationEntry.range].
// If no value estimate is possible, units are
// [CompensationUnit.COMPENSATION_UNIT_UNSPECIFIED][google.cloud.talent.v4.CompensationInfo.CompensationUnit.COMPENSATION_UNIT_UNSPECIFIED]
// and then further clarified in
// [CompensationEntry.description][google.cloud.talent.v4.CompensationInfo.CompensationEntry.description]
// field.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompensationInfo_CompensationType = src.CompensationInfo_CompensationType

// Pay frequency.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompensationInfo_CompensationUnit = src.CompensationInfo_CompensationUnit

// Auto-complete parameters.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompleteQueryRequest = src.CompleteQueryRequest

// Enum to specify the scope of completion.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompleteQueryRequest_CompletionScope = src.CompleteQueryRequest_CompletionScope

// Enum to specify auto-completion topics.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompleteQueryRequest_CompletionType = src.CompleteQueryRequest_CompletionType

// Response of auto-complete query.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompleteQueryResponse = src.CompleteQueryResponse

// Resource that represents completion results.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompleteQueryResponse_CompletionResult = src.CompleteQueryResponse_CompletionResult

// CompletionClient is the client API for Completion service. For semantics
// around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompletionClient = src.CompletionClient

// CompletionServer is the server API for Completion service.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CompletionServer = src.CompletionServer

// The report event request.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CreateClientEventRequest = src.CreateClientEventRequest

// The Request of the CreateCompany method.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CreateCompanyRequest = src.CreateCompanyRequest

// Create job request.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CreateJobRequest = src.CreateJobRequest

// The Request of the CreateTenant method.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CreateTenantRequest = src.CreateTenantRequest

// Custom attribute values that are either filterable or non-filterable.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type CustomAttribute = src.CustomAttribute

// Educational degree level defined in International Standard Classification
// of Education (ISCED).
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type DegreeType = src.DegreeType

// Request to delete a company.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type DeleteCompanyRequest = src.DeleteCompanyRequest

// Delete job request.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type DeleteJobRequest = src.DeleteJobRequest

// Request to delete a tenant.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type DeleteTenantRequest = src.DeleteTenantRequest

// Device information collected from the job seeker, candidate, or other
// entity conducting the job search. Providing this information improves the
// quality of the search results across devices.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type DeviceInfo = src.DeviceInfo

// An enumeration describing an API access portal and exposure mechanism.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type DeviceInfo_DeviceType = src.DeviceInfo_DeviceType

// An enum that represents the employment type of a job.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type EmploymentType = src.EmploymentType

// EventServiceClient is the client API for EventService service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type EventServiceClient = src.EventServiceClient

// EventServiceServer is the server API for EventService service.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type EventServiceServer = src.EventServiceServer

// Request for getting a company by name.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type GetCompanyRequest = src.GetCompanyRequest

// Get job request.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type GetJobRequest = src.GetJobRequest

// Request for getting a tenant by name.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type GetTenantRequest = src.GetTenantRequest

// The histogram request.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type HistogramQuery = src.HistogramQuery

// Histogram result that matches
// [HistogramQuery][google.cloud.talent.v4.HistogramQuery] specified in
// searches.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type HistogramQueryResult = src.HistogramQueryResult

// Option for HTML content sanitization on user input fields, for example, job
// description. By setting this option, user can determine whether and how
// sanitization is performed on these fields.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type HtmlSanitization = src.HtmlSanitization

// A Job resource represents a job posting (also referred to as a "job
// listing" or "job requisition"). A job belongs to a
// [Company][google.cloud.talent.v4.Company], which is the hiring entity
// responsible for the job.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type Job = src.Job

// An enum that represents employee benefits included with the job.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type JobBenefit = src.JobBenefit

// An enum that represents the categorization or primary focus of specific
// role. This value is different than the "industry" associated with a role,
// which is related to the categorization of the company listing the job.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type JobCategory = src.JobCategory

// An event issued when a job seeker interacts with the application that
// implements Cloud Talent Solution.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type JobEvent = src.JobEvent

// An enumeration of an event attributed to the behavior of the end user, such
// as a job seeker.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type JobEvent_JobEventType = src.JobEvent_JobEventType

// An enum that represents the required experience level required for the job.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type JobLevel = src.JobLevel

// The query required to perform a search query.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type JobQuery = src.JobQuery

// Mutation result of a job from a batch operation.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type JobResult = src.JobResult

// JobServiceClient is the client API for JobService service. For semantics
// around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type JobServiceClient = src.JobServiceClient

// JobServiceServer is the server API for JobService service.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type JobServiceServer = src.JobServiceServer

// An enum that specifies the job attributes that are returned in the
// [MatchingJob.job][google.cloud.talent.v4.SearchJobsResponse.MatchingJob.job]
// or [ListJobsResponse.jobs][google.cloud.talent.v4.ListJobsResponse.jobs]
// fields.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type JobView = src.JobView

// Application related details of a job posting.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type Job_ApplicationInfo = src.Job_ApplicationInfo

// Derived details about the job posting.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type Job_DerivedInfo = src.Job_DerivedInfo

// Options for job processing.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type Job_ProcessingOptions = src.Job_ProcessingOptions

// List companies for which the client has ACL visibility.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type ListCompaniesRequest = src.ListCompaniesRequest

// The List companies response object.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type ListCompaniesResponse = src.ListCompaniesResponse

// List jobs request.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type ListJobsRequest = src.ListJobsRequest

// List jobs response.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type ListJobsResponse = src.ListJobsResponse

// List tenants for which the client has ACL visibility.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type ListTenantsRequest = src.ListTenantsRequest

// The List tenants response object.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type ListTenantsResponse = src.ListTenantsResponse

// A resource that represents a location with full geographic information.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type Location = src.Location

// Geographic region of the search.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type LocationFilter = src.LocationFilter

// Specify whether to include telecommute jobs.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type LocationFilter_TelecommutePreference = src.LocationFilter_TelecommutePreference

// An enum which represents the type of a location.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type Location_LocationType = src.Location_LocationType

// An enum that represents the job posting region. In most cases, job postings
// don't need to specify a region. If a region is given, jobs are eligible for
// searches in the specified region.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type PostingRegion = src.PostingRegion

// Meta information related to the job searcher or entity conducting the job
// search. This information is used to improve the performance of the service.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type RequestMetadata = src.RequestMetadata

// Additional information returned to client, such as debugging information.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type ResponseMetadata = src.ResponseMetadata

// The Request body of the `SearchJobs` call.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type SearchJobsRequest = src.SearchJobsRequest

// Custom ranking information for
// [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type SearchJobsRequest_CustomRankingInfo = src.SearchJobsRequest_CustomRankingInfo

// The importance level for
// [CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression].
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type SearchJobsRequest_CustomRankingInfo_ImportanceLevel = src.SearchJobsRequest_CustomRankingInfo_ImportanceLevel

// Controls whether highly similar jobs are returned next to each other in the
// search results. Jobs are identified as highly similar based on their titles,
// job categories, and locations. Highly similar results are clustered so that
// only one representative job of the cluster is displayed to the job seeker
// higher up in the results, with the other jobs being displayed lower down in
// the results. If you are using pageToken to page through the result set,
// latency might be lower but we can't guarantee that all results are returned.
// If you are using page offset, latency might be higher but all results are
// returned.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type SearchJobsRequest_DiversificationLevel = src.SearchJobsRequest_DiversificationLevel

// Controls what keyword matching behavior the search has. When keyword
// matching is enabled, a keyword match returns jobs that may not match given
// category filters when there are matching keywords. For example, for the
// query "program manager" with KeywordMatchMode set to KEYWORD_MATCH_ALL, a
// job posting with the title "software developer," which doesn't fall into
// "program manager" ontology, and "program manager" appearing in its
// description will be surfaced. For queries like "cloud" that don't contain
// title or location specific ontology, jobs with "cloud" keyword matches are
// returned regardless of this enum's value. Use
// [Company.keyword_searchable_job_custom_attributes][google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes]
// if company-specific globally matched custom field/attribute string values
// are needed. Enabling keyword match improves recall of subsequent search
// requests.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type SearchJobsRequest_KeywordMatchMode = src.SearchJobsRequest_KeywordMatchMode

// A string-represented enumeration of the job search mode. The service
// operate differently for different modes of service.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type SearchJobsRequest_SearchMode = src.SearchJobsRequest_SearchMode

// Response for SearchJob method.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type SearchJobsResponse = src.SearchJobsResponse

// Commute details related to this job.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type SearchJobsResponse_CommuteInfo = src.SearchJobsResponse_CommuteInfo

// Job entry with metadata inside
// [SearchJobsResponse][google.cloud.talent.v4.SearchJobsResponse].
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type SearchJobsResponse_MatchingJob = src.SearchJobsResponse_MatchingJob

// Spell check result.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type SpellingCorrection = src.SpellingCorrection

// A Tenant resource represents a tenant in the service. A tenant is a group
// or entity that shares common access with specific privileges for resources
// like jobs. Customer may create multiple tenants to provide data isolation
// for different groups.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type Tenant = src.Tenant

// TenantServiceClient is the client API for TenantService service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type TenantServiceClient = src.TenantServiceClient

// TenantServiceServer is the server API for TenantService service.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type TenantServiceServer = src.TenantServiceServer

// Message representing a period of time between two timestamps.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type TimestampRange = src.TimestampRange

// UnimplementedCompanyServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type UnimplementedCompanyServiceServer = src.UnimplementedCompanyServiceServer

// UnimplementedCompletionServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type UnimplementedCompletionServer = src.UnimplementedCompletionServer

// UnimplementedEventServiceServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type UnimplementedEventServiceServer = src.UnimplementedEventServiceServer

// UnimplementedJobServiceServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type UnimplementedJobServiceServer = src.UnimplementedJobServiceServer

// UnimplementedTenantServiceServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type UnimplementedTenantServiceServer = src.UnimplementedTenantServiceServer

// Request for updating a specified company.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type UpdateCompanyRequest = src.UpdateCompanyRequest

// Update job request.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type UpdateJobRequest = src.UpdateJobRequest

// Request for updating a specified tenant.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type UpdateTenantRequest = src.UpdateTenantRequest

// Deprecated. All resources are only visible to the owner. An enum that
// represents who has view access to the resource. Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/talent/apiv4/talentpb
type Visibility = src.Visibility

// Deprecated: Please use funcs in: cloud.google.com/go/talent/apiv4/talentpb
func NewCompanyServiceClient(cc grpc.ClientConnInterface) CompanyServiceClient {
	return src.NewCompanyServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/talent/apiv4/talentpb
func NewCompletionClient(cc grpc.ClientConnInterface) CompletionClient {
	return src.NewCompletionClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/talent/apiv4/talentpb
func NewEventServiceClient(cc grpc.ClientConnInterface) EventServiceClient {
	return src.NewEventServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/talent/apiv4/talentpb
func NewJobServiceClient(cc grpc.ClientConnInterface) JobServiceClient {
	return src.NewJobServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/talent/apiv4/talentpb
func NewTenantServiceClient(cc grpc.ClientConnInterface) TenantServiceClient {
	return src.NewTenantServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/talent/apiv4/talentpb
func RegisterCompanyServiceServer(s *grpc.Server, srv CompanyServiceServer) {
	src.RegisterCompanyServiceServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/talent/apiv4/talentpb
func RegisterCompletionServer(s *grpc.Server, srv CompletionServer) {
	src.RegisterCompletionServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/talent/apiv4/talentpb
func RegisterEventServiceServer(s *grpc.Server, srv EventServiceServer) {
	src.RegisterEventServiceServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/talent/apiv4/talentpb
func RegisterJobServiceServer(s *grpc.Server, srv JobServiceServer) {
	src.RegisterJobServiceServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/talent/apiv4/talentpb
func RegisterTenantServiceServer(s *grpc.Server, srv TenantServiceServer) {
	src.RegisterTenantServiceServer(s, srv)
}
