/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.file.attribute.FileTime;
import java.util.jar.JarEntry;
import org.jruby.util.JarCache;
import org.jruby.util.JarResource;

class JarFileResource
extends JarResource {
    private final JarCache.JarIndex index;
    private final JarEntry entry;

    JarFileResource(String jarPath, boolean rootSlashPrefix, JarCache.JarIndex index2, JarEntry entry) {
        super(jarPath, rootSlashPrefix);
        this.index = index2;
        this.entry = entry;
    }

    @Override
    public String entryName() {
        return this.entry.getName();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public long length() {
        return this.entry.getSize();
    }

    @Override
    public FileTime creationTime() {
        return this.entry.getCreationTime();
    }

    @Override
    public FileTime lastAccessTime() {
        return this.entry.getLastAccessTime();
    }

    @Override
    public FileTime lastModifiedTime() {
        return this.entry.getLastModifiedTime();
    }

    @Override
    public String[] list() {
        return null;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.index.getInputStream(this.entry);
    }

    @Override
    public Channel openChannel(int flags2, int perm) throws IOException {
        return Channels.newChannel(this.openInputStream());
    }

    @Override
    public <T> T unwrap(Class<T> type2) {
        if (type2 == JarEntry.class) {
            return (T)this.entry;
        }
        throw new UnsupportedOperationException("unwrap: " + type2.getName());
    }
}

