#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 610
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 105
#define ALIAS_COUNT 0
#define TOKEN_COUNT 55
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 3
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 20

enum ts_symbol_identifiers {
  sym_identifier = 1,
  sym_comment = 2,
  sym_number = 3,
  sym_string_string = 4,
  sym_code_string = 5,
  sym_var = 6,
  anon_sym_include = 7,
  sym_preprocessor = 8,
  anon_sym_LBRACE = 9,
  anon_sym_RBRACE = 10,
  anon_sym_class = 11,
  anon_sym_COLON = 12,
  anon_sym_COMMA = 13,
  anon_sym_LT = 14,
  anon_sym_EQ = 15,
  anon_sym_GT = 16,
  anon_sym_SEMI = 17,
  anon_sym_field = 18,
  anon_sym_code = 19,
  anon_sym_let = 20,
  anon_sym_defvar = 21,
  anon_sym_def = 22,
  anon_sym_in = 23,
  anon_sym_multiclass = 24,
  anon_sym_defm = 25,
  anon_sym_defset = 26,
  anon_sym_deftype = 27,
  anon_sym_foreach = 28,
  anon_sym_if = 29,
  anon_sym_then = 30,
  anon_sym_else = 31,
  anon_sym_assert = 32,
  anon_sym_bit = 33,
  anon_sym_int = 34,
  anon_sym_string = 35,
  anon_sym_dag = 36,
  anon_sym_bits = 37,
  anon_sym_list = 38,
  anon_sym_POUND = 39,
  anon_sym_true = 40,
  anon_sym_false = 41,
  anon_sym_QMARK = 42,
  anon_sym_LBRACK = 43,
  anon_sym_RBRACK = 44,
  anon_sym_LPAREN = 45,
  anon_sym_RPAREN = 46,
  anon_sym_BANGcond = 47,
  anon_sym_DOT = 48,
  anon_sym_DOT_DOT_DOT = 49,
  anon_sym_DASH = 50,
  anon_sym_dump = 51,
  anon_sym_BANG = 52,
  aux_sym_operator_keyword_token1 = 53,
  sym_multiline_comment = 54,
  sym_file = 55,
  sym_include = 56,
  sym_statement = 57,
  sym_statement_or_block = 58,
  sym_class = 59,
  sym_parent_class_list = 60,
  sym_argument_list = 61,
  sym_template_args = 62,
  sym_template_arg = 63,
  sym_record_body = 64,
  sym_body_item = 65,
  sym_instruction = 66,
  sym_let_inst = 67,
  sym_def_var = 68,
  sym_def = 69,
  sym_let = 70,
  sym_let_item = 71,
  sym_multiclass = 72,
  sym_multiclass_body = 73,
  sym_multiclass_statement = 74,
  sym_defm = 75,
  sym_defset = 76,
  sym_defvar = 77,
  sym_deftype = 78,
  sym_foreach = 79,
  sym_if = 80,
  sym_assert = 81,
  sym_type = 82,
  sym_value = 83,
  sym__value_concat = 84,
  sym__simple_value = 85,
  aux_sym__repeated_string = 86,
  sym_operator = 87,
  sym_dag_arg = 88,
  sym_value_suffix = 89,
  sym_dump = 90,
  sym_operator_keyword = 91,
  aux_sym_file_repeat1 = 92,
  aux_sym_parent_class_list_repeat1 = 93,
  aux_sym_argument_list_repeat1 = 94,
  aux_sym_template_args_repeat1 = 95,
  aux_sym_record_body_repeat1 = 96,
  aux_sym_let_inst_repeat1 = 97,
  aux_sym_let_repeat1 = 98,
  aux_sym_multiclass_body_repeat1 = 99,
  aux_sym_value_repeat1 = 100,
  aux_sym__value_concat_repeat1 = 101,
  aux_sym__simple_value_repeat1 = 102,
  aux_sym__simple_value_repeat2 = 103,
  aux_sym_operator_repeat1 = 104,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_comment] = "comment",
  [sym_number] = "number",
  [sym_string_string] = "string_string",
  [sym_code_string] = "code_string",
  [sym_var] = "var",
  [anon_sym_include] = "include",
  [sym_preprocessor] = "preprocessor",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_class] = "class",
  [anon_sym_COLON] = ":",
  [anon_sym_COMMA] = ",",
  [anon_sym_LT] = "<",
  [anon_sym_EQ] = "=",
  [anon_sym_GT] = ">",
  [anon_sym_SEMI] = ";",
  [anon_sym_field] = "field",
  [anon_sym_code] = "code",
  [anon_sym_let] = "let",
  [anon_sym_defvar] = "defvar",
  [anon_sym_def] = "def",
  [anon_sym_in] = "in",
  [anon_sym_multiclass] = "multiclass",
  [anon_sym_defm] = "defm",
  [anon_sym_defset] = "defset",
  [anon_sym_deftype] = "deftype",
  [anon_sym_foreach] = "foreach",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_else] = "else",
  [anon_sym_assert] = "assert",
  [anon_sym_bit] = "bit",
  [anon_sym_int] = "int",
  [anon_sym_string] = "string",
  [anon_sym_dag] = "dag",
  [anon_sym_bits] = "bits",
  [anon_sym_list] = "list",
  [anon_sym_POUND] = "#",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_QMARK] = "\?",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_BANGcond] = "!cond",
  [anon_sym_DOT] = ".",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_DASH] = "-",
  [anon_sym_dump] = "dump",
  [anon_sym_BANG] = "!",
  [aux_sym_operator_keyword_token1] = "operator_keyword_token1",
  [sym_multiline_comment] = "multiline_comment",
  [sym_file] = "file",
  [sym_include] = "include",
  [sym_statement] = "statement",
  [sym_statement_or_block] = "statement_or_block",
  [sym_class] = "class",
  [sym_parent_class_list] = "parent_class_list",
  [sym_argument_list] = "argument_list",
  [sym_template_args] = "template_args",
  [sym_template_arg] = "template_arg",
  [sym_record_body] = "record_body",
  [sym_body_item] = "body_item",
  [sym_instruction] = "instruction",
  [sym_let_inst] = "let_inst",
  [sym_def_var] = "def_var",
  [sym_def] = "def",
  [sym_let] = "let",
  [sym_let_item] = "let_item",
  [sym_multiclass] = "multiclass",
  [sym_multiclass_body] = "multiclass_body",
  [sym_multiclass_statement] = "multiclass_statement",
  [sym_defm] = "defm",
  [sym_defset] = "defset",
  [sym_defvar] = "defvar",
  [sym_deftype] = "deftype",
  [sym_foreach] = "foreach",
  [sym_if] = "if",
  [sym_assert] = "assert",
  [sym_type] = "type",
  [sym_value] = "value",
  [sym__value_concat] = "_value_concat",
  [sym__simple_value] = "_simple_value",
  [aux_sym__repeated_string] = "_repeated_string",
  [sym_operator] = "operator",
  [sym_dag_arg] = "dag_arg",
  [sym_value_suffix] = "value_suffix",
  [sym_dump] = "dump",
  [sym_operator_keyword] = "operator_keyword",
  [aux_sym_file_repeat1] = "file_repeat1",
  [aux_sym_parent_class_list_repeat1] = "parent_class_list_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_template_args_repeat1] = "template_args_repeat1",
  [aux_sym_record_body_repeat1] = "record_body_repeat1",
  [aux_sym_let_inst_repeat1] = "let_inst_repeat1",
  [aux_sym_let_repeat1] = "let_repeat1",
  [aux_sym_multiclass_body_repeat1] = "multiclass_body_repeat1",
  [aux_sym_value_repeat1] = "value_repeat1",
  [aux_sym__value_concat_repeat1] = "_value_concat_repeat1",
  [aux_sym__simple_value_repeat1] = "_simple_value_repeat1",
  [aux_sym__simple_value_repeat2] = "_simple_value_repeat2",
  [aux_sym_operator_repeat1] = "operator_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_comment] = sym_comment,
  [sym_number] = sym_number,
  [sym_string_string] = sym_string_string,
  [sym_code_string] = sym_code_string,
  [sym_var] = sym_var,
  [anon_sym_include] = anon_sym_include,
  [sym_preprocessor] = sym_preprocessor,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_field] = anon_sym_field,
  [anon_sym_code] = anon_sym_code,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_defvar] = anon_sym_defvar,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_multiclass] = anon_sym_multiclass,
  [anon_sym_defm] = anon_sym_defm,
  [anon_sym_defset] = anon_sym_defset,
  [anon_sym_deftype] = anon_sym_deftype,
  [anon_sym_foreach] = anon_sym_foreach,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_bit] = anon_sym_bit,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_dag] = anon_sym_dag,
  [anon_sym_bits] = anon_sym_bits,
  [anon_sym_list] = anon_sym_list,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_BANGcond] = anon_sym_BANGcond,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_dump] = anon_sym_dump,
  [anon_sym_BANG] = anon_sym_BANG,
  [aux_sym_operator_keyword_token1] = aux_sym_operator_keyword_token1,
  [sym_multiline_comment] = sym_multiline_comment,
  [sym_file] = sym_file,
  [sym_include] = sym_include,
  [sym_statement] = sym_statement,
  [sym_statement_or_block] = sym_statement_or_block,
  [sym_class] = sym_class,
  [sym_parent_class_list] = sym_parent_class_list,
  [sym_argument_list] = sym_argument_list,
  [sym_template_args] = sym_template_args,
  [sym_template_arg] = sym_template_arg,
  [sym_record_body] = sym_record_body,
  [sym_body_item] = sym_body_item,
  [sym_instruction] = sym_instruction,
  [sym_let_inst] = sym_let_inst,
  [sym_def_var] = sym_def_var,
  [sym_def] = sym_def,
  [sym_let] = sym_let,
  [sym_let_item] = sym_let_item,
  [sym_multiclass] = sym_multiclass,
  [sym_multiclass_body] = sym_multiclass_body,
  [sym_multiclass_statement] = sym_multiclass_statement,
  [sym_defm] = sym_defm,
  [sym_defset] = sym_defset,
  [sym_defvar] = sym_defvar,
  [sym_deftype] = sym_deftype,
  [sym_foreach] = sym_foreach,
  [sym_if] = sym_if,
  [sym_assert] = sym_assert,
  [sym_type] = sym_type,
  [sym_value] = sym_value,
  [sym__value_concat] = sym__value_concat,
  [sym__simple_value] = sym__simple_value,
  [aux_sym__repeated_string] = aux_sym__repeated_string,
  [sym_operator] = sym_operator,
  [sym_dag_arg] = sym_dag_arg,
  [sym_value_suffix] = sym_value_suffix,
  [sym_dump] = sym_dump,
  [sym_operator_keyword] = sym_operator_keyword,
  [aux_sym_file_repeat1] = aux_sym_file_repeat1,
  [aux_sym_parent_class_list_repeat1] = aux_sym_parent_class_list_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_template_args_repeat1] = aux_sym_template_args_repeat1,
  [aux_sym_record_body_repeat1] = aux_sym_record_body_repeat1,
  [aux_sym_let_inst_repeat1] = aux_sym_let_inst_repeat1,
  [aux_sym_let_repeat1] = aux_sym_let_repeat1,
  [aux_sym_multiclass_body_repeat1] = aux_sym_multiclass_body_repeat1,
  [aux_sym_value_repeat1] = aux_sym_value_repeat1,
  [aux_sym__value_concat_repeat1] = aux_sym__value_concat_repeat1,
  [aux_sym__simple_value_repeat1] = aux_sym__simple_value_repeat1,
  [aux_sym__simple_value_repeat2] = aux_sym__simple_value_repeat2,
  [aux_sym_operator_repeat1] = aux_sym_operator_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_string_string] = {
    .visible = true,
    .named = true,
  },
  [sym_code_string] = {
    .visible = true,
    .named = true,
  },
  [sym_var] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [sym_preprocessor] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_field] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_code] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defvar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_multiclass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_deftype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_foreach] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dag] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_list] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANGcond] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dump] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_operator_keyword_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_multiline_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_file] = {
    .visible = true,
    .named = true,
  },
  [sym_include] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_or_block] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_parent_class_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_template_args] = {
    .visible = true,
    .named = true,
  },
  [sym_template_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_record_body] = {
    .visible = true,
    .named = true,
  },
  [sym_body_item] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction] = {
    .visible = true,
    .named = true,
  },
  [sym_let_inst] = {
    .visible = true,
    .named = true,
  },
  [sym_def_var] = {
    .visible = true,
    .named = true,
  },
  [sym_def] = {
    .visible = true,
    .named = true,
  },
  [sym_let] = {
    .visible = true,
    .named = true,
  },
  [sym_let_item] = {
    .visible = true,
    .named = true,
  },
  [sym_multiclass] = {
    .visible = true,
    .named = true,
  },
  [sym_multiclass_body] = {
    .visible = true,
    .named = true,
  },
  [sym_multiclass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_defm] = {
    .visible = true,
    .named = true,
  },
  [sym_defset] = {
    .visible = true,
    .named = true,
  },
  [sym_defvar] = {
    .visible = true,
    .named = true,
  },
  [sym_deftype] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym__value_concat] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_value] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__repeated_string] = {
    .visible = false,
    .named = false,
  },
  [sym_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_dag_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_value_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_dump] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_keyword] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parent_class_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_inst_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_multiclass_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__value_concat_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_value_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_argument = 1,
  field_body = 2,
  field_name = 3,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_body] = "body",
  [field_name] = "name",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 2},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 2},
  [6] = {.index = 7, .length = 1},
  [7] = {.index = 8, .length = 1},
  [8] = {.index = 9, .length = 2},
  [9] = {.index = 11, .length = 1},
  [10] = {.index = 12, .length = 1},
  [11] = {.index = 13, .length = 2},
  [12] = {.index = 15, .length = 2},
  [13] = {.index = 17, .length = 2},
  [14] = {.index = 19, .length = 3},
  [15] = {.index = 22, .length = 3},
  [16] = {.index = 25, .length = 4},
  [17] = {.index = 29, .length = 4},
  [18] = {.index = 33, .length = 1},
  [19] = {.index = 34, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_body, 1},
  [1] =
    {field_argument, 0, .inherited = true},
  [2] =
    {field_body, 2},
    {field_name, 1},
  [4] =
    {field_body, 2},
  [5] =
    {field_body, 3},
    {field_name, 1},
  [7] =
    {field_body, 3},
  [8] =
    {field_argument, 1},
  [9] =
    {field_body, 4},
    {field_name, 1},
  [11] =
    {field_argument, 2},
  [12] =
    {field_body, 4},
  [13] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
  [15] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [17] =
    {field_argument, 2},
    {field_argument, 3, .inherited = true},
  [19] =
    {field_argument, 2},
    {field_argument, 3},
    {field_argument, 4},
  [22] =
    {field_argument, 1},
    {field_argument, 2},
    {field_argument, 3},
  [25] =
    {field_argument, 2},
    {field_argument, 3},
    {field_argument, 4},
    {field_argument, 5, .inherited = true},
  [29] =
    {field_argument, 1},
    {field_argument, 2},
    {field_argument, 3},
    {field_argument, 4, .inherited = true},
  [33] =
    {field_argument, 5},
  [34] =
    {field_argument, 5},
    {field_argument, 6, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 6,
  [13] = 13,
  [14] = 9,
  [15] = 8,
  [16] = 11,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 7,
  [21] = 21,
  [22] = 11,
  [23] = 10,
  [24] = 21,
  [25] = 11,
  [26] = 17,
  [27] = 19,
  [28] = 28,
  [29] = 28,
  [30] = 13,
  [31] = 7,
  [32] = 7,
  [33] = 33,
  [34] = 33,
  [35] = 35,
  [36] = 33,
  [37] = 35,
  [38] = 35,
  [39] = 4,
  [40] = 35,
  [41] = 33,
  [42] = 42,
  [43] = 4,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 47,
  [49] = 49,
  [50] = 50,
  [51] = 49,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 52,
  [57] = 53,
  [58] = 4,
  [59] = 55,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 61,
  [64] = 4,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 91,
  [95] = 95,
  [96] = 96,
  [97] = 89,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 88,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 104,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 74,
  [113] = 103,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 90,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 82,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 49,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 47,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 127,
  [145] = 128,
  [146] = 132,
  [147] = 147,
  [148] = 136,
  [149] = 149,
  [150] = 140,
  [151] = 135,
  [152] = 149,
  [153] = 153,
  [154] = 133,
  [155] = 142,
  [156] = 143,
  [157] = 139,
  [158] = 158,
  [159] = 50,
  [160] = 160,
  [161] = 141,
  [162] = 153,
  [163] = 47,
  [164] = 137,
  [165] = 131,
  [166] = 46,
  [167] = 49,
  [168] = 129,
  [169] = 147,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 174,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 170,
  [189] = 186,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 175,
  [198] = 195,
  [199] = 199,
  [200] = 200,
  [201] = 67,
  [202] = 177,
  [203] = 173,
  [204] = 170,
  [205] = 175,
  [206] = 170,
  [207] = 175,
  [208] = 208,
  [209] = 179,
  [210] = 190,
  [211] = 66,
  [212] = 60,
  [213] = 213,
  [214] = 62,
  [215] = 60,
  [216] = 62,
  [217] = 65,
  [218] = 72,
  [219] = 65,
  [220] = 68,
  [221] = 110,
  [222] = 98,
  [223] = 223,
  [224] = 224,
  [225] = 76,
  [226] = 226,
  [227] = 85,
  [228] = 228,
  [229] = 229,
  [230] = 86,
  [231] = 87,
  [232] = 232,
  [233] = 92,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 93,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 69,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 71,
  [246] = 77,
  [247] = 78,
  [248] = 248,
  [249] = 249,
  [250] = 79,
  [251] = 95,
  [252] = 80,
  [253] = 111,
  [254] = 115,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 70,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 96,
  [264] = 42,
  [265] = 75,
  [266] = 124,
  [267] = 109,
  [268] = 119,
  [269] = 83,
  [270] = 120,
  [271] = 99,
  [272] = 121,
  [273] = 232,
  [274] = 274,
  [275] = 100,
  [276] = 122,
  [277] = 102,
  [278] = 278,
  [279] = 84,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 114,
  [284] = 123,
  [285] = 108,
  [286] = 286,
  [287] = 287,
  [288] = 116,
  [289] = 73,
  [290] = 107,
  [291] = 125,
  [292] = 292,
  [293] = 117,
  [294] = 105,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 49,
  [309] = 47,
  [310] = 60,
  [311] = 65,
  [312] = 62,
  [313] = 232,
  [314] = 314,
  [315] = 232,
  [316] = 316,
  [317] = 228,
  [318] = 286,
  [319] = 282,
  [320] = 281,
  [321] = 280,
  [322] = 278,
  [323] = 249,
  [324] = 44,
  [325] = 243,
  [326] = 242,
  [327] = 240,
  [328] = 328,
  [329] = 239,
  [330] = 261,
  [331] = 292,
  [332] = 287,
  [333] = 295,
  [334] = 262,
  [335] = 260,
  [336] = 257,
  [337] = 256,
  [338] = 316,
  [339] = 248,
  [340] = 340,
  [341] = 244,
  [342] = 234,
  [343] = 236,
  [344] = 274,
  [345] = 238,
  [346] = 255,
  [347] = 235,
  [348] = 258,
  [349] = 226,
  [350] = 45,
  [351] = 223,
  [352] = 229,
  [353] = 224,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 357,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 358,
  [365] = 362,
  [366] = 366,
  [367] = 366,
  [368] = 368,
  [369] = 361,
  [370] = 359,
  [371] = 363,
  [372] = 372,
  [373] = 373,
  [374] = 372,
  [375] = 375,
  [376] = 373,
  [377] = 375,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 62,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 60,
  [391] = 391,
  [392] = 65,
  [393] = 393,
  [394] = 389,
  [395] = 387,
  [396] = 396,
  [397] = 382,
  [398] = 393,
  [399] = 399,
  [400] = 400,
  [401] = 396,
  [402] = 386,
  [403] = 213,
  [404] = 388,
  [405] = 405,
  [406] = 383,
  [407] = 405,
  [408] = 399,
  [409] = 400,
  [410] = 410,
  [411] = 380,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 418,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 434,
  [439] = 439,
  [440] = 440,
  [441] = 435,
  [442] = 436,
  [443] = 443,
  [444] = 444,
  [445] = 434,
  [446] = 446,
  [447] = 446,
  [448] = 448,
  [449] = 449,
  [450] = 449,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 436,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 457,
  [459] = 459,
  [460] = 456,
  [461] = 461,
  [462] = 429,
  [463] = 463,
  [464] = 434,
  [465] = 440,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 435,
  [473] = 473,
  [474] = 455,
  [475] = 475,
  [476] = 457,
  [477] = 477,
  [478] = 436,
  [479] = 470,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 459,
  [488] = 488,
  [489] = 432,
  [490] = 431,
  [491] = 491,
  [492] = 492,
  [493] = 485,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 457,
  [499] = 453,
  [500] = 484,
  [501] = 471,
  [502] = 502,
  [503] = 495,
  [504] = 504,
  [505] = 468,
  [506] = 504,
  [507] = 497,
  [508] = 433,
  [509] = 437,
  [510] = 439,
  [511] = 435,
  [512] = 448,
  [513] = 451,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 516,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 521,
  [523] = 521,
  [524] = 524,
  [525] = 525,
  [526] = 521,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 534,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 538,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 553,
  [555] = 555,
  [556] = 555,
  [557] = 545,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 552,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 544,
  [567] = 567,
  [568] = 535,
  [569] = 569,
  [570] = 570,
  [571] = 550,
  [572] = 564,
  [573] = 531,
  [574] = 561,
  [575] = 575,
  [576] = 576,
  [577] = 547,
  [578] = 578,
  [579] = 579,
  [580] = 565,
  [581] = 578,
  [582] = 576,
  [583] = 583,
  [584] = 584,
  [585] = 585,
  [586] = 586,
  [587] = 586,
  [588] = 588,
  [589] = 533,
  [590] = 570,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 542,
  [595] = 549,
  [596] = 585,
  [597] = 530,
  [598] = 598,
  [599] = 546,
  [600] = 600,
  [601] = 601,
  [602] = 570,
  [603] = 560,
  [604] = 532,
  [605] = 584,
  [606] = 548,
  [607] = 584,
  [608] = 570,
  [609] = 584,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(133);
      ADVANCE_MAP(
        '!', 171,
        '"', 1,
        '#', 159,
        '$', 131,
        '(', 164,
        ')', 165,
        '+', 128,
        ',', 154,
        '-', 170,
        '.', 167,
        '/', 5,
        '0', 135,
        ':', 153,
        ';', 158,
        '<', 155,
        '=', 156,
        '>', 157,
        '?', 160,
        '[', 162,
        ']', 163,
        '{', 151,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(146);
      if (lookahead == '\\') ADVANCE(125);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '#', 25,
        '/', 5,
        '0', 136,
        'a', 30,
        'c', 9,
        'd', 7,
        'e', 73,
        'f', 60,
        'g', 39,
        'h', 40,
        'i', 53,
        'l', 63,
        'm', 114,
        'n', 38,
        'o', 95,
        'r', 14,
        's', 45,
        't', 16,
        'x', 83,
        '+', 128,
        '-', 128,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(25);
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == '0') ADVANCE(136);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(128);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 4:
      if (lookahead == '.') ADVANCE(168);
      END_STATE();
    case 5:
      if (lookahead == '/') ADVANCE(134);
      END_STATE();
    case 6:
      if (lookahead == ']') ADVANCE(147);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead != 0) ADVANCE(121);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(54);
      if (lookahead == 'i') ADVANCE(115);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(172);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(100);
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(116);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(103);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(21);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(75);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(80);
      if (lookahead == 'e') ADVANCE(88);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(27);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(59);
      if (lookahead == 'o') ADVANCE(67);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(94);
      if (lookahead == 'n') ADVANCE(13);
      if (lookahead == 'o') ADVANCE(89);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(55);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(113);
      END_STATE();
    case 20:
      if (lookahead == 'b') ADVANCE(175);
      END_STATE();
    case 21:
      if (lookahead == 'c') ADVANCE(58);
      END_STATE();
    case 22:
      if (lookahead == 'c') ADVANCE(11);
      END_STATE();
    case 23:
      if (lookahead == 'c') ADVANCE(87);
      END_STATE();
    case 24:
      if (lookahead == 'c') ADVANCE(87);
      if (lookahead == 'f') ADVANCE(69);
      if (lookahead == 'r') ADVANCE(41);
      if (lookahead == 's') ADVANCE(93);
      END_STATE();
    case 25:
      if (lookahead == 'd') ADVANCE(42);
      if (lookahead == 'e') ADVANCE(65);
      if (lookahead == 'i') ADVANCE(49);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(166);
      END_STATE();
    case 27:
      if (lookahead == 'd') ADVANCE(172);
      END_STATE();
    case 28:
      if (lookahead == 'd') ADVANCE(66);
      END_STATE();
    case 29:
      if (lookahead == 'd') ADVANCE(62);
      END_STATE();
    case 30:
      if (lookahead == 'd') ADVANCE(27);
      if (lookahead == 'n') ADVANCE(27);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(18);
      if (lookahead == 'o') ADVANCE(89);
      END_STATE();
    case 32:
      if (lookahead == 'd') ADVANCE(46);
      END_STATE();
    case 33:
      if (lookahead == 'd') ADVANCE(46);
      if (lookahead == 'n') ADVANCE(32);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(172);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(172);
      if (lookahead == 'o') ADVANCE(103);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(176);
      if (lookahead == 't') ADVANCE(172);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(15);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(12);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(104);
      if (lookahead == 'h') ADVANCE(66);
      if (lookahead == 'i') ADVANCE(120);
      if (lookahead == 'r') ADVANCE(123);
      if (lookahead == 't') ADVANCE(96);
      if (lookahead == 'u') ADVANCE(20);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(52);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(76);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(10);
      END_STATE();
    case 49:
      if (lookahead == 'f') ADVANCE(33);
      END_STATE();
    case 50:
      if (lookahead == 'f') ADVANCE(61);
      END_STATE();
    case 51:
      if (lookahead == 'f') ADVANCE(149);
      END_STATE();
    case 52:
      if (lookahead == 'f') ADVANCE(126);
      END_STATE();
    case 53:
      if (lookahead == 'f') ADVANCE(172);
      if (lookahead == 'n') ADVANCE(110);
      if (lookahead == 's') ADVANCE(8);
      END_STATE();
    case 54:
      if (lookahead == 'g') ADVANCE(172);
      END_STATE();
    case 55:
      if (lookahead == 'g') ADVANCE(17);
      END_STATE();
    case 56:
      if (lookahead == 'g') ADVANCE(107);
      END_STATE();
    case 57:
      if (lookahead == 'g') ADVANCE(37);
      END_STATE();
    case 58:
      if (lookahead == 'h') ADVANCE(172);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(66);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'o') ADVANCE(68);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(79);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(51);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(101);
      if (lookahead == 'o') ADVANCE(56);
      if (lookahead == 'e' ||
          lookahead == 't') ADVANCE(172);
      END_STATE();
    case 64:
      if (lookahead == 'i') ADVANCE(102);
      END_STATE();
    case 65:
      if (lookahead == 'l') ADVANCE(99);
      if (lookahead == 'n') ADVANCE(29);
      END_STATE();
    case 66:
      if (lookahead == 'l') ADVANCE(172);
      END_STATE();
    case 67:
      if (lookahead == 'l') ADVANCE(86);
      if (lookahead == 'u') ADVANCE(91);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(28);
      if (lookahead == 'r') ADVANCE(44);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(19);
      END_STATE();
    case 70:
      if (lookahead == 'l') ADVANCE(11);
      END_STATE();
    case 71:
      if (lookahead == 'l') ADVANCE(48);
      END_STATE();
    case 72:
      if (lookahead == 'l') ADVANCE(111);
      if (lookahead == 'n') ADVANCE(27);
      END_STATE();
    case 73:
      if (lookahead == 'm') ADVANCE(90);
      if (lookahead == 'q') ADVANCE(172);
      if (lookahead == 'x') ADVANCE(64);
      END_STATE();
    case 74:
      if (lookahead == 'm') ADVANCE(85);
      END_STATE();
    case 75:
      if (lookahead == 'm') ADVANCE(37);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(172);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(173);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(26);
      END_STATE();
    case 79:
      if (lookahead == 'n') ADVANCE(35);
      END_STATE();
    case 80:
      if (lookahead == 'n') ADVANCE(57);
      END_STATE();
    case 81:
      if (lookahead == 'n') ADVANCE(22);
      END_STATE();
    case 82:
      if (lookahead == 'o') ADVANCE(78);
      END_STATE();
    case 83:
      if (lookahead == 'o') ADVANCE(95);
      END_STATE();
    case 84:
      if (lookahead == 'o') ADVANCE(172);
      END_STATE();
    case 85:
      if (lookahead == 'o') ADVANCE(116);
      END_STATE();
    case 86:
      if (lookahead == 'o') ADVANCE(118);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(81);
      END_STATE();
    case 88:
      if (lookahead == 'p') ADVANCE(95);
      END_STATE();
    case 89:
      if (lookahead == 'p') ADVANCE(172);
      END_STATE();
    case 90:
      if (lookahead == 'p') ADVANCE(105);
      END_STATE();
    case 91:
      if (lookahead == 'p') ADVANCE(92);
      END_STATE();
    case 92:
      if (lookahead == 'p') ADVANCE(36);
      END_STATE();
    case 93:
      if (lookahead == 'p') ADVANCE(70);
      END_STATE();
    case 94:
      if (lookahead == 'r') ADVANCE(54);
      END_STATE();
    case 95:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 96:
      if (lookahead == 'r') ADVANCE(23);
      END_STATE();
    case 97:
      if (lookahead == 'r') ADVANCE(71);
      END_STATE();
    case 98:
      if (lookahead == 's') ADVANCE(172);
      END_STATE();
    case 99:
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 100:
      if (lookahead == 's') ADVANCE(103);
      END_STATE();
    case 101:
      if (lookahead == 's') ADVANCE(106);
      END_STATE();
    case 102:
      if (lookahead == 's') ADVANCE(109);
      END_STATE();
    case 103:
      if (lookahead == 't') ADVANCE(172);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(119);
      END_STATE();
    case 106:
      if (lookahead == 't') ADVANCE(24);
      END_STATE();
    case 107:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(174);
      END_STATE();
    case 109:
      if (lookahead == 't') ADVANCE(98);
      END_STATE();
    case 110:
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(36);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 113:
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 114:
      if (lookahead == 'u') ADVANCE(66);
      END_STATE();
    case 115:
      if (lookahead == 'v') ADVANCE(172);
      END_STATE();
    case 116:
      if (lookahead == 'v') ADVANCE(37);
      END_STATE();
    case 117:
      if (lookahead == 'w') ADVANCE(84);
      END_STATE();
    case 118:
      if (lookahead == 'w') ADVANCE(36);
      END_STATE();
    case 119:
      if (lookahead == 'y') ADVANCE(172);
      END_STATE();
    case 120:
      if (lookahead == 'z') ADVANCE(37);
      END_STATE();
    case 121:
      if (lookahead == '}') ADVANCE(6);
      if (lookahead != 0) ADVANCE(121);
      END_STATE();
    case 122:
      if (lookahead == '}') ADVANCE(122);
      if (lookahead != 0 &&
          lookahead != ']') ADVANCE(121);
      END_STATE();
    case 123:
      if (lookahead == 'a' ||
          lookahead == 'l') ADVANCE(172);
      END_STATE();
    case 124:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(138);
      END_STATE();
    case 125:
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 't') ADVANCE(1);
      END_STATE();
    case 126:
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(127);
      END_STATE();
    case 127:
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(127);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 128:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 129:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 130:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(142);
      END_STATE();
    case 131:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(148);
      END_STATE();
    case 132:
      if (eof) ADVANCE(133);
      ADVANCE_MAP(
        '"', 1,
        '#', 159,
        ')', 165,
        ',', 154,
        '-', 169,
        '.', 167,
        '/', 5,
        ':', 153,
        ';', 158,
        '<', 155,
        '=', 156,
        '>', 157,
        '[', 161,
        ']', 163,
        '{', 151,
        '}', 152,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(132);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(134);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'b') ADVANCE(143);
      if (lookahead == 'x') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'b') ADVANCE(124);
      if (lookahead == 'x') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(137);
      if (('2' <= lookahead && lookahead <= '9')) ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(138);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(139);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(141);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(141);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(142);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(137);
      if (('2' <= lookahead && lookahead <= '9')) ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(144);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(141);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(141);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_string_string);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_code_string);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_var);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(148);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_preprocessor);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_preprocessor);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == 'd') ADVANCE(42);
      if (lookahead == 'e') ADVANCE(65);
      if (lookahead == 'i') ADVANCE(49);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '{') ADVANCE(121);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_BANGcond);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(4);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(140);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == 'c') ADVANCE(82);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym_operator_keyword_token1);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym_operator_keyword_token1);
      if (lookahead == 'd') ADVANCE(172);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(aux_sym_operator_keyword_token1);
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(aux_sym_operator_keyword_token1);
      if (lookahead == 's') ADVANCE(108);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(aux_sym_operator_keyword_token1);
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'i', 7,
        'l', 8,
        'm', 9,
        's', 10,
        't', 11,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(12);
      END_STATE();
    case 2:
      if (lookahead == 'i') ADVANCE(13);
      END_STATE();
    case 3:
      if (lookahead == 'l') ADVANCE(14);
      if (lookahead == 'o') ADVANCE(15);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(16);
      if (lookahead == 'e') ADVANCE(17);
      if (lookahead == 'u') ADVANCE(18);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(19);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(20);
      if (lookahead == 'i') ADVANCE(21);
      if (lookahead == 'o') ADVANCE(22);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(25);
      if (lookahead == 'i') ADVANCE(26);
      END_STATE();
    case 9:
      if (lookahead == 'u') ADVANCE(27);
      END_STATE();
    case 10:
      if (lookahead == 't') ADVANCE(28);
      END_STATE();
    case 11:
      if (lookahead == 'h') ADVANCE(29);
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 12:
      if (lookahead == 's') ADVANCE(31);
      END_STATE();
    case 13:
      if (lookahead == 't') ADVANCE(32);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(33);
      END_STATE();
    case 15:
      if (lookahead == 'd') ADVANCE(34);
      END_STATE();
    case 16:
      if (lookahead == 'g') ADVANCE(35);
      END_STATE();
    case 17:
      if (lookahead == 'f') ADVANCE(36);
      END_STATE();
    case 18:
      if (lookahead == 'm') ADVANCE(37);
      END_STATE();
    case 19:
      if (lookahead == 's') ADVANCE(38);
      END_STATE();
    case 20:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 22:
      if (lookahead == 'r') ADVANCE(41);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'c') ADVANCE(42);
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 25:
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 26:
      if (lookahead == 's') ADVANCE(45);
      END_STATE();
    case 27:
      if (lookahead == 'l') ADVANCE(46);
      END_STATE();
    case 28:
      if (lookahead == 'r') ADVANCE(47);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 30:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_bit);
      if (lookahead == 's') ADVANCE(51);
      END_STATE();
    case 33:
      if (lookahead == 's') ADVANCE(52);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_dag);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_def);
      if (lookahead == 'm') ADVANCE(54);
      if (lookahead == 's') ADVANCE(55);
      if (lookahead == 't') ADVANCE(56);
      if (lookahead == 'v') ADVANCE(57);
      END_STATE();
    case 37:
      if (lookahead == 'p') ADVANCE(58);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 39:
      if (lookahead == 's') ADVANCE(60);
      END_STATE();
    case 40:
      if (lookahead == 'l') ADVANCE(61);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(62);
      END_STATE();
    case 42:
      if (lookahead == 'l') ADVANCE(63);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(64);
      END_STATE();
    case 46:
      if (lookahead == 't') ADVANCE(65);
      END_STATE();
    case 47:
      if (lookahead == 'i') ADVANCE(66);
      END_STATE();
    case 48:
      if (lookahead == 'n') ADVANCE(67);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(68);
      END_STATE();
    case 50:
      if (lookahead == 'r') ADVANCE(69);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_bits);
      END_STATE();
    case 52:
      if (lookahead == 's') ADVANCE(70);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_code);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_defm);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(71);
      END_STATE();
    case 56:
      if (lookahead == 'y') ADVANCE(72);
      END_STATE();
    case 57:
      if (lookahead == 'a') ADVANCE(73);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_dump);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 61:
      if (lookahead == 'd') ADVANCE(75);
      END_STATE();
    case 62:
      if (lookahead == 'a') ADVANCE(76);
      END_STATE();
    case 63:
      if (lookahead == 'u') ADVANCE(77);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_list);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(78);
      END_STATE();
    case 66:
      if (lookahead == 'n') ADVANCE(79);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 69:
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 72:
      if (lookahead == 'p') ADVANCE(82);
      END_STATE();
    case 73:
      if (lookahead == 'r') ADVANCE(83);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_field);
      END_STATE();
    case 76:
      if (lookahead == 'c') ADVANCE(84);
      END_STATE();
    case 77:
      if (lookahead == 'd') ADVANCE(85);
      END_STATE();
    case 78:
      if (lookahead == 'c') ADVANCE(86);
      END_STATE();
    case 79:
      if (lookahead == 'g') ADVANCE(87);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_defset);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(88);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_defvar);
      END_STATE();
    case 84:
      if (lookahead == 'h') ADVANCE(89);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 86:
      if (lookahead == 'l') ADVANCE(91);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_deftype);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_foreach);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_include);
      END_STATE();
    case 91:
      if (lookahead == 'a') ADVANCE(92);
      END_STATE();
    case 92:
      if (lookahead == 's') ADVANCE(93);
      END_STATE();
    case 93:
      if (lookahead == 's') ADVANCE(94);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_multiclass);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 132, .external_lex_state = 1},
  [2] = {.lex_state = 0, .external_lex_state = 1},
  [3] = {.lex_state = 0, .external_lex_state = 1},
  [4] = {.lex_state = 0, .external_lex_state = 1},
  [5] = {.lex_state = 132, .external_lex_state = 1},
  [6] = {.lex_state = 132, .external_lex_state = 1},
  [7] = {.lex_state = 132, .external_lex_state = 1},
  [8] = {.lex_state = 132, .external_lex_state = 1},
  [9] = {.lex_state = 132, .external_lex_state = 1},
  [10] = {.lex_state = 132, .external_lex_state = 1},
  [11] = {.lex_state = 132, .external_lex_state = 1},
  [12] = {.lex_state = 132, .external_lex_state = 1},
  [13] = {.lex_state = 132, .external_lex_state = 1},
  [14] = {.lex_state = 132, .external_lex_state = 1},
  [15] = {.lex_state = 132, .external_lex_state = 1},
  [16] = {.lex_state = 132, .external_lex_state = 1},
  [17] = {.lex_state = 132, .external_lex_state = 1},
  [18] = {.lex_state = 132, .external_lex_state = 1},
  [19] = {.lex_state = 132, .external_lex_state = 1},
  [20] = {.lex_state = 132, .external_lex_state = 1},
  [21] = {.lex_state = 132, .external_lex_state = 1},
  [22] = {.lex_state = 132, .external_lex_state = 1},
  [23] = {.lex_state = 132, .external_lex_state = 1},
  [24] = {.lex_state = 132, .external_lex_state = 1},
  [25] = {.lex_state = 132, .external_lex_state = 1},
  [26] = {.lex_state = 132, .external_lex_state = 1},
  [27] = {.lex_state = 132, .external_lex_state = 1},
  [28] = {.lex_state = 132, .external_lex_state = 1},
  [29] = {.lex_state = 132, .external_lex_state = 1},
  [30] = {.lex_state = 132, .external_lex_state = 1},
  [31] = {.lex_state = 132, .external_lex_state = 1},
  [32] = {.lex_state = 132, .external_lex_state = 1},
  [33] = {.lex_state = 132, .external_lex_state = 1},
  [34] = {.lex_state = 132, .external_lex_state = 1},
  [35] = {.lex_state = 132, .external_lex_state = 1},
  [36] = {.lex_state = 132, .external_lex_state = 1},
  [37] = {.lex_state = 132, .external_lex_state = 1},
  [38] = {.lex_state = 132, .external_lex_state = 1},
  [39] = {.lex_state = 0, .external_lex_state = 1},
  [40] = {.lex_state = 132, .external_lex_state = 1},
  [41] = {.lex_state = 132, .external_lex_state = 1},
  [42] = {.lex_state = 0, .external_lex_state = 1},
  [43] = {.lex_state = 0, .external_lex_state = 1},
  [44] = {.lex_state = 132, .external_lex_state = 1},
  [45] = {.lex_state = 132, .external_lex_state = 1},
  [46] = {.lex_state = 132, .external_lex_state = 1},
  [47] = {.lex_state = 0, .external_lex_state = 1},
  [48] = {.lex_state = 0, .external_lex_state = 1},
  [49] = {.lex_state = 0, .external_lex_state = 1},
  [50] = {.lex_state = 0, .external_lex_state = 1},
  [51] = {.lex_state = 0, .external_lex_state = 1},
  [52] = {.lex_state = 0, .external_lex_state = 1},
  [53] = {.lex_state = 132, .external_lex_state = 1},
  [54] = {.lex_state = 132, .external_lex_state = 1},
  [55] = {.lex_state = 132, .external_lex_state = 1},
  [56] = {.lex_state = 0, .external_lex_state = 1},
  [57] = {.lex_state = 132, .external_lex_state = 1},
  [58] = {.lex_state = 0, .external_lex_state = 1},
  [59] = {.lex_state = 132, .external_lex_state = 1},
  [60] = {.lex_state = 0, .external_lex_state = 1},
  [61] = {.lex_state = 0, .external_lex_state = 1},
  [62] = {.lex_state = 0, .external_lex_state = 1},
  [63] = {.lex_state = 0, .external_lex_state = 1},
  [64] = {.lex_state = 0, .external_lex_state = 1},
  [65] = {.lex_state = 0, .external_lex_state = 1},
  [66] = {.lex_state = 0, .external_lex_state = 1},
  [67] = {.lex_state = 0, .external_lex_state = 1},
  [68] = {.lex_state = 0, .external_lex_state = 1},
  [69] = {.lex_state = 0, .external_lex_state = 1},
  [70] = {.lex_state = 0, .external_lex_state = 1},
  [71] = {.lex_state = 0, .external_lex_state = 1},
  [72] = {.lex_state = 0, .external_lex_state = 1},
  [73] = {.lex_state = 0, .external_lex_state = 1},
  [74] = {.lex_state = 0, .external_lex_state = 1},
  [75] = {.lex_state = 0, .external_lex_state = 1},
  [76] = {.lex_state = 0, .external_lex_state = 1},
  [77] = {.lex_state = 0, .external_lex_state = 1},
  [78] = {.lex_state = 0, .external_lex_state = 1},
  [79] = {.lex_state = 0, .external_lex_state = 1},
  [80] = {.lex_state = 0, .external_lex_state = 1},
  [81] = {.lex_state = 0, .external_lex_state = 1},
  [82] = {.lex_state = 0, .external_lex_state = 1},
  [83] = {.lex_state = 0, .external_lex_state = 1},
  [84] = {.lex_state = 0, .external_lex_state = 1},
  [85] = {.lex_state = 0, .external_lex_state = 1},
  [86] = {.lex_state = 0, .external_lex_state = 1},
  [87] = {.lex_state = 0, .external_lex_state = 1},
  [88] = {.lex_state = 0, .external_lex_state = 1},
  [89] = {.lex_state = 0, .external_lex_state = 1},
  [90] = {.lex_state = 0, .external_lex_state = 1},
  [91] = {.lex_state = 0, .external_lex_state = 1},
  [92] = {.lex_state = 0, .external_lex_state = 1},
  [93] = {.lex_state = 0, .external_lex_state = 1},
  [94] = {.lex_state = 0, .external_lex_state = 1},
  [95] = {.lex_state = 0, .external_lex_state = 1},
  [96] = {.lex_state = 0, .external_lex_state = 1},
  [97] = {.lex_state = 0, .external_lex_state = 1},
  [98] = {.lex_state = 0, .external_lex_state = 1},
  [99] = {.lex_state = 0, .external_lex_state = 1},
  [100] = {.lex_state = 0, .external_lex_state = 1},
  [101] = {.lex_state = 0, .external_lex_state = 1},
  [102] = {.lex_state = 0, .external_lex_state = 1},
  [103] = {.lex_state = 0, .external_lex_state = 1},
  [104] = {.lex_state = 0, .external_lex_state = 1},
  [105] = {.lex_state = 0, .external_lex_state = 1},
  [106] = {.lex_state = 0, .external_lex_state = 1},
  [107] = {.lex_state = 0, .external_lex_state = 1},
  [108] = {.lex_state = 0, .external_lex_state = 1},
  [109] = {.lex_state = 0, .external_lex_state = 1},
  [110] = {.lex_state = 0, .external_lex_state = 1},
  [111] = {.lex_state = 0, .external_lex_state = 1},
  [112] = {.lex_state = 0, .external_lex_state = 1},
  [113] = {.lex_state = 0, .external_lex_state = 1},
  [114] = {.lex_state = 0, .external_lex_state = 1},
  [115] = {.lex_state = 0, .external_lex_state = 1},
  [116] = {.lex_state = 0, .external_lex_state = 1},
  [117] = {.lex_state = 0, .external_lex_state = 1},
  [118] = {.lex_state = 0, .external_lex_state = 1},
  [119] = {.lex_state = 0, .external_lex_state = 1},
  [120] = {.lex_state = 0, .external_lex_state = 1},
  [121] = {.lex_state = 0, .external_lex_state = 1},
  [122] = {.lex_state = 0, .external_lex_state = 1},
  [123] = {.lex_state = 0, .external_lex_state = 1},
  [124] = {.lex_state = 0, .external_lex_state = 1},
  [125] = {.lex_state = 0, .external_lex_state = 1},
  [126] = {.lex_state = 0, .external_lex_state = 1},
  [127] = {.lex_state = 0, .external_lex_state = 1},
  [128] = {.lex_state = 0, .external_lex_state = 1},
  [129] = {.lex_state = 0, .external_lex_state = 1},
  [130] = {.lex_state = 0, .external_lex_state = 1},
  [131] = {.lex_state = 0, .external_lex_state = 1},
  [132] = {.lex_state = 0, .external_lex_state = 1},
  [133] = {.lex_state = 0, .external_lex_state = 1},
  [134] = {.lex_state = 132, .external_lex_state = 1},
  [135] = {.lex_state = 0, .external_lex_state = 1},
  [136] = {.lex_state = 0, .external_lex_state = 1},
  [137] = {.lex_state = 0, .external_lex_state = 1},
  [138] = {.lex_state = 132, .external_lex_state = 1},
  [139] = {.lex_state = 0, .external_lex_state = 1},
  [140] = {.lex_state = 132, .external_lex_state = 1},
  [141] = {.lex_state = 0, .external_lex_state = 1},
  [142] = {.lex_state = 0, .external_lex_state = 1},
  [143] = {.lex_state = 0, .external_lex_state = 1},
  [144] = {.lex_state = 0, .external_lex_state = 1},
  [145] = {.lex_state = 0, .external_lex_state = 1},
  [146] = {.lex_state = 0, .external_lex_state = 1},
  [147] = {.lex_state = 0, .external_lex_state = 1},
  [148] = {.lex_state = 0, .external_lex_state = 1},
  [149] = {.lex_state = 0, .external_lex_state = 1},
  [150] = {.lex_state = 132, .external_lex_state = 1},
  [151] = {.lex_state = 0, .external_lex_state = 1},
  [152] = {.lex_state = 0, .external_lex_state = 1},
  [153] = {.lex_state = 132, .external_lex_state = 1},
  [154] = {.lex_state = 0, .external_lex_state = 1},
  [155] = {.lex_state = 0, .external_lex_state = 1},
  [156] = {.lex_state = 0, .external_lex_state = 1},
  [157] = {.lex_state = 0, .external_lex_state = 1},
  [158] = {.lex_state = 132, .external_lex_state = 1},
  [159] = {.lex_state = 132, .external_lex_state = 1},
  [160] = {.lex_state = 0, .external_lex_state = 1},
  [161] = {.lex_state = 0, .external_lex_state = 1},
  [162] = {.lex_state = 132, .external_lex_state = 1},
  [163] = {.lex_state = 132, .external_lex_state = 1},
  [164] = {.lex_state = 0, .external_lex_state = 1},
  [165] = {.lex_state = 0, .external_lex_state = 1},
  [166] = {.lex_state = 132, .external_lex_state = 1},
  [167] = {.lex_state = 132, .external_lex_state = 1},
  [168] = {.lex_state = 0, .external_lex_state = 1},
  [169] = {.lex_state = 0, .external_lex_state = 1},
  [170] = {.lex_state = 0, .external_lex_state = 1},
  [171] = {.lex_state = 0, .external_lex_state = 1},
  [172] = {.lex_state = 0, .external_lex_state = 1},
  [173] = {.lex_state = 0, .external_lex_state = 1},
  [174] = {.lex_state = 0, .external_lex_state = 1},
  [175] = {.lex_state = 0, .external_lex_state = 1},
  [176] = {.lex_state = 0, .external_lex_state = 1},
  [177] = {.lex_state = 0, .external_lex_state = 1},
  [178] = {.lex_state = 0, .external_lex_state = 1},
  [179] = {.lex_state = 0, .external_lex_state = 1},
  [180] = {.lex_state = 0, .external_lex_state = 1},
  [181] = {.lex_state = 0, .external_lex_state = 1},
  [182] = {.lex_state = 0, .external_lex_state = 1},
  [183] = {.lex_state = 0, .external_lex_state = 1},
  [184] = {.lex_state = 0, .external_lex_state = 1},
  [185] = {.lex_state = 0, .external_lex_state = 1},
  [186] = {.lex_state = 0, .external_lex_state = 1},
  [187] = {.lex_state = 0, .external_lex_state = 1},
  [188] = {.lex_state = 0, .external_lex_state = 1},
  [189] = {.lex_state = 0, .external_lex_state = 1},
  [190] = {.lex_state = 0, .external_lex_state = 1},
  [191] = {.lex_state = 0, .external_lex_state = 1},
  [192] = {.lex_state = 0, .external_lex_state = 1},
  [193] = {.lex_state = 0, .external_lex_state = 1},
  [194] = {.lex_state = 0, .external_lex_state = 1},
  [195] = {.lex_state = 0, .external_lex_state = 1},
  [196] = {.lex_state = 0, .external_lex_state = 1},
  [197] = {.lex_state = 0, .external_lex_state = 1},
  [198] = {.lex_state = 0, .external_lex_state = 1},
  [199] = {.lex_state = 0, .external_lex_state = 1},
  [200] = {.lex_state = 0, .external_lex_state = 1},
  [201] = {.lex_state = 132, .external_lex_state = 1},
  [202] = {.lex_state = 0, .external_lex_state = 1},
  [203] = {.lex_state = 0, .external_lex_state = 1},
  [204] = {.lex_state = 0, .external_lex_state = 1},
  [205] = {.lex_state = 0, .external_lex_state = 1},
  [206] = {.lex_state = 0, .external_lex_state = 1},
  [207] = {.lex_state = 0, .external_lex_state = 1},
  [208] = {.lex_state = 0, .external_lex_state = 1},
  [209] = {.lex_state = 0, .external_lex_state = 1},
  [210] = {.lex_state = 0, .external_lex_state = 1},
  [211] = {.lex_state = 132, .external_lex_state = 1},
  [212] = {.lex_state = 132, .external_lex_state = 1},
  [213] = {.lex_state = 0, .external_lex_state = 1},
  [214] = {.lex_state = 132, .external_lex_state = 1},
  [215] = {.lex_state = 0, .external_lex_state = 1},
  [216] = {.lex_state = 0, .external_lex_state = 1},
  [217] = {.lex_state = 0, .external_lex_state = 1},
  [218] = {.lex_state = 132, .external_lex_state = 1},
  [219] = {.lex_state = 132, .external_lex_state = 1},
  [220] = {.lex_state = 132, .external_lex_state = 1},
  [221] = {.lex_state = 132, .external_lex_state = 1},
  [222] = {.lex_state = 132, .external_lex_state = 1},
  [223] = {.lex_state = 132, .external_lex_state = 1},
  [224] = {.lex_state = 132, .external_lex_state = 1},
  [225] = {.lex_state = 132, .external_lex_state = 1},
  [226] = {.lex_state = 132, .external_lex_state = 1},
  [227] = {.lex_state = 132, .external_lex_state = 1},
  [228] = {.lex_state = 132, .external_lex_state = 1},
  [229] = {.lex_state = 132, .external_lex_state = 1},
  [230] = {.lex_state = 132, .external_lex_state = 1},
  [231] = {.lex_state = 132, .external_lex_state = 1},
  [232] = {.lex_state = 132, .external_lex_state = 1},
  [233] = {.lex_state = 132, .external_lex_state = 1},
  [234] = {.lex_state = 132, .external_lex_state = 1},
  [235] = {.lex_state = 132, .external_lex_state = 1},
  [236] = {.lex_state = 132, .external_lex_state = 1},
  [237] = {.lex_state = 132, .external_lex_state = 1},
  [238] = {.lex_state = 132, .external_lex_state = 1},
  [239] = {.lex_state = 132, .external_lex_state = 1},
  [240] = {.lex_state = 132, .external_lex_state = 1},
  [241] = {.lex_state = 132, .external_lex_state = 1},
  [242] = {.lex_state = 132, .external_lex_state = 1},
  [243] = {.lex_state = 132, .external_lex_state = 1},
  [244] = {.lex_state = 132, .external_lex_state = 1},
  [245] = {.lex_state = 132, .external_lex_state = 1},
  [246] = {.lex_state = 132, .external_lex_state = 1},
  [247] = {.lex_state = 132, .external_lex_state = 1},
  [248] = {.lex_state = 132, .external_lex_state = 1},
  [249] = {.lex_state = 132, .external_lex_state = 1},
  [250] = {.lex_state = 132, .external_lex_state = 1},
  [251] = {.lex_state = 132, .external_lex_state = 1},
  [252] = {.lex_state = 132, .external_lex_state = 1},
  [253] = {.lex_state = 132, .external_lex_state = 1},
  [254] = {.lex_state = 132, .external_lex_state = 1},
  [255] = {.lex_state = 132, .external_lex_state = 1},
  [256] = {.lex_state = 132, .external_lex_state = 1},
  [257] = {.lex_state = 132, .external_lex_state = 1},
  [258] = {.lex_state = 132, .external_lex_state = 1},
  [259] = {.lex_state = 132, .external_lex_state = 1},
  [260] = {.lex_state = 132, .external_lex_state = 1},
  [261] = {.lex_state = 132, .external_lex_state = 1},
  [262] = {.lex_state = 132, .external_lex_state = 1},
  [263] = {.lex_state = 132, .external_lex_state = 1},
  [264] = {.lex_state = 132, .external_lex_state = 1},
  [265] = {.lex_state = 132, .external_lex_state = 1},
  [266] = {.lex_state = 132, .external_lex_state = 1},
  [267] = {.lex_state = 132, .external_lex_state = 1},
  [268] = {.lex_state = 132, .external_lex_state = 1},
  [269] = {.lex_state = 132, .external_lex_state = 1},
  [270] = {.lex_state = 132, .external_lex_state = 1},
  [271] = {.lex_state = 132, .external_lex_state = 1},
  [272] = {.lex_state = 132, .external_lex_state = 1},
  [273] = {.lex_state = 132, .external_lex_state = 1},
  [274] = {.lex_state = 132, .external_lex_state = 1},
  [275] = {.lex_state = 132, .external_lex_state = 1},
  [276] = {.lex_state = 132, .external_lex_state = 1},
  [277] = {.lex_state = 132, .external_lex_state = 1},
  [278] = {.lex_state = 132, .external_lex_state = 1},
  [279] = {.lex_state = 132, .external_lex_state = 1},
  [280] = {.lex_state = 132, .external_lex_state = 1},
  [281] = {.lex_state = 132, .external_lex_state = 1},
  [282] = {.lex_state = 132, .external_lex_state = 1},
  [283] = {.lex_state = 132, .external_lex_state = 1},
  [284] = {.lex_state = 132, .external_lex_state = 1},
  [285] = {.lex_state = 132, .external_lex_state = 1},
  [286] = {.lex_state = 132, .external_lex_state = 1},
  [287] = {.lex_state = 132, .external_lex_state = 1},
  [288] = {.lex_state = 132, .external_lex_state = 1},
  [289] = {.lex_state = 132, .external_lex_state = 1},
  [290] = {.lex_state = 132, .external_lex_state = 1},
  [291] = {.lex_state = 132, .external_lex_state = 1},
  [292] = {.lex_state = 132, .external_lex_state = 1},
  [293] = {.lex_state = 132, .external_lex_state = 1},
  [294] = {.lex_state = 132, .external_lex_state = 1},
  [295] = {.lex_state = 132, .external_lex_state = 1},
  [296] = {.lex_state = 0, .external_lex_state = 1},
  [297] = {.lex_state = 0, .external_lex_state = 1},
  [298] = {.lex_state = 132, .external_lex_state = 1},
  [299] = {.lex_state = 132, .external_lex_state = 1},
  [300] = {.lex_state = 132, .external_lex_state = 1},
  [301] = {.lex_state = 132, .external_lex_state = 1},
  [302] = {.lex_state = 132, .external_lex_state = 1},
  [303] = {.lex_state = 132, .external_lex_state = 1},
  [304] = {.lex_state = 132, .external_lex_state = 1},
  [305] = {.lex_state = 132, .external_lex_state = 1},
  [306] = {.lex_state = 132, .external_lex_state = 1},
  [307] = {.lex_state = 132, .external_lex_state = 1},
  [308] = {.lex_state = 132, .external_lex_state = 1},
  [309] = {.lex_state = 132, .external_lex_state = 1},
  [310] = {.lex_state = 132, .external_lex_state = 1},
  [311] = {.lex_state = 132, .external_lex_state = 1},
  [312] = {.lex_state = 132, .external_lex_state = 1},
  [313] = {.lex_state = 132, .external_lex_state = 1},
  [314] = {.lex_state = 132, .external_lex_state = 1},
  [315] = {.lex_state = 132, .external_lex_state = 1},
  [316] = {.lex_state = 132, .external_lex_state = 1},
  [317] = {.lex_state = 132, .external_lex_state = 1},
  [318] = {.lex_state = 132, .external_lex_state = 1},
  [319] = {.lex_state = 132, .external_lex_state = 1},
  [320] = {.lex_state = 132, .external_lex_state = 1},
  [321] = {.lex_state = 132, .external_lex_state = 1},
  [322] = {.lex_state = 132, .external_lex_state = 1},
  [323] = {.lex_state = 132, .external_lex_state = 1},
  [324] = {.lex_state = 132, .external_lex_state = 1},
  [325] = {.lex_state = 132, .external_lex_state = 1},
  [326] = {.lex_state = 132, .external_lex_state = 1},
  [327] = {.lex_state = 132, .external_lex_state = 1},
  [328] = {.lex_state = 132, .external_lex_state = 1},
  [329] = {.lex_state = 132, .external_lex_state = 1},
  [330] = {.lex_state = 132, .external_lex_state = 1},
  [331] = {.lex_state = 132, .external_lex_state = 1},
  [332] = {.lex_state = 132, .external_lex_state = 1},
  [333] = {.lex_state = 132, .external_lex_state = 1},
  [334] = {.lex_state = 132, .external_lex_state = 1},
  [335] = {.lex_state = 132, .external_lex_state = 1},
  [336] = {.lex_state = 132, .external_lex_state = 1},
  [337] = {.lex_state = 132, .external_lex_state = 1},
  [338] = {.lex_state = 132, .external_lex_state = 1},
  [339] = {.lex_state = 132, .external_lex_state = 1},
  [340] = {.lex_state = 132, .external_lex_state = 1},
  [341] = {.lex_state = 132, .external_lex_state = 1},
  [342] = {.lex_state = 132, .external_lex_state = 1},
  [343] = {.lex_state = 132, .external_lex_state = 1},
  [344] = {.lex_state = 132, .external_lex_state = 1},
  [345] = {.lex_state = 132, .external_lex_state = 1},
  [346] = {.lex_state = 132, .external_lex_state = 1},
  [347] = {.lex_state = 132, .external_lex_state = 1},
  [348] = {.lex_state = 132, .external_lex_state = 1},
  [349] = {.lex_state = 132, .external_lex_state = 1},
  [350] = {.lex_state = 132, .external_lex_state = 1},
  [351] = {.lex_state = 132, .external_lex_state = 1},
  [352] = {.lex_state = 132, .external_lex_state = 1},
  [353] = {.lex_state = 132, .external_lex_state = 1},
  [354] = {.lex_state = 132, .external_lex_state = 1},
  [355] = {.lex_state = 132, .external_lex_state = 1},
  [356] = {.lex_state = 132, .external_lex_state = 1},
  [357] = {.lex_state = 132, .external_lex_state = 1},
  [358] = {.lex_state = 132, .external_lex_state = 1},
  [359] = {.lex_state = 132, .external_lex_state = 1},
  [360] = {.lex_state = 132, .external_lex_state = 1},
  [361] = {.lex_state = 132, .external_lex_state = 1},
  [362] = {.lex_state = 132, .external_lex_state = 1},
  [363] = {.lex_state = 132, .external_lex_state = 1},
  [364] = {.lex_state = 132, .external_lex_state = 1},
  [365] = {.lex_state = 132, .external_lex_state = 1},
  [366] = {.lex_state = 132, .external_lex_state = 1},
  [367] = {.lex_state = 132, .external_lex_state = 1},
  [368] = {.lex_state = 132, .external_lex_state = 1},
  [369] = {.lex_state = 132, .external_lex_state = 1},
  [370] = {.lex_state = 132, .external_lex_state = 1},
  [371] = {.lex_state = 132, .external_lex_state = 1},
  [372] = {.lex_state = 0, .external_lex_state = 1},
  [373] = {.lex_state = 0, .external_lex_state = 1},
  [374] = {.lex_state = 0, .external_lex_state = 1},
  [375] = {.lex_state = 0, .external_lex_state = 1},
  [376] = {.lex_state = 0, .external_lex_state = 1},
  [377] = {.lex_state = 0, .external_lex_state = 1},
  [378] = {.lex_state = 0, .external_lex_state = 1},
  [379] = {.lex_state = 0, .external_lex_state = 1},
  [380] = {.lex_state = 0, .external_lex_state = 1},
  [381] = {.lex_state = 0, .external_lex_state = 1},
  [382] = {.lex_state = 0, .external_lex_state = 1},
  [383] = {.lex_state = 0, .external_lex_state = 1},
  [384] = {.lex_state = 0, .external_lex_state = 1},
  [385] = {.lex_state = 0, .external_lex_state = 1},
  [386] = {.lex_state = 0, .external_lex_state = 1},
  [387] = {.lex_state = 0, .external_lex_state = 1},
  [388] = {.lex_state = 0, .external_lex_state = 1},
  [389] = {.lex_state = 0, .external_lex_state = 1},
  [390] = {.lex_state = 0, .external_lex_state = 1},
  [391] = {.lex_state = 0, .external_lex_state = 1},
  [392] = {.lex_state = 0, .external_lex_state = 1},
  [393] = {.lex_state = 0, .external_lex_state = 1},
  [394] = {.lex_state = 0, .external_lex_state = 1},
  [395] = {.lex_state = 0, .external_lex_state = 1},
  [396] = {.lex_state = 0, .external_lex_state = 1},
  [397] = {.lex_state = 0, .external_lex_state = 1},
  [398] = {.lex_state = 0, .external_lex_state = 1},
  [399] = {.lex_state = 0, .external_lex_state = 1},
  [400] = {.lex_state = 0, .external_lex_state = 1},
  [401] = {.lex_state = 0, .external_lex_state = 1},
  [402] = {.lex_state = 0, .external_lex_state = 1},
  [403] = {.lex_state = 0, .external_lex_state = 1},
  [404] = {.lex_state = 0, .external_lex_state = 1},
  [405] = {.lex_state = 0, .external_lex_state = 1},
  [406] = {.lex_state = 0, .external_lex_state = 1},
  [407] = {.lex_state = 0, .external_lex_state = 1},
  [408] = {.lex_state = 0, .external_lex_state = 1},
  [409] = {.lex_state = 0, .external_lex_state = 1},
  [410] = {.lex_state = 0, .external_lex_state = 1},
  [411] = {.lex_state = 0, .external_lex_state = 1},
  [412] = {.lex_state = 0, .external_lex_state = 1},
  [413] = {.lex_state = 132, .external_lex_state = 1},
  [414] = {.lex_state = 132, .external_lex_state = 1},
  [415] = {.lex_state = 0, .external_lex_state = 1},
  [416] = {.lex_state = 0, .external_lex_state = 1},
  [417] = {.lex_state = 0, .external_lex_state = 1},
  [418] = {.lex_state = 0, .external_lex_state = 1},
  [419] = {.lex_state = 132, .external_lex_state = 1},
  [420] = {.lex_state = 0, .external_lex_state = 1},
  [421] = {.lex_state = 0, .external_lex_state = 1},
  [422] = {.lex_state = 0, .external_lex_state = 1},
  [423] = {.lex_state = 0, .external_lex_state = 1},
  [424] = {.lex_state = 132, .external_lex_state = 1},
  [425] = {.lex_state = 0, .external_lex_state = 1},
  [426] = {.lex_state = 0, .external_lex_state = 1},
  [427] = {.lex_state = 0, .external_lex_state = 1},
  [428] = {.lex_state = 0, .external_lex_state = 1},
  [429] = {.lex_state = 0, .external_lex_state = 1},
  [430] = {.lex_state = 132, .external_lex_state = 1},
  [431] = {.lex_state = 0, .external_lex_state = 1},
  [432] = {.lex_state = 0, .external_lex_state = 1},
  [433] = {.lex_state = 0, .external_lex_state = 1},
  [434] = {.lex_state = 132, .external_lex_state = 1},
  [435] = {.lex_state = 132, .external_lex_state = 1},
  [436] = {.lex_state = 132, .external_lex_state = 1},
  [437] = {.lex_state = 0, .external_lex_state = 1},
  [438] = {.lex_state = 132, .external_lex_state = 1},
  [439] = {.lex_state = 0, .external_lex_state = 1},
  [440] = {.lex_state = 0, .external_lex_state = 1},
  [441] = {.lex_state = 132, .external_lex_state = 1},
  [442] = {.lex_state = 132, .external_lex_state = 1},
  [443] = {.lex_state = 0, .external_lex_state = 1},
  [444] = {.lex_state = 0, .external_lex_state = 1},
  [445] = {.lex_state = 132, .external_lex_state = 1},
  [446] = {.lex_state = 0, .external_lex_state = 1},
  [447] = {.lex_state = 0, .external_lex_state = 1},
  [448] = {.lex_state = 0, .external_lex_state = 1},
  [449] = {.lex_state = 0, .external_lex_state = 1},
  [450] = {.lex_state = 0, .external_lex_state = 1},
  [451] = {.lex_state = 0, .external_lex_state = 1},
  [452] = {.lex_state = 132, .external_lex_state = 1},
  [453] = {.lex_state = 0, .external_lex_state = 1},
  [454] = {.lex_state = 132, .external_lex_state = 1},
  [455] = {.lex_state = 0, .external_lex_state = 1},
  [456] = {.lex_state = 0, .external_lex_state = 1},
  [457] = {.lex_state = 132, .external_lex_state = 1},
  [458] = {.lex_state = 132, .external_lex_state = 1},
  [459] = {.lex_state = 0, .external_lex_state = 1},
  [460] = {.lex_state = 0, .external_lex_state = 1},
  [461] = {.lex_state = 0, .external_lex_state = 1},
  [462] = {.lex_state = 0, .external_lex_state = 1},
  [463] = {.lex_state = 0, .external_lex_state = 1},
  [464] = {.lex_state = 132, .external_lex_state = 1},
  [465] = {.lex_state = 0, .external_lex_state = 1},
  [466] = {.lex_state = 0, .external_lex_state = 1},
  [467] = {.lex_state = 0, .external_lex_state = 1},
  [468] = {.lex_state = 0, .external_lex_state = 1},
  [469] = {.lex_state = 0, .external_lex_state = 1},
  [470] = {.lex_state = 0, .external_lex_state = 1},
  [471] = {.lex_state = 0, .external_lex_state = 1},
  [472] = {.lex_state = 132, .external_lex_state = 1},
  [473] = {.lex_state = 0, .external_lex_state = 1},
  [474] = {.lex_state = 0, .external_lex_state = 1},
  [475] = {.lex_state = 0, .external_lex_state = 1},
  [476] = {.lex_state = 132, .external_lex_state = 1},
  [477] = {.lex_state = 0, .external_lex_state = 1},
  [478] = {.lex_state = 132, .external_lex_state = 1},
  [479] = {.lex_state = 0, .external_lex_state = 1},
  [480] = {.lex_state = 0, .external_lex_state = 1},
  [481] = {.lex_state = 0, .external_lex_state = 1},
  [482] = {.lex_state = 0, .external_lex_state = 1},
  [483] = {.lex_state = 0, .external_lex_state = 1},
  [484] = {.lex_state = 0, .external_lex_state = 1},
  [485] = {.lex_state = 0, .external_lex_state = 1},
  [486] = {.lex_state = 0, .external_lex_state = 1},
  [487] = {.lex_state = 0, .external_lex_state = 1},
  [488] = {.lex_state = 0, .external_lex_state = 1},
  [489] = {.lex_state = 0, .external_lex_state = 1},
  [490] = {.lex_state = 0, .external_lex_state = 1},
  [491] = {.lex_state = 132, .external_lex_state = 1},
  [492] = {.lex_state = 0, .external_lex_state = 1},
  [493] = {.lex_state = 0, .external_lex_state = 1},
  [494] = {.lex_state = 0, .external_lex_state = 1},
  [495] = {.lex_state = 0, .external_lex_state = 1},
  [496] = {.lex_state = 0, .external_lex_state = 1},
  [497] = {.lex_state = 0, .external_lex_state = 1},
  [498] = {.lex_state = 132, .external_lex_state = 1},
  [499] = {.lex_state = 0, .external_lex_state = 1},
  [500] = {.lex_state = 0, .external_lex_state = 1},
  [501] = {.lex_state = 0, .external_lex_state = 1},
  [502] = {.lex_state = 0, .external_lex_state = 1},
  [503] = {.lex_state = 0, .external_lex_state = 1},
  [504] = {.lex_state = 0, .external_lex_state = 1},
  [505] = {.lex_state = 0, .external_lex_state = 1},
  [506] = {.lex_state = 0, .external_lex_state = 1},
  [507] = {.lex_state = 0, .external_lex_state = 1},
  [508] = {.lex_state = 0, .external_lex_state = 1},
  [509] = {.lex_state = 0, .external_lex_state = 1},
  [510] = {.lex_state = 0, .external_lex_state = 1},
  [511] = {.lex_state = 132, .external_lex_state = 1},
  [512] = {.lex_state = 0, .external_lex_state = 1},
  [513] = {.lex_state = 0, .external_lex_state = 1},
  [514] = {.lex_state = 0, .external_lex_state = 1},
  [515] = {.lex_state = 0, .external_lex_state = 1},
  [516] = {.lex_state = 0, .external_lex_state = 1},
  [517] = {.lex_state = 0, .external_lex_state = 1},
  [518] = {.lex_state = 0, .external_lex_state = 1},
  [519] = {.lex_state = 0, .external_lex_state = 1},
  [520] = {.lex_state = 0, .external_lex_state = 1},
  [521] = {.lex_state = 132, .external_lex_state = 1},
  [522] = {.lex_state = 132, .external_lex_state = 1},
  [523] = {.lex_state = 132, .external_lex_state = 1},
  [524] = {.lex_state = 132, .external_lex_state = 1},
  [525] = {.lex_state = 0, .external_lex_state = 1},
  [526] = {.lex_state = 132, .external_lex_state = 1},
  [527] = {.lex_state = 0, .external_lex_state = 1},
  [528] = {.lex_state = 132, .external_lex_state = 1},
  [529] = {.lex_state = 0, .external_lex_state = 1},
  [530] = {.lex_state = 0, .external_lex_state = 1},
  [531] = {.lex_state = 0, .external_lex_state = 1},
  [532] = {.lex_state = 0, .external_lex_state = 1},
  [533] = {.lex_state = 132, .external_lex_state = 1},
  [534] = {.lex_state = 0, .external_lex_state = 1},
  [535] = {.lex_state = 0, .external_lex_state = 1},
  [536] = {.lex_state = 0, .external_lex_state = 1},
  [537] = {.lex_state = 0, .external_lex_state = 1},
  [538] = {.lex_state = 0, .external_lex_state = 1},
  [539] = {.lex_state = 0, .external_lex_state = 1},
  [540] = {.lex_state = 0, .external_lex_state = 1},
  [541] = {.lex_state = 0, .external_lex_state = 1},
  [542] = {.lex_state = 0, .external_lex_state = 1},
  [543] = {.lex_state = 0, .external_lex_state = 1},
  [544] = {.lex_state = 0, .external_lex_state = 1},
  [545] = {.lex_state = 0, .external_lex_state = 1},
  [546] = {.lex_state = 0, .external_lex_state = 1},
  [547] = {.lex_state = 0, .external_lex_state = 1},
  [548] = {.lex_state = 132, .external_lex_state = 1},
  [549] = {.lex_state = 132, .external_lex_state = 1},
  [550] = {.lex_state = 0, .external_lex_state = 1},
  [551] = {.lex_state = 2, .external_lex_state = 1},
  [552] = {.lex_state = 0, .external_lex_state = 1},
  [553] = {.lex_state = 0, .external_lex_state = 1},
  [554] = {.lex_state = 0, .external_lex_state = 1},
  [555] = {.lex_state = 132, .external_lex_state = 1},
  [556] = {.lex_state = 132, .external_lex_state = 1},
  [557] = {.lex_state = 0, .external_lex_state = 1},
  [558] = {.lex_state = 0, .external_lex_state = 1},
  [559] = {.lex_state = 132, .external_lex_state = 1},
  [560] = {.lex_state = 0, .external_lex_state = 1},
  [561] = {.lex_state = 0, .external_lex_state = 1},
  [562] = {.lex_state = 0, .external_lex_state = 1},
  [563] = {.lex_state = 0, .external_lex_state = 1},
  [564] = {.lex_state = 0, .external_lex_state = 1},
  [565] = {.lex_state = 0, .external_lex_state = 1},
  [566] = {.lex_state = 0, .external_lex_state = 1},
  [567] = {.lex_state = 132, .external_lex_state = 1},
  [568] = {.lex_state = 0, .external_lex_state = 1},
  [569] = {.lex_state = 132, .external_lex_state = 1},
  [570] = {.lex_state = 0, .external_lex_state = 1},
  [571] = {.lex_state = 0, .external_lex_state = 1},
  [572] = {.lex_state = 0, .external_lex_state = 1},
  [573] = {.lex_state = 0, .external_lex_state = 1},
  [574] = {.lex_state = 0, .external_lex_state = 1},
  [575] = {.lex_state = 0, .external_lex_state = 1},
  [576] = {.lex_state = 0, .external_lex_state = 1},
  [577] = {.lex_state = 0, .external_lex_state = 1},
  [578] = {.lex_state = 0, .external_lex_state = 1},
  [579] = {.lex_state = 2, .external_lex_state = 1},
  [580] = {.lex_state = 0, .external_lex_state = 1},
  [581] = {.lex_state = 0, .external_lex_state = 1},
  [582] = {.lex_state = 0, .external_lex_state = 1},
  [583] = {.lex_state = 0, .external_lex_state = 1},
  [584] = {.lex_state = 132, .external_lex_state = 1},
  [585] = {.lex_state = 132, .external_lex_state = 1},
  [586] = {.lex_state = 132, .external_lex_state = 1},
  [587] = {.lex_state = 132, .external_lex_state = 1},
  [588] = {.lex_state = 132, .external_lex_state = 1},
  [589] = {.lex_state = 132, .external_lex_state = 1},
  [590] = {.lex_state = 0, .external_lex_state = 1},
  [591] = {.lex_state = 0, .external_lex_state = 1},
  [592] = {.lex_state = 0, .external_lex_state = 1},
  [593] = {.lex_state = 0, .external_lex_state = 1},
  [594] = {.lex_state = 0, .external_lex_state = 1},
  [595] = {.lex_state = 132, .external_lex_state = 1},
  [596] = {.lex_state = 132, .external_lex_state = 1},
  [597] = {.lex_state = 0, .external_lex_state = 1},
  [598] = {.lex_state = 132, .external_lex_state = 1},
  [599] = {.lex_state = 0, .external_lex_state = 1},
  [600] = {.lex_state = 132, .external_lex_state = 1},
  [601] = {.lex_state = 132, .external_lex_state = 1},
  [602] = {.lex_state = 0, .external_lex_state = 1},
  [603] = {.lex_state = 0, .external_lex_state = 1},
  [604] = {.lex_state = 0, .external_lex_state = 1},
  [605] = {.lex_state = 132, .external_lex_state = 1},
  [606] = {.lex_state = 132, .external_lex_state = 1},
  [607] = {.lex_state = 132, .external_lex_state = 1},
  [608] = {.lex_state = 0, .external_lex_state = 1},
  [609] = {.lex_state = 132, .external_lex_state = 1},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_number] = ACTIONS(1),
    [sym_string_string] = ACTIONS(1),
    [sym_code_string] = ACTIONS(1),
    [sym_var] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [sym_preprocessor] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_field] = ACTIONS(1),
    [anon_sym_code] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_defvar] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_multiclass] = ACTIONS(1),
    [anon_sym_defm] = ACTIONS(1),
    [anon_sym_defset] = ACTIONS(1),
    [anon_sym_deftype] = ACTIONS(1),
    [anon_sym_foreach] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_bit] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_dag] = ACTIONS(1),
    [anon_sym_bits] = ACTIONS(1),
    [anon_sym_list] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_BANGcond] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_dump] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [sym_multiline_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_file] = STATE(583),
    [sym_include] = STATE(234),
    [sym_statement] = STATE(18),
    [sym_class] = STATE(234),
    [sym_def] = STATE(234),
    [sym_let] = STATE(234),
    [sym_multiclass] = STATE(234),
    [sym_defm] = STATE(234),
    [sym_defset] = STATE(234),
    [sym_defvar] = STATE(234),
    [sym_deftype] = STATE(234),
    [sym_foreach] = STATE(234),
    [sym_if] = STATE(234),
    [sym_assert] = STATE(234),
    [sym_dump] = STATE(234),
    [aux_sym_file_repeat1] = STATE(18),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [anon_sym_include] = ACTIONS(7),
    [sym_preprocessor] = ACTIONS(3),
    [anon_sym_class] = ACTIONS(9),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_defvar] = ACTIONS(13),
    [anon_sym_def] = ACTIONS(15),
    [anon_sym_multiclass] = ACTIONS(17),
    [anon_sym_defm] = ACTIONS(19),
    [anon_sym_defset] = ACTIONS(21),
    [anon_sym_deftype] = ACTIONS(23),
    [anon_sym_foreach] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_assert] = ACTIONS(29),
    [anon_sym_dump] = ACTIONS(31),
    [sym_multiline_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 29,
    ACTIONS(33), 1,
      sym_identifier,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(43), 1,
      anon_sym_RBRACE,
    ACTIONS(45), 1,
      anon_sym_COMMA,
    ACTIONS(47), 1,
      anon_sym_field,
    ACTIONS(49), 1,
      anon_sym_code,
    ACTIONS(51), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_defvar,
    ACTIONS(55), 1,
      anon_sym_assert,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(69), 1,
      anon_sym_dump,
    ACTIONS(71), 1,
      anon_sym_BANG,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(402), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    STATE(601), 1,
      sym_type,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(57), 2,
      sym_body_item,
      aux_sym_record_body_repeat1,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(57), 4,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
    STATE(307), 5,
      sym_instruction,
      sym_let_inst,
      sym_def_var,
      sym_assert,
      sym_dump,
  [102] = 29,
    ACTIONS(33), 1,
      sym_identifier,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_COMMA,
    ACTIONS(47), 1,
      anon_sym_field,
    ACTIONS(49), 1,
      anon_sym_code,
    ACTIONS(51), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_defvar,
    ACTIONS(55), 1,
      anon_sym_assert,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(69), 1,
      anon_sym_dump,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(73), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(402), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    STATE(601), 1,
      sym_type,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(53), 2,
      sym_body_item,
      aux_sym_record_body_repeat1,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(57), 4,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
    STATE(307), 5,
      sym_instruction,
      sym_let_inst,
      sym_def_var,
      sym_assert,
      sym_dump,
  [204] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LBRACE,
    ACTIONS(88), 1,
      anon_sym_LBRACK,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(219), 1,
      sym_value,
    STATE(264), 1,
      sym__value_concat,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(79), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(134), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(77), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(86), 5,
      anon_sym_in,
      anon_sym_then,
      anon_sym_POUND,
      anon_sym_DOT,
      anon_sym_DASH,
    ACTIONS(84), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
  [274] = 17,
    ACTIONS(93), 1,
      anon_sym_include,
    ACTIONS(96), 1,
      anon_sym_class,
    ACTIONS(99), 1,
      anon_sym_let,
    ACTIONS(102), 1,
      anon_sym_defvar,
    ACTIONS(105), 1,
      anon_sym_def,
    ACTIONS(108), 1,
      anon_sym_multiclass,
    ACTIONS(111), 1,
      anon_sym_defm,
    ACTIONS(114), 1,
      anon_sym_defset,
    ACTIONS(117), 1,
      anon_sym_deftype,
    ACTIONS(120), 1,
      anon_sym_foreach,
    ACTIONS(123), 1,
      anon_sym_if,
    ACTIONS(126), 1,
      anon_sym_assert,
    ACTIONS(129), 1,
      anon_sym_dump,
    ACTIONS(91), 2,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
    STATE(5), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [342] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(132), 1,
      anon_sym_RBRACE,
    STATE(5), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [409] = 18,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(136), 1,
      anon_sym_LBRACE,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(140), 1,
      anon_sym_let,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(152), 1,
      anon_sym_deftype,
    ACTIONS(154), 1,
      anon_sym_foreach,
    ACTIONS(156), 1,
      anon_sym_if,
    ACTIONS(158), 1,
      anon_sym_assert,
    ACTIONS(160), 1,
      anon_sym_dump,
    STATE(315), 1,
      sym_statement_or_block,
    STATE(334), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(342), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [478] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(162), 1,
      anon_sym_RBRACE,
    STATE(5), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [545] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(162), 1,
      anon_sym_RBRACE,
    STATE(6), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [612] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(164), 1,
      anon_sym_RBRACE,
    STATE(5), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [679] = 18,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    STATE(262), 1,
      sym_statement,
    STATE(280), 1,
      sym_statement_or_block,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [748] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(168), 1,
      anon_sym_RBRACE,
    STATE(5), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [815] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(170), 1,
      anon_sym_RBRACE,
    STATE(5), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [882] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(172), 1,
      anon_sym_RBRACE,
    STATE(12), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [949] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(172), 1,
      anon_sym_RBRACE,
    STATE(5), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [1016] = 18,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    ACTIONS(174), 1,
      anon_sym_let,
    ACTIONS(176), 1,
      anon_sym_foreach,
    ACTIONS(178), 1,
      anon_sym_if,
    STATE(262), 1,
      sym_statement,
    STATE(280), 1,
      sym_statement_or_block,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [1085] = 18,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    STATE(262), 1,
      sym_statement,
    STATE(282), 1,
      sym_statement_or_block,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [1154] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(180), 1,
      ts_builtin_sym_end,
    STATE(5), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [1221] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(182), 1,
      anon_sym_RBRACE,
    STATE(10), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [1288] = 18,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(136), 1,
      anon_sym_LBRACE,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(140), 1,
      anon_sym_let,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(152), 1,
      anon_sym_deftype,
    ACTIONS(154), 1,
      anon_sym_foreach,
    ACTIONS(156), 1,
      anon_sym_if,
    ACTIONS(158), 1,
      anon_sym_assert,
    ACTIONS(160), 1,
      anon_sym_dump,
    STATE(313), 1,
      sym_statement_or_block,
    STATE(334), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(342), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [1357] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(184), 1,
      anon_sym_RBRACE,
    STATE(30), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [1424] = 18,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(136), 1,
      anon_sym_LBRACE,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(152), 1,
      anon_sym_deftype,
    ACTIONS(158), 1,
      anon_sym_assert,
    ACTIONS(160), 1,
      anon_sym_dump,
    ACTIONS(186), 1,
      anon_sym_let,
    ACTIONS(188), 1,
      anon_sym_foreach,
    ACTIONS(190), 1,
      anon_sym_if,
    STATE(321), 1,
      sym_statement_or_block,
    STATE(334), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(342), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [1493] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(192), 1,
      anon_sym_RBRACE,
    STATE(5), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [1560] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(194), 1,
      anon_sym_RBRACE,
    STATE(13), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [1627] = 18,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(136), 1,
      anon_sym_LBRACE,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(140), 1,
      anon_sym_let,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(152), 1,
      anon_sym_deftype,
    ACTIONS(154), 1,
      anon_sym_foreach,
    ACTIONS(156), 1,
      anon_sym_if,
    ACTIONS(158), 1,
      anon_sym_assert,
    ACTIONS(160), 1,
      anon_sym_dump,
    STATE(321), 1,
      sym_statement_or_block,
    STATE(334), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(342), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [1696] = 18,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(136), 1,
      anon_sym_LBRACE,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(152), 1,
      anon_sym_deftype,
    ACTIONS(158), 1,
      anon_sym_assert,
    ACTIONS(160), 1,
      anon_sym_dump,
    ACTIONS(186), 1,
      anon_sym_let,
    ACTIONS(188), 1,
      anon_sym_foreach,
    ACTIONS(190), 1,
      anon_sym_if,
    STATE(319), 1,
      sym_statement_or_block,
    STATE(334), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(342), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [1765] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(196), 1,
      anon_sym_RBRACE,
    STATE(23), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [1832] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(198), 1,
      anon_sym_RBRACE,
    STATE(8), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [1899] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(200), 1,
      anon_sym_RBRACE,
    STATE(15), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [1966] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(202), 1,
      anon_sym_RBRACE,
    STATE(5), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [2033] = 18,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    ACTIONS(174), 1,
      anon_sym_let,
    ACTIONS(176), 1,
      anon_sym_foreach,
    ACTIONS(178), 1,
      anon_sym_if,
    STATE(232), 1,
      sym_statement_or_block,
    STATE(262), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [2102] = 18,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(166), 1,
      anon_sym_LBRACE,
    ACTIONS(174), 1,
      anon_sym_let,
    ACTIONS(176), 1,
      anon_sym_foreach,
    ACTIONS(178), 1,
      anon_sym_if,
    STATE(262), 1,
      sym_statement,
    STATE(273), 1,
      sym_statement_or_block,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [2171] = 17,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(140), 1,
      anon_sym_let,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(152), 1,
      anon_sym_deftype,
    ACTIONS(154), 1,
      anon_sym_foreach,
    ACTIONS(156), 1,
      anon_sym_if,
    ACTIONS(158), 1,
      anon_sym_assert,
    ACTIONS(160), 1,
      anon_sym_dump,
    ACTIONS(204), 1,
      anon_sym_LBRACE,
    STATE(331), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(342), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [2237] = 17,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(152), 1,
      anon_sym_deftype,
    ACTIONS(158), 1,
      anon_sym_assert,
    ACTIONS(160), 1,
      anon_sym_dump,
    ACTIONS(186), 1,
      anon_sym_let,
    ACTIONS(188), 1,
      anon_sym_foreach,
    ACTIONS(190), 1,
      anon_sym_if,
    ACTIONS(204), 1,
      anon_sym_LBRACE,
    STATE(331), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(342), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [2303] = 17,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(140), 1,
      anon_sym_let,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(152), 1,
      anon_sym_deftype,
    ACTIONS(154), 1,
      anon_sym_foreach,
    ACTIONS(156), 1,
      anon_sym_if,
    ACTIONS(158), 1,
      anon_sym_assert,
    ACTIONS(160), 1,
      anon_sym_dump,
    ACTIONS(206), 1,
      anon_sym_LBRACE,
    STATE(345), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(342), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [2369] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(174), 1,
      anon_sym_let,
    ACTIONS(176), 1,
      anon_sym_foreach,
    ACTIONS(178), 1,
      anon_sym_if,
    ACTIONS(208), 1,
      anon_sym_LBRACE,
    STATE(292), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [2435] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(174), 1,
      anon_sym_let,
    ACTIONS(176), 1,
      anon_sym_foreach,
    ACTIONS(178), 1,
      anon_sym_if,
    ACTIONS(210), 1,
      anon_sym_LBRACE,
    STATE(238), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [2501] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(210), 1,
      anon_sym_LBRACE,
    STATE(238), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [2567] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(311), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(86), 3,
      anon_sym_in,
      anon_sym_then,
      anon_sym_POUND,
    ACTIONS(84), 7,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [2633] = 17,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(152), 1,
      anon_sym_deftype,
    ACTIONS(158), 1,
      anon_sym_assert,
    ACTIONS(160), 1,
      anon_sym_dump,
    ACTIONS(186), 1,
      anon_sym_let,
    ACTIONS(188), 1,
      anon_sym_foreach,
    ACTIONS(190), 1,
      anon_sym_if,
    ACTIONS(206), 1,
      anon_sym_LBRACE,
    STATE(345), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(342), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [2699] = 17,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_deftype,
    ACTIONS(25), 1,
      anon_sym_foreach,
    ACTIONS(27), 1,
      anon_sym_if,
    ACTIONS(29), 1,
      anon_sym_assert,
    ACTIONS(31), 1,
      anon_sym_dump,
    ACTIONS(208), 1,
      anon_sym_LBRACE,
    STATE(292), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(234), 13,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_deftype,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [2765] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(212), 11,
      sym_number,
      sym_identifier,
      anon_sym_in,
      anon_sym_then,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(214), 16,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_QMARK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [2802] = 17,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(222), 1,
      sym_string_string,
    ACTIONS(228), 1,
      anon_sym_LBRACE,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(234), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_BANGcond,
    ACTIONS(240), 1,
      anon_sym_BANG,
    STATE(42), 1,
      sym__value_concat,
    STATE(65), 1,
      sym_value,
    STATE(67), 1,
      aux_sym__repeated_string,
    STATE(518), 1,
      sym_operator_keyword,
    ACTIONS(225), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(51), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(86), 3,
      anon_sym_POUND,
      anon_sym_DOT,
      anon_sym_DASH,
    ACTIONS(219), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(84), 5,
      sym_var,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
  [2866] = 3,
    ACTIONS(243), 2,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(245), 23,
      sym_identifier,
      anon_sym_include,
      anon_sym_class,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_def,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
      anon_sym_dump,
  [2901] = 3,
    ACTIONS(247), 2,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(249), 23,
      sym_identifier,
      anon_sym_include,
      anon_sym_class,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_def,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
      anon_sym_dump,
  [2936] = 5,
    ACTIONS(255), 1,
      anon_sym_def,
    ACTIONS(257), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(253), 7,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    ACTIONS(251), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [2975] = 11,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(266), 1,
      anon_sym_LT,
    ACTIONS(269), 1,
      anon_sym_LBRACK,
    ACTIONS(272), 1,
      anon_sym_DOT,
    ACTIONS(275), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(278), 1,
      anon_sym_DASH,
    STATE(75), 1,
      sym_argument_list,
    STATE(50), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(259), 6,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
    ACTIONS(261), 8,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [3024] = 11,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(269), 1,
      anon_sym_LBRACK,
    ACTIONS(281), 1,
      anon_sym_LT,
    ACTIONS(283), 1,
      anon_sym_DOT,
    ACTIONS(285), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    STATE(75), 1,
      sym_argument_list,
    STATE(50), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(259), 6,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
    ACTIONS(261), 8,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [3073] = 11,
    ACTIONS(281), 1,
      anon_sym_LT,
    ACTIONS(283), 1,
      anon_sym_DOT,
    ACTIONS(285), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_LBRACE,
    ACTIONS(296), 1,
      anon_sym_LBRACK,
    STATE(75), 1,
      sym_argument_list,
    STATE(48), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(289), 6,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
    ACTIONS(291), 8,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [3122] = 11,
    ACTIONS(303), 1,
      anon_sym_LBRACE,
    ACTIONS(306), 1,
      anon_sym_LT,
    ACTIONS(309), 1,
      anon_sym_LBRACK,
    ACTIONS(312), 1,
      anon_sym_DOT,
    ACTIONS(315), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(318), 1,
      anon_sym_DASH,
    STATE(75), 1,
      sym_argument_list,
    STATE(50), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(299), 6,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
    ACTIONS(301), 8,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [3171] = 11,
    ACTIONS(293), 1,
      anon_sym_LBRACE,
    ACTIONS(296), 1,
      anon_sym_LBRACK,
    ACTIONS(321), 1,
      anon_sym_LT,
    ACTIONS(324), 1,
      anon_sym_DOT,
    ACTIONS(327), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(330), 1,
      anon_sym_DASH,
    STATE(75), 1,
      sym_argument_list,
    STATE(47), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(289), 6,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
    ACTIONS(291), 8,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [3220] = 19,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(337), 1,
      anon_sym_LBRACE,
    ACTIONS(339), 1,
      anon_sym_COLON,
    ACTIONS(341), 1,
      anon_sym_SEMI,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(258), 1,
      sym_record_body,
    STATE(373), 1,
      sym_value,
    STATE(479), 1,
      sym_parent_class_list,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(335), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(308), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(333), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3284] = 14,
    ACTIONS(47), 1,
      anon_sym_field,
    ACTIONS(49), 1,
      anon_sym_code,
    ACTIONS(51), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_defvar,
    ACTIONS(55), 1,
      anon_sym_assert,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    ACTIONS(69), 1,
      anon_sym_dump,
    ACTIONS(343), 1,
      anon_sym_RBRACE,
    STATE(601), 1,
      sym_type,
    STATE(54), 2,
      sym_body_item,
      aux_sym_record_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
    STATE(307), 5,
      sym_instruction,
      sym_let_inst,
      sym_def_var,
      sym_assert,
      sym_dump,
  [3338] = 14,
    ACTIONS(348), 1,
      anon_sym_RBRACE,
    ACTIONS(350), 1,
      anon_sym_field,
    ACTIONS(353), 1,
      anon_sym_code,
    ACTIONS(356), 1,
      anon_sym_let,
    ACTIONS(359), 1,
      anon_sym_defvar,
    ACTIONS(362), 1,
      anon_sym_assert,
    ACTIONS(365), 1,
      anon_sym_bits,
    ACTIONS(368), 1,
      anon_sym_list,
    ACTIONS(371), 1,
      anon_sym_dump,
    STATE(601), 1,
      sym_type,
    STATE(54), 2,
      sym_body_item,
      aux_sym_record_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(345), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
    STATE(307), 5,
      sym_instruction,
      sym_let_inst,
      sym_def_var,
      sym_assert,
      sym_dump,
  [3392] = 14,
    ACTIONS(47), 1,
      anon_sym_field,
    ACTIONS(49), 1,
      anon_sym_code,
    ACTIONS(51), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_defvar,
    ACTIONS(55), 1,
      anon_sym_assert,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    ACTIONS(69), 1,
      anon_sym_dump,
    ACTIONS(374), 1,
      anon_sym_RBRACE,
    STATE(601), 1,
      sym_type,
    STATE(53), 2,
      sym_body_item,
      aux_sym_record_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
    STATE(307), 5,
      sym_instruction,
      sym_let_inst,
      sym_def_var,
      sym_assert,
      sym_dump,
  [3446] = 19,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(339), 1,
      anon_sym_COLON,
    ACTIONS(376), 1,
      anon_sym_LBRACE,
    ACTIONS(378), 1,
      anon_sym_SEMI,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(348), 1,
      sym_record_body,
    STATE(376), 1,
      sym_value,
    STATE(470), 1,
      sym_parent_class_list,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(335), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(308), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(333), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3510] = 14,
    ACTIONS(47), 1,
      anon_sym_field,
    ACTIONS(49), 1,
      anon_sym_code,
    ACTIONS(51), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_defvar,
    ACTIONS(55), 1,
      anon_sym_assert,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    ACTIONS(69), 1,
      anon_sym_dump,
    ACTIONS(380), 1,
      anon_sym_RBRACE,
    STATE(601), 1,
      sym_type,
    STATE(54), 2,
      sym_body_item,
      aux_sym_record_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
    STATE(307), 5,
      sym_instruction,
      sym_let_inst,
      sym_def_var,
      sym_assert,
      sym_dump,
  [3564] = 17,
    ACTIONS(86), 1,
      anon_sym_POUND,
    ACTIONS(216), 1,
      sym_identifier,
    ACTIONS(222), 1,
      sym_string_string,
    ACTIONS(228), 1,
      anon_sym_LBRACE,
    ACTIONS(231), 1,
      anon_sym_LBRACK,
    ACTIONS(234), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_BANGcond,
    ACTIONS(240), 1,
      anon_sym_BANG,
    STATE(42), 1,
      sym__value_concat,
    STATE(67), 1,
      aux_sym__repeated_string,
    STATE(217), 1,
      sym_value,
    STATE(518), 1,
      sym_operator_keyword,
    ACTIONS(385), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(49), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(84), 3,
      sym_var,
      anon_sym_COLON,
      anon_sym_RPAREN,
    ACTIONS(382), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3624] = 14,
    ACTIONS(47), 1,
      anon_sym_field,
    ACTIONS(49), 1,
      anon_sym_code,
    ACTIONS(51), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_defvar,
    ACTIONS(55), 1,
      anon_sym_assert,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    ACTIONS(69), 1,
      anon_sym_dump,
    ACTIONS(388), 1,
      anon_sym_RBRACE,
    STATE(601), 1,
      sym_type,
    STATE(57), 2,
      sym_body_item,
      aux_sym_record_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
    STATE(307), 5,
      sym_instruction,
      sym_let_inst,
      sym_def_var,
      sym_assert,
      sym_dump,
  [3678] = 5,
    ACTIONS(394), 1,
      anon_sym_POUND,
    STATE(60), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(390), 8,
      sym_number,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(392), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [3713] = 18,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(397), 1,
      sym_var,
    ACTIONS(399), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(403), 1,
      sym_value,
    STATE(490), 1,
      sym_dag_arg,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3774] = 5,
    ACTIONS(405), 1,
      anon_sym_POUND,
    STATE(60), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(401), 8,
      sym_number,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(403), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [3809] = 18,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(397), 1,
      sym_var,
    ACTIONS(408), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(403), 1,
      sym_value,
    STATE(431), 1,
      sym_dag_arg,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3870] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LBRACE,
    ACTIONS(86), 1,
      anon_sym_POUND,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(392), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(84), 2,
      anon_sym_COLON,
      anon_sym_SEMI,
    ACTIONS(335), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(308), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(333), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3929] = 4,
    STATE(62), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(390), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(392), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [3962] = 5,
    ACTIONS(412), 1,
      sym_string_string,
    STATE(66), 1,
      aux_sym__repeated_string,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(410), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(415), 10,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [3997] = 5,
    ACTIONS(419), 1,
      sym_string_string,
    STATE(66), 1,
      aux_sym__repeated_string,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(417), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(422), 10,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4032] = 4,
    STATE(62), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(424), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(426), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4065] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(428), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(430), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4095] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(432), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(434), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4125] = 4,
    ACTIONS(436), 1,
      anon_sym_LT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(417), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(422), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4157] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(439), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(442), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4187] = 4,
    ACTIONS(445), 1,
      anon_sym_LT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(257), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(253), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4219] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(448), 1,
      anon_sym_COMMA,
    ACTIONS(450), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(383), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4277] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(452), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(454), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4307] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(257), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(253), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4337] = 4,
    ACTIONS(456), 1,
      anon_sym_LT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(428), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(430), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4369] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(459), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(461), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4399] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(424), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(426), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4429] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(463), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(465), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4459] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(397), 1,
      sym_var,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(403), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    STATE(517), 1,
      sym_dag_arg,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4517] = 17,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(397), 1,
      sym_var,
    ACTIONS(467), 1,
      sym_identifier,
    ACTIONS(471), 1,
      sym_string_string,
    ACTIONS(475), 1,
      anon_sym_LBRACE,
    ACTIONS(477), 1,
      anon_sym_LBRACK,
    ACTIONS(479), 1,
      anon_sym_LPAREN,
    ACTIONS(481), 1,
      anon_sym_BANGcond,
    STATE(42), 1,
      sym__value_concat,
    STATE(61), 1,
      sym_dag_arg,
    STATE(67), 1,
      aux_sym__repeated_string,
    STATE(213), 1,
      sym_value,
    STATE(518), 1,
      sym_operator_keyword,
    ACTIONS(473), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(49), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(469), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4575] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(483), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(485), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4605] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(487), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(489), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4635] = 4,
    ACTIONS(491), 1,
      anon_sym_LT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(487), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(489), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4667] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(494), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(496), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4697] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(498), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(500), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4727] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(502), 1,
      anon_sym_COMMA,
    ACTIONS(504), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(396), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4785] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(506), 1,
      anon_sym_COMMA,
    ACTIONS(508), 1,
      anon_sym_RBRACK,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(399), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4843] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(339), 1,
      anon_sym_COLON,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(422), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    STATE(544), 1,
      sym_parent_class_list,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4901] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(510), 1,
      anon_sym_COMMA,
    ACTIONS(512), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(449), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4959] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(514), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(516), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4989] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(518), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(520), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5019] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(502), 1,
      anon_sym_COMMA,
    ACTIONS(504), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(450), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5077] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(522), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(524), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5107] = 4,
    ACTIONS(526), 1,
      anon_sym_LT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(432), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(434), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5139] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(529), 1,
      anon_sym_COMMA,
    ACTIONS(531), 1,
      anon_sym_RBRACK,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(408), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5197] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(533), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(535), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5227] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(537), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(539), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5257] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(541), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(543), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5287] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(510), 1,
      anon_sym_COMMA,
    ACTIONS(512), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(401), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5345] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(545), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(547), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5375] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(549), 1,
      anon_sym_RBRACE,
    ACTIONS(551), 1,
      anon_sym_COMMA,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(386), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5433] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(553), 1,
      anon_sym_COMMA,
    ACTIONS(555), 1,
      anon_sym_RBRACK,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(400), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5491] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(557), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(559), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5521] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(561), 1,
      anon_sym_COMMA,
    ACTIONS(563), 1,
      anon_sym_RBRACK,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(409), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5579] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(565), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(567), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5609] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(569), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(571), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5639] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(573), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(575), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5669] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(577), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(579), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5699] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(581), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(583), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5729] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(585), 1,
      anon_sym_COMMA,
    ACTIONS(587), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(406), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5787] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      anon_sym_COMMA,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(589), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(402), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5845] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(591), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(593), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5875] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(595), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(597), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5905] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(599), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(601), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5935] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(603), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(605), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5965] = 17,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(339), 1,
      anon_sym_COLON,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(418), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    STATE(566), 1,
      sym_parent_class_list,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6023] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(607), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(609), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6053] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(611), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(613), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6083] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(615), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(617), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6113] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(619), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(621), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6143] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(623), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(625), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6173] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(627), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(629), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6203] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(631), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(633), 11,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6233] = 17,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(397), 1,
      sym_var,
    ACTIONS(467), 1,
      sym_identifier,
    ACTIONS(471), 1,
      sym_string_string,
    ACTIONS(475), 1,
      anon_sym_LBRACE,
    ACTIONS(477), 1,
      anon_sym_LBRACK,
    ACTIONS(479), 1,
      anon_sym_LPAREN,
    ACTIONS(481), 1,
      anon_sym_BANGcond,
    STATE(42), 1,
      sym__value_concat,
    STATE(63), 1,
      sym_dag_arg,
    STATE(67), 1,
      aux_sym__repeated_string,
    STATE(213), 1,
      sym_value,
    STATE(518), 1,
      sym_operator_keyword,
    ACTIONS(473), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(49), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(469), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6291] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(531), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(388), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6346] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(635), 1,
      sym_identifier,
    ACTIONS(637), 1,
      anon_sym_GT,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(405), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6401] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(639), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(492), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6456] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(410), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6511] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(643), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(391), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6566] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(645), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(391), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6621] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(647), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(378), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6676] = 10,
    ACTIONS(289), 1,
      anon_sym_POUND,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(652), 1,
      anon_sym_LT,
    ACTIONS(655), 1,
      anon_sym_LBRACK,
    ACTIONS(658), 1,
      anon_sym_DOT,
    STATE(265), 1,
      sym_argument_list,
    ACTIONS(661), 2,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    STATE(138), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(291), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [6719] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(664), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(378), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6774] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(666), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(391), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6829] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(668), 1,
      anon_sym_RBRACK,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(378), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6884] = 10,
    ACTIONS(259), 1,
      anon_sym_POUND,
    ACTIONS(670), 1,
      anon_sym_LBRACE,
    ACTIONS(673), 1,
      anon_sym_LT,
    ACTIONS(676), 1,
      anon_sym_LBRACK,
    ACTIONS(679), 1,
      anon_sym_DOT,
    STATE(265), 1,
      sym_argument_list,
    ACTIONS(682), 2,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    STATE(159), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(261), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [6927] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(685), 1,
      anon_sym_RBRACK,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(378), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6982] = 12,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(158), 1,
      anon_sym_assert,
    ACTIONS(160), 1,
      anon_sym_dump,
    ACTIONS(186), 1,
      anon_sym_let,
    ACTIONS(188), 1,
      anon_sym_foreach,
    ACTIONS(190), 1,
      anon_sym_if,
    ACTIONS(687), 1,
      anon_sym_RBRACE,
    STATE(162), 2,
      sym_multiclass_statement,
      aux_sym_multiclass_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(355), 8,
      sym_def,
      sym_let,
      sym_defm,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [7029] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(689), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(391), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7084] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(399), 1,
      anon_sym_GT,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(397), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7139] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(691), 1,
      anon_sym_RBRACK,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(378), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7194] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(508), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(404), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7249] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(693), 1,
      sym_identifier,
    ACTIONS(695), 1,
      anon_sym_GT,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(407), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7304] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(697), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(391), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7359] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(699), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(492), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7414] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(701), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(391), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7469] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(703), 1,
      anon_sym_RBRACK,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(378), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7524] = 12,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(158), 1,
      anon_sym_assert,
    ACTIONS(160), 1,
      anon_sym_dump,
    ACTIONS(186), 1,
      anon_sym_let,
    ACTIONS(188), 1,
      anon_sym_foreach,
    ACTIONS(190), 1,
      anon_sym_if,
    ACTIONS(705), 1,
      anon_sym_RBRACE,
    STATE(153), 2,
      sym_multiclass_statement,
      aux_sym_multiclass_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(355), 8,
      sym_def,
      sym_let,
      sym_defm,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [7571] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(707), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(378), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7626] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(709), 1,
      anon_sym_RBRACK,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(378), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7681] = 12,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(158), 1,
      anon_sym_assert,
    ACTIONS(160), 1,
      anon_sym_dump,
    ACTIONS(186), 1,
      anon_sym_let,
    ACTIONS(188), 1,
      anon_sym_foreach,
    ACTIONS(190), 1,
      anon_sym_if,
    ACTIONS(711), 1,
      anon_sym_RBRACE,
    STATE(158), 2,
      sym_multiclass_statement,
      aux_sym_multiclass_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(355), 8,
      sym_def,
      sym_let,
      sym_defm,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [7728] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(713), 1,
      anon_sym_RBRACE,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(378), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7783] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(408), 1,
      anon_sym_GT,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(382), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7838] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(715), 1,
      anon_sym_RBRACK,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(378), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7893] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(717), 1,
      anon_sym_RBRACK,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(378), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7948] = 12,
    ACTIONS(719), 1,
      anon_sym_RBRACE,
    ACTIONS(721), 1,
      anon_sym_let,
    ACTIONS(724), 1,
      anon_sym_defvar,
    ACTIONS(727), 1,
      anon_sym_def,
    ACTIONS(730), 1,
      anon_sym_defm,
    ACTIONS(733), 1,
      anon_sym_foreach,
    ACTIONS(736), 1,
      anon_sym_if,
    ACTIONS(739), 1,
      anon_sym_assert,
    ACTIONS(742), 1,
      anon_sym_dump,
    STATE(158), 2,
      sym_multiclass_statement,
      aux_sym_multiclass_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(355), 8,
      sym_def,
      sym_let,
      sym_defm,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [7995] = 10,
    ACTIONS(299), 1,
      anon_sym_POUND,
    ACTIONS(745), 1,
      anon_sym_LBRACE,
    ACTIONS(748), 1,
      anon_sym_LT,
    ACTIONS(751), 1,
      anon_sym_LBRACK,
    ACTIONS(754), 1,
      anon_sym_DOT,
    STATE(265), 1,
      sym_argument_list,
    ACTIONS(757), 2,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    STATE(159), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(301), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [8038] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(760), 1,
      anon_sym_GT,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(412), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8093] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(762), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(391), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8148] = 12,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(158), 1,
      anon_sym_assert,
    ACTIONS(160), 1,
      anon_sym_dump,
    ACTIONS(186), 1,
      anon_sym_let,
    ACTIONS(188), 1,
      anon_sym_foreach,
    ACTIONS(190), 1,
      anon_sym_if,
    ACTIONS(764), 1,
      anon_sym_RBRACE,
    STATE(158), 2,
      sym_multiclass_statement,
      aux_sym_multiclass_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(355), 8,
      sym_def,
      sym_let,
      sym_defm,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
      sym_dump,
  [8195] = 10,
    ACTIONS(259), 1,
      anon_sym_POUND,
    ACTIONS(766), 1,
      anon_sym_LBRACE,
    ACTIONS(768), 1,
      anon_sym_LT,
    ACTIONS(770), 1,
      anon_sym_LBRACK,
    ACTIONS(772), 1,
      anon_sym_DOT,
    STATE(265), 1,
      sym_argument_list,
    ACTIONS(774), 2,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    STATE(159), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(261), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [8238] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(776), 1,
      anon_sym_RBRACK,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(378), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8293] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(778), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(391), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8348] = 5,
    ACTIONS(255), 1,
      anon_sym_def,
    ACTIONS(257), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(253), 7,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    ACTIONS(251), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [8381] = 10,
    ACTIONS(289), 1,
      anon_sym_POUND,
    ACTIONS(766), 1,
      anon_sym_LBRACE,
    ACTIONS(768), 1,
      anon_sym_LT,
    ACTIONS(770), 1,
      anon_sym_LBRACK,
    ACTIONS(772), 1,
      anon_sym_DOT,
    STATE(265), 1,
      sym_argument_list,
    ACTIONS(774), 2,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    STATE(163), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(291), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [8424] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(780), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(492), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8479] = 16,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(782), 1,
      anon_sym_RPAREN,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(492), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8534] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(438), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8586] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(414), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8638] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(784), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(427), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8690] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(501), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8742] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(380), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8794] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(476), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8846] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(411), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8898] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(484), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8950] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(424), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9002] = 15,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(467), 1,
      sym_identifier,
    ACTIONS(471), 1,
      sym_string_string,
    ACTIONS(475), 1,
      anon_sym_LBRACE,
    ACTIONS(477), 1,
      anon_sym_LBRACK,
    ACTIONS(479), 1,
      anon_sym_LPAREN,
    ACTIONS(481), 1,
      anon_sym_BANGcond,
    STATE(42), 1,
      sym__value_concat,
    STATE(67), 1,
      aux_sym__repeated_string,
    STATE(68), 1,
      sym_value,
    STATE(518), 1,
      sym_operator_keyword,
    ACTIONS(788), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(51), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(786), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9054] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(492), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9106] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(420), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9158] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(473), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9210] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(413), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9262] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(419), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9314] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(378), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9366] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(462), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9418] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(483), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9470] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(464), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9522] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(429), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9574] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(499), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9626] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(416), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9678] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(391), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9730] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(494), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9782] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(496), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9834] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(393), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9886] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(466), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9938] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(498), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [9990] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(398), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [10042] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(469), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [10094] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(477), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [10146] = 5,
    ACTIONS(790), 1,
      sym_string_string,
    STATE(211), 1,
      aux_sym__repeated_string,
    ACTIONS(417), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(422), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10178] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(500), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [10230] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(471), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [10282] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(445), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [10334] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(458), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [10386] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(434), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [10438] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(457), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [10490] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(425), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [10542] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(220), 1,
      sym_value,
    STATE(264), 1,
      sym__value_concat,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(79), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(134), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(77), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [10594] = 15,
    ACTIONS(37), 1,
      sym_string_string,
    ACTIONS(41), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_BANGcond,
    ACTIONS(71), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      sym_identifier,
    STATE(42), 1,
      sym__value_concat,
    STATE(201), 1,
      aux_sym__repeated_string,
    STATE(453), 1,
      sym_value,
    STATE(516), 1,
      sym_operator_keyword,
    ACTIONS(39), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(167), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(35), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [10646] = 5,
    ACTIONS(792), 1,
      sym_string_string,
    STATE(211), 1,
      aux_sym__repeated_string,
    ACTIONS(410), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(415), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10678] = 5,
    ACTIONS(390), 1,
      anon_sym_DOT,
    ACTIONS(795), 1,
      anon_sym_POUND,
    STATE(212), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(392), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10709] = 6,
    ACTIONS(802), 1,
      anon_sym_COLON,
    ACTIONS(804), 1,
      anon_sym_POUND,
    STATE(216), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(798), 6,
      sym_number,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_BANG,
    ACTIONS(800), 8,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [10742] = 5,
    ACTIONS(401), 1,
      anon_sym_DOT,
    ACTIONS(806), 1,
      anon_sym_POUND,
    STATE(212), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(403), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10773] = 5,
    ACTIONS(809), 1,
      anon_sym_POUND,
    STATE(215), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(390), 6,
      sym_number,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_BANG,
    ACTIONS(392), 9,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [10804] = 5,
    ACTIONS(812), 1,
      anon_sym_POUND,
    STATE(215), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(401), 6,
      sym_number,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_BANG,
    ACTIONS(403), 9,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [10835] = 4,
    STATE(216), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(390), 7,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_BANG,
    ACTIONS(392), 9,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [10864] = 4,
    ACTIONS(815), 1,
      sym_string_string,
    ACTIONS(439), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(442), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10893] = 4,
    STATE(214), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(390), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(392), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10922] = 4,
    STATE(214), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(424), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(426), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10951] = 3,
    ACTIONS(577), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(579), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10977] = 3,
    ACTIONS(533), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(535), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11003] = 3,
    ACTIONS(819), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(817), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11029] = 3,
    ACTIONS(823), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(821), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11055] = 3,
    ACTIONS(257), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(253), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11081] = 3,
    ACTIONS(827), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(825), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11107] = 4,
    ACTIONS(829), 1,
      anon_sym_LT,
    ACTIONS(487), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(489), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11135] = 3,
    ACTIONS(834), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(832), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11161] = 3,
    ACTIONS(255), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(251), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11187] = 3,
    ACTIONS(494), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(496), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11213] = 3,
    ACTIONS(498), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(500), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11239] = 3,
    ACTIONS(838), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(836), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11265] = 3,
    ACTIONS(514), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(516), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11291] = 3,
    ACTIONS(842), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(840), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11317] = 3,
    ACTIONS(846), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(844), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11343] = 3,
    ACTIONS(850), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(848), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11369] = 3,
    ACTIONS(518), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(520), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11395] = 3,
    ACTIONS(854), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(852), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11421] = 3,
    ACTIONS(858), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(856), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11447] = 3,
    ACTIONS(862), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(860), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11473] = 3,
    ACTIONS(428), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(430), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11499] = 3,
    ACTIONS(866), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(864), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11525] = 3,
    ACTIONS(870), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(868), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11551] = 3,
    ACTIONS(874), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(872), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11577] = 4,
    ACTIONS(876), 1,
      anon_sym_LT,
    ACTIONS(417), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(422), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11605] = 4,
    ACTIONS(879), 1,
      anon_sym_LT,
    ACTIONS(428), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(430), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11633] = 3,
    ACTIONS(459), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(461), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11659] = 3,
    ACTIONS(884), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(882), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11685] = 3,
    ACTIONS(888), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(886), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11711] = 3,
    ACTIONS(424), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(426), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11737] = 3,
    ACTIONS(522), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(524), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11763] = 3,
    ACTIONS(463), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(465), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11789] = 3,
    ACTIONS(581), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(583), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11815] = 3,
    ACTIONS(595), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(597), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11841] = 3,
    ACTIONS(892), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(890), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11867] = 3,
    ACTIONS(896), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(894), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11893] = 3,
    ACTIONS(900), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(898), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11919] = 3,
    ACTIONS(904), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(902), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11945] = 3,
    ACTIONS(432), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(434), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11971] = 3,
    ACTIONS(908), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(906), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [11997] = 3,
    ACTIONS(912), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(910), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [12023] = 3,
    ACTIONS(916), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(914), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [12049] = 4,
    ACTIONS(918), 1,
      anon_sym_LT,
    ACTIONS(432), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(434), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12077] = 3,
    ACTIONS(212), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(214), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12103] = 3,
    ACTIONS(452), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(454), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12129] = 3,
    ACTIONS(627), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(629), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12155] = 3,
    ACTIONS(573), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(575), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12181] = 3,
    ACTIONS(607), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(609), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12207] = 3,
    ACTIONS(483), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(485), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12233] = 3,
    ACTIONS(611), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(613), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12259] = 3,
    ACTIONS(537), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(539), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12285] = 3,
    ACTIONS(615), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(617), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12311] = 4,
    ACTIONS(838), 1,
      anon_sym_def,
    ACTIONS(921), 1,
      anon_sym_else,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(836), 14,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_dump,
  [12339] = 3,
    ACTIONS(925), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(923), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [12365] = 3,
    ACTIONS(541), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(543), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12391] = 3,
    ACTIONS(619), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(621), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12417] = 3,
    ACTIONS(545), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(547), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12443] = 3,
    ACTIONS(929), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(927), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [12469] = 3,
    ACTIONS(487), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(489), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12495] = 3,
    ACTIONS(933), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(931), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [12521] = 3,
    ACTIONS(937), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(935), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [12547] = 3,
    ACTIONS(941), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(939), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [12573] = 3,
    ACTIONS(591), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(593), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12599] = 3,
    ACTIONS(623), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(625), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12625] = 3,
    ACTIONS(569), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(571), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12651] = 3,
    ACTIONS(945), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(943), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [12677] = 3,
    ACTIONS(949), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(947), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [12703] = 3,
    ACTIONS(599), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(601), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12729] = 4,
    ACTIONS(951), 1,
      anon_sym_LT,
    ACTIONS(257), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(253), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12757] = 3,
    ACTIONS(565), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(567), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12783] = 3,
    ACTIONS(631), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(633), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12809] = 3,
    ACTIONS(956), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(954), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [12835] = 3,
    ACTIONS(603), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(605), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12861] = 3,
    ACTIONS(557), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(559), 14,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [12887] = 3,
    ACTIONS(960), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(958), 15,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_deftype,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [12913] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(798), 6,
      sym_number,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_BANG,
    ACTIONS(800), 9,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [12938] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(962), 6,
      sym_number,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_BANG,
    ACTIONS(964), 9,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [12963] = 3,
    ACTIONS(968), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(966), 13,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
      anon_sym_dump,
  [12987] = 3,
    ACTIONS(972), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(970), 13,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
      anon_sym_dump,
  [13011] = 3,
    ACTIONS(976), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(974), 13,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
      anon_sym_dump,
  [13035] = 3,
    ACTIONS(980), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(978), 13,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
      anon_sym_dump,
  [13059] = 3,
    ACTIONS(984), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(982), 13,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
      anon_sym_dump,
  [13083] = 3,
    ACTIONS(988), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(986), 13,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
      anon_sym_dump,
  [13107] = 3,
    ACTIONS(992), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(990), 13,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
      anon_sym_dump,
  [13131] = 3,
    ACTIONS(996), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(994), 13,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
      anon_sym_dump,
  [13155] = 3,
    ACTIONS(1000), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(998), 13,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
      anon_sym_dump,
  [13179] = 3,
    ACTIONS(1004), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1002), 13,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
      anon_sym_dump,
  [13203] = 10,
    ACTIONS(289), 1,
      anon_sym_POUND,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(768), 1,
      anon_sym_LT,
    ACTIONS(770), 1,
      anon_sym_LBRACK,
    ACTIONS(772), 1,
      anon_sym_DOT,
    STATE(265), 1,
      sym_argument_list,
    ACTIONS(291), 2,
      anon_sym_COLON,
      anon_sym_SEMI,
    ACTIONS(774), 2,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    STATE(309), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13239] = 10,
    ACTIONS(259), 1,
      anon_sym_POUND,
    ACTIONS(670), 1,
      anon_sym_LBRACE,
    ACTIONS(768), 1,
      anon_sym_LT,
    ACTIONS(770), 1,
      anon_sym_LBRACK,
    ACTIONS(772), 1,
      anon_sym_DOT,
    STATE(265), 1,
      sym_argument_list,
    ACTIONS(261), 2,
      anon_sym_COLON,
      anon_sym_SEMI,
    ACTIONS(774), 2,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    STATE(159), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13275] = 4,
    ACTIONS(1006), 1,
      anon_sym_POUND,
    STATE(310), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(392), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [13298] = 4,
    ACTIONS(390), 1,
      anon_sym_POUND,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(392), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [13321] = 4,
    ACTIONS(1009), 1,
      anon_sym_POUND,
    STATE(310), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(403), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [13344] = 4,
    ACTIONS(838), 1,
      anon_sym_def,
    ACTIONS(1012), 1,
      anon_sym_else,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(836), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_dump,
  [13366] = 5,
    ACTIONS(876), 1,
      anon_sym_LT,
    ACTIONS(1014), 1,
      sym_identifier,
    ACTIONS(417), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(422), 6,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [13390] = 3,
    ACTIONS(838), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(836), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13410] = 5,
    ACTIONS(876), 1,
      anon_sym_LT,
    ACTIONS(1016), 1,
      anon_sym_EQ,
    ACTIONS(417), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(422), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [13434] = 3,
    ACTIONS(834), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(832), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13454] = 3,
    ACTIONS(945), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(943), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13474] = 3,
    ACTIONS(941), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(939), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13494] = 3,
    ACTIONS(937), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(935), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13514] = 3,
    ACTIONS(933), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(931), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13534] = 3,
    ACTIONS(929), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(927), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13554] = 3,
    ACTIONS(888), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(886), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13574] = 3,
    ACTIONS(245), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(243), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13594] = 3,
    ACTIONS(870), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(868), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13614] = 3,
    ACTIONS(866), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(864), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13634] = 3,
    ACTIONS(862), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(860), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13654] = 7,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    ACTIONS(1018), 1,
      anon_sym_GT,
    STATE(443), 1,
      sym_template_arg,
    STATE(588), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [13682] = 3,
    ACTIONS(858), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(856), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13702] = 3,
    ACTIONS(912), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(910), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13722] = 3,
    ACTIONS(956), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(954), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13742] = 3,
    ACTIONS(949), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(947), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13762] = 3,
    ACTIONS(960), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(958), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13782] = 3,
    ACTIONS(916), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(914), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13802] = 3,
    ACTIONS(908), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(906), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13822] = 3,
    ACTIONS(900), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(898), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13842] = 3,
    ACTIONS(896), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(894), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13862] = 5,
    ACTIONS(876), 1,
      anon_sym_LT,
    ACTIONS(1020), 1,
      anon_sym_EQ,
    ACTIONS(417), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(422), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [13886] = 3,
    ACTIONS(884), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(882), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13906] = 5,
    ACTIONS(876), 1,
      anon_sym_LT,
    ACTIONS(1022), 1,
      anon_sym_EQ,
    ACTIONS(417), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(422), 6,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [13930] = 3,
    ACTIONS(874), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(872), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13950] = 3,
    ACTIONS(842), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(840), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13970] = 3,
    ACTIONS(850), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(848), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [13990] = 3,
    ACTIONS(925), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(923), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [14010] = 3,
    ACTIONS(854), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(852), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [14030] = 3,
    ACTIONS(892), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(890), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [14050] = 3,
    ACTIONS(846), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(844), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [14070] = 3,
    ACTIONS(904), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(902), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [14090] = 3,
    ACTIONS(827), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(825), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [14110] = 3,
    ACTIONS(249), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(247), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [14130] = 3,
    ACTIONS(819), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(817), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [14150] = 3,
    ACTIONS(255), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(251), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [14170] = 3,
    ACTIONS(823), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(821), 9,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_dump,
  [14190] = 6,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    ACTIONS(1024), 1,
      anon_sym_code,
    STATE(598), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14215] = 3,
    ACTIONS(1028), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1026), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_dump,
  [14234] = 6,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(527), 1,
      sym_template_arg,
    STATE(588), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14259] = 5,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(552), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14281] = 5,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(532), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14303] = 5,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(578), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14325] = 5,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(562), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14347] = 5,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(530), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14369] = 5,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(546), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14391] = 5,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(541), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14413] = 5,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(604), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14435] = 5,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(599), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14457] = 5,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(589), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14479] = 5,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(533), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14501] = 5,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(591), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14523] = 5,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(597), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14545] = 5,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(581), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14567] = 5,
    ACTIONS(59), 1,
      anon_sym_bits,
    ACTIONS(61), 1,
      anon_sym_list,
    STATE(538), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(57), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [14589] = 8,
    ACTIONS(339), 1,
      anon_sym_COLON,
    ACTIONS(341), 1,
      anon_sym_SEMI,
    ACTIONS(1030), 1,
      anon_sym_LBRACE,
    ACTIONS(1032), 1,
      anon_sym_LT,
    STATE(295), 1,
      sym_record_body,
    STATE(394), 1,
      sym_template_args,
    STATE(505), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14616] = 8,
    ACTIONS(339), 1,
      anon_sym_COLON,
    ACTIONS(341), 1,
      anon_sym_SEMI,
    ACTIONS(1030), 1,
      anon_sym_LBRACE,
    ACTIONS(1034), 1,
      anon_sym_POUND,
    STATE(274), 1,
      sym_record_body,
    STATE(384), 1,
      aux_sym__value_concat_repeat1,
    STATE(474), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14643] = 8,
    ACTIONS(339), 1,
      anon_sym_COLON,
    ACTIONS(378), 1,
      anon_sym_SEMI,
    ACTIONS(1032), 1,
      anon_sym_LT,
    ACTIONS(1036), 1,
      anon_sym_LBRACE,
    STATE(333), 1,
      sym_record_body,
    STATE(389), 1,
      sym_template_args,
    STATE(468), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14670] = 8,
    ACTIONS(339), 1,
      anon_sym_COLON,
    ACTIONS(1032), 1,
      anon_sym_LT,
    ACTIONS(1038), 1,
      anon_sym_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_SEMI,
    STATE(224), 1,
      sym_multiclass_body,
    STATE(387), 1,
      sym_template_args,
    STATE(460), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14697] = 8,
    ACTIONS(339), 1,
      anon_sym_COLON,
    ACTIONS(378), 1,
      anon_sym_SEMI,
    ACTIONS(1034), 1,
      anon_sym_POUND,
    ACTIONS(1036), 1,
      anon_sym_LBRACE,
    STATE(344), 1,
      sym_record_body,
    STATE(384), 1,
      aux_sym__value_concat_repeat1,
    STATE(455), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14724] = 8,
    ACTIONS(339), 1,
      anon_sym_COLON,
    ACTIONS(1032), 1,
      anon_sym_LT,
    ACTIONS(1042), 1,
      anon_sym_LBRACE,
    ACTIONS(1044), 1,
      anon_sym_SEMI,
    STATE(353), 1,
      sym_multiclass_body,
    STATE(395), 1,
      sym_template_args,
    STATE(456), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14751] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1046), 4,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_RBRACK,
  [14769] = 6,
    ACTIONS(768), 1,
      anon_sym_LT,
    ACTIONS(1052), 1,
      anon_sym_COMMA,
    STATE(415), 1,
      sym_argument_list,
    STATE(417), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(1050), 2,
      anon_sym_LBRACE,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14791] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1054), 1,
      anon_sym_COMMA,
    ACTIONS(1056), 1,
      anon_sym_GT,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(495), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14812] = 4,
    ACTIONS(768), 1,
      anon_sym_LT,
    STATE(480), 1,
      sym_argument_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1058), 3,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [14829] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1060), 1,
      anon_sym_COMMA,
    ACTIONS(1062), 1,
      anon_sym_GT,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(506), 1,
      aux_sym__simple_value_repeat2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14850] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1064), 1,
      anon_sym_COMMA,
    ACTIONS(1066), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(493), 1,
      aux_sym__simple_value_repeat2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14871] = 4,
    ACTIONS(1068), 1,
      anon_sym_POUND,
    STATE(390), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(403), 3,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_SEMI,
  [14888] = 4,
    ACTIONS(1071), 1,
      anon_sym_COMMA,
    STATE(385), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1046), 3,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_RBRACK,
  [14905] = 6,
    ACTIONS(399), 1,
      anon_sym_RBRACE,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1074), 1,
      anon_sym_COMMA,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(487), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14926] = 6,
    ACTIONS(339), 1,
      anon_sym_COLON,
    ACTIONS(1038), 1,
      anon_sym_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_SEMI,
    STATE(257), 1,
      sym_multiclass_body,
    STATE(446), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14947] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1076), 1,
      anon_sym_RBRACE,
    ACTIONS(1078), 1,
      anon_sym_COMMA,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(437), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14968] = 6,
    ACTIONS(339), 1,
      anon_sym_COLON,
    ACTIONS(378), 1,
      anon_sym_SEMI,
    ACTIONS(1036), 1,
      anon_sym_LBRACE,
    STATE(347), 1,
      sym_record_body,
    STATE(465), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14989] = 4,
    ACTIONS(1080), 1,
      anon_sym_POUND,
    STATE(390), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(392), 3,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_SEMI,
  [15006] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1083), 3,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_RPAREN,
  [15023] = 4,
    ACTIONS(390), 1,
      anon_sym_POUND,
    STATE(384), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(392), 3,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_SEMI,
  [15040] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1085), 1,
      anon_sym_COMMA,
    ACTIONS(1087), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(497), 1,
      aux_sym_operator_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15061] = 6,
    ACTIONS(339), 1,
      anon_sym_COLON,
    ACTIONS(341), 1,
      anon_sym_SEMI,
    ACTIONS(1030), 1,
      anon_sym_LBRACE,
    STATE(235), 1,
      sym_record_body,
    STATE(440), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15082] = 6,
    ACTIONS(339), 1,
      anon_sym_COLON,
    ACTIONS(1042), 1,
      anon_sym_LBRACE,
    ACTIONS(1044), 1,
      anon_sym_SEMI,
    STATE(336), 1,
      sym_multiclass_body,
    STATE(447), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15103] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1089), 1,
      anon_sym_COMMA,
    ACTIONS(1091), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(513), 1,
      aux_sym__simple_value_repeat2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15124] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1060), 1,
      anon_sym_COMMA,
    ACTIONS(1093), 1,
      anon_sym_GT,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(504), 1,
      aux_sym__simple_value_repeat2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15145] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1095), 1,
      anon_sym_COMMA,
    ACTIONS(1097), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(507), 1,
      aux_sym_operator_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15166] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1099), 1,
      anon_sym_COMMA,
    ACTIONS(1101), 1,
      anon_sym_RBRACK,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(512), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15187] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1103), 1,
      anon_sym_COMMA,
    ACTIONS(1105), 1,
      anon_sym_RBRACK,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(489), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15208] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1107), 1,
      anon_sym_COMMA,
    ACTIONS(1109), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(451), 1,
      aux_sym__simple_value_repeat2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15229] = 6,
    ACTIONS(408), 1,
      anon_sym_RBRACE,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1111), 1,
      anon_sym_COMMA,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(459), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15250] = 5,
    ACTIONS(802), 1,
      anon_sym_COLON,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(800), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15269] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1078), 1,
      anon_sym_COMMA,
    ACTIONS(1101), 1,
      anon_sym_RBRACE,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(509), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15290] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1054), 1,
      anon_sym_COMMA,
    ACTIONS(1113), 1,
      anon_sym_GT,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(510), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15311] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1115), 1,
      anon_sym_COMMA,
    ACTIONS(1117), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(485), 1,
      aux_sym__simple_value_repeat2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15332] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1054), 1,
      anon_sym_COMMA,
    ACTIONS(1119), 1,
      anon_sym_GT,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(439), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15353] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1076), 1,
      anon_sym_RBRACK,
    ACTIONS(1121), 1,
      anon_sym_COMMA,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(448), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15374] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1123), 1,
      anon_sym_COMMA,
    ACTIONS(1125), 1,
      anon_sym_RBRACK,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(432), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15395] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1078), 1,
      anon_sym_COMMA,
    ACTIONS(1127), 1,
      anon_sym_RBRACE,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(502), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15416] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1054), 1,
      anon_sym_COMMA,
    ACTIONS(1129), 1,
      anon_sym_GT,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(503), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15437] = 6,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1078), 1,
      anon_sym_COMMA,
    ACTIONS(1131), 1,
      anon_sym_GT,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(428), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15458] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(1133), 2,
      anon_sym_COMMA,
      anon_sym_in,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15474] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(1135), 2,
      anon_sym_COMMA,
      anon_sym_in,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15490] = 4,
    ACTIONS(1052), 1,
      anon_sym_COMMA,
    STATE(421), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(1137), 2,
      anon_sym_LBRACE,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15506] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(1139), 2,
      anon_sym_COMMA,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15522] = 4,
    ACTIONS(1052), 1,
      anon_sym_COMMA,
    STATE(426), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(1137), 2,
      anon_sym_LBRACE,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15538] = 5,
    ACTIONS(339), 1,
      anon_sym_COLON,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(547), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15556] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(1141), 2,
      anon_sym_COMMA,
      anon_sym_in,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15572] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(1143), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15588] = 4,
    ACTIONS(1052), 1,
      anon_sym_COMMA,
    STATE(426), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(1145), 2,
      anon_sym_LBRACE,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15604] = 5,
    ACTIONS(339), 1,
      anon_sym_COLON,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    STATE(577), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15622] = 4,
    ACTIONS(1147), 1,
      anon_sym_COMMA,
    STATE(423), 1,
      aux_sym__simple_value_repeat2,
    ACTIONS(1150), 2,
      anon_sym_GT,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15638] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(1152), 2,
      anon_sym_COMMA,
      anon_sym_in,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15654] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(1154), 2,
      anon_sym_COMMA,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15670] = 4,
    ACTIONS(1156), 1,
      anon_sym_COMMA,
    STATE(426), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(1058), 2,
      anon_sym_LBRACE,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15686] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(1159), 2,
      anon_sym_COMMA,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15702] = 4,
    ACTIONS(1078), 1,
      anon_sym_COMMA,
    ACTIONS(1161), 1,
      anon_sym_GT,
    STATE(385), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15717] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1163), 1,
      anon_sym_SEMI,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15732] = 4,
    ACTIONS(1165), 1,
      anon_sym_COMMA,
    ACTIONS(1168), 1,
      anon_sym_in,
    STATE(430), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15747] = 4,
    ACTIONS(664), 1,
      anon_sym_RPAREN,
    ACTIONS(1170), 1,
      anon_sym_COMMA,
    STATE(433), 1,
      aux_sym__simple_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15762] = 4,
    ACTIONS(703), 1,
      anon_sym_RBRACK,
    ACTIONS(1172), 1,
      anon_sym_COMMA,
    STATE(385), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15777] = 4,
    ACTIONS(647), 1,
      anon_sym_RPAREN,
    ACTIONS(1170), 1,
      anon_sym_COMMA,
    STATE(482), 1,
      aux_sym__simple_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15792] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1174), 1,
      anon_sym_in,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15807] = 4,
    ACTIONS(1176), 1,
      anon_sym_COMMA,
    ACTIONS(1178), 1,
      anon_sym_in,
    STATE(430), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15822] = 4,
    ACTIONS(1176), 1,
      anon_sym_COMMA,
    ACTIONS(1180), 1,
      anon_sym_in,
    STATE(435), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15837] = 4,
    ACTIONS(685), 1,
      anon_sym_RBRACE,
    ACTIONS(1078), 1,
      anon_sym_COMMA,
    STATE(385), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15852] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1182), 1,
      anon_sym_in,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15867] = 4,
    ACTIONS(1054), 1,
      anon_sym_COMMA,
    ACTIONS(1184), 1,
      anon_sym_GT,
    STATE(486), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15882] = 4,
    ACTIONS(341), 1,
      anon_sym_SEMI,
    ACTIONS(1030), 1,
      anon_sym_LBRACE,
    STATE(287), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15897] = 4,
    ACTIONS(1176), 1,
      anon_sym_COMMA,
    ACTIONS(1186), 1,
      anon_sym_in,
    STATE(430), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15912] = 4,
    ACTIONS(1176), 1,
      anon_sym_COMMA,
    ACTIONS(1188), 1,
      anon_sym_in,
    STATE(441), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15927] = 4,
    ACTIONS(1190), 1,
      anon_sym_COMMA,
    ACTIONS(1192), 1,
      anon_sym_GT,
    STATE(467), 1,
      aux_sym_template_args_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15942] = 2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1194), 3,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_SEMI,
  [15953] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1196), 1,
      anon_sym_in,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15968] = 4,
    ACTIONS(1038), 1,
      anon_sym_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_SEMI,
    STATE(240), 1,
      sym_multiclass_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15983] = 4,
    ACTIONS(1042), 1,
      anon_sym_LBRACE,
    ACTIONS(1044), 1,
      anon_sym_SEMI,
    STATE(327), 1,
      sym_multiclass_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15998] = 4,
    ACTIONS(685), 1,
      anon_sym_RBRACK,
    ACTIONS(1198), 1,
      anon_sym_COMMA,
    STATE(385), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16013] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1200), 1,
      anon_sym_COLON,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16028] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1202), 1,
      anon_sym_COLON,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16043] = 4,
    ACTIONS(1204), 1,
      anon_sym_COMMA,
    ACTIONS(1206), 1,
      anon_sym_RPAREN,
    STATE(423), 1,
      aux_sym__simple_value_repeat2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16058] = 2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1208), 3,
      sym_identifier,
      anon_sym_GT,
      anon_sym_SEMI,
  [16069] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1210), 1,
      anon_sym_COMMA,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16084] = 4,
    ACTIONS(1176), 1,
      anon_sym_COMMA,
    ACTIONS(1212), 1,
      anon_sym_in,
    STATE(511), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16099] = 4,
    ACTIONS(378), 1,
      anon_sym_SEMI,
    ACTIONS(1036), 1,
      anon_sym_LBRACE,
    STATE(339), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16114] = 4,
    ACTIONS(1042), 1,
      anon_sym_LBRACE,
    ACTIONS(1044), 1,
      anon_sym_SEMI,
    STATE(336), 1,
      sym_multiclass_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16129] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1214), 1,
      anon_sym_then,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16144] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1216), 1,
      anon_sym_then,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16159] = 4,
    ACTIONS(664), 1,
      anon_sym_RBRACE,
    ACTIONS(1218), 1,
      anon_sym_COMMA,
    STATE(385), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16174] = 4,
    ACTIONS(1038), 1,
      anon_sym_LBRACE,
    ACTIONS(1040), 1,
      anon_sym_SEMI,
    STATE(257), 1,
      sym_multiclass_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16189] = 2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1220), 3,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_SEMI,
  [16200] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1222), 1,
      anon_sym_SEMI,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16215] = 4,
    ACTIONS(1224), 1,
      anon_sym_COMMA,
    ACTIONS(1227), 1,
      anon_sym_GT,
    STATE(463), 1,
      aux_sym_template_args_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16230] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1229), 1,
      anon_sym_in,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16245] = 4,
    ACTIONS(378), 1,
      anon_sym_SEMI,
    ACTIONS(1036), 1,
      anon_sym_LBRACE,
    STATE(332), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16260] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1231), 1,
      anon_sym_SEMI,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16275] = 4,
    ACTIONS(1190), 1,
      anon_sym_COMMA,
    ACTIONS(1233), 1,
      anon_sym_GT,
    STATE(463), 1,
      aux_sym_template_args_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16290] = 4,
    ACTIONS(378), 1,
      anon_sym_SEMI,
    ACTIONS(1036), 1,
      anon_sym_LBRACE,
    STATE(347), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16305] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1235), 1,
      anon_sym_SEMI,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16320] = 4,
    ACTIONS(378), 1,
      anon_sym_SEMI,
    ACTIONS(1036), 1,
      anon_sym_LBRACE,
    STATE(344), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16335] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1237), 1,
      anon_sym_SEMI,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16350] = 4,
    ACTIONS(1176), 1,
      anon_sym_COMMA,
    ACTIONS(1239), 1,
      anon_sym_in,
    STATE(430), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16365] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1241), 1,
      anon_sym_SEMI,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16380] = 4,
    ACTIONS(341), 1,
      anon_sym_SEMI,
    ACTIONS(1030), 1,
      anon_sym_LBRACE,
    STATE(248), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16395] = 2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1243), 3,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_SEMI,
  [16406] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1245), 1,
      anon_sym_then,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16421] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1247), 1,
      anon_sym_SEMI,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16436] = 4,
    ACTIONS(1176), 1,
      anon_sym_COMMA,
    ACTIONS(1249), 1,
      anon_sym_in,
    STATE(472), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16451] = 4,
    ACTIONS(341), 1,
      anon_sym_SEMI,
    ACTIONS(1030), 1,
      anon_sym_LBRACE,
    STATE(274), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16466] = 2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1251), 3,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [16477] = 3,
    ACTIONS(1255), 1,
      anon_sym_EQ,
    ACTIONS(1253), 2,
      anon_sym_COMMA,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16490] = 4,
    ACTIONS(1257), 1,
      anon_sym_COMMA,
    ACTIONS(1260), 1,
      anon_sym_RPAREN,
    STATE(482), 1,
      aux_sym__simple_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16505] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1262), 1,
      anon_sym_SEMI,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16520] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1264), 1,
      anon_sym_SEMI,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16535] = 4,
    ACTIONS(1266), 1,
      anon_sym_COMMA,
    ACTIONS(1268), 1,
      anon_sym_RPAREN,
    STATE(423), 1,
      aux_sym__simple_value_repeat2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16550] = 4,
    ACTIONS(1270), 1,
      anon_sym_COMMA,
    ACTIONS(1273), 1,
      anon_sym_GT,
    STATE(486), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16565] = 4,
    ACTIONS(707), 1,
      anon_sym_RBRACE,
    ACTIONS(1275), 1,
      anon_sym_COMMA,
    STATE(385), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16580] = 4,
    ACTIONS(1277), 1,
      anon_sym_COMMA,
    ACTIONS(1280), 1,
      anon_sym_RPAREN,
    STATE(488), 1,
      aux_sym_operator_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16595] = 4,
    ACTIONS(709), 1,
      anon_sym_RBRACK,
    ACTIONS(1282), 1,
      anon_sym_COMMA,
    STATE(385), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16610] = 4,
    ACTIONS(707), 1,
      anon_sym_RPAREN,
    ACTIONS(1170), 1,
      anon_sym_COMMA,
    STATE(508), 1,
      aux_sym__simple_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16625] = 2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1014), 3,
      sym_identifier,
      anon_sym_GT,
      anon_sym_SEMI,
  [16636] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_COLON,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16651] = 4,
    ACTIONS(1286), 1,
      anon_sym_COMMA,
    ACTIONS(1288), 1,
      anon_sym_RPAREN,
    STATE(423), 1,
      aux_sym__simple_value_repeat2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16666] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1290), 1,
      anon_sym_SEMI,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16681] = 4,
    ACTIONS(1054), 1,
      anon_sym_COMMA,
    ACTIONS(1292), 1,
      anon_sym_GT,
    STATE(486), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16696] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1294), 1,
      anon_sym_SEMI,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16711] = 4,
    ACTIONS(1296), 1,
      anon_sym_COMMA,
    ACTIONS(1298), 1,
      anon_sym_RPAREN,
    STATE(488), 1,
      aux_sym_operator_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16726] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1300), 1,
      anon_sym_then,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16741] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1302), 1,
      anon_sym_COMMA,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16756] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1304), 1,
      anon_sym_SEMI,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16771] = 4,
    ACTIONS(1048), 1,
      anon_sym_POUND,
    ACTIONS(1306), 1,
      anon_sym_SEMI,
    STATE(312), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16786] = 4,
    ACTIONS(1078), 1,
      anon_sym_COMMA,
    ACTIONS(1308), 1,
      anon_sym_RBRACE,
    STATE(385), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16801] = 4,
    ACTIONS(1054), 1,
      anon_sym_COMMA,
    ACTIONS(1310), 1,
      anon_sym_GT,
    STATE(486), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16816] = 4,
    ACTIONS(1060), 1,
      anon_sym_COMMA,
    ACTIONS(1312), 1,
      anon_sym_GT,
    STATE(423), 1,
      aux_sym__simple_value_repeat2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16831] = 4,
    ACTIONS(341), 1,
      anon_sym_SEMI,
    ACTIONS(1030), 1,
      anon_sym_LBRACE,
    STATE(235), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16846] = 4,
    ACTIONS(1060), 1,
      anon_sym_COMMA,
    ACTIONS(1314), 1,
      anon_sym_GT,
    STATE(423), 1,
      aux_sym__simple_value_repeat2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16861] = 4,
    ACTIONS(1316), 1,
      anon_sym_COMMA,
    ACTIONS(1318), 1,
      anon_sym_RPAREN,
    STATE(488), 1,
      aux_sym_operator_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16876] = 4,
    ACTIONS(713), 1,
      anon_sym_RPAREN,
    ACTIONS(1170), 1,
      anon_sym_COMMA,
    STATE(482), 1,
      aux_sym__simple_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16891] = 4,
    ACTIONS(717), 1,
      anon_sym_RBRACE,
    ACTIONS(1078), 1,
      anon_sym_COMMA,
    STATE(385), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16906] = 4,
    ACTIONS(1054), 1,
      anon_sym_COMMA,
    ACTIONS(1320), 1,
      anon_sym_GT,
    STATE(486), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16921] = 4,
    ACTIONS(1176), 1,
      anon_sym_COMMA,
    ACTIONS(1322), 1,
      anon_sym_in,
    STATE(430), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16936] = 4,
    ACTIONS(717), 1,
      anon_sym_RBRACK,
    ACTIONS(1324), 1,
      anon_sym_COMMA,
    STATE(385), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16951] = 4,
    ACTIONS(1326), 1,
      anon_sym_COMMA,
    ACTIONS(1328), 1,
      anon_sym_RPAREN,
    STATE(423), 1,
      aux_sym__simple_value_repeat2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16966] = 3,
    ACTIONS(1330), 1,
      anon_sym_LBRACE,
    ACTIONS(1332), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16978] = 3,
    ACTIONS(1334), 1,
      anon_sym_EQ,
    ACTIONS(1336), 1,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [16990] = 3,
    ACTIONS(1338), 1,
      anon_sym_LT,
    ACTIONS(1340), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17002] = 2,
    ACTIONS(1260), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17012] = 3,
    ACTIONS(1342), 1,
      anon_sym_LT,
    ACTIONS(1344), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17024] = 2,
    ACTIONS(1346), 2,
      anon_sym_LT,
      anon_sym_LPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17034] = 3,
    ACTIONS(1348), 1,
      anon_sym_EQ,
    ACTIONS(1350), 1,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17046] = 3,
    ACTIONS(1352), 1,
      sym_identifier,
    STATE(442), 1,
      sym_let_item,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17058] = 3,
    ACTIONS(1352), 1,
      sym_identifier,
    STATE(454), 1,
      sym_let_item,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17070] = 3,
    ACTIONS(1352), 1,
      sym_identifier,
    STATE(436), 1,
      sym_let_item,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17082] = 2,
    ACTIONS(1168), 2,
      anon_sym_COMMA,
      anon_sym_in,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17092] = 3,
    ACTIONS(1354), 1,
      anon_sym_LT,
    ACTIONS(1356), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17104] = 3,
    ACTIONS(1352), 1,
      sym_identifier,
    STATE(478), 1,
      sym_let_item,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17116] = 2,
    ACTIONS(1358), 2,
      anon_sym_COMMA,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17126] = 3,
    ACTIONS(1352), 1,
      sym_identifier,
    STATE(524), 1,
      sym_let_item,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17138] = 2,
    ACTIONS(1360), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17147] = 2,
    ACTIONS(1362), 1,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17156] = 2,
    ACTIONS(1364), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17165] = 2,
    ACTIONS(1366), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17174] = 2,
    ACTIONS(1368), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17183] = 2,
    ACTIONS(1370), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17192] = 2,
    ACTIONS(1101), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17201] = 2,
    ACTIONS(1372), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17210] = 2,
    ACTIONS(1374), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17219] = 2,
    ACTIONS(1376), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17228] = 2,
    ACTIONS(1378), 1,
      anon_sym_LT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17237] = 2,
    ACTIONS(1380), 1,
      anon_sym_LT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17246] = 2,
    ACTIONS(1382), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17255] = 2,
    ACTIONS(1384), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17264] = 2,
    ACTIONS(1386), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17273] = 2,
    ACTIONS(1388), 1,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17282] = 2,
    ACTIONS(1125), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17291] = 2,
    ACTIONS(1390), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17300] = 2,
    ACTIONS(1392), 1,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17309] = 2,
    ACTIONS(1394), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17318] = 2,
    ACTIONS(1396), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17327] = 2,
    ACTIONS(1398), 1,
      sym_string_string,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17336] = 2,
    ACTIONS(1400), 1,
      aux_sym_operator_keyword_token1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17345] = 2,
    ACTIONS(647), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17354] = 2,
    ACTIONS(1402), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17363] = 2,
    ACTIONS(1404), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17372] = 2,
    ACTIONS(508), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17381] = 2,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17390] = 2,
    ACTIONS(1105), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17399] = 2,
    ACTIONS(1406), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17408] = 2,
    ACTIONS(1408), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17417] = 2,
    ACTIONS(399), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17426] = 2,
    ACTIONS(1410), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17435] = 2,
    ACTIONS(713), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17444] = 2,
    ACTIONS(1412), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17453] = 2,
    ACTIONS(1414), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17462] = 2,
    ACTIONS(1416), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17471] = 2,
    ACTIONS(1418), 1,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17480] = 2,
    ACTIONS(1420), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17489] = 2,
    ACTIONS(1076), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17498] = 2,
    ACTIONS(1422), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17507] = 2,
    ACTIONS(1424), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17516] = 2,
    ACTIONS(1426), 1,
      sym_string_string,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17525] = 2,
    ACTIONS(1428), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17534] = 2,
    ACTIONS(1430), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17543] = 2,
    ACTIONS(1432), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17552] = 2,
    ACTIONS(1434), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17561] = 2,
    ACTIONS(1436), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17570] = 2,
    ACTIONS(1438), 1,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17579] = 2,
    ACTIONS(1440), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17588] = 2,
    ACTIONS(1442), 1,
      sym_number,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17597] = 2,
    ACTIONS(1444), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17606] = 2,
    ACTIONS(1446), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17615] = 2,
    ACTIONS(1448), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17624] = 2,
    ACTIONS(1450), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17633] = 2,
    ACTIONS(1452), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17642] = 2,
    ACTIONS(1454), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17651] = 2,
    ACTIONS(1456), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17660] = 2,
    ACTIONS(1458), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17669] = 2,
    ACTIONS(1460), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17678] = 2,
    ACTIONS(1462), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17687] = 2,
    ACTIONS(1464), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17696] = 2,
    ACTIONS(1466), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17705] = 2,
    ACTIONS(1468), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17714] = 2,
    ACTIONS(1470), 1,
      sym_var,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17723] = 2,
    ACTIONS(1472), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17732] = 2,
    ACTIONS(1474), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17741] = 2,
    ACTIONS(1476), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17750] = 2,
    ACTIONS(1478), 1,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17759] = 2,
    ACTIONS(1480), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17768] = 2,
    ACTIONS(1482), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17777] = 2,
    ACTIONS(1484), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17786] = 2,
    ACTIONS(1486), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17795] = 2,
    ACTIONS(1488), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17804] = 2,
    ACTIONS(408), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17813] = 2,
    ACTIONS(1490), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17822] = 2,
    ACTIONS(1492), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17831] = 2,
    ACTIONS(1494), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17840] = 2,
    ACTIONS(1496), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17849] = 2,
    ACTIONS(1498), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [17858] = 2,
    ACTIONS(1500), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 102,
  [SMALL_STATE(4)] = 204,
  [SMALL_STATE(5)] = 274,
  [SMALL_STATE(6)] = 342,
  [SMALL_STATE(7)] = 409,
  [SMALL_STATE(8)] = 478,
  [SMALL_STATE(9)] = 545,
  [SMALL_STATE(10)] = 612,
  [SMALL_STATE(11)] = 679,
  [SMALL_STATE(12)] = 748,
  [SMALL_STATE(13)] = 815,
  [SMALL_STATE(14)] = 882,
  [SMALL_STATE(15)] = 949,
  [SMALL_STATE(16)] = 1016,
  [SMALL_STATE(17)] = 1085,
  [SMALL_STATE(18)] = 1154,
  [SMALL_STATE(19)] = 1221,
  [SMALL_STATE(20)] = 1288,
  [SMALL_STATE(21)] = 1357,
  [SMALL_STATE(22)] = 1424,
  [SMALL_STATE(23)] = 1493,
  [SMALL_STATE(24)] = 1560,
  [SMALL_STATE(25)] = 1627,
  [SMALL_STATE(26)] = 1696,
  [SMALL_STATE(27)] = 1765,
  [SMALL_STATE(28)] = 1832,
  [SMALL_STATE(29)] = 1899,
  [SMALL_STATE(30)] = 1966,
  [SMALL_STATE(31)] = 2033,
  [SMALL_STATE(32)] = 2102,
  [SMALL_STATE(33)] = 2171,
  [SMALL_STATE(34)] = 2237,
  [SMALL_STATE(35)] = 2303,
  [SMALL_STATE(36)] = 2369,
  [SMALL_STATE(37)] = 2435,
  [SMALL_STATE(38)] = 2501,
  [SMALL_STATE(39)] = 2567,
  [SMALL_STATE(40)] = 2633,
  [SMALL_STATE(41)] = 2699,
  [SMALL_STATE(42)] = 2765,
  [SMALL_STATE(43)] = 2802,
  [SMALL_STATE(44)] = 2866,
  [SMALL_STATE(45)] = 2901,
  [SMALL_STATE(46)] = 2936,
  [SMALL_STATE(47)] = 2975,
  [SMALL_STATE(48)] = 3024,
  [SMALL_STATE(49)] = 3073,
  [SMALL_STATE(50)] = 3122,
  [SMALL_STATE(51)] = 3171,
  [SMALL_STATE(52)] = 3220,
  [SMALL_STATE(53)] = 3284,
  [SMALL_STATE(54)] = 3338,
  [SMALL_STATE(55)] = 3392,
  [SMALL_STATE(56)] = 3446,
  [SMALL_STATE(57)] = 3510,
  [SMALL_STATE(58)] = 3564,
  [SMALL_STATE(59)] = 3624,
  [SMALL_STATE(60)] = 3678,
  [SMALL_STATE(61)] = 3713,
  [SMALL_STATE(62)] = 3774,
  [SMALL_STATE(63)] = 3809,
  [SMALL_STATE(64)] = 3870,
  [SMALL_STATE(65)] = 3929,
  [SMALL_STATE(66)] = 3962,
  [SMALL_STATE(67)] = 3997,
  [SMALL_STATE(68)] = 4032,
  [SMALL_STATE(69)] = 4065,
  [SMALL_STATE(70)] = 4095,
  [SMALL_STATE(71)] = 4125,
  [SMALL_STATE(72)] = 4157,
  [SMALL_STATE(73)] = 4187,
  [SMALL_STATE(74)] = 4219,
  [SMALL_STATE(75)] = 4277,
  [SMALL_STATE(76)] = 4307,
  [SMALL_STATE(77)] = 4337,
  [SMALL_STATE(78)] = 4369,
  [SMALL_STATE(79)] = 4399,
  [SMALL_STATE(80)] = 4429,
  [SMALL_STATE(81)] = 4459,
  [SMALL_STATE(82)] = 4517,
  [SMALL_STATE(83)] = 4575,
  [SMALL_STATE(84)] = 4605,
  [SMALL_STATE(85)] = 4635,
  [SMALL_STATE(86)] = 4667,
  [SMALL_STATE(87)] = 4697,
  [SMALL_STATE(88)] = 4727,
  [SMALL_STATE(89)] = 4785,
  [SMALL_STATE(90)] = 4843,
  [SMALL_STATE(91)] = 4901,
  [SMALL_STATE(92)] = 4959,
  [SMALL_STATE(93)] = 4989,
  [SMALL_STATE(94)] = 5019,
  [SMALL_STATE(95)] = 5077,
  [SMALL_STATE(96)] = 5107,
  [SMALL_STATE(97)] = 5139,
  [SMALL_STATE(98)] = 5197,
  [SMALL_STATE(99)] = 5227,
  [SMALL_STATE(100)] = 5257,
  [SMALL_STATE(101)] = 5287,
  [SMALL_STATE(102)] = 5345,
  [SMALL_STATE(103)] = 5375,
  [SMALL_STATE(104)] = 5433,
  [SMALL_STATE(105)] = 5491,
  [SMALL_STATE(106)] = 5521,
  [SMALL_STATE(107)] = 5579,
  [SMALL_STATE(108)] = 5609,
  [SMALL_STATE(109)] = 5639,
  [SMALL_STATE(110)] = 5669,
  [SMALL_STATE(111)] = 5699,
  [SMALL_STATE(112)] = 5729,
  [SMALL_STATE(113)] = 5787,
  [SMALL_STATE(114)] = 5845,
  [SMALL_STATE(115)] = 5875,
  [SMALL_STATE(116)] = 5905,
  [SMALL_STATE(117)] = 5935,
  [SMALL_STATE(118)] = 5965,
  [SMALL_STATE(119)] = 6023,
  [SMALL_STATE(120)] = 6053,
  [SMALL_STATE(121)] = 6083,
  [SMALL_STATE(122)] = 6113,
  [SMALL_STATE(123)] = 6143,
  [SMALL_STATE(124)] = 6173,
  [SMALL_STATE(125)] = 6203,
  [SMALL_STATE(126)] = 6233,
  [SMALL_STATE(127)] = 6291,
  [SMALL_STATE(128)] = 6346,
  [SMALL_STATE(129)] = 6401,
  [SMALL_STATE(130)] = 6456,
  [SMALL_STATE(131)] = 6511,
  [SMALL_STATE(132)] = 6566,
  [SMALL_STATE(133)] = 6621,
  [SMALL_STATE(134)] = 6676,
  [SMALL_STATE(135)] = 6719,
  [SMALL_STATE(136)] = 6774,
  [SMALL_STATE(137)] = 6829,
  [SMALL_STATE(138)] = 6884,
  [SMALL_STATE(139)] = 6927,
  [SMALL_STATE(140)] = 6982,
  [SMALL_STATE(141)] = 7029,
  [SMALL_STATE(142)] = 7084,
  [SMALL_STATE(143)] = 7139,
  [SMALL_STATE(144)] = 7194,
  [SMALL_STATE(145)] = 7249,
  [SMALL_STATE(146)] = 7304,
  [SMALL_STATE(147)] = 7359,
  [SMALL_STATE(148)] = 7414,
  [SMALL_STATE(149)] = 7469,
  [SMALL_STATE(150)] = 7524,
  [SMALL_STATE(151)] = 7571,
  [SMALL_STATE(152)] = 7626,
  [SMALL_STATE(153)] = 7681,
  [SMALL_STATE(154)] = 7728,
  [SMALL_STATE(155)] = 7783,
  [SMALL_STATE(156)] = 7838,
  [SMALL_STATE(157)] = 7893,
  [SMALL_STATE(158)] = 7948,
  [SMALL_STATE(159)] = 7995,
  [SMALL_STATE(160)] = 8038,
  [SMALL_STATE(161)] = 8093,
  [SMALL_STATE(162)] = 8148,
  [SMALL_STATE(163)] = 8195,
  [SMALL_STATE(164)] = 8238,
  [SMALL_STATE(165)] = 8293,
  [SMALL_STATE(166)] = 8348,
  [SMALL_STATE(167)] = 8381,
  [SMALL_STATE(168)] = 8424,
  [SMALL_STATE(169)] = 8479,
  [SMALL_STATE(170)] = 8534,
  [SMALL_STATE(171)] = 8586,
  [SMALL_STATE(172)] = 8638,
  [SMALL_STATE(173)] = 8690,
  [SMALL_STATE(174)] = 8742,
  [SMALL_STATE(175)] = 8794,
  [SMALL_STATE(176)] = 8846,
  [SMALL_STATE(177)] = 8898,
  [SMALL_STATE(178)] = 8950,
  [SMALL_STATE(179)] = 9002,
  [SMALL_STATE(180)] = 9054,
  [SMALL_STATE(181)] = 9106,
  [SMALL_STATE(182)] = 9158,
  [SMALL_STATE(183)] = 9210,
  [SMALL_STATE(184)] = 9262,
  [SMALL_STATE(185)] = 9314,
  [SMALL_STATE(186)] = 9366,
  [SMALL_STATE(187)] = 9418,
  [SMALL_STATE(188)] = 9470,
  [SMALL_STATE(189)] = 9522,
  [SMALL_STATE(190)] = 9574,
  [SMALL_STATE(191)] = 9626,
  [SMALL_STATE(192)] = 9678,
  [SMALL_STATE(193)] = 9730,
  [SMALL_STATE(194)] = 9782,
  [SMALL_STATE(195)] = 9834,
  [SMALL_STATE(196)] = 9886,
  [SMALL_STATE(197)] = 9938,
  [SMALL_STATE(198)] = 9990,
  [SMALL_STATE(199)] = 10042,
  [SMALL_STATE(200)] = 10094,
  [SMALL_STATE(201)] = 10146,
  [SMALL_STATE(202)] = 10178,
  [SMALL_STATE(203)] = 10230,
  [SMALL_STATE(204)] = 10282,
  [SMALL_STATE(205)] = 10334,
  [SMALL_STATE(206)] = 10386,
  [SMALL_STATE(207)] = 10438,
  [SMALL_STATE(208)] = 10490,
  [SMALL_STATE(209)] = 10542,
  [SMALL_STATE(210)] = 10594,
  [SMALL_STATE(211)] = 10646,
  [SMALL_STATE(212)] = 10678,
  [SMALL_STATE(213)] = 10709,
  [SMALL_STATE(214)] = 10742,
  [SMALL_STATE(215)] = 10773,
  [SMALL_STATE(216)] = 10804,
  [SMALL_STATE(217)] = 10835,
  [SMALL_STATE(218)] = 10864,
  [SMALL_STATE(219)] = 10893,
  [SMALL_STATE(220)] = 10922,
  [SMALL_STATE(221)] = 10951,
  [SMALL_STATE(222)] = 10977,
  [SMALL_STATE(223)] = 11003,
  [SMALL_STATE(224)] = 11029,
  [SMALL_STATE(225)] = 11055,
  [SMALL_STATE(226)] = 11081,
  [SMALL_STATE(227)] = 11107,
  [SMALL_STATE(228)] = 11135,
  [SMALL_STATE(229)] = 11161,
  [SMALL_STATE(230)] = 11187,
  [SMALL_STATE(231)] = 11213,
  [SMALL_STATE(232)] = 11239,
  [SMALL_STATE(233)] = 11265,
  [SMALL_STATE(234)] = 11291,
  [SMALL_STATE(235)] = 11317,
  [SMALL_STATE(236)] = 11343,
  [SMALL_STATE(237)] = 11369,
  [SMALL_STATE(238)] = 11395,
  [SMALL_STATE(239)] = 11421,
  [SMALL_STATE(240)] = 11447,
  [SMALL_STATE(241)] = 11473,
  [SMALL_STATE(242)] = 11499,
  [SMALL_STATE(243)] = 11525,
  [SMALL_STATE(244)] = 11551,
  [SMALL_STATE(245)] = 11577,
  [SMALL_STATE(246)] = 11605,
  [SMALL_STATE(247)] = 11633,
  [SMALL_STATE(248)] = 11659,
  [SMALL_STATE(249)] = 11685,
  [SMALL_STATE(250)] = 11711,
  [SMALL_STATE(251)] = 11737,
  [SMALL_STATE(252)] = 11763,
  [SMALL_STATE(253)] = 11789,
  [SMALL_STATE(254)] = 11815,
  [SMALL_STATE(255)] = 11841,
  [SMALL_STATE(256)] = 11867,
  [SMALL_STATE(257)] = 11893,
  [SMALL_STATE(258)] = 11919,
  [SMALL_STATE(259)] = 11945,
  [SMALL_STATE(260)] = 11971,
  [SMALL_STATE(261)] = 11997,
  [SMALL_STATE(262)] = 12023,
  [SMALL_STATE(263)] = 12049,
  [SMALL_STATE(264)] = 12077,
  [SMALL_STATE(265)] = 12103,
  [SMALL_STATE(266)] = 12129,
  [SMALL_STATE(267)] = 12155,
  [SMALL_STATE(268)] = 12181,
  [SMALL_STATE(269)] = 12207,
  [SMALL_STATE(270)] = 12233,
  [SMALL_STATE(271)] = 12259,
  [SMALL_STATE(272)] = 12285,
  [SMALL_STATE(273)] = 12311,
  [SMALL_STATE(274)] = 12339,
  [SMALL_STATE(275)] = 12365,
  [SMALL_STATE(276)] = 12391,
  [SMALL_STATE(277)] = 12417,
  [SMALL_STATE(278)] = 12443,
  [SMALL_STATE(279)] = 12469,
  [SMALL_STATE(280)] = 12495,
  [SMALL_STATE(281)] = 12521,
  [SMALL_STATE(282)] = 12547,
  [SMALL_STATE(283)] = 12573,
  [SMALL_STATE(284)] = 12599,
  [SMALL_STATE(285)] = 12625,
  [SMALL_STATE(286)] = 12651,
  [SMALL_STATE(287)] = 12677,
  [SMALL_STATE(288)] = 12703,
  [SMALL_STATE(289)] = 12729,
  [SMALL_STATE(290)] = 12757,
  [SMALL_STATE(291)] = 12783,
  [SMALL_STATE(292)] = 12809,
  [SMALL_STATE(293)] = 12835,
  [SMALL_STATE(294)] = 12861,
  [SMALL_STATE(295)] = 12887,
  [SMALL_STATE(296)] = 12913,
  [SMALL_STATE(297)] = 12938,
  [SMALL_STATE(298)] = 12963,
  [SMALL_STATE(299)] = 12987,
  [SMALL_STATE(300)] = 13011,
  [SMALL_STATE(301)] = 13035,
  [SMALL_STATE(302)] = 13059,
  [SMALL_STATE(303)] = 13083,
  [SMALL_STATE(304)] = 13107,
  [SMALL_STATE(305)] = 13131,
  [SMALL_STATE(306)] = 13155,
  [SMALL_STATE(307)] = 13179,
  [SMALL_STATE(308)] = 13203,
  [SMALL_STATE(309)] = 13239,
  [SMALL_STATE(310)] = 13275,
  [SMALL_STATE(311)] = 13298,
  [SMALL_STATE(312)] = 13321,
  [SMALL_STATE(313)] = 13344,
  [SMALL_STATE(314)] = 13366,
  [SMALL_STATE(315)] = 13390,
  [SMALL_STATE(316)] = 13410,
  [SMALL_STATE(317)] = 13434,
  [SMALL_STATE(318)] = 13454,
  [SMALL_STATE(319)] = 13474,
  [SMALL_STATE(320)] = 13494,
  [SMALL_STATE(321)] = 13514,
  [SMALL_STATE(322)] = 13534,
  [SMALL_STATE(323)] = 13554,
  [SMALL_STATE(324)] = 13574,
  [SMALL_STATE(325)] = 13594,
  [SMALL_STATE(326)] = 13614,
  [SMALL_STATE(327)] = 13634,
  [SMALL_STATE(328)] = 13654,
  [SMALL_STATE(329)] = 13682,
  [SMALL_STATE(330)] = 13702,
  [SMALL_STATE(331)] = 13722,
  [SMALL_STATE(332)] = 13742,
  [SMALL_STATE(333)] = 13762,
  [SMALL_STATE(334)] = 13782,
  [SMALL_STATE(335)] = 13802,
  [SMALL_STATE(336)] = 13822,
  [SMALL_STATE(337)] = 13842,
  [SMALL_STATE(338)] = 13862,
  [SMALL_STATE(339)] = 13886,
  [SMALL_STATE(340)] = 13906,
  [SMALL_STATE(341)] = 13930,
  [SMALL_STATE(342)] = 13950,
  [SMALL_STATE(343)] = 13970,
  [SMALL_STATE(344)] = 13990,
  [SMALL_STATE(345)] = 14010,
  [SMALL_STATE(346)] = 14030,
  [SMALL_STATE(347)] = 14050,
  [SMALL_STATE(348)] = 14070,
  [SMALL_STATE(349)] = 14090,
  [SMALL_STATE(350)] = 14110,
  [SMALL_STATE(351)] = 14130,
  [SMALL_STATE(352)] = 14150,
  [SMALL_STATE(353)] = 14170,
  [SMALL_STATE(354)] = 14190,
  [SMALL_STATE(355)] = 14215,
  [SMALL_STATE(356)] = 14234,
  [SMALL_STATE(357)] = 14259,
  [SMALL_STATE(358)] = 14281,
  [SMALL_STATE(359)] = 14303,
  [SMALL_STATE(360)] = 14325,
  [SMALL_STATE(361)] = 14347,
  [SMALL_STATE(362)] = 14369,
  [SMALL_STATE(363)] = 14391,
  [SMALL_STATE(364)] = 14413,
  [SMALL_STATE(365)] = 14435,
  [SMALL_STATE(366)] = 14457,
  [SMALL_STATE(367)] = 14479,
  [SMALL_STATE(368)] = 14501,
  [SMALL_STATE(369)] = 14523,
  [SMALL_STATE(370)] = 14545,
  [SMALL_STATE(371)] = 14567,
  [SMALL_STATE(372)] = 14589,
  [SMALL_STATE(373)] = 14616,
  [SMALL_STATE(374)] = 14643,
  [SMALL_STATE(375)] = 14670,
  [SMALL_STATE(376)] = 14697,
  [SMALL_STATE(377)] = 14724,
  [SMALL_STATE(378)] = 14751,
  [SMALL_STATE(379)] = 14769,
  [SMALL_STATE(380)] = 14791,
  [SMALL_STATE(381)] = 14812,
  [SMALL_STATE(382)] = 14829,
  [SMALL_STATE(383)] = 14850,
  [SMALL_STATE(384)] = 14871,
  [SMALL_STATE(385)] = 14888,
  [SMALL_STATE(386)] = 14905,
  [SMALL_STATE(387)] = 14926,
  [SMALL_STATE(388)] = 14947,
  [SMALL_STATE(389)] = 14968,
  [SMALL_STATE(390)] = 14989,
  [SMALL_STATE(391)] = 15006,
  [SMALL_STATE(392)] = 15023,
  [SMALL_STATE(393)] = 15040,
  [SMALL_STATE(394)] = 15061,
  [SMALL_STATE(395)] = 15082,
  [SMALL_STATE(396)] = 15103,
  [SMALL_STATE(397)] = 15124,
  [SMALL_STATE(398)] = 15145,
  [SMALL_STATE(399)] = 15166,
  [SMALL_STATE(400)] = 15187,
  [SMALL_STATE(401)] = 15208,
  [SMALL_STATE(402)] = 15229,
  [SMALL_STATE(403)] = 15250,
  [SMALL_STATE(404)] = 15269,
  [SMALL_STATE(405)] = 15290,
  [SMALL_STATE(406)] = 15311,
  [SMALL_STATE(407)] = 15332,
  [SMALL_STATE(408)] = 15353,
  [SMALL_STATE(409)] = 15374,
  [SMALL_STATE(410)] = 15395,
  [SMALL_STATE(411)] = 15416,
  [SMALL_STATE(412)] = 15437,
  [SMALL_STATE(413)] = 15458,
  [SMALL_STATE(414)] = 15474,
  [SMALL_STATE(415)] = 15490,
  [SMALL_STATE(416)] = 15506,
  [SMALL_STATE(417)] = 15522,
  [SMALL_STATE(418)] = 15538,
  [SMALL_STATE(419)] = 15556,
  [SMALL_STATE(420)] = 15572,
  [SMALL_STATE(421)] = 15588,
  [SMALL_STATE(422)] = 15604,
  [SMALL_STATE(423)] = 15622,
  [SMALL_STATE(424)] = 15638,
  [SMALL_STATE(425)] = 15654,
  [SMALL_STATE(426)] = 15670,
  [SMALL_STATE(427)] = 15686,
  [SMALL_STATE(428)] = 15702,
  [SMALL_STATE(429)] = 15717,
  [SMALL_STATE(430)] = 15732,
  [SMALL_STATE(431)] = 15747,
  [SMALL_STATE(432)] = 15762,
  [SMALL_STATE(433)] = 15777,
  [SMALL_STATE(434)] = 15792,
  [SMALL_STATE(435)] = 15807,
  [SMALL_STATE(436)] = 15822,
  [SMALL_STATE(437)] = 15837,
  [SMALL_STATE(438)] = 15852,
  [SMALL_STATE(439)] = 15867,
  [SMALL_STATE(440)] = 15882,
  [SMALL_STATE(441)] = 15897,
  [SMALL_STATE(442)] = 15912,
  [SMALL_STATE(443)] = 15927,
  [SMALL_STATE(444)] = 15942,
  [SMALL_STATE(445)] = 15953,
  [SMALL_STATE(446)] = 15968,
  [SMALL_STATE(447)] = 15983,
  [SMALL_STATE(448)] = 15998,
  [SMALL_STATE(449)] = 16013,
  [SMALL_STATE(450)] = 16028,
  [SMALL_STATE(451)] = 16043,
  [SMALL_STATE(452)] = 16058,
  [SMALL_STATE(453)] = 16069,
  [SMALL_STATE(454)] = 16084,
  [SMALL_STATE(455)] = 16099,
  [SMALL_STATE(456)] = 16114,
  [SMALL_STATE(457)] = 16129,
  [SMALL_STATE(458)] = 16144,
  [SMALL_STATE(459)] = 16159,
  [SMALL_STATE(460)] = 16174,
  [SMALL_STATE(461)] = 16189,
  [SMALL_STATE(462)] = 16200,
  [SMALL_STATE(463)] = 16215,
  [SMALL_STATE(464)] = 16230,
  [SMALL_STATE(465)] = 16245,
  [SMALL_STATE(466)] = 16260,
  [SMALL_STATE(467)] = 16275,
  [SMALL_STATE(468)] = 16290,
  [SMALL_STATE(469)] = 16305,
  [SMALL_STATE(470)] = 16320,
  [SMALL_STATE(471)] = 16335,
  [SMALL_STATE(472)] = 16350,
  [SMALL_STATE(473)] = 16365,
  [SMALL_STATE(474)] = 16380,
  [SMALL_STATE(475)] = 16395,
  [SMALL_STATE(476)] = 16406,
  [SMALL_STATE(477)] = 16421,
  [SMALL_STATE(478)] = 16436,
  [SMALL_STATE(479)] = 16451,
  [SMALL_STATE(480)] = 16466,
  [SMALL_STATE(481)] = 16477,
  [SMALL_STATE(482)] = 16490,
  [SMALL_STATE(483)] = 16505,
  [SMALL_STATE(484)] = 16520,
  [SMALL_STATE(485)] = 16535,
  [SMALL_STATE(486)] = 16550,
  [SMALL_STATE(487)] = 16565,
  [SMALL_STATE(488)] = 16580,
  [SMALL_STATE(489)] = 16595,
  [SMALL_STATE(490)] = 16610,
  [SMALL_STATE(491)] = 16625,
  [SMALL_STATE(492)] = 16636,
  [SMALL_STATE(493)] = 16651,
  [SMALL_STATE(494)] = 16666,
  [SMALL_STATE(495)] = 16681,
  [SMALL_STATE(496)] = 16696,
  [SMALL_STATE(497)] = 16711,
  [SMALL_STATE(498)] = 16726,
  [SMALL_STATE(499)] = 16741,
  [SMALL_STATE(500)] = 16756,
  [SMALL_STATE(501)] = 16771,
  [SMALL_STATE(502)] = 16786,
  [SMALL_STATE(503)] = 16801,
  [SMALL_STATE(504)] = 16816,
  [SMALL_STATE(505)] = 16831,
  [SMALL_STATE(506)] = 16846,
  [SMALL_STATE(507)] = 16861,
  [SMALL_STATE(508)] = 16876,
  [SMALL_STATE(509)] = 16891,
  [SMALL_STATE(510)] = 16906,
  [SMALL_STATE(511)] = 16921,
  [SMALL_STATE(512)] = 16936,
  [SMALL_STATE(513)] = 16951,
  [SMALL_STATE(514)] = 16966,
  [SMALL_STATE(515)] = 16978,
  [SMALL_STATE(516)] = 16990,
  [SMALL_STATE(517)] = 17002,
  [SMALL_STATE(518)] = 17012,
  [SMALL_STATE(519)] = 17024,
  [SMALL_STATE(520)] = 17034,
  [SMALL_STATE(521)] = 17046,
  [SMALL_STATE(522)] = 17058,
  [SMALL_STATE(523)] = 17070,
  [SMALL_STATE(524)] = 17082,
  [SMALL_STATE(525)] = 17092,
  [SMALL_STATE(526)] = 17104,
  [SMALL_STATE(527)] = 17116,
  [SMALL_STATE(528)] = 17126,
  [SMALL_STATE(529)] = 17138,
  [SMALL_STATE(530)] = 17147,
  [SMALL_STATE(531)] = 17156,
  [SMALL_STATE(532)] = 17165,
  [SMALL_STATE(533)] = 17174,
  [SMALL_STATE(534)] = 17183,
  [SMALL_STATE(535)] = 17192,
  [SMALL_STATE(536)] = 17201,
  [SMALL_STATE(537)] = 17210,
  [SMALL_STATE(538)] = 17219,
  [SMALL_STATE(539)] = 17228,
  [SMALL_STATE(540)] = 17237,
  [SMALL_STATE(541)] = 17246,
  [SMALL_STATE(542)] = 17255,
  [SMALL_STATE(543)] = 17264,
  [SMALL_STATE(544)] = 17273,
  [SMALL_STATE(545)] = 17282,
  [SMALL_STATE(546)] = 17291,
  [SMALL_STATE(547)] = 17300,
  [SMALL_STATE(548)] = 17309,
  [SMALL_STATE(549)] = 17318,
  [SMALL_STATE(550)] = 17327,
  [SMALL_STATE(551)] = 17336,
  [SMALL_STATE(552)] = 17345,
  [SMALL_STATE(553)] = 17354,
  [SMALL_STATE(554)] = 17363,
  [SMALL_STATE(555)] = 17372,
  [SMALL_STATE(556)] = 17381,
  [SMALL_STATE(557)] = 17390,
  [SMALL_STATE(558)] = 17399,
  [SMALL_STATE(559)] = 17408,
  [SMALL_STATE(560)] = 17417,
  [SMALL_STATE(561)] = 17426,
  [SMALL_STATE(562)] = 17435,
  [SMALL_STATE(563)] = 17444,
  [SMALL_STATE(564)] = 17453,
  [SMALL_STATE(565)] = 17462,
  [SMALL_STATE(566)] = 17471,
  [SMALL_STATE(567)] = 17480,
  [SMALL_STATE(568)] = 17489,
  [SMALL_STATE(569)] = 17498,
  [SMALL_STATE(570)] = 17507,
  [SMALL_STATE(571)] = 17516,
  [SMALL_STATE(572)] = 17525,
  [SMALL_STATE(573)] = 17534,
  [SMALL_STATE(574)] = 17543,
  [SMALL_STATE(575)] = 17552,
  [SMALL_STATE(576)] = 17561,
  [SMALL_STATE(577)] = 17570,
  [SMALL_STATE(578)] = 17579,
  [SMALL_STATE(579)] = 17588,
  [SMALL_STATE(580)] = 17597,
  [SMALL_STATE(581)] = 17606,
  [SMALL_STATE(582)] = 17615,
  [SMALL_STATE(583)] = 17624,
  [SMALL_STATE(584)] = 17633,
  [SMALL_STATE(585)] = 17642,
  [SMALL_STATE(586)] = 17651,
  [SMALL_STATE(587)] = 17660,
  [SMALL_STATE(588)] = 17669,
  [SMALL_STATE(589)] = 17678,
  [SMALL_STATE(590)] = 17687,
  [SMALL_STATE(591)] = 17696,
  [SMALL_STATE(592)] = 17705,
  [SMALL_STATE(593)] = 17714,
  [SMALL_STATE(594)] = 17723,
  [SMALL_STATE(595)] = 17732,
  [SMALL_STATE(596)] = 17741,
  [SMALL_STATE(597)] = 17750,
  [SMALL_STATE(598)] = 17759,
  [SMALL_STATE(599)] = 17768,
  [SMALL_STATE(600)] = 17777,
  [SMALL_STATE(601)] = 17786,
  [SMALL_STATE(602)] = 17795,
  [SMALL_STATE(603)] = 17804,
  [SMALL_STATE(604)] = 17813,
  [SMALL_STATE(605)] = 17822,
  [SMALL_STATE(606)] = 17831,
  [SMALL_STATE(607)] = 17840,
  [SMALL_STATE(608)] = 17849,
  [SMALL_STATE(609)] = 17858,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(606),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(596),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(584),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(314),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(354),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(601),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(600),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(567),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(190),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(491),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(540),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(539),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(189),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(551),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(245),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [81] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1, 0, 0), SHIFT_REPEAT(113),
  [84] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1, 0, 0),
  [86] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 1, 0, 0),
  [88] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 1, 0, 0), SHIFT_REPEAT(106),
  [91] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0),
  [93] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(550),
  [96] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(606),
  [99] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(522),
  [102] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(596),
  [105] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(52),
  [108] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(595),
  [111] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(90),
  [114] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(367),
  [117] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(587),
  [120] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(584),
  [123] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(197),
  [126] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(190),
  [129] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(189),
  [132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(585),
  [144] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(609),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [180] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 1, 0, 0),
  [182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(605),
  [190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [212] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 1, 0, 0),
  [214] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 1, 0, 0),
  [216] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 1, 0, 0), SHIFT_REPEAT(71),
  [219] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 1, 0, 0), SHIFT_REPEAT(51),
  [222] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1, 0, 0), SHIFT_REPEAT(72),
  [225] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1, 0, 0), SHIFT_REPEAT(51),
  [228] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1, 0, 0), SHIFT_REPEAT(103),
  [231] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 1, 0, 0), SHIFT_REPEAT(104),
  [234] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1, 0, 0), SHIFT_REPEAT(82),
  [237] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1, 0, 0), SHIFT_REPEAT(554),
  [240] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 1, 0, 0), SHIFT_REPEAT(551),
  [243] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assert, 5, 0, 0),
  [245] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assert, 5, 0, 0),
  [247] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dump, 3, 0, 0),
  [249] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dump, 3, 0, 0),
  [251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 2, 0, 0),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 2, 0, 0),
  [255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 2, 0, 0),
  [257] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 2, 0, 0),
  [259] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 2, 0, 2),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 2, 0, 2),
  [263] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 2, 0, 2), SHIFT(144),
  [266] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 2, 0, 2), SHIFT(128),
  [269] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 2, 0, 2), SHIFT(89),
  [272] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 2, 0, 2), SHIFT(555),
  [275] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 2, 0, 2), SHIFT(179),
  [278] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 2, 0, 2), SHIFT(179),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(555),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(179),
  [289] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 1, 0, 2),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 1, 0, 2),
  [293] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 1, 0, 2), SHIFT(144),
  [296] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 1, 0, 2), SHIFT(89),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0),
  [303] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(144),
  [306] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(128),
  [309] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(89),
  [312] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(555),
  [315] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(179),
  [318] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(179),
  [321] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 1, 0, 2), SHIFT(128),
  [324] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 1, 0, 2), SHIFT(555),
  [327] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 1, 0, 2), SHIFT(179),
  [330] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 1, 0, 2), SHIFT(179),
  [333] = {.entry = {.count = 1, .reusable = false}}, SHIFT(308),
  [335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [345] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 0), SHIFT_REPEAT(491),
  [348] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 0),
  [350] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 0), SHIFT_REPEAT(354),
  [353] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 0), SHIFT_REPEAT(601),
  [356] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 0), SHIFT_REPEAT(600),
  [359] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 0), SHIFT_REPEAT(567),
  [362] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 0), SHIFT_REPEAT(190),
  [365] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 0), SHIFT_REPEAT(540),
  [368] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 0), SHIFT_REPEAT(539),
  [371] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2, 0, 0), SHIFT_REPEAT(189),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [382] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 1, 0, 0), SHIFT_REPEAT(49),
  [385] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1, 0, 0), SHIFT_REPEAT(49),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [390] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 2, 0, 0),
  [392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 2, 0, 0),
  [394] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 2, 0, 0), SHIFT_REPEAT(43),
  [397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [401] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__value_concat, 2, 0, 0),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__value_concat, 2, 0, 0),
  [405] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__value_concat, 2, 0, 0), SHIFT(43),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [410] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__repeated_string, 2, 0, 0),
  [412] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__repeated_string, 2, 0, 0), SHIFT_REPEAT(66),
  [415] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__repeated_string, 2, 0, 0),
  [417] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 1, 0, 0),
  [419] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__simple_value, 1, 0, 0), SHIFT(66),
  [422] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 1, 0, 0),
  [424] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_suffix, 2, 0, 0),
  [426] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_suffix, 2, 0, 0),
  [428] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 3, 0, 0),
  [430] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 3, 0, 0),
  [432] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 5, 0, 0),
  [434] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 5, 0, 0),
  [436] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__simple_value, 1, 0, 0), SHIFT(142),
  [439] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__simple_value, 1, 0, 0), REDUCE(aux_sym__repeated_string, 1, 0, 0),
  [442] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__simple_value, 1, 0, 0), REDUCE(aux_sym__repeated_string, 1, 0, 0),
  [445] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__simple_value, 2, 0, 0), SHIFT(360),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [452] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_suffix, 1, 0, 0),
  [454] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_suffix, 1, 0, 0),
  [456] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__simple_value, 3, 0, 0), SHIFT(365),
  [459] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 3, 0, 0),
  [461] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 3, 0, 0),
  [463] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 2, 0, 0),
  [465] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 2, 0, 0),
  [467] = {.entry = {.count = 1, .reusable = false}}, SHIFT(71),
  [469] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [477] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [483] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 4, 0, 9),
  [485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 4, 0, 9),
  [487] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 4, 0, 0),
  [489] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 4, 0, 0),
  [491] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__simple_value, 4, 0, 0), SHIFT(358),
  [494] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 4, 0, 0),
  [496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 4, 0, 0),
  [498] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_suffix, 3, 0, 0),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_suffix, 3, 0, 0),
  [502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(535),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [514] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 3, 0, 7),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 3, 0, 7),
  [518] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 4, 0, 9),
  [520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 4, 0, 9),
  [522] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 5, 0, 13),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 5, 0, 13),
  [526] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__simple_value, 5, 0, 0), SHIFT(371),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [533] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_suffix, 4, 0, 0),
  [535] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_suffix, 4, 0, 0),
  [537] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 4, 0, 11),
  [539] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 4, 0, 11),
  [541] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 5, 0, 9),
  [543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 5, 0, 9),
  [545] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 5, 0, 13),
  [547] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 5, 0, 13),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [557] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 6, 0, 0),
  [559] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 6, 0, 0),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [565] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 6, 0, 14),
  [567] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 6, 0, 14),
  [569] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 5, 0, 15),
  [571] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 5, 0, 15),
  [573] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_suffix, 5, 0, 0),
  [575] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_suffix, 5, 0, 0),
  [577] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 6, 0, 0),
  [579] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 6, 0, 0),
  [581] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 6, 0, 13),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 6, 0, 13),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(534),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [591] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 7, 0, 0),
  [593] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 7, 0, 0),
  [595] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 7, 0, 14),
  [597] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 7, 0, 14),
  [599] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 7, 0, 16),
  [601] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 7, 0, 16),
  [603] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 6, 0, 17),
  [605] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 6, 0, 17),
  [607] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 9, 0, 19),
  [609] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 9, 0, 19),
  [611] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 8, 0, 19),
  [613] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 8, 0, 19),
  [615] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 8, 0, 18),
  [617] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 8, 0, 18),
  [619] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 8, 0, 16),
  [621] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 8, 0, 16),
  [623] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 8, 0, 0),
  [625] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 8, 0, 0),
  [627] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 7, 0, 0),
  [629] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 7, 0, 0),
  [631] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 7, 0, 18),
  [633] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 7, 0, 18),
  [635] = {.entry = {.count = 1, .reusable = false}}, SHIFT(316),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [649] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 1, 0, 2), SHIFT(127),
  [652] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 1, 0, 2), SHIFT(145),
  [655] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 1, 0, 2), SHIFT(97),
  [658] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 1, 0, 2), SHIFT(556),
  [661] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 1, 0, 2), SHIFT(209),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [670] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 2, 0, 2), SHIFT(127),
  [673] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 2, 0, 2), SHIFT(145),
  [676] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 2, 0, 2), SHIFT(97),
  [679] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 2, 0, 2), SHIFT(556),
  [682] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 2, 0, 2), SHIFT(209),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [693] = {.entry = {.count = 1, .reusable = false}}, SHIFT(338),
  [695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [719] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_multiclass_body_repeat1, 2, 0, 0),
  [721] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multiclass_body_repeat1, 2, 0, 0), SHIFT_REPEAT(526),
  [724] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multiclass_body_repeat1, 2, 0, 0), SHIFT_REPEAT(585),
  [727] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_multiclass_body_repeat1, 2, 0, 0), SHIFT_REPEAT(56),
  [730] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multiclass_body_repeat1, 2, 0, 0), SHIFT_REPEAT(118),
  [733] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multiclass_body_repeat1, 2, 0, 0), SHIFT_REPEAT(605),
  [736] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multiclass_body_repeat1, 2, 0, 0), SHIFT_REPEAT(175),
  [739] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multiclass_body_repeat1, 2, 0, 0), SHIFT_REPEAT(210),
  [742] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multiclass_body_repeat1, 2, 0, 0), SHIFT_REPEAT(186),
  [745] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(127),
  [748] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(145),
  [751] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(97),
  [754] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(556),
  [757] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2, 0, 0), SHIFT_REPEAT(209),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [772] = {.entry = {.count = 1, .reusable = false}}, SHIFT(556),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [784] = {.entry = {.count = 1, .reusable = false}}, SHIFT(340),
  [786] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [792] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__repeated_string, 2, 0, 0), SHIFT_REPEAT(211),
  [795] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 2, 0, 0), SHIFT_REPEAT(4),
  [798] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dag_arg, 1, 0, 0),
  [800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dag_arg, 1, 0, 0),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(593),
  [804] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [806] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__value_concat, 2, 0, 0), SHIFT(4),
  [809] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 2, 0, 0), SHIFT_REPEAT(58),
  [812] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__value_concat, 2, 0, 0), SHIFT(58),
  [815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__repeated_string, 1, 0, 0),
  [817] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiclass_body, 1, 0, 0),
  [819] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiclass_body, 1, 0, 0),
  [821] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiclass, 3, 0, 4),
  [823] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiclass, 3, 0, 4),
  [825] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defm, 3, 0, 0),
  [827] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_defm, 3, 0, 0),
  [829] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__simple_value, 4, 0, 0), SHIFT(364),
  [832] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defset, 7, 0, 0),
  [834] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_defset, 7, 0, 0),
  [836] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if, 4, 0, 0),
  [838] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if, 4, 0, 0),
  [840] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1, 0, 0),
  [842] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1, 0, 0),
  [844] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class, 4, 0, 5),
  [846] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class, 4, 0, 5),
  [848] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include, 2, 0, 0),
  [850] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include, 2, 0, 0),
  [852] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let, 4, 0, 0),
  [854] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let, 4, 0, 0),
  [856] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiclass_body, 3, 0, 0),
  [858] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiclass_body, 3, 0, 0),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiclass, 5, 0, 10),
  [862] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiclass, 5, 0, 10),
  [864] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_deftype, 5, 0, 0),
  [866] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_deftype, 5, 0, 0),
  [868] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement_or_block, 2, 0, 0),
  [870] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement_or_block, 2, 0, 0),
  [872] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 3, 0, 0),
  [874] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 3, 0, 0),
  [876] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__simple_value, 1, 0, 0), SHIFT(155),
  [879] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__simple_value, 3, 0, 0), SHIFT(362),
  [882] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_def, 4, 0, 6),
  [884] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_def, 4, 0, 6),
  [886] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let, 6, 0, 0),
  [888] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let, 6, 0, 0),
  [890] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 1, 0, 0),
  [892] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 1, 0, 0),
  [894] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiclass_body, 2, 0, 0),
  [896] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiclass_body, 2, 0, 0),
  [898] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiclass, 4, 0, 6),
  [900] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiclass, 4, 0, 6),
  [902] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_def, 2, 0, 1),
  [904] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_def, 2, 0, 1),
  [906] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defm, 4, 0, 0),
  [908] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_defm, 4, 0, 0),
  [910] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defvar, 5, 0, 0),
  [912] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_defvar, 5, 0, 0),
  [914] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement_or_block, 1, 0, 0),
  [916] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement_or_block, 1, 0, 0),
  [918] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__simple_value, 5, 0, 0), SHIFT(363),
  [921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [923] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_def, 3, 0, 4),
  [925] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_def, 3, 0, 4),
  [927] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defset, 6, 0, 0),
  [929] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_defset, 6, 0, 0),
  [931] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach, 6, 0, 0),
  [933] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach, 6, 0, 0),
  [935] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement_or_block, 3, 0, 0),
  [937] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement_or_block, 3, 0, 0),
  [939] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if, 6, 0, 0),
  [941] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if, 6, 0, 0),
  [943] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let, 7, 0, 0),
  [945] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let, 7, 0, 0),
  [947] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class, 5, 0, 8),
  [949] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class, 5, 0, 8),
  [951] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__simple_value, 2, 0, 0), SHIFT(357),
  [954] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let, 5, 0, 0),
  [956] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let, 5, 0, 0),
  [958] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class, 3, 0, 3),
  [960] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class, 3, 0, 3),
  [962] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dag_arg, 3, 0, 0),
  [964] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dag_arg, 3, 0, 0),
  [966] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_def_var, 5, 0, 0),
  [968] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_def_var, 5, 0, 0),
  [970] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_inst, 5, 0, 0),
  [972] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_inst, 5, 0, 0),
  [974] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_inst, 7, 0, 0),
  [976] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_inst, 7, 0, 0),
  [978] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instruction, 5, 0, 0),
  [980] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instruction, 5, 0, 0),
  [982] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instruction, 3, 0, 0),
  [984] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instruction, 3, 0, 0),
  [986] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_inst, 8, 0, 0),
  [988] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_inst, 8, 0, 0),
  [990] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instruction, 6, 0, 0),
  [992] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instruction, 6, 0, 0),
  [994] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_inst, 9, 0, 0),
  [996] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_inst, 9, 0, 0),
  [998] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instruction, 4, 0, 0),
  [1000] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instruction, 4, 0, 0),
  [1002] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_body_item, 1, 0, 0),
  [1004] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_body_item, 1, 0, 0),
  [1006] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 2, 0, 0), SHIFT_REPEAT(39),
  [1009] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__value_concat, 2, 0, 0), SHIFT(39),
  [1012] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1014] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 1, 0, 0),
  [1016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [1018] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [1022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [1024] = {.entry = {.count = 1, .reusable = false}}, SHIFT(598),
  [1026] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiclass_statement, 1, 0, 0),
  [1028] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiclass_statement, 1, 0, 0),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [1034] = {.entry = {.count = 1, .reusable = false}}, SHIFT(64),
  [1036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [1046] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_let_inst_repeat1, 2, 0, 0),
  [1048] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [1050] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parent_class_list, 2, 0, 0),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [1058] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parent_class_list_repeat1, 2, 0, 0),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [1066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [1068] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__value_concat, 2, 0, 0), SHIFT(64),
  [1071] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_let_inst_repeat1, 2, 0, 0), SHIFT_REPEAT(185),
  [1074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [1080] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 2, 0, 0), SHIFT_REPEAT(64),
  [1083] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__simple_value_repeat2, 2, 0, 7),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [1093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [1097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [1105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [1107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [1109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [1113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [1115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [1117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [1131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1133] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_item, 3, 0, 0),
  [1135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_item, 7, 0, 0),
  [1137] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parent_class_list, 3, 0, 0),
  [1139] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 4, 0, 15),
  [1141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_item, 5, 0, 0),
  [1143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_operator_repeat1, 4, 0, 15),
  [1145] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parent_class_list, 4, 0, 0),
  [1147] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__simple_value_repeat2, 2, 0, 12), SHIFT_REPEAT(192),
  [1150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__simple_value_repeat2, 2, 0, 12),
  [1152] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_item, 6, 0, 0),
  [1154] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_arg, 4, 0, 0),
  [1156] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parent_class_list_repeat1, 2, 0, 0), SHIFT_REPEAT(569),
  [1159] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 7),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1165] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_let_repeat1, 2, 0, 0), SHIFT_REPEAT(528),
  [1168] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_let_repeat1, 2, 0, 0),
  [1170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [1174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [1176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [1178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [1186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [1192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [1194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_args, 2, 0, 0),
  [1196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [1200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [1202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [1204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [1206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [1208] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 4, 0, 0),
  [1210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [1220] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_args, 4, 0, 11),
  [1222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [1224] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_args_repeat1, 2, 0, 12), SHIFT_REPEAT(356),
  [1227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_template_args_repeat1, 2, 0, 12),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [1235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [1237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1243] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_args, 3, 0, 7),
  [1245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parent_class_list_repeat1, 3, 0, 0),
  [1253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_arg, 2, 0, 0),
  [1255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1257] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__simple_value_repeat1, 2, 0, 0), SHIFT_REPEAT(81),
  [1260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__simple_value_repeat1, 2, 0, 0),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [1270] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 12), SHIFT_REPEAT(172),
  [1273] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 12),
  [1275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1277] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_operator_repeat1, 2, 0, 12), SHIFT_REPEAT(180),
  [1280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_operator_repeat1, 2, 0, 12),
  [1282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [1286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [1290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [1292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [1294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [1296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [1298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [1300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [1304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [1306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [1308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [1310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [1314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [1316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [1326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [1328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [1330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [1332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [1336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [1338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [1340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [1344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_keyword, 2, 0, 0),
  [1348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [1350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [1352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [1354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [1358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_template_args_repeat1, 2, 0, 7),
  [1360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [1362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [1364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [1366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [1370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [1372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [1374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [1376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [1378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [1380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [1382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [1386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [1390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [1392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [1396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [1398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [1400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [1408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [1410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [1412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [1414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [1418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [1420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [1422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [1424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [1426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [1428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [1430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [1432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [1436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [1438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [1440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [1442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [1444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [1446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [1448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [1450] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(570),
  [1454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [1456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [1458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [1460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [1462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [1464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [1466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [1470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [1472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [1474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [1476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [1478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [1480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [1482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [1484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [1486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [1488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [1490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [1492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [1494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(602),
  [1498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [1500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token_multiline_comment = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_multiline_comment] = sym_multiline_comment,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_multiline_comment] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_tablegen_external_scanner_create(void);
void tree_sitter_tablegen_external_scanner_destroy(void *);
bool tree_sitter_tablegen_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_tablegen_external_scanner_serialize(void *, char *);
void tree_sitter_tablegen_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_tablegen(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_tablegen_external_scanner_create,
      tree_sitter_tablegen_external_scanner_destroy,
      tree_sitter_tablegen_external_scanner_scan,
      tree_sitter_tablegen_external_scanner_serialize,
      tree_sitter_tablegen_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
