package data

// Code generated by go-ipld-prime gengo.  DO NOT EDIT.

import (
	ipld "github.com/ipld/go-ipld-prime"
	"github.com/ipld/go-ipld-prime/node/mixins"
	"github.com/ipld/go-ipld-prime/schema"
)

func (n *_BlockSizes) Lookup(idx int64) Int {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return v
}
func (n *_BlockSizes) LookupMaybe(idx int64) MaybeInt {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return &_Int__Maybe{
		m: schema.Maybe_Value,
		v: *v,
	}
}

var _BlockSizes__valueAbsent = _Int__Maybe{m: schema.Maybe_Absent}

func (n BlockSizes) Iterator() *BlockSizes__Itr {
	return &BlockSizes__Itr{n, 0}
}

type BlockSizes__Itr struct {
	n   BlockSizes
	idx int
}

func (itr *BlockSizes__Itr) Next() (idx int64, v Int) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil
	}
	idx = int64(itr.idx)
	v = &itr.n.x[itr.idx]
	itr.idx++
	return
}
func (itr *BlockSizes__Itr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

type _BlockSizes__Maybe struct {
	m schema.Maybe
	v _BlockSizes
}
type MaybeBlockSizes = *_BlockSizes__Maybe

func (m MaybeBlockSizes) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeBlockSizes) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeBlockSizes) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeBlockSizes) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeBlockSizes) Must() BlockSizes {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (BlockSizes)(&_BlockSizes{})
var _ schema.TypedNode = (BlockSizes)(&_BlockSizes{})

func (BlockSizes) Kind() ipld.Kind {
	return ipld.Kind_List
}
func (BlockSizes) LookupByString(string) (ipld.Node, error) {
	return mixins.List{TypeName: "data.BlockSizes"}.LookupByString("")
}
func (n BlockSizes) LookupByNode(k ipld.Node) (ipld.Node, error) {
	idx, err := k.AsInt()
	if err != nil {
		return nil, err
	}
	return n.LookupByIndex(idx)
}
func (n BlockSizes) LookupByIndex(idx int64) (ipld.Node, error) {
	if n.Length() <= idx {
		return nil, ipld.ErrNotExists{Segment: ipld.PathSegmentOfInt(idx)}
	}
	v := &n.x[idx]
	return v, nil
}
func (n BlockSizes) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, ipld.ErrInvalidSegmentForList{TypeName: "data.BlockSizes", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (BlockSizes) MapIterator() ipld.MapIterator {
	return nil
}
func (n BlockSizes) ListIterator() ipld.ListIterator {
	return &_BlockSizes__ListItr{n, 0}
}

type _BlockSizes__ListItr struct {
	n   BlockSizes
	idx int
}

func (itr *_BlockSizes__ListItr) Next() (idx int64, v ipld.Node, _ error) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil, ipld.ErrIteratorOverread{}
	}
	idx = int64(itr.idx)
	x := &itr.n.x[itr.idx]
	v = x
	itr.idx++
	return
}
func (itr *_BlockSizes__ListItr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

func (n BlockSizes) Length() int64 {
	return int64(len(n.x))
}
func (BlockSizes) IsAbsent() bool {
	return false
}
func (BlockSizes) IsNull() bool {
	return false
}
func (BlockSizes) AsBool() (bool, error) {
	return mixins.List{TypeName: "data.BlockSizes"}.AsBool()
}
func (BlockSizes) AsInt() (int64, error) {
	return mixins.List{TypeName: "data.BlockSizes"}.AsInt()
}
func (BlockSizes) AsFloat() (float64, error) {
	return mixins.List{TypeName: "data.BlockSizes"}.AsFloat()
}
func (BlockSizes) AsString() (string, error) {
	return mixins.List{TypeName: "data.BlockSizes"}.AsString()
}
func (BlockSizes) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "data.BlockSizes"}.AsBytes()
}
func (BlockSizes) AsLink() (ipld.Link, error) {
	return mixins.List{TypeName: "data.BlockSizes"}.AsLink()
}
func (BlockSizes) Prototype() ipld.NodePrototype {
	return _BlockSizes__Prototype{}
}

type _BlockSizes__Prototype struct{}

func (_BlockSizes__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _BlockSizes__Builder
	nb.Reset()
	return &nb
}

type _BlockSizes__Builder struct {
	_BlockSizes__Assembler
}

func (nb *_BlockSizes__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_BlockSizes__Builder) Reset() {
	var w _BlockSizes
	var m schema.Maybe
	*nb = _BlockSizes__Builder{_BlockSizes__Assembler{w: &w, m: &m}}
}

type _BlockSizes__Assembler struct {
	w     *_BlockSizes
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _Int__Assembler
}

func (na *_BlockSizes__Assembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_BlockSizes__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "data.BlockSizes"}.BeginMap(0)
}
func (na *_BlockSizes__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_Int, 0, sizeHint)
	}
	return na, nil
}
func (na *_BlockSizes__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "data.BlockSizes"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_BlockSizes__Assembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "data.BlockSizes"}.AssignBool(false)
}
func (_BlockSizes__Assembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "data.BlockSizes"}.AssignInt(0)
}
func (_BlockSizes__Assembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "data.BlockSizes"}.AssignFloat(0)
}
func (_BlockSizes__Assembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "data.BlockSizes"}.AssignString("")
}
func (_BlockSizes__Assembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "data.BlockSizes"}.AssignBytes(nil)
}
func (_BlockSizes__Assembler) AssignLink(ipld.Link) error {
	return mixins.ListAssembler{TypeName: "data.BlockSizes"}.AssignLink(nil)
}
func (na *_BlockSizes__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_BlockSizes); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_List {
		return ipld.ErrWrongKind{TypeName: "data.BlockSizes", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_BlockSizes__Assembler) Prototype() ipld.NodePrototype {
	return _BlockSizes__Prototype{}
}
func (la *_BlockSizes__Assembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_BlockSizes__Assembler) AssembleValue() ipld.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _Int{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_BlockSizes__Assembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_BlockSizes__Assembler) ValuePrototype(_ int64) ipld.NodePrototype {
	return _Int__Prototype{}
}
func (BlockSizes) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n BlockSizes) Representation() ipld.Node {
	return (*_BlockSizes__Repr)(n)
}

type _BlockSizes__Repr _BlockSizes

var _ ipld.Node = &_BlockSizes__Repr{}

func (_BlockSizes__Repr) Kind() ipld.Kind {
	return ipld.Kind_List
}
func (_BlockSizes__Repr) LookupByString(string) (ipld.Node, error) {
	return mixins.List{TypeName: "data.BlockSizes.Repr"}.LookupByString("")
}
func (nr *_BlockSizes__Repr) LookupByNode(k ipld.Node) (ipld.Node, error) {
	v, err := (BlockSizes)(nr).LookupByNode(k)
	if err != nil || v == ipld.Null {
		return v, err
	}
	return v.(Int).Representation(), nil
}
func (nr *_BlockSizes__Repr) LookupByIndex(idx int64) (ipld.Node, error) {
	v, err := (BlockSizes)(nr).LookupByIndex(idx)
	if err != nil || v == ipld.Null {
		return v, err
	}
	return v.(Int).Representation(), nil
}
func (n _BlockSizes__Repr) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, ipld.ErrInvalidSegmentForList{TypeName: "data.BlockSizes.Repr", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (_BlockSizes__Repr) MapIterator() ipld.MapIterator {
	return nil
}
func (nr *_BlockSizes__Repr) ListIterator() ipld.ListIterator {
	return &_BlockSizes__ReprListItr{(BlockSizes)(nr), 0}
}

type _BlockSizes__ReprListItr _BlockSizes__ListItr

func (itr *_BlockSizes__ReprListItr) Next() (idx int64, v ipld.Node, err error) {
	idx, v, err = (*_BlockSizes__ListItr)(itr).Next()
	if err != nil || v == ipld.Null {
		return
	}
	return idx, v.(Int).Representation(), nil
}
func (itr *_BlockSizes__ReprListItr) Done() bool {
	return (*_BlockSizes__ListItr)(itr).Done()
}

func (rn *_BlockSizes__Repr) Length() int64 {
	return int64(len(rn.x))
}
func (_BlockSizes__Repr) IsAbsent() bool {
	return false
}
func (_BlockSizes__Repr) IsNull() bool {
	return false
}
func (_BlockSizes__Repr) AsBool() (bool, error) {
	return mixins.List{TypeName: "data.BlockSizes.Repr"}.AsBool()
}
func (_BlockSizes__Repr) AsInt() (int64, error) {
	return mixins.List{TypeName: "data.BlockSizes.Repr"}.AsInt()
}
func (_BlockSizes__Repr) AsFloat() (float64, error) {
	return mixins.List{TypeName: "data.BlockSizes.Repr"}.AsFloat()
}
func (_BlockSizes__Repr) AsString() (string, error) {
	return mixins.List{TypeName: "data.BlockSizes.Repr"}.AsString()
}
func (_BlockSizes__Repr) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "data.BlockSizes.Repr"}.AsBytes()
}
func (_BlockSizes__Repr) AsLink() (ipld.Link, error) {
	return mixins.List{TypeName: "data.BlockSizes.Repr"}.AsLink()
}
func (_BlockSizes__Repr) Prototype() ipld.NodePrototype {
	return _BlockSizes__ReprPrototype{}
}

type _BlockSizes__ReprPrototype struct{}

func (_BlockSizes__ReprPrototype) NewBuilder() ipld.NodeBuilder {
	var nb _BlockSizes__ReprBuilder
	nb.Reset()
	return &nb
}

type _BlockSizes__ReprBuilder struct {
	_BlockSizes__ReprAssembler
}

func (nb *_BlockSizes__ReprBuilder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_BlockSizes__ReprBuilder) Reset() {
	var w _BlockSizes
	var m schema.Maybe
	*nb = _BlockSizes__ReprBuilder{_BlockSizes__ReprAssembler{w: &w, m: &m}}
}

type _BlockSizes__ReprAssembler struct {
	w     *_BlockSizes
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _Int__ReprAssembler
}

func (na *_BlockSizes__ReprAssembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_BlockSizes__ReprAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "data.BlockSizes.Repr"}.BeginMap(0)
}
func (na *_BlockSizes__ReprAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_Int, 0, sizeHint)
	}
	return na, nil
}
func (na *_BlockSizes__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "data.BlockSizes.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_BlockSizes__ReprAssembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "data.BlockSizes.Repr"}.AssignBool(false)
}
func (_BlockSizes__ReprAssembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "data.BlockSizes.Repr"}.AssignInt(0)
}
func (_BlockSizes__ReprAssembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "data.BlockSizes.Repr"}.AssignFloat(0)
}
func (_BlockSizes__ReprAssembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "data.BlockSizes.Repr"}.AssignString("")
}
func (_BlockSizes__ReprAssembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "data.BlockSizes.Repr"}.AssignBytes(nil)
}
func (_BlockSizes__ReprAssembler) AssignLink(ipld.Link) error {
	return mixins.ListAssembler{TypeName: "data.BlockSizes.Repr"}.AssignLink(nil)
}
func (na *_BlockSizes__ReprAssembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_BlockSizes); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_List {
		return ipld.ErrWrongKind{TypeName: "data.BlockSizes.Repr", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_BlockSizes__ReprAssembler) Prototype() ipld.NodePrototype {
	return _BlockSizes__ReprPrototype{}
}
func (la *_BlockSizes__ReprAssembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_BlockSizes__ReprAssembler) AssembleValue() ipld.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _Int{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_BlockSizes__ReprAssembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_BlockSizes__ReprAssembler) ValuePrototype(_ int64) ipld.NodePrototype {
	return _Int__ReprPrototype{}
}

func (n Bytes) Bytes() []byte {
	return n.x
}
func (_Bytes__Prototype) FromBytes(v []byte) (Bytes, error) {
	n := _Bytes{v}
	return &n, nil
}

type _Bytes__Maybe struct {
	m schema.Maybe
	v _Bytes
}
type MaybeBytes = *_Bytes__Maybe

func (m MaybeBytes) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeBytes) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeBytes) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeBytes) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeBytes) Must() Bytes {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (Bytes)(&_Bytes{})
var _ schema.TypedNode = (Bytes)(&_Bytes{})

func (Bytes) Kind() ipld.Kind {
	return ipld.Kind_Bytes
}
func (Bytes) LookupByString(string) (ipld.Node, error) {
	return mixins.Bytes{TypeName: "data.Bytes"}.LookupByString("")
}
func (Bytes) LookupByNode(ipld.Node) (ipld.Node, error) {
	return mixins.Bytes{TypeName: "data.Bytes"}.LookupByNode(nil)
}
func (Bytes) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Bytes{TypeName: "data.Bytes"}.LookupByIndex(0)
}
func (Bytes) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return mixins.Bytes{TypeName: "data.Bytes"}.LookupBySegment(seg)
}
func (Bytes) MapIterator() ipld.MapIterator {
	return nil
}
func (Bytes) ListIterator() ipld.ListIterator {
	return nil
}
func (Bytes) Length() int64 {
	return -1
}
func (Bytes) IsAbsent() bool {
	return false
}
func (Bytes) IsNull() bool {
	return false
}
func (Bytes) AsBool() (bool, error) {
	return mixins.Bytes{TypeName: "data.Bytes"}.AsBool()
}
func (Bytes) AsInt() (int64, error) {
	return mixins.Bytes{TypeName: "data.Bytes"}.AsInt()
}
func (Bytes) AsFloat() (float64, error) {
	return mixins.Bytes{TypeName: "data.Bytes"}.AsFloat()
}
func (Bytes) AsString() (string, error) {
	return mixins.Bytes{TypeName: "data.Bytes"}.AsString()
}
func (n Bytes) AsBytes() ([]byte, error) {
	return n.x, nil
}
func (Bytes) AsLink() (ipld.Link, error) {
	return mixins.Bytes{TypeName: "data.Bytes"}.AsLink()
}
func (Bytes) Prototype() ipld.NodePrototype {
	return _Bytes__Prototype{}
}

type _Bytes__Prototype struct{}

func (_Bytes__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _Bytes__Builder
	nb.Reset()
	return &nb
}

type _Bytes__Builder struct {
	_Bytes__Assembler
}

func (nb *_Bytes__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Bytes__Builder) Reset() {
	var w _Bytes
	var m schema.Maybe
	*nb = _Bytes__Builder{_Bytes__Assembler{w: &w, m: &m}}
}

type _Bytes__Assembler struct {
	w *_Bytes
	m *schema.Maybe
}

func (na *_Bytes__Assembler) reset() {}
func (_Bytes__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.BytesAssembler{TypeName: "data.Bytes"}.BeginMap(0)
}
func (_Bytes__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.BytesAssembler{TypeName: "data.Bytes"}.BeginList(0)
}
func (na *_Bytes__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.BytesAssembler{TypeName: "data.Bytes"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_Bytes__Assembler) AssignBool(bool) error {
	return mixins.BytesAssembler{TypeName: "data.Bytes"}.AssignBool(false)
}
func (_Bytes__Assembler) AssignInt(int64) error {
	return mixins.BytesAssembler{TypeName: "data.Bytes"}.AssignInt(0)
}
func (_Bytes__Assembler) AssignFloat(float64) error {
	return mixins.BytesAssembler{TypeName: "data.Bytes"}.AssignFloat(0)
}
func (_Bytes__Assembler) AssignString(string) error {
	return mixins.BytesAssembler{TypeName: "data.Bytes"}.AssignString("")
}
func (na *_Bytes__Assembler) AssignBytes(v []byte) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (_Bytes__Assembler) AssignLink(ipld.Link) error {
	return mixins.BytesAssembler{TypeName: "data.Bytes"}.AssignLink(nil)
}
func (na *_Bytes__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Bytes); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsBytes(); err != nil {
		return err
	} else {
		return na.AssignBytes(v2)
	}
}
func (_Bytes__Assembler) Prototype() ipld.NodePrototype {
	return _Bytes__Prototype{}
}
func (Bytes) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Bytes) Representation() ipld.Node {
	return (*_Bytes__Repr)(n)
}

type _Bytes__Repr = _Bytes

var _ ipld.Node = &_Bytes__Repr{}

type _Bytes__ReprPrototype = _Bytes__Prototype
type _Bytes__ReprAssembler = _Bytes__Assembler

func (n Int) Int() int64 {
	return n.x
}
func (_Int__Prototype) FromInt(v int64) (Int, error) {
	n := _Int{v}
	return &n, nil
}

type _Int__Maybe struct {
	m schema.Maybe
	v _Int
}
type MaybeInt = *_Int__Maybe

func (m MaybeInt) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeInt) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeInt) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeInt) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeInt) Must() Int {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (Int)(&_Int{})
var _ schema.TypedNode = (Int)(&_Int{})

func (Int) Kind() ipld.Kind {
	return ipld.Kind_Int
}
func (Int) LookupByString(string) (ipld.Node, error) {
	return mixins.Int{TypeName: "data.Int"}.LookupByString("")
}
func (Int) LookupByNode(ipld.Node) (ipld.Node, error) {
	return mixins.Int{TypeName: "data.Int"}.LookupByNode(nil)
}
func (Int) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Int{TypeName: "data.Int"}.LookupByIndex(0)
}
func (Int) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return mixins.Int{TypeName: "data.Int"}.LookupBySegment(seg)
}
func (Int) MapIterator() ipld.MapIterator {
	return nil
}
func (Int) ListIterator() ipld.ListIterator {
	return nil
}
func (Int) Length() int64 {
	return -1
}
func (Int) IsAbsent() bool {
	return false
}
func (Int) IsNull() bool {
	return false
}
func (Int) AsBool() (bool, error) {
	return mixins.Int{TypeName: "data.Int"}.AsBool()
}
func (n Int) AsInt() (int64, error) {
	return n.x, nil
}
func (Int) AsFloat() (float64, error) {
	return mixins.Int{TypeName: "data.Int"}.AsFloat()
}
func (Int) AsString() (string, error) {
	return mixins.Int{TypeName: "data.Int"}.AsString()
}
func (Int) AsBytes() ([]byte, error) {
	return mixins.Int{TypeName: "data.Int"}.AsBytes()
}
func (Int) AsLink() (ipld.Link, error) {
	return mixins.Int{TypeName: "data.Int"}.AsLink()
}
func (Int) Prototype() ipld.NodePrototype {
	return _Int__Prototype{}
}

type _Int__Prototype struct{}

func (_Int__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _Int__Builder
	nb.Reset()
	return &nb
}

type _Int__Builder struct {
	_Int__Assembler
}

func (nb *_Int__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Int__Builder) Reset() {
	var w _Int
	var m schema.Maybe
	*nb = _Int__Builder{_Int__Assembler{w: &w, m: &m}}
}

type _Int__Assembler struct {
	w *_Int
	m *schema.Maybe
}

func (na *_Int__Assembler) reset() {}
func (_Int__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.IntAssembler{TypeName: "data.Int"}.BeginMap(0)
}
func (_Int__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.IntAssembler{TypeName: "data.Int"}.BeginList(0)
}
func (na *_Int__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.IntAssembler{TypeName: "data.Int"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_Int__Assembler) AssignBool(bool) error {
	return mixins.IntAssembler{TypeName: "data.Int"}.AssignBool(false)
}
func (na *_Int__Assembler) AssignInt(v int64) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (_Int__Assembler) AssignFloat(float64) error {
	return mixins.IntAssembler{TypeName: "data.Int"}.AssignFloat(0)
}
func (_Int__Assembler) AssignString(string) error {
	return mixins.IntAssembler{TypeName: "data.Int"}.AssignString("")
}
func (_Int__Assembler) AssignBytes([]byte) error {
	return mixins.IntAssembler{TypeName: "data.Int"}.AssignBytes(nil)
}
func (_Int__Assembler) AssignLink(ipld.Link) error {
	return mixins.IntAssembler{TypeName: "data.Int"}.AssignLink(nil)
}
func (na *_Int__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Int); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsInt(); err != nil {
		return err
	} else {
		return na.AssignInt(v2)
	}
}
func (_Int__Assembler) Prototype() ipld.NodePrototype {
	return _Int__Prototype{}
}
func (Int) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Int) Representation() ipld.Node {
	return (*_Int__Repr)(n)
}

type _Int__Repr = _Int

var _ ipld.Node = &_Int__Repr{}

type _Int__ReprPrototype = _Int__Prototype
type _Int__ReprAssembler = _Int__Assembler

func (n String) String() string {
	return n.x
}
func (_String__Prototype) fromString(w *_String, v string) error {
	*w = _String{v}
	return nil
}
func (_String__Prototype) FromString(v string) (String, error) {
	n := _String{v}
	return &n, nil
}

type _String__Maybe struct {
	m schema.Maybe
	v _String
}
type MaybeString = *_String__Maybe

func (m MaybeString) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeString) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeString) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeString) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeString) Must() String {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ ipld.Node = (String)(&_String{})
var _ schema.TypedNode = (String)(&_String{})

func (String) Kind() ipld.Kind {
	return ipld.Kind_String
}
func (String) LookupByString(string) (ipld.Node, error) {
	return mixins.String{TypeName: "data.String"}.LookupByString("")
}
func (String) LookupByNode(ipld.Node) (ipld.Node, error) {
	return mixins.String{TypeName: "data.String"}.LookupByNode(nil)
}
func (String) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.String{TypeName: "data.String"}.LookupByIndex(0)
}
func (String) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return mixins.String{TypeName: "data.String"}.LookupBySegment(seg)
}
func (String) MapIterator() ipld.MapIterator {
	return nil
}
func (String) ListIterator() ipld.ListIterator {
	return nil
}
func (String) Length() int64 {
	return -1
}
func (String) IsAbsent() bool {
	return false
}
func (String) IsNull() bool {
	return false
}
func (String) AsBool() (bool, error) {
	return mixins.String{TypeName: "data.String"}.AsBool()
}
func (String) AsInt() (int64, error) {
	return mixins.String{TypeName: "data.String"}.AsInt()
}
func (String) AsFloat() (float64, error) {
	return mixins.String{TypeName: "data.String"}.AsFloat()
}
func (n String) AsString() (string, error) {
	return n.x, nil
}
func (String) AsBytes() ([]byte, error) {
	return mixins.String{TypeName: "data.String"}.AsBytes()
}
func (String) AsLink() (ipld.Link, error) {
	return mixins.String{TypeName: "data.String"}.AsLink()
}
func (String) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}

type _String__Prototype struct{}

func (_String__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _String__Builder
	nb.Reset()
	return &nb
}

type _String__Builder struct {
	_String__Assembler
}

func (nb *_String__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_String__Builder) Reset() {
	var w _String
	var m schema.Maybe
	*nb = _String__Builder{_String__Assembler{w: &w, m: &m}}
}

type _String__Assembler struct {
	w *_String
	m *schema.Maybe
}

func (na *_String__Assembler) reset() {}
func (_String__Assembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "data.String"}.BeginMap(0)
}
func (_String__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "data.String"}.BeginList(0)
}
func (na *_String__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.StringAssembler{TypeName: "data.String"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_String__Assembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "data.String"}.AssignBool(false)
}
func (_String__Assembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "data.String"}.AssignInt(0)
}
func (_String__Assembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "data.String"}.AssignFloat(0)
}
func (na *_String__Assembler) AssignString(v string) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (_String__Assembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "data.String"}.AssignBytes(nil)
}
func (_String__Assembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "data.String"}.AssignLink(nil)
}
func (na *_String__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_String); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return na.AssignString(v2)
	}
}
func (_String__Assembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (String) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n String) Representation() ipld.Node {
	return (*_String__Repr)(n)
}

type _String__Repr = _String

var _ ipld.Node = &_String__Repr{}

type _String__ReprPrototype = _String__Prototype
type _String__ReprAssembler = _String__Assembler

func (n _UnixFSData) FieldDataType() Int {
	return &n.DataType
}
func (n _UnixFSData) FieldData() MaybeBytes {
	return &n.Data
}
func (n _UnixFSData) FieldFileSize() MaybeInt {
	return &n.FileSize
}
func (n _UnixFSData) FieldBlockSizes() BlockSizes {
	return &n.BlockSizes
}
func (n _UnixFSData) FieldHashType() MaybeInt {
	return &n.HashType
}
func (n _UnixFSData) FieldFanout() MaybeInt {
	return &n.Fanout
}
func (n _UnixFSData) FieldMode() MaybeInt {
	return &n.Mode
}
func (n _UnixFSData) FieldMtime() MaybeUnixTime {
	return &n.Mtime
}

type _UnixFSData__Maybe struct {
	m schema.Maybe
	v UnixFSData
}
type MaybeUnixFSData = *_UnixFSData__Maybe

func (m MaybeUnixFSData) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeUnixFSData) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeUnixFSData) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeUnixFSData) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeUnixFSData) Must() UnixFSData {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__UnixFSData_DataType   = _String{"DataType"}
	fieldName__UnixFSData_Data       = _String{"Data"}
	fieldName__UnixFSData_FileSize   = _String{"FileSize"}
	fieldName__UnixFSData_BlockSizes = _String{"BlockSizes"}
	fieldName__UnixFSData_HashType   = _String{"HashType"}
	fieldName__UnixFSData_Fanout     = _String{"Fanout"}
	fieldName__UnixFSData_Mode       = _String{"Mode"}
	fieldName__UnixFSData_Mtime      = _String{"Mtime"}
)
var _ ipld.Node = (UnixFSData)(&_UnixFSData{})
var _ schema.TypedNode = (UnixFSData)(&_UnixFSData{})

func (UnixFSData) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n UnixFSData) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "DataType":
		return &n.DataType, nil
	case "Data":
		if n.Data.m == schema.Maybe_Absent {
			return ipld.Absent, nil
		}
		return &n.Data.v, nil
	case "FileSize":
		if n.FileSize.m == schema.Maybe_Absent {
			return ipld.Absent, nil
		}
		return &n.FileSize.v, nil
	case "BlockSizes":
		return &n.BlockSizes, nil
	case "HashType":
		if n.HashType.m == schema.Maybe_Absent {
			return ipld.Absent, nil
		}
		return &n.HashType.v, nil
	case "Fanout":
		if n.Fanout.m == schema.Maybe_Absent {
			return ipld.Absent, nil
		}
		return &n.Fanout.v, nil
	case "Mode":
		if n.Mode.m == schema.Maybe_Absent {
			return ipld.Absent, nil
		}
		return &n.Mode.v, nil
	case "Mtime":
		if n.Mtime.m == schema.Maybe_Absent {
			return ipld.Absent, nil
		}
		return n.Mtime.v, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n UnixFSData) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (UnixFSData) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "data.UnixFSData"}.LookupByIndex(0)
}
func (n UnixFSData) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n UnixFSData) MapIterator() ipld.MapIterator {
	return &_UnixFSData__MapItr{n, 0}
}

type _UnixFSData__MapItr struct {
	n   UnixFSData
	idx int
}

func (itr *_UnixFSData__MapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
	if itr.idx >= 8 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__UnixFSData_DataType
		v = &itr.n.DataType
	case 1:
		k = &fieldName__UnixFSData_Data
		if itr.n.Data.m == schema.Maybe_Absent {
			v = ipld.Absent
			break
		}
		v = &itr.n.Data.v
	case 2:
		k = &fieldName__UnixFSData_FileSize
		if itr.n.FileSize.m == schema.Maybe_Absent {
			v = ipld.Absent
			break
		}
		v = &itr.n.FileSize.v
	case 3:
		k = &fieldName__UnixFSData_BlockSizes
		v = &itr.n.BlockSizes
	case 4:
		k = &fieldName__UnixFSData_HashType
		if itr.n.HashType.m == schema.Maybe_Absent {
			v = ipld.Absent
			break
		}
		v = &itr.n.HashType.v
	case 5:
		k = &fieldName__UnixFSData_Fanout
		if itr.n.Fanout.m == schema.Maybe_Absent {
			v = ipld.Absent
			break
		}
		v = &itr.n.Fanout.v
	case 6:
		k = &fieldName__UnixFSData_Mode
		if itr.n.Mode.m == schema.Maybe_Absent {
			v = ipld.Absent
			break
		}
		v = &itr.n.Mode.v
	case 7:
		k = &fieldName__UnixFSData_Mtime
		if itr.n.Mtime.m == schema.Maybe_Absent {
			v = ipld.Absent
			break
		}
		v = itr.n.Mtime.v
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_UnixFSData__MapItr) Done() bool {
	return itr.idx >= 8
}

func (UnixFSData) ListIterator() ipld.ListIterator {
	return nil
}
func (UnixFSData) Length() int64 {
	return 8
}
func (UnixFSData) IsAbsent() bool {
	return false
}
func (UnixFSData) IsNull() bool {
	return false
}
func (UnixFSData) AsBool() (bool, error) {
	return mixins.Map{TypeName: "data.UnixFSData"}.AsBool()
}
func (UnixFSData) AsInt() (int64, error) {
	return mixins.Map{TypeName: "data.UnixFSData"}.AsInt()
}
func (UnixFSData) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "data.UnixFSData"}.AsFloat()
}
func (UnixFSData) AsString() (string, error) {
	return mixins.Map{TypeName: "data.UnixFSData"}.AsString()
}
func (UnixFSData) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "data.UnixFSData"}.AsBytes()
}
func (UnixFSData) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "data.UnixFSData"}.AsLink()
}
func (UnixFSData) Prototype() ipld.NodePrototype {
	return _UnixFSData__Prototype{}
}

type _UnixFSData__Prototype struct{}

func (_UnixFSData__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _UnixFSData__Builder
	nb.Reset()
	return &nb
}

type _UnixFSData__Builder struct {
	_UnixFSData__Assembler
}

func (nb *_UnixFSData__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_UnixFSData__Builder) Reset() {
	var w _UnixFSData
	var m schema.Maybe
	*nb = _UnixFSData__Builder{_UnixFSData__Assembler{w: &w, m: &m}}
}

type _UnixFSData__Assembler struct {
	w     *_UnixFSData
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm            schema.Maybe
	ca_DataType   _Int__Assembler
	ca_Data       _Bytes__Assembler
	ca_FileSize   _Int__Assembler
	ca_BlockSizes _BlockSizes__Assembler
	ca_HashType   _Int__Assembler
	ca_Fanout     _Int__Assembler
	ca_Mode       _Int__Assembler
	ca_Mtime      _UnixTime__Assembler
}

func (na *_UnixFSData__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_DataType.reset()
	na.ca_Data.reset()
	na.ca_FileSize.reset()
	na.ca_BlockSizes.reset()
	na.ca_HashType.reset()
	na.ca_Fanout.reset()
	na.ca_Mode.reset()
	na.ca_Mtime.reset()
}

var (
	fieldBit__UnixFSData_DataType    = 1 << 0
	fieldBit__UnixFSData_Data        = 1 << 1
	fieldBit__UnixFSData_FileSize    = 1 << 2
	fieldBit__UnixFSData_BlockSizes  = 1 << 3
	fieldBit__UnixFSData_HashType    = 1 << 4
	fieldBit__UnixFSData_Fanout      = 1 << 5
	fieldBit__UnixFSData_Mode        = 1 << 6
	fieldBit__UnixFSData_Mtime       = 1 << 7
	fieldBits__UnixFSData_sufficient = 0 + 1<<0 + 1<<3
)

func (na *_UnixFSData__Assembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_UnixFSData{}
	}
	return na, nil
}
func (_UnixFSData__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "data.UnixFSData"}.BeginList(0)
}
func (na *_UnixFSData__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "data.UnixFSData"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_UnixFSData__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSData"}.AssignBool(false)
}
func (_UnixFSData__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSData"}.AssignInt(0)
}
func (_UnixFSData__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSData"}.AssignFloat(0)
}
func (_UnixFSData__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSData"}.AssignString("")
}
func (_UnixFSData__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSData"}.AssignBytes(nil)
}
func (_UnixFSData__Assembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSData"}.AssignLink(nil)
}
func (na *_UnixFSData__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_UnixFSData); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "data.UnixFSData", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_UnixFSData__Assembler) Prototype() ipld.NodePrototype {
	return _UnixFSData__Prototype{}
}
func (ma *_UnixFSData__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_DataType.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.Data.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.w.FileSize.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 3:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_BlockSizes.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 4:
		switch ma.w.HashType.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 5:
		switch ma.w.Fanout.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 6:
		switch ma.w.Mode.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 7:
		switch ma.w.Mtime.m {
		case schema.Maybe_Value:
			ma.w.Mtime.v = ma.ca_Mtime.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_UnixFSData__Assembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "DataType":
		if ma.s&fieldBit__UnixFSData_DataType != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_DataType}
		}
		ma.s += fieldBit__UnixFSData_DataType
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_DataType.w = &ma.w.DataType
		ma.ca_DataType.m = &ma.cm
		return &ma.ca_DataType, nil
	case "Data":
		if ma.s&fieldBit__UnixFSData_Data != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Data}
		}
		ma.s += fieldBit__UnixFSData_Data
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_Data.w = &ma.w.Data.v
		ma.ca_Data.m = &ma.w.Data.m
		return &ma.ca_Data, nil
	case "FileSize":
		if ma.s&fieldBit__UnixFSData_FileSize != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_FileSize}
		}
		ma.s += fieldBit__UnixFSData_FileSize
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_FileSize.w = &ma.w.FileSize.v
		ma.ca_FileSize.m = &ma.w.FileSize.m
		return &ma.ca_FileSize, nil
	case "BlockSizes":
		if ma.s&fieldBit__UnixFSData_BlockSizes != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_BlockSizes}
		}
		ma.s += fieldBit__UnixFSData_BlockSizes
		ma.state = maState_midValue
		ma.f = 3
		ma.ca_BlockSizes.w = &ma.w.BlockSizes
		ma.ca_BlockSizes.m = &ma.cm
		return &ma.ca_BlockSizes, nil
	case "HashType":
		if ma.s&fieldBit__UnixFSData_HashType != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_HashType}
		}
		ma.s += fieldBit__UnixFSData_HashType
		ma.state = maState_midValue
		ma.f = 4
		ma.ca_HashType.w = &ma.w.HashType.v
		ma.ca_HashType.m = &ma.w.HashType.m
		return &ma.ca_HashType, nil
	case "Fanout":
		if ma.s&fieldBit__UnixFSData_Fanout != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Fanout}
		}
		ma.s += fieldBit__UnixFSData_Fanout
		ma.state = maState_midValue
		ma.f = 5
		ma.ca_Fanout.w = &ma.w.Fanout.v
		ma.ca_Fanout.m = &ma.w.Fanout.m
		return &ma.ca_Fanout, nil
	case "Mode":
		if ma.s&fieldBit__UnixFSData_Mode != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Mode}
		}
		ma.s += fieldBit__UnixFSData_Mode
		ma.state = maState_midValue
		ma.f = 6
		ma.ca_Mode.w = &ma.w.Mode.v
		ma.ca_Mode.m = &ma.w.Mode.m
		return &ma.ca_Mode, nil
	case "Mtime":
		if ma.s&fieldBit__UnixFSData_Mtime != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Mtime}
		}
		ma.s += fieldBit__UnixFSData_Mtime
		ma.state = maState_midValue
		ma.f = 7
		ma.ca_Mtime.w = ma.w.Mtime.v
		ma.ca_Mtime.m = &ma.w.Mtime.m
		return &ma.ca_Mtime, nil
	}
	return nil, ipld.ErrInvalidKey{TypeName: "data.UnixFSData", Key: &_String{k}}
}
func (ma *_UnixFSData__Assembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_UnixFSData__KeyAssembler)(ma)
}
func (ma *_UnixFSData__Assembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_DataType.w = &ma.w.DataType
		ma.ca_DataType.m = &ma.cm
		return &ma.ca_DataType
	case 1:
		ma.ca_Data.w = &ma.w.Data.v
		ma.ca_Data.m = &ma.w.Data.m
		return &ma.ca_Data
	case 2:
		ma.ca_FileSize.w = &ma.w.FileSize.v
		ma.ca_FileSize.m = &ma.w.FileSize.m
		return &ma.ca_FileSize
	case 3:
		ma.ca_BlockSizes.w = &ma.w.BlockSizes
		ma.ca_BlockSizes.m = &ma.cm
		return &ma.ca_BlockSizes
	case 4:
		ma.ca_HashType.w = &ma.w.HashType.v
		ma.ca_HashType.m = &ma.w.HashType.m
		return &ma.ca_HashType
	case 5:
		ma.ca_Fanout.w = &ma.w.Fanout.v
		ma.ca_Fanout.m = &ma.w.Fanout.m
		return &ma.ca_Fanout
	case 6:
		ma.ca_Mode.w = &ma.w.Mode.v
		ma.ca_Mode.m = &ma.w.Mode.m
		return &ma.ca_Mode
	case 7:
		ma.ca_Mtime.w = ma.w.Mtime.v
		ma.ca_Mtime.m = &ma.w.Mtime.m
		return &ma.ca_Mtime
	default:
		panic("unreachable")
	}
}
func (ma *_UnixFSData__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__UnixFSData_sufficient != fieldBits__UnixFSData_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__UnixFSData_DataType == 0 {
			err.Missing = append(err.Missing, "DataType")
		}
		if ma.s&fieldBit__UnixFSData_BlockSizes == 0 {
			err.Missing = append(err.Missing, "BlockSizes")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_UnixFSData__Assembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_UnixFSData__Assembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _UnixFSData__KeyAssembler _UnixFSData__Assembler

func (_UnixFSData__KeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.KeyAssembler"}.BeginMap(0)
}
func (_UnixFSData__KeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.KeyAssembler"}.BeginList(0)
}
func (na *_UnixFSData__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.KeyAssembler"}.AssignNull()
}
func (_UnixFSData__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.KeyAssembler"}.AssignBool(false)
}
func (_UnixFSData__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.KeyAssembler"}.AssignInt(0)
}
func (_UnixFSData__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.KeyAssembler"}.AssignFloat(0)
}
func (ka *_UnixFSData__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "DataType":
		if ka.s&fieldBit__UnixFSData_DataType != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_DataType}
		}
		ka.s += fieldBit__UnixFSData_DataType
		ka.state = maState_expectValue
		ka.f = 0
	case "Data":
		if ka.s&fieldBit__UnixFSData_Data != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Data}
		}
		ka.s += fieldBit__UnixFSData_Data
		ka.state = maState_expectValue
		ka.f = 1
	case "FileSize":
		if ka.s&fieldBit__UnixFSData_FileSize != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_FileSize}
		}
		ka.s += fieldBit__UnixFSData_FileSize
		ka.state = maState_expectValue
		ka.f = 2
	case "BlockSizes":
		if ka.s&fieldBit__UnixFSData_BlockSizes != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_BlockSizes}
		}
		ka.s += fieldBit__UnixFSData_BlockSizes
		ka.state = maState_expectValue
		ka.f = 3
	case "HashType":
		if ka.s&fieldBit__UnixFSData_HashType != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_HashType}
		}
		ka.s += fieldBit__UnixFSData_HashType
		ka.state = maState_expectValue
		ka.f = 4
	case "Fanout":
		if ka.s&fieldBit__UnixFSData_Fanout != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Fanout}
		}
		ka.s += fieldBit__UnixFSData_Fanout
		ka.state = maState_expectValue
		ka.f = 5
	case "Mode":
		if ka.s&fieldBit__UnixFSData_Mode != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Mode}
		}
		ka.s += fieldBit__UnixFSData_Mode
		ka.state = maState_expectValue
		ka.f = 6
	case "Mtime":
		if ka.s&fieldBit__UnixFSData_Mtime != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Mtime}
		}
		ka.s += fieldBit__UnixFSData_Mtime
		ka.state = maState_expectValue
		ka.f = 7
	default:
		return ipld.ErrInvalidKey{TypeName: "data.UnixFSData", Key: &_String{k}}
	}
	return nil
}
func (_UnixFSData__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.KeyAssembler"}.AssignBytes(nil)
}
func (_UnixFSData__KeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.KeyAssembler"}.AssignLink(nil)
}
func (ka *_UnixFSData__KeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_UnixFSData__KeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (UnixFSData) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n UnixFSData) Representation() ipld.Node {
	return (*_UnixFSData__Repr)(n)
}

type _UnixFSData__Repr _UnixFSData

var (
	fieldName__UnixFSData_DataType_serial   = _String{"DataType"}
	fieldName__UnixFSData_Data_serial       = _String{"Data"}
	fieldName__UnixFSData_FileSize_serial   = _String{"FileSize"}
	fieldName__UnixFSData_BlockSizes_serial = _String{"BlockSizes"}
	fieldName__UnixFSData_HashType_serial   = _String{"HashType"}
	fieldName__UnixFSData_Fanout_serial     = _String{"Fanout"}
	fieldName__UnixFSData_Mode_serial       = _String{"Mode"}
	fieldName__UnixFSData_Mtime_serial      = _String{"Mtime"}
)
var _ ipld.Node = &_UnixFSData__Repr{}

func (_UnixFSData__Repr) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n *_UnixFSData__Repr) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "DataType":
		return n.DataType.Representation(), nil
	case "Data":
		if n.Data.m == schema.Maybe_Absent {
			return ipld.Absent, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(key)}
		}
		return n.Data.v.Representation(), nil
	case "FileSize":
		if n.FileSize.m == schema.Maybe_Absent {
			return ipld.Absent, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(key)}
		}
		return n.FileSize.v.Representation(), nil
	case "BlockSizes":
		return n.BlockSizes.Representation(), nil
	case "HashType":
		if n.HashType.m == schema.Maybe_Absent {
			return ipld.Absent, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(key)}
		}
		return n.HashType.v.Representation(), nil
	case "Fanout":
		if n.Fanout.m == schema.Maybe_Absent {
			return ipld.Absent, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(key)}
		}
		return n.Fanout.v.Representation(), nil
	case "Mode":
		if n.Mode.m == schema.Maybe_Absent {
			return ipld.Absent, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(key)}
		}
		return n.Mode.v.Representation(), nil
	case "Mtime":
		if n.Mtime.m == schema.Maybe_Absent {
			return ipld.Absent, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(key)}
		}
		return n.Mtime.v.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n *_UnixFSData__Repr) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_UnixFSData__Repr) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "data.UnixFSData.Repr"}.LookupByIndex(0)
}
func (n _UnixFSData__Repr) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_UnixFSData__Repr) MapIterator() ipld.MapIterator {
	end := 8
	if n.Mtime.m == schema.Maybe_Absent {
		end = 7
	} else {
		goto done
	}
	if n.Mode.m == schema.Maybe_Absent {
		end = 6
	} else {
		goto done
	}
	if n.Fanout.m == schema.Maybe_Absent {
		end = 5
	} else {
		goto done
	}
	if n.HashType.m == schema.Maybe_Absent {
		end = 4
	} else {
		goto done
	}
done:
	return &_UnixFSData__ReprMapItr{n, 0, end}
}

type _UnixFSData__ReprMapItr struct {
	n   *_UnixFSData__Repr
	idx int
	end int
}

func (itr *_UnixFSData__ReprMapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
advance:
	if itr.idx >= 8 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__UnixFSData_DataType_serial
		v = itr.n.DataType.Representation()
	case 1:
		k = &fieldName__UnixFSData_Data_serial
		if itr.n.Data.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.Data.v.Representation()
	case 2:
		k = &fieldName__UnixFSData_FileSize_serial
		if itr.n.FileSize.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.FileSize.v.Representation()
	case 3:
		k = &fieldName__UnixFSData_BlockSizes_serial
		v = itr.n.BlockSizes.Representation()
	case 4:
		k = &fieldName__UnixFSData_HashType_serial
		if itr.n.HashType.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.HashType.v.Representation()
	case 5:
		k = &fieldName__UnixFSData_Fanout_serial
		if itr.n.Fanout.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.Fanout.v.Representation()
	case 6:
		k = &fieldName__UnixFSData_Mode_serial
		if itr.n.Mode.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.Mode.v.Representation()
	case 7:
		k = &fieldName__UnixFSData_Mtime_serial
		if itr.n.Mtime.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.Mtime.v.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_UnixFSData__ReprMapItr) Done() bool {
	return itr.idx >= itr.end
}
func (_UnixFSData__Repr) ListIterator() ipld.ListIterator {
	return nil
}
func (rn *_UnixFSData__Repr) Length() int64 {
	l := 8
	if rn.Data.m == schema.Maybe_Absent {
		l--
	}
	if rn.FileSize.m == schema.Maybe_Absent {
		l--
	}
	if rn.HashType.m == schema.Maybe_Absent {
		l--
	}
	if rn.Fanout.m == schema.Maybe_Absent {
		l--
	}
	if rn.Mode.m == schema.Maybe_Absent {
		l--
	}
	if rn.Mtime.m == schema.Maybe_Absent {
		l--
	}
	return int64(l)
}
func (_UnixFSData__Repr) IsAbsent() bool {
	return false
}
func (_UnixFSData__Repr) IsNull() bool {
	return false
}
func (_UnixFSData__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "data.UnixFSData.Repr"}.AsBool()
}
func (_UnixFSData__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "data.UnixFSData.Repr"}.AsInt()
}
func (_UnixFSData__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "data.UnixFSData.Repr"}.AsFloat()
}
func (_UnixFSData__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "data.UnixFSData.Repr"}.AsString()
}
func (_UnixFSData__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "data.UnixFSData.Repr"}.AsBytes()
}
func (_UnixFSData__Repr) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "data.UnixFSData.Repr"}.AsLink()
}
func (_UnixFSData__Repr) Prototype() ipld.NodePrototype {
	return _UnixFSData__ReprPrototype{}
}

type _UnixFSData__ReprPrototype struct{}

func (_UnixFSData__ReprPrototype) NewBuilder() ipld.NodeBuilder {
	var nb _UnixFSData__ReprBuilder
	nb.Reset()
	return &nb
}

type _UnixFSData__ReprBuilder struct {
	_UnixFSData__ReprAssembler
}

func (nb *_UnixFSData__ReprBuilder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_UnixFSData__ReprBuilder) Reset() {
	var w _UnixFSData
	var m schema.Maybe
	*nb = _UnixFSData__ReprBuilder{_UnixFSData__ReprAssembler{w: &w, m: &m}}
}

type _UnixFSData__ReprAssembler struct {
	w     *_UnixFSData
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm            schema.Maybe
	ca_DataType   _Int__ReprAssembler
	ca_Data       _Bytes__ReprAssembler
	ca_FileSize   _Int__ReprAssembler
	ca_BlockSizes _BlockSizes__ReprAssembler
	ca_HashType   _Int__ReprAssembler
	ca_Fanout     _Int__ReprAssembler
	ca_Mode       _Int__ReprAssembler
	ca_Mtime      _UnixTime__ReprAssembler
}

func (na *_UnixFSData__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_DataType.reset()
	na.ca_Data.reset()
	na.ca_FileSize.reset()
	na.ca_BlockSizes.reset()
	na.ca_HashType.reset()
	na.ca_Fanout.reset()
	na.ca_Mode.reset()
	na.ca_Mtime.reset()
}
func (na *_UnixFSData__ReprAssembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_UnixFSData{}
	}
	return na, nil
}
func (_UnixFSData__ReprAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "data.UnixFSData.Repr"}.BeginList(0)
}
func (na *_UnixFSData__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "data.UnixFSData.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_UnixFSData__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSData.Repr"}.AssignBool(false)
}
func (_UnixFSData__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSData.Repr"}.AssignInt(0)
}
func (_UnixFSData__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSData.Repr"}.AssignFloat(0)
}
func (_UnixFSData__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSData.Repr"}.AssignString("")
}
func (_UnixFSData__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSData.Repr"}.AssignBytes(nil)
}
func (_UnixFSData__ReprAssembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSData.Repr"}.AssignLink(nil)
}
func (na *_UnixFSData__ReprAssembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_UnixFSData); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "data.UnixFSData.Repr", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_UnixFSData__ReprAssembler) Prototype() ipld.NodePrototype {
	return _UnixFSData__ReprPrototype{}
}
func (ma *_UnixFSData__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.Data.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.w.FileSize.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 3:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 4:
		switch ma.w.HashType.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 5:
		switch ma.w.Fanout.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 6:
		switch ma.w.Mode.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 7:
		switch ma.w.Mtime.m {
		case schema.Maybe_Value:
			ma.w.Mtime.v = ma.ca_Mtime.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_UnixFSData__ReprAssembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "DataType":
		if ma.s&fieldBit__UnixFSData_DataType != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_DataType_serial}
		}
		ma.s += fieldBit__UnixFSData_DataType
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_DataType.w = &ma.w.DataType
		ma.ca_DataType.m = &ma.cm
		return &ma.ca_DataType, nil
	case "Data":
		if ma.s&fieldBit__UnixFSData_Data != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Data_serial}
		}
		ma.s += fieldBit__UnixFSData_Data
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_Data.w = &ma.w.Data.v
		ma.ca_Data.m = &ma.w.Data.m

		return &ma.ca_Data, nil
	case "FileSize":
		if ma.s&fieldBit__UnixFSData_FileSize != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_FileSize_serial}
		}
		ma.s += fieldBit__UnixFSData_FileSize
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_FileSize.w = &ma.w.FileSize.v
		ma.ca_FileSize.m = &ma.w.FileSize.m

		return &ma.ca_FileSize, nil
	case "BlockSizes":
		if ma.s&fieldBit__UnixFSData_BlockSizes != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_BlockSizes_serial}
		}
		ma.s += fieldBit__UnixFSData_BlockSizes
		ma.state = maState_midValue
		ma.f = 3
		ma.ca_BlockSizes.w = &ma.w.BlockSizes
		ma.ca_BlockSizes.m = &ma.cm
		return &ma.ca_BlockSizes, nil
	case "HashType":
		if ma.s&fieldBit__UnixFSData_HashType != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_HashType_serial}
		}
		ma.s += fieldBit__UnixFSData_HashType
		ma.state = maState_midValue
		ma.f = 4
		ma.ca_HashType.w = &ma.w.HashType.v
		ma.ca_HashType.m = &ma.w.HashType.m

		return &ma.ca_HashType, nil
	case "Fanout":
		if ma.s&fieldBit__UnixFSData_Fanout != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Fanout_serial}
		}
		ma.s += fieldBit__UnixFSData_Fanout
		ma.state = maState_midValue
		ma.f = 5
		ma.ca_Fanout.w = &ma.w.Fanout.v
		ma.ca_Fanout.m = &ma.w.Fanout.m

		return &ma.ca_Fanout, nil
	case "Mode":
		if ma.s&fieldBit__UnixFSData_Mode != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Mode_serial}
		}
		ma.s += fieldBit__UnixFSData_Mode
		ma.state = maState_midValue
		ma.f = 6
		ma.ca_Mode.w = &ma.w.Mode.v
		ma.ca_Mode.m = &ma.w.Mode.m

		return &ma.ca_Mode, nil
	case "Mtime":
		if ma.s&fieldBit__UnixFSData_Mtime != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Mtime_serial}
		}
		ma.s += fieldBit__UnixFSData_Mtime
		ma.state = maState_midValue
		ma.f = 7
		ma.ca_Mtime.w = ma.w.Mtime.v
		ma.ca_Mtime.m = &ma.w.Mtime.m

		return &ma.ca_Mtime, nil
	default:
	}
	return nil, ipld.ErrInvalidKey{TypeName: "data.UnixFSData.Repr", Key: &_String{k}}
}
func (ma *_UnixFSData__ReprAssembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_UnixFSData__ReprKeyAssembler)(ma)
}
func (ma *_UnixFSData__ReprAssembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_DataType.w = &ma.w.DataType
		ma.ca_DataType.m = &ma.cm
		return &ma.ca_DataType
	case 1:
		ma.ca_Data.w = &ma.w.Data.v
		ma.ca_Data.m = &ma.w.Data.m

		return &ma.ca_Data
	case 2:
		ma.ca_FileSize.w = &ma.w.FileSize.v
		ma.ca_FileSize.m = &ma.w.FileSize.m

		return &ma.ca_FileSize
	case 3:
		ma.ca_BlockSizes.w = &ma.w.BlockSizes
		ma.ca_BlockSizes.m = &ma.cm
		return &ma.ca_BlockSizes
	case 4:
		ma.ca_HashType.w = &ma.w.HashType.v
		ma.ca_HashType.m = &ma.w.HashType.m

		return &ma.ca_HashType
	case 5:
		ma.ca_Fanout.w = &ma.w.Fanout.v
		ma.ca_Fanout.m = &ma.w.Fanout.m

		return &ma.ca_Fanout
	case 6:
		ma.ca_Mode.w = &ma.w.Mode.v
		ma.ca_Mode.m = &ma.w.Mode.m

		return &ma.ca_Mode
	case 7:
		ma.ca_Mtime.w = ma.w.Mtime.v
		ma.ca_Mtime.m = &ma.w.Mtime.m

		return &ma.ca_Mtime
	default:
		panic("unreachable")
	}
}
func (ma *_UnixFSData__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__UnixFSData_sufficient != fieldBits__UnixFSData_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__UnixFSData_DataType == 0 {
			err.Missing = append(err.Missing, "DataType")
		}
		if ma.s&fieldBit__UnixFSData_BlockSizes == 0 {
			err.Missing = append(err.Missing, "BlockSizes")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_UnixFSData__ReprAssembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_UnixFSData__ReprAssembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _UnixFSData__ReprKeyAssembler _UnixFSData__ReprAssembler

func (_UnixFSData__ReprKeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.Repr.KeyAssembler"}.BeginMap(0)
}
func (_UnixFSData__ReprKeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_UnixFSData__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.Repr.KeyAssembler"}.AssignNull()
}
func (_UnixFSData__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.Repr.KeyAssembler"}.AssignBool(false)
}
func (_UnixFSData__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.Repr.KeyAssembler"}.AssignInt(0)
}
func (_UnixFSData__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_UnixFSData__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "DataType":
		if ka.s&fieldBit__UnixFSData_DataType != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_DataType_serial}
		}
		ka.s += fieldBit__UnixFSData_DataType
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "Data":
		if ka.s&fieldBit__UnixFSData_Data != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Data_serial}
		}
		ka.s += fieldBit__UnixFSData_Data
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "FileSize":
		if ka.s&fieldBit__UnixFSData_FileSize != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_FileSize_serial}
		}
		ka.s += fieldBit__UnixFSData_FileSize
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	case "BlockSizes":
		if ka.s&fieldBit__UnixFSData_BlockSizes != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_BlockSizes_serial}
		}
		ka.s += fieldBit__UnixFSData_BlockSizes
		ka.state = maState_expectValue
		ka.f = 3
		return nil
	case "HashType":
		if ka.s&fieldBit__UnixFSData_HashType != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_HashType_serial}
		}
		ka.s += fieldBit__UnixFSData_HashType
		ka.state = maState_expectValue
		ka.f = 4
		return nil
	case "Fanout":
		if ka.s&fieldBit__UnixFSData_Fanout != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Fanout_serial}
		}
		ka.s += fieldBit__UnixFSData_Fanout
		ka.state = maState_expectValue
		ka.f = 5
		return nil
	case "Mode":
		if ka.s&fieldBit__UnixFSData_Mode != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Mode_serial}
		}
		ka.s += fieldBit__UnixFSData_Mode
		ka.state = maState_expectValue
		ka.f = 6
		return nil
	case "Mtime":
		if ka.s&fieldBit__UnixFSData_Mtime != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSData_Mtime_serial}
		}
		ka.s += fieldBit__UnixFSData_Mtime
		ka.state = maState_expectValue
		ka.f = 7
		return nil
	}
	return ipld.ErrInvalidKey{TypeName: "data.UnixFSData.Repr", Key: &_String{k}}
}
func (_UnixFSData__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_UnixFSData__ReprKeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSData.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_UnixFSData__ReprKeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_UnixFSData__ReprKeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}

func (n _UnixFSMetadata) FieldMimeType() MaybeString {
	return &n.MimeType
}

type _UnixFSMetadata__Maybe struct {
	m schema.Maybe
	v UnixFSMetadata
}
type MaybeUnixFSMetadata = *_UnixFSMetadata__Maybe

func (m MaybeUnixFSMetadata) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeUnixFSMetadata) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeUnixFSMetadata) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeUnixFSMetadata) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeUnixFSMetadata) Must() UnixFSMetadata {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__UnixFSMetadata_MimeType = _String{"MimeType"}
)
var _ ipld.Node = (UnixFSMetadata)(&_UnixFSMetadata{})
var _ schema.TypedNode = (UnixFSMetadata)(&_UnixFSMetadata{})

func (UnixFSMetadata) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n UnixFSMetadata) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "MimeType":
		if n.MimeType.m == schema.Maybe_Absent {
			return ipld.Absent, nil
		}
		return &n.MimeType.v, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n UnixFSMetadata) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (UnixFSMetadata) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "data.UnixFSMetadata"}.LookupByIndex(0)
}
func (n UnixFSMetadata) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n UnixFSMetadata) MapIterator() ipld.MapIterator {
	return &_UnixFSMetadata__MapItr{n, 0}
}

type _UnixFSMetadata__MapItr struct {
	n   UnixFSMetadata
	idx int
}

func (itr *_UnixFSMetadata__MapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
	if itr.idx >= 1 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__UnixFSMetadata_MimeType
		if itr.n.MimeType.m == schema.Maybe_Absent {
			v = ipld.Absent
			break
		}
		v = &itr.n.MimeType.v
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_UnixFSMetadata__MapItr) Done() bool {
	return itr.idx >= 1
}

func (UnixFSMetadata) ListIterator() ipld.ListIterator {
	return nil
}
func (UnixFSMetadata) Length() int64 {
	return 1
}
func (UnixFSMetadata) IsAbsent() bool {
	return false
}
func (UnixFSMetadata) IsNull() bool {
	return false
}
func (UnixFSMetadata) AsBool() (bool, error) {
	return mixins.Map{TypeName: "data.UnixFSMetadata"}.AsBool()
}
func (UnixFSMetadata) AsInt() (int64, error) {
	return mixins.Map{TypeName: "data.UnixFSMetadata"}.AsInt()
}
func (UnixFSMetadata) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "data.UnixFSMetadata"}.AsFloat()
}
func (UnixFSMetadata) AsString() (string, error) {
	return mixins.Map{TypeName: "data.UnixFSMetadata"}.AsString()
}
func (UnixFSMetadata) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "data.UnixFSMetadata"}.AsBytes()
}
func (UnixFSMetadata) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "data.UnixFSMetadata"}.AsLink()
}
func (UnixFSMetadata) Prototype() ipld.NodePrototype {
	return _UnixFSMetadata__Prototype{}
}

type _UnixFSMetadata__Prototype struct{}

func (_UnixFSMetadata__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _UnixFSMetadata__Builder
	nb.Reset()
	return &nb
}

type _UnixFSMetadata__Builder struct {
	_UnixFSMetadata__Assembler
}

func (nb *_UnixFSMetadata__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_UnixFSMetadata__Builder) Reset() {
	var w _UnixFSMetadata
	var m schema.Maybe
	*nb = _UnixFSMetadata__Builder{_UnixFSMetadata__Assembler{w: &w, m: &m}}
}

type _UnixFSMetadata__Assembler struct {
	w     *_UnixFSMetadata
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm          schema.Maybe
	ca_MimeType _String__Assembler
}

func (na *_UnixFSMetadata__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_MimeType.reset()
}

var (
	fieldBit__UnixFSMetadata_MimeType    = 1 << 0
	fieldBits__UnixFSMetadata_sufficient = 0
)

func (na *_UnixFSMetadata__Assembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_UnixFSMetadata{}
	}
	return na, nil
}
func (_UnixFSMetadata__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "data.UnixFSMetadata"}.BeginList(0)
}
func (na *_UnixFSMetadata__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "data.UnixFSMetadata"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_UnixFSMetadata__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSMetadata"}.AssignBool(false)
}
func (_UnixFSMetadata__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSMetadata"}.AssignInt(0)
}
func (_UnixFSMetadata__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSMetadata"}.AssignFloat(0)
}
func (_UnixFSMetadata__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSMetadata"}.AssignString("")
}
func (_UnixFSMetadata__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSMetadata"}.AssignBytes(nil)
}
func (_UnixFSMetadata__Assembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSMetadata"}.AssignLink(nil)
}
func (na *_UnixFSMetadata__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_UnixFSMetadata); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "data.UnixFSMetadata", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_UnixFSMetadata__Assembler) Prototype() ipld.NodePrototype {
	return _UnixFSMetadata__Prototype{}
}
func (ma *_UnixFSMetadata__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.MimeType.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_UnixFSMetadata__Assembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "MimeType":
		if ma.s&fieldBit__UnixFSMetadata_MimeType != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSMetadata_MimeType}
		}
		ma.s += fieldBit__UnixFSMetadata_MimeType
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_MimeType.w = &ma.w.MimeType.v
		ma.ca_MimeType.m = &ma.w.MimeType.m
		return &ma.ca_MimeType, nil
	}
	return nil, ipld.ErrInvalidKey{TypeName: "data.UnixFSMetadata", Key: &_String{k}}
}
func (ma *_UnixFSMetadata__Assembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_UnixFSMetadata__KeyAssembler)(ma)
}
func (ma *_UnixFSMetadata__Assembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_MimeType.w = &ma.w.MimeType.v
		ma.ca_MimeType.m = &ma.w.MimeType.m
		return &ma.ca_MimeType
	default:
		panic("unreachable")
	}
}
func (ma *_UnixFSMetadata__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__UnixFSMetadata_sufficient != fieldBits__UnixFSMetadata_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_UnixFSMetadata__Assembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_UnixFSMetadata__Assembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _UnixFSMetadata__KeyAssembler _UnixFSMetadata__Assembler

func (_UnixFSMetadata__KeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.KeyAssembler"}.BeginMap(0)
}
func (_UnixFSMetadata__KeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.KeyAssembler"}.BeginList(0)
}
func (na *_UnixFSMetadata__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.KeyAssembler"}.AssignNull()
}
func (_UnixFSMetadata__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.KeyAssembler"}.AssignBool(false)
}
func (_UnixFSMetadata__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.KeyAssembler"}.AssignInt(0)
}
func (_UnixFSMetadata__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.KeyAssembler"}.AssignFloat(0)
}
func (ka *_UnixFSMetadata__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "MimeType":
		if ka.s&fieldBit__UnixFSMetadata_MimeType != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSMetadata_MimeType}
		}
		ka.s += fieldBit__UnixFSMetadata_MimeType
		ka.state = maState_expectValue
		ka.f = 0
	default:
		return ipld.ErrInvalidKey{TypeName: "data.UnixFSMetadata", Key: &_String{k}}
	}
	return nil
}
func (_UnixFSMetadata__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.KeyAssembler"}.AssignBytes(nil)
}
func (_UnixFSMetadata__KeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.KeyAssembler"}.AssignLink(nil)
}
func (ka *_UnixFSMetadata__KeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_UnixFSMetadata__KeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (UnixFSMetadata) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n UnixFSMetadata) Representation() ipld.Node {
	return (*_UnixFSMetadata__Repr)(n)
}

type _UnixFSMetadata__Repr _UnixFSMetadata

var (
	fieldName__UnixFSMetadata_MimeType_serial = _String{"MimeType"}
)
var _ ipld.Node = &_UnixFSMetadata__Repr{}

func (_UnixFSMetadata__Repr) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n *_UnixFSMetadata__Repr) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "MimeType":
		if n.MimeType.m == schema.Maybe_Absent {
			return ipld.Absent, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(key)}
		}
		return n.MimeType.v.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n *_UnixFSMetadata__Repr) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_UnixFSMetadata__Repr) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "data.UnixFSMetadata.Repr"}.LookupByIndex(0)
}
func (n _UnixFSMetadata__Repr) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_UnixFSMetadata__Repr) MapIterator() ipld.MapIterator {
	end := 1
	if n.MimeType.m == schema.Maybe_Absent {
		end = 0
	} else {
		goto done
	}
done:
	return &_UnixFSMetadata__ReprMapItr{n, 0, end}
}

type _UnixFSMetadata__ReprMapItr struct {
	n   *_UnixFSMetadata__Repr
	idx int
	end int
}

func (itr *_UnixFSMetadata__ReprMapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
advance:
	if itr.idx >= 1 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__UnixFSMetadata_MimeType_serial
		if itr.n.MimeType.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.MimeType.v.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_UnixFSMetadata__ReprMapItr) Done() bool {
	return itr.idx >= itr.end
}
func (_UnixFSMetadata__Repr) ListIterator() ipld.ListIterator {
	return nil
}
func (rn *_UnixFSMetadata__Repr) Length() int64 {
	l := 1
	if rn.MimeType.m == schema.Maybe_Absent {
		l--
	}
	return int64(l)
}
func (_UnixFSMetadata__Repr) IsAbsent() bool {
	return false
}
func (_UnixFSMetadata__Repr) IsNull() bool {
	return false
}
func (_UnixFSMetadata__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "data.UnixFSMetadata.Repr"}.AsBool()
}
func (_UnixFSMetadata__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "data.UnixFSMetadata.Repr"}.AsInt()
}
func (_UnixFSMetadata__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "data.UnixFSMetadata.Repr"}.AsFloat()
}
func (_UnixFSMetadata__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "data.UnixFSMetadata.Repr"}.AsString()
}
func (_UnixFSMetadata__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "data.UnixFSMetadata.Repr"}.AsBytes()
}
func (_UnixFSMetadata__Repr) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "data.UnixFSMetadata.Repr"}.AsLink()
}
func (_UnixFSMetadata__Repr) Prototype() ipld.NodePrototype {
	return _UnixFSMetadata__ReprPrototype{}
}

type _UnixFSMetadata__ReprPrototype struct{}

func (_UnixFSMetadata__ReprPrototype) NewBuilder() ipld.NodeBuilder {
	var nb _UnixFSMetadata__ReprBuilder
	nb.Reset()
	return &nb
}

type _UnixFSMetadata__ReprBuilder struct {
	_UnixFSMetadata__ReprAssembler
}

func (nb *_UnixFSMetadata__ReprBuilder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_UnixFSMetadata__ReprBuilder) Reset() {
	var w _UnixFSMetadata
	var m schema.Maybe
	*nb = _UnixFSMetadata__ReprBuilder{_UnixFSMetadata__ReprAssembler{w: &w, m: &m}}
}

type _UnixFSMetadata__ReprAssembler struct {
	w     *_UnixFSMetadata
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm          schema.Maybe
	ca_MimeType _String__ReprAssembler
}

func (na *_UnixFSMetadata__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_MimeType.reset()
}
func (na *_UnixFSMetadata__ReprAssembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_UnixFSMetadata{}
	}
	return na, nil
}
func (_UnixFSMetadata__ReprAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "data.UnixFSMetadata.Repr"}.BeginList(0)
}
func (na *_UnixFSMetadata__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "data.UnixFSMetadata.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_UnixFSMetadata__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSMetadata.Repr"}.AssignBool(false)
}
func (_UnixFSMetadata__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSMetadata.Repr"}.AssignInt(0)
}
func (_UnixFSMetadata__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSMetadata.Repr"}.AssignFloat(0)
}
func (_UnixFSMetadata__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSMetadata.Repr"}.AssignString("")
}
func (_UnixFSMetadata__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSMetadata.Repr"}.AssignBytes(nil)
}
func (_UnixFSMetadata__ReprAssembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "data.UnixFSMetadata.Repr"}.AssignLink(nil)
}
func (na *_UnixFSMetadata__ReprAssembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_UnixFSMetadata); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "data.UnixFSMetadata.Repr", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_UnixFSMetadata__ReprAssembler) Prototype() ipld.NodePrototype {
	return _UnixFSMetadata__ReprPrototype{}
}
func (ma *_UnixFSMetadata__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.MimeType.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_UnixFSMetadata__ReprAssembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "MimeType":
		if ma.s&fieldBit__UnixFSMetadata_MimeType != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSMetadata_MimeType_serial}
		}
		ma.s += fieldBit__UnixFSMetadata_MimeType
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_MimeType.w = &ma.w.MimeType.v
		ma.ca_MimeType.m = &ma.w.MimeType.m

		return &ma.ca_MimeType, nil
	default:
	}
	return nil, ipld.ErrInvalidKey{TypeName: "data.UnixFSMetadata.Repr", Key: &_String{k}}
}
func (ma *_UnixFSMetadata__ReprAssembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_UnixFSMetadata__ReprKeyAssembler)(ma)
}
func (ma *_UnixFSMetadata__ReprAssembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_MimeType.w = &ma.w.MimeType.v
		ma.ca_MimeType.m = &ma.w.MimeType.m

		return &ma.ca_MimeType
	default:
		panic("unreachable")
	}
}
func (ma *_UnixFSMetadata__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__UnixFSMetadata_sufficient != fieldBits__UnixFSMetadata_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_UnixFSMetadata__ReprAssembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_UnixFSMetadata__ReprAssembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _UnixFSMetadata__ReprKeyAssembler _UnixFSMetadata__ReprAssembler

func (_UnixFSMetadata__ReprKeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.Repr.KeyAssembler"}.BeginMap(0)
}
func (_UnixFSMetadata__ReprKeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_UnixFSMetadata__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.Repr.KeyAssembler"}.AssignNull()
}
func (_UnixFSMetadata__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.Repr.KeyAssembler"}.AssignBool(false)
}
func (_UnixFSMetadata__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.Repr.KeyAssembler"}.AssignInt(0)
}
func (_UnixFSMetadata__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_UnixFSMetadata__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "MimeType":
		if ka.s&fieldBit__UnixFSMetadata_MimeType != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixFSMetadata_MimeType_serial}
		}
		ka.s += fieldBit__UnixFSMetadata_MimeType
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	}
	return ipld.ErrInvalidKey{TypeName: "data.UnixFSMetadata.Repr", Key: &_String{k}}
}
func (_UnixFSMetadata__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_UnixFSMetadata__ReprKeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "data.UnixFSMetadata.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_UnixFSMetadata__ReprKeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_UnixFSMetadata__ReprKeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}

func (n _UnixTime) FieldSeconds() Int {
	return &n.Seconds
}
func (n _UnixTime) FieldFractionalNanoseconds() MaybeInt {
	return &n.FractionalNanoseconds
}

type _UnixTime__Maybe struct {
	m schema.Maybe
	v UnixTime
}
type MaybeUnixTime = *_UnixTime__Maybe

func (m MaybeUnixTime) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeUnixTime) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeUnixTime) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeUnixTime) AsNode() ipld.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return ipld.Absent
	case schema.Maybe_Null:
		return ipld.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeUnixTime) Must() UnixTime {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__UnixTime_Seconds               = _String{"Seconds"}
	fieldName__UnixTime_FractionalNanoseconds = _String{"FractionalNanoseconds"}
)
var _ ipld.Node = (UnixTime)(&_UnixTime{})
var _ schema.TypedNode = (UnixTime)(&_UnixTime{})

func (UnixTime) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n UnixTime) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "Seconds":
		return &n.Seconds, nil
	case "FractionalNanoseconds":
		if n.FractionalNanoseconds.m == schema.Maybe_Absent {
			return ipld.Absent, nil
		}
		return &n.FractionalNanoseconds.v, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n UnixTime) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (UnixTime) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "data.UnixTime"}.LookupByIndex(0)
}
func (n UnixTime) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n UnixTime) MapIterator() ipld.MapIterator {
	return &_UnixTime__MapItr{n, 0}
}

type _UnixTime__MapItr struct {
	n   UnixTime
	idx int
}

func (itr *_UnixTime__MapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
	if itr.idx >= 2 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__UnixTime_Seconds
		v = &itr.n.Seconds
	case 1:
		k = &fieldName__UnixTime_FractionalNanoseconds
		if itr.n.FractionalNanoseconds.m == schema.Maybe_Absent {
			v = ipld.Absent
			break
		}
		v = &itr.n.FractionalNanoseconds.v
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_UnixTime__MapItr) Done() bool {
	return itr.idx >= 2
}

func (UnixTime) ListIterator() ipld.ListIterator {
	return nil
}
func (UnixTime) Length() int64 {
	return 2
}
func (UnixTime) IsAbsent() bool {
	return false
}
func (UnixTime) IsNull() bool {
	return false
}
func (UnixTime) AsBool() (bool, error) {
	return mixins.Map{TypeName: "data.UnixTime"}.AsBool()
}
func (UnixTime) AsInt() (int64, error) {
	return mixins.Map{TypeName: "data.UnixTime"}.AsInt()
}
func (UnixTime) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "data.UnixTime"}.AsFloat()
}
func (UnixTime) AsString() (string, error) {
	return mixins.Map{TypeName: "data.UnixTime"}.AsString()
}
func (UnixTime) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "data.UnixTime"}.AsBytes()
}
func (UnixTime) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "data.UnixTime"}.AsLink()
}
func (UnixTime) Prototype() ipld.NodePrototype {
	return _UnixTime__Prototype{}
}

type _UnixTime__Prototype struct{}

func (_UnixTime__Prototype) NewBuilder() ipld.NodeBuilder {
	var nb _UnixTime__Builder
	nb.Reset()
	return &nb
}

type _UnixTime__Builder struct {
	_UnixTime__Assembler
}

func (nb *_UnixTime__Builder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_UnixTime__Builder) Reset() {
	var w _UnixTime
	var m schema.Maybe
	*nb = _UnixTime__Builder{_UnixTime__Assembler{w: &w, m: &m}}
}

type _UnixTime__Assembler struct {
	w     *_UnixTime
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm                       schema.Maybe
	ca_Seconds               _Int__Assembler
	ca_FractionalNanoseconds _Int__Assembler
}

func (na *_UnixTime__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_Seconds.reset()
	na.ca_FractionalNanoseconds.reset()
}

var (
	fieldBit__UnixTime_Seconds               = 1 << 0
	fieldBit__UnixTime_FractionalNanoseconds = 1 << 1
	fieldBits__UnixTime_sufficient           = 0 + 1<<0
)

func (na *_UnixTime__Assembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_UnixTime{}
	}
	return na, nil
}
func (_UnixTime__Assembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "data.UnixTime"}.BeginList(0)
}
func (na *_UnixTime__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "data.UnixTime"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_UnixTime__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "data.UnixTime"}.AssignBool(false)
}
func (_UnixTime__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "data.UnixTime"}.AssignInt(0)
}
func (_UnixTime__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "data.UnixTime"}.AssignFloat(0)
}
func (_UnixTime__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "data.UnixTime"}.AssignString("")
}
func (_UnixTime__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "data.UnixTime"}.AssignBytes(nil)
}
func (_UnixTime__Assembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "data.UnixTime"}.AssignLink(nil)
}
func (na *_UnixTime__Assembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_UnixTime); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "data.UnixTime", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_UnixTime__Assembler) Prototype() ipld.NodePrototype {
	return _UnixTime__Prototype{}
}
func (ma *_UnixTime__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_Seconds.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.FractionalNanoseconds.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_UnixTime__Assembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "Seconds":
		if ma.s&fieldBit__UnixTime_Seconds != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixTime_Seconds}
		}
		ma.s += fieldBit__UnixTime_Seconds
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_Seconds.w = &ma.w.Seconds
		ma.ca_Seconds.m = &ma.cm
		return &ma.ca_Seconds, nil
	case "FractionalNanoseconds":
		if ma.s&fieldBit__UnixTime_FractionalNanoseconds != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixTime_FractionalNanoseconds}
		}
		ma.s += fieldBit__UnixTime_FractionalNanoseconds
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_FractionalNanoseconds.w = &ma.w.FractionalNanoseconds.v
		ma.ca_FractionalNanoseconds.m = &ma.w.FractionalNanoseconds.m
		return &ma.ca_FractionalNanoseconds, nil
	}
	return nil, ipld.ErrInvalidKey{TypeName: "data.UnixTime", Key: &_String{k}}
}
func (ma *_UnixTime__Assembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_UnixTime__KeyAssembler)(ma)
}
func (ma *_UnixTime__Assembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_Seconds.w = &ma.w.Seconds
		ma.ca_Seconds.m = &ma.cm
		return &ma.ca_Seconds
	case 1:
		ma.ca_FractionalNanoseconds.w = &ma.w.FractionalNanoseconds.v
		ma.ca_FractionalNanoseconds.m = &ma.w.FractionalNanoseconds.m
		return &ma.ca_FractionalNanoseconds
	default:
		panic("unreachable")
	}
}
func (ma *_UnixTime__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__UnixTime_sufficient != fieldBits__UnixTime_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__UnixTime_Seconds == 0 {
			err.Missing = append(err.Missing, "Seconds")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_UnixTime__Assembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_UnixTime__Assembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _UnixTime__KeyAssembler _UnixTime__Assembler

func (_UnixTime__KeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "data.UnixTime.KeyAssembler"}.BeginMap(0)
}
func (_UnixTime__KeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "data.UnixTime.KeyAssembler"}.BeginList(0)
}
func (na *_UnixTime__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "data.UnixTime.KeyAssembler"}.AssignNull()
}
func (_UnixTime__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "data.UnixTime.KeyAssembler"}.AssignBool(false)
}
func (_UnixTime__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "data.UnixTime.KeyAssembler"}.AssignInt(0)
}
func (_UnixTime__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "data.UnixTime.KeyAssembler"}.AssignFloat(0)
}
func (ka *_UnixTime__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "Seconds":
		if ka.s&fieldBit__UnixTime_Seconds != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixTime_Seconds}
		}
		ka.s += fieldBit__UnixTime_Seconds
		ka.state = maState_expectValue
		ka.f = 0
	case "FractionalNanoseconds":
		if ka.s&fieldBit__UnixTime_FractionalNanoseconds != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixTime_FractionalNanoseconds}
		}
		ka.s += fieldBit__UnixTime_FractionalNanoseconds
		ka.state = maState_expectValue
		ka.f = 1
	default:
		return ipld.ErrInvalidKey{TypeName: "data.UnixTime", Key: &_String{k}}
	}
	return nil
}
func (_UnixTime__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "data.UnixTime.KeyAssembler"}.AssignBytes(nil)
}
func (_UnixTime__KeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "data.UnixTime.KeyAssembler"}.AssignLink(nil)
}
func (ka *_UnixTime__KeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_UnixTime__KeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (UnixTime) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n UnixTime) Representation() ipld.Node {
	return (*_UnixTime__Repr)(n)
}

type _UnixTime__Repr _UnixTime

var (
	fieldName__UnixTime_Seconds_serial               = _String{"Seconds"}
	fieldName__UnixTime_FractionalNanoseconds_serial = _String{"FractionalNanoseconds"}
)
var _ ipld.Node = &_UnixTime__Repr{}

func (_UnixTime__Repr) Kind() ipld.Kind {
	return ipld.Kind_Map
}
func (n *_UnixTime__Repr) LookupByString(key string) (ipld.Node, error) {
	switch key {
	case "Seconds":
		return n.Seconds.Representation(), nil
	case "FractionalNanoseconds":
		if n.FractionalNanoseconds.m == schema.Maybe_Absent {
			return ipld.Absent, ipld.ErrNotExists{Segment: ipld.PathSegmentOfString(key)}
		}
		return n.FractionalNanoseconds.v.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: ipld.PathSegmentOfString(key)}
	}
}
func (n *_UnixTime__Repr) LookupByNode(key ipld.Node) (ipld.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_UnixTime__Repr) LookupByIndex(idx int64) (ipld.Node, error) {
	return mixins.Map{TypeName: "data.UnixTime.Repr"}.LookupByIndex(0)
}
func (n _UnixTime__Repr) LookupBySegment(seg ipld.PathSegment) (ipld.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_UnixTime__Repr) MapIterator() ipld.MapIterator {
	end := 2
	if n.FractionalNanoseconds.m == schema.Maybe_Absent {
		end = 1
	} else {
		goto done
	}
done:
	return &_UnixTime__ReprMapItr{n, 0, end}
}

type _UnixTime__ReprMapItr struct {
	n   *_UnixTime__Repr
	idx int
	end int
}

func (itr *_UnixTime__ReprMapItr) Next() (k ipld.Node, v ipld.Node, _ error) {
advance:
	if itr.idx >= 2 {
		return nil, nil, ipld.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__UnixTime_Seconds_serial
		v = itr.n.Seconds.Representation()
	case 1:
		k = &fieldName__UnixTime_FractionalNanoseconds_serial
		if itr.n.FractionalNanoseconds.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.FractionalNanoseconds.v.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_UnixTime__ReprMapItr) Done() bool {
	return itr.idx >= itr.end
}
func (_UnixTime__Repr) ListIterator() ipld.ListIterator {
	return nil
}
func (rn *_UnixTime__Repr) Length() int64 {
	l := 2
	if rn.FractionalNanoseconds.m == schema.Maybe_Absent {
		l--
	}
	return int64(l)
}
func (_UnixTime__Repr) IsAbsent() bool {
	return false
}
func (_UnixTime__Repr) IsNull() bool {
	return false
}
func (_UnixTime__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "data.UnixTime.Repr"}.AsBool()
}
func (_UnixTime__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "data.UnixTime.Repr"}.AsInt()
}
func (_UnixTime__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "data.UnixTime.Repr"}.AsFloat()
}
func (_UnixTime__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "data.UnixTime.Repr"}.AsString()
}
func (_UnixTime__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "data.UnixTime.Repr"}.AsBytes()
}
func (_UnixTime__Repr) AsLink() (ipld.Link, error) {
	return mixins.Map{TypeName: "data.UnixTime.Repr"}.AsLink()
}
func (_UnixTime__Repr) Prototype() ipld.NodePrototype {
	return _UnixTime__ReprPrototype{}
}

type _UnixTime__ReprPrototype struct{}

func (_UnixTime__ReprPrototype) NewBuilder() ipld.NodeBuilder {
	var nb _UnixTime__ReprBuilder
	nb.Reset()
	return &nb
}

type _UnixTime__ReprBuilder struct {
	_UnixTime__ReprAssembler
}

func (nb *_UnixTime__ReprBuilder) Build() ipld.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_UnixTime__ReprBuilder) Reset() {
	var w _UnixTime
	var m schema.Maybe
	*nb = _UnixTime__ReprBuilder{_UnixTime__ReprAssembler{w: &w, m: &m}}
}

type _UnixTime__ReprAssembler struct {
	w     *_UnixTime
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm                       schema.Maybe
	ca_Seconds               _Int__ReprAssembler
	ca_FractionalNanoseconds _Int__ReprAssembler
}

func (na *_UnixTime__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_Seconds.reset()
	na.ca_FractionalNanoseconds.reset()
}
func (na *_UnixTime__ReprAssembler) BeginMap(int64) (ipld.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_UnixTime{}
	}
	return na, nil
}
func (_UnixTime__ReprAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "data.UnixTime.Repr"}.BeginList(0)
}
func (na *_UnixTime__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "data.UnixTime.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_UnixTime__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "data.UnixTime.Repr"}.AssignBool(false)
}
func (_UnixTime__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "data.UnixTime.Repr"}.AssignInt(0)
}
func (_UnixTime__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "data.UnixTime.Repr"}.AssignFloat(0)
}
func (_UnixTime__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "data.UnixTime.Repr"}.AssignString("")
}
func (_UnixTime__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "data.UnixTime.Repr"}.AssignBytes(nil)
}
func (_UnixTime__ReprAssembler) AssignLink(ipld.Link) error {
	return mixins.MapAssembler{TypeName: "data.UnixTime.Repr"}.AssignLink(nil)
}
func (na *_UnixTime__ReprAssembler) AssignNode(v ipld.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_UnixTime); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != ipld.Kind_Map {
		return ipld.ErrWrongKind{TypeName: "data.UnixTime.Repr", MethodName: "AssignNode", AppropriateKind: ipld.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_UnixTime__ReprAssembler) Prototype() ipld.NodePrototype {
	return _UnixTime__ReprPrototype{}
}
func (ma *_UnixTime__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.FractionalNanoseconds.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_UnixTime__ReprAssembler) AssembleEntry(k string) (ipld.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "Seconds":
		if ma.s&fieldBit__UnixTime_Seconds != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixTime_Seconds_serial}
		}
		ma.s += fieldBit__UnixTime_Seconds
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_Seconds.w = &ma.w.Seconds
		ma.ca_Seconds.m = &ma.cm
		return &ma.ca_Seconds, nil
	case "FractionalNanoseconds":
		if ma.s&fieldBit__UnixTime_FractionalNanoseconds != 0 {
			return nil, ipld.ErrRepeatedMapKey{Key: &fieldName__UnixTime_FractionalNanoseconds_serial}
		}
		ma.s += fieldBit__UnixTime_FractionalNanoseconds
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_FractionalNanoseconds.w = &ma.w.FractionalNanoseconds.v
		ma.ca_FractionalNanoseconds.m = &ma.w.FractionalNanoseconds.m

		return &ma.ca_FractionalNanoseconds, nil
	default:
	}
	return nil, ipld.ErrInvalidKey{TypeName: "data.UnixTime.Repr", Key: &_String{k}}
}
func (ma *_UnixTime__ReprAssembler) AssembleKey() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_UnixTime__ReprKeyAssembler)(ma)
}
func (ma *_UnixTime__ReprAssembler) AssembleValue() ipld.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_Seconds.w = &ma.w.Seconds
		ma.ca_Seconds.m = &ma.cm
		return &ma.ca_Seconds
	case 1:
		ma.ca_FractionalNanoseconds.w = &ma.w.FractionalNanoseconds.v
		ma.ca_FractionalNanoseconds.m = &ma.w.FractionalNanoseconds.m

		return &ma.ca_FractionalNanoseconds
	default:
		panic("unreachable")
	}
}
func (ma *_UnixTime__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__UnixTime_sufficient != fieldBits__UnixTime_sufficient {
		err := ipld.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__UnixTime_Seconds == 0 {
			err.Missing = append(err.Missing, "Seconds")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_UnixTime__ReprAssembler) KeyPrototype() ipld.NodePrototype {
	return _String__Prototype{}
}
func (ma *_UnixTime__ReprAssembler) ValuePrototype(k string) ipld.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _UnixTime__ReprKeyAssembler _UnixTime__ReprAssembler

func (_UnixTime__ReprKeyAssembler) BeginMap(sizeHint int64) (ipld.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "data.UnixTime.Repr.KeyAssembler"}.BeginMap(0)
}
func (_UnixTime__ReprKeyAssembler) BeginList(sizeHint int64) (ipld.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "data.UnixTime.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_UnixTime__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "data.UnixTime.Repr.KeyAssembler"}.AssignNull()
}
func (_UnixTime__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "data.UnixTime.Repr.KeyAssembler"}.AssignBool(false)
}
func (_UnixTime__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "data.UnixTime.Repr.KeyAssembler"}.AssignInt(0)
}
func (_UnixTime__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "data.UnixTime.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_UnixTime__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "Seconds":
		if ka.s&fieldBit__UnixTime_Seconds != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixTime_Seconds_serial}
		}
		ka.s += fieldBit__UnixTime_Seconds
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "FractionalNanoseconds":
		if ka.s&fieldBit__UnixTime_FractionalNanoseconds != 0 {
			return ipld.ErrRepeatedMapKey{Key: &fieldName__UnixTime_FractionalNanoseconds_serial}
		}
		ka.s += fieldBit__UnixTime_FractionalNanoseconds
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	}
	return ipld.ErrInvalidKey{TypeName: "data.UnixTime.Repr", Key: &_String{k}}
}
func (_UnixTime__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "data.UnixTime.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_UnixTime__ReprKeyAssembler) AssignLink(ipld.Link) error {
	return mixins.StringAssembler{TypeName: "data.UnixTime.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_UnixTime__ReprKeyAssembler) AssignNode(v ipld.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_UnixTime__ReprKeyAssembler) Prototype() ipld.NodePrototype {
	return _String__Prototype{}
}
