/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'ovl_dentry_is_whiteout' function which is called by
 *    'ovl_create_or_link'.
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process calls 'ovl_create_or_link', we need to correctly handle
 *    this situation and adjust 'off' flag
 *
 * Caveats:
 *  - Originally, 'ovl_create_or_link' function was hooked.
 *    Due the fact it is declared with 'static' keyword, it may be inlined.
 *
 * Timeline:
 *  - Modified: 27.VII.2022
 *  - Created:  28.III.2019
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_OVL_OVERRIDE_SYNC_H
#define P_LKRG_EXPLOIT_DETECTION_OVL_OVERRIDE_SYNC_H

#if LINUX_VERSION_CODE >= KERNEL_VERSION(4, 10, 0) || \
    (LINUX_VERSION_CODE >= KERNEL_VERSION(4, 4, 179) && LINUX_VERSION_CODE < KERNEL_VERSION(4, 5, 0)) || \
    (defined(RHEL_RELEASE_CODE) && RHEL_RELEASE_CODE > RHEL_RELEASE_VERSION(7, 4))
#define P_OVL_OVERRIDE_SYNC_MODE 2
#define P_OVL_OVERRIDE_SYNC_FUNC "ovl_dentry_is_whiteout"
#elif LINUX_VERSION_CODE >= KERNEL_VERSION(4, 7, 0)
/* Between 4.7 and 4.9, the 'ovl_dentry_is_whiteout' function does not exist */
#define P_OVL_OVERRIDE_SYNC_MODE 1
#define P_OVL_OVERRIDE_SYNC_FUNC "ovl_create_or_link"
#else
#define P_OVL_OVERRIDE_SYNC_MODE 0
#endif

#if P_OVL_OVERRIDE_SYNC_MODE

/* per-instance private data */
struct p_ovl_override_sync_data {
    ktime_t entry_stamp;
};

extern char p_ovl_override_sync_kretprobe_state;

int p_ovl_override_sync_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs);
int p_ovl_override_sync_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_ovl_override_sync_hook(int p_isra);
void p_uninstall_ovl_override_sync_hook(void);
void p_reinit_ovl_override_sync_kretprobe(void);

#endif
#endif
