/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'schedule' function
 *
 * Notes:
 *  - Enforce Exploit Detection pCFI
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 19.XII.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_PCFI_SCHEDULE_H
#define P_LKRG_EXPLOIT_DETECTION_PCFI_SCHEDULE_H

/* per-instance private data */
struct p_pcfi_schedule_data {
    ktime_t entry_stamp;
};


int p_pcfi_schedule_ret(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_pcfi_schedule_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_pcfi_schedule_hook(int p_isra);
void p_uninstall_pcfi_schedule_hook(void);

#endif
