/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept ptrace syscall
 *
 * Notes:
 *  - Enforce Exploit Detection validation
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 5.XI.2020
 *
 * Author:
 * - Mariusz Zaborski (https://oshogbo.vexillium.org/)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_SECURITY_PTRACE_ACCESS_H
#define P_LKRG_EXPLOIT_DETECTION_SECURITY_PTRACE_ACCESS_H

struct p_security_ptrace_access_data {
    ktime_t entry_stamp;
};

int p_security_ptrace_access_ret(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_security_ptrace_access_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_security_ptrace_access_hook(int p_isra);
void p_uninstall_security_ptrace_access_hook(void);

#endif
