/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept setuid syscall
 *
 * Notes:
 *  - None
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 09.IX.2017
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_SYS_SETUID_H
#define P_LKRG_EXPLOIT_DETECTION_SYS_SETUID_H

/* per-instance private data */
struct p_sys_setuid_data {
    ktime_t entry_stamp;
};


int p_sys_setuid_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs);
int p_sys_setuid_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_sys_setuid_hook(int p_isra);
void p_uninstall_sys_setuid_hook(void);

#endif
