package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceUsage invokes the cr.GetInstanceUsage API synchronously
// api document: https://help.aliyun.com/api/cr/getinstanceusage.html
func (client *Client) GetInstanceUsage(request *GetInstanceUsageRequest) (response *GetInstanceUsageResponse, err error) {
	response = CreateGetInstanceUsageResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceUsageWithChan invokes the cr.GetInstanceUsage API asynchronously
// api document: https://help.aliyun.com/api/cr/getinstanceusage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceUsageWithChan(request *GetInstanceUsageRequest) (<-chan *GetInstanceUsageResponse, <-chan error) {
	responseChan := make(chan *GetInstanceUsageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceUsage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceUsageWithCallback invokes the cr.GetInstanceUsage API asynchronously
// api document: https://help.aliyun.com/api/cr/getinstanceusage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceUsageWithCallback(request *GetInstanceUsageRequest, callback func(response *GetInstanceUsageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceUsageResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceUsage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceUsageRequest is the request struct for api GetInstanceUsage
type GetInstanceUsageRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetInstanceUsageResponse is the response struct for api GetInstanceUsage
type GetInstanceUsageResponse struct {
	*responses.BaseResponse
	GetInstanceUsageIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	Code                      string `json:"Code" xml:"Code"`
	RequestId                 string `json:"RequestId" xml:"RequestId"`
	NamespaceQuota            string `json:"NamespaceQuota" xml:"NamespaceQuota"`
	NamespaceUsage            string `json:"NamespaceUsage" xml:"NamespaceUsage"`
	RepoQuota                 string `json:"RepoQuota" xml:"RepoQuota"`
	RepoUsage                 string `json:"RepoUsage" xml:"RepoUsage"`
}

// CreateGetInstanceUsageRequest creates a request to invoke GetInstanceUsage API
func CreateGetInstanceUsageRequest() (request *GetInstanceUsageRequest) {
	request = &GetInstanceUsageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "GetInstanceUsage", "acr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetInstanceUsageResponse creates a response to parse from GetInstanceUsage response
func CreateGetInstanceUsageResponse() (response *GetInstanceUsageResponse) {
	response = &GetInstanceUsageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
