package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRobotTaskCalls invokes the dyvmsapi.ListRobotTaskCalls API synchronously
func (client *Client) ListRobotTaskCalls(request *ListRobotTaskCallsRequest) (response *ListRobotTaskCallsResponse, err error) {
	response = CreateListRobotTaskCallsResponse()
	err = client.DoAction(request, response)
	return
}

// ListRobotTaskCallsWithChan invokes the dyvmsapi.ListRobotTaskCalls API asynchronously
func (client *Client) ListRobotTaskCallsWithChan(request *ListRobotTaskCallsRequest) (<-chan *ListRobotTaskCallsResponse, <-chan error) {
	responseChan := make(chan *ListRobotTaskCallsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRobotTaskCalls(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRobotTaskCallsWithCallback invokes the dyvmsapi.ListRobotTaskCalls API asynchronously
func (client *Client) ListRobotTaskCallsWithCallback(request *ListRobotTaskCallsRequest, callback func(response *ListRobotTaskCallsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRobotTaskCallsResponse
		var err error
		defer close(result)
		response, err = client.ListRobotTaskCalls(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRobotTaskCallsRequest is the request struct for api ListRobotTaskCalls
type ListRobotTaskCallsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Called               string           `position:"Query" name:"Called"`
	DialogCountTo        string           `position:"Query" name:"DialogCountTo"`
	DurationFrom         string           `position:"Query" name:"DurationFrom"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	TaskId               string           `position:"Query" name:"TaskId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DialogCountFrom      string           `position:"Query" name:"DialogCountFrom"`
	DurationTo           string           `position:"Query" name:"DurationTo"`
	HangupDirection      string           `position:"Query" name:"HangupDirection"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PageNo               requests.Integer `position:"Query" name:"PageNo"`
	CallResult           string           `position:"Query" name:"CallResult"`
}

// ListRobotTaskCallsResponse is the response struct for api ListRobotTaskCalls
type ListRobotTaskCallsResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Data       string `json:"Data" xml:"Data"`
	PageSize   string `json:"PageSize" xml:"PageSize"`
	PageNo     string `json:"PageNo" xml:"PageNo"`
	TotalCount string `json:"TotalCount" xml:"TotalCount"`
	Code       string `json:"Code" xml:"Code"`
	Message    string `json:"Message" xml:"Message"`
}

// CreateListRobotTaskCallsRequest creates a request to invoke ListRobotTaskCalls API
func CreateListRobotTaskCallsRequest() (request *ListRobotTaskCallsRequest) {
	request = &ListRobotTaskCallsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "ListRobotTaskCalls", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListRobotTaskCallsResponse creates a response to parse from ListRobotTaskCalls response
func CreateListRobotTaskCallsResponse() (response *ListRobotTaskCallsResponse) {
	response = &ListRobotTaskCallsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
