/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.cache;

import com.intellij.ml.inline.completion.impl.AnalyzedMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.MLCompletionProposalsDetails;
import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.cache.LightweightCacheKey;
import com.intellij.ml.inline.completion.impl.cache.LightweightEditorCache;
import com.intellij.openapi.Disposable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u0012\u001a\u00020\nJ\f\u0010\u0013\u001a\u00020\u0014*\u00020\bH\u0002J\b\u0010\u0015\u001a\u00020\nH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/inline/completion/impl/cache/MLInlineCompletionCache;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "rawCache", "Lcom/intellij/ml/inline/completion/impl/cache/LightweightEditorCache;", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "analyzedCache", "Lcom/intellij/ml/inline/completion/impl/AnalyzedMLCompletionProposal;", "cacheRaw", "", "key", "Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey;", "proposal", "getCachedRaw", "", "cacheAnalyzed", "getAnalyzed", "invalidate", "isEmpty", "", "dispose", "Companion", "intellij.ml.inline.completion"})
@SourceDebugExtension(value={"SMAP\nMLInlineCompletionCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLInlineCompletionCache.kt\ncom/intellij/ml/inline/completion/impl/cache/MLInlineCompletionCache\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n535#2:69\n520#2,6:70\n1053#3:76\n1557#3:77\n1628#3,3:78\n774#3:81\n865#3,2:82\n1#4:84\n*S KotlinDebug\n*F\n+ 1 MLInlineCompletionCache.kt\ncom/intellij/ml/inline/completion/impl/cache/MLInlineCompletionCache\n*L\n16#1:69\n16#1:70,6\n22#1:76\n23#1:77\n23#1:78,3\n30#1:81\n30#1:82,2\n*E\n"})
public abstract class MLInlineCompletionCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LightweightEditorCache<RawMLCompletionProposal> rawCache = new LightweightEditorCache(30L, CACHE_TTL, null);
    @NotNull
    private final LightweightEditorCache<AnalyzedMLCompletionProposal> analyzedCache = new LightweightEditorCache(30L, CACHE_TTL, null);
    private static final long CACHE_TTL = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES);
    private static final long CACHE_CAPACITY = 30L;

    public final void cacheRaw(@NotNull LightweightCacheKey key, @NotNull RawMLCompletionProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        this.rawCache.put(key, proposal);
    }

    @NotNull
    public final List<RawMLCompletionProposal> getCachedRaw(@NotNull LightweightCacheKey key) {
        Object $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object $this$filter$iv = this.rawCache.getMatching(key);
        boolean $i$f$filter = false;
        Map<LightweightCacheKey, RawMLCompletionProposal> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            it = element$iv$iv;
            boolean bl = false;
            String fullSuggestion = ((LightweightCacheKey)it.getKey()).getLinePrefix() + ((RawMLCompletionProposal)it.getValue()).getSuggestion();
            if (!StringsKt.startsWith$default((String)fullSuggestion, (String)key.getLinePrefix(), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map allMatching = destination$iv$iv;
        Iterable $this$sortedBy$iv = allMatching.entrySet();
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((LightweightCacheKey)it.getKey()).getLinePrefix().length());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((LightweightCacheKey)it.getKey()).getLinePrefix().length()));
            }
        });
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            RawMLCompletionProposal rawMLCompletionProposal;
            Map.Entry item$iv$iv = iterator.next();
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            String prefixToTrim = StringsKt.removePrefix((String)key.getLinePrefix(), (CharSequence)((LightweightCacheKey)it.getKey()).getLinePrefix());
            RawMLCompletionProposal source = ((RawMLCompletionProposal)it.getValue()).trimPrefix(prefixToTrim);
            RawMLCompletionProposal $this$getCachedRaw_u24lambda_u243_u24lambda_u242 = rawMLCompletionProposal = new RawMLCompletionProposal(source.getSuggestion(), source.getScore(), source.getDetails().clone(true));
            boolean bl2 = false;
            $this$getCachedRaw_u24lambda_u243_u24lambda_u242.getDetails().set(MLCompletionProposalsDetails.INSTANCE.getCACHED_TRIMMED_PREFIX_LENGTH(), prefixToTrim.length());
            object.add(rawMLCompletionProposal);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv) {
            it = (RawMLCompletionProposal)((Object)element$iv$iv);
            boolean bl = false;
            boolean bl3 = ((CharSequence)((RawMLCompletionProposal)it).getSuggestion()).length() > 0;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void cacheAnalyzed(@NotNull LightweightCacheKey key, @NotNull AnalyzedMLCompletionProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        this.analyzedCache.put(key, proposal);
    }

    @Nullable
    public final AnalyzedMLCompletionProposal getAnalyzed(@NotNull LightweightCacheKey key) {
        Map.Entry<LightweightCacheKey, AnalyzedMLCompletionProposal> entry;
        block4: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            AnalyzedMLCompletionProposal analyzedMLCompletionProposal = this.analyzedCache.getExact(key);
            if (analyzedMLCompletionProposal != null) {
                AnalyzedMLCompletionProposal it = analyzedMLCompletionProposal;
                boolean bl = false;
                return it;
            }
            for (Map.Entry<LightweightCacheKey, AnalyzedMLCompletionProposal> entry2 : this.analyzedCache.getMatching(key).entrySet()) {
                AnalyzedMLCompletionProposal analyzedMLCompletionProposal2;
                boolean bl = false;
                LightweightCacheKey otherKey = entry2.getKey();
                AnalyzedMLCompletionProposal proposal = entry2.getValue();
                String fullSuggestion = otherKey.getLinePrefix() + proposal.getSuggestion();
                if (StringsKt.startsWith$default((String)fullSuggestion, (String)key.getLinePrefix(), (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)key.getLineSuffix(), (Object)otherKey.getLineSuffix())) {
                    AnalyzedMLCompletionProposal analyzedMLCompletionProposal3;
                    String prefixToTrim = StringsKt.removePrefix((String)key.getLinePrefix(), (CharSequence)otherKey.getLinePrefix());
                    AnalyzedMLCompletionProposal it = analyzedMLCompletionProposal3 = proposal.trimPrefix(prefixToTrim);
                    boolean bl2 = false;
                    analyzedMLCompletionProposal2 = !this.isEmpty(it) ? analyzedMLCompletionProposal3 : null;
                } else {
                    analyzedMLCompletionProposal2 = null;
                }
                if ((entry2 = analyzedMLCompletionProposal2) == null) continue;
                entry = entry2;
                break block4;
            }
            entry = null;
        }
        return entry;
    }

    public final void invalidate() {
        this.rawCache.clear();
        this.analyzedCache.clear();
    }

    private final boolean isEmpty(AnalyzedMLCompletionProposal $this$isEmpty) {
        if (((CharSequence)$this$isEmpty.getSuggestion()).length() == 0) {
            return true;
        }
        Set<Integer> set = $this$isEmpty.getDetails().get(MLCompletionProposalsDetails.INSTANCE.getMATCHED_SYMBOLS_INDICES());
        int matchedSymbolsSize = set != null ? set.size() : 0;
        return $this$isEmpty.getSuggestion().length() <= matchedSymbolsSize;
    }

    public void dispose() {
        this.invalidate();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/inline/completion/impl/cache/MLInlineCompletionCache$Companion;", "", "<init>", "()V", "CACHE_TTL", "Lkotlin/time/Duration;", "J", "CACHE_CAPACITY", "", "intellij.ml.inline.completion"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

