/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.rsync;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.rsync.RsyncConfigurable;
import com.intellij.ssh.rsync.RsyncService;
import com.intellij.ssh.rsync.RsyncStatusService;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ssh/rsync/RsyncConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "<init>", "()V", "optionsTextField", "Lcom/intellij/ui/RawCommandLineEditor;", "testConnectionJBLabel", "Lcom/intellij/ui/components/JBLabel;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "testConnection", "", "path", "", "shell", "options", "intellij.platform.ssh.ui"})
public final class RsyncConfigurable
extends BoundConfigurable {
    @NotNull
    private final RawCommandLineEditor optionsTextField;
    @NotNull
    private final JBLabel testConnectionJBLabel;

    public RsyncConfigurable() {
        String string = SshBundle.message("configurable.RsyncConfigurable.display.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "reference.settings.tools.rsync");
        this.optionsTextField = new RawCommandLineEditor(arg_0 -> RsyncConfigurable.optionsTextField$lambda$1(RsyncConfigurable::optionsTextField$lambda$0, arg_0), arg_0 -> RsyncConfigurable.optionsTextField$lambda$3(RsyncConfigurable::optionsTextField$lambda$2, arg_0));
        this.testConnectionJBLabel = new JBLabel();
    }

    @NotNull
    public DialogPanel createPanel() {
        Ref.ObjectRef restoreOptionsLink = new Ref.ObjectRef();
        Ref.ObjectRef shellPathTextField = new Ref.ObjectRef();
        Ref.ObjectRef rsyncPathTextField = new Ref.ObjectRef();
        JBPanel jBPanel = BuilderKt.panel(arg_0 -> RsyncConfigurable.createPanel$lambda$15(rsyncPathTextField, this, restoreOptionsLink, shellPathTextField, arg_0)).withBorder((Border)JBUI.Borders.emptyTop((int)12));
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"withBorder(...)");
        return (DialogPanel)jBPanel;
    }

    private final void testConnection(String path, String shell, String options) {
        String string;
        String string2;
        String string3 = path;
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = shell) == null) {
            string2 = "";
        }
        if ((string = RsyncStatusService.validateRsyncCommand(string3, options, string2, true)) == null) {
            String string4 = SshBundle.message("rsync.test.connection.successful", new Object[0]);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        }
        this.testConnectionJBLabel.setText(string);
        this.testConnectionJBLabel.setVisible(true);
    }

    private static final List optionsTextField$lambda$0(String it) {
        Intrinsics.checkNotNull((Object)it);
        String[] stringArray = new String[]{",", " "};
        return StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }

    private static final List optionsTextField$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final String optionsTextField$lambda$2(List it) {
        Intrinsics.checkNotNull((Object)it);
        return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)it, (CharSequence)",", null, null, (int)0, null, null, (int)62, null))).toString();
    }

    private static final String optionsTextField$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit createPanel$lambda$15$lambda$4(Ref.ObjectRef $rsyncPathTextField, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = SshBundle.message("rsync.settings.browsing.dialog.title.rsync.executable.path", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $rsyncPathTextField.element = TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (String)string, null, null, (int)6, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(RsyncService.Companion.getInstance()){

            public Object get() {
                return ((RsyncService)this.receiver).getRsyncPath();
            }

            public void set(Object value) {
                ((RsyncService)this.receiver).setRsyncPath((String)value);
            }
        })).align((Align)AlignX.FILL.INSTANCE).getComponent();
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$15$lambda$8$lambda$5(RawCommandLineEditor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (char)' ', (char)',', (boolean)false, (int)4, null);
    }

    private static final Unit createPanel$lambda$15$lambda$8$lambda$6(RsyncConfigurable this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.optionsTextField.setText("-zar");
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15$lambda$8$lambda$7(RsyncConfigurable this$0, ActionLink $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setAutoHideOnDisable(false);
        $this$applyToComponent.setEnabled(!this$0.optionsTextField.getText().equals("-zar"));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15$lambda$8(RsyncConfigurable this$0, Ref.ObjectRef $restoreOptionsLink, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell.comment$default((Cell)$this$row.cell((JComponent)this$0.optionsTextField), (String)SshBundle.message("rsync.settings.label.rsync.man", new Object[0]), (int)0, null, (int)6, null).resizableColumn().align((Align)AlignX.FILL.INSTANCE).gap(RightGap.SMALL).bind(RsyncConfigurable::createPanel$lambda$15$lambda$8$lambda$5, (Function2)createPanel.1.2.2.INSTANCE, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(RsyncService.Companion.getInstance()){

            public Object get() {
                return ((RsyncService)this.receiver).getOptions();
            }

            public void set(Object value) {
                ((RsyncService)this.receiver).setOptions((String)value);
            }
        })));
        String string = SshBundle.message("rsync.settings.reset", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $restoreOptionsLink.element = $this$row.link(string, arg_0 -> RsyncConfigurable.createPanel$lambda$15$lambda$8$lambda$6(this$0, arg_0)).applyToComponent(arg_0 -> RsyncConfigurable.createPanel$lambda$15$lambda$8$lambda$7(this$0, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15$lambda$9(Ref.ObjectRef $shellPathTextField, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = SshBundle.message("rsync.settings.browsing.dialog.title.shell.executable.path", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $shellPathTextField.element = Cell.comment$default((Cell)TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (String)string, null, null, (int)6, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(RsyncService.Companion.getInstance()){

            public Object get() {
                return ((RsyncService)this.receiver).getShellPath();
            }

            public void set(Object value) {
                ((RsyncService)this.receiver).setShellPath((String)value);
            }
        })), (String)SshBundle.message("rsync.settings.shell.executable.hint", new Object[0]), (int)0, null, (int)6, null).align((Align)AlignX.FILL.INSTANCE).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15$lambda$11$lambda$10(RsyncConfigurable this$0, Ref.ObjectRef $rsyncPathTextField, Ref.ObjectRef $shellPathTextField, ActionEvent it) {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($rsyncPathTextField.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rsyncPathTextField");
            textFieldWithBrowseButton2 = null;
        } else {
            textFieldWithBrowseButton2 = (TextFieldWithBrowseButton)$rsyncPathTextField.element;
        }
        String string = textFieldWithBrowseButton2.getText();
        if ($shellPathTextField.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shellPathTextField");
            textFieldWithBrowseButton = null;
        } else {
            textFieldWithBrowseButton = (TextFieldWithBrowseButton)$shellPathTextField.element;
        }
        String string2 = textFieldWithBrowseButton.getText();
        String string3 = this$0.optionsTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        this$0.testConnection(string, string2, StringsKt.replace$default((String)string3, (char)' ', (char)',', (boolean)false, (int)4, null));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15$lambda$11(RsyncConfigurable this$0, Ref.ObjectRef $rsyncPathTextField, Ref.ObjectRef $shellPathTextField, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = SshBundle.message("rsync.test.connection", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.button(string, arg_0 -> RsyncConfigurable.createPanel$lambda$15$lambda$11$lambda$10(this$0, $rsyncPathTextField, $shellPathTextField, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15$lambda$13$lambda$12(JBLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setFontColor(UIUtil.FontColor.BRIGHTER);
        $this$applyToComponent.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        $this$applyToComponent.setVisible(false);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15$lambda$13(RsyncConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.testConnectionJBLabel).applyToComponent(RsyncConfigurable::createPanel$lambda$15$lambda$13$lambda$12);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15$lambda$14(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon = AllIcons.General.Information;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Information");
        $this$row.icon(icon).align((Align)AlignY.TOP.INSTANCE).gap(RightGap.SMALL);
        String string = SshBundle.message("text.recommended.setup.cygwin.with.rsync.openssh.packages.installed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.comment$default((Row)$this$row, (String)string, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$15(Ref.ObjectRef $rsyncPathTextField, RsyncConfigurable this$0, Ref.ObjectRef $restoreOptionsLink, Ref.ObjectRef $shellPathTextField, Panel $this$panel) {
        Object object;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = SshBundle.message("rsync.settings.label.rsync.executable.path", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> RsyncConfigurable.createPanel$lambda$15$lambda$4($rsyncPathTextField, arg_0));
        String string2 = SshBundle.message("rsync.settings.label.rsync.arguments", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> RsyncConfigurable.createPanel$lambda$15$lambda$8(this$0, $restoreOptionsLink, arg_0));
        String string3 = SshBundle.message("rsync.settings.label.shell.executable.path", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$panel.row(string3, arg_0 -> RsyncConfigurable.createPanel$lambda$15$lambda$9($shellPathTextField, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> RsyncConfigurable.createPanel$lambda$15$lambda$11(this$0, $rsyncPathTextField, $shellPathTextField, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> RsyncConfigurable.createPanel$lambda$15$lambda$13(this$0, arg_0), (int)1, null);
        if ($rsyncPathTextField.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rsyncPathTextField");
            textFieldWithBrowseButton = null;
        } else {
            textFieldWithBrowseButton = (TextFieldWithBrowseButton)$rsyncPathTextField.element;
        }
        Document document = textFieldWithBrowseButton.getTextField().getDocument();
        if (document != null) {
            document.addDocumentListener((DocumentListener)new DocumentAdapter(this$0){
                final /* synthetic */ RsyncConfigurable this$0;
                {
                    this.this$0 = $receiver;
                }

                protected void textChanged(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    RsyncConfigurable.access$getTestConnectionJBLabel$p(this.this$0).setVisible(false);
                }
            });
        }
        if ((object = this$0.optionsTextField.getTextField()) != null && (object = ((JTextComponent)object).getDocument()) != null) {
            object.addDocumentListener((DocumentListener)new DocumentAdapter((Ref.ObjectRef<ActionLink>)$restoreOptionsLink, this$0){
                final /* synthetic */ Ref.ObjectRef<ActionLink> $restoreOptionsLink;
                final /* synthetic */ RsyncConfigurable this$0;
                {
                    this.$restoreOptionsLink = $restoreOptionsLink;
                    this.this$0 = $receiver;
                }

                protected void textChanged(DocumentEvent e) {
                    ActionLink actionLink;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (this.$restoreOptionsLink.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"restoreOptionsLink");
                        actionLink = null;
                    } else {
                        actionLink = (ActionLink)this.$restoreOptionsLink.element;
                    }
                    actionLink.setEnabled(!RsyncConfigurable.access$getOptionsTextField$p(this.this$0).getText().equals("-zar"));
                }
            });
        }
        if (SystemInfo.isWindows) {
            TextFieldWithBrowseButton textFieldWithBrowseButton2;
            if ($rsyncPathTextField.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rsyncPathTextField");
                textFieldWithBrowseButton2 = null;
            } else {
                textFieldWithBrowseButton2 = (TextFieldWithBrowseButton)$rsyncPathTextField.element;
            }
            Document document2 = textFieldWithBrowseButton2.getTextField().getDocument();
            if (document2 != null) {
                document2.addDocumentListener((DocumentListener)new DocumentAdapter((Ref.ObjectRef<TextFieldWithBrowseButton>)$rsyncPathTextField, (Ref.ObjectRef<TextFieldWithBrowseButton>)$shellPathTextField){
                    final /* synthetic */ Ref.ObjectRef<TextFieldWithBrowseButton> $rsyncPathTextField;
                    final /* synthetic */ Ref.ObjectRef<TextFieldWithBrowseButton> $shellPathTextField;
                    {
                        this.$rsyncPathTextField = $rsyncPathTextField;
                        this.$shellPathTextField = $shellPathTextField;
                    }

                    protected void textChanged(DocumentEvent e) {
                        TextFieldWithBrowseButton textFieldWithBrowseButton;
                        TextFieldWithBrowseButton textFieldWithBrowseButton2;
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (this.$rsyncPathTextField.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"rsyncPathTextField");
                            textFieldWithBrowseButton2 = null;
                        } else {
                            textFieldWithBrowseButton2 = (TextFieldWithBrowseButton)this.$rsyncPathTextField.element;
                        }
                        String string = textFieldWithBrowseButton2.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        String rsyncPath = string;
                        if (this.$shellPathTextField.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"shellPathTextField");
                            textFieldWithBrowseButton = null;
                        } else {
                            textFieldWithBrowseButton = (TextFieldWithBrowseButton)this.$shellPathTextField.element;
                        }
                        String string2 = textFieldWithBrowseButton.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                        String sshPath = string2;
                        if (Intrinsics.areEqual((Object)"ssh", (Object)sshPath) && FileUtil.isAbsolute((String)rsyncPath)) {
                            TextFieldWithBrowseButton textFieldWithBrowseButton3;
                            String string3 = PathUtil.getParentPath((String)rsyncPath);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getParentPath(...)");
                            String parentPath = string3;
                            if (this.$shellPathTextField.element == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"shellPathTextField");
                                textFieldWithBrowseButton3 = null;
                            } else {
                                textFieldWithBrowseButton3 = (TextFieldWithBrowseButton)this.$shellPathTextField.element;
                            }
                            textFieldWithBrowseButton3.setText(parentPath + File.separator + "ssh.exe");
                        }
                    }
                });
            }
            Panel.row$default((Panel)$this$panel, null, RsyncConfigurable::createPanel$lambda$15$lambda$14, (int)1, null);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ JBLabel access$getTestConnectionJBLabel$p(RsyncConfigurable $this) {
        return $this.testConnectionJBLabel;
    }

    public static final /* synthetic */ RawCommandLineEditor access$getOptionsTextField$p(RsyncConfigurable $this) {
        return $this.optionsTextField;
    }
}

