/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.regex.Pattern;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.Actions;
import org.assertj.swing.driver.ContainerDriver;
import org.assertj.swing.driver.JComponentToolTipQuery;
import org.assertj.swing.driver.KeyStrokes;
import org.assertj.swing.driver.TextAssert;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.internal.annotation.InternalApi;

@InternalApi
public class JComponentDriver
extends ContainerDriver {
    private static final String TOOL_TIP_TEXT_PROPERTY = "toolTipText";

    public JComponentDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInCurrentThread
    protected final void scrollToVisible(@Nonnull JComponent c, @Nonnull Rectangle r) {
        c.scrollRectToVisible(r);
    }

    @RunsInCurrentThread
    protected static boolean isVisible(@Nonnull JComponent c, @Nonnull Rectangle r) {
        return c.getVisibleRect().contains(r);
    }

    @RunsInCurrentThread
    protected final boolean isVisible(@Nonnull JComponent c, @Nonnull Point p) {
        return c.getVisibleRect().contains(p);
    }

    @RunsInEDT
    protected final void invokeAction(@Nonnull JComponent c, @Nonnull String name) {
        this.robot.focusAndWaitForFocusGain(c);
        for (KeyStroke keyStroke : JComponentDriver.keyStrokesForAction(c, name)) {
            try {
                this.type((KeyStroke)Preconditions.checkNotNull((Object)keyStroke));
                this.robot.waitForIdle();
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw ActionFailedException.actionFailure(String.format("Unable to type any key for the action with key '%s'", name));
    }

    @RunsInCurrentThread
    private static KeyStroke[] keyStrokesForAction(@Nonnull JComponent component2, @Nonnull String actionName) {
        Object key = Actions.findActionKey(actionName, (ActionMap)Preconditions.checkNotNull((Object)component2.getActionMap()));
        return KeyStrokes.findKeyStrokesForAction(actionName, key, (InputMap)Preconditions.checkNotNull((Object)component2.getInputMap()));
    }

    private void type(@Nonnull KeyStroke keyStroke) {
        if (keyStroke.getKeyCode() == 0) {
            this.robot.type(keyStroke.getKeyChar());
            return;
        }
        this.robot.pressAndReleaseKey(keyStroke.getKeyCode(), keyStroke.getModifiers());
    }

    @RunsInEDT
    public void requireToolTip(@Nonnull JComponent c, @Nullable String expected) {
        ((TextAssert)((Object)TextAssert.verifyThat(JComponentToolTipQuery.toolTipOf(c)).as(JComponentDriver.propertyName(c, TOOL_TIP_TEXT_PROPERTY)))).isEqualOrMatches(expected);
    }

    @RunsInEDT
    public void requireToolTip(@Nonnull JComponent c, @Nonnull Pattern pattern) {
        ((TextAssert)((Object)TextAssert.verifyThat(JComponentToolTipQuery.toolTipOf(c)).as(JComponentDriver.propertyName(c, TOOL_TIP_TEXT_PROPERTY)))).matches(pattern);
    }

    @Nullable
    @RunsInEDT
    public Object clientProperty(@Nonnull JComponent c, @Nonnull Object key) {
        return JComponentDriver.clientPropertyIn(c, Preconditions.checkNotNull((Object)key));
    }

    @Nullable
    private static Object clientPropertyIn(@Nonnull JComponent c, @Nonnull Object key) {
        return GuiActionRunner.execute(() -> c.getClientProperty(key));
    }
}

