/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.spellchecking;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.spellchecker.CssSpellcheckingStrategy;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;
import org.jetbrains.plugins.less.psi.impl.LESSNamespace;
import org.jetbrains.plugins.less.psi.impl.LESSVariableImpl;

public final class LessSpellcheckingStrategy
extends CssSpellcheckingStrategy
implements DumbAware {
    private static final Tokenizer SUBSTRING_TOKENIZER_FOR_NAME_OWNERS = new Tokenizer<PsiNameIdentifierOwner>(){

        public void tokenize(@NotNull PsiNameIdentifierOwner element, @NotNull TokenConsumer consumer) {
            PsiElement identifier;
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((identifier = element.getNameIdentifier()) == null) {
                return;
            }
            TextRange range = identifier.getTextRange();
            if (range.isEmpty()) {
                return;
            }
            String text = identifier.getText().substring(1);
            consumer.consumeToken((PsiElement)element, text, true, 1, TextRange.allOf((String)text), (Splitter)IdentifierSplitter.getInstance());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/less/spellchecking/LessSpellcheckingStrategy$1";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final Tokenizer SUBSTRING_TOKENIZER_FOR_NAME_IDENTIFIERS = new Tokenizer<PsiNamedElement>(){

        public void tokenize(@NotNull PsiNamedElement element, @NotNull TokenConsumer consumer) {
            String name;
            if (element == null) {
                2.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                2.$$$reportNull$$$0(1);
            }
            if (StringUtil.isEmpty((String)(name = element.getName()))) {
                return;
            }
            consumer.consumeToken((PsiElement)element, name, true, element.getTextOffset() - element.getTextRange().getStartOffset(), TextRange.allOf((String)name), (Splitter)IdentifierSplitter.getInstance());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/less/spellchecking/LessSpellcheckingStrategy$2";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof LESSNamespace || element instanceof LESSMixinInvocation || element instanceof LESSMixin) {
            IElementType elementType;
            PsiElement nameIdentifier = ((PsiNameIdentifierOwner)element).getNameIdentifier();
            if (nameIdentifier != null && ((elementType = nameIdentifier.getNode().getElementType()) == CssElementTypes.CSS_HASH || elementType == LESSElementTypes.LESS_VARIABLE)) {
                Tokenizer tokenizer = SUBSTRING_TOKENIZER_FOR_NAME_OWNERS;
                if (tokenizer == null) {
                    LessSpellcheckingStrategy.$$$reportNull$$$0(0);
                }
                return tokenizer;
            }
        } else {
            if (element instanceof LESSVariableImpl) {
                Tokenizer tokenizer = SUBSTRING_TOKENIZER_FOR_NAME_IDENTIFIERS;
                if (tokenizer == null) {
                    LessSpellcheckingStrategy.$$$reportNull$$$0(1);
                }
                return tokenizer;
            }
            if (element instanceof LESSVariableDeclaration) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    LessSpellcheckingStrategy.$$$reportNull$$$0(2);
                }
                return tokenizer;
            }
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            LessSpellcheckingStrategy.$$$reportNull$$$0(3);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/spellchecking/LessSpellcheckingStrategy", "getTokenizer"));
    }
}

