/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang.html.index;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLexerUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.lexer.Lexer;
import com.intellij.psi.impl.cache.CacheUtil;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.idCache.XmlFilterLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.angular2.lang.expr.Angular2Language;
import org.angular2.lang.expr.lexer.Angular2TokenTypes;
import org.angular2.lang.html.Angular2HtmlLanguage;
import org.angular2.lang.html.lexer.Angular2HtmlTokenTypes;
import org.angular2.lang.html.parser.Angular2AttributeNameParser;
import org.angular2.lang.html.parser.Angular2AttributeType;
import org.angular2.lang.html.parser.Angular2HtmlElementTypes;
import org.angular2.lang.svg.Angular2SvgLanguage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/angular2/lang/html/index/Angular2HtmlFilterLexer;", "Lcom/intellij/psi/impl/cache/impl/BaseFilterLexer;", "occurrenceConsumer", "Lcom/intellij/psi/impl/cache/impl/OccurrenceConsumer;", "originalLexer", "Lcom/intellij/lexer/Lexer;", "<init>", "(Lcom/intellij/psi/impl/cache/impl/OccurrenceConsumer;Lcom/intellij/lexer/Lexer;)V", "advance", "", "Companion", "intellij.angular"})
public final class Angular2HtmlFilterLexer
extends BaseFilterLexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<Language> SUPPORTED_LANGUAGES;
    @NotNull
    private static final TokenSet IDENTIFIERS;
    @NotNull
    private static final TokenSet COMMENTS;
    @NotNull
    private static final TokenSet LITERALS;
    @NotNull
    private static final TokenSet SKIP_WORDS;

    public Angular2HtmlFilterLexer(@NotNull OccurrenceConsumer occurrenceConsumer, @NotNull Lexer originalLexer) {
        Intrinsics.checkNotNullParameter((Object)occurrenceConsumer, (String)"occurrenceConsumer");
        Intrinsics.checkNotNullParameter((Object)originalLexer, (String)"originalLexer");
        super(originalLexer, occurrenceConsumer);
    }

    public void advance() {
        IElementType tokenType = this.myDelegate.getTokenType();
        if (!SKIP_WORDS.contains(tokenType)) {
            if (IDENTIFIERS.contains(tokenType)) {
                this.addOccurrenceInToken(1);
            } else if (tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || tokenType == XmlTokenType.XML_NAME || tokenType == XmlTokenType.XML_TAG_NAME || tokenType == XmlTokenType.XML_DATA_CHARACTERS) {
                this.scanWordsInToken(24, tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, false);
            } else if (COMMENTS.contains(tokenType)) {
                this.scanWordsInToken(2, false, false);
                this.advanceTodoItemCountsInToken();
            } else if (LITERALS.contains(tokenType)) {
                this.scanWordsInToken(4, false, false);
            } else if (Angular2HtmlElementTypes.ALL_ATTRIBUTES.contains(tokenType)) {
                String string = this.myDelegate.getTokenText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenText(...)");
                Angular2AttributeNameParser.AttributeInfo info2 = Angular2AttributeNameParser.INSTANCE.parse(string);
                if (info2.getType() != Angular2AttributeType.REGULAR) {
                    String string2 = this.getTokenText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTokenText(...)");
                    this.addOccurrenceInToken(1, StringsKt.lastIndexOf$default((CharSequence)string2, (String)info2.getName(), (int)0, (boolean)false, (int)6, null), info2.getName().length());
                }
            } else if (tokenType != null && !SUPPORTED_LANGUAGES.contains(tokenType.getLanguage())) {
                boolean inComments = CacheUtil.isInComments((IElementType)tokenType);
                int mask = inComments ? 2 : 24;
                this.scanWordsInToken(mask, true, false);
                if (inComments) {
                    this.advanceTodoItemCountsInToken();
                }
            } else {
                this.scanWordsInToken(16, false, false);
            }
        }
        this.myDelegate.advance();
    }

    static {
        Object[] objectArray = new Language[]{XMLLanguage.INSTANCE, HTMLLanguage.INSTANCE, Angular2HtmlLanguage.INSTANCE, Angular2SvgLanguage.INSTANCE, Angular2Language.INSTANCE, Language.ANY};
        SUPPORTED_LANGUAGES = SetsKt.setOf((Object[])objectArray);
        TokenSet[] tokenSetArray = new TokenSet[]{JSKeywordSets.IDENTIFIER_NAMES};
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        IDENTIFIERS = tokenSet;
        tokenSetArray = new TokenSet[2];
        tokenSetArray[0] = JSTokenTypes.COMMENTS;
        IElementType[] iElementTypeArray = new IElementType[]{XmlTokenType.XML_COMMENT_CHARACTERS};
        tokenSetArray[1] = TokenSet.create((IElementType[])iElementTypeArray);
        TokenSet tokenSet2 = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"orSet(...)");
        COMMENTS = tokenSet2;
        tokenSetArray = new TokenSet[]{JSTokenTypes.LITERALS};
        TokenSet tokenSet3 = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"orSet(...)");
        LITERALS = tokenSet3;
        tokenSetArray = new TokenSet[3];
        tokenSetArray[0] = JSLexerUtil.SKIP_WORDS_SCAN_SET;
        tokenSetArray[1] = XmlFilterLexer.NO_WORDS_TOKEN_SET;
        iElementTypeArray = new IElementType[]{Angular2HtmlTokenTypes.INTERPOLATION_START, Angular2HtmlTokenTypes.INTERPOLATION_END, Angular2HtmlTokenTypes.EXPANSION_FORM_START, Angular2HtmlTokenTypes.EXPANSION_FORM_END, Angular2HtmlTokenTypes.EXPANSION_FORM_CASE_END, Angular2HtmlTokenTypes.EXPANSION_FORM_CASE_START, XmlTokenType.XML_COMMA, Angular2TokenTypes.ESCAPE_SEQUENCE, Angular2HtmlTokenTypes.EXPANSION_FORM_COMMA, Angular2HtmlTokenTypes.EXPRESSION_WHITE_SPACE};
        tokenSetArray[2] = TokenSet.create((IElementType[])iElementTypeArray);
        TokenSet tokenSet4 = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet4, (String)"orSet(...)");
        SKIP_WORDS = tokenSet4;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/angular2/lang/html/index/Angular2HtmlFilterLexer$Companion;", "", "<init>", "()V", "SUPPORTED_LANGUAGES", "", "Lcom/intellij/lang/Language;", "IDENTIFIERS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "COMMENTS", "LITERALS", "SKIP_WORDS", "intellij.angular"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

