/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.nodejs.execution.NodeProgressUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.npm.NpmNodePackage;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.ProcessOutputCatcher;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class WorkingDirectoryDependentNpmPackageVersionManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(WorkingDirectoryDependentNpmPackageVersionManager.class);
    private static final ExecutorService ourExecutorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)(WorkingDirectoryDependentNpmPackageVersionManager.class.getSimpleName() + " Pool"));
    private static final int TIMEOUT = 30000;
    private final Project myProject;
    private final ConcurrentMap<InputData, VersionInfo> myVersionCache;
    private final ConcurrentMap<InputData, Fetch> myFetchInProgressByPkgMap;
    private final List<ModificationTracker> myModificationTrackers;

    public WorkingDirectoryDependentNpmPackageVersionManager(@NotNull Project project) {
        if (project == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(0);
        }
        this.myVersionCache = new ConcurrentHashMap<InputData, VersionInfo>();
        this.myFetchInProgressByPkgMap = new ConcurrentHashMap<InputData, Fetch>();
        this.myProject = project;
        final SimpleModificationTracker switchedOutModificationTracker = new SimpleModificationTracker();
        this.myModificationTrackers = List.of(switchedOutModificationTracker, VirtualFileManager.getInstance());
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    1.$$$reportNull$$$0(0);
                }
                switchedOutModificationTracker.incModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/javascript/nodejs/npm/WorkingDirectoryDependentNpmPackageVersionManager$1", "applicationDeactivated"));
            }
        });
    }

    public void dispose() {
    }

    @NotNull
    public static WorkingDirectoryDependentNpmPackageVersionManager getInstance(@NotNull Project project) {
        if (project == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(1);
        }
        WorkingDirectoryDependentNpmPackageVersionManager workingDirectoryDependentNpmPackageVersionManager = (WorkingDirectoryDependentNpmPackageVersionManager)project.getService(WorkingDirectoryDependentNpmPackageVersionManager.class);
        if (workingDirectoryDependentNpmPackageVersionManager == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(2);
        }
        return workingDirectoryDependentNpmPackageVersionManager;
    }

    public void fetchVersion(@NotNull NodeJsInterpreter interpreter2, @NotNull NodePackage pkg, @NotNull Consumer<SemVer> versionConsumer) {
        if (interpreter2 == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(3);
        }
        if (pkg == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(4);
        }
        if (versionConsumer == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(5);
        }
        this.fetchVersion(interpreter2, pkg, null, versionConsumer);
    }

    public void fetchVersion(@NotNull NodeJsInterpreter interpreter2, @NotNull NodePackage pkg, @Nullable Path workingDirectory, @NotNull Consumer<SemVer> versionConsumer) {
        if (interpreter2 == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(6);
        }
        if (pkg == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(7);
        }
        if (versionConsumer == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(8);
        }
        this.fetchVersion(interpreter2, pkg, workingDirectory, versionConsumer, version2 -> {});
    }

    @ApiStatus.Internal
    public void fetchVersion(@NotNull NodeJsInterpreter interpreter2, @NotNull NodePackage pkg, @Nullable Path workingDirectory, @NotNull Consumer<SemVer> versionConsumer, @NotNull Consumer<@Nullable SemVer> fullVersionConsumer) {
        if (interpreter2 == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(9);
        }
        if (pkg == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(10);
        }
        if (versionConsumer == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(11);
        }
        if (fullVersionConsumer == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(12);
        }
        if (pkg.isEmptyPath()) {
            versionConsumer.accept(null);
            fullVersionConsumer.accept(null);
            return;
        }
        Path effectiveWorkingDirectory = workingDirectory != null ? workingDirectory : this.getDefaultWorkingDir();
        InputData inputData = new InputData(interpreter2, pkg, effectiveWorkingDirectory.toString());
        VersionInfo info = (VersionInfo)this.myVersionCache.get(inputData);
        NullableLazyValue pkgVersionFromPackageJsonValue = NullableLazyValue.lazyNullable(() -> pkg.getVersion());
        SemVer initialVersion = info != null && info.myPkgVersionInProjectRoot != null ? info.myPkgVersionInProjectRoot : (SemVer)pkgVersionFromPackageJsonValue.getValue();
        versionConsumer.accept(initialVersion);
        if (info != null && info.isModCountsUpToDate() && Objects.equals(pkgVersionFromPackageJsonValue.getValue(), info.myPkgVersionFromPackageJson)) {
            fullVersionConsumer.accept(initialVersion);
            return;
        }
        Fetch newFetch = new Fetch(inputData);
        Fetch prevFetch = this.myFetchInProgressByPkgMap.putIfAbsent(inputData, newFetch);
        Fetch fetch = (Fetch)ObjectUtils.notNull((Object)prevFetch, (Object)newFetch);
        fetch.notifyWhenDone(versionConsumer, initialVersion, fullVersionConsumer);
    }

    @NotNull
    private SemVer fetchProjectVersion(@NotNull NodeJsInterpreter interpreter2, @NotNull NodePackage pkg, @NotNull Path workingDirectory) throws com.intellij.execution.ExecutionException {
        ProcessOutput output;
        if (interpreter2 == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(13);
        }
        if (pkg == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(14);
        }
        if (workingDirectory == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(15);
        }
        if (interpreter2 instanceof NodeJsLocalInterpreter && ((NodeJsLocalInterpreter)interpreter2).isElectron()) {
            throw new com.intellij.execution.ExecutionException("Electron Node.js interpreter is not supported");
        }
        NodeTargetRun targetRun = new NodeTargetRun(interpreter2, this.myProject, null, NodeTargetRunOptions.of(false));
        WorkingDirectoryDependentNpmPackageVersionManager.configureCommandLine(targetRun, pkg, workingDirectory);
        NpmUtil.prepareImplicitPackageManagerRun(targetRun, pkg);
        ProcessWithCmdLine processWithCmdLine = targetRun.startProcessEx();
        long startNano = System.nanoTime();
        try {
            output = new ProcessOutputCatcher((BaseOSProcessHandler)processWithCmdLine.getProcessHandler()).run(null, 30000L);
        }
        catch (com.intellij.execution.ExecutionException e) {
            throw new com.intellij.execution.ExecutionException("Cannot fetch version (" + processWithCmdLine.getCommandLinePresentation() + ")", (Throwable)e);
        }
        String shortInfo = "command: " + processWithCmdLine.getCommandLinePresentation() + ", duration: " + TimeoutUtil.getDurationMillis((long)startNano) + "ms";
        String longInfo = shortInfo + ", " + String.valueOf(output);
        if (output.isTimeout()) {
            throw new com.intellij.execution.ExecutionException("Cannot fetch version: timed out; " + longInfo);
        }
        if (output.getExitCode() != 0) {
            throw new com.intellij.execution.ExecutionException("Cannot fetch version: non-zero exit code; " + longInfo);
        }
        List stdout = output.getStdoutLines(true);
        if (stdout.size() != 1) {
            throw new com.intellij.execution.ExecutionException("Cannot parse version: expected single line, actual lines " + String.valueOf(stdout) + "; " + longInfo);
        }
        SemVer version2 = SemVer.parseFromText((String)StringUtil.trimStart((String)((String)stdout.get(0)), (String)"v"));
        if (version2 == null) {
            throw new com.intellij.execution.ExecutionException("Cannot parse version from '" + (String)stdout.get(0) + "'; " + longInfo);
        }
        LOG.info("Version fetched successfully: " + String.valueOf(version2) + "; " + shortInfo);
        SemVer semVer = version2;
        if (semVer == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(16);
        }
        return semVer;
    }

    private static void configureCommandLine(@NotNull NodeTargetRun targetRun, @NotNull NodePackage npmPkg, @NotNull Path workingDirectory) throws com.intellij.execution.ExecutionException {
        if (targetRun == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(17);
        }
        if (npmPkg == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(18);
        }
        if (workingDirectory == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(19);
        }
        targetRun.setEnableWrappingWithYarnNode(false);
        TargetedCommandLineBuilder commandLine = targetRun.getCommandLineBuilder();
        commandLine.setCharset(StandardCharsets.UTF_8);
        commandLine.setWorkingDirectory(targetRun.path(workingDirectory));
        NpmNodePackage.configureNpmPackage(targetRun, npmPkg, new String[0]);
        commandLine.addParameter("--version");
    }

    @NotNull
    private Path getDefaultWorkingDir() {
        VirtualFile projectRoot = ProjectUtil.guessProjectDir((Project)this.myProject);
        if (projectRoot != null) {
            Path path2 = projectRoot.toNioPath();
            if (path2 == null) {
                WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(20);
            }
            return path2;
        }
        Path path3 = Path.of(SystemProperties.getUserHome(), new String[0]);
        if (path3 == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(21);
        }
        return path3;
    }

    private long @NotNull [] createModCounts() {
        long[] counts = new long[this.myModificationTrackers.size()];
        for (int i = 0; i < this.myModificationTrackers.size(); ++i) {
            counts[i] = this.myModificationTrackers.get(i).getModificationCount();
        }
        if (counts == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(22);
        }
        return counts;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 16, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/WorkingDirectoryDependentNpmPackageVersionManager";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionConsumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullVersionConsumer";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/WorkingDirectoryDependentNpmPackageVersionManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchProjectVersion";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultWorkingDir";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createModCounts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fetchVersion";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fetchProjectVersion";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "configureCommandLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 16, 20, 21, 22 -> new IllegalStateException(string);
        };
    }

    private static class InputData {
        private final NodeJsInterpreter myInterpreter;
        private final NodePackage myPkg;
        private final String myWorkingDirectory;

        private InputData(@NotNull NodeJsInterpreter interpreter2, @NotNull NodePackage pkg, @NotNull String workingDirectory) {
            if (interpreter2 == null) {
                InputData.$$$reportNull$$$0(0);
            }
            if (pkg == null) {
                InputData.$$$reportNull$$$0(1);
            }
            if (workingDirectory == null) {
                InputData.$$$reportNull$$$0(2);
            }
            this.myInterpreter = interpreter2;
            this.myPkg = pkg;
            this.myWorkingDirectory = workingDirectory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InputData data2 = (InputData)o;
            return this.myPkg.equals(data2.myPkg) && this.myWorkingDirectory.equals(data2.myWorkingDirectory);
        }

        public int hashCode() {
            return Objects.hash(this.myPkg, this.myWorkingDirectory);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "interpreter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pkg";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workingDirectory";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/npm/WorkingDirectoryDependentNpmPackageVersionManager$InputData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class VersionInfo {
        private final SemVer myPkgVersionFromPackageJson;
        private final SemVer myPkgVersionInProjectRoot;
        private final long[] myModificationCounts;

        VersionInfo(@Nullable SemVer pkgVersionFromPackageJson, SemVer pkgVersionInProjectRoot) {
            this.myPkgVersionFromPackageJson = pkgVersionFromPackageJson;
            this.myPkgVersionInProjectRoot = pkgVersionInProjectRoot;
            this.myModificationCounts = WorkingDirectoryDependentNpmPackageVersionManager.this.createModCounts();
        }

        boolean isModCountsUpToDate() {
            return Arrays.equals(this.myModificationCounts, WorkingDirectoryDependentNpmPackageVersionManager.this.createModCounts());
        }
    }

    private final class Fetch {
        private final AtomicBoolean myStarted;
        private final FutureTask<SemVer> myFuture;

        private Fetch(InputData inputData) {
            if (inputData == null) {
                Fetch.$$$reportNull$$$0(0);
            }
            this.myStarted = new AtomicBoolean(false);
            this.myFuture = new FutureTask<SemVer>(() -> (SemVer)NodeProgressUtil.withInvisibleProgress(() -> {
                SemVer version2 = null;
                try {
                    version2 = WorkingDirectoryDependentNpmPackageVersionManager.this.fetchProjectVersion(inputData.myInterpreter, inputData.myPkg, Path.of(inputData.myWorkingDirectory, new String[0]));
                }
                catch (Throwable t) {
                    LOG.warn("Failed to fetch version for " + inputData.myPkg.getSystemIndependentPath() + ": " + t.getMessage());
                }
                finally {
                    WorkingDirectoryDependentNpmPackageVersionManager.this.myVersionCache.put(inputData, new VersionInfo(inputData.myPkg.getVersion(), version2));
                    WorkingDirectoryDependentNpmPackageVersionManager.this.myFetchInProgressByPkgMap.remove(inputData);
                }
                return version2;
            }));
        }

        public void notifyWhenDone(@NotNull Consumer<SemVer> consumer, @Nullable SemVer initialVersion, @NotNull Consumer<@Nullable SemVer> fullVersionConsumer) {
            if (consumer == null) {
                Fetch.$$$reportNull$$$0(1);
            }
            if (fullVersionConsumer == null) {
                Fetch.$$$reportNull$$$0(2);
            }
            if (this.myStarted.compareAndSet(false, true)) {
                ourExecutorService.execute(this.myFuture);
            }
            ourExecutorService.execute(() -> {
                SemVer version2 = null;
                try {
                    version2 = this.myFuture.get();
                }
                catch (InterruptedException e) {
                    LOG.warn("Fetch interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.warn("Unexpected exception", (Throwable)e);
                }
                finally {
                    if (!Objects.equals(initialVersion, version2)) {
                        consumer.accept(version2);
                    }
                    fullVersionConsumer.accept(version2);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullVersionConsumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/npm/WorkingDirectoryDependentNpmPackageVersionManager$Fetch";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyWhenDone";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

