/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ecmascript6.psi.impl.JSNodeModulesHandlerScope;
import com.intellij.lang.javascript.config.JSFileInclude;
import com.intellij.lang.javascript.config.graph.JSConfigGraphCache;
import com.intellij.lang.javascript.config.graph.JSImportGraph;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.modules.JSNodeModuleStructure;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptImportScope
extends JSNodeModulesHandlerScope {
    @Nullable
    private final TypeScriptConfig myConfig;
    @NotNull
    private final Collection<VirtualFile> myReferences;
    @NotNull
    private final Map<VirtualFile, TypeScriptConfig> myConfigs;
    @NotNull
    private final TypeScriptConfigService myService;
    @Nullable
    private final JSImportGraph myGraph;
    private final boolean myCheckProjectReferences;

    @NotNull
    private static Collection<VirtualFile> getReferencedProjectsRecursive(@NotNull TypeScriptConfig config, @NotNull TypeScriptConfigService service) {
        if (config == null) {
            TypeScriptImportScope.$$$reportNull$$$0(0);
        }
        if (service == null) {
            TypeScriptImportScope.$$$reportNull$$$0(1);
        }
        Collection<VirtualFile> references = config.getReferences();
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(references.size() + 1);
        result2.add(config.getConfigFile());
        ArrayDeque<VirtualFile> stack = new ArrayDeque<VirtualFile>(references);
        while (!stack.isEmpty()) {
            TypeScriptConfig currentConfig;
            VirtualFile el = stack.pop();
            if (!result2.add(el) || (currentConfig = service.parseConfigFile(el)) == null) continue;
            stack.addAll(currentConfig.getReferences());
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            TypeScriptImportScope.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    public TypeScriptImportScope(@NotNull Project project, @NotNull VirtualFile contextFile, @NotNull GlobalSearchScope baseScope) {
        if (project == null) {
            TypeScriptImportScope.$$$reportNull$$$0(3);
        }
        if (contextFile == null) {
            TypeScriptImportScope.$$$reportNull$$$0(4);
        }
        if (baseScope == null) {
            TypeScriptImportScope.$$$reportNull$$$0(5);
        }
        super(project, contextFile, baseScope, JSModuleStatusOwner.ModuleStatus.ES6);
        this.myConfigs = new HashMap<VirtualFile, TypeScriptConfig>();
        this.myService = TypeScriptConfigService.Provider.get(project);
        this.myConfig = this.myService.getPreferableConfig(contextFile);
        if (this.myConfig != null && (this.myConfig.isComposite() || this.myConfig.hasReferences())) {
            this.myCheckProjectReferences = true;
            this.myReferences = TypeScriptImportScope.getReferencedProjectsRecursive(this.myConfig, this.myService);
            this.myGraph = JSConfigGraphCache.getService(project).getGraph(this.myConfig).initialize();
        } else {
            this.myReferences = Collections.emptyList();
            this.myCheckProjectReferences = false;
            this.myGraph = null;
        }
    }

    @Override
    protected boolean isAcceptableProjectFile(@NotNull VirtualFile toCheck) {
        if (toCheck == null) {
            TypeScriptImportScope.$$$reportNull$$$0(6);
        }
        if (!this.myCheckProjectReferences || this.myConfig == null || TypeScriptUtil.isDefinitionFile(toCheck)) {
            return true;
        }
        if (this.myGraph == null || this.myGraph.containsFile(toCheck)) {
            return true;
        }
        VirtualFile currentConfig = this.myConfig.getConfigFile();
        VirtualFile configCandidate = TypeScriptConfigUtil.getParentConfigWithName(toCheck, "tsconfig.json");
        if (configCandidate == null || currentConfig.equals(configCandidate)) {
            return true;
        }
        if (this.myReferences.isEmpty()) {
            return false;
        }
        TypeScriptConfig config = this.myConfigs.computeIfAbsent(configCandidate, this.myService::parseConfigFile);
        if (config == null) {
            return true;
        }
        JSFileInclude include = config.getInclude();
        if (include.accept(toCheck) && this.myReferences.contains(configCandidate)) {
            return true;
        }
        return this.isSymlinkedNodeModule(toCheck, config);
    }

    @Override
    protected boolean isAcceptableNodeModulesFile(@NotNull VirtualFile toCheck, @NotNull JSNodeModuleStructure structure) {
        if (toCheck == null) {
            TypeScriptImportScope.$$$reportNull$$$0(7);
        }
        if (structure == null) {
            TypeScriptImportScope.$$$reportNull$$$0(8);
        }
        if (!super.isAcceptableNodeModulesFile(toCheck, structure)) {
            if (this.myConfig != null) {
                return this.checkConfigDirectInclude(toCheck);
            }
            return false;
        }
        return TypeScriptUtil.isDefinitionFile(toCheck) || this.checkConfigDirectInclude(toCheck);
    }

    private boolean checkConfigDirectInclude(@NotNull VirtualFile toCheck) {
        TypeScriptConfig config;
        if (toCheck == null) {
            TypeScriptImportScope.$$$reportNull$$$0(9);
        }
        if ((config = this.myConfig) == null) {
            return false;
        }
        return config.isIncludedFile(toCheck, false) || config.isFromFileList(toCheck);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptImportScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCheck";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptImportScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedProjectsRecursive";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedProjectsRecursive";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableProjectFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableNodeModulesFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkConfigDirectInclude";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

