/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementInteractivity;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionKeyword;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSKeywordInsertHandlerBase;
import com.intellij.lang.javascript.completion.JSKeywordInsertHandlers;
import com.intellij.lang.javascript.completion.JSKeywordTemplateInsertHandlers;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeofType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.polySymbols.PolySymbolQualifiedKind;
import com.intellij.polySymbols.completion.PolySymbolsCompletionProviderBase;
import com.intellij.polySymbols.js.JsSymbolKinds;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSKeywordsCompletionProvider
extends CompletionProvider<CompletionParameters>
implements DumbAware {
    public static final JSCompletionKeyword[] TYPE_LITERAL_VALUES = new JSCompletionKeyword[]{JSCompletionKeyword.TRUE, JSCompletionKeyword.FALSE, JSCompletionKeyword.NULL};
    private static final JSCompletionKeyword[] KEYWORDS_FOLLOWED_NOT_ONLY_BY_SPACE = new JSCompletionKeyword[]{JSCompletionKeyword.TRUE, JSCompletionKeyword.FALSE, JSCompletionKeyword.NULL, JSCompletionKeyword.DEBUGGER};
    private static final JSCompletionKeyword[] DEFAULT_KEYWORDS_WITH_WHITESPACE = new JSCompletionKeyword[]{JSCompletionKeyword.DELETE, JSCompletionKeyword.NEW, JSCompletionKeyword.THROW, JSCompletionKeyword.TYPEOF, JSCompletionKeyword.VAR, JSCompletionKeyword.VOID};

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(2);
        }
        if (PolySymbolsCompletionProviderBase.isFurtherCodeCompletionPreventedFor((CompletionParameters)parameters2, (PolySymbolQualifiedKind[])new PolySymbolQualifiedKind[]{JsSymbolKinds.JS_KEYWORDS})) {
            return;
        }
        PsiFile containingFile = parameters2.getPosition().getContainingFile().getOriginalFile();
        List<Object> variants = containingFile instanceof JSExpressionCodeFragment ? ((JSExpressionCodeFragment)containingFile).getTopLevelVariants(parameters2.getPosition()) : JSKeywordsCompletionProvider.getDefaultKeywordVariants(parameters2.getPosition());
        ArrayList<LookupElement> lookupElements = new ArrayList<LookupElement>(variants.size());
        for (Object variant : variants) {
            lookupElements.add(JSLookupUtilImpl.toBoldLookupElement(variant));
        }
        result2.addAllElements(lookupElements);
    }

    @NotNull
    public static List<LookupElement> getDefaultKeywordVariants(@NotNull PsiElement context2) {
        KeywordCompletionConsumer consumer;
        if (context2 == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(3);
        }
        ArrayList<Trinity<JSCompletionKeyword, JSLookupPriority, Boolean>> keywords = new ArrayList<Trinity<JSCompletionKeyword, JSLookupPriority, Boolean>>();
        JSCompletionKeywordsContributor contributor = JSHandlersFactory.forElement(context2).newCompletionKeywordsContributor();
        if (!contributor.process(consumer = JSKeywordsCompletionProvider.createKeywordConsumer(keywords), context2)) {
            return JSKeywordsCompletionProvider.createKeywordItems(keywords, context2);
        }
        PsiElement parent = context2.getParent();
        if (JSKeywordsCompletionProvider.isNoKeywordsContext(context2, parent)) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (JSKeywordsCompletionProvider.isCaseClauseContext(context2, parent)) {
            JSKeywordsCompletionProvider.appendCaseKeywords(keywords);
            return JSKeywordsCompletionProvider.createKeywordItems(keywords, context2);
        }
        CommonCodeStyleSettings commonSettings = JSCodeStyleSettings.getCommonSettings(context2);
        PsiElement grandParent = parent.getParent();
        if (parent instanceof JSReferenceExpression) {
            if (((JSReferenceExpression)parent).getQualifier() != null || parent.textContains('.') || parent.textContains(':')) {
                List<LookupElement> list = Collections.emptyList();
                if (list == null) {
                    JSKeywordsCompletionProvider.$$$reportNull$$$0(5);
                }
                return list;
            }
            if (grandParent instanceof JSNewExpression) {
                boolean appendSpace = JSCodeStyleSettings.getSettings((PsiElement)context2).SPACE_BEFORE_FUNCTION_LEFT_PARENTH;
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, appendSpace, JSCompletionKeyword.FUNCTION);
                return JSKeywordsCompletionProvider.createKeywordItems(keywords, context2);
            }
            if (grandParent instanceof JSStatement && JSKeywordsCompletionProvider.isStatementContext(parent, grandParent)) {
                if (grandParent instanceof JSDoWhileStatement) {
                    boolean appendSpace = commonSettings.SPACE_BEFORE_WHILE_PARENTHESES;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, JSCompletionKeyword.WHILE);
                    return JSKeywordsCompletionProvider.createKeywordItems(keywords, context2);
                }
                PsiElement prevStatement = PsiTreeUtil.getPrevSiblingOfType((PsiElement)grandParent, JSStatement.class);
                if (prevStatement instanceof JSIfStatement) {
                    appendSpace = commonSettings.SPACE_BEFORE_ELSE_LBRACE;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, JSCompletionKeyword.ELSE);
                } else if (prevStatement instanceof JSTryStatement) {
                    appendSpace = commonSettings.SPACE_BEFORE_CATCH_PARENTHESES;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, JSCompletionKeyword.CATCH);
                    appendSpace = commonSettings.SPACE_BEFORE_FINALLY_LBRACE;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, JSCompletionKeyword.FINALLY);
                }
                if (grandParent instanceof JSExpressionStatement) {
                    PsiElement grandParentParent;
                    PsiElement prevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent);
                    if (prevSibling != null && prevSibling.getNode().getElementType() == JSTokenTypes.ELSE_KEYWORD) {
                        boolean appendSpace = commonSettings.SPACE_BEFORE_IF_PARENTHESES;
                        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, JSCompletionKeyword.IF);
                    }
                    if ((grandParentParent = grandParent.getParent()) instanceof JSCaseClause) {
                        JSKeywordsCompletionProvider.appendCaseKeywords(keywords);
                    }
                    if (grandParentParent instanceof JSForStatement) {
                        if (prevSibling instanceof PsiErrorElement) {
                            prevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prevSibling);
                        }
                        if (prevSibling instanceof JSVarStatement) {
                            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.OF, JSCompletionKeyword.IN);
                            return JSKeywordsCompletionProvider.createKeywordItems(keywords, context2);
                        }
                    } else if (JSKeywordsCompletionProvider.isContextForOperation((JSReferenceExpression)parent)) {
                        return JSKeywordsCompletionProvider.getVariantsForOperation(context2, keywords);
                    }
                }
            } else {
                if (grandParent instanceof JSEmbeddedContent && JSKeywordsCompletionProvider.isContextForOperation((JSReferenceExpression)parent)) {
                    return JSKeywordsCompletionProvider.getVariantsForOperation(context2, keywords);
                }
                if (JSKeywordsCompletionProvider.isES6ShortHandedProperty(parent, grandParent)) {
                    List<LookupElement> list = Collections.emptyList();
                    if (list == null) {
                        JSKeywordsCompletionProvider.$$$reportNull$$$0(6);
                    }
                    return list;
                }
                JSKeywordsCompletionProvider.appendExpressionKeywords(keywords, commonSettings, grandParent);
                contributor.appendExpressionContextKeywords(consumer, context2, grandParent);
                return JSKeywordsCompletionProvider.createKeywordItems(keywords, context2);
            }
        }
        if (JSKeywordsCompletionProvider.isEmbeddedContentExpression(grandParent)) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, TYPE_LITERAL_VALUES);
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, JSCompletionKeyword.INT, JSCompletionKeyword.UINT);
            return JSKeywordsCompletionProvider.createKeywordItems(keywords, context2);
        }
        boolean isLoop = JSKeywordsCompletionProvider.isLoopContext(grandParent);
        if (isLoop) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, JSCompletionKeyword.CONTINUE);
        }
        if (isLoop || JSKeywordsCompletionProvider.isCaseClauseBodyContext(grandParent)) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, JSCompletionKeyword.BREAK);
        }
        if (JSKeywordsCompletionProvider.isFunctionBodyStatementContext(grandParent)) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.LOCAL_SCOPE_MAX_PRIORITY_EXOTIC, false, JSCompletionKeyword.RETURN);
        }
        if (JSKeywordsCompletionProvider.isThisOwnerContext(grandParent)) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, JSCompletionKeyword.THIS);
        }
        PsiElement sibling = PsiTreeUtil.prevVisibleLeaf((PsiElement)parent);
        JSKeywordsCompletionProvider.appendEachKeyword(keywords, commonSettings, sibling);
        if (sibling != null && sibling.getNode().getElementType() == JSTokenTypes.LPAR && grandParent instanceof JSForStatement) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, true, JSCompletionKeyword.VAR);
            if (DialectDetector.hasFeature(parent, JSLanguageFeature.CONST_DEFINITIONS)) {
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, true, JSCompletionKeyword.CONST);
            }
            if (DialectDetector.hasFeature(parent, JSLanguageFeature.LET_DEFINITIONS)) {
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, true, JSCompletionKeyword.LET);
            }
            return JSKeywordsCompletionProvider.createKeywordItems(keywords, context2);
        }
        JSKeywordsCompletionProvider.appendDefaultKeywords(keywords, context2, commonSettings);
        contributor.appendSpecificKeywords(consumer, context2, grandParent);
        return JSKeywordsCompletionProvider.createKeywordItems(keywords, context2);
    }

    @NotNull
    private static List<LookupElement> getVariantsForOperation(@NotNull PsiElement context2, List<Trinity<JSCompletionKeyword, JSLookupPriority, Boolean>> keywords) {
        if (context2 == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(7);
        }
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.IN);
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.INSTANCEOF);
        if (DialectDetector.isTypeScript(context2)) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.AS);
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.SATISFIES);
        }
        return JSKeywordsCompletionProvider.createKeywordItems(keywords, context2);
    }

    private static void appendEachKeyword(@NotNull List<Trinity<JSCompletionKeyword, JSLookupPriority, Boolean>> keywords, @NotNull CommonCodeStyleSettings commonSettings, @Nullable PsiElement sibling) {
        if (keywords == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(8);
        }
        if (commonSettings == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(9);
        }
        if (sibling != null && DialectDetector.hasFeature(sibling, JSLanguageFeature.FOR_EACH) && sibling.getNode().getElementType() == JSTokenTypes.FOR_KEYWORD) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, commonSettings.SPACE_BEFORE_FOR_PARENTHESES, JSCompletionKeyword.EACH);
        }
    }

    private static void appendExpressionKeywords(@NotNull List<Trinity<JSCompletionKeyword, JSLookupPriority, Boolean>> keywords, @NotNull CommonCodeStyleSettings commonSettings, @Nullable PsiElement grandParent) {
        if (keywords == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(10);
        }
        if (commonSettings == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(11);
        }
        boolean isComparison = JSKeywordsCompletionProvider.isComparisonContext(grandParent);
        boolean isAssignment = JSKeywordsCompletionProvider.isAssignmentContext(grandParent);
        JSLookupPriority priority = JSLookupPriority.KEYWORDS_PRIORITY;
        JSKeywordsCompletionProvider.appendKeywords(keywords, priority, false, TYPE_LITERAL_VALUES);
        JSKeywordsCompletionProvider.appendKeywords(keywords, priority, false, JSCompletionKeyword.THIS);
        if (isAssignment || !isComparison) {
            boolean appendSpace = commonSettings.SPACE_BEFORE_METHOD_PARENTHESES;
            JSKeywordsCompletionProvider.appendKeywords(keywords, priority, appendSpace, JSCompletionKeyword.FUNCTION);
        }
        JSKeywordsCompletionProvider.appendKeywords(keywords, priority, true, JSCompletionKeyword.TYPEOF);
        if (isAssignment || !isComparison) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, priority, true, JSCompletionKeyword.NEW);
        }
        if (isAssignment || !isComparison) {
            if (grandParent instanceof JSArgumentList) {
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.VOID);
            } else {
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.VOID, JSCompletionKeyword.DELETE);
            }
        }
    }

    private static boolean isStatementContext(@NotNull PsiElement parent, @NotNull PsiElement grandParent) {
        if (parent == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(12);
        }
        if (grandParent == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(13);
        }
        if (grandParent instanceof JSConditionOwner && ((JSConditionOwner)grandParent).getCondition() == parent) {
            return false;
        }
        if (grandParent instanceof JSSwitchStatement && ((JSSwitchStatement)grandParent).getSwitchExpression() == parent) {
            return false;
        }
        if (grandParent instanceof JSThrowStatement && ((JSThrowStatement)grandParent).getExpression() == parent) {
            return false;
        }
        if (grandParent instanceof JSReturnStatement && ((JSReturnStatement)grandParent).getExpression() == parent) {
            return false;
        }
        return !(grandParent instanceof JSForInStatement) || ((JSForInStatement)grandParent).getCollectionExpression() != parent;
    }

    @NotNull
    private static KeywordCompletionConsumer createKeywordConsumer(final List<Trinity<JSCompletionKeyword, JSLookupPriority, Boolean>> keywords) {
        return new KeywordCompletionConsumer(){

            @Override
            public void consume(JSLookupPriority priority, boolean appendSpaces, JSCompletionKeyword ... contributorKeywords) {
                JSKeywordsCompletionProvider.appendKeywords(keywords, priority, appendSpaces, contributorKeywords);
            }
        };
    }

    private static boolean isComparisonContext(@Nullable PsiElement grandParent) {
        return grandParent instanceof JSBinaryExpression && JSTokenTypes.EQUALITY_OPERATIONS.contains(((JSBinaryExpression)grandParent).getOperationSign());
    }

    private static boolean isAssignmentContext(@Nullable PsiElement grandParent) {
        return grandParent instanceof JSArgumentList || grandParent instanceof JSBinaryExpression && ((JSBinaryExpression)grandParent).getOperationSign() == JSTokenTypes.EQ;
    }

    public static boolean isContextForOperation(@NotNull JSReferenceExpression dummyIdentifier) {
        if (dummyIdentifier == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(14);
        }
        JSReferenceExpression parent = dummyIdentifier;
        PsiElement prev = parent.getPrevSibling();
        while (true) {
            if (prev instanceof PsiWhiteSpace && prev.textContains('\n')) {
                return false;
            }
            if (prev != null && !(prev instanceof PsiWhiteSpace) && !(prev instanceof PsiComment)) break;
            if (prev == null) {
                if ((parent = parent.getParent()) == null || parent instanceof PsiFile) {
                    return false;
                }
                prev = parent.getPrevSibling();
                continue;
            }
            prev = prev.getPrevSibling();
        }
        for (PsiElement last = PsiTreeUtil.getDeepestVisibleLast((PsiElement)prev); last != null && last != prev; last = last.getParent()) {
            if (!(last instanceof JSExpression)) continue;
            return true;
        }
        return false;
    }

    private static void appendDefaultKeywords(@NotNull List<Trinity<JSCompletionKeyword, JSLookupPriority, Boolean>> keywords, @NotNull PsiElement context2, @NotNull CommonCodeStyleSettings commonSettings) {
        if (keywords == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(15);
        }
        if (context2 == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(16);
        }
        if (commonSettings == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(17);
        }
        ArrayList withoutSpace = new ArrayList(30);
        ContainerUtil.addAll(withoutSpace, (Object[])KEYWORDS_FOLLOWED_NOT_ONLY_BY_SPACE);
        ArrayList<JSCompletionKeyword> withSpace = new ArrayList<JSCompletionKeyword>(20);
        ContainerUtil.addAll(withSpace, (Object[])DEFAULT_KEYWORDS_WITH_WHITESPACE);
        (commonSettings.SPACE_BEFORE_WHILE_PARENTHESES ? withSpace : withoutSpace).add(JSCompletionKeyword.WHILE);
        (commonSettings.SPACE_BEFORE_DO_LBRACE ? withSpace : withoutSpace).add(JSCompletionKeyword.DO);
        (commonSettings.SPACE_BEFORE_FOR_PARENTHESES ? withSpace : withoutSpace).add(JSCompletionKeyword.FOR);
        (JSCodeStyleSettings.getSettings((PsiElement)context2).SPACE_BEFORE_FUNCTION_LEFT_PARENTH ? withSpace : withoutSpace).add(JSCompletionKeyword.FUNCTION);
        (commonSettings.SPACE_BEFORE_IF_PARENTHESES ? withSpace : withoutSpace).add(JSCompletionKeyword.IF);
        (commonSettings.SPACE_BEFORE_TRY_LBRACE ? withSpace : withoutSpace).add(JSCompletionKeyword.TRY);
        (commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES ? withSpace : withoutSpace).add(JSCompletionKeyword.SWITCH);
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, (JSCompletionKeyword[])withoutSpace.toArray(JSCompletionKeyword[]::new));
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, (JSCompletionKeyword[])withSpace.toArray(JSCompletionKeyword[]::new));
        keywords.add((Trinity<JSCompletionKeyword, JSLookupPriority, Boolean>)Trinity.create((Object)((Object)JSCompletionKeyword.WITH), (Object)((Object)JSLookupPriority.LOWEST_PRIORITY), (Object)true));
    }

    private static boolean isCaseClauseContext(@NotNull PsiElement context2, @Nullable PsiElement parent) {
        if (context2 == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(18);
        }
        return parent instanceof JSCaseClause && SyntaxTraverser.psiTraverser().children((Object)parent).filter(Conditions.not((Condition)Conditions.instanceOf((Class[])new Class[]{PsiErrorElement.class, PsiWhiteSpace.class}))).first() == context2;
    }

    private static boolean isCaseClauseBodyContext(@Nullable PsiElement context2) {
        return PsiTreeUtil.getParentOfType((PsiElement)context2, JSCaseClause.class) != null;
    }

    private static boolean isLoopContext(@Nullable PsiElement context2) {
        return PsiTreeUtil.getParentOfType((PsiElement)context2, JSLoopStatement.class) != null;
    }

    private static boolean isFunctionBodyStatementContext(@Nullable PsiElement grandParent) {
        return grandParent instanceof JSExpressionStatement && PsiTreeUtil.getParentOfType((PsiElement)grandParent, JSFunction.class) != null;
    }

    private static boolean isThisOwnerContext(@Nullable PsiElement parent) {
        if (PsiTreeUtil.getParentOfType((PsiElement)parent, TypeScriptEnum.class, (boolean)true, (Class[])new Class[]{TypeScriptFunction.class, TypeScriptModule.class, TypeScriptClass.class, JSObjectLiteralExpression.class}) != null) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)parent, TypeScriptModule.class) == null) {
            return true;
        }
        JSPsiElementBase parentFunction = JSPsiImplUtils.getParentFunctionThroughLambdas(parent);
        if (parentFunction == null) {
            parentFunction = (JSPsiElementBase)PsiTreeUtil.getParentOfType((PsiElement)parent, JSField.class);
        }
        return parentFunction != null;
    }

    private static boolean isNoKeywordsContext(@NotNull PsiElement context2, PsiElement parent) {
        if (context2 == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(19);
        }
        return parent instanceof JSBreakStatement || parent instanceof JSContinueStatement || parent instanceof JSLiteralExpression || parent instanceof JSProperty || parent instanceof JSVariable || parent instanceof XmlAttribute || parent instanceof XmlAttributeValue || parent instanceof JSFunction && ((JSFunction)parent).getNameIdentifier() == context2 || parent instanceof JSClass && ((JSClass)parent).getNameIdentifier() == context2 || parent instanceof TypeScriptModule && ((TypeScriptModule)parent).getNameIdentifier() == context2 || JSTokenTypes.STRING_LITERALS.contains(context2.getNode().getElementType()) || PsiTreeUtil.getNonStrictParentOfType((PsiElement)context2, (Class[])new Class[]{PsiComment.class}) != null || PsiTreeUtil.getNonStrictParentOfType((PsiElement)context2, (Class[])new Class[]{JSAttribute.class}) != null || parent instanceof JSReferenceExpression && (JSResolveUtil.isSelfReference(parent) || parent.getParent() instanceof TypeScriptTypeofType) || parent != null && JSKeywordsCompletionProvider.isJustAfterLiteral(parent);
    }

    private static boolean isJustAfterLiteral(@NotNull PsiElement parent) {
        PsiElement leaf;
        if (parent == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(20);
        }
        if ((leaf = PsiTreeUtil.prevLeaf((PsiElement)parent)) instanceof PsiErrorElement) {
            leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf);
        }
        return leaf != null && JSTokenTypes.LITERALS.contains(PsiUtilCore.getElementType((PsiElement)leaf));
    }

    private static boolean isES6ShortHandedProperty(PsiElement parent, PsiElement grandParent) {
        return grandParent instanceof JSProperty && ((JSProperty)grandParent).getNameIdentifier() == parent;
    }

    private static boolean isEmbeddedContentExpression(PsiElement grandParent) {
        ASTNode grandParentNode;
        return grandParent instanceof JSEmbeddedContent && (grandParentNode = grandParent.getNode()) != null && grandParentNode.getElementType() == JSStubElementTypes.EMBEDDED_EXPRESSION;
    }

    private static void appendCaseKeywords(List<? super Trinity<JSCompletionKeyword, JSLookupPriority, Boolean>> keywords) {
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.CASE);
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, JSCompletionKeyword.DEFAULT);
    }

    public static void appendKeywords(List<? super Trinity<JSCompletionKeyword, JSLookupPriority, Boolean>> keywords, @NotNull JSLookupPriority priority, boolean appendSpace, JSCompletionKeyword ... names) {
        if (priority == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(21);
        }
        for (JSCompletionKeyword name : names) {
            keywords.add((Trinity<JSCompletionKeyword, JSLookupPriority, Boolean>)Trinity.create((Object)((Object)name), (Object)((Object)priority), (Object)appendSpace));
        }
    }

    @NotNull
    private static List<LookupElement> createKeywordItems(@NotNull List<Trinity<JSCompletionKeyword, JSLookupPriority, Boolean>> keywords, @NotNull PsiElement context2) {
        if (keywords == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(22);
        }
        if (context2 == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(23);
        }
        HashMap<JSCompletionKeyword, Pair> keywordsMap = new HashMap<JSCompletionKeyword, Pair>();
        for (Trinity<JSCompletionKeyword, JSLookupPriority, Boolean> keyword : keywords) {
            Pair oldKeywordValue = (Pair)keywordsMap.get(keyword.first);
            if (oldKeywordValue != null && ((JSLookupPriority)((Object)oldKeywordValue.first)).compareTo((JSLookupPriority)((Object)keyword.second)) >= 0) continue;
            keywordsMap.put((JSCompletionKeyword)((Object)keyword.first), Pair.create((Object)((Object)((JSLookupPriority)((Object)keyword.second))), (Object)((Boolean)keyword.third)));
        }
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>(keywordsMap.size() * 2);
        for (Map.Entry entry : keywordsMap.entrySet()) {
            JSCompletionKeyword option = (JSCompletionKeyword)((Object)entry.getKey());
            InsertHandler<LookupElement> insertHandler = JSKeywordsCompletionProvider.getInsertHandler(option, (Boolean)((Pair)entry.getValue()).second);
            LookupElementBuilder element2 = LookupElementBuilder.create((Object)((Object)option)).withBoldness(true).withInsertHandler(insertHandler);
            LookupElement item = JSCompletionUtil.withJSLookupPriority((LookupElement)element2, (JSLookupPriority)((Object)((Pair)entry.getValue()).first));
            if (insertHandler instanceof JSKeywordInsertHandlerBase) {
                item.putUserData(LookupElementInteractivity.KEY, (Object)LookupElementInteractivity.ALWAYS);
            }
            result2.add(item);
            Pair<String, InsertHandler<LookupElement>> additionalElementData = JSKeywordTemplateInsertHandlers.getAdditionalKeywordElementData(option, context2);
            if (additionalElementData == null) continue;
            LookupElementBuilder additionalElementBuilder = LookupElementBuilder.create((Object)((Object)option)).withBoldness(true).withTailText((String)additionalElementData.first, true).withInsertHandler((InsertHandler)additionalElementData.second);
            LookupElement additionalElement = JSCompletionUtil.withJSLookupPriority((LookupElement)additionalElementBuilder, (JSLookupPriority)((Object)((Pair)entry.getValue()).first));
            if (additionalElementData.second instanceof JSKeywordInsertHandlerBase) {
                additionalElement.putUserData(LookupElementInteractivity.KEY, (Object)LookupElementInteractivity.ALWAYS);
            }
            result2.add(additionalElement);
        }
        ArrayList<LookupElement> arrayList = result2;
        if (arrayList == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    private static InsertHandler<LookupElement> getInsertHandler(@NotNull JSCompletionKeyword option, boolean addSpaceByDefault) {
        InsertHandler<LookupElement> handlerForKeyword;
        if (option == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(25);
        }
        if ((handlerForKeyword = JSKeywordInsertHandlers.INSTANCE.getInsertHandlerForKeyword(option)) != null) {
            InsertHandler<LookupElement> insertHandler = handlerForKeyword;
            if (insertHandler == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(26);
            }
            return insertHandler;
        }
        if (addSpaceByDefault) {
            InsertHandler insertHandler = AddSpaceInsertHandler.INSTANCE;
            if (insertHandler == null) {
                JSKeywordsCompletionProvider.$$$reportNull$$$0(27);
            }
            return insertHandler;
        }
        InsertHandler<LookupElement> insertHandler = JSInsertHandler.DEFAULT;
        if (insertHandler == null) {
            JSKeywordsCompletionProvider.$$$reportNull$$$0(28);
        }
        return insertHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 24, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 16: 
            case 18: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider";
                break;
            }
            case 8: 
            case 10: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywords";
                break;
            }
            case 9: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grandParent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dummyIdentifier";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultKeywordVariants";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeywordItems";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultKeywordVariants";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVariantsForOperation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendEachKeyword";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendExpressionKeywords";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isStatementContext";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isContextForOperation";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "appendDefaultKeywords";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCaseClauseContext";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isNoKeywordsContext";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isJustAfterLiteral";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "appendKeywords";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createKeywordItems";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getInsertHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 24, 26, 27, 28 -> new IllegalStateException(string);
        };
    }
}

