/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.lang.javascript.findUsages.JavaScriptGroupRuleProviderBase;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IconManager;
import com.intellij.usages.PsiNamedElementUsageGroupBase;
import com.intellij.usages.UsageGroup;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;

final class JavaScriptFunctionGroupRuleProvider
extends JavaScriptGroupRuleProviderBase<JSFunction> {
    JavaScriptFunctionGroupRuleProvider() {
    }

    @Override
    protected Class<? extends JSNamedElement> getUsageClass() {
        return JSFunction.class;
    }

    @Override
    protected UsageGroup createUsageGroup(JSFunction jsFunction) {
        PsiElement context2;
        String name = jsFunction.getName();
        if (name == null && (context2 = jsFunction.getContainingFile().getContext()) != null) {
            PsiNamedElement parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlAttribute.class);
            if (parent == null) {
                parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)context2, XmlTag.class);
            }
            if (parent != null) {
                return new PsiNamedElementUsageGroupBase(parent, PlatformIcons.XML_TAG_ICON);
            }
        }
        return new FunctionUsageGroup(jsFunction);
    }

    @Override
    protected UsageGroup createUsageGroupForElement(PsiElement psiElement) {
        UsageGroup usageGroupForElement = super.createUsageGroupForElement(psiElement);
        if (usageGroupForElement == null) {
            usageGroupForElement = (UsageGroup)ActionScriptResolveUtil.computeIfInsideAnonymousEventHandler(psiElement, jsFunctionExpression -> this.createUsageGroup((JSFunction)jsFunctionExpression));
        }
        return usageGroupForElement;
    }

    private static class FunctionUsageGroup
    extends PsiNamedElementUsageGroupBase<JSFunction> {
        private String myAnonymousName;

        FunctionUsageGroup(@NotNull JSFunction function) {
            if (function == null) {
                FunctionUsageGroup.$$$reportNull$$$0(0);
            }
            super((PsiNamedElement)function, IconManager.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Method));
            String name = super.getPresentableName();
            if (JSFormatUtil.getAnonymousElementPresentation().equals(name)) {
                JSFunction current = function;
                while (current != null && this.myAnonymousName == null) {
                    String qualifiedName;
                    current = current.getParent();
                    JSQualifiedNamedElement qualifier = null;
                    if (current instanceof JSQualifiedNamedElement) {
                        qualifier = current;
                    } else if (current instanceof JSAssignmentExpression) {
                        qualifier = ((JSAssignmentExpression)((Object)current)).getDefinitionExpression();
                    }
                    if (qualifier == null || (qualifiedName = qualifier.getQualifiedName()) == null) continue;
                    this.myAnonymousName = name + " in " + qualifiedName;
                }
            }
        }

        @NotNull
        public String getPresentableGroupText() {
            String string = this.getPresentableName();
            if (string == null) {
                FunctionUsageGroup.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        @NlsSafe
        public String getPresentableName() {
            String name = super.getPresentableName();
            if (JSFormatUtil.getAnonymousElementPresentation().equals(name) && this.myAnonymousName != null) {
                String string = this.myAnonymousName;
                if (string == null) {
                    FunctionUsageGroup.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = name;
            if (string == null) {
                FunctionUsageGroup.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/findUsages/JavaScriptFunctionGroupRuleProvider$FunctionUsageGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/findUsages/JavaScriptFunctionGroupRuleProvider$FunctionUsageGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableGroupText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

