/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.index.JSItemPresentationProvider;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSDocOwner;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.CompositeRootCollection;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitPrototypeElement;
import com.intellij.lang.typescript.library.TypeScriptLibraries;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSItemPresentation
implements ColoredItemPresentation {
    public static final String TYPESCRIPT_PACKAGE = "typescript";
    private static final int LENGTH_LIMIT = 30;
    @NotNull
    private final PsiNamedElement myElement;
    private static final String NODE_MODULES = "node_modules/";
    private static final String NODE_TYPES = "node_modules/@types/";

    public JSItemPresentation(@NotNull PsiNamedElement element2) {
        if (element2 == null) {
            JSItemPresentation.$$$reportNull$$$0(0);
        }
        this.myElement = element2;
    }

    public String getPresentableText() {
        Object postfix = (String)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)this.myElement, () -> {
            if (this.myElement instanceof JSFunctionItem) {
                return !DumbService.isDumb((Project)this.myElement.getProject()) ? JSFormatUtil.buildFunctionSignaturePresentation((JSFunctionItem)this.myElement) : "";
            }
            PsiNamedElement patt3546$temp = this.myElement;
            if (patt3546$temp instanceof JSTypeDeclarationOwner) {
                JSType jsType;
                JSTypeDeclarationOwner typeDeclarationOwner = (JSTypeDeclarationOwner)patt3546$temp;
                PsiElement typeElement = typeDeclarationOwner.getTypeElement();
                String typeText = null;
                if (typeElement instanceof JSTypeDeclaration) {
                    JSTypeDeclaration typeDeclaration = (JSTypeDeclaration)typeElement;
                    typeText = JSFormatUtil.formatTypeDeclaration(typeDeclaration);
                } else if (!DumbService.isDumb((Project)typeDeclarationOwner.getProject()) && (jsType = typeDeclarationOwner.getJSType()) != null) {
                    typeText = JSFormatUtil.formatType(jsType, (PsiElement)this.myElement, 0);
                }
                if (typeText != null) {
                    return ": " + typeText;
                }
            }
            return "";
        });
        if (((String)postfix).length() > 30) {
            postfix = ((String)postfix).substring(0, 30) + "...";
        }
        return new JSNamedElementPresenter((PsiElement)this.myElement).getShortName() + (String)postfix;
    }

    @Nullable
    public String getLocationString() {
        return this.getLocationString(false);
    }

    @Nullable
    public String getLocationString(boolean completion) {
        String qNameForSearch;
        String packageName;
        String qName;
        PsiFile psiFile = this.myElement.getContainingFile();
        boolean showPathInformation = true;
        JSQualifiedName elementNamespace = this.myElement instanceof JSPsiElementBase ? ((JSPsiElementBase)this.myElement).getNamespace() : null;
        String string = qName = this.myElement instanceof JSPsiElementBase ? ((JSPsiElementBase)this.myElement).getQualifiedName() : this.myElement.getName();
        if (elementNamespace != null) {
            StringBuilder presentation = new StringBuilder();
            String namespace = elementNamespace.getQualifiedName();
            if (!namespace.isEmpty()) {
                presentation.append("(");
                presentation.append(namespace);
                this.appendFileName(psiFile, true, presentation, completion);
                presentation.append(")");
                return presentation.toString();
            }
        } else if (this.myElement instanceof JSVariable || this.myElement instanceof JSFunction || this.myElement instanceof JSNamespaceDeclaration || this.myElement instanceof JSImplicitPrototypeElement) {
            PsiElement possibleClazz;
            PsiElement psiElement = possibleClazz = this.myElement instanceof JSImplicitPrototypeElement ? ((JSImplicitPrototypeElement)this.myElement).getOwnerClass() : JSResolveUtil.findParent((PsiElement)this.myElement);
            if (possibleClazz instanceof JSClass) {
                String namespace;
                StringBuilder result2 = new StringBuilder();
                JSAttributeList attributeList = this.myElement instanceof JSAttributeListOwner ? ((JSAttributeListOwner)this.myElement).getAttributeList() : null;
                String qualifiedName = ((JSClass)possibleClazz).getQualifiedName();
                if (qualifiedName != null) {
                    result2.append(qualifiedName);
                }
                if ((namespace = ActionScriptPsiImplUtil.getNamespace(attributeList)) != null) {
                    result2.append(".").append(namespace);
                }
                this.appendFileName(psiFile, !DialectDetector.isActionScript((PsiElement)psiFile), result2, completion);
                return result2.toString();
            }
            if (possibleClazz instanceof JSFile && DialectDetector.isActionScript(possibleClazz) || possibleClazz instanceof JSPackageStatement) {
                String packageName2 = qName == null ? "" : StringUtil.getPackageName((String)qName);
                return !packageName2.isEmpty() ? "(" + packageName2 + ")" : "";
            }
        } else if (this.myElement instanceof JSClass && (!StringUtil.isEmpty((String)(packageName = JSItemPresentation.representationFromQName(qName))) || DialectDetector.isActionScript((PsiElement)this.myElement))) {
            return packageName;
        }
        if (this.myElement instanceof JSFunctionExpression && (qNameForSearch = JSResolveUtil.getQNameToStartHierarchySearch((JSFunctionExpression)this.myElement)) != null) {
            StringBuilder result3 = new StringBuilder(qNameForSearch);
            this.appendFileName(psiFile, true, result3, completion);
            return result3.toString();
        }
        StringBuilder res = new StringBuilder();
        this.appendFileName(psiFile, true, res, completion);
        return res.toString();
    }

    private void appendFileName(PsiFile psiFile, boolean showPathInformation, StringBuilder presentation, boolean completion) {
        if (JSItemPresentation.isLocalParameter((PsiElement)this.myElement)) {
            JSItemPresentation.appendParenthesizedIfNeeded(presentation, JavaScriptBundle.message("javascript.language.term.parameter", new Object[0]));
        } else if (JSItemPresentation.isLocalVariable((PsiElement)this.myElement)) {
            JSItemPresentation.appendParenthesizedIfNeeded(presentation, ((JSVariable)this.myElement).isConst() ? JavaScriptBundle.message("javascript.language.term.local.const", new Object[0]) : JavaScriptBundle.message("javascript.language.term.local.variable", new Object[0]));
        } else if (psiFile != null) {
            JSItemPresentation.appendParenthesizedIfNeeded(presentation, JSItemPresentation.getFileName(psiFile, showPathInformation, true, completion));
        }
    }

    public static boolean isLocalVariable(@Nullable PsiElement element2) {
        return !(element2 instanceof JSParameter) && element2 instanceof JSVariable && JSItemPresentation.isLocalScope(((JSVariable)element2).getDeclarationScope());
    }

    public static boolean isLocalParameter(@Nullable PsiElement element2) {
        return element2 instanceof JSParameter && !TypeScriptPsiUtil.isFieldParameter((JSParameter)element2);
    }

    private static void appendParenthesizedIfNeeded(StringBuilder presentation, String str) {
        boolean addParens;
        if (StringUtil.isEmpty((String)str)) {
            return;
        }
        if (str.charAt(0) == '(') {
            str = StringUtil.trimEnd((String)StringUtil.trimStart((String)str, (String)"("), (String)")");
        }
        presentation.append((addParens = presentation.isEmpty()) ? "(" : ", ");
        presentation.append(str);
        if (addParens) {
            presentation.append(")");
        }
    }

    private static boolean isLocalScope(PsiElement scope2) {
        return !(scope2 instanceof JSClass) && (!(scope2 instanceof JSExecutionScope) || scope2 instanceof JSFunction);
    }

    @NotNull
    private static String representationFromQName(String qName) {
        String packageName = qName != null ? StringUtil.getPackageName((String)qName) : "";
        return !StringUtil.isEmpty((String)packageName) ? "(" + packageName + ")" : "";
    }

    @NotNull
    public static String getFileName(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JSItemPresentation.$$$reportNull$$$0(1);
        }
        return JSItemPresentation.getFileName(psiFile, true);
    }

    @NotNull
    public static String getFileName(@NotNull PsiFile psiFile, boolean showLocation) {
        if (psiFile == null) {
            JSItemPresentation.$$$reportNull$$$0(2);
        }
        return JSItemPresentation.getFileName(psiFile, showLocation, false, false);
    }

    @NotNull
    public static String getFileName(@NotNull PsiFile psiFile, boolean showLibraryLocation, boolean showFilePath, boolean completion) {
        String packageDesc;
        String fileName;
        ProjectFileIndex projectFileIndex;
        String name;
        if (psiFile == null) {
            JSItemPresentation.$$$reportNull$$$0(3);
        }
        if ((name = JSItemPresentationProvider.Companion.getFileName(psiFile)) != null) {
            String string = name;
            if (string == null) {
                JSItemPresentation.$$$reportNull$$$0(4);
            }
            return string;
        }
        VirtualFile file = psiFile.getOriginalFile().getViewProvider().getVirtualFile();
        boolean isFromLibrary = false;
        if (showLibraryLocation && (projectFileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex()).isInLibrary(file)) {
            List entriesForFile = projectFileIndex.getOrderEntriesForFile(file);
            for (int i = 0; i < entriesForFile.size(); ++i) {
                OrderEntry entry = (OrderEntry)entriesForFile.get(i);
                String s = null;
                if (entry instanceof LibraryOrderEntry) {
                    s = entry.getPresentableName();
                    int lastSlash = s.lastIndexOf(File.separatorChar);
                    if (lastSlash != -1) {
                        s = s.substring(lastSlash + 1);
                    }
                } else if (entry instanceof JdkOrderEntry) {
                    Sdk sdk = ((JdkOrderEntry)entry).getJdk();
                    s = sdk instanceof CompositeRootCollection ? ((CompositeRootCollection)sdk).getName(file) : ((JdkOrderEntry)entry).getJdkName();
                }
                if (s == null) continue;
                String string = s;
                if (string == null) {
                    JSItemPresentation.$$$reportNull$$$0(5);
                }
                return string;
            }
            file = JSItemPresentation.getNameOfPhysicalFile(file);
            isFromLibrary = true;
        }
        if (JSResolveUtil.isFromPredefinedFile(psiFile) || JSCorePredefinedLibrariesProvider.isCoreLibraryFile(file)) {
            return JSItemPresentation.formatPredefinedFileName(file.getName(), completion);
        }
        String string = fileName = showFilePath ? JSItemPresentation.getUniqueFileName((PsiElement)psiFile, file, completion) : file.getName();
        if (isFromLibrary && (packageDesc = JSItemPresentation.getNodePackageDesc(file)) != null) {
            String string2 = packageDesc;
            if (string2 == null) {
                JSItemPresentation.$$$reportNull$$$0(6);
            }
            return string2;
        }
        String string3 = fileName;
        if (string3 == null) {
            JSItemPresentation.$$$reportNull$$$0(7);
        }
        return string3;
    }

    @NotNull
    private static String getUniqueFileName(@NotNull PsiElement context2, @NotNull VirtualFile virtualFile, boolean completion) {
        if (context2 == null) {
            JSItemPresentation.$$$reportNull$$$0(8);
        }
        if (virtualFile == null) {
            JSItemPresentation.$$$reportNull$$$0(9);
        }
        Project project = context2.getProject();
        if (!completion || DumbService.isDumb((Project)project)) {
            String path2;
            String path3;
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)context2.getProject()).getFileIndex();
            VirtualFile contentRootForFile = projectFileIndex.getContentRootForFile(virtualFile);
            if (contentRootForFile != null && (path3 = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)contentRootForFile)) != null && !path3.isEmpty()) {
                String string = path3;
                if (string == null) {
                    JSItemPresentation.$$$reportNull$$$0(10);
                }
                return string;
            }
            VirtualFile baseDirectoryFor = BaseProjectDirectories.getInstance((Project)project).getBaseDirectoryFor(virtualFile);
            if (baseDirectoryFor != null && (path2 = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)baseDirectoryFor)) != null && !path2.isEmpty()) {
                String string = path2;
                if (string == null) {
                    JSItemPresentation.$$$reportNull$$$0(11);
                }
                return string;
            }
            String string = virtualFile.getName();
            if (string == null) {
                JSItemPresentation.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(context2.getProject(), virtualFile);
        if (string == null) {
            JSItemPresentation.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    private static String getNodePackageDesc(@NotNull VirtualFile file) {
        String path2;
        int types;
        if (file == null) {
            JSItemPresentation.$$$reportNull$$$0(14);
        }
        if ((types = (path2 = file.getPath()).indexOf(NODE_TYPES)) != -1) {
            String rest = path2.substring(types + NODE_TYPES.length());
            return JSItemPresentation.getPackageDesc(rest, file);
        }
        int modules = path2.indexOf(NODE_MODULES);
        if (modules != -1) {
            String rest = path2.substring(modules + NODE_MODULES.length());
            return JSItemPresentation.getPackageDesc(rest, file);
        }
        return null;
    }

    @NotNull
    private static String formatPredefinedFileName(@NotNull String name, boolean completion) {
        String trimmedName;
        if (name == null) {
            JSItemPresentation.$$$reportNull$$$0(15);
        }
        if (Strings.areSameInstance((String)(trimmedName = TypeScriptLibraries.trimLibFileName(name)), (String)name)) {
            String string = name;
            if (string == null) {
                JSItemPresentation.$$$reportNull$$$0(16);
            }
            return string;
        }
        if (name.contains(".dom.") && completion) {
            return "(DOM)";
        }
        String builtIn = JavaScriptBundle.message("javascript.library.built.in", new Object[0]);
        String string = completion || StringUtil.isEmpty((String)name) ? "(" + builtIn + ")" : "(" + builtIn + ", " + trimmedName + ")";
        if (string == null) {
            JSItemPresentation.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static String getPackageDesc(@NotNull String rest, @NotNull VirtualFile file) {
        int slash;
        if (rest == null) {
            JSItemPresentation.$$$reportNull$$$0(18);
        }
        if (file == null) {
            JSItemPresentation.$$$reportNull$$$0(19);
        }
        if ((slash = rest.indexOf(47)) == -1) {
            String string = "(" + rest + ")";
            if (string == null) {
                JSItemPresentation.$$$reportNull$$$0(20);
            }
            return string;
        }
        String firstPart = rest.substring(0, slash);
        if (!firstPart.isEmpty() && firstPart.charAt(0) == '@' && (slash = rest.indexOf(47, slash + 1)) != -1) {
            firstPart = rest.substring(0, slash);
        }
        String result2 = TYPESCRIPT_PACKAGE.equals(firstPart) ? firstPart + ", " + TypeScriptLibraries.trimLibFileName(file.getName()) : firstPart;
        String string = "(" + result2 + ")";
        if (string == null) {
            JSItemPresentation.$$$reportNull$$$0(21);
        }
        return string;
    }

    public static VirtualFile getNameOfPhysicalFile(VirtualFile file) {
        VirtualFile fileForJar;
        VirtualFileSystem fileSystem;
        if ("library.swf".equals(file.getName()) && (fileSystem = file.getFileSystem()) instanceof JarFileSystem && (fileForJar = ((JarFileSystem)fileSystem).getLocalByEntry(file)) != null) {
            file = fileForJar;
        }
        return file;
    }

    @Nullable
    public Icon getIcon(boolean open2) {
        return this.myElement.getIcon(3);
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        return this.myElement instanceof JSDocOwner && ((JSDocOwner)this.myElement).isDeprecated() ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 10, 11, 12, 13, 16, 17, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSItemPresentation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSItemPresentation";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueFileName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "formatPredefinedFileName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageDesc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueFileName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNodePackageDesc";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "formatPredefinedFileName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPackageDesc";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 10, 11, 12, 13, 16, 17, 20, 21 -> new IllegalStateException(string);
        };
    }
}

