/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.fixes.ChangeJSDocTypeFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCheckFunctionSignaturesInspection
extends JSInspection {
    public static final String SHORT_NAME = JSCheckFunctionSignaturesInspection.calcShortNameFromClass(JSCheckFunctionSignaturesInspection.class);
    public boolean myCheckGuessedTypes;

    @Override
    public boolean isCoveredByTypeScriptServiceHighlighting() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            JSCheckFunctionSignaturesInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myCheckGuessedTypes", (String)JavaScriptBundle.message("js.check.function.signature.guess.optionality", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(JavaScriptBundle.message("js.check.function.signature.guess.optionality.hint", new Object[0]))});
        if (optPane == null) {
            JSCheckFunctionSignaturesInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    protected boolean isAllowedToCheckCallExpression(JSCallExpression node) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)node);
        return dialect == null || !dialect.isTypeScript && dialect != DialectOptionHolder.FLOW;
    }

    @Override
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSCheckFunctionSignaturesInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            JSCheckFunctionSignaturesInspection.$$$reportNull$$$0(3);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSCallExpression(@NotNull JSCallExpression node) {
                PsiElement arrayInitializingType;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!JSCheckFunctionSignaturesInspection.this.isAllowedToCheckCallExpression(node)) {
                    return;
                }
                JSExpression methodExpression = node.getMethodExpression();
                if (methodExpression instanceof JSParenthesizedExpression) {
                    methodExpression = JSUtils.unparenthesize(methodExpression);
                }
                if (methodExpression instanceof JSReferenceExpression || methodExpression instanceof JSSuperExpression) {
                    PsiReference reference = methodExpression.getReference();
                    if (reference == null) {
                        return;
                    }
                    PsiElement resolve2 = reference.resolve();
                    if (resolve2 == null && reference instanceof PsiPolyVariantReference) {
                        resolve2 = JSCheckFunctionSignaturesInspection.reportIncompleteAsArgumentTypesMismatch(((PsiPolyVariantReference)reference).multiResolve(false));
                    }
                    if (resolve2 != null && resolve2.isValid()) {
                        JSFunctionItem function;
                        boolean checkFunction = true;
                        if (!JSCheckFunctionSignaturesInspection.this.myCheckGuessedTypes && (function = JSPsiImplUtils.calculatePossibleFunction(resolve2, (PsiElement)methodExpression, true)) instanceof JSFunction && !JSPsiImplUtils.signatureIsExplicitlyDeclared(function)) {
                            checkFunction = false;
                        }
                        if (checkFunction) {
                            this.getFunctionSignatureChecker((PsiElement)node).checkFunction(node, resolve2);
                        }
                    }
                } else if (methodExpression instanceof JSFunctionExpression && (JSCheckFunctionSignaturesInspection.this.myCheckGuessedTypes || JSPsiImplUtils.signatureIsExplicitlyDeclared((JSFunctionExpression)methodExpression))) {
                    this.getFunctionSignatureChecker((PsiElement)node).checkFunction(node, (PsiElement)methodExpression);
                } else if (methodExpression instanceof JSArrayLiteralExpression && node instanceof JSNewExpression && (arrayInitializingType = ((JSNewExpression)node).getArrayInitializingType()) != null) {
                    String typeName = JSImportHandlingUtil.resolveTypeName(arrayInitializingType.getText(), (PsiElement)node);
                    ((JSArrayLiteralExpression)methodExpression).getExpressionStream().filter(Objects::nonNull).forEach(expr -> JSCheckFunctionSignaturesInspection.getTypeChecker((PsiElement)expr, holder).checkExpressionIsAssignableToTypeAndReportError((JSExpression)expr, typeName, "javascript.vector.literal.element.type.mismatch", null, true));
                }
            }

            @NotNull
            private JSFunctionSignatureChecker getFunctionSignatureChecker(@NotNull PsiElement context2) {
                if (context2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                JSFunctionSignatureChecker jSFunctionSignatureChecker = JSAnalysisHandlersFactory.forElement(context2).getFunctionSignatureChecker(holder);
                if (jSFunctionSignatureChecker == null) {
                    1.$$$reportNull$$$0(2);
                }
                return jSFunctionSignatureChecker;
            }

            @Override
            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.checkSignatureMatchesOverridden(node);
            }

            @Override
            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.checkSignatureMatchesOverridden(node);
            }

            private void checkSignatureMatchesOverridden(JSFunction function) {
                if (!DialectDetector.isJavaScript(function)) {
                    return;
                }
                Collection<JSPsiElementBase> members = JSInheritanceUtil.findNearestOverriddenMembers(function, true);
                if (members.isEmpty()) {
                    return;
                }
                JSParameterListElement[] parameters2 = function.getParameters();
                if (members.size() == 1) {
                    JSFunctionItem overridden = JSPsiImplUtils.calculatePossibleFunction((PsiElement)members.iterator().next(), null, false);
                    if (overridden == null) {
                        return;
                    }
                    this.checkCompatibleSignature(function, parameters2, overridden, true);
                } else {
                    for (JSPsiElementBase member : members) {
                        JSFunctionItem overridden = JSPsiImplUtils.calculatePossibleFunction((PsiElement)member, null, false);
                        if (overridden == null || !this.checkCompatibleSignature(function, parameters2, overridden, false)) continue;
                        return;
                    }
                    PsiElement nameIdentifier = function.getNameIdentifier();
                    holder.registerProblem((PsiElement)(nameIdentifier != null ? nameIdentifier : function), JavaScriptBundle.message("javascript.validation.message.function.override.incompatible.signature.generic", new Object[0]), new LocalQuickFix[0]);
                }
            }

            private boolean checkCompatibleSignature(JSFunction function, JSParameterListElement[] parameters2, JSFunctionItem overridden, boolean reportProblems) {
                PsiFile file = overridden.getContainingFile();
                if (file instanceof JSFile && ((JSFile)file).isPredefined()) {
                    return true;
                }
                if (!JSPsiImplUtils.signatureIsExplicitlyDeclared(overridden)) {
                    return true;
                }
                ProcessingContext context2 = JSTypeComparingContextService.createProcessingContextWithCache((PsiElement)overridden);
                JSParameterItem[] overriddenParameters = overridden.getParameters();
                if (overriddenParameters.length != parameters2.length) {
                    if (reportProblems) {
                        String expectedSignature = JSFormatUtil.buildFunctionSignaturePresentation(overridden);
                        JSParameterList parameterList = function.getParameterList();
                        if (parameterList != null) {
                            holder.registerProblem((PsiElement)parameterList, JavaScriptBundle.message("javascript.validation.message.function.override.incompatible.signature", expectedSignature), new LocalQuickFix[0]);
                        }
                    }
                    return false;
                }
                boolean result2 = true;
                for (int i = 0; i < parameters2.length; ++i) {
                    JSParameterListElement source;
                    JSType type2 = parameters2[i].getJSType();
                    JSType overriddenType = overriddenParameters[i].getInferredType();
                    if (type2 == null || overriddenType == null || JSTypeUtils.hasForeignGenericParameter(overriddenType) || JSTypeUtils.areTypesCompatible(type2, overriddenType, context2, function)) continue;
                    if (reportProblems && (source = parameters2[i]) instanceof JSNamedElement) {
                        boolean hasJSDoc = source instanceof JSPsiElementBase ? ((JSPsiElementBase)((Object)source)).hasJSDoc() || function.hasJSDoc() : function.hasJSDoc();
                        this.registerTypeMismatchProblem(hasJSDoc, (JSNamedElement)((Object)source), overriddenType);
                    }
                    result2 = false;
                }
                JSType overriddenReturnType = overridden.getReturnType();
                JSType returnType2 = function.getReturnType();
                if (!(overriddenReturnType == null || returnType2 == null || overriddenReturnType instanceof JSVoidType || JSTypeUtils.hasForeignGenericParameter(overriddenReturnType) || overriddenReturnType.isDirectlyAssignableType(returnType2, context2))) {
                    if (reportProblems) {
                        this.registerTypeMismatchProblem(function.hasJSDoc(), function, overriddenReturnType);
                    }
                    result2 = false;
                }
                return result2;
            }

            private void registerTypeMismatchProblem(boolean hasJSDoc, @NotNull JSNamedElement typedElement, @NotNull JSType overriddenType) {
                LocalQuickFix[] localQuickFixArray;
                if (typedElement == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (overriddenType == null) {
                    1.$$$reportNull$$$0(6);
                }
                String typeText = overriddenType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
                String message = JavaScriptBundle.message("javascript.validation.message.function.method.invalid.overridden.parameter.type", typeText);
                if (hasJSDoc) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = new ChangeJSDocTypeFix(typedElement, overriddenType);
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                PsiElement nameIdentifier = typedElement.getNameIdentifier();
                holder.registerProblem((PsiElement)(nameIdentifier != null ? nameIdentifier : typedElement), message, fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/inspections/JSCheckFunctionSignaturesInspection$1";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typedElement";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "overriddenType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSCheckFunctionSignaturesInspection$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFunctionSignatureChecker";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitJSCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getFunctionSignatureChecker";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "visitJSFunctionExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "registerTypeMismatchProblem";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Nullable
    public static PsiElement reportIncompleteAsArgumentTypesMismatch(ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            JSCheckFunctionSignaturesInspection.$$$reportNull$$$0(4);
        }
        return resolveResults.length == 1 && resolveResults[0] instanceof JSResolveResult && ((JSResolveResult)resolveResults[0]).getResolveProblemKind() == JSResolveResult.ProblemKind.ARGUMENT_TYPES_MISMATCH ? resolveResults[0].getElement() : null;
    }

    @NotNull
    private static JSTypeChecker getTypeChecker(PsiElement context2, ProblemsHolder holder) {
        JSTypeChecker jSTypeChecker = JSAnalysisHandlersFactory.forElement(context2).getTypeChecker(holder);
        if (jSTypeChecker == null) {
            JSCheckFunctionSignaturesInspection.$$$reportNull$$$0(5);
        }
        return jSTypeChecker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSCheckFunctionSignaturesInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSCheckFunctionSignaturesInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeChecker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reportIncompleteAsArgumentTypesMismatch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

