/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.intentions.destructuring.JSIntroduceDestructuringVariablesIntention;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPropertyAccessToIndexerIntention
extends JavaScriptIntention
implements LowPriorityAction {
    public JSPropertyAccessToIndexerIntention() {
        this.setText(this.getFamilyName());
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (project == null) {
            JSPropertyAccessToIndexerIntention.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            JSPropertyAccessToIndexerIntention.$$$reportNull$$$0(1);
        }
        JSReferenceExpression reference = JSPropertyAccessToIndexerIntention.findReference(element2);
        assert (reference != null);
        JSExpression qualifier = reference.getQualifier();
        assert (qualifier != null);
        String quote = JSCodeStyleSettings.getQuote(element2);
        JSExpression newExpression = JSPsiElementFactory.createJSExpression(qualifier.getText() + "[" + quote + reference.getReferenceName() + quote + "]", element2);
        reference.replace((PsiElement)newExpression);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.property.to.indexer.intention", new Object[0]);
        if (string == null) {
            JSPropertyAccessToIndexerIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        if (project == null) {
            JSPropertyAccessToIndexerIntention.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            JSPropertyAccessToIndexerIntention.$$$reportNull$$$0(4);
        }
        if (!super.isAvailable(project, editor, element2)) {
            return false;
        }
        JSReferenceExpression reference = JSPropertyAccessToIndexerIntention.findReference(element2);
        if (reference == null) {
            return false;
        }
        PsiFile file = reference.getContainingFile();
        if (file != null && file.getContext() instanceof XmlElement) {
            return false;
        }
        return reference.getQualifier() != null && !(reference.getParent() instanceof JSCallExpression) && reference.getReferenceKind() == JSReferenceExpression.Kind.PropertyAccess && !JSIntroduceDestructuringVariablesIntention.isInTypeAnnotation((PsiElement)reference);
    }

    @Nullable
    private static JSReferenceExpression findReference(PsiElement element2) {
        IElementType type2 = PsiUtilCore.getElementType((PsiElement)element2);
        if (type2 == JSTokenTypes.PRIVATE_IDENTIFIER) {
            return null;
        }
        if (type2 != JSTokenTypes.IDENTIFIER) {
            return (JSReferenceExpression)ObjectUtils.tryCast((Object)element2.getPrevSibling(), JSReferenceExpression.class);
        }
        return (JSReferenceExpression)ObjectUtils.tryCast((Object)element2.getParent(), JSReferenceExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSPropertyAccessToIndexerIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSPropertyAccessToIndexerIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

