/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSPredefinedLibraryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSPredefinedLibraryMappings {
    static final String EXCLUDED_PREDEFINED_LIBRARY = "excludedPredefinedLibrary";
    static final String INCLUDED_PREDEFINED_LIBRARY = "includedPredefinedLibrary";
    static final String PREDEFINED_LIBRARY_NAME = "name";
    @NotNull
    private Set<String> myPrevPredefinedLibraryNames;
    @NotNull
    private Set<String> myLastPredefinedLibraryNames;
    private final Set<String> myExcludedPredefinedLibraryNames;
    private final Set<String> myIncludedPredefinedLibraryNames;
    private final Project myProject;

    JSPredefinedLibraryMappings(@NotNull Project project) {
        if (project == null) {
            JSPredefinedLibraryMappings.$$$reportNull$$$0(0);
        }
        this.myPrevPredefinedLibraryNames = Collections.emptySet();
        this.myLastPredefinedLibraryNames = Collections.emptySet();
        this.myExcludedPredefinedLibraryNames = new TreeSet<String>();
        this.myIncludedPredefinedLibraryNames = new TreeSet<String>();
        this.myProject = project;
    }

    public void loadState(@NotNull ScriptingLibraryMappings mappings, @NotNull Element state) {
        if (mappings == null) {
            JSPredefinedLibraryMappings.$$$reportNull$$$0(1);
        }
        if (state == null) {
            JSPredefinedLibraryMappings.$$$reportNull$$$0(2);
        }
        this.myExcludedPredefinedLibraryNames.clear();
        JSPredefinedLibraryMappings.loadLibrariesFromState(state, EXCLUDED_PREDEFINED_LIBRARY, this.myExcludedPredefinedLibraryNames);
        JSPredefinedLibraryMappings.loadLibrariesFromState(state, INCLUDED_PREDEFINED_LIBRARY, this.myIncludedPredefinedLibraryNames);
        this.setMissingPredefinedLibraries(mappings, false);
    }

    public void updateLibraryStates(@NotNull ScriptingLibraryMappings mappings) {
        if (mappings == null) {
            JSPredefinedLibraryMappings.$$$reportNull$$$0(3);
        }
        this.updateLibraryStates(mappings, null);
    }

    public void updateLibraryStates(@NotNull ScriptingLibraryMappings mapping, @Nullable Set<String> allowedPredefinedLibraryNames) {
        if (mapping == null) {
            JSPredefinedLibraryMappings.$$$reportNull$$$0(4);
        }
        this.myExcludedPredefinedLibraryNames.clear();
        this.myIncludedPredefinedLibraryNames.clear();
        for (ScriptingLibraryModel model : this.getPredefinedLibraryModules()) {
            List mappings;
            List defaultMappings;
            if (allowedPredefinedLibraryNames != null && !allowedPredefinedLibraryNames.contains(model.getName()) || (defaultMappings = model.getDefaultMappings()).equals(mappings = mapping.getMappingsByLibraryName(model.getName()))) continue;
            if (mappings.isEmpty()) {
                this.myExcludedPredefinedLibraryNames.add(model.getName());
                continue;
            }
            if (!defaultMappings.isEmpty() || !ScriptingLibraryMappings.isAssociatedWithProject((List)mappings)) continue;
            this.myIncludedPredefinedLibraryNames.add(model.getName());
        }
    }

    void fillState(@NotNull ScriptingLibraryMappings mappings, @NotNull Element e) {
        Element predefLibsElement;
        if (mappings == null) {
            JSPredefinedLibraryMappings.$$$reportNull$$$0(5);
        }
        if (e == null) {
            JSPredefinedLibraryMappings.$$$reportNull$$$0(6);
        }
        this.updateLibraryStates(mappings);
        for (String libName : this.myIncludedPredefinedLibraryNames) {
            predefLibsElement = new Element(INCLUDED_PREDEFINED_LIBRARY);
            predefLibsElement.setAttribute(new Attribute(PREDEFINED_LIBRARY_NAME, libName));
            e.addContent(predefLibsElement);
        }
        for (String libName : this.myExcludedPredefinedLibraryNames) {
            predefLibsElement = new Element(EXCLUDED_PREDEFINED_LIBRARY);
            predefLibsElement.setAttribute(new Attribute(PREDEFINED_LIBRARY_NAME, libName));
            e.addContent(predefLibsElement);
        }
    }

    void setMissingPredefinedLibraries(ScriptingLibraryMappings mapping, boolean processNewOnly) {
        HashSet<String> predefinedLibraryNames = new HashSet<String>();
        JSPredefinedLibraryManager manager = JSPredefinedLibraryManager.getPredefinedLibraryManager(this.myProject);
        for (ScriptingLibraryModel model : manager.getLibraryModels()) {
            String libraryName = model.getName();
            if (processNewOnly && this.myPrevPredefinedLibraryNames.contains(libraryName)) continue;
            predefinedLibraryNames.add(libraryName);
            if (this.myIncludedPredefinedLibraryNames.contains(libraryName)) {
                mapping.associate(null, libraryName, true);
                continue;
            }
            List mappings = mapping.getMappingsByLibraryName(libraryName);
            if (!mappings.isEmpty() || this.myExcludedPredefinedLibraryNames.contains(libraryName)) continue;
            List defaultMappings = model.getDefaultMappings();
            for (VirtualFile file : defaultMappings) {
                mapping.associate(model, file, true);
            }
        }
        this.myPrevPredefinedLibraryNames = predefinedLibraryNames;
    }

    void updateMappings(ScriptingLibraryMappings mapping) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.updateLibraryStates(mapping, this.myLastPredefinedLibraryNames);
        }
        this.setMissingPredefinedLibraries(mapping, true);
        this.myLastPredefinedLibraryNames = ContainerUtil.map2Set(this.getPredefinedLibraryModules(), ScriptingLibraryModel::getName);
    }

    private static void loadLibrariesFromState(@NotNull Element state, String library, Set<String> names) {
        if (state == null) {
            JSPredefinedLibraryMappings.$$$reportNull$$$0(7);
        }
        List excludedLibraries = state.getChildren(library);
        for (Element predefLibrary : excludedLibraries) {
            Attribute libName = predefLibrary.getAttribute(PREDEFINED_LIBRARY_NAME);
            if (libName == null) continue;
            String presentationName = libName.getValue();
            names.add(presentationName);
        }
    }

    private Set<ScriptingLibraryModel> getPredefinedLibraryModules() {
        return JSPredefinedLibraryManager.getPredefinedLibraryManager(this.myProject).getLibraryModels();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/library/JSPredefinedLibraryMappings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateLibraryStates";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fillState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "loadLibrariesFromState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

