/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.download.TypeScriptAllStubsFile;
import com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptInstallGlobalTypesFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myModuleName;

    public TypeScriptInstallGlobalTypesFix(@Nullable PsiElement element2, @NotNull String moduleName) {
        if (moduleName == null) {
            TypeScriptInstallGlobalTypesFix.$$$reportNull$$$0(0);
        }
        super(element2);
        this.myModuleName = moduleName;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("npm.modules.install.global.types.fix.name", new Object[0]);
        if (string == null) {
            TypeScriptInstallGlobalTypesFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            TypeScriptInstallGlobalTypesFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement element2, @NotNull PsiElement endElement) {
        if (project == null) {
            TypeScriptInstallGlobalTypesFix.$$$reportNull$$$0(3);
        }
        if (psiFile == null) {
            TypeScriptInstallGlobalTypesFix.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            TypeScriptInstallGlobalTypesFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            TypeScriptInstallGlobalTypesFix.$$$reportNull$$$0(6);
        }
        if (!element2.isValid()) {
            return;
        }
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.EXEC);
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        LibraryTable table = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
        ScriptingLibraryMappings mappings = libraryManager.getLibraryMappings();
        String name = "@types/" + this.myModuleName;
        Library library = table.getLibraryByName(name);
        if (library != null && !mappings.isAssociatedWithProject(name)) {
            WriteAction.run(() -> {
                mappings.associateWithProject(name);
                libraryManager.commitChanges(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
                DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
            });
            return;
        }
        DownloadableFileSetDescriptionWithUrl description = TypeScriptAllStubsFile.INSTANCE.getDownloadableFileSetDescription(this.myModuleName);
        if (description == null) {
            if (editor != null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message("dialog.message.cannot.find.module.types", this.myModuleName), (String)this.getName(), null);
            }
            return;
        }
        TypeScriptDefinitionFilesRootsProvider.LibraryCreator.downloadTypesLibrary(project, (DownloadableFileSetDescription)description, null, () -> {
            if (project.isDisposed()) {
                return;
            }
            if (!psiFile.isValid()) {
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            } else {
                DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/TypeScriptInstallGlobalTypesFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/TypeScriptInstallGlobalTypesFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

