/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.accessibility;

import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSAccessibilityChecker;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigAccessibilityChecker
extends JSAccessibilityChecker {
    public static final TypeScriptConfigAccessibilityChecker INSTANCE = new TypeScriptConfigAccessibilityChecker();
    private static final Class[] myClasses = new Class[]{JSVariable.class, JSFunction.class, JSField.class, ES6ImportSpecifier.class, JSClass.class};

    @Override
    protected Class<? extends JSElement> @NotNull [] getSuitableClasses() {
        if (myClasses == null) {
            TypeScriptConfigAccessibilityChecker.$$$reportNull$$$0(0);
        }
        return myClasses;
    }

    @Override
    protected @Nullable JSResolveResult.ProblemKind checkImpl(@Nullable PsiElement place, @NotNull PsiElement element2) {
        PsiFile elementOriginalFile;
        if (element2 == null) {
            TypeScriptConfigAccessibilityChecker.$$$reportNull$$$0(1);
        }
        if (place == null) {
            return null;
        }
        if (place instanceof ES6ImportSpecifier) {
            return null;
        }
        PsiFile placeContainingFile = JSResolveUtil.getOriginalFile(place);
        VirtualFile scope2 = this.getScope((PsiElement)placeContainingFile);
        PsiFile elementContainingFile = element2.getContainingFile();
        if (scope2 == null || elementContainingFile == null) {
            return null;
        }
        if (place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() != null) {
            if (ES6PsiUtil.isExternalModule((PsiElement)elementContainingFile)) {
                return null;
            }
            PsiElement module = ES6PsiUtil.findExternalModule(element2);
            if (module != null) {
                return null;
            }
        }
        if ((elementOriginalFile = JSResolveUtil.getOriginalFile((PsiElement)elementContainingFile)) == null || elementOriginalFile instanceof JSExpressionCodeFragment) {
            return null;
        }
        VirtualFile referencedFile = elementOriginalFile.getVirtualFile();
        if (referencedFile == null) {
            return null;
        }
        if (!TypeScriptConfigService.Provider.isAccessible(place.getProject(), scope2, referencedFile)) {
            return JSResolveResult.ProblemKind.TS_NEED_TO_BE_INCLUDED_TO_CONFIG;
        }
        return null;
    }

    protected VirtualFile getScope(@Nullable PsiElement place) {
        return PsiUtilCore.getVirtualFile((PsiElement)place);
    }

    @Override
    public boolean isAvailable(AccessibilityProcessingHandler handler, SinkResolveProcessor<?> resolveProcessor) {
        return ((ResultSink)resolveProcessor.getResultSink()).isTypeScript() && !resolveProcessor.isLocalResolve();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/accessibility/TypeScriptConfigAccessibilityChecker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/accessibility/TypeScriptConfigAccessibilityChecker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

