/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceSimpleDeleteUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JavaScriptParameterSafeDeleteProcessor
implements SafeDeleteProcessorDelegate {
    public boolean handlesElement(PsiElement element2) {
        return element2 instanceof JSParameter;
    }

    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element2, PsiElement @NotNull [] allElementsToDelete, @NotNull List<? super UsageInfo> usages) {
        JSQualifiedNamedElement elementAssignedTo;
        if (element2 == null) {
            JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(0);
        }
        if (usages == null) {
            JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(1);
        }
        if (allElementsToDelete == null) {
            JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(2);
        }
        if (!(element2 instanceof JSParameter)) {
            return null;
        }
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element2, JSFunction.class);
        if (fun == null) {
            return null;
        }
        ReferencesSearch.search((PsiElement)element2, (SearchScope)element2.getUseScope()).asIterable().forEach(reference -> {
            PsiElement refElement = reference.getElement();
            if (!JSResolveUtil.isSelfReference(refElement) && !(reference instanceof JSDocParamReference)) {
                usages.add((UsageInfo)new SafeDeleteReferenceSimpleDeleteUsageInfo(refElement, element2, false));
            }
        });
        JSParameterListElement parameterElement = JavaScriptParameterSafeDeleteProcessor.destructuringParameterIfPossibleToDelete((JSParameter)element2);
        final int parameterIndex = ArrayUtil.find((Object[])fun.getParameters(), (Object)parameterElement);
        if (parameterIndex < 0) {
            return null;
        }
        PsiComment comment = JSDocumentationUtils.findFunctionComment(fun);
        if (comment instanceof JSDocComment) {
            JSDocTag[] tags = ((JSDocComment)comment).getTags();
            final HashSet<Integer> indexesToRemove = new HashSet<Integer>();
            JSDocumentationUtils.JSTagToParameterMap map2 = JSDocumentationUtils.getTagToParameterMap((JSDocComment)comment, fun, null);
            int parameterTagIndex = map2.getTagForParameter(parameterElement);
            if (parameterTagIndex >= 0) {
                indexesToRemove.add(parameterIndex);
                for (int associatedTag = parameterTagIndex + 1; !map2.getMatchedTags().containsKey(associatedTag) && associatedTag < tags.length && "param".equals(tags[associatedTag].getName()); ++associatedTag) {
                    indexesToRemove.add(associatedTag);
                }
                usages.add((UsageInfo)new SafeDeleteReferenceSimpleDeleteUsageInfo((PsiElement)comment, element2, true){

                    public void deleteElement() throws IncorrectOperationException {
                        PsiElement docComment = this.getElement();
                        if (docComment == null) {
                            return;
                        }
                        JSDocumentationUtils.createOrUpdateTagsInDocComment(docComment, ContainerUtil.emptyList(), Collections.emptyMap(), indexesToRemove);
                    }
                });
            }
        }
        Processor functionCallsProcessor = psiReference -> {
            JSCallExpression callExpression;
            if (psiReference instanceof JSReferenceExpression && ((JSReferenceExpression)psiReference).getParent() instanceof JSCallExpression && (callExpression = (JSCallExpression)((JSReferenceExpression)psiReference).getParent()).getArguments().length > parameterIndex) {
                usages.add((UsageInfo)new SafeDeleteReferenceSimpleDeleteUsageInfo((PsiElement)callExpression, element2, true){

                    public void deleteElement() throws IncorrectOperationException {
                        JSCallExpression callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)this.getElement(), JSCallExpression.class);
                        if (this.isSafeDelete() && callExpression != null) {
                            JSExpression[] arguments = callExpression.getArguments();
                            JSChangeUtil.removeRangeWithRemovalOfCommas((PsiElement)arguments[parameterIndex], (PsiElement[])arguments);
                        }
                    }
                });
            }
            return true;
        };
        ReferencesSearch.search((PsiElement)fun).forEach(functionCallsProcessor);
        if (fun instanceof JSFunctionExpression && (elementAssignedTo = ((JSFunctionExpression)fun).getElementAssignedTo()) != null && elementAssignedTo.getName() != null) {
            ReferencesSearch.search((PsiElement)elementAssignedTo).forEach(functionCallsProcessor);
        }
        return new NonCodeUsageSearchInfo(Conditions.alwaysFalse(), element2);
    }

    @NotNull
    private static JSParameterListElement destructuringParameterIfPossibleToDelete(@NotNull JSParameter parameter) {
        if (parameter == null) {
            JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(3);
        }
        JSParameter current = parameter;
        while (JSDestructuringUtil.isDestructuring(current.getParent())) {
            if (current instanceof JSDestructuringArray && !JSDestructuringUtil.hasSingleElement((JSDestructuringArray)((Object)current))) {
                JSParameter jSParameter = parameter;
                if (jSParameter == null) {
                    JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(4);
                }
                return jSParameter;
            }
            if (current instanceof JSDestructuringObject && ((JSDestructuringObject)((Object)current)).getProperties().length != 1) {
                JSParameter jSParameter = parameter;
                if (jSParameter == null) {
                    JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(5);
                }
                return jSParameter;
            }
            current = current.getParent();
        }
        JSParameterListElement jSParameterListElement = current instanceof JSDestructuringParameter ? (JSDestructuringParameter)((Object)current) : parameter;
        if (jSParameterListElement == null) {
            JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(6);
        }
        return jSParameterListElement;
    }

    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element2, @NotNull Collection<? extends PsiElement> allElementsToDelete) {
        if (element2 == null) {
            JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(7);
        }
        if (allElementsToDelete == null) {
            JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(8);
        }
        return Collections.singletonList(element2);
    }

    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element2, @NotNull Collection<? extends PsiElement> allElementsToDelete, boolean askUser) {
        if (element2 == null) {
            JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(9);
        }
        if (allElementsToDelete == null) {
            JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(10);
        }
        return null;
    }

    public Collection<String> findConflicts(@NotNull PsiElement element2, PsiElement @NotNull [] allElementsToDelete) {
        if (element2 == null) {
            JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(11);
        }
        if (allElementsToDelete == null) {
            JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(12);
        }
        return null;
    }

    public UsageInfo[] preprocessUsages(@NotNull Project project, UsageInfo @NotNull [] usages) {
        if (project == null) {
            JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(13);
        }
        if (usages == null) {
            JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(14);
        }
        return usages;
    }

    public void prepareForDeletion(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            JavaScriptParameterSafeDeleteProcessor.$$$reportNull$$$0(15);
        }
    }

    public boolean isToSearchInComments(PsiElement element2) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element2) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public void setToSearchInComments(PsiElement element2, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    public void setToSearchForTextOccurrences(PsiElement element2, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allElementsToDelete";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/JavaScriptParameterSafeDeleteProcessor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/JavaScriptParameterSafeDeleteProcessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "destructuringParameterIfPossibleToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "destructuringParameterIfPossibleToDelete";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToSearch";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalElementsToDelete";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findConflicts";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prepareForDeletion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

