/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.rename;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class JSRenameWrongRefHandler
implements RenameHandler {
    @NonNls
    private static final String INPUT_VARIABLE_NAME = "INPUTVAR";
    @NonNls
    private static final String OTHER_VARIABLE_NAME = "OTHERVAR";

    public final boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JSRenameWrongRefHandler.$$$reportNull$$$0(0);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (editor == null || file == null || project == null) {
            return false;
        }
        return JSRenameWrongRefHandler.isAvailable(editor);
    }

    private static boolean isAvailable(Editor editor) {
        ResolveResult[] results;
        PsiReference reference = TargetElementUtil.findReference((Editor)editor);
        if (!(reference instanceof JSReferenceExpression)) {
            return false;
        }
        for (ResolveResult result2 : results = ((JSReferenceExpression)reference).multiResolve(true)) {
            if (!result2.isValidResult()) continue;
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, @Nullable DataContext dataContext) {
        PsiReference reference;
        JSReferenceExpression refExpr;
        if (project == null) {
            JSRenameWrongRefHandler.$$$reportNull$$$0(1);
        }
        if ((refExpr = JSPsiImplUtils.findReferenceOfClass(reference = TargetElementUtil.findReference((Editor)editor), JSReferenceExpression.class)) == null) {
            Logger.getInstance(JSRenameWrongRefHandler.class).error("JSReferenceExpression was not found");
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project).run(() -> {
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            PsiElement scope2 = PsiTreeUtil.getParentOfType((PsiElement)refExpr, (Class[])new Class[]{JSFunction.class, JSFile.class, JSEmbeddedContent.class});
            if (scope2 == null) {
                return;
            }
            ArrayList<JSNamedElement> declarations = new ArrayList<JSNamedElement>();
            JSReferenceExpression[] refs = JSRenameWrongRefHandler.collectSimilarReferencesAndDeclarations(refExpr, scope2, declarations);
            Expression expression = JSRenameWrongRefHandler.createExpression(refExpr.getReferenceName(), JSRenameWrongRefHandler.filterDeclarations(refExpr, declarations));
            TemplateBuilderImpl builder2 = new TemplateBuilderImpl(scope2);
            for (JSReferenceExpression expr : refs) {
                if (!expr.equals(refExpr)) {
                    builder2.replaceElement(expr.getReferenceNameElement(), OTHER_VARIABLE_NAME, INPUT_VARIABLE_NAME, false);
                    continue;
                }
                builder2.replaceElement(expr.getReferenceNameElement(), INPUT_VARIABLE_NAME, expression, true);
            }
            float proportion = EditorUtil.calcVerticalScrollProportion((Editor)editor);
            editor.getCaretModel().moveToOffset(scope2.getTextRange().getStartOffset());
            Template template = builder2.buildInlineTemplate();
            editor.getCaretModel().moveToOffset(scope2.getTextRange().getStartOffset());
            TemplateManager.getInstance((Project)project).startTemplate(editor, template);
            EditorUtil.setVerticalScrollProportion((Editor)editor, (float)proportion);
        });
    }

    @NotNull
    private static @Unmodifiable List<JSNamedElement> filterDeclarations(@NotNull JSReferenceExpression expr, @NotNull List<JSNamedElement> declarations) {
        PsiElement parent;
        if (expr == null) {
            JSRenameWrongRefHandler.$$$reportNull$$$0(2);
        }
        if (declarations == null) {
            JSRenameWrongRefHandler.$$$reportNull$$$0(3);
        }
        boolean isTypeContext = (parent = JSResolveUtil.getTopReferenceParent((PsiElement)expr)) instanceof JSReferenceListMember || parent instanceof TypeScriptSingleType;
        JSClass contextClass = parent instanceof JSReferenceListMember ? (JSClass)PsiTreeUtil.getParentOfType((PsiElement)parent, JSClass.class) : null;
        List list = ContainerUtil.filter(declarations, element2 -> {
            if (isTypeContext) {
                if (element2 instanceof JSClass && element2.getName() != null) {
                    boolean expectInterfaces;
                    boolean bl = expectInterfaces = contextClass != null && contextClass.isInterface();
                    if (contextClass != null && !expectInterfaces) {
                        JSReferenceList referenceList = (JSReferenceList)PsiTreeUtil.getParentOfType((PsiElement)parent, JSReferenceList.class);
                        assert (referenceList != null);
                        expectInterfaces = JSStubElementTypes.IMPLEMENTS_LIST.equals(referenceList.getNode().getElementType());
                    }
                    return contextClass == null || contextClass != element2 && expectInterfaces == ((JSClass)element2).isInterface();
                }
                return false;
            }
            return !(element2 instanceof JSClass);
        });
        if (list == null) {
            JSRenameWrongRefHandler.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            JSRenameWrongRefHandler.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            JSRenameWrongRefHandler.$$$reportNull$$$0(6);
        }
    }

    private static JSReferenceExpression[] collectSimilarReferencesAndDeclarations(final JSReferenceExpression ref2, PsiElement scope2, final List<JSNamedElement> declarations) {
        boolean isQualified;
        final String refName = ref2.getReferenceName();
        final ArrayList<JSReferenceExpression> similarRefs = new ArrayList<JSReferenceExpression>();
        similarRefs.add(ref2);
        boolean bl = isQualified = ref2.getQualifier() != null;
        if (refName != null) {
            JSRecursiveElementVisitor visitor = new JSRecursiveElementVisitor(){

                @Override
                public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (node == ref2 || !isQualified && node.getQualifier() == null && refName.equals(node.getReferenceName())) {
                        similarRefs.add(node);
                    }
                    if (node.getFirstChild() instanceof JSReferenceExpression) {
                        this.visitJSReferenceExpression((JSReferenceExpression)node.getFirstChild());
                    }
                }

                @Override
                public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    declarations.add(node);
                    PsiElement identifier = node.getNameIdentifier();
                    if (identifier instanceof JSReferenceExpression) {
                        this.visitJSReferenceExpression((JSReferenceExpression)identifier);
                    }
                }

                @Override
                public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    declarations.add(node);
                }

                @Override
                public void visitJSVariable(@NotNull JSVariable node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    declarations.add(node);
                    super.visitJSVariable(node);
                }

                @Override
                public void visitJSClass(@NotNull JSClass aClass) {
                    if (aClass == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    declarations.add(aClass);
                    super.visitJSClass(aClass);
                }

                @Override
                public void visitJSDefinitionExpression(@NotNull JSDefinitionExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    declarations.add(node);
                    super.visitJSDefinitionExpression(node);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "aClass";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/rename/JSRenameWrongRefHandler$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSReferenceExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSFunctionDeclaration";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSFunctionExpression";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSVariable";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSClass";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSDefinitionExpression";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            visitor.visitElement(scope2);
        }
        return similarRefs.toArray(new JSReferenceExpression[0]);
    }

    private static Expression createExpression(String oldRefName, List<JSNamedElement> declarations) {
        return new ConstantNode(oldRefName).withLookupStrings((Collection)ContainerUtil.mapNotNull(declarations, NavigationItem::getName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/rename/JSRenameWrongRefHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/rename/JSRenameWrongRefHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterDeclarations";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

