/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.index.JSInheritanceCallEvaluator;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitItem;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.structureView.JSNodeFactory;
import com.intellij.lang.javascript.structureView.JSStructureViewElementBase;
import com.intellij.lang.javascript.structureView.SimpleItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class JSStructureViewElement
extends JSStructureViewElementBase {
    private static final JSNodeFactory NODE_FACTORY = new JSNodeFactory(){

        @Override
        @NotNull
        public JSStructureViewElementBase create(@Nullable String name, @Nullable Icon icon, @NotNull PsiElement element2) {
            if (element2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return new JSStructureViewElement(element2, new SimpleItemPresentation(name, null, icon));
        }

        @Override
        @NotNull
        public JSStructureViewElementBase create(@Nullable String name, @Nullable Icon icon, @Nullable String description, @NotNull PsiElement element2) {
            if (element2 == null) {
                1.$$$reportNull$$$0(1);
            }
            return new JSStructureViewElement(element2, new SimpleItemPresentation(name, description, icon));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/structureView/JSStructureViewElement$1", "create"));
        }
    };
    @NotNull
    private final OwnAndAncestorSiblings myAndAncestorSiblings;
    private final boolean myEcma;

    public JSStructureViewElement(@NotNull PsiElement element2, boolean ecma) {
        if (element2 == null) {
            JSStructureViewElement.$$$reportNull$$$0(0);
        }
        super(element2, null, false);
        this.myAndAncestorSiblings = OwnAndAncestorSiblings.EMPTY;
        this.myEcma = ecma;
    }

    public JSStructureViewElement(@NotNull PsiElement element2, @Nullable ItemPresentation presentation) {
        if (element2 == null) {
            JSStructureViewElement.$$$reportNull$$$0(1);
        }
        super(element2, presentation, false);
        this.myAndAncestorSiblings = OwnAndAncestorSiblings.EMPTY;
        this.myEcma = false;
    }

    private JSStructureViewElement(@NotNull List<PsiElement> elements, @Nullable OwnAndAncestorSiblings myAndAncestorSiblings, boolean ecma) {
        if (elements == null) {
            JSStructureViewElement.$$$reportNull$$$0(2);
        }
        this(elements, myAndAncestorSiblings, null, ecma, false);
    }

    protected JSStructureViewElement(@NotNull List<PsiElement> elements, @Nullable OwnAndAncestorSiblings myAndAncestorSiblings, @Nullable ItemPresentation presentation, boolean ecma, boolean inherited) {
        if (elements == null) {
            JSStructureViewElement.$$$reportNull$$$0(3);
        }
        super(elements, presentation, inherited);
        this.myAndAncestorSiblings = myAndAncestorSiblings != null ? myAndAncestorSiblings : OwnAndAncestorSiblings.EMPTY;
        this.myEcma = ecma;
    }

    @Override
    @NotNull
    protected JSStructureViewElementBase copyWithInheritedImpl() {
        return new JSStructureViewElement(this.getAllElements(), this.myAndAncestorSiblings, this.getPresentation(), this.myEcma, true);
    }

    @Override
    protected JSNodeFactory getNodeFactory() {
        return NODE_FACTORY;
    }

    @Override
    @NotNull
    public List<StructureViewTreeElement> getOwnChildren() {
        PsiElement element2 = this.getValue();
        if (!element2.isValid()) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                JSStructureViewElement.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (this.myNodeProvider != null) {
            List<StructureViewTreeElement> list = this.myNodeProvider.getNodes(element2, NODE_FACTORY);
            if (list == null) {
                JSStructureViewElement.$$$reportNull$$$0(5);
            }
            return list;
        }
        JSQualifiedName ns = JSStructureViewElement.getProvidedNamespaceByElement(element2);
        List<StructureViewTreeElement> list = this.collectMyElements(new HashSet<String>(), ns, element2.getContainingFile());
        if (list == null) {
            JSStructureViewElement.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public List<StructureViewTreeElement> getInherited() {
        PsiElement element2 = this.getValue();
        if (!element2.isValid()) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                JSStructureViewElement.$$$reportNull$$$0(7);
            }
            return list;
        }
        PsiFile file = element2.getContainingFile();
        if (file instanceof JSFile && ((JSFile)file).isMinified()) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                JSStructureViewElement.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<StructureViewTreeElement> elementsFromSupers = null;
        HashSet<String> childrenNames = new HashSet<String>();
        JSNamespace providedNs = element2 instanceof JSElementBase ? JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)element2, true, null) : null;
        JSQualifiedName namespace = providedNs != null ? providedNs.getQualifiedName() : null;
        this.collectMyElements(childrenNames, namespace, element2.getContainingFile());
        if (element2 instanceof JSClass) {
            OwnAndAncestorSiblings childAndAncestorSiblings = new OwnAndAncestorSiblings(childrenNames, this.myAndAncestorSiblings);
            elementsFromSupers = this.getInheritedForClass((JSClass)element2, (Function<? super PsiElement, ? extends JSStructureViewElementBase>)((Function)superClass -> this.createStructureViewElement((PsiElement)superClass, childAndAncestorSiblings)));
        } else if (!this.myEcma) {
            JSQualifiedName parent;
            JSQualifiedName jSQualifiedName = parent = namespace != null ? namespace.getParent() : null;
            if (parent != null && "Object".equals(parent.getQualifiedName())) {
                providedNs = null;
            }
            if (element2 instanceof JSPsiElementBase && !JSSymbolUtil.isConstructorSymbol((JSPsiElementBase)element2) && (!(element2 instanceof JSFunction) || element2 instanceof JSFunctionExpression) && (!(element2 instanceof JSVariable) || !JSSymbolUtil.isMeaningfulLocalVariableInitializer(((JSVariable)element2).getInitializerOrStub()) || ((JSVariable)element2).isLocal()) || !(element2 instanceof JSNamedElement) && (namespace == null || !JSSymbolUtil.isConstructorName(namespace.getQualifiedName())) || element2 instanceof JSProperty || element2 instanceof JSImplicitElement && !JSStructureViewElement.isClass((JSImplicitElement)element2)) {
                providedNs = null;
            }
            if (providedNs != null && providedNs.getQualifiedName() != null) {
                providedNs = JSNamedTypeFactory.copyWithJSContext(providedNs, JSContext.INSTANCE);
                GlobalSearchScope scope2 = JSResolveUtil.getResolveScope((PsiElement)file);
                elementsFromSupers = this.getInheritedElements(element2, providedNs, scope2, childrenNames);
            }
        }
        List<StructureViewTreeElement> list = elementsFromSupers != null ? elementsFromSupers : Collections.emptyList();
        if (list == null) {
            JSStructureViewElement.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    private List<StructureViewTreeElement> getInheritedElements(@NotNull PsiElement element2, @NotNull JSNamespace providedNs, @NotNull GlobalSearchScope scope2, @NotNull Set<String> outReferencedNames) {
        if (element2 == null) {
            JSStructureViewElement.$$$reportNull$$$0(10);
        }
        if (providedNs == null) {
            JSStructureViewElement.$$$reportNull$$$0(11);
        }
        if (scope2 == null) {
            JSStructureViewElement.$$$reportNull$$$0(12);
        }
        if (outReferencedNames == null) {
            JSStructureViewElement.$$$reportNull$$$0(13);
        }
        HashSet visitedTypes = new HashSet();
        JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(element2, providedNs, true, true, true, (Processor<? super JSType>)((Processor)type2 -> {
            JSNamespace ns = JSTypeUtils.getNamespaceMatchingType(type2, false);
            if (ns != null) {
                visitedTypes.add(ns);
            }
            return true;
        }));
        MultiMap result2 = new MultiMap();
        for (JSNamespace type3 : visitedTypes) {
            JSQualifiedName name = type3.getQualifiedName();
            if (name == null) continue;
            this.addElementsFromNamespace((MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider>)result2, scope2, name.getQualifiedName());
        }
        OwnAndAncestorSiblings childAncestorAndSiblings = new OwnAndAncestorSiblings(outReferencedNames, this.myAndAncestorSiblings);
        List superElements = ContainerUtil.map(this.convertPsiToElements((MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider>)result2, childAncestorAndSiblings), el -> ((JSStructureViewElement)((Object)el)).copyWithInherited());
        return !superElements.isEmpty() ? superElements : null;
    }

    private static boolean isClass(JSImplicitItem element2) {
        JSImplicitElement.Type type2 = element2.getType();
        return type2 == JSImplicitElement.Type.Class || type2 == JSImplicitElement.Type.Interface;
    }

    @Nullable
    private static JSQualifiedName getProvidedNamespaceByElement(PsiElement element2) {
        JSNamespace jsNamespace;
        if (element2 instanceof JSElementBase && (jsNamespace = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)element2, true, null)) != null) {
            return jsNamespace.getQualifiedName();
        }
        return null;
    }

    protected JSStructureViewElementBase createStructureViewElement(PsiElement element2, @Nullable OwnAndAncestorSiblings ownAndAncestorSiblings) {
        return this.createStructureViewElement(Collections.singletonList(element2), ownAndAncestorSiblings);
    }

    private JSStructureViewElementBase createStructureViewElement(List<PsiElement> elements, @Nullable OwnAndAncestorSiblings ownAndAncestorSiblings) {
        return new JSStructureViewElement(elements, ownAndAncestorSiblings, this.myEcma);
    }

    protected List<StructureViewTreeElement> collectMyElements(@NotNull Set<String> outChildrenNames, JSQualifiedName ns, PsiFile contextFile) {
        if (outChildrenNames == null) {
            JSStructureViewElement.$$$reportNull$$$0(14);
        }
        return this.doCollectMyElements(outChildrenNames, ns, contextFile, this.getElement(), this.getAllElements(), false);
    }

    private List<StructureViewTreeElement> doCollectMyElements(@NotNull Set<String> outChildrenNames, JSQualifiedName ns, PsiFile contextFile, PsiElement mainElement, List<PsiElement> mainElements, boolean oneElementOnly) {
        boolean myElementIsFile;
        boolean shouldFindNsInDepth;
        if (outChildrenNames == null) {
            JSStructureViewElement.$$$reportNull$$$0(15);
        }
        boolean bl = shouldFindNsInDepth = (myElementIsFile = mainElement instanceof PsiFile) && mainElement.getLanguage() != FlexSupportLoader.ECMA_SCRIPT_L4 || mainElement instanceof JSImplicitElement;
        if (mainElement instanceof JSDefinitionExpression && "prototype".equals(((JSDefinitionExpression)mainElement).getName())) {
            return Collections.emptyList();
        }
        HashSet<PsiFile> visitedFiles = new HashSet<PsiFile>();
        visitedFiles.add(contextFile);
        MultiMap children = MultiMap.createLinked();
        Function childrenProvider = el -> JSStructureViewElement.gatherChildElements(el, visitedFiles);
        JSStructureViewElementBase.ChildElementProcessor childProcessor = (el, name) -> this.addChildElement(el, name, ns, mainElement, shouldFindNsInDepth, (MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider>)children);
        if (this.fillChildrenElement(mainElements, (MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider>)children, (Function<? super PsiElement, ? extends Collection<? extends PsiElement>>)childrenProvider, childProcessor, oneElementOnly)) {
            return this.convertPsiToElements((MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider>)children, this.myAndAncestorSiblings);
        }
        if (ns != null && !oneElementOnly) {
            this.addElementsFromNamespaceFromFile(ns, contextFile, (MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider>)children);
        }
        outChildrenNames.addAll(children.keySet());
        return this.convertPsiToElements((MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider>)children, new OwnAndAncestorSiblings(outChildrenNames, this.myAndAncestorSiblings));
    }

    private void addElementsFromNamespaceFromFile(@NotNull JSQualifiedName ns, @NotNull PsiFile contextFile, @NotNull MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider> children) {
        if (ns == null) {
            JSStructureViewElement.$$$reportNull$$$0(16);
        }
        if (contextFile == null) {
            JSStructureViewElement.$$$reportNull$$$0(17);
        }
        if (children == null) {
            JSStructureViewElement.$$$reportNull$$$0(18);
        }
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> this.addElementsFromNamespace(children, GlobalSearchScope.fileScope((PsiFile)contextFile), ns.getQualifiedName()));
    }

    private boolean addChildElement(JSStructureViewElementBase.PsiElementWithNodeProvider element2, String name, JSQualifiedName ns, PsiElement parentElement, boolean shouldFindNsInDepth, MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider> children) {
        PsiElement psiElement = element2.getElement();
        if (JSStructureViewElement.isElementInMyNamespace(psiElement, ns, parentElement, shouldFindNsInDepth)) {
            this.addElement(children, element2, name);
            return true;
        }
        if (psiElement instanceof JSPsiElementBase) {
            String childName;
            JSQualifiedName namespace = ((JSPsiElementBase)psiElement).getJSNamespace().getQualifiedName();
            JSQualifiedName childNs = JSStructureViewElement.findFirstLevelChildNs(ns, namespace);
            childNs = childNs == null && JSStructureViewElement.shouldAddNamespaceFromDefinition(psiElement, namespace, this.myAndAncestorSiblings) ? namespace : childNs;
            String string = childName = childNs != null ? childNs.getName() : null;
            if (childNs != null && this.myAndAncestorSiblings.contains(name) && Comparing.equal((Object)childNs, (Object)namespace)) {
                return true;
            }
            if (childNs != null && !childName.equals("Window")) {
                JSStructureImplicitNamespace implicitNamespace = new JSStructureImplicitNamespace(childNs, (JSPsiElementBase)psiElement);
                children.putValue((Object)childName, (Object)new JSStructureViewElementBase.PsiElementWithNodeProvider((PsiElement)implicitNamespace));
                return true;
            }
        }
        return false;
    }

    private static boolean shouldAddNamespaceFromDefinition(PsiElement element2, JSQualifiedName namespace, OwnAndAncestorSiblings ownAndAncestorSiblings) {
        return namespace != null && element2 instanceof JSDefinitionExpression && ((JSDefinitionExpression)element2).getInitializerOrStub() instanceof JSFunctionItem && !ownAndAncestorSiblings.contains(namespace.getName());
    }

    private void addElementsFromNamespace(MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider> children, GlobalSearchScope scope2, String namespace) {
        boolean isObject = "Object".equals(namespace);
        for (JSPsiElementBase namedElement : JSClassResolver.getInstance().findNamespaceMembersIncludingLocal(namespace, scope2)) {
            String name;
            if (isObject && namedElement.getJSContext() == JSContext.STATIC || (name = this.getName((PsiElement)namedElement, children.size())) == null) continue;
            this.addElement(children, new JSStructureViewElementBase.PsiElementWithNodeProvider((PsiElement)namedElement), name);
        }
    }

    @Override
    protected String getName(@NotNull PsiElement element2, int count) {
        if (element2 == null) {
            JSStructureViewElement.$$$reportNull$$$0(19);
        }
        if (element2 instanceof JSPackageStatement) {
            return null;
        }
        if (element2 instanceof JSDefinitionExpression) {
            PsiFile file;
            JSFunction function;
            JSClass clazz;
            JSDefinitionExpression definition = (JSDefinitionExpression)element2;
            if ("prototype".equals(definition.getName()) && definition.getJSContext() != JSContext.INSTANCE) {
                return null;
            }
            if (this.myEcma && (clazz = (JSClass)PsiTreeUtil.getContextOfType((PsiElement)(function = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)definition, (Class[])new Class[]{JSFunction.class})), (Class[])new Class[]{JSClass.class})) != null) {
                return null;
            }
            if ("exports".equals(definition.getName()) && (file = definition.getContainingFile()) instanceof JSFile && ((JSFile)file).isCommonJSModule()) {
                return null;
            }
            if (definition.getJSNamespace().getQualifiedName() == null && !(definition.getInitializerOrStub() instanceof JSFunctionItem) && !this.hasStructureElements(element2)) {
                return null;
            }
        }
        return super.getName(element2, count);
    }

    @Override
    protected boolean hasStructureElements(PsiElement element2) {
        List<StructureViewTreeElement> elements = this.doCollectMyElements(new HashSet<String>(), JSStructureViewElement.getProvidedNamespaceByElement(element2), element2.getContainingFile(), element2, Collections.singletonList(element2), true);
        return !elements.isEmpty();
    }

    private static Collection<? extends PsiElement> gatherChildElements(PsiElement element2, Set<PsiFile> visitedFiles) {
        JSExpression value;
        if (element2 instanceof JSStructureImplicitNamespace) {
            return Collections.singleton(element2.getParent());
        }
        if (element2 instanceof JSAssignmentExpression) {
            JSAssignmentExpression value2 = (JSAssignmentExpression)element2;
            SmartList result2 = new SmartList();
            while (value2 instanceof JSStubElementImpl) {
                JSDefinitionExpression definition = ((JSStubElementImpl)((Object)value2)).getStubOrPsiChild(JSStubElementTypes.DEFINITION_EXPRESSION);
                ContainerUtil.addIfNotNull((Collection)result2, (Object)definition);
                value2 = ((JSStubElementImpl)((Object)value2)).getStubOrPsiChild(JSStubElementTypes.ASSIGNMENT_EXPRESSION);
            }
            return result2;
        }
        if (element2 instanceof JSDefinitionExpression && (value = ((JSDefinitionExpression)element2).getInitializerOrStub()) != null) {
            return Collections.singleton(value);
        }
        if (element2 instanceof JSIncludeDirective) {
            PsiFile file = ((JSIncludeDirective)element2).resolveFile();
            element2 = file != null && !visitedFiles.contains(file) ? file : element2;
            visitedFiles.add(file);
        }
        return JSStructureViewElement.getPsiOrStubChildren(element2);
    }

    @NotNull
    private List<StructureViewTreeElement> convertPsiToElements(MultiMap<String, JSStructureViewElementBase.PsiElementWithNodeProvider> children, final OwnAndAncestorSiblings ownAndAncestorSiblings) {
        List list = JBIterable.from((Iterable)children.entrySet()).flatMap((Function)new Function<Map.Entry<String, Collection<JSStructureViewElementBase.PsiElementWithNodeProvider>>, List<StructureViewTreeElement>>(){

            public List<StructureViewTreeElement> fun(Map.Entry<String, Collection<JSStructureViewElementBase.PsiElementWithNodeProvider>> entry) {
                Collection<JSStructureViewElementBase.PsiElementWithNodeProvider> value = entry.getValue();
                ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>(3);
                boolean hasProvider = false;
                for (JSStructureViewElementBase.PsiElementWithNodeProvider elementWithNodeProvider : value) {
                    hasProvider = JSStructureViewElement.this.collectExtensionElements(elementWithNodeProvider, result2);
                }
                if (!result2.isEmpty() || hasProvider) {
                    return result2;
                }
                List elements = ContainerUtil.map(value, val -> val.getElement());
                if (value.size() <= 1) {
                    return Collections.singletonList(this.sortAndCreate(elements));
                }
                SmartList staticElements = new SmartList();
                SmartList exportSpecifiers = new SmartList();
                SmartList otherElements = new SmartList();
                boolean hasInstanceMember = false;
                for (PsiElement element2 : elements) {
                    if (element2 instanceof ES6ExportSpecifier) {
                        exportSpecifiers.add((Object)element2);
                        continue;
                    }
                    if (element2 instanceof JSPsiElementBase) {
                        JSContext context2 = ((JSPsiElementBase)element2).getJSContext();
                        if (context2 == JSContext.STATIC) {
                            staticElements.add((Object)element2);
                            continue;
                        }
                        if (context2 == JSContext.INSTANCE) {
                            hasInstanceMember = true;
                        }
                    }
                    otherElements.add((Object)element2);
                }
                if (!staticElements.isEmpty() && hasInstanceMember) {
                    result2.add(this.sortAndCreate((List<? extends PsiElement>)staticElements));
                } else {
                    otherElements.addAll((Collection)staticElements);
                }
                if (!otherElements.isEmpty()) {
                    result2.add(this.sortAndCreate((List<? extends PsiElement>)otherElements));
                }
                if (!exportSpecifiers.isEmpty()) {
                    result2.add(this.sortAndCreate((List<? extends PsiElement>)exportSpecifiers));
                }
                return result2;
            }

            private StructureViewTreeElement sortAndCreate(@Unmodifiable List<? extends PsiElement> value) {
                return JSStructureViewElement.this.createStructureViewElement(JSStructureViewElement.this.sortChildrenByImplicitElements(value), ownAndAncestorSiblings);
            }
        }).toList();
        if (list == null) {
            JSStructureViewElement.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static boolean isElementInMyNamespace(PsiElement element2, JSQualifiedName myNs, PsiElement parentElement, boolean shouldFindNsInDepth) {
        JSInheritanceCallEvaluator.JSInheritanceCallResult inheritance;
        JSExpression initializer;
        if (!(element2 instanceof JSElementBase)) {
            return true;
        }
        JSQualifiedName namespace = ((JSElementBase)element2).getJSNamespace().getQualifiedName();
        if (namespace == null) {
            return true;
        }
        if (namespace.equals(myNs)) {
            return true;
        }
        String name = namespace.getName();
        if (parentElement instanceof PsiFile) {
            if (Comparing.equal((Object)namespace.getParent(), (Object)myNs) && "Window".equals(name)) {
                return true;
            }
            if (!shouldFindNsInDepth && element2 instanceof JSClass && JSStructureViewElement.findFirstLevelChildNs(myNs, namespace) != null) {
                return true;
            }
        } else if (!StringUtil.isEmpty((String)name) && myNs != null && name.equals(myNs.getName()) && Comparing.equal((Object)JSStructureViewElement.getParentSkippingWindow(namespace), (Object)JSStructureViewElement.getParentSkippingWindow(myNs))) {
            return true;
        }
        return parentElement instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)parentElement).getInitializer()) instanceof JSCallExpression && (inheritance = JSInheritanceCallEvaluator.findInheritance((JSCallExpression)initializer)) != null && inheritance.destination != initializer && inheritance.isCallExpressionMatchesDestination;
    }

    private static JSQualifiedName getParentSkippingWindow(@Nullable JSQualifiedName namespace) {
        JSQualifiedName parent;
        JSQualifiedName jSQualifiedName = parent = namespace != null ? namespace.getParent() : null;
        if (parent != null && "Window".equals(parent.getName())) {
            return parent.getParent();
        }
        return parent;
    }

    private static JSQualifiedName findFirstLevelChildNs(JSQualifiedName parent, JSQualifiedName namespace) {
        while (namespace != null) {
            JSQualifiedName parentNs = namespace.getParent();
            if (Comparing.equal((Object)parentNs, (Object)parent)) {
                return namespace;
            }
            namespace = parentNs;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JSStructureViewElement element2 = (JSStructureViewElement)((Object)o);
        return this.myEcma == element2.myEcma && this.myAndAncestorSiblings.equals(element2.myAndAncestorSiblings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myAndAncestorSiblings, this.myEcma);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/structureView/JSStructureViewElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providedNs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outReferencedNames";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChildrenNames";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/structureView/JSStructureViewElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnChildren";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInherited";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPsiToElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 20: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInheritedElements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectMyElements";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doCollectMyElements";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addElementsFromNamespaceFromFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 20 -> new IllegalStateException(string);
        };
    }

    protected static class OwnAndAncestorSiblings {
        private static final OwnAndAncestorSiblings EMPTY = new OwnAndAncestorSiblings(Collections.emptySet(), null);
        @NotNull
        private final Set<String> mySiblings;
        @Nullable
        private final OwnAndAncestorSiblings myAncestorSiblings;

        private OwnAndAncestorSiblings(@NotNull Set<String> siblings, @Nullable OwnAndAncestorSiblings ancestorSiblings) {
            if (siblings == null) {
                OwnAndAncestorSiblings.$$$reportNull$$$0(0);
            }
            this.mySiblings = siblings;
            this.myAncestorSiblings = ancestorSiblings;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OwnAndAncestorSiblings siblings = (OwnAndAncestorSiblings)o;
            return this.mySiblings.equals(siblings.mySiblings) && Objects.equals(this.myAncestorSiblings, siblings.myAncestorSiblings);
        }

        public int hashCode() {
            return Objects.hash(this.mySiblings, this.myAncestorSiblings);
        }

        public boolean contains(String name) {
            return this.mySiblings.contains(name) || this.myAncestorSiblings != null && this.myAncestorSiblings.contains(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "siblings", "com/intellij/lang/javascript/structureView/JSStructureViewElement$OwnAndAncestorSiblings", "<init>"));
        }
    }

    private static final class JSStructureImplicitNamespace
    extends JSImplicitElementImpl {
        private JSStructureImplicitNamespace(JSQualifiedName parent, JSPsiElementBase element2) {
            super(new JSImplicitElementImpl.Builder(parent, (PsiElement)element2).setType(JSStructureImplicitNamespace.isClassMemberDefinition((PsiElement)element2) ? JSImplicitElement.Type.Class : JSImplicitElement.Type.Namespace));
        }

        private static boolean isClassMemberDefinition(PsiElement element2) {
            return element2 instanceof JSDefinitionExpression && ((JSDefinitionExpression)element2).getJSContext() == JSContext.INSTANCE;
        }
    }
}

