/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceResponseParser;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerFunctionDisplay;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerPropertyDisplay;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerSymbolDisplay;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptSymbolDisplayPart;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a7\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u001d\u0010\u000e\u001a\u00020\r2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010\u0010\u001a/\u0010\u0011\u001a\u00020\u00122\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u00122\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017\u001a\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010\u0019\u001a#\u0010\u001a\u001a\u00020\u00122\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u001b\u001a\u001b\u0010\u001c\u001a\u00020\u00122\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\u001d\u001a\u001e\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\u0006H\u0002\u001a\u0010\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0006H\u0002\u001a\u0010\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0006H\u0002\u001a@\u0010&\u001a\u00020\u00032\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052!\u0010'\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00030(H\u0001\u00a2\u0006\u0002\u0010+\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"parseDisplayParts", "Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerSymbolDisplay;", "kind", "", "displayParts", "", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;", "sourceDisplay", "(Ljava/lang/String;[Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;[Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;)Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerSymbolDisplay;", "functionKinds", "", "defaultParameters", "defaultParametersAndReturn", "Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerFunctionDisplay;", "getParametersAndReturn", "parts", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;)Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerFunctionDisplay;", "parseFunctionParameters", "", "startIndex", "signature", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;ILjava/lang/StringBuilder;)I", "getPropertyType", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;)Ljava/lang/String;", "skipWhitespaces", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;I)I", "skipDescriptionBraces", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;)I", "fillBraces", "", "braces", "Ljava/util/Deque;", "", "part", "isOpenBrace", "isCloseBrace", "joinParts", "mapper", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;Lkotlin/jvm/functions/Function1;)Ljava/lang/String;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptServerServiceCompletionEntryParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptServerServiceCompletionEntryParser.kt\ncom/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceCompletionEntryParserKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,139:1\n1#2:140\n209#3,8:141\n*S KotlinDebug\n*F\n+ 1 TypeScriptServerServiceCompletionEntryParser.kt\ncom/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceCompletionEntryParserKt\n*L\n92#1:141,8\n*E\n"})
public final class TypeScriptServerServiceCompletionEntryParserKt {
    @NotNull
    private static final Set<String> functionKinds;
    @NotNull
    private static final String defaultParameters = "(...)";
    @NotNull
    private static final TypeScriptServerFunctionDisplay defaultParametersAndReturn;

    @NotNull
    public static final TypeScriptServerSymbolDisplay parseDisplayParts(@Nullable String kind, @Nullable TypeScriptSymbolDisplayPart[] displayParts, @Nullable TypeScriptSymbolDisplayPart[] sourceDisplay) {
        return (sourceDisplay != null ? !(sourceDisplay.length == 0) : false) ? (TypeScriptServerSymbolDisplay)new TypeScriptServerPropertyDisplay(TypeScriptServerServiceCompletionEntryParserKt.joinParts(sourceDisplay, (Function1<? super String, String>)((Function1)TypeScriptServerServiceCompletionEntryParserKt::parseDisplayParts$lambda$0))) : (CollectionsKt.contains((Iterable)functionKinds, (Object)kind) ? (TypeScriptServerSymbolDisplay)TypeScriptServerServiceCompletionEntryParserKt.getParametersAndReturn(displayParts) : (TypeScriptServerSymbolDisplay)new TypeScriptServerPropertyDisplay(TypeScriptServerServiceCompletionEntryParserKt.getPropertyType(displayParts)));
    }

    private static final TypeScriptServerFunctionDisplay getParametersAndReturn(TypeScriptSymbolDisplayPart[] parts) {
        TypeScriptSymbolDisplayPart[] typeScriptSymbolDisplayPartArray = parts;
        if (typeScriptSymbolDisplayPartArray == null || typeScriptSymbolDisplayPartArray.length == 0) {
            return defaultParametersAndReturn;
        }
        int indexToStart = TypeScriptServerServiceCompletionEntryParserKt.skipDescriptionBraces(parts);
        if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, indexToStart)) {
            return defaultParametersAndReturn;
        }
        int indexToStartReadParameter = TypeScriptLanguageServiceResponseParser.waitSymbolWithoutBrace(parts, indexToStart, '(');
        if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, indexToStartReadParameter)) {
            return defaultParametersAndReturn;
        }
        int index = 0;
        index = TypeScriptServerServiceCompletionEntryParserKt.skipWhitespaces(parts, indexToStartReadParameter);
        if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, index)) {
            return defaultParametersAndReturn;
        }
        StringBuilder sb = new StringBuilder();
        boolean bl = false;
        index = TypeScriptServerServiceCompletionEntryParserKt.parseFunctionParameters(parts, index, sb);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"let(...)");
        String signature = string;
        if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, index)) {
            return new TypeScriptServerFunctionDisplay(signature, null);
        }
        index = TypeScriptLanguageServiceResponseParser.waitSymbolWithoutBrace(parts, indexToStart, ':');
        return TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, index) ? new TypeScriptServerFunctionDisplay(signature, null) : new TypeScriptServerFunctionDisplay(signature, TypeScriptLanguageServiceResponseParser.readRestText(parts, index));
    }

    private static final int parseFunctionParameters(TypeScriptSymbolDisplayPart[] parts, int startIndex, StringBuilder signature) {
        Deque openedBraces = new ArrayDeque();
        openedBraces.add(true);
        signature.append("(");
        int n = parts.length;
        for (int i = startIndex; i < n; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            if (TypeScriptServerServiceCompletionEntryParserKt.isOpenBrace(part)) {
                openedBraces.add(true);
            } else if (TypeScriptServerServiceCompletionEntryParserKt.isCloseBrace(part)) {
                openedBraces.pop();
                if (openedBraces.isEmpty()) {
                    signature.append(")");
                    return i + 1;
                }
            }
            TypeScriptLanguageServiceResponseParser.appendText(signature, part);
        }
        signature.append(")");
        return -1;
    }

    private static final String getPropertyType(TypeScriptSymbolDisplayPart[] parts) {
        CharSequence charSequence;
        TypeScriptSymbolDisplayPart[] typeScriptSymbolDisplayPartArray = parts;
        if (typeScriptSymbolDisplayPartArray == null || typeScriptSymbolDisplayPartArray.length == 0) {
            return null;
        }
        int indexToStart = TypeScriptServerServiceCompletionEntryParserKt.skipDescriptionBraces(parts);
        if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, indexToStart)) {
            return null;
        }
        int cursor = TypeScriptServerServiceCompletionEntryParserKt.skipWhitespaces(parts, indexToStart);
        if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, cursor)) {
            return null;
        }
        cursor = TypeScriptLanguageServiceResponseParser.waitSymbolWithoutBrace(parts, indexToStart, ':');
        if (TypeScriptLanguageServiceResponseParser.isInvalidPlace(parts, cursor)) {
            return null;
        }
        String string = TypeScriptLanguageServiceResponseParser.readRestText(parts, cursor);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readRestText(...)");
        String typeText = string;
        CharSequence charSequence2 = typeText;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private static final int skipWhitespaces(TypeScriptSymbolDisplayPart[] parts, int startIndex) {
        int n;
        block3: {
            Sequence $this$indexOfFirst$iv = SequencesKt.drop((Sequence)ArraysKt.asSequence((Object[])parts), (int)startIndex);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                TypeScriptSymbolDisplayPart it = (TypeScriptSymbolDisplayPart)item$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.kind, (Object)"space")) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n + startIndex;
    }

    private static final int skipDescriptionBraces(TypeScriptSymbolDisplayPart[] parts) {
        Deque braces = new ArrayDeque();
        boolean firstBraceAdded = false;
        int n = parts.length;
        for (int i = 0; i < n; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            if (firstBraceAdded) {
                TypeScriptServerServiceCompletionEntryParserKt.fillBraces(braces, part);
                if (!braces.isEmpty()) continue;
                return i + 1;
            }
            if (!TypeScriptServerServiceCompletionEntryParserKt.isOpenBrace(part)) continue;
            int nextToken = i + 1;
            if (nextToken < parts.length && Intrinsics.areEqual((Object)"parameterName", (Object)parts[nextToken].kind)) {
                return i;
            }
            braces.add(true);
            firstBraceAdded = true;
        }
        return -1;
    }

    private static final void fillBraces(Deque<Boolean> braces, TypeScriptSymbolDisplayPart part) {
        if (Intrinsics.areEqual((Object)part.kind, (Object)"punctuation")) {
            String string = part.text;
            if (Intrinsics.areEqual((Object)string, (Object)")")) {
                braces.pop();
            } else if (Intrinsics.areEqual((Object)string, (Object)"(")) {
                braces.add(true);
            }
        }
    }

    private static final boolean isOpenBrace(TypeScriptSymbolDisplayPart part) {
        return Intrinsics.areEqual((Object)"punctuation", (Object)part.kind) && Intrinsics.areEqual((Object)part.text, (Object)"(");
    }

    private static final boolean isCloseBrace(TypeScriptSymbolDisplayPart part) {
        return Intrinsics.areEqual((Object)"punctuation", (Object)part.kind) && Intrinsics.areEqual((Object)part.text, (Object)")");
    }

    @NlsSafe
    @NotNull
    public static final String joinParts(@Nullable TypeScriptSymbolDisplayPart[] parts, @NotNull Function1<? super String, String> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        Object object = parts;
        if (parts == null || (object = ArraysKt.joinToString$default((Object[])object, (CharSequence)"", null, null, (int)0, null, arg_0 -> TypeScriptServerServiceCompletionEntryParserKt.joinParts$lambda$4(mapper, arg_0), (int)30, null)) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
            object = "";
        }
        return object;
    }

    private static final String parseDisplayParts$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = StringUtil.escapeXmlEntities((String)it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(...)");
        return string;
    }

    private static final CharSequence joinParts$lambda$4(Function1 $mapper, TypeScriptSymbolDisplayPart it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.text;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        return (CharSequence)$mapper.invoke((Object)string);
    }

    static {
        Object[] objectArray = new String[]{"call", "method", "function", "local function"};
        functionKinds = SetsKt.setOf((Object[])objectArray);
        defaultParametersAndReturn = new TypeScriptServerFunctionDisplay(defaultParameters, null);
    }
}

