/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.lang.typescript.lsp.JSServiceLoader;
import com.intellij.lang.typescript.lsp.LspServerDownloadingKt;
import com.intellij.lang.typescript.lsp.PackageDownloadInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/typescript/lsp/LspDownloadService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "downloadInfoMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/lang/javascript/library/typings/TypeScriptPackageName;", "Lcom/intellij/lang/typescript/lsp/PackageDownloadInfo;", "scheduleDownload", "", "loader", "Lcom/intellij/lang/typescript/lsp/JSServiceLoader;", "dispose", "intellij.javascript.impl"})
public final class LspDownloadService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<TypeScriptPackageName, PackageDownloadInfo> downloadInfoMap;

    public LspDownloadService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.downloadInfoMap = new ConcurrentHashMap();
    }

    public final void scheduleDownload(@NotNull JSServiceLoader loader) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        if (!TrustedProjects.isProjectTrusted((Project)this.project)) {
            throw new IllegalStateException("Project is not trusted");
        }
        PackageDownloadInfo packageDownloadInfo = this.downloadInfoMap.computeIfAbsent(loader.getPackageDescriptor().getServerPackage(), arg_0 -> LspDownloadService.scheduleDownload$lambda$1(LspDownloadService::scheduleDownload$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)packageDownloadInfo, (String)"computeIfAbsent(...)");
        PackageDownloadInfo downloadInfo = packageDownloadInfo;
        if (downloadInfo.isDownloadPermitted()) {
            int attemptId = downloadInfo.getAttempts().get() + 1;
            LspServerDownloadingKt.access$getLog$p().info("[attempt #" + attemptId + "] Downloading LSP package " + loader.getPackageDescriptor().getServerPackage());
            LspServerDownloadingKt.access$scheduleDownloadingTask(this.project, loader, attemptId, () -> LspDownloadService.scheduleDownload$lambda$2(downloadInfo));
        }
    }

    public void dispose() {
    }

    private static final PackageDownloadInfo scheduleDownload$lambda$0(TypeScriptPackageName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new PackageDownloadInfo(null, null, null, 7, null);
    }

    private static final PackageDownloadInfo scheduleDownload$lambda$1(Function1 $tmp0, Object p0) {
        return (PackageDownloadInfo)$tmp0.invoke(p0);
    }

    private static final Unit scheduleDownload$lambda$2(PackageDownloadInfo $downloadInfo) {
        $downloadInfo.onDownloadFinished();
        return Unit.INSTANCE;
    }
}

